<?php 
class Messages extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		
		$this->load->helper('download');
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->messages();		
	}
	
	/*
	 * 
	 * name		: Messages
	 * @param   : Null
	 * @return  : List all the messages for admin
	 */	
	 	
	public function messages()
	{	
		$data['page_title'] 	= 	$this->lang->line('messages');	
		$data['breadcrumb'] 	= 	'';	
		
		/*$account_id				=	get_session('account_id');
		$network_id				=	get_session('network_account_id');
		$account_type			=	get_session('account_type');*/
		
		$data['inbox'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'inbox'),'php');
		$data['sent'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'sent'),'php');
		$data['trash'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'trash'),'php');
		
		$data['content'] 		= 	$this->load->view('messages/messages',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: Messages
	 * @param   : Null
	 * @return  : List all the messages for admin
	 */	
	
	public function fetch_message($type=FALSE)
	{	
		/*$account_id			=	get_session('account_id');
		$network_id			=	get_session('network_account_id');
		$account_type		=	get_session('account_type');*/
		
		$message 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>$type),'json');
		
		echo convert_to_datatable_format($message);
	}
	
	/*
	 * 
	 * name		: send_message
	 * @param   : Null
	 * @return  : Send new messages to advertiser/publisher
	 */	
	
	public function send_message()
	{		
		$data['to_id']	= $this->rest->get('api/v1/message/fetch_receiever_id',array('api_key'=>get_session('api_key')),'php');
	
		echo $this->load->view('messages/modal_messages/content/send_message',$data);		
	}
	
	/*
	 * 
	 * name		: read_message
	 * @param   : Null
	 * @return  : read messages
	 */	
	
	public function read_message($type=FALSE,$msg_id=FALSE)
	{	
		$message 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>$type,'message_id'=>$msg_id),'php');
		
		$data['read']		=	$message[0];
		
		if($type=='inbox')
		{
			$this->rest->get('api/v1/message/update_message_status',array('api_key'=>get_session('api_key'),'message_id'=>$msg_id),'php');
			
			echo $this->load->view('messages/modal_messages/content/read_reply_message',$data);		
		}
		else
		{
			echo $this->load->view('messages/modal_messages/content/read_message',$data);		
		}
	}
	
	/*
	 * 
	 * name		: fetch_message_count
	 * @param   : Null
	 * @return  : count messages
	 */	
	
	public function fetch_message_count($type=FALSE)
	{	
		/*$account_id			=	get_session('account_id');
		$network_id			=	get_session('network_account_id');
		$account_type		=	get_session('account_type');*/
		
		$message 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>$type),'php');
		
		if($type=='inbox')
		{
			$inbox_count		=	0;
			if(!empty($message)):
				foreach($message as $msg):
					if($msg['status']==1)
					{
						$inbox_count	+=	1;
					}
				endforeach;
			endif;
			
			echo $inbox_count;
		}
		elseif($type=='sent')
		{	
			echo (!empty($message))?count($message):'0';		
		}
		else
		{
			echo '0';		
		}
	}
	
	/*
	 * 
	 * name		: download_file
	 * @param   : Null
	 * @return  : download image/file
	 */	
	
	public function download_file($file_name=0)
	{	
		$data 	= 	file_get_contents($this->config->item('message_path').'/'.$file_name); // Read the file's contents
		$name 	=	$file_name;
		force_download($name, $data); 
	}
	
}
