<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Do_zone_link extends CI_Model
{
	
	
	public $agency_id='';

	/*
	 * 
	 * name: fetch_adblock
	 * @param :
	 * @return : $result
	 * 
	 * Lists a ad blocks
	 */
	 
	 function fetch_adblock($zone_id=false)
	 {
		if($zone_id)
		{
			$this->db->select('width,height,delivery,dj_zone_type,affiliateid');		
			$this->db->where('zoneid ',$zone_id);
			$this->db->where('dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES);	
			$result = $query->result_array();
			
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get Creatives
	 */
	 
	 function fetch_creative($creative_id=false)
	 {
		if($creative_id)
		{
			$this->db->select('oxb.width,oxb.height,oxb.dj_banner_type,oxcamp.bidding_type,oxcamp.affiliate_id,oxcl.dj_is_default,oxcamp.dj_targetting_type');	
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');	
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxb.bannerid ',$creative_id);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.'as oxb');	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name:link_ads_get
	 * @param : zone_id 
	 * @return : NULL
	 * 
	 * Link zone to creative
*/
	
	function link_ads($zone_id=false,$housead=FALSE,$dsp_id=FALSE)
	{
		
		if($zone_id)
		{
			
			//Sets the agency_id
			//$this->agency_id = $agencyid;
			
			// Unlink the previously linked creatives for zone
			$this->unlink_ads($zone_id);
		
			$zone_details = $this->fetch_adblock($zone_id);
			$zone = $zone_details[0];
			
			$zone_type = $zone['dj_zone_type'];
			

			$affiliateid = $zone['affiliateid'];
			
			
		
			switch($zone_type)
			{
				case WEB_AD_BLOCK_BANNER:
				
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								/*$where_web	=array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF);*/	
								$creatives = $this->fetch_web_creatives($where_web,$housead,$dsp_id);
								
		
							if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);					

                                     
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   
									}
								}
								break;
				case WEB_AD_BLOCK_TEXT:
				            
								$creatives = $this->fetch_text_creatives($housead,$dsp_id);
								
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										
							
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									 
											
									}
								}
								break;
				case WEB_AD_BLOCK_DHTML:
				 
								$where_dhtml = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_dhtml_creatives($where_dhtml,$housead);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										
					
								
                                     
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									   
									}
								}
								break;									
												
				case VIDEO_AD_BLOCK_OVERLAY:
				 
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								//$creatives = $this->fetch_overlay_creatives($where_overlay,$housead,$dsp_id);
								$creatives = $this->fetch_inline_creatives($where_overlay,$housead,$dsp_id);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
									
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									   
									}
								}
								break;
								
	             // html 5 video ads
	             
	             	case VIDEO_AD_BLOCK_HTML:
	             	 
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_html5_creatives($where_overlay,$housead);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);	
										
										
                                      if(in_array($affiliateid,$affiliate_id) || $c['affiliate_id']=="all" || $c['dj_is_default']==1 || $c['affiliate_id'] == '0')
                                       {
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									   }
									}
								}
								break;	
								
	             // In-Banner video ads
	             
	             	case VIDEO_AD_BLOCK_INBANNER:
	             	 
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_inbanner_creatives($where_overlay,$housead);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									}
								}
								break;										
										
	             	
				case VIDEO_AD_BLOCK_INLINE:
				
				 
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_inline_creatives($where_inline,$housead,$dsp_id);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									   
									}
								}
								break;
								
								
								
								case MOBILE_AD_BLOCK_IMAGE:



								$creatives = $this->fetch_image_creatives($house_ad,$dsp_id);

								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									   
											
									}
								}

								break;
						case MOBILE_AD_BLOCK_TEXT:

							$creatives = $this->fetch_mob_text_creatives($housead,$dsp_id);
								
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									   
											
									}
								}
								break;			

				case C_A_IM:
				 
								//$where_web = array(
												//"oxb.width" => $zone['width'],
												//"oxb.height" => $zone['height']
											//);
								//print_r($where_web);exit('-------8');
								/*$where_web	=array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF);*/	
								$creatives = $this->fetch_cross_creatives(NULL,NULL,$dsp_id);


								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   
									}
								}
								break;								
				case C_A_TXT:
				

									
								$creatives = $this->fetch_cross_text_creatives($housead,$dsp_id);
								
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   
									}
								}
								break;								
				case MOBILE_AD_BLOCK_INTERSTITIAL:
				 
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								//print_r($where_web);exit('------10');
								/*$where_web	=array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF);*/	
								$creatives = $this->fetch_interstitial_creatives($where_web,$housead);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);	
										
										
                                     if(in_array($affiliateid,$affiliate_id) || $c['affiliate_id']=="all" || $c['dj_is_default']==1 || $c['affiliate_id'] == '0')
                                       {
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   }
									}
								}
								break;								
				case MOBILE_AD_BLOCK_EXPAND:
				 
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								//print_r($where_web);exit('------10');									
								$creatives = $this->fetch_expand_creatives($where_web,$housead);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);	
										
										
                                      if(in_array($affiliateid,$affiliate_id) || $c['affiliate_id']=="all" || $c['dj_is_default']==1 || $c['affiliate_id'] == '0')
                                       {
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   }
									}
								}
								break;								
				case MOBILE_AD_BLOCK_REVEAL:
				 
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								//print_r($where_web);exit('------10');									
								$creatives = $this->fetch_reveal_creatives($where_web,$housead);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);	
										
										
                                      if(in_array($affiliateid,$affiliate_id) || $c['affiliate_id']=="all" || $c['dj_is_default']==1 || $c['affiliate_id'] == '0')
                                       {
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   }
									}
								}
								break;								
				case MOBILE_AD_BLOCK_FLEX:
				 
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								//print_r($where_web);exit('------10');									
								$creatives = $this->fetch_flex_creatives($where_web,$housead);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);	
										
										
                                      if(in_array($affiliateid,$affiliate_id) || $c['affiliate_id']=="all" || $c['dj_is_default']==1 || $c['affiliate_id'] == '0')
                                       {
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   }
									}
								}
								break;								
				case MOBILE_AD_BLOCK_ADHENSION:
				 
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								//print_r($where_web);exit('------10');									
								$creatives = $this->fetch_adhension_creatives($where_web,$housead);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);	
										
										
                                      if(in_array($affiliateid,$affiliate_id) || $c['affiliate_id']=="all" || $c['dj_is_default']==1 || $c['affiliate_id'] == '0')
                                       {
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   }
									}
								}
								break;								
				case MOBILE_AD_BLOCK_FLIMSTRIP:
				 
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								//print_r($where_web);exit('------10');									
								$creatives = $this->fetch_filmstrip_creatives($housead);
								//print_r($creatives);exit('------10');		
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);								
										
                                      if(in_array($affiliateid,$affiliate_id) || $c['affiliate_id']=="all" || $c['dj_is_default']==1 || $c['affiliate_id'] == '0')
                                       {
										   	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   }
									  
									}
								}
								break;								
				case MOBILE_AD_BLOCK_SLIDER:
				 
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								//print_r($where_web);exit('------10');									
								$creatives = $this->fetch_slider_creatives($where_web,$housead);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);								
										
                                      if(in_array($affiliateid,$affiliate_id) || $c['affiliate_id']=="all" || $c['dj_is_default']==1 || $c['affiliate_id'] == '0')
                                       {
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   }
									}
								}
								break;								
				case MOBILE_AD_BLOCK_PULL:
				 
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								//print_r($where_web);exit('------10');									
								$creatives = $this->fetch_pull_creatives($where_web,$housead);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);								
										
                                     if(in_array($affiliateid,$affiliate_id) || $c['affiliate_id']=="all" || $c['dj_is_default']==1 || $c['affiliate_id'] == '0')
                                       {
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   }
									}
								}
								break;	
								case MOBILE_AD_BLOCK_INLINE:
				 
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								//print_r($where_web);exit('------10');	
								$creatives = $this->fetch_inline_creatives($where_web,$housead,$dsp_id);	
								
								//$creatives = $this->fetch_mob_inline_creatives($where_web,$housead,$dsp_id);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);								
										
                                     //~ if(in_array($affiliateid,$affiliate_id) || $c['affiliate_id']=="all" || $c['dj_is_default']==1 || $c['affiliate_id'] == '0' || $c['affiliate_id'] == 'null')
                                       //~ {
										  		
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   //}
								   
									}
								}
								break;		
								case MOBILE_AD_BLOCK_OVERLAY:
				 
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								//print_r($where_web);exit('------10');	
								$creatives = $this->fetch_inline_creatives($where_web,$housead,$dsp_id);							
								//$creatives = $this->fetch_mob_overlay_creatives($where_web,$housead,$dsp_id);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);								
										
                                     //~ if(in_array($affiliateid,$affiliate_id) || $c['affiliate_id']=="all" || $c['dj_is_default']==1 || $c['affiliate_id'] == '0')
                                       //~ {
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   //}
									}
								}
								break;
								
						case MOBILE_AD_BLOCK_NATIVE_VIDEO:
				 
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								//print_r($where_web);exit('------10');	
								$creatives = $this->fetch_native_video_creatives($where_web,$housead,$dsp_id);							
								//$creatives = $this->fetch_mob_overlay_creatives($where_web,$housead,$dsp_id);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$affiliate_id=explode(',',$c['affiliate_id']);								
										
                                     //~ if(in_array($affiliateid,$affiliate_id) || $c['affiliate_id']=="all" || $c['dj_is_default']==1 || $c['affiliate_id'] == '0')
                                       //~ {
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									   //}
									}
								}
								break;	
									
								
																
				
			}
			
		}
	}
		 
	
	/**************************************************************************************
	 * 									Match AD CREATIVE
	 * ************************************************************************************/
	 
	/*
	 * 
	 * name: fetch_match_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a matched creative with adblock
	 */
	function fetch_match_creatives($where=false,$housead=FALSE)
	{
		if($where)
		{
			$this->db->select('oxb.bannerid,oxcamp.affiliate_id,oxcl.dj_is_default');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			
					
			$this->db->where_in('oxb.storagetype', $where['storagetype']);
			$this->db->where_in('oxb.dj_banner_type', $where['bannertype']);
			$this->db->where('oxb.dj_is_deleted ','0');
			
			 if($housead==1)
			{
				
				$this->db->where('oxcl.dj_is_default', '1');
			}	
			//checking bidding type
			if($housead==FALSE)
			{
			
			$this->db->where('oxcamp.bidding_type !=', '1');
			}
			
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	
	/*
	 * 
	 * name: fetch_web_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a web creative
	 */
	 
	 function fetch_web_creatives($where=false,$housead=FALSE,$dsp_id=FALSE)
	 {
	 	
		
		$dsp=explode(',',$dsp_id);

			$this->db->select('oxb.bannerid,oxcamp.affiliate_id');//,oxcl.dj_is_default
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			//$this->db->where('oxcl.agencyid',$agency_id);
			$this->db->where('oxcl.dj_is_deleted', '0');	


           
            if($dsp_id)
			{
				
				$this->db->where_in('oxb.exchange_id', $dsp);
			}	
			
			$this->db->where_in('oxb.storagetype', array('html'));
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_WEB));
			$this->db->where('oxb.dj_is_deleted ','0');
			//$this->db->where_not_in('oxb.exchange_id','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			 
			 
			$result = $query->result_array();
			
			if($result){
				
				return $result;
			}
			else
			{
				return FALSE;
			}
			
		
	}
	function fetch_cross_creatives($where=false,$housead=FALSE,$dsp_id=FALSE)
		{
			$dsp=explode(',',$dsp_id);
			$storagetype=array('web','html');
			$this->db->select('oxb.bannerid,oxcamp.affiliate_id');//,oxcl.dj_is_default
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			
			 if($dsp_id)
			{
				
				$this->db->where_in('oxb.exchange_id', $dsp_id);
			}	
			
			
			
			$this->db->where('oxcl.dj_is_deleted', '0');		
           
			$this->db->where_in('oxb.storagetype', $storagetype);
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_WEB,MOBILE_IMAGE_CREATIVE));
			$this->db->where('oxb.dj_is_deleted ','0');
			//$this->db->where_not_in('oxb.exchange_id','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			// echo $this->db->last_query();die('welcome');
			$result = $query->result_array();
			
			
			if($result){
				
				return $result;
			}
			else
			{
				return FALSE;
			}
			
		
	}
	 function fetch_interstitial_creatives($where_web=FALSE,$housead=FALSE)

	 {

		$this->db->select('oxb.bannerid,oxcamp.affiliate_id');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($housead==1)
		{
			
			 $this->db->where('oxcl.dj_is_default', '1');
	     }
		$this->db->where('oxb.dj_admin_approve', '1');
		if($this->agency_id)
		{
				$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		$this->db->where('oxb.storagetype', 'web');
		$this->db->where('oxb.dj_banner_type', MOBILE_MRAID_CREATIVE_INTERSTITAL);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}


	function fetch_expand_creatives($where=FALSE,$housead=FALSE)

	 {

		$this->db->select('oxb.bannerid,oxcamp.affiliate_id');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($housead==1)
		{
			
			 $this->db->where('oxcl.dj_is_default', '1');
	     }
		$this->db->where('oxb.dj_admin_approve', '1');
		if($this->agency_id)
		{
				$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		$this->db->where('oxb.storagetype', 'web');
		$this->db->where('oxb.dj_banner_type', MOBILE_MRAID_CREATIVE_EXPAND);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');
		$result = $query->result_array(TAB_BANNERS.' as oxb');
//echo $this->db->last_query();exit;
		if($result)

			return $result;

		else

			return FALSE;

	}
	

	/***Listing of mobile creatives based on type****/
	
	function fetch_reveal_creatives($where=FALSE,$housead=FALSE)

	 {

		$this->db->select('oxb.bannerid,oxcamp.affiliate_id');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		//$this->db->where('oxcl.dj_is_deleted', '0');
		if($housead==1)
		{
			
			 $this->db->where('oxcl.dj_is_default', '1');
	     }
		$this->db->where('oxb.dj_admin_approve', '1');
		if($this->agency_id)
		{
				$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		$this->db->where('oxb.storagetype', 'web');
		$this->db->where('oxb.dj_banner_type', MOBILE_MRAID_CREATIVE_REVEAL);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
function fetch_flex_creatives($where=FALSE,$housead=FALSE)
	 {
		$this->db->select('oxb.bannerid,oxcamp.affiliate_id');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($housead==1)
		{
			
			 $this->db->where('oxcl.dj_is_default', '1');
	     }
		$this->db->where('oxb.dj_admin_approve', '1');
		if($this->agency_id)
		{
				$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		$this->db->where('oxb.storagetype', 'web');
		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_FLEX);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	 function fetch_adhension_creatives($where_web=FALSE,$housead=FALSE)
	 {
		$this->db->select('oxb.bannerid,oxcamp.affiliate_id');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($housead==1)
		{
			
			 $this->db->where('oxcl.dj_is_default', '1');
	     }
		$this->db->where('oxb.dj_admin_approve', '1');
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		$this->db->where('oxb.storagetype', 'web');
		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_ADHESION);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	 function fetch_filmstrip_creatives($housead=FALSE)
	 {
		$this->db->select('oxb.bannerid,oxcamp.affiliate_id');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($housead==1)
		{
			
			 $this->db->where('oxcl.dj_is_default', '1');
	     }	
		$this->db->where('oxb.dj_admin_approve', '1');
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		$this->db->where('oxb.storagetype', 'web');
		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_FILMSTRIP);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		$result = $query->result_array();
	//	echo $this->db->last_query();exit;
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	 function fetch_slider_creatives($where=FALSE,$housead=FALSE)
	 {
		$this->db->select('oxb.bannerid,oxcamp.affiliate_id');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($housead==1)
		{
			
			 $this->db->where('oxcl.dj_is_default', '1');
	     }
		$this->db->where('oxb.dj_admin_approve', '1');
		if($this->agency_id)
		{
				$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		$this->db->where('oxb.storagetype', 'web');
		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_SLIDER);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;

	}
	
	
	 function fetch_pull_creatives($where=FALSE,$housead=FALSE)
	 {
		$this->db->select('oxb.bannerid,oxcamp.affiliate_id');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($housead==1)
		{
			
			 $this->db->where('oxcl.dj_is_default', '1');
	     }
		$this->db->where('oxb.dj_admin_approve', '1');
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		$this->db->where('oxb.storagetype', 'web');
		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_PULL);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	function fetch_mob_inline_creatives($where=FALSE,$housead=FALSE,$dsp_id=FALSE)
	 {
		$this->db->select('oxb.bannerid,oxcamp.affiliate_id,oxcl.dj_is_default');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		
		if($dsp_id)
			{
				
				$this->db->where_in('oxb.exchange_id', $dsp_id);
			}	 
			
		//~ if($housead==1)
		//~ {
			
			 //~ $this->db->where('oxcl.dj_is_default', '1');
	     //~ }
		$this->db->where('oxb.dj_admin_approve', '1');
		//~ if($this->agency_id){
				//~ $this->db->where('oxcl.agencyid',$this->agency_id);
			//~ }
		$this->db->where('oxb.storagetype', 'html');
			
		$this->db->where('oxb.dj_banner_type', MOBILE_VIDEO_CREATIVE_INLINE);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		
		//echo $this->db->last_query();die('welcome');
		//~ log_message('error', 'testt');
		//~ log_message('error', $this->db->last_query());
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	function fetch_mob_overlay_creatives($where=FALSE,$housead=FALSE,$dsp_id)
	 {
		$this->db->select('oxb.bannerid,oxcamp.affiliate_id,oxcl.dj_is_default');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		
		 if($dsp_id)
			{
				
				$this->db->where_in('oxb.exchange_id', $dsp_id);
			}	
		
		//~ if($housead==1)
		//~ {
			
			 //~ $this->db->where('oxcl.dj_is_default', '1');
	     //~ }
		$this->db->where('oxb.dj_admin_approve', '1');
		//~ if($this->agency_id)
		//~ {
			//~ $this->db->where('oxcl.agencyid',$this->agency_id);
		//~ }
		$this->db->where('oxb.storagetype', 'html');
			
		$this->db->where('oxb.dj_banner_type', MOBILE_VIDEO_CREATIVE_OVERLAY);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}

	
	/*
	 * 
	 * name: fetch_dhtml_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a web creative
	 */
	 function fetch_dhtml_creatives($where=FALSE,$housead=FALSE)
	 {
		 
		if($where)
		{
			$this->db->select('oxb.bannerid,oxcamp.affiliate_id');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			
			//$this->db->where($where);
			$this->db->where_in('oxb.storagetype', array('html'));
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_HTML));
			// $this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF));
			$this->db->where('oxb.dj_is_deleted ','0');
			
			 if($housead==1)
			{
				
				$this->db->where('oxcl.dj_is_default', '0');
			}
			$this->db->where_not_in('oxb.exchange_id','0');	
			//~ //checking bidding type
			//~ if($housead==FALSE)
			//~ {
			//~ 
			//~ $this->db->where('oxcamp.bidding_type', '0');
			//~ }
			
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//~ echo $this->db->last_query();
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_text_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a text creative
	 */
	 function fetch_text_creatives($housead=FALSE,$dsp_id=FALSE)
	 {
	 	$dsp=explode(',',$dsp_id);
		$this->db->select('oxb.bannerid,oxcamp.affiliate_id,oxcl.dj_is_default');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		
		$this->db->where('oxb.storagetype', 'html');
		if($dsp_id)
			{
				
				$this->db->where_in('oxb.exchange_id', $dsp_id);
			}	
		
		$this->db->where('oxb.dj_banner_type', WEB_CREATIVE_TEXT);
		$this->db->where('oxb.dj_is_deleted ','0');
		
		$query = $this->db->get(TAB_BANNERS.' as oxb');
		
		$result = $query->result_array(); 
		// echo $this->db->last_query();exit;
		if($result)
			return $result;
		else
			return FALSE;
	}

	 function fetch_cross_text_creatives($housead=FALSE,$dsp_id=FALSE)
	 {
	 	
	 	$dsp=explode(',',$dsp_id);

		$this->db->select('oxb.bannerid,oxcamp.affiliate_id,oxcl.dj_is_default');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		
		$this->db->where_in('oxb.storagetype', array(txt,html));
		if($dsp_id)
			{
				
				$this->db->where_in('oxb.exchange_id', $dsp_id);
			}	
		
		$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_TEXT,M_TEXT));
		$this->db->where('oxb.dj_is_deleted ','0');
		
		$query = $this->db->get(TAB_BANNERS.' as oxb');
		
		$result = $query->result_array(); 
		
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_inline_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline creative
	 */
	 function fetch_inline_creatives($where=false,$housead=FALSE,$dsp_id=FALSE)
	 {
		 
	 	$dsp=explode(',',$dsp_id);
		if($where)
		{
			
			$this->db->select('oxb.bannerid,oxcamp.affiliate_id,oxcl.dj_is_default');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			
			
			 if($dsp_id)
			{
				
				$this->db->where_in('oxb.exchange_id', $dsp_id);
			}	
		
			$this->db->where('oxb.storagetype', 'html');
			
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_INLINE);
			$this->db->where('oxb.dj_is_deleted ','0');
			
			
			
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
		//~ echo $this->db->last_query();die('welcome');
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_overlay_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay creative
	 */
	 function fetch_overlay_creatives($where=false,$housead=FALSE,$dsp_id=FALSE)
	 {
	 	$dsp=explode(',',$dsp_id);
		if($where)
		{
			$this->db->select('oxb.bannerid,oxcamp.affiliate_id,oxcl.dj_is_default');
			
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			//~ if($this->agency_id)
			//~ {
				//~ $this->db->where('oxcl.agencyid',$this->agency_id);
			//~ }
			//$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_OVERLAY);
			$this->db->where('oxb.dj_is_deleted ','0');
			 if($dsp_id)
			{
				
				$this->db->where_in('oxb.exchange_id', $dsp_id);
			}	
			
			 
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	
	function add_link_ads($link_assoc_data)
	{
		
		if($link_assoc_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banners */
			$this->db->insert(TAB_AD_ZONE_ASSOC,$link_assoc_data);
			//~ echo $this->db->last_query();die('welocme');
			$insert_id	= $this->db->insert_id();
			
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$campaignid=$this->get_campaignid($link_assoc_data['ad_id']);

				$this->unlink_campaigns($link_assoc_data['zone_id'],$campaignid);
				$this->db->trans_commit();
				return $insert_id;
			}
		}
		else
			return FALSE;
	}

	 function unlink_campaigns($zone_id,$placement_id){
		if($zone_id && $placement_id)
		{
			$this->db->select('placement_id');		
			$this->db->where('zone_id',$zone_id);
			$this->db->where('placement_id',$placement_id);
			$query = $this->db->get(TAB_PLACE_ZONE_ASSOC);
			$placement_zone	=array('zone_id'=>$zone_id,'placement_id'=>$placement_id); 
			
			if ($query->num_rows() == 0) 
			{
				$this->db->insert(TAB_PLACE_ZONE_ASSOC,$placement_zone);
			}
			else
			{
				return FALSE;
			}
		}
	}

	function get_campaignid($creative_id)
	{
		$this->db->select('oxb.campaignid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_default','0');
		$this->db->where('oxb.bannerid',$creative_id);
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		$result = $query->result_array();
		return $result['0']['campaignid'];
	}

	
	/*
	 * 
	 * name: unlink_ads
	 * @param : zone_id
	 * @return : $result
	 * 
	 * Delete the zone assoc
	 */
	 function unlink_ads($zone_id=false)
	 {
		if($zone_id)
		{
			$this->db->trans_start();
			// $this->db->delete(TAB_AD_ZONE_ASSOC.'as oxz');
			// $this->db->from('oxz.*');
			// $this->db->join(TAB_BANNERS.' as oxb','oxb.bannerid=oxz.ad_id');
			// $this->db->where('oxz.zone_id',$zone_id);
			// $this->db->where('oxb.bannerid !=',0);
			
			//~ $sql="delete oxz.* from ox_ad_zone_assoc as oxz Join ox_banners as oxb on oxb.bannerid=oxz.ad_id WHERE oxz.zone_id = '".$zone_id."' and oxb.exchange_id!=0";
			$sql="delete oxz.* from ox_ad_zone_assoc as oxz Join ox_banners as oxb on oxb.bannerid=oxz.ad_id WHERE oxz.zone_id = '".$zone_id."'";
			
			$this->db->query($sql);
			
			

			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();
			else
				$this->db->trans_commit();
		}
		else
			return FALSE;
		
	}
	
	
	
	
	/**************************************************************************************
	 * 									Match AD BLOCK
	 * ************************************************************************************/
	 
	/*
	 * 
	 * name: fetch_match_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a matched blocks with creative
	 */
	 function fetch_match_adblocks($where=false)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if(isset($where['size']))
			{
				$this->db->where($where['size']);
			}
			$this->db->where_in('oxz.dj_zone_type', $where['zonetype']);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	
	
	
	/*
	 * 
	 * name: fetch_banner_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a web blocks
	 */
	 function fetch_banner_adblocks($where=false)
	 {
		 if(get_session('agencyid'))
			{
				
			$agencyid=get_session('agencyid');
			}else
			{
				$agencyid=get_session('agency_id');
			}
		if($where)
		{
			$this->db->select('oxz.zoneid,oxz.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			$this->db->where('oxa.agencyid',$agencyid);
			
			$this->db->where_in('oxz.dj_zone_type', array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML,CROSS_AD_BLOCK_IMAGE));
			
			 $this->db->where($where);
			$this->db->where('oxz.dj_is_deleted ','0');

			$query = $this->db->get(TAB_ZONES.' as oxz');

		 // echo $this->db->last_query();die('welcome');
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	function fetch_banner_adblocks_with_cross($where=false)
	 {
		 if(get_session('agencyid'))
			{
				
			$agencyid=get_session('agencyid');
			}else
			{
				$agencyid=get_session('agency_id');
			}
		// if($where)
		// {
			$this->db->select('oxz.zoneid,oxz.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			$this->db->where('oxa.agencyid',$agencyid);
			
			$this->db->where_in('oxz.dj_zone_type', array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML,CROSS_AD_BLOCK_IMAGE));
			
			 // $this->db->where($where);
			$this->db->where('oxz.dj_is_deleted ','0');

			// $this->db->or_where('oxz.height','0');
			// $this->db->or_where('oxz.width','0');


			$query = $this->db->get(TAB_ZONES.' as oxz');

		 // echo $this->db->last_query();die('welcome');
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		// }
		// else
		// 	return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_text_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a text blocks
	 */
	
	function fetch_text_adblocks()
	{
		 if(get_session('agencyid'))
			{
				
			$agencyid=get_session('agencyid');
			}else
			{
				$agencyid=get_session('agency_id');
			}
		$this->db->select('oxz.zoneid,oxz.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		
		$this->db->where('oxa.agencyid',$agencyid);
		
		$this->db->where_in('oxz.dj_zone_type', array(WEB_AD_BLOCK_TEXT,CROSS_AD_BLOCK_TEXT));
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_overlay_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay blocks
	 */
	 function fetch_overlay_adblocks($where=false)
	 {
		  if(get_session('agencyid'))
			{
				
			$agencyid=get_session('agencyid');
			}else
			{
				$agencyid=get_session('agency_id');
			}
		if($where)
		{
			$this->db->select('oxz.zoneid,oxz.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			
				$this->db->where('oxa.agencyid',$agencyid);
			
			//$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_OVERLAY);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	function fetch_banner_adblocks_mobile($where=false)
	 {
		 
		 if(get_session('agencyid'))
			{
				
			$agencyid=get_session('agencyid');
			}else
			{
				$agencyid=get_session('agency_id');
			}
		 
		if($where)
		{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			
				$this->db->where('oxa.agencyid',$agencyid);
			
			//$this->db->where($where);
			$this->db->where_in('oxz.dj_zone_type', array(MOBILE_VIDEO_AD_BLOCK_INLINE));
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			
			$result = $query->result_array();
		//echo $this->db->last_query();exit;
			if($result)
				return $result;
			else
				return FALSE;
		} 
		else
			return FALSE;
		
	}
	function fetch_banner_adblocks_mobile_overlay($where=false)
	 {
		  if(get_session('agencyid'))
			{
				
			$agencyid=get_session('agencyid');
			}else
			{
				$agencyid=get_session('agency_id');
			}
		 
		if($where)
		{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$agencyid);
			}
			//$this->db->where($where);
			$this->db->where_in('oxz.dj_zone_type', array(MOBILE_VIDEO_AD_BLOCK_OVERLAY));
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	


	/*
	 * 
	 * name: fetch_inline_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline blocks
	 */
	 function fetch_inline_adblocks($where=false)
	 {
		  if(get_session('agencyid'))
			{
				
			$agencyid=get_session('agencyid');
			}else
			{
				$agencyid=get_session('agency_id');
			}
		if($where)
		{
			$this->db->select('oxz.zoneid,oxz.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			
				$this->db->where('oxa.agencyid',$agencyid);
			
			//$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_INLINE);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	 function fetch_image_creatives($house_ad = false,$dsp_id)

	 {
		   $dsp=explode(',',$dsp_id);
			$this->db->select('oxb.bannerid,oxcamp.affiliate_id');//,oxcl.dj_is_default
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			// $this->db->where('oxcl.agencyid',$agency_id);
			$this->db->where('oxcl.dj_is_deleted', '0');	

			if($dsp_id)
			{
				
				$this->db->where_in('oxb.exchange_id', $dsp);
			}
           	

			$this->db->where_in('oxb.storagetype', array('web'));
			$this->db->where('oxb.dj_banner_type', MOBILE_IMAGE_CREATIVE);
			$this->db->where('oxb.dj_is_deleted ','0');
			//$this->db->where_not_in('oxb.exchange_id','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			
			$result = $query->result_array();
			
			if($result){
				
				return $result;
			}
			else
			{
				return FALSE;
			}
		

	}
	
	function fetch_mob_text_creatives($housead=FALSE,$dsp_id=FALSE)
	 {

		$this->db->select('oxb.bannerid,oxcamp.affiliate_id,oxcl.dj_is_default');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		
		if($dsp_id)
			{
				
				$this->db->where_in('oxb.exchange_id', $dsp_id);
			}
		
		//~ if($this->agency_id)
		//~ {
			//~ $this->db->where('oxcl.agencyid',$this->agency_id);
		//~ }
		
		$this->db->where('oxb.storagetype', 'txt');
		 //~ if($housead==1)
			//~ {
				
				//~ $this->db->where('oxcl.dj_is_default', '1');
			//~ }	
			//checking bidding type
			//~ if($housead==FALSE)
			//~ {
			//~ 
			//~ $this->db->where('oxcamp.bidding_type', '0');
			//~ }
		$this->db->where_in('oxb.dj_banner_type', array(M_TEXT));
		$this->db->where('oxb.dj_is_deleted ','0');
		//checking bidding type
		//$this->db->where('oxcamp.bidding_type', '0');
		//$this->db->where_not_in('oxb.exchange_id','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');
		
		$result = $query->result_array(); 
		//echo $this->db->last_query();exit;
		if($result)
			return $result;
		else
			return FALSE;
	}
}
