<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Do_web_creative extends CI_Model
{
  
    /*
	 * 
	 * name: add_web
	 * @param :$creative_data,$blob_data
	 * @return : TRUE (or) FALSE
	 * 
	 * This method adds the web creative
	 */
	
	function add($creative_data,$blob_data=false,$agency_id=FALSE,$is_house_ad=FALSE)
	{
	
		if($creative_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banners */
			$this->db->insert(TAB_BANNERS,$creative_data);
			$creative_id=$this->db->insert_id();
			$campaign_id = $creative_data['campaignid'];
			
			/*SQL BLOB data*/
			if($creative_data['storagetype']=='sql')
			{
				$this->db->insert(TAB_IMAGES,$blob_data);
			}
			/*SQL BLOB data*/
				
			// Process of auto link adblocks
					
			 /*Manual linking*/
			$link_type=$this->default_configurations->get('linking_type');  
				
				if($link_type !='manual linking')
				{
					$this->Do_auto_link->link_adblocks($creative_id);
			    }elseif($link_type =='manual linking')
			    {
					if($is_house_ad==1)
					{
						$this->Do_auto_link->link_adblocks($creative_id);
					}
					$exist_campaign = $this->fetch_campaign_stats($campaign_id);
					
					if($exist_campaign)
					{
						$this->Do_auto_link->link_adblocks($creative_id);
						
					}
				}
			    
			    
			
			/*Manual linking*/

			$this->db->trans_complete();
			if ($this->db->trans_status() == FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $creative_id;
			}
		}
		else
			return FALSE;
		
	}

	function update_url($update_url_data=false,$creative_id=false)
	{

		if($update_url_data && $creative_id)
		{
			$this->db->trans_start();

			/*Update in ox_banners */
			$this->db->where('bannerid',$creative_id);
			$this->db->update(TAB_BANNERS,$update_url_data);

			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
	}
    /*
	 * 
	 * name: add_creative_dependiences
	 * @param :$creative_data,$blob_data
	 * @return : TRUE (or) FALSE
	 * 
	 * This method adds the web creative
	 */
	
	function add_creative_dependiences($creative_data)
	{
		if($creative_data)
		{
			$this->db->trans_start();

			$this->db->insert(TAB_BAN_DEPEND,$creative_data);

			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}
	/*
	 * 
	 * name: edit
	 * @param :$creative_data,$creative_id
	 * @return : TRUE (or) FALSE
	 * 
	 * Edit the WEB creative
	 */
	function edit($creative_data,$creative_id=false,$agency_id=FALSE,$is_house_ad=false)
	{
		if($creative_data && $creative_id)
		{
			$this->db->trans_start();

			/*Update in ox_banners */
			$this->db->where('bannerid',$creative_id);
			$this->db->update(TAB_BANNERS,$creative_data);
			
			// Process of auto link adblocks
			if($agency_id!=FALSE && $is_house_ad == 1)
			{
			 $this->Do_auto_link->link_adblocks($creative_id);
			}
			
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
	}
	/*
	 * 
	 * name: edit_blob_data
	 * @param :$creative_data,$creative_id,$blob_data
	 * @return : TRUE (or) FALSE
	 * 
	 * Updates the blob data of the database creative
	 */
	function edit_blob_data($blob_data,$creative_name=false)
	{

		if($blob_data && $creative_name)
		{
			$this->db->trans_start();

			/*Update in ox_images */
			$this->db->where('filename',$creative_name);
			$this->db->update(TAB_IMAGES,$blob_data);

			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
	}
	/*
	 * 
	 * name: edit_creative_dependiences
	 * @param :$creative_data,$creative_id,$blob_data
	 * @return : TRUE (or) FALSE
	 * 
	 * Edit the WEB creative
	 */
	function edit_creative_dependiences($creative_data,$creative_id=false,$blob_data=false)
	{
		if($creative_data && $creative_id)
		{
			$this->db->trans_start();

			$this->db->where('banner_id',$creative_id);
			$this->db->update(TAB_BAN_DEPEND,$creative_data);
				
			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
	}
	
	function fetch_campaign_stats($campaign_id)
	{
		if($campaign_id)
		{
			$this->db->select('*');		
			$this->db->where('placement_id ',$campaign_id);
			$query = $this->db->get(TAB_PLACE_ZONE_ASSOC);
			$result = $query->result_array();
			//echo $this->db->last_query(); exit;	
			if($result)
				return $result;
			else
				return FALSE;
		}
	}
}

