<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Do_video_creative extends CI_Model
{
	 /*
	 * 
	 * name: fetch_creative
	 * @param :
	 * @return : $result
	 * 
	 * Lists a video creative of an advertiser
	 */
	function check_companion_size($campaign_id=false,$width=false,$height=false)
	{
		$where	=	array(
							'width'			=>	$width,
							'height'		=>	$height,
							'campaignid'	=>	$campaign_id,
							'storagetype'	=>	'web',
							'dj_banner_type'=>	WEB_CREATIVE_WEB,
							'dj_is_deleted'	=>	'0'
						);
						
		$this->db->select('bannerid,description,filename,storagetype,width,height');		
		$this->db->where($where);
		$this->db->order_by('dj_added_date ');
		$query 	= 	$this->db->get(TAB_BANNERS);		
		$result = 	$query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: add_video
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Add the video creative into the database
	 */
	
	//~ function add_video($creative_data,$agency_id=FALSE,$is_house_ad=FALSE)
	//~ {
		//~ if($creative_data)
		//~ {
			//~ $this->db->trans_start();
			//~ /*Insert in ox_banners */
			//~ $this->db->insert(TAB_BANNERS,$creative_data);
			//~ 
			//~ $creative_id	= $this->db->insert_id();
		//~ 
			//~ if($agency_id!=FALSE) 
			//~ {
				//~ $this->Do_auto_link->link_adblocks($creative_id);
			//~ }
			//~ 
			//~ $this->db->trans_complete();
//~ 
			//~ if ($this->db->trans_status() === FALSE)
			//~ {
				//~ $this->db->trans_rollback();
				//~ return FALSE;
			//~ }
			//~ else
			//~ {
				//~ $this->db->trans_commit();
				//~ 
				//~ return $creative_id;
			//~ }
		//~ }
		//~ else
			//~ return FALSE;
		//~ 
	//~ }
		function add_video($creative_data,$agency_id=FALSE,$is_house_ad=FALSE)
	{
		//print_r($creative_data);exit;
		if($creative_data)
		{
			$campid = $creative_data['campaignid'];
			$this->db->trans_start();
			/*Insert in ox_banners */
			$this->db->insert(TAB_BANNERS,$creative_data);
			
			$creative_id	= $this->db->insert_id();
		//$creative_id=560;
		
			if($agency_id!=FALSE) 
			{
				$link_type=$this->default_configurations->get('linking_type');
				
				if($link_type !='manual linking')
				{
					$res=$this->Do_auto_link->link_adblocks($creative_id,$agency_id);
				}
				else{
					if($is_house_ad==1)
					{
						$res=$this->Do_auto_link->link_adblocks($creative_id,$agency_id);
					}
					$exist_campaign = $this->fetch_campaign_stats($campid);
					if($exist_campaign)
					{
						$this->Do_auto_link->link_adblocks($creative_id);
						
					}
				}
				//$this->Do_auto_link->link_adblocks($creative_id);
			}
			//return $link_type;
			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				
				return $creative_id;
			}
		}
		else
			return FALSE;
		
	}
	/*
	 * 
	 * name: add_video_vast
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Add the video vast creative into the database
	 */
	
	function add_video_vast($creative_data)
	{
		if($creative_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banner_vast_element */
			$this->db->insert(TAB_BAN_VAST_ELE,$creative_data);

			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: update_video
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Update the video creative into the database
	 */
	
	function update_video($creative_data,$creative_id,$agency_id=FALSE)
	{
		if($creative_data)
		{
			$this->db->trans_start();
			/*Update in ox_banners */
			$this->db->where('bannerid',$creative_id);
			$this->db->update(TAB_BANNERS,$creative_data);
			
			// Process of auto link adblocks
			if($agency_id!=FALSE)
			{
			 $this->Do_auto_link->link_adblocks($creative_id);
			}
			
			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: update_video_vast
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Update the video vast creative into the database
	 */
	
	function update_video_vast($creative_data,$creative_id)
	{
		if($creative_data)
		{
			$this->db->trans_start();
			/*Update in ox_banner_vast_element */
			$this->db->where('banner_id',$creative_id);
			$this->db->update(TAB_BAN_VAST_ELE,$creative_data);

			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}
	
	
	/*
	 * 
	 * name: fetch_video
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Get the video creative from the database
	 */
	
	function fetch_video($creative_id)
	{	
		if($creative_id)
		{	
			/*Get records from ox_banner_vast_element */
			$this->db->where('bannerid',$creative_id);
			$query	=	$this->db->get(TAB_BANNERS);
			$result	=	$query->result_array();
			
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	/*
	 * 
	 * name: fetch_video_vast
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Get the video vast creative from the database
	 */
	
	function fetch_video_vast($creative_id)
	{
		if($creative_id)
		{
			/*Get records from ox_banner_vast_element */
			$this->db->where('banner_id',$creative_id);
			$query	=	$this->db->get(TAB_BAN_VAST_ELE);
			$result	=	$query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	function fetch_campaign_stats($campaign_id)
	{
		if($campaign_id)
		{
			$this->db->select('*');		
			$this->db->where('placement_id ',$campaign_id);
			$query = $this->db->get(TAB_PLACE_ZONE_ASSOC);
			$result = $query->result_array();
			//echo $this->db->last_query(); exit;	
			if($result)
				return $result;
			else
				return FALSE;
		}
	}
}
