<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Do_vast_mediation extends CI_Model
{
	function fetch($dsp_id=FALSE)
	{	
		$SQL = "SELECT id, agency_id, adnetwork_name, vast_mediation_url, zone_id, macro, video_length, vast_version, publisher, country, auto_ecpm, ecpm_duration, country_weight, status, ecpm, date_created FROM ".TAB_VIDEO_ADNETWORK." WHERE is_deleted = 0";

		if($dsp_id) $SQL .= " AND id =".$dsp_id."";

		$SQL .= " ORDER BY id DESC";
		
		$query = $this->db->query($SQL);
		
		if($query->num_rows() >0)
		{
				$result = 	$query->result_array();	
				return $result;
		}else{
				return FALSE;	
		}	
	}

	function fetch_active($account_id)
	{	
		$dsp_sql = "SELECT id, adnetwork_name, publisher FROM ".TAB_VIDEO_ADNETWORK." WHERE is_deleted = 0 AND status = 1 ORDER BY id DESC";
		$dsp_query = $this->db->query($dsp_sql);
		
		if($dsp_query->num_rows() >0)
		{
				$dsp = 	$dsp_query->result_array();	
				
				$target_sql = "SELECT GROUP_CONCAT(dsp_id) as dsp FROM ".TAB_DSP_TAR_PUBLISHER." where account_id = ".$account_id;
				$target_query = $this->db->query($target_sql);

				$target = 	$target_query->result_array();	
				$target_array = array_filter(explode(',', $target[0]['dsp']));
				
				$filter_dsp = array();
				foreach($dsp as $key => $data){
					if($data['publisher'] == 1 && !in_array($data['id'], $target_array)){
						unset($dsp[$key]);
					}
					if($data['publisher'] == 2 && in_array($data['id'], $target_array)){
						unset($dsp[$key]);
					}
				}
				return array_values($dsp);
		}else{
				return FALSE;	
		}	
	}

	function block($id){
		$data = array(
	        'status' => 0
		);

		$this->db->where('id', $id);
		return $this->db->update(TAB_VIDEO_ADNETWORK, $data);
	}

	function unblock($id){
		$data = array(
	        'status' => 1
		);

		$this->db->where('id', $id);
		return $this->db->update(TAB_VIDEO_ADNETWORK, $data);
	}

	function remove($id){
		$data = array(
	        'is_deleted' => 1
		);

		$this->db->where('id', $id);
		$this->db->update(TAB_VIDEO_ADNETWORK, $data);
		$this->db->where('dsp_id', $id)->delete(TAB_DSP_PUB_ASSOC);
		return TRUE;
	}

	function dsp_assoc($account_id){
        $SQL = "SELECT GROUP_CONCAT(dsp_id) AS 'dsps', publisher_id FROM ".TAB_DSP_PUB_ASSOC." WHERE publisher_id =".$account_id;
		
		$query = $this->db->query($SQL);
		$result = 	$query->result_array();	
		return $result;
	}

	function link_dsp($account_id, $new_dsps){
		$existing = $this->dsp_assoc($account_id);
		$existing_dsps = explode(',', $existing[0]['dsps']);
		
		$remove_dsp = array_diff($existing_dsps, $new_dsps);
		$add_dsp = array_diff($new_dsps, $existing_dsps);

		$result = 1;

		if(is_array($remove_dsp) && count($remove_dsp) > 0)
		{
			$this->db->where('publisher_id',$account_id);
			$this->db->where_in('dsp_id',$remove_dsp);
			$this->db->delete(TAB_DSP_PUB_ASSOC);
			$result	   +=	1;
		}

		if(is_array($add_dsp) && count($add_dsp) > 0)
		{
			foreach($add_dsp as $dsp)
			{
				$this->db->insert(TAB_DSP_PUB_ASSOC, array('publisher_id' =>	$account_id, 'dsp_id' => $dsp));				
			}
			$result	   +=	1;
		}
		return $result;
	}
	
	function auto_link_dsp($dsp_id)
	{
	
	$account_ids = 	$this->fetch_publisher();
	
	if($account_ids > 0)
	{
	
	foreach($account_ids as $account_id)
	{
		$this->db->insert(TAB_DSP_PUB_ASSOC, array('publisher_id' =>	$account_id['id'], 'dsp_id' => $dsp_id));
	}	

	}
	return TRUE;
	}	

	function fetch_publisher($account_id){
        $SQL = "SELECT `oxaf`.`name` as text,`oxaf`.`account_id` as id FROM ".TAB_USERS." as oxu JOIN ".TAB_AFFILIATE." as oxaf ON `oxaf`.`account_id`=`oxu`.`default_account_id` JOIN ".TAB_NWK_MANAGERS." as dnm ON `dnm`.`agency_id`=`oxaf`.`agencyid` WHERE dnm.is_deleted =0 AND oxaf.dj_is_deleted =0 AND oxaf.dj_is_denied =0 AND dnm.default_manager = 1 GROUP BY `oxaf`.`account_id`";
		
		$query = $this->db->query($SQL);
		$result = 	$query->result_array();	
		return $result;
	}

	function add_dsp($dsp_data){
		// Add DSP
		//echo "asdasd";exit;
		$this->db->insert(TAB_VIDEO_ADNETWORK, $dsp_data);
		$dsp_id = $this->db->insert_id();
		//echo $this->db->last_query();die("qwe");
		//return $dsp_id;
		// Add Accounts data
		$accounts_data = array('account_type' => 'ADVERTISER', 'account_name' => $dsp_data['adnetwork_name']);
		$this->db->insert(TAB_ACCOUNTS, $accounts_data);
		$account_id = $this->db->insert_id();

		// Add Clients data
		$email = str_replace(' ', '', $dsp_data['adnetwork_name']).'@dsp.com';
		$clients_data = array('agencyid' => '1', 'clientname' => $dsp_data['adnetwork_name'], 'contact' => 'Dsp user', 'email' => $email, 'report' => 'f', 'reportinterval' => '7', 'reportlastdate' => '', 'reportdeactivate' => '', 'comments' => '', 'updated' => date('Y-m-d H:i:s'), 'account_id' => $account_id, 'advertiser_limitation' => '0', 'type' => '0', 'exchange_id' => $dsp_id);
		$this->db->insert(TAB_CLIENTS, $clients_data);
		$client_id = $this->db->insert_id();

		// Add campaign data
		$campaign_data = array('campaignname' => $dsp_data['adnetwork_name'], 'clientid' => $client_id, 'views' => '-1', 'clicks' => '-1', 'conversions' => '-1', 'priority' => '-2', 'weight' => '1', 'target_impression' => '0', 'target_click' => '0', 'target_conversion' => '0', 'anonymous' => 'f', 'companion' => '0', 'comments' => '', 'revenue' => '', 'revenue_type' => '1', 'updated' => date('Y-m-d H:i:s'), 'block' => '0', 'capping' => '0', 'session_capping' => '0', 'status' => '1', 'hosted_views' => '0', 'hosted_clicks' => '0', 'viewwindow' => '0', 'clickwindow' => '0', 'ecpm' => '', 'min_impressions' => '100', 'ecpm_enabled' => '0', 'activate_time' => date('Y-m-d H:i:s'), 'type' => '0', 'show_capped_no_cookie' => '0', 'dj_campaign_budget' => '0', 'dj_is_retargeted' => '0', 'dj_max_retargetting' => '0', 'dj_daily_budget' => '0', 'dj_campaign_remain_budget' => '0', 'dj_campaign_remain_total_budget' => '0', 'dj_current_date' => date('Y-m-d H:i:s'), 'dj_targetting_type' => 'WEB', 'compiledlimitation' => '', 'acl_plugins' => '', 'dj_added_date' => date('Y-m-d H:i:s'), 'dj_category_id' => '', 'dj_is_deleted' => '1', 'dj_media_type' => '', 'dj_wizard_status' => '1', 'dj_is_rtb_campaign' => '', 'dj_rtb_buyer_id' => '', 'dsp_category' => '', 'dj_dsp_campaign_remain_total_budget' => '', 'exchange_id' => $dsp_id);
		$this->db->insert(TAB_CAMPAIGNS, $campaign_data);
		$campaign_id = $this->db->insert_id();

		// Add banner data
		$inline_data = array('campaignid' => $campaign_id, 'contenttype' => 'gif', 'pluginversion' => '0', 'storagetype' => 'html', 'filename' => '', 'imageurl' => '', 'htmltemplate' => '', 'htmlcache' => '', 'width' => '-3', 'height' => '-3', 'weight' => '1', 'seq' => '0', 'target' => '', 'url' => '', 'alt' => '', 'statustext' => '', 'bannertext' => '', 'description' => $dsp_data['adnetwork_name'].' buyer Video ads served to opted in campaigns', 'adserver' => '', 'block' => '0', 'capping' => '0', 'session_capping' => '0', 'compiledlimitation' => '', 'acl_plugins' => '', 'append' => '', 'bannertype' => '', 'alt_filename' => '', 'alt_imageurl' => '', 'alt_contenttype' => 'gif', 'comments' => '', 'updated' => date('Y-m-d H:i:s'), 'acls_updated' => '', 'keyword' => '', 'transparent' => '0', 'parameters' => '', 'status' => '0', 'ext_bannertype' => 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml', 'prepend' => '', 'dj_master_banner' => '-1', 'dj_banner_type' => 'V_IN', 'dj_added_date' => date('Y-m-d H:i:s'), 'dj_admin_approve' => '1', 'dj_approved_date' => date('Y-m-d H:i:s'), 'dj_is_deleted' => '1', 'dj_account_id' => $account_id, 'dj_approve_mode' => '0', 'exchange_id' => $dsp_id);
		$this->db->insert(TAB_BANNERS, $inline_data);
		$inline_id = $this->db->insert_id();

		$inline_vast = array('banner_id' => $inline_id, 'vast_element_type' => 'singlerow', 'vast_video_id' => '', 'vast_video_duration' => '', 'vast_video_delivery' => '', 'vast_video_type' => '', 'vast_video_bitrate' => 400, 'vast_video_height' => 480, 'vast_video_width' => 640, 'vast_video_outgoing_filename' =>'', 'vast_companion_banner_id' => 0, 'vast_overlay_height' => '', 'vast_overlay_width' => '', 'vast_video_clickthrough_url' => '', 'vast_overlay_action' => '', 'vast_overlay_format' => '', 'vast_overlay_text_title' => '', 'vast_overlay_text_description' => '', 'vast_overlay_text_call' => '', 'vast_creative_type' => '', 'vast_thirdparty_companion_clicktracking' => '', 'vast_thirdparty_companion_expandedwidth' => 0, 'vast_thirdparty_companion_expandedheight' => 0, 'vast_thirdparty_clicktracking' => '', 'vast_thirdparty_clickcustom' => '', 'vast_video_skip_duration' => 0, 'vast_video_skip_progress_duration' => 0, 'vast_overlay_expandedminduration' => '', 'vast_overlay_expanded_width' => 0, 'vast_overlay_expanded_height' => 0, 'vast_thirdparty_impression' => '', 'vast_wrapper_url' => '', 'vast_version' => '', 'vast_overlay_wrapper' => '', 'vast_overlay_version' => 0, 'adbreak_tag1' => '', 'adbreak_tag2' => '', 'adbreak_tag3' => '', 'adbreak_tag4' => '', 'adbreak_tag5' => '', 'vmap_overlay_count' => 0, 'vmap_offset_adbreak1' => '', 'vmap_offset_adbreak2' => '', 'vmap_offset_adbreak3' => '', 'vmap_offset_adbreak4' => '', 'vmap_offset_adbreak5' => '', 'vmap_midroll_skipoffset' => '');
		$this->db->insert(TAB_BAN_VAST_ELE, $inline_vast);

		$overlay_data = array('campaignid' => $campaign_id, 'contenttype' => 'gif', 'pluginversion' => '0', 'storagetype' => 'html', 'filename' => '', 'imageurl' => '', 'htmltemplate' => '', 'htmlcache' => '', 'width' => '-2', 'height' => '-2', 'weight' => '1', 'seq' => '0', 'target' => '', 'url' => '', 'alt' => '', 'statustext' => '', 'bannertext' => '', 'description' => $dsp_data['adnetwork_name'].' buyer Video ads served to opted in campaigns', 'adserver' => '', 'block' => '0', 'capping' => '0', 'session_capping' => '0', 'compiledlimitation' => '', 'acl_plugins' => '', 'append' => '', 'bannertype' => '', 'alt_filename' => '', 'alt_imageurl' => '', 'alt_contenttype' => 'gif', 'comments' => '', 'updated' => date('Y-m-d H:i:s'), 'acls_updated' => '', 'keyword' => '', 'transparent' => '0', 'parameters' => '', 'status' => '0', 'ext_bannertype' => 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml', 'prepend' => '', 'dj_master_banner' => '-1', 'dj_banner_type' => 'V_OL', 'dj_added_date' => date('Y-m-d H:i:s'), 'dj_admin_approve' => '1', 'dj_approved_date' => date('Y-m-d H:i:s'), 'dj_is_deleted' => '1', 'dj_account_id' => $account_id, 'dj_approve_mode' => '0', 'exchange_id' => $dsp_id);
		$this->db->insert(TAB_BANNERS, $overlay_data);
		$overlay_id = $this->db->insert_id();

		$overlay_vast = array('banner_id' => $overlay_id, 'vast_element_type' => 'singlerow', 'vast_video_id' => '', 'vast_video_duration' => '', 'vast_video_delivery' => '', 'vast_video_type' => '', 'vast_video_bitrate' => 400, 'vast_video_height' => 480, 'vast_video_width' => 640, 'vast_video_outgoing_filename' =>'', 'vast_companion_banner_id' => 0, 'vast_overlay_height' => '', 'vast_overlay_width' => '', 'vast_video_clickthrough_url' => '', 'vast_overlay_action' => '', 'vast_overlay_format' => '', 'vast_overlay_text_title' => '', 'vast_overlay_text_description' => '', 'vast_overlay_text_call' => '', 'vast_creative_type' => '', 'vast_thirdparty_companion_clicktracking' => '', 'vast_thirdparty_companion_expandedwidth' => 0, 'vast_thirdparty_companion_expandedheight' => 0, 'vast_thirdparty_clicktracking' => '', 'vast_thirdparty_clickcustom' => '', 'vast_video_skip_duration' => '', 'vast_video_skip_progress_duration' => '', 'vast_overlay_expandedminduration' => '', 'vast_overlay_expanded_width' => 0, 'vast_overlay_expanded_height' => 0, 'vast_thirdparty_impression' => '', 'vast_wrapper_url' => '', 'vast_version' => '', 'vast_overlay_wrapper' => '', 'vast_overlay_version' => 0, 'adbreak_tag1' => '', 'adbreak_tag2' => '', 'adbreak_tag3' => '', 'adbreak_tag4' => '', 'adbreak_tag5' => '', 'vmap_overlay_count' => 0, 'vmap_offset_adbreak1' => '', 'vmap_offset_adbreak2' => '', 'vmap_offset_adbreak3' => '', 'vmap_offset_adbreak4' => '', 'vmap_offset_adbreak5' => '', 'vmap_midroll_skipoffset' => '');
		$this->db->insert(TAB_BAN_VAST_ELE, $overlay_vast);
		
		if($dsp_id)
		{
		$this->auto_link_dsp($dsp_id);
		}
		
		return $dsp_id;
	}

	function edit_dsp($dsp_data,$dsp_id,$agency_id){
		$this->db->where(array('id' => $dsp_id, 'agency_id' => $agency_id));
		return $this->db->update(TAB_VIDEO_ADNETWORK, $dsp_data);
	}

	function target_publishers($insertId, $publishers){
		$this->db->where('dsp_id', $insertId)->delete(TAB_DSP_TAR_PUBLISHER);
		foreach($publishers as $publisher){
			$this->db->insert(TAB_DSP_TAR_PUBLISHER, array('dsp_id' => $insertId, 'account_id' => $publisher));
		}
		return TRUE;
	}

	function remove_target_publishers($dsp_id){
		$this->db->where('dsp_id', $dsp_id)->delete(TAB_DSP_TAR_PUBLISHER);
		return TRUE;
	}

	function target_countries($insertId, $countries){
		$this->db->where('dsp_id', $insertId)->delete(TAB_DSP_TAR_COUNTRY);
		foreach($countries as $country){
			$this->db->insert(TAB_DSP_TAR_COUNTRY, array('dsp_id' => $insertId, 'country_code' => $country));
		}
		return TRUE;
	}

	function remove_target_countries($dsp_id){
		$this->db->where('dsp_id', $insertId)->delete(TAB_DSP_TAR_COUNTRY);
		return TRUE;
	}

	function fetch_dsp_publisher($dsp_id){
		
		$SQL = "SELECT GROUP_CONCAT(`account_id`) as account_ids FROM (".TAB_DSP_TAR_PUBLISHER.") WHERE `dsp_id` =".$dsp_id;
		//return $SQL;
		$query = $this->db->query($SQL);
		if($query->num_rows() >0)
		{
			
				$result = 	$query->result_array();	
				return $result;
		}else{
				return FALSE;	
		}
	}
	
	function fetch_dsp_country($dsp_id){
		$SQL = "SELECT GROUP_CONCAT(`country_code`) as country_codes FROM (".TAB_DSP_TAR_COUNTRY.") WHERE `dsp_id` =".$dsp_id;
		
		$query = $this->db->query($SQL);
		if($query->num_rows() >0)
		{
				$result = 	$query->result_array();	
				return $result;
		}else{
				return FALSE;	
		}
	}

	function update_ecpm($id, $ecpm){
		$data = array(
	        'ecpm' => $ecpm
		);

		$this->db->where('id', $id);
		return $this->db->update(TAB_VIDEO_ADNETWORK, $data);
	}

	function country_weight($dsp_id, $country_weight){
		$this->db->where('dsp_id', $dsp_id)->delete(TAB_DSP_COUNTRY_WEIGHT);

		foreach($country_weight as $country_code => $country_weight){
			$this->db->insert(TAB_DSP_COUNTRY_WEIGHT, array('dsp_id' => $dsp_id, 'country_code' => $country_code, 'country_weight' => $country_weight));
		}
		return TRUE;
	}

	function fetch_country_weight($dsp_id){
		$result = $this->db->get_where(TAB_DSP_COUNTRY_WEIGHT, array('dsp_id' => $dsp_id))->result_array();
		if($result){
			return $result;
		}else{
			return FALSE;
		}
	}

	function remove_country_weight($dsp_id){
		$this->db->where('dsp_id', $dsp_id)->delete(TAB_DSP_COUNTRY_WEIGHT);
		return TRUE;
	}
	
		function check_country($c){
			
		$SQL = "SELECT value FROM (".TAB_TARG_COUNTRY.") WHERE value = '{$c}'";
		
		$query = $this->db->query($SQL);
		
		//return $query->num_rows(); 
		
		if($query->num_rows() > 0)
		{			
		return 1;
		}
		else
		{	
		return "FALSE";
		}	
	}
	
		function country_weight_csv($dsp_id,$country_weight){

		if(!empty($dsp_id))
		{
			
		foreach($country_weight as $country_code => $country_weight){
			
		$SQL = "SELECT dsp_id FROM (".TAB_DSP_COUNTRY_WEIGHT.") WHERE dsp_id = '{$dsp_id}' AND country_code = '{$country_code}'";
		
		$query = $this->db->query($SQL);
		
		if($query->num_rows() > 0)
		{
		$data = array('country_weight' => $country_weight);
		$this->db->where(array('dsp_id' => $dsp_id,'country_code' => $country_code));
		$this->db->update(TAB_DSP_COUNTRY_WEIGHT, $data);		
		}	
		else
		{
			
			$this->db->insert(TAB_DSP_COUNTRY_WEIGHT, array('dsp_id' => $dsp_id, 'country_code' => $country_code, 'country_weight' => $country_weight));
		}
		
	}
		return TRUE;

}
else
{
return FALSE;	
}	
}
	
}

