<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Do_targeting extends CI_Model
{
    /*
     *
     * name: add
     * @param :$ox_acls_data
     * @return : TRUE (or) FALSE
     *
     * This method adds targetting acls to the particular campaign
    */
    function add($ox_acls_data = FALSE, $campaign_id = FALSE) 
    {
		
        if ($ox_acls_data AND $campaign_id) {
            $this->db->trans_start();
            /*Insert in ox_acls */
            $this->db->select('campaignid');
            $this->db->where('campaignid ', $campaign_id);
            $this->db->where('type', $ox_acls_data['type']);
            $query = $this->db->get(TAB_ACLS);
           
            if ($query->num_rows() > 0) {
                $where = array(
                    'campaignid' => $campaign_id,
                    'type' => $ox_acls_data['type']
                );
                $this->db->delete(TAB_ACLS, $where);
                $this->db->insert(TAB_ACLS, $ox_acls_data);
                
                //UPDATE IN OX ACLS TABLE
                $this->update_campaign_targetting($campaign_id, $ox_acls_data);
            } else {
                $this->db->insert(TAB_ACLS, $ox_acls_data);
                //UPDATE IN OX ACLS TABLE
                $this->update_campaign_targetting($campaign_id, $ox_acls_data);
            }
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return FALSE;
            } else {
                $this->db->trans_commit();
                return TRUE;
            }
        } else return FALSE;
    }
    /*
     *
     * name: delete
     * @param :$ox_acls_data
     * @return : TRUE (or) FALSE
     *
     * This method adds targetting acls to the particular campaign
    */
    function delete($ox_acls_data = FALSE, $campaign_id = FALSE) 
    {
		
        if ($ox_acls_data AND $campaign_id) {
            $this->db->trans_start();
            /*Insert in ox_acls */
            $this->db->select('campaignid');
            $this->db->where('campaignid ', $campaign_id);
            $this->db->where('type', $ox_acls_data['type']);
            $query = $this->db->get(TAB_ACLS);
            
            if ($query->num_rows() > 0) {
				
                //~ $where = array(
                    //~ 'campaignid' => $campaign_id,
                    //~ 'type' => $ox_acls_data['type']
                //~ );
                $this->db->where('campaignid', $campaign_id);
                $this->db->where('type', $ox_acls_data['type']);
                $this->db->delete(TAB_ACLS);
                
                //UPDATE IN OX ACLS TABLE
                $this->update_campaign_targetting($campaign_id, $ox_acls_data);
            } else {
					
                //UPDATE IN OX ACLS TABLE
                $this->update_campaign_targetting($campaign_id, $ox_acls_data);
            }
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return FALSE;
            } else {
                $this->db->trans_commit();
                return TRUE;
            }
        } else return FALSE;
    }
    
    function delete1($ox_acls_data = FALSE, $campaign_id = FALSE) 
    {
        if ($ox_acls_data AND $campaign_id) {
            $this->db->trans_start();
            /*Insert in ox_acls */
            $this->db->select('campaignid');
            $this->db->where('campaignid ', $campaign_id);
            $this->db->where('type', $ox_acls_data['type']);
            $query = $this->db->get(TAB_ACLS);
            if ($query->num_rows() > 0) {
                $where = array(
                    'campaignid' => $campaign_id,
                    'type' => $ox_acls_data['type']
                );
                $this->db->delete(TAB_ACLS, $where);
                //UPDATE IN OX ACLS TABLE
                $this->update_campaign_targetting($campaign_id, $ox_acls_data);
            } else {
                //UPDATE IN OX ACLS TABLE
                $this->update_campaign_targetting($campaign_id, $ox_acls_data);
            }
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return FALSE;
            } else {
                $this->db->trans_commit();
                return TRUE;
            }
        } else return FALSE;
    }
    /*
     *
     * name: update_campaign_targetting
     * @param :$campaign_targ_data,$campaign_id
     * @return : TRUE (or) FALSE
     *
     * Update the delivery options in the ox campaigns table
     *
     * This method ched weater it has targeting defind already.
     * If it exisits , it will return the processed data,
     * If not exisits, it will return data as such,
    */
    function update_campaign_targetting($campaign_id, $ox_acls_data) 
    {
		
        if ($campaign_id and $ox_acls_data) {
            $this->db->select('logical,type,comparison,data');
            $this->db->where('campaignid', $campaign_id);
            $query = $this->db->get(TAB_ACLS);
            $result = $query->result_array();
            $compiledlimitations = "";
            $acl_plugins = "";
            foreach ($result as $data) {
                $acl_plugins .= $data['type'] . ',';
                $target_data = $data['data'];
                //Fetch constants for targeting type
                $compiled_constants = $this->fetch_complied_constant($data['type']);               
                $compiledlimitations .= $compiled_constants['prefix'] . $data['data'] . $compiled_constants['suffix'] . ' and ';
            }
           
            $acl_plugins = substr($acl_plugins, 0, -1);
            $compiledlimitations = substr($compiledlimitations, 0, -5);
            $campaign_targ_data = array(
                "compiledlimitation" => $compiledlimitations,
                "acl_plugins" => $acl_plugins,
            );
            if ($campaign_targ_data && $campaign_id) {
                $this->db->trans_start();
                $this->db->where('campaignid', $campaign_id);
                $this->db->update(TAB_CAMPAIGNS, $campaign_targ_data);
                $this->db->trans_complete();
                if ($this->db->trans_status() === FALSE) {
                    $this->db->trans_rollback();
                    return FALSE;
                } else {
                    $this->db->trans_commit();
                    return TRUE;
                }
            } else return FALSE;
        }
    }
    /*
     *
     * name: update_capping
     * @param :$ox_campaigns_frquency_data,$campaign_id
     * @return : TRUE (or) FALSE
     *
     * Update the delivery options in the ox campaigns table
     *
     * This method will add capping details to the campaign
     *
    */
    function update_capping($ox_campaigns_frquency_data, $campaign_id) 
    {
        if ($campaign_id and $ox_campaigns_frquency_data) {
            $this->db->trans_start();
            $this->db->where('campaignid', $campaign_id);
            $this->db->update(TAB_CAMPAIGNS, $ox_campaigns_frquency_data);
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return FALSE;
            } else {
                $this->db->trans_commit();
                return TRUE;
            }
        } else return FALSE;
    }
    /*
     *
     * name: fetch_complied_constant
     * @param $type targetting type
     * @return
     *
     * This function will return prefix and suffix for the given targetting type
    */
    function fetch_complied_constant($type = FALSE) 
    {
        if ($type != FALSE) {
            //IF written below lets the both mobile targeing and web-> profile targeting alone.
            if ($type != 'os' and $type != 'handset' and $type != 'capability' and $type != 'teleco' and $type != 'country' and $type != 'city' and $type != 'profile:age' and $type != 'gender' and $type != 'domain' and $type!='keyword' and $type != 'profile:color' and $type != 'profile:weight' and $type != 'profile:height' and $type != 'segment'and $type != 'site'and $type != 'sentiment'and $type != 'age' and $type != 'custom_targ1' and $type != 'custom_targ2' and $type != 'custom_targ3' and $type != 'custom_targ4' ) {
                $targeting_type = explode(':', $type);
                $targeting_type = $targeting_type[2];
            } else {
                $targeting_type = $type;
            }
            $compiled_constants=array();       
            
            switch ($targeting_type) {
                case 'Browser':
                    $compiledlimitation_prefix = "MAX_checkClient_Browser('";
                    $compiledlimitation_suffix = "', '=~')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'Os':
                    $compiledlimitation_prefix = "MAX_checkClient_Os('";
                    $compiledlimitation_suffix = "', '=~')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'domain':
                    $compiledlimitation_prefix = "domain('";
					$compiledlimitation_suffix="', '==')";
					$compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
                    break;
                case 'Country':
                    $compiledlimitation_prefix = "MAX_checkGeo_Country('";
                    $compiledlimitation_suffix = "', '=~')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'Hour':
                    $time_zone = $this->config->item('time_zone'); //get_session('time_zone');
                    $compiledlimitation_prefix = "MAX_checkTime_Hour('";
                    $compiledlimitation_suffix = "@$time_zone', '=~')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'profile:age':
                    $compiledlimitation_prefix = "profile:age('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'gender':
                    $compiledlimitation_prefix = "gender('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'profile:color':
                    $compiledlimitation_prefix = "profile:color('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'profile:height':
                    $compiledlimitation_prefix = "profile:height('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'profile:weight':
                    $compiledlimitation_prefix = "profile:weight('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                 case 'keyword':
                    $compiledlimitation_prefix="keyword('";
                    $compiledlimitation_suffix="', '==',".$campaign_id.")";
                    $compiled_constants=array("prefix"=> $compiledlimitation_prefix,"suffix"=>$compiledlimitation_suffix );
                    break;
                //MOBILE CONSTANTS

                case 'os':
                    $compiledlimitation_prefix = "os('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'handset':
                    $compiledlimitation_prefix = "handset('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'capability':
                    $compiledlimitation_prefix = "capability('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'teleco':
                    $compiledlimitation_prefix = "teleco('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'country':
                    $compiledlimitation_prefix = "country('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'city':
                    $compiledlimitation_prefix = "city('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;
                case 'segment':
                    $compiledlimitation_prefix = "segment('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;      
                case 'site':
                    $compiledlimitation_prefix = "site('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;      
                case 'sentiment':
                    $compiledlimitation_prefix = "sentiment('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;      
                case 'age':
                    $compiledlimitation_prefix = "age('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;  
                case 'custom_targ1':
                    $compiledlimitation_prefix = "custom_targ1('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;   
                 case 'custom_targ2':
                    $compiledlimitation_prefix = "custom_targ2('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;    
                  case 'custom_targ3':
                    $compiledlimitation_prefix = "custom_targ3('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;    
                  case 'custom_targ4':
                    $compiledlimitation_prefix = "custom_targ4('";
                    $compiledlimitation_suffix = "', '==')";
                    $compiled_constants = array(
                        "prefix" => $compiledlimitation_prefix,
                        "suffix" => $compiledlimitation_suffix
                    );
                    break;       
            }
            return $compiled_constants;
        }
    }
    /*
     *
     * name: get_options
     * @param $type targetting type
     * @return
     *
     * Call Function to get options for targetting
    */
    function fetch_targ_options($type = FALSE) 
    {
        if ($type != FALSE) {
            $opt_tables = array(
                TAB_TARG_BROWSERS => 'browser',
                TAB_TARG_OS => 'os',
                TAB_TARG_COUNTRY => 'geo',
                TAB_TARG_MOB_OS => 'mobile_os',
                TAB_TARG_MOB_MANU => 'mobile_manu',
                TAB_TARG_MOBILE_CARRIER => 'mobile_telecom',
                TAB_TARG_KEYWORD => 'keyword',
                //TAB_TARG_MOBILE_CARRIER => 'mobile_carrier',
                TAB_TARG_MOB_CAPA => 'mobile_capability',
                TAB_TARG_DOMAIN => 'domains',
                TAB_TARG_TIME			=> 	'time',
				TAB_TARG_DAYS			=> 	'days',
				TAB_TARG_SEGMENT => 'segment',
				TAB_TARG_SITES => 'site',
				TAB_TARG_SENTIMENTS => 'sentiment',
				TAB_CUSTOM_TARGETING1 => 'custom_targ1',
				TAB_CUSTOM_TARGETING2 => 'custom_targ2',
				TAB_CUSTOM_TARGETING3 => 'custom_targ3',
				TAB_CUSTOM_TARGETING4 => 'custom_targ4',
            );
            $tbl_name = array_search($type, $opt_tables);
            if ($type == 'domains') {
                $this->db->select('name as id , name as text,');
                $this->db->where('is_deleted', '0');
            }
            else if ($type == 'keyword')
            {
                
                $this->db->select('keyword as id,keyword as text,');
                $this->db->where('is_deleted', '0');
            } 
			elseif ($type != 'mobile_telecom' && $type != 'mobile_capability' && $type != 'time') {
			 $this->db->select('value as id,name as text,name as name,GROUP_CONCAT(DISTINCT value) as id');
			 $this->db->group_by('name');
			$this->db->group_by('value');
             
            }elseif ($type == 'mobile_capability') {
                 $this->db->select('value as id,value as text,name as name,GROUP_CONCAT(DISTINCT value) as id');
                 $this->db->group_by('name');
                $this->db->group_by('value');
             
            }
            elseif ($type == 'time') {
                $this->db->select('value as id,name as text,');
            }  else {
                $this->db->select("id as id,CONCAT(country,'-',carriername) as text", false);
                $this->db->where('status', 1);
            }
            if ($type != 'geo' && $type != 'mobile_telecom' && $type != 'mobile_carrier') {
                $this->db->where('is_blocked', 0);
            }            
            $query = $this->db->get($tbl_name);
            if ($query->num_rows > 0)
                return $query->result_array();
            else return FALSE;
        } else return FALSE;
    }
    /*
     *
     * name: add
     * @param : categoryname,categoryvalue
     * @return :lastinsertid
     *
     * Fetch list of n/w users (pub or adv)
    */
    public function add_category($ins_data = FALSE) 
    {
        if ($this->db->insert(TAB_SITE_CATEGORIES, $ins_data)) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
    }
    /* domain crud operation */
    public function add_domain($domain_name = FALSE) 
    {
        $ins_data = array(
            'name' => $domain_name['domain_name']
        );
        if ($this->db->insert(TAB_TARG_DOMAIN, $ins_data)) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: update_domain
     * @param : domainname,domainid
     * @return : domain id
     *
    */
    public function update_domain($domain_info = FALSE) 
    {
        $domainObj = array(
            "name" => $domain_info['domain_name']
        );
        if (!empty($domainObj)) {
            $this->db->where('id', $domain_info['domain_id']);
            $this->db->update(TAB_TARG_DOMAIN, $domainObj);
            return $domain_info['domain_id'];
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_domain
     * @param :
     * @return :all the browser details.
     *
    */
    public function fetch_domain() 
    {
        $query = $this->db->get(TAB_TARG_DOMAIN);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_domain_select
     * @param : browser_id
     * @return :slected  browser details.
     *
    */
    public function fetch_domain_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_TARG_DOMAIN);
        $result = $query->result_array();
        return $result;
    }


    public function fetch_domain_select_data($id = FALSE, $type)
		{
            $this->db->select('data as name');
            $this->db->where('campaignid', $id);
            $this->db->where('type', $type);
            $query = $this->db->get(TAB_ACLS);

            $result = $query->result_array();


            return $result;
        }
    
    
    
    
    
    
    
    /*
     *
     * name: delete_domain
     * @param : domaind
     * @return : status true or false
     *
    */
    public function delete_domain($id = FALSE) 
    {
        if ($id) {
            $this->db->where('id', $id);
            $this->db->delete(TAB_TARG_DOMAIN);
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        } else {
            return FALSE;
        }
    }
    /* domain crud operation */
    /*
     *
     * name: add_main_category
     * @param : categoryname,categoryvalue
     * @return :lastinsertid
     *
     * Fetch list of n/w users (pub or adv)
    */
    public function add_main_category($cat_name = FALSE, $cat_value = FALSE) 
    {
        $ins_data = array(
            'category_name' => $cat_name,
            'value' => $cat_value
        );
        if ($this->db->insert(TAB_SITE_CATEGORIES, $ins_data)) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch
     * @param :
     * @return :all the creatives details need to be approve
     *
    */
    public function fetch() 
    {
        $this->db->where('is_deleted', 0);
        $this->db->where_not_in('parent_category_id', '0');
        $query = $this->db->get(TAB_SITE_CATEGORIES);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_select
     * @param : category_id
     * @return :categoryname,categoryvalue
     *
    */
    public function fetch_select($cat_id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('category_id', $cat_id);
        $query = $this->db->get(TAB_SITE_CATEGORIES);
        $result = $query->result_array();
        return $result;
    }
    /*
     *
     * name: update_category
     * @param : categoryname,categoryvalue,categoryid
     * @return : category id
     *
    */
    public function update_category($category_info = FALSE) 
    {
        $catObj = array(
            'category_name' => $category_info['category_name']
        );
        if (!empty($catObj)) {
            $this->db->where('category_id', $category_info['category_id']);
            $this->db->update(TAB_SITE_CATEGORIES, $catObj);
            return $category_info['category_id'];
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: delete_category
     * @param : categoryid
     * @return : status true or false
     *
    */
    public function delete_category($cat_id = FALSE) 
    {
        if ($cat_id) {
            $data = array(
                'is_deleted' => 1
            );
            $this->db->where('category_id', $cat_id);
            $this->db->update(TAB_SITE_CATEGORIES, $data);
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: add_os
     * @param : osname,osvalue
     * @return :lastinsertid
     *
    */
    public function add_os($device_os = FALSE, $os_value = FALSE) 
    {
        $osObj = array(
            "name" => $device_os,
            "value" => $os_value,
        );
        if ($this->db->insert(TAB_TARG_OS, $osObj)) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_os
     * @param :
     * @return :all the os details.
     *
    */
    public function fetch_os() 
    {
        $query = $this->db->get(TAB_TARG_OS);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_os_select
     * @param : os id
     * @return :selected os details.
     *
    */
    public function fetch_os_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_TARG_OS);
        $result = $query->result_array();
        return $result;
    }
    /*
     *
     * name: update_os
     * @param : osname,osvalue,osid
     * @return : os id
     *
    */
    public function update_os($os_info = FALSE) 
    {
        $osObj = array(
            'name' => $os_info['device_os'],
            'value' => $os_info['os_value']
        );
        if (!empty($osObj)) {
            $this->db->where('id', $os_info['os_id']);
            $this->db->update(TAB_TARG_OS, $osObj);
            return $os_info['os_id'];
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: delete_os
     * @param : os_id
     * @return : status true or false
     *
    */
    public function delete_os($id = FALSE) 
    {
        if ($id) {
            $this->db->where('id', $id);
            $this->db->delete(TAB_TARG_OS);
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: add_browser
     * @param : browsername,browservalue
     * @return :lastinsertid
     *
    */
    public function add_browser($browser_info = FALSE) 
    {
        $browserObj = array(
            "name" => $browser_info['browser_name'],
            "value" => $browser_info['browser_code']
        );
        if ($this->db->insert(TAB_TARG_BROWSERS, $browserObj)) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_browser
     * @param :
     * @return :all the browser details.
     *
    */
    public function fetch_browser() 
    {
        $query = $this->db->get(TAB_TARG_BROWSERS);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_browser_select
     * @param : browser_id
     * @return :slected  browser details.
     *
    */
    public function fetch_browser_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_TARG_BROWSERS);
        $result = $query->result_array();
        return $result;
    }
    /*
     *
     * name: update_browser
     * @param : browsername,browservalue,browserid
     * @return : category id
     *
    */
    public function update_browser($browser_info = FALSE) 
    {
        $browserObj = array(
            "name" => $browser_info['browser_name'],
            "value" => $browser_info['browser_code']
        );
        if (!empty($browserObj)) {
            $this->db->where('id', $browser_info['browser_id']);
            $this->db->update(TAB_TARG_BROWSERS, $browserObj);
            return $browser_info['browser_id'];
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: delete_browser
     * @param : browserid
     * @return : status true or false
     *
    */
    public function delete_browser($id = FALSE) 
    {
        if ($id) {
            $this->db->where('id', $id);
            $this->db->delete(TAB_TARG_BROWSERS);
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: add_manu
     * @param : manuname,manuvalue
     * @return :lastinsertid
     *
    */
    public function add_manu($manu_info = FALSE) 
    {
        $manuObj = array(
            "name" => $manu_info['manu_name'],
            "value" => $manu_info['manu_value']
        );
        if ($this->db->insert(TAB_MOB_MANUFACT, $manuObj)) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_manu
     * @param :
     * @return :all the manufacturers details.
     *
    */
    public function fetch_manu() 
    {
        $query = $this->db->get(TAB_MOB_MANUFACT);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_manu_select
     * @param : manufacturers id
     * @return :all the selected manufacturers details.
     *
    */
    public function fetch_manu_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_MOB_MANUFACT);
        $result = $query->result_array();
        return $result;
    }
    /*
     *
     * name: update_manu
     * @param : manufacturers name,manufacturers value,manufacturers id
     * @return : category id
     *
    */
    public function update_manu($manu_info = FALSE) 
    {
        $manuObj = array(
            "name" => $manu_info['manu_name'],
            "value" => $manu_info['manu_value']
        );
        if (!empty($manuObj)) {
            $this->db->where('id', $manu_info['manu_id']);
            $this->db->update(TAB_MOB_MANUFACT, $manuObj);
            return $manu_info['manu_id'];
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: delete_manu
     * @param : manufacturers id
     * @return : status true or false
     *
    */
    public function delete_manu($id = FALSE) 
    {
        if ($id) {
            $this->db->where('id', $id);
            $this->db->delete(TAB_MOB_MANUFACT);
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        } else {
            return FALSE;
        }
    }
    /* Mobile Targeting */
    /*
     *
     * name: add_mobile_os
     * @param : Mobile osname, Mobile osvalue
     * @return :lastinsertid
     *
    */
    public function add_mobile_os($device_os = FALSE, $os_value = FALSE) 
    {
        $osObj = array(
            "name" => $device_os,
            "value" => $os_value,
        );
        if ($this->db->insert(TAB_TARG_MOB_OS, $osObj)) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_os
     * @param :
     * @return :all the os details.
     *
    */
    public function fetch_mobile_os() 
    {
        $query = $this->db->get(TAB_TARG_MOB_OS);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_mobile_os_select
     * @param : os id
     * @return :selected os details.
     *
    */
    public function fetch_mobile_os_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_TARG_MOB_OS);
        $result = $query->result_array();
        return $result;
    }
    /*
     *
     * name: update_mobile_os
     * @param : osname,osvalue,osid
     * @return : os id
     *
    */
    public function update_mobile_os($os_info = FALSE) 
    {
        $osObj = array(
            'name' => $os_info['device_os'],
            'value' => $os_info['os_value']
        );
        if (!empty($osObj)) {
            $this->db->where('id', $os_info['os_id']);
            $this->db->update(TAB_TARG_MOB_OS, $osObj);
            return $os_info['os_id'];
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: delete_mobile_os
     * @param : os_id
     * @return : status true or false
     *
    */
    public function delete_mobile_os($id = FALSE) 
    {
        if ($id) {
            $this->db->where('id', $id);
            $this->db->delete(TAB_TARG_MOB_OS);
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: add_mobile_manufacturers
     * @param : manuname,manuvalue
     * @return :lastinsertid
     *
    */
    public function add_mobile_manufacturers($manufact_name = FALSE, $manufact_value = FALSE) 
    {
        $manuObj = array(
            "name" => $manufact_name,
            "value" => $manufact_value,
        );
        if ($this->db->insert(TAB_TARG_MOB_MANU, $manuObj)) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_mobile_manufacturers
     * @param :
     * @return :all the manufacturers details.
     *
    */
    public function fetch_mobile_manufacturers() 
    {
        $query = $this->db->get(TAB_TARG_MOB_MANU);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_mobile_manufacturer_select
     * @param : manufacturers id
     * @return :all the selected manufacturers details.
     *
    */
    public function fetch_mobile_manufacturers_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_TARG_MOB_MANU);
        $result = $query->result_array();
        return $result;
    }
    /*
     *
     * name: update_mobile_manufacturers
     * @param : manufacturers name,manufacturers value,manufacturers id
     * @return : category id
     *
    */
    public function update_mobile_manufacturers($manu_info = FALSE) 
    {
        $manuObj = array(
            "name" => $manu_info['manu_name'],
            "value" => $manu_info['manu_value']
        );
        if (!empty($manuObj)) {
            $this->db->where('id', $manu_info['manu_id']);
            $this->db->update(TAB_TARG_MOB_MANU, $manuObj);
            return $manu_info['manu_id'];
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: delete_mobile_manufacturers
     * @param : manufacturers id
     * @return : status true or false
     *
    */
    public function delete_mobile_manufacturers($id = FALSE) 
    {
        if ($id) {
            $this->db->where('id', $id);
            $this->db->delete(TAB_TARG_MOB_MANU);
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: add_mobile_capability
     * @param : Mobile capability name, Mobile capability value
     * @return :lastinsertid
     *
    */
    public function add_mobile_capability($capability_name = FALSE, $capability_value = FALSE) 
    {
        $capabilityObj = array(
            "name" => $capability_name,
            "value" => $capability_value,
        );
        if ($this->db->insert(TAB_TARG_MOB_CAPA, $capabilityObj)) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
    }
    public function check_mobile_capability($capability_name = FALSE, $capability_value = FALSE)
    {
		$this->db->select('*');
		$this->db->where('name ', $capability_name);
		$this->db->where('value', $capability_value);
		$query = $this->db->get(TAB_TARG_MOB_CAPA);
		return $query->num_rows();
	}
	function capability_targeting_check($table_name,$value,$name,$id)
	{
		$this->db->select('*');	
		$this->db->where("value",$value);
		$this->db->where("name",$name);
		$this->db->where_not_in('id',$id);
		$query_count	=	$this->db->get($table_name)->num_rows();
		
		if($query_count)
		{			
			return $query_count;
		}
		else
		{
			return FALSE;
		} 	
	}
    /*
     *
     * name: fetch_capability
     * @param :
     * @return :all the capability details.
     *
    */
    public function fetch_mobile_capability() 
    {
        $query = $this->db->get(TAB_TARG_MOB_CAPA);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: fetch_mobile_capability_select
     * @param : capability id
     * @return :selected capability details.
     *
    */
    public function fetch_mobile_capability_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_TARG_MOB_CAPA);
        $result = $query->result_array();
        return $result;
    }
    /*
     *
     * name: update_mobile_capability
     * @param : capabilityname,capabilityvalue,capabilityid
     * @return : capability id
     *
    */
    public function update_mobile_capability($capability_info = FALSE) 
    {
        $capabilityObj = array(
            'name' => $capability_info['capability_name'],
            'value' => $capability_info['capability_value']
        );
        if (!empty($capabilityObj)) {
            $this->db->where('id', $capability_info['capability_id']);
            $this->db->update(TAB_TARG_MOB_CAPA, $capabilityObj);
            return $capability_info['capability_id'];
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: delete_mobile_capability
     * @param : os_id
     * @return : status true or false
     *
    */
    public function delete_mobile_capability($id = FALSE) 
    {
        if ($id) {
            $this->db->where('id', $id);
            $this->db->delete(TAB_TARG_MOB_CAPA);
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: block_category
     * @param : categoryid
     * @return : categoryid
     *
    */
    public function block_category($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 1
            );
            $this->db->where('category_id', $id);
            $this->db->update(TAB_SITE_CATEGORIES, $data);
            return $id;
        }
    }
    /*
     *
     * name: unblock_category
     * @param : categoryid
     * @return : categoryid
     *
    */
    public function unblock_category($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 0
            );
            $this->db->where('category_id', $id);
            $this->db->update(TAB_SITE_CATEGORIES, $data);
            return $id;
        }
    }
    /*
     *
     * name: block_os
     * @param : osid
     * @return : osid
     *
    */
    public function block_os($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 1
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_OS, $data);
            return $id;
        }
    }
    /*
     *
     * name: unblock_os
     * @param : osid
     * @return : osid
     *
    */
    public function unblock_os($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 0
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_OS, $data);
            return $id;
        }
    }
    /*
     *
     * name: block_browser
     * @param : browser id
     * @return :browserid
     *
    */
    public function block_browser($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 1
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_BROWSERS, $data);
            return $id;
        }
    }
    /*
     *
     * name: block_browser
     * @param : browser id
     * @return :browserid
     *
    */
    public function unblock_browser($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 0
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_BROWSERS, $data);
            return $id;
        }
    }
    /* domain block unblock operation */
    /*
     *
     * name: block_domain
     * @param : domain id
     * @return :domainid
     *
    */
    public function block_domain($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 1
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_DOMAIN, $data);
            return $id;
        }
    }
    /*
     *
     * name: block_domain
     * @param : domain id
     * @return :domain id
     *
    */
    public function unblock_domain($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 0
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_DOMAIN, $data);
            return $id;
        }
    }
    /* End domain block unblock operation */
    /* domain delete operation*/
    /* domain delete operation*/
    /*
     *
     * name: block_manu
     * @param :manu id
     * @return :manu id
     *
    */
    public function block_manu($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 1
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_MOB_MANUFACT, $data);
            return $id;
        }
    }
    /*
     *
     * name: block_manu
     * @param : manu id
     * @return :manu id
     *
    */
    public function unblock_manu($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 0
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_MOB_MANUFACT, $data);
            return $id;
        }
    }
    /*
     *
     * name: block_os
     * @param : osid
     * @return : osid
     *
    */
    public function mobile_block_os($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 1
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_MOB_OS, $data);
            return $id;
        }
    }
    /*
     *
     * name: unblock_os
     * @param : osid
     * @return : osid
     *
    */
    public function mobile_unblock_os($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 0
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_MOB_OS, $data);
            return $id;
        }
    }
    /*
     *
     * name: mobile_block_manu
     * @param :manu id
     * @return :manu id
     *
    */
    public function mobile_block_manu($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 1
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_MOB_MANU, $data);
            return $id;
        }
    }
    /*
     *
     * name: block_manu
     * @param : manu id
     * @return :manu id
     *
    */
    public function mobile_unblock_manu($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 0
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_MOB_MANU, $data);
            return $id;
        }
    }
    /*
     *
     * name: mobile_block_manu
     * @param :manu id
     * @return :manu id
     *
    */
    public function mobile_block_capability($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 1
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_MOB_CAPA, $data);
            return $id;
        }
    }
    /*
     *
     * name: block_manu
     * @param : manu id
     * @return :manu id
     *
    */
    public function mobile_unblock_capability($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 0
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_MOB_CAPA, $data);
            return $id;
        }
    }
    /*
     *
     * name: fetch_telecom_values
     * @param :
     * @return :all the telecom operators details.
     *
    */
    public function fetch_telecom_values() 
    {
		$this->db->select('teleco.*,cty.name as Country');
		$this->db->from(TAB_TARG_MOBILE_CARRIER.' as teleco ');
		$this->db->join(TAB_TARG_COUNTRY.' as cty ', 'cty.value=teleco.country');
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: block_telecom
     * @param :
     * @return :block selected telecom operator.
     *
    */
    public function block_telecom($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'status' => 0
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_MOBILE_CARRIER, $data);
            return $id;
        }
    }
    /*
     *
     * name: unblock_telecom
     * @param :
     * @return :unblock selected telecom operator.
     *
    */
    public function unblock_telecom($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'status' => 1
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_MOBILE_CARRIER, $data);
            return $id;
        }
    }
    /*
     *
     * name: check_ip_exist
     * @param :
     * @return :check for already exixt ip's.
     *
    */
    public function check_ip_exist($start_ip = FALSE, $end_ip = FALSE, $country, $carriername) 
    {
        $this->db->select('*');
        $this->db->where('start_ip', $start_ip);
        $this->db->where('end_ip', $end_ip);
        //$this->db->where('country',$country);
        $query = $this->db->get(TAB_TARG_MOBILE_CARRIER);
        #echo $this->db->last_query();exit;
        if ($query->num_rows() > 0) {
            return '1';
            /*$this->db->select('*');
            $this->db->where('start_ip', $start_ip);
            $this->db->where('end_ip', $end_ip);
            $query = $this->db->get(TAB_TARG_MOBILE_CARRIER);
            if($query->num_rows()>0)
            {
            return '1';
            }
            else
            {
            return '0';
            }*/
        } else {
            return '0';
        }
    }
    /*
     *
     * name: insert_tele_data
     * @param :
     * @return :insert telecom operator data.
     *
    */
    public function insert_tele_data($ins_data = FALSE) 
    {
        $this->db->insert(TAB_TARG_MOBILE_CARRIER, $ins_data);
        return TRUE;
    }
    /*
     *
     * name: update_tele_data
     * @param :
     * @return :update already existing record with different country name.
     *
    */
    public function update_tele_data($start_ip = FALSE, $end_ip = FALSE, $up_data = FALSE) 
    {
        $this->db->where('start_ip', $start_ip);
        $this->db->where('end_ip', $end_ip);
        $this->db->update(TAB_TARG_MOBILE_CARRIER, $up_data);
        return TRUE;
    }
    /*
     *
     * name: fetch_main_category
     * @param :
     * @return :all the creatives details need to be approve
     *
    */
    public function fetch_main_category() 
    {
        $this->db->where('parent_category_id', '0');
        $this->db->where('is_deleted', 0);
        $query = $this->db->get(TAB_SITE_CATEGORIES);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }

    public function update_category_value($category = FALSE, $final_cat = FALSE)
    {
        $this->db->where('category_id', $category);
        $updata = array(
            'value' => $final_cat
        );
        $this->db->update(TAB_SITE_CATEGORIES, $updata);
    }

    public function dup_category_name_chk($cat_id = FALSE, $cat_name = FALSE)
    {
        $this->db->select('category_name');
        $this->db->where('category_name', $cat_name);
        $this->db->where_not_in('category_id', $cat_id);
        $query = $this->db->get(TAB_SITE_CATEGORIES)->num_rows();
        #echo $this->db->last_query();exit;

        #$query_count	=	$this->db->query($query)->num_rows();
        if ($query) {
            return $query;
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: update_main_category
     * @param : categoryname,categoryvalue,categoryid
     * @return : category id
     *
    */
    public function update_main_category($category_info = FALSE) 
    {
        $catObj = array(
            'category_name' => $category_info['category_name']
        );
        if (!empty($catObj)) {
            $this->db->where('category_id', $category_info['category_id']);
            $this->db->update(TAB_SITE_CATEGORIES, $catObj);
            return $category_info['category_id'];
        } else {
            return FALSE;
        }
    }
    /*
     *
     * Check For Parent Category
    */
    function check_category($cat_id = FALSE) 
    {
        $this->db->select('parent_category_id,value');
        $this->db->where('category_id', $cat_id);
        $query = $this->db->get(TAB_SITE_CATEGORIES);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
    /*
     *
     *
     *
    */
    public function delete_assoc_category($cat_id = FALSE, $par_val = FALSE) 
    {
        /* Delete Child Category */
        $this->db->where('parent_category_id', $par_val);
        $this->db->delete(TAB_SITE_CATEGORIES);
        /* Delete Parent Category */
        $this->db->where('category_id', $cat_id);
        $this->db->delete(TAB_SITE_CATEGORIES);
    }

    function check_category_root($par_val = FALSE)
    {
        $this->db->select('category_name,value');
        $this->db->where('value', $par_val);
        $query = $this->db->get(TAB_SITE_CATEGORIES);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
    
     /*
     *function- fetch_country_by_val
     *Used to fetch the country with carrier & ip by suganiya.R on 05-03-2016
     *
    */
    
     function fetch_country_by_val($val = FALSE) 
    {

       	$this->db->select("DISTINCT start_ip as text,CONCAT(country,'|',carriername,'_',start_ip) as id,carriername as name", false);
       //~ $this->db->select('start_ip as id,start_ip as text,carriername as name,GROUP_CONCAT(DISTINCT start_ip) as id', false);
        $this->db->where_in('country', $val);
        if ($search != 'stop' && !empty($search))
        {
            $this->db->like('start_ip', $search);
        }
        $this->db->group_by('start_ip');
        $this->db->order_by('country','ASC');
        $query = $this->db->get_where('djax_targ_carrier_detail',array('start_ip !='=>' '));
    //~ return $this->db->last_query();
        if ($query->num_rows() > 0)
        { 
            return $query->result_array();
        }
        else
        {
            return FALSE;
        }
 
    }	
    
    
     function fetch_mob_cap_val() 
    {

       	$this->db->select("value as text,CONCAT(name,'|',value) as id,name", false);
     //~ //  $this->db->select('start_ip as id,start_ip as text,carriername as name,GROUP_CONCAT(DISTINCT start_ip) as id', false);
      
        if ($search != 'stop' && !empty($search))
        {
            $this->db->like('name', $search);
        }
       
        $this->db->order_by('name','ASC');
        $query = $this->db->get_where('djax_targ_mobile_capability');

        if ($query->num_rows() > 0)
        { 
            return $query->result_array();
        }
        else
        {
            return FALSE;
        }
 
    }		
	 /*
     *function- fetch_targ_time_options
     *Used to fetch the time zone
     *
    */
	public function fetch_targ_time_options()
    {
	  $this->db->order_by('timezone','ASC');
	  $query = $this->db->get(TAB_TZ);
	  if($query->num_rows()>0){
	 	 $result=$query->result_array();
	 	 return $result;
	  }
	  else
	  {
	    return FALSE;
	  }
	}
		 /*function:fetch targeting options for city
    
     */
     function fetch_targ_options_city_mob($type = FALSE, $countryval = FALSE)
    {
      
        $parentosvalue = explode(",", $countryval);
        
        /*for ($i = 0; $i < count($parentosvalue); $i++) {
            $this->db->select('id');
            
            $this->db->where('value', $parentosvalue[$i]);
            $this->db->where('parent_os_id', 0);
            $query  = $this->db->get(TAB_TARG_MOB_OS);
            $osid[] = $query->row();
        }*/
        
        for ($i = 0; $i < count($parentosvalue); $i++) {
            
            $this->db->select('city as id, city as text');
            //$this->db->where('id',  $osid[$i]);
            $this->db->where('country', $parentosvalue[$i]);
            
            $query = $this->db->get_where('geoipcity',array('city !='=>' '));
            	//return $this->db->last_query();	;
            if ($query->num_rows() != 0) {
			
                $cityres = $query->result_array();
                for ($j = 0; $j < count($cityres); $j++) {
                    
                    $city[] = $cityres[$j];
                }
            }
            
        }
        return $city;
    } 
    function fetch_targ_options_tele_mob($type = FALSE, $countryval = FALSE)
    {
      
        $parentosvalue = explode(",", $countryval);
        
        /*for ($i = 0; $i < count($parentosvalue); $i++) {
            $this->db->select('id');
            
            $this->db->where('value', $parentosvalue[$i]);
            $this->db->where('parent_os_id', 0);
            $query  = $this->db->get(TAB_TARG_MOB_OS);
            $osid[] = $query->row();
        }*/
        
        for ($i = 0; $i < count($parentosvalue); $i++) {
            
            $this->db->select('start_ip as text,start_ip as id');
            //$this->db->where('id',  $osid[$i]);
            $this->db->where('country', $parentosvalue[$i]);
            
            $query = $this->db->get_where('djax_targ_carrier_detail',array('start_ip !='=>' '));
            	//return $this->db->last_query();	;
            if ($query->num_rows() != 0) {
			
                $cityres = $query->result_array();
                for ($j = 0; $j < count($cityres); $j++) {
                    
                    $city[] = $cityres[$j];
                }
            }
            
        }
        return $city;
    } 
    
     /*function:fetch targeting country by city
    
     */
    function fetch_targ_countrymob_data($type = false, $campaign_id = false)
    {
		
        $this->db->trans_start();
        /*Insert in ox_acls */
        $this->db->select('data');
        $this->db->where('campaignid ', $campaign_id);
        $this->db->where('type', $type);
        $query = $this->db->get(TAB_ACLS);
         if ($query->num_rows() > 0)
        { 
            return $query->result_array();
        }
        else
        {
            return FALSE;
        }
      
        
    }
    function fetch_city_by_val($val=FALSE,$search = false)
	{			
        $this->db->select("DISTINCT city as text,CONCAT(country,'|',city) as id,dcon.name as country", false);
        $this->db->join('djax_conf_targ_country as dcon','dcon.value=geoipcity.country');
        $this->db->where_in("country", $val);
         if ($search != 'stop' && !empty($search))
        {
            $this->db->like('city', $search);
        }
        $this->db->group_by('city');
        $this->db->order_by('country','ASC');
        $query = $this->db->get_where('geoipcity',array('city !='=>' '));
    //return $this->db->last_query();
        if ($query->num_rows() > 0)
        { 
            return $query->result_array();
        }
        else
        {
            return FALSE;
        }
		
	}
	/*
     * 
     * name: add_keyword
     * @param : 
     * @return :add the keyword details.
     * 
     */
    public function add_keyword($keydata = FALSE)
    {
        $this->db->insert(TAB_TARG_KEYWORD, $keydata);
        if ($this->db->affected_rows())
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }
    /*
     * 
     * name: update_keyword
     * @param : 
     * @return :update the keyword details.
     * 
     */
    public function update_keyword($id = FALSE, $keydata = FALSE)
    {
        if ($id != FALSE)
        {
            $this->db->where('id', $id);
        }
        $this->db->update(TAB_TARG_KEYWORD, $keydata);
        return TRUE;
    }
     /*
     * 
     * name: fetch_keyword
     * @param : 
     * @return :all the keyword details.
     * 
     */
    public function fetch_keyword($keyword_id = FALSE)
    {
        if ($keyword_id != FALSE)
        {
            $this->db->where('id', $keyword_id);
        }
        $this->db->where('is_deleted', '0');
        $query = $this->db->get(TAB_TARG_KEYWORD);
        if ($query->num_rows() > 0)
        {
            return $query->result_array();
        }
        else
        {
            return FALSE;
        }
    }
     /*
     * 
     * name: delete_keyword
     * @param : keywordid
     * @return : status true or false
     * 
     */
    public function delete_keyword($id = FALSE)
    {
        if ($id != FALSE)
        {
            $this->db->where('id', $id);
        }
        $data = array(
            'is_deleted' => 1
        );
        $this->db->update(TAB_TARG_KEYWORD, $data);
        if ($this->db->affected_rows())
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }
     /*
     * 
     * name: block_keyword
     * @param : 
     * @return :block the keyword details.
     * 
     */
    public function block_keyword($id = FALSE)
    {
        if ($id != FALSE)
        {
            $this->db->where('id', $id);
        }
        $keydata = array(
            'is_blocked' => '1'
        );
        $this->db->update(TAB_TARG_KEYWORD, $keydata);
        if ($this->db->affected_rows())
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }
    /*
     * 
     * name: unblock_keyword
     * @param : 
     * @return :unblock the keyword details.
     * 
     */
    public function unblock_keyword($id = FALSE)
    {
        if ($id != FALSE)
        {
            $this->db->where('id', $id);
        }
        $keydata = array(
            'is_blocked' => '0'
        );
        $this->db->update(TAB_TARG_KEYWORD, $keydata);
        if ($this->db->affected_rows())
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }

    /*
     *
     * name: fetch_segment
     * @param :
     * @return :all the segment details.
     *
    */
    public function fetch_segment() 
    {
        $query = $this->db->get(TAB_TARG_SEGMENT);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
     /*
     *
     * name: block_segment
     * @param : segmentid
     * @return : segmentid
     *
    */
    public function block_segment($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'status' => 0,
                'is_blocked' => 1
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_SEGMENT, $data);
            return $id;
        }
    }
     /*
     *
     * name: unblock_segment
     * @param : segmentid
     * @return : segmentid
     *
    */
    public function unblock_segment($id = FALSE) 
    {
        if ($id) {
            $data = array(
                 'status' => 1,
                'is_blocked' => 0
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_SEGMENT, $data);
            return $id;
        }
    }
     /*
     *
     * name: delete_segment
     * @param : seg_id
     * @return : status true or false
     *
    */
    public function delete_segment($id = FALSE) 
    {
        if ($id) {
            $this->db->where('id', $id);
            $this->db->delete(TAB_TARG_SEGMENT);
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        } else {
            return FALSE;
        }
    }
     /*
     *
     * name: fetch_segment_select
     * @param : segment id
     * @return :selected segment details.
     *
    */
    public function fetch_segment_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_TARG_SEGMENT);
        $result = $query->result_array();
        return $result;
    }
     /*
     *
     * name: add_segment
     * @param : segmentname,segmentvalue
     * @return :lastinsertid
     *
    */
    public function add_segment($seg_name = FALSE, $seg_desc = FALSE, $upload_seg = FALSE,$upload_path = FALSE) 
    {
        $segObj = array(
            "name" => $seg_name,
            "seg_desc" => $seg_desc,
            "value" => $seg_name,
            "filename" => $upload_seg,
            "upload_path" => $upload_path,
            "status" => 1,
            "is_blocked" => 0,
            "created_date"=> Date('Y-m-d H:i:s')
        );
        if ($this->db->insert(TAB_TARG_SEGMENT, $segObj)) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
    }
    /*
     *
     * name: update_segment
     * @param : segmentname,segmentvalue,segment file
     * @return : segment id
     *
    */
    public function update_segment($seg_info = FALSE,$file_id = FALSE,$file_path = FALSE) 
    {
        $segObj = array(
            'name' => $seg_info['seg_name'],
            'seg_desc' => $seg_info['seg_desc'],
            'value' => $seg_info['seg_name'],
            'filename' => $file_id,
            'upload_path' => $file_path
        );
       // return $segObj;
        if (!empty($segObj)) {
            $this->db->where('id', $seg_info['seg_id']);
            $this->db->update(TAB_TARG_SEGMENT, $segObj);
            return $seg_info['seg_id'];
        } else {
            return FALSE;
        }
    } 
    
    
    public function add_site($siteinfo)
    { 
		
		$siteObj = array(
            "name" => $siteinfo['site_name'],
            "value" => $siteinfo['site_value']
        );
        if ($this->db->insert(TAB_TARG_SITES, $siteObj)) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
	}
	  public function fetch_site() 
    {
        $query = $this->db->get(TAB_TARG_SITES);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
     public function fetch_site_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_TARG_SITES);
        $result = $query->result_array();
        return $result;
    }
    
     public function update_site($site_info = FALSE) 
    {
        $siteObj = array(
            "name" => $site_info['site_name'],
            "value" => $site_info['site_value']
        );
        if (!empty($siteObj)) {
            $this->db->where('id', $site_info['site_id']);
            $this->db->update(TAB_TARG_SITES, $siteObj);
            return $site_info['site_id'];
        } else {
            return FALSE;
        }
    }
    public function delete_site($id = FALSE) 
    {
        if ($id) {
            $this->db->where('id', $id);
            $this->db->delete(TAB_TARG_SITES);
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        } else {
            return FALSE;
        }
    }
    
    public function block_site($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 1
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_SITES, $data);
            return $id;
        }
    }
    
    public function unblock_site($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 0
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_SITES, $data);
            return $id;
        }
    }
    
     public function add_sentiment($sentimentinfo)
    { 
		
		$sentimentObj = array(
            "name" => $sentimentinfo['sentiment_name'],
            "value" => $sentimentinfo['sentiment_value']
        );
        if ($this->db->insert(TAB_TARG_SENTIMENTS, $sentimentObj)) {
            return $this->db->insert_id();
        } else {
            return FALSE;
        }
	}
	  public function fetch_sentiment() 
    {
        $query = $this->db->get(TAB_TARG_SENTIMENTS);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
     public function fetch_sentiment_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_TARG_SENTIMENTS);
        $result = $query->result_array();
        return $result;
    }
    
    public function update_sentiment($sentiment_info = FALSE) 
    {
        $sentimentObj = array(
            "name" => $sentiment_info['sentiment_name'],
            "value" => $sentiment_info['sentiment_value']
        );
        if (!empty($sentimentObj)) {
            $this->db->where('id', $sentiment_info['sentiment_id']);
            $this->db->update(TAB_TARG_SENTIMENTS, $sentimentObj);
            return $sentiment_info['sentiment_id'];
        } else {
            return FALSE;
        }
    }
    public function delete_sentiment($id = FALSE) 
    {
        if ($id) {
            $this->db->where('id', $id);
            $this->db->delete(TAB_TARG_SENTIMENTS);
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        } else {
            return FALSE;
        }
    }
    
    public function block_sentiment($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 1
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_SENTIMENTS, $data);
            return $id;
        }
    }
    
    public function unblock_sentiment($id = FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 0
            );
            $this->db->where('id', $id);
            $this->db->update(TAB_TARG_SENTIMENTS, $data);
            return $id;
        }
    }
	
	public function add_custom_targeting1($custominfo)
	{
		$customObj = array(
            "name" => $custominfo['custom_name'],
            "value" => $custominfo['custom_value']
        );
        if ($this->db->insert(TAB_CUSTOM_TARGETING1, $customObj)) 
		{
            return $this->db->insert_id();
        } 
		else
		{
            return FALSE;
		}
	}
	
	public function fetch_custom_targeting1()
	{
		$query = $this->db->get(TAB_CUSTOM_TARGETING1);
        if ($query->num_rows() > 0) 
		{
            $result = $query->result_array();
            return $result;
        }
		else
		{
            return FALSE;
        }
	}
	
	 public function fetch_custom_targeting1_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_CUSTOM_TARGETING1);
        $result = $query->result_array();
        return $result;
    }
	
	public function update_custom_targeting1($target_info = FALSE) 
    {
        $customObj = array(
            "name" => $target_info['custom_name'],
            "value" => $target_info['custom_value']
        );
        if (!empty($customObj)) {
            $this->db->where('id', $target_info['target_id']);
            $this->db->update(TAB_CUSTOM_TARGETING1, $customObj);
            return $target_info['target_id'];
        } else {
            return FALSE;   
        }
    } 
	
	public function add_custom_targeting2($custominfo)
	{
		$customObj = array(
            "name" => $custominfo['custom_name'],
            "value" => $custominfo['custom_value']
        );
        if ($this->db->insert(TAB_CUSTOM_TARGETING2, $customObj)) 
		{
            return $this->db->insert_id();
        } 
		else
		{
            return FALSE;
		}
	}
	
	public function fetch_custom_targeting2()
	{
		$query = $this->db->get(TAB_CUSTOM_TARGETING2);
        if ($query->num_rows() > 0) 
		{
            $result = $query->result_array();
            return $result;
        }
		else
		{
            return FALSE;
        }
	}
	
	 public function fetch_custom_targeting2_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_CUSTOM_TARGETING2);
        $result = $query->result_array();
        return $result;
    }
	
	public function update_custom_targeting2($target_info = FALSE) 
    {
        $customObj = array(
            "name" => $target_info['custom_name'],
            "value" => $target_info['custom_value']
        );
        if (!empty($customObj)) {
            $this->db->where('id', $target_info['target_id']);
            $this->db->update(TAB_CUSTOM_TARGETING2, $customObj);
            return $target_info['target_id'];
        } else {
            return FALSE;   
        }
    } 
	
	public function add_custom_targeting3($custominfo)
	{
		$customObj = array(
            "name" => $custominfo['custom_name'],
            "value" => $custominfo['custom_value']
        );
        if ($this->db->insert(TAB_CUSTOM_TARGETING3, $customObj)) 
		{
            return $this->db->insert_id();
        } 
		else
		{
            return FALSE;
		}
	}
	
	public function fetch_custom_targeting3()
	{
		$query = $this->db->get(TAB_CUSTOM_TARGETING3);
        if ($query->num_rows() > 0) 
		{
            $result = $query->result_array();
            return $result;
        }
		else
		{
            return FALSE;
        }
	}
	
	 public function fetch_custom_targeting3_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_CUSTOM_TARGETING3);
        $result = $query->result_array();
        return $result;
    }
	
	public function update_custom_targeting3($target_info = FALSE) 
    {
        $customObj = array(
            "name" => $target_info['custom_name'],
            "value" => $target_info['custom_value']
        );
        if (!empty($customObj)) {
            $this->db->where('id', $target_info['target_id']);
            $this->db->update(TAB_CUSTOM_TARGETING3, $customObj);
            return $target_info['target_id'];
        } else {
            return FALSE;   
        }
    }
	
	public function add_custom_targeting4($custominfo)
	{
		$customObj = array(
            "name" => $custominfo['custom_name'],
            "value" => $custominfo['custom_value']
        );
        if ($this->db->insert(TAB_CUSTOM_TARGETING4, $customObj)) 
		{
            return $this->db->insert_id();
        } 
		else
		{
            return FALSE;
		}
	}
	
	public function fetch_custom_targeting4()
	{
		$query = $this->db->get(TAB_CUSTOM_TARGETING4);
        if ($query->num_rows() > 0) 
		{
            $result = $query->result_array();
            return $result;
        }
		else
		{
            return FALSE;
        }
	}
	
	 public function fetch_custom_targeting4_select($id = FALSE) 
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $query = $this->db->get(TAB_CUSTOM_TARGETING4);
        $result = $query->result_array();
        return $result;
    }
	
	public function update_custom_targeting4($target_info = FALSE) 
    {
        $customObj = array(
            "name" => $target_info['custom_name'],
            "value" => $target_info['custom_value']
        );
        if (!empty($customObj)) {
            $this->db->where('id', $target_info['target_id']);
            $this->db->update(TAB_CUSTOM_TARGETING4, $customObj);
            return $target_info['target_id'];
        } else {
            return FALSE;   
        }
    }

	public function delete_custom_targeting($id = FALSE,$table=FALSE) 
    {	
        if ($id)
		{
			$this->db->where('id', $id);
			if($table=="TAB_CUSTOM_TARGETING1")
			{  
				$this->db->delete(TAB_CUSTOM_TARGETING1);
			}
			else if($table=="TAB_CUSTOM_TARGETING2")
			{  
				$this->db->delete(TAB_CUSTOM_TARGETING2);
			}
			else if($table=="TAB_CUSTOM_TARGETING3")
			{  
				$this->db->delete(TAB_CUSTOM_TARGETING3);
			}	
			else if($table=="TAB_CUSTOM_TARGETING4")
			{  
				$this->db->delete(TAB_CUSTOM_TARGETING4);
			}	
			
			if ($this->db->trans_status() === FALSE)
			{  
                $this->db->trans_rollback();
            } 
			else 
			{  
                $this->db->trans_commit();
            }
        } 
		else 
		{
            return FALSE;
        }
    }
	
	 public function block_custom_targeting($id = FALSE,$table=FALSE) 
    {
       if ($id) {
            $data = array(
                'is_blocked' => 1
            );
            $this->db->where('id', $id);
			if($table=="TAB_CUSTOM_TARGETING1")
			{  
				$this->db->update(TAB_CUSTOM_TARGETING1,$data);
			}
			else if($table=="TAB_CUSTOM_TARGETING2")
			{  
				$this->db->update(TAB_CUSTOM_TARGETING2,$data);
			}	
			else if($table=="TAB_CUSTOM_TARGETING3")
			{  
				$this->db->update(TAB_CUSTOM_TARGETING3,$data);
			}	
			else if($table=="TAB_CUSTOM_TARGETING4")
			{  
				$this->db->update(TAB_CUSTOM_TARGETING4,$data);
			}	
            //$this->db->update($table, $data);
            return $id;
        }
    }
	
	
	public function unblock_custom_targeting($id = FALSE,$table=FALSE) 
    {
        if ($id) {
            $data = array(
                'is_blocked' => 0
            );
            $this->db->where('id', $id);
            if($table=="TAB_CUSTOM_TARGETING1")
			{  
				$this->db->update(TAB_CUSTOM_TARGETING1,$data);
			}
			else if($table=="TAB_CUSTOM_TARGETING2")
			{  
				$this->db->update(TAB_CUSTOM_TARGETING2,$data);
			}	
			else if($table=="TAB_CUSTOM_TARGETING3")
			{  
				$this->db->update(TAB_CUSTOM_TARGETING3,$data);
			}
			else if($table=="TAB_CUSTOM_TARGETING4")
			{  
				$this->db->update(TAB_CUSTOM_TARGETING4,$data);
			}
			return $id;  
        }
    }
	
	

	
}
