<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Do_site extends CI_Model
{
	/*  djax_publisher_sites
	 * ---------------------
	 *  site_id
		account_id
		site_name
		site_url
		comments
		is_default
		added_date
		updated_date
		is_deleted
	 * */
	 
	 function add($account_id,$dj_admin_approve,$site_info,$comments='',$is_default=0){
		
		if(!$site_info['is_rtb'])
		{
			$site_info['is_rtb'] = 0;
		}
		if(!$site_info['type_bidding'])
		{
		$siteObj = array(
							"account_id" 	=> $account_id,
							"site_name" 	=> $site_info['site_name'],
							"site_url" 		=> $site_info['site_url'],
							"is_rtb"        => $site_info['is_rtb'],
							"comments" 		=> $comments,
							"is_default" 	=> $is_default,
							"added_date" 	=> date("Y-m-d H:i:s"),
							"dj_admin_approve" =>$dj_admin_approve
						);
					}
					else
					{
							$siteObj = array(
							"account_id" 	=> $account_id,
							"site_name" 	=> $site_info['site_name'],
							"site_url" 		=> $site_info['site_url'],
							"is_rtb"        => $site_info['type_bidding'],
							"comments" 		=> $comments,
							"is_default" 	=> $is_default,
							"added_date" 	=> date("Y-m-d H:i:s"),
							"dj_admin_approve" =>$dj_admin_approve
						);
					}
					
		if($this->db->insert(TAB_PUB_SITES,$siteObj)){
			return $this->db->insert_id();
		}
		else
		{
			return FALSE;
		}
	 }
	  
	  function update($site_info,$dj_admin_approve=false){


		
		$this->db->where('site_id',$site_info['site_id']);
		$query = $this->db->get(TAB_PUB_SITES);
		$result = $query->result_array();
	
	
		
		//~ if($result[0]['site_url'] != $site_info['site_url'] || $result[0]['site_name'] != $site_info['site_name'])	
		//~ {
			
		if($dj_admin_approve == 1)
		{
			
			
			$siteObj = array('site_name'=>$site_info['site_name'],
						'site_url'=>$site_info['site_url'],
						'status' => 1,
						"dj_admin_approve" =>1,
						'updated_date'=>date('Y-m-d H:i:s')
					);
					
		
		}else if($dj_admin_approve == 0)
		{
		
			$siteObj = array('site_name'=>$site_info['site_name'],
						'site_url'=>$site_info['site_url'],
						'status' => 0,
						"dj_admin_approve" =>0,
						'updated_date'=>date('Y-m-d H:i:s')
					);
					
		}else
		{
			$siteObj = array('site_name'=>$site_info['site_name'],
						'site_url'=>$site_info['site_url'],
						'status' => 0,
						"dj_admin_approve" =>0,
						'updated_date'=>date('Y-m-d H:i:s')
					);
		}
		
					
		
		if(!empty($siteObj)){
			
			$this->db->where('site_id',$site_info['site_id']);
			$this->db->update(TAB_PUB_SITES,$siteObj);
			
			return $site_info['site_id'];
			
		}
		else
		{
			return FALSE;
		}
	//}
	//~ else
	//~ {
		
		//return $site_info['site_id'];
	//}
	 }
	 function update1($site_info){
		
		$this->db->where('site_id',$site_info['site_id']);
		$query = $this->db->get(TAB_PUB_SITES);
		$result = $query->result_array();
		//added by murugeswari on 05-10-2017
		//when changing bidding type not able to save the site, it shows the url is already exit in url field.
		if($result[0]['site_url'] != $site_info['site_url'] || $result[0]['site_name'] != $site_info['site_name']|| $result[0]['type_bidding'] != $site_info['type_bidding'])	
		{
			
		//Edited website status gets updated as '0-Pause' state in DB.
		//status changed by murugeswari on 17-Oct-2017
		$siteObj = array('site_name'=>$site_info['site_name'],
						'site_url'=>$site_info['site_url'],
						'status' => 1,
						'is_rtb'        =>$site_info['type_bidding'],
						'updated_date'=>date('Y-m-d H:i:s')
					);
		
					
		
		if(!empty($siteObj)){
			
			$this->db->where('site_id',$site_info['site_id']);
			$this->db->update(TAB_PUB_SITES,$siteObj);
			
			return $site_info['site_id'];
			
		}
		else
		{
			return FALSE;
		}
	}
	else
	{
		return $site_info['site_id'];
	}
	 }
	 
	 
	 function fetch($where=FALSE){
		
		if($where != FALSE){
			$this->db->where($where);
		}
	
		$this->db->select('site_id,account_id,site_name,site_url,is_default,is_rtb,dj_admin_approve');		
		$this->db->where('is_deleted','0');
		
		$this->db->order_by('added_date');
		
		
		$query = $this->db->get(TAB_PUB_SITES);		
		
		$result = $query->result_array();
			
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		}

		
	 }
	 
	  function fetch1($where=FALSE){
		
		if($where != FALSE){
			$this->db->where($where);
		}
	
		$this->db->select('site_id,account_id,site_name,site_url,is_default,is_rtb,dj_admin_approve');		
		$this->db->where('is_deleted','0');
		$this->db->where('is_rtb','0');
		
		$this->db->order_by('added_date');
		
		
		$query = $this->db->get(TAB_PUB_SITES);		
		
		$result = $query->result_array();
			
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		}

		
	 }
	 
	 function fetch2($where=FALSE){
			
			$this->db->select('dps.site_id,dps.account_id,dps.site_name,dps.site_url,dps.is_default,dps.is_rtb,dps.dj_admin_approve');
			$this->db->from('djax_site_category_assoc as cat');
			$this->db->join('djax_publisher_sites as dps','dps.site_id = cat.site_id');
			$this->db->where($where);
			$query = $this->db->get();
			$result = $query->result_array();
			if($result)
			{			
				return $result;
			}
			else
			{
				return FALSE;
			}	
	 }
	 function get_info($site_id){
		if(!empty($site_id)){
			$this->db->where("site_id",$site_id);
			
			$query = $this->db->get(TAB_PUB_SITES);
			
			$result = $query->result_array();
			
			if($result)
			{			
				return $result;
			}
			else
			{
				return FALSE;
			}
		}
	 }
	  
	 
	 function set_assoc_category($site_id,$category){
		 
		 if($site_id != FALSE){
		
			$this->db->delete(TAB_SITE_CAT_ASSOC,array('site_id'=>$site_id));
			if(!empty($category)){
				
				foreach($category as $_id){
					$this->db->insert(TAB_SITE_CAT_ASSOC,array("site_id"=>$site_id,"category_id"=>$_id));
				}
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		 }
		 else
		 {
			return FALSE;
		 }
	 }
	 
	function remove($id){
		
		$this->db->trans_start();
		 if(is_array($id)){
			 
			$siteObj = array();
			foreach($id as $val){
				$siteObj[]= array('is_deleted'=>'1','site_id'=>$val);
			}
			$this->db->update_batch(TAB_PUB_SITES,$siteObj,'site_id');
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
			}
			else
			{
				$this->db->trans_commit();
			}
			
		 }
		 else if(!empty($id)){
			/*Associated Zones with sites delete*/
			$SQL = 'UPDATE '.TAB_ZONES.' as oxz 
					LEFT JOIN  '.TAB_SITE_ZONE_ASSOC.' as sz ON sz.zone_id=oxz.zoneid 
					SET dj_is_deleted=1 WHERE sz.site_id='.$id.'';
			
			$this->db->query($SQL);
			$this->db->where('site_id',$id); 
			$this->db->update(TAB_PUB_SITES,array('is_deleted'=>'1'));
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
			}
			else
			{
				$this->db->trans_commit();
			} 
			
		 }
	 }
	 
	 /**
       * Retreives the categories associated with this site
       * 
       * @param numeric $site_id Site id
       * 
	   * @return boolean Returns TRUE (or) FALSE
    */
	 
	 function get_site_category_assoc($site_id =FALSE)
	 {
		 if($site_id)
		 {
			 $this->db->select('category_id');
			 $query = $this->db->get_where(TAB_SITE_CAT_ASSOC,array('site_id'=>$site_id));
			 if($query->num_rows()>0)
			 {
				 $result = array();
				foreach($query->result_array() as $row)
				{
					array_push($result,$row['category_id']);	
					
				}
				return $result;
			 }else{
				return FALSE;	
			 }
		 }else{
			return FALSE; 
		 } 
	 }
	 
	/**
       * Deletes the site and associated categories
       * 
       * @param numeric $site_id Site id
       * 
	   * @return boolean Returns TRUE (or) FALSE
    */
    function delete($site_id =FALSE)
    {
		if($site_id)
		{
			$this->db->trans_start();

			$tables = array(TAB_PUB_SITES, TAB_SITE_CAT_ASSOC, TAB_SITE_BL_CAT_ASSOC);
			
			$this->db->where('site_id',$site_id);
			$this->db->delete($tables);
			
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
			}
			else
			{
				$this->db->trans_commit();
			}
			
		}else{
			return FALSE;	
		}	
	}


	/* blocked category associate */
	function set_assoc_blocked_category($site_id, $blocked_category)
	{

		if ($site_id != FALSE) {

			$this->db->delete(TAB_SITE_BL_CAT_ASSOC, array('site_id' => $site_id));
			if (!empty($blocked_category)) {
				foreach ($blocked_category as $_id) {
					$this->db->insert(TAB_SITE_BL_CAT_ASSOC, array("site_id" => $site_id, "blocked_category_id" => $_id));
				}
				return TRUE;
			} else {
				return FALSE;
			}
		} else {
			return FALSE;
		}
	}

	/* End of blocked category associate */


	/**
	 * Retreives the Blocked categories associated with this site
	 *
	 * @param numeric $site_id Site id
	 *
	 * @return boolean Returns TRUE (or) FALSE
	 */

	function get_site_blocked_category_assoc($site_id = FALSE)
	{
		if ($site_id) {
			$this->db->select('blocked_category_id');
			$query = $this->db->get_where(TAB_SITE_BL_CAT_ASSOC, array('site_id' => $site_id));
			if ($query->num_rows() > 0) {
				$result = array();
				foreach ($query->result_array() as $row) {
					array_push($result, $row['blocked_category_id']);
					
				}
				return $result;
			} else {
				return FALSE;
			}
		} else {
			return FALSE;
		}
	}
	
	/*
     * 
     * name: fetch_publisher
     * @param :
     * @return : $result
     * added : karthika
	 * on : dec-12-2016
     */
    function fetch_publisher($site_id)
    {
        $SQL = "SELECT a.account_id
				FROM 
					" . TAB_PUB_SITES . " as a
				WHERE 
					 a.is_deleted =0 AND a.site_id=$site_id 
				";
        $query = $this->db->query($SQL);

        $result = $query->result_array();
        
        if ($result)
            return $result;
        else
            return FALSE;
    }   
	
	
	
	
	
	
	
	
	
	
	
	function fetch_site_approval_type()

	 {
		 
		 
			$agency_id=get_session('agency_id');

			$this->db->select('config_value as site_approval_type');		
			$this->db->where('config_key','site_approval_type');
			$this->db->where('agency_id',$agency_id);
			$query = $this->db->get(TAB_APP_CONFIG);
            //echo $this->db->last_query();exit;
			$result = $query->result_array();
			
			

			if($query->num_rows()>0)

				return $result[0]['site_approval_type'];

			else

				return FALSE;

	}
	/*
     * 
     * name: fetch all sites
     * @param :
     * @return : $result
     * added : Murugeswari
	 * on : nov 15,2017
     */
	function fetch_all_site($agency_id)
	 {

		$this->db->select('ts.site_id,tp.name,ts.account_id,ts.site_name,ts.site_url,ts.is_default,ts.dj_admin_approve');
				
		$this->db->where('ts.is_deleted','0');
			
		$this->db->where('ts.dj_admin_approve',0);
			 
		$this->db->where('ta.agencyid',$agency_id);
			
		$this->db->from(TAB_PUB_SITES .' as ts');

		$this->db->join(TAB_USERS .' as tu','tu.default_account_id=ts.account_id');	
	  
		$this->db->join(TAB_AFFILIATE .' as tp','tp.account_id=ts.account_id'); 
		  
		$this->db->join(TAB_AGENCY .' as ta','ta.agencyid=tp.agencyid');

		$this->db->group_by('ts.site_id'); 

		$this->db->order_by('ts.site_id');
		
		$query = $this->db->get();		
       
		$result = $query->result_array();
			
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		} 
	 }	 
	/*

	* name: approve_site

	* @param : site_id

	* @return : TRUE or FALSE
	
	* added : Murugeswari
	* 
	* on : nov 15,2017

	* Approve the site

	*/  

	 function approve_site($site_id=FALSE)
	 {
		 	$data=array('dj_admin_approve'=>1,'status'=>1); 
			$this->db->where('site_id', $site_id);
			$this->db->update(TAB_PUB_SITES, $data);
	  	    if($this->db->affected_rows()>0)
					{
                    $this->db->select('*');
					$this->db->where('site_id',$site_id);
					$query=$this->db->get(TAB_PUB_SITES);
					$result=$query->result_array();
	    			return $result[0];
	             	}
					else
					{
                 	return FALSE;
				    }
 
	  }	 
	  
	 function fetch_unapproved_site($agency_id=FALSE)
	 {
		 	
			$this->db->select('count(site.site_id) as site_count');
			$this->db->join('ox_affiliates as aff','aff.account_id=site.account_id');
			$this->db->where('site.is_deleted',0);
			$this->db->where('aff.dj_approval_status',1);
			$this->db->where('aff.dj_is_denied',0);
			$this->db->where('aff.dj_is_deleted',0);
			$this->db->where('site.dj_admin_approve',0);
			$query=$this->db->get('djax_publisher_sites as site');
			$result=$query->result_array();
	    	return $result[0];

	  }	 
	  
	   function fetch_unapproved_site_pub($account_id=FALSE)
	 {
		 	
			$this->db->select('count(site.site_id) as site_count');
			$this->db->join('ox_affiliates as aff','aff.account_id=site.account_id');
			$this->db->where('site.is_deleted',0);
			$this->db->where('aff.dj_approval_status',1);
			$this->db->where('aff.dj_is_denied',0);
			$this->db->where('aff.dj_is_deleted',0);
			//~ $this->db->where('site.status',0);
			$this->db->where('site.dj_admin_approve',0);
			$this->db->where('site.account_id',$account_id);
			$query=$this->db->get('djax_publisher_sites as site');
			$result=$query->result_array();
	    	return $result[0];

	  }	
	  
	    /*

	* name: is_site_id

	* @param : site_id

	* @return : TRUE or FALSE
	* 
	* * added : Murugeswari
	* 
	* on : nov 15,2017

	* Check the site is approved / rejected previously 
	
	*/  

	

	public function is_site_id($site_id=FALSE)
	{

	  $query=$this->db->get_where(TAB_PUB_SITES,array('dj_admin_approve'=>0,'site_id'=>$site_id));
	  if($query->num_rows>0)
	  {
	    return TRUE;
	  }
	  else
	  {
	    return FALSE;
	  }

	}
	/*

	* name: reject_site

	* @param : site_id

	* @return : TRUE or FALSE
	
	* added : Murugeswari
	* 
	* on : nov 15,2017

	* Reject the site

	*/  
	
	 function reject_site($site_id=FALSE)
	 {
	  $data=array('dj_admin_approve'=>-1); 
	  $this->db->where('site_id', $site_id);
	  $this->db->update(TAB_PUB_SITES, $data);
	  if($this->db->affected_rows()>0)
	  {
      $this->db->select('*');
	  $this->db->where('site_id',$site_id);
	  $query=$this->db->get(TAB_PUB_SITES);
	  $result=$query->result_array();
	  return $result[0];
	  }
	  else
	  {
	  return FALSE;	
	  }
 
	}	 
}
