<?php defined('BASEPATH') OR exit('No direct script access allowed');
Class Do_roles extends CI_Model
{
	
	/*  ox_zones
	 * ---------------------
	 *  zonename
	 * 	width
	 *  Height
	 *  oac_category_id
	 *  dj_added_date
	 * 	is_deleted
	 * */
	 
	 public function add_role($roles)
	 {
	    $data=array( 'role_name'=>$roles['role_name'],
		             'status'  =>1,
					 'date_created'=>date('Y-m-d H:i:s')
					);
	    //INSERT ROLE NAME INTO djax_roles
	    $this->db->insert(TAB_ROLES,$data);
		$inserted_id=$this->db->insert_id();
		//CALL TO ANOTHER METHOD TO INSERT
		$this->add_role_permission($roles,$inserted_id);
	}
	
	public function update_role($roles)
	 {
	    //UPDATE ROLE NAME INTO djax_roles
		$data=array( 'role_name'=>$roles['role_name'],
		             'date_created'=>date('Y-m-d H:i:s')
				   );
	    $where=array('role_id'=>$roles['role_id']);
	    $this->db->update(TAB_ROLES,$data,$where);
		//DELETE THE EXISTING ID IF VALUES FOUND
		$this->db->delete(TAB_ROLE_PERMISSION_ASSOC,array('role_id'=>$roles['role_id']));
		//CALL TO ANOTHER METHOD TO INSERT
		$this->add_role_permission($roles);
	}
	
	//added on 12-06-2017
	public function add_user($roles)
	 {
	   $data=array( 'role_name'=>$roles['role_name'],
		             'status'  =>1,
					 'date_created'=>date('Y-m-d H:i:s')
					);
	    //INSERT ROLE NAME INTO djax_roles
	    $this->db->insert(TAB_ROLES,$data);
		$inserted_id=$this->db->insert_id();

		// $permission=array('role_id'=>$inserted_id,
		// 				 'permission_value' =>0);
		// $result=$this->db->insert(TAB_ROLE_PERMISSION_ASSOC,$permission);

		$final_arr=array();
		$roles['man_per']=array('198','200','205');

			foreach($roles['man_per'] as $permission)
			{  
			  $perm_data=array( 'role_id'=>$inserted_id,
								'permission_value'=>$permission
							  );
			   array_push($final_arr,$perm_data);
			}
		  $result =$this->db->insert_batch(TAB_ROLE_PERMISSION_ASSOC,$final_arr);

		if($result)
		{

		return true;
		}else
		{
			return false;
		}
		
		
	}		
		//end
		
	// check the user has permission or not
	//added on 13-06-2017
	public function check_user($role_id)
	 {
	   $this->db->select('id');
	   $this->db->where('role_id',$role_id['role_id']);
	   $query=$this->db->get(TAB_ROLE_PERMISSION_ASSOC);
	  // return $this->db->last_query();
	   
	   $result=$query->result_array();
	   if($result){
			return $result;
		  }else
		  {
			  return false;
		  }
	 }		
		//end	
		
	
	
	public function add_role_permission($roles,$last_inserted_id=FALSE)
	{
	    //INSERT MANAGER PERMISSION ID's into djax_role_permission_assoc
		$final_arr=array();
		if($last_inserted_id!=FALSE)
		{
			foreach($roles['man_per'] as $permission)
			{  
			  $perm_data=array( 'role_id'=>$last_inserted_id,
								'permission_value'=>$permission
							  );
			   array_push($final_arr,$perm_data);
			}
		   $this->db->insert_batch(TAB_ROLE_PERMISSION_ASSOC,$final_arr);
		}
		else
		{
		    foreach($roles['man_per'] as $permission)
			{  
			  $perm_data=array( 'role_id'=>$roles['role_id'],
								'permission_value'=>$permission
							  );
			   array_push($final_arr,$perm_data);
			}
		   $this->db->insert_batch(TAB_ROLE_PERMISSION_ASSOC,$final_arr);
		}
		return TRUE;
	}
	
	public function fetch_role($role_id)
	{
       $this->db->select('*');
	   $this->db->where('role_id',$role_id);
	   $query=$this->db->get(TAB_ROLES);
	   $result=$query->result_array(); 
	   if($result)
	   	 return $result;
	   else
	     return FALSE;
	}
	
	public function fetch_role_permission($role_id)
	{
       $this->db->select('permission_value');
	   $this->db->where('role_id',$role_id);
	   $query=$this->db->get(TAB_ROLE_PERMISSION_ASSOC);
	   $result=$query->result_array(); 
	   $final_arr = array();
	   if($result)
	   {
		   foreach($result as $key=>$value)
		   {
				$final_arr[$key] = $value['permission_value'];
		   }
		   return $final_arr;
	  }
	}
	
	/* 
	* name: fetch_user_role_list
	* @param : null
	* @return : return all user_role list from djax_roles
   */
	public function fetch_user_role_list()
	{
	   $this->db->select('*');
       $this->db->order_by("role_id");
	   $query=$this->db->get(TAB_ROLES);
	   $result=$query->result_array();
	   return $result;
	}
	
	/* 
	* name: block_role
	* @param : null
	* @return : return all user_role list from djax_roles
   */
	public function block_role($role_id)
	{
	   $this->db->trans_start();
	   $data=array('status'=>0);
	   $where=array('role_id'=>$role_id);
	   $this->db->update(TAB_ROLES,$data,$where);
	   //UPDATE ROLE BLOCK STATUS in djax_user_role_assoc table
	   $role_block=array('role_block'=>1);
	   $where_role=array('role_id'=>$role_id);
	   $this->db->update(TAB_USER_ROLE_ASSOC,$role_block,$where_role);
	   $this->db->trans_complete();
	   if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			return array("error"=>"Database error". $this->db->_error_message());
		}
		else
		{
			$this->db->trans_commit();
			return $role_id;	
		}
	}
	
	/* 
	* name: block_role
	* @param : null
	* @return : return all user_role list from djax_roles
   */
	public function unblock_role($role_id)
	{
	   $this->db->trans_start();
	   $data=array('status'=>1);
	   $where=array('role_id'=>$role_id);
	   $this->db->update(TAB_ROLES,$data,$where);
	   //UPDATE ROLE UN-BLOCK STATUS in djax_user_role_assoc table
	   $role_block=array('role_block'=>0);
	   $where_role=array('role_id'=>$role_id);
	   $this->db->update(TAB_USER_ROLE_ASSOC,$role_block,$where_role);
	   $this->db->trans_complete();
	  if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			return array("error"=>"Database error". $this->db->_error_message());
		}
		else
		{
			$this->db->trans_commit();
			return $role_id;	
		}
	}
		
}
