<?php defined('BASEPATH') OR exit('No direct script access allowed');
Class Do_report extends CI_Model
{
    function fetch($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
		//~ $exchangeRate	=	$this->config->item('exchangeRate');
		
		if(isset($search['exchangeval'])){
			$exchangeRate = $search['exchangeval'];
		}else{
			$exchangeRate = $this->config->item('exchangeRate');
		}
		
		//~ return $exchangeRate;
        if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'IMP';
                        $SQL .= " SUM(oxah.impressions) as " . $val . ',';
                        break;
                    case 'CLK';
                        $SQL .= " SUM(oxah.clicks) as " . $val . ',';
                        break;
                    case 'UIMP';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(oxah.dj_unique_impressions) as " . $val . ",";
                        }
                        break;
                    case 'UCLK';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(oxah.dj_unique_clicks) as " . $val . ",";
                        }
                        break;
                    case 'CON';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(oxah.conversions) as " . $val . ',';
                        }
                        break;
                    case 'SPEND';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= "ROUND(($exchangeRate*(SUM(oxah.dj_total_revenue))),2) as " . $val . ',';
                        }
                        break;
                    case 'PUB_EARN';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= "ROUND(($exchangeRate*(SUM(oxah.dj_publisher_earnings))),2) as " . $val . ',';
                        }
                        break;
                    case 'ADM_EARN';
                        if ($search['account_type'] === 'ADMIN')
                        {
                            $SQL .= "ROUND(($exchangeRate*(SUM(oxah.dj_total_revenue) - SUM(oxah.dj_publisher_earnings))),2) as " . $val . ',';
                        }
                        break;
                    case 'CTR';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " ROUND(((SUM(oxah.clicks)/SUM(oxah.impressions))*100),2) as " . $val . ',';
                        }
                        break;
                    case 'ECPM';
                        $SQL .= "ROUND(($exchangeRate*((SUM(oxah.dj_total_revenue)/SUM(oxah.impressions))*1000)),2) as " . $val . ',';
                        break;
                    case 'PUB_ECPM';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= "ROUND(($exchangeRate*(IFNULL(((SUM(oxah.dj_publisher_earnings)/SUM(oxah.impressions))*1000),0))),2) as " . $val . ',';
                        }
                        break;
                    case 'ACC_ID';
                        if ($search['account_type'] === 'ADVERTISER')
                        {
                            $SQL .= " (oxcl.account_id) as " . $val . ',';
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                        }
                        else if ($search['account_type'] === 'TRAFFICKER')
                        {
                            $SQL .= " (oxaff.account_id) as " . $val . ',';
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        else if ($search['account_type'] === 'ADMIN')
                        {
                            if ($search['page'] === 'REPORT_ADVERTISER')
                            {
                                $SQL .= " (oxcl.account_id) as " . $val . ',';
                                $SQL .= " (oxcl.clientname) as ACC_NAME,";
                                $SQL .= " (oxcl.dj_is_deleted) as DEL_STATUS,";
                                $SQL .= " (SELECT active FROM ox_users WHERE default_account_id =oxcl.account_id  limit 1) as ACTIVE_STATUS,";
                            }
                            else if ($search['page'] === 'REPORT_PUBLISHER')
                            {
                                $SQL .= " (oxaff.account_id) as " . $val . ',';
                                $SQL .= " (oxaff.name) as ACC_NAME,";
                            }
                        }
                        break;
                    case 'CAM_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxc.campaignid) as " . $val . ',';
                            $SQL .= " (oxc.campaignname) as CAM_NAME,";
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                        }
                        break;
                    case 'BAN_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxb.bannerid) as " . $val . ',';
                            $SQL .= " (oxb.storagetype) as ST_TYPE,";
                            $SQL .= " (oxb.dj_banner_type) as BAN_TYPE,";
                            $SQL .= " (oxb.description) as BAN_NAME,";
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                        }
                        break;
                    case 'SITE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxps.site_id) as " . $val . ',';
                            $SQL .= " (oxps.site_name) as SITE_NAME,";
                            $SQL .= " (oxps.site_url) as SITE_URL,";
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        break;
                    case 'ZONE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxz.zoneid) as " . $val . ',';
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        break;
                    case 'ENV';
                        $SQL .= " (oxah.dj_delivery_media_type) as " . $val . ",";
                        break;
                }
            }
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM ox_data_summary_ad_hourly as oxah";
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            {
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=oxah.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    // GET ZONE DETAILS
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=oxah.zone_id";
                    $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "TRAFFICKER")
                {
                    //// GET STATISTICS VALUES FOR AN TRAFFICKER
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=oxah.zone_id";
                    $SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER")
                {
                    // LINK ADVERTISER RELATED TABLES
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=oxah.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['adv_account_id']) AND $search['adv_account_id'] !== '' AND $search['adv_account_id'] > 0)
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['adv_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
                    }
                    // LINK TRAFFICKER RELATED TABLES
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=oxah.zone_id";
                    $SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '')
                    {
                        $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id=" . $search['pub_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " JOIN ox_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id)";
                    }
                }
            }
			/*DAC020 - Feb27,2020*/
			//$SQL .= "  WHERE 1";  
            $SQL .= "  WHERE oxah.impressions!='0'";  
			/*End*/
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
                if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND dj_delivery_media_type='" . $search['environment'] . "'";
                }
                if (isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term'] != '')
                {
                    $SQL .= " AND (";
                    foreach ($search['search_fields'] as $sObj)
                    {
                        $SQL .= "  {$sObj} LIKE '%" . $search['search_term'] . "%' OR";
                    }
                    $SQL = rtrim($SQL, "OR");
                    $SQL .= " )";
                }
            }
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'ACC_ID';
                            if ($search['account_type'] === 'ADVERTISER')
                            {
                                $SQL .= "oxcl.account_id,";
                            }
                            else if ($search['account_type'] === 'TRAFFICKER')
                            {
                                $SQL .= "oxaff.account_id,";
                            }
                            else if ($search['account_type'] === 'ADMIN')
                            {
                                if ($search['page'] === 'REPORT_ADVERTISER')
                                {
                                    $SQL .= "oxcl.account_id,";
                                }
                                else if ($search['page'] === 'REPORT_PUBLISHER')
                                {
                                    $SQL .= "oxaff.account_id,";
                                }
                            }
                            break;
                        case 'CAM_ID';
                            $SQL .= "oxc.campaignid,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,";
                            break;
                        case 'SITE_ID';
                            $SQL .= "oxps.site_id,";
                            break;
                        case 'ZONE_ID';
                            $SQL .= "oxz.zoneid,";
                            break;
                        case 'ENV';
                            $SQL .= "oxah.dj_delivery_media_type,";
                            break;
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }
        //~ return $SQL;
        
        $query = $this->db->query($SQL);
        //return $query->result_array();
        log_message("error",$this->db->last_query());
        if ($dataTable)
        {
            $data = $query->result_array();
            log_message("Error",$this->db->last_query());
            if ($data)
            {
                $data = array_map('callbackformat', $data);
                //date from overview from helper
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;
            }
        }
    }
    function fetch_country($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
        if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'IMP';
                        $SQL .= " SUM(dgs.impressions) as " . $val . ',';
                        break;
                    case 'CLK';
                        $SQL .= " SUM(dgs.clicks) as " . $val . ',';
                        break;
                    case 'UIMP';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_impressions) as " . $val . ",";
                        }
                        break;
                    case 'UCLK';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_clicks) as " . $val . ",";
                        }
                        break;
                    case 'CON';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.conversions) as " . $val . ',';
                        }
                        break;
                    case 'CTR';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " FORMAT(((SUM(dgs.clicks)/SUM(dgs.impressions))*100),2) as " . $val . ',';
                        }
                        break;
                    case 'ACC_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxcl.account_id) as " . $val . ',';
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                        }
                        else if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxaff.account_id) as " . $val . ',';
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        break;
                    case 'CAM_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxc.campaignid) as " . $val . ',';
                            $SQL .= " (oxc.campaignname) as CAM_NAME,";
                        }
                        break;
                    case 'BAN_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxb.bannerid) as " . $val . ',';
                            $SQL .= " (oxb.description) as BAN_NAME,";
                        }
                        break;
                    case 'SITE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxps.site_id) as " . $val . ',';
                            $SQL .= " (oxps.site_name) as SITE_NAME,";
                            $SQL .= " (oxps.site_url) as SITE_URL,";
                        }
                        break;
                    case 'ZONE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxz.zoneid) as " . $val . ',';
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                        }
                        break;
                    case 'ENV';
                        $SQL .= " (dgs.delivery_media_type) as " . $val . ",";
                        break;
                    case 'COUNTRY_CODE':
                        $SQL .= " (dgs.country_code) as " . $val . ",";
                        $SQL .= " (dtc.name) as COUNTRY,";
                        break;
                    case 'LATITUDE':
                        $SQL .= " (dgs.latitude) as " . $val . ",";
                        break;
                    case 'LONGITUDE':
                        $SQL .= " (dgs.longitude) as " . $val . ",";
                        break;
                }
            }
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM djax_geographical_stats as dgs";
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            {
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "TRAFFICKER")
                {
                    //// GET STATISTICS VALUES FOR AN TRAFFICKER
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER")
                {
                    // LINK ADVERTISER RELATED TABLES
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['adv_account_id']) AND $search['adv_account_id'] != '')
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['adv_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    // LINK TRAFFICKER RELATED TABLES
                    $SQL .= " LEFT JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " LEFT JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '')
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id=" . $search['pub_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id)";
                    }
                }
            }
            $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
                if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND delivery_media_type='" . $search['environment'] . "'";
                }
            }
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'ACC_ID';
                            if ($search['account_type'] !== "TRAFFICKER")
                            {
                                $SQL .= "oxcl.account_id,";
                            }
                            else if ($search['account_type'] !== "ADVERTISER")
                            {
                                $SQL .= "oxaff.account_id,";
                            }
                            break;
                        case 'CAM_ID';
                            $SQL .= "oxc.campaignid,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,";
                            break;
                        case 'SITE_ID';
                            $SQL .= "oxps.site_id,";
                            break;
                        case 'ZONE_ID';
                            $SQL .= "oxz.zoneid,";
                            break;
                        case 'ENV';
                            $SQL .= "delivery_media_type,";
                            break;
                        case 'COUNTRY_CODE';
                            $SQL .= " dgs.country_code,";
                            break;
                        case 'LATITUDE';
                            $SQL .= " dgs.latitude,";
                            break;
                        case 'LONGITUDE';
                            $SQL .= " dgs.longitude,";
                            break;
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }
        $query = $this->db->query($SQL);
        log_message('error',$this->db->last_query());
        if ($dataTable)
        {
            $data = $query->result_array();
            if ($data)
            {
                $data = array_map('callbackformat', $data);
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;
            }
        }
    }
    
    
     function fetch_city($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
        if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'IMP';
                        $SQL .= " SUM(dgs.impressions) as " . $val . ',';
                        break;
                    case 'CLK';
                        $SQL .= " SUM(dgs.clicks) as " . $val . ',';
                        break;
                    case 'UIMP';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_impressions) as " . $val . ",";
                        }
                        break;
                    case 'UCLK';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_clicks) as " . $val . ",";
                        }
                        break;
                    case 'CON';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.conversions) as " . $val . ',';
                        }
                        break;
                    case 'CTR';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " FORMAT(((SUM(dgs.clicks)/SUM(dgs.impressions))*100),2) as " . $val . ',';
                        }
                        break;
                    case 'ACC_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxcl.account_id) as " . $val . ',';
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                        }
                        else if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxaff.account_id) as " . $val . ',';
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        break;
                    case 'CAM_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxc.campaignid) as " . $val . ',';
                            $SQL .= " (oxc.campaignname) as CAM_NAME,";
                        }
                        break;
                    case 'BAN_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxb.bannerid) as " . $val . ',';
                            $SQL .= " (oxb.description) as BAN_NAME,";
                        }
                        break;
                    case 'SITE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxps.site_id) as " . $val . ',';
                            $SQL .= " (oxps.site_name) as SITE_NAME,";
                            $SQL .= " (oxps.site_url) as SITE_URL,";
                        }
                        break;
                    case 'ZONE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxz.zoneid) as " . $val . ',';
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                        }
                        break;
                    case 'ENV';
                        $SQL .= " (dgs.delivery_media_type) as " . $val . ",";
                        break;
                    case 'CITY':
                        $SQL .= " (dgs.city) as " . $val . ",";
                        $SQL .= " (dtc.name) as COUNTRY,";
                        break;
                    case 'LATITUDE':
                        $SQL .= " (round(dgs.latitude,2)) as " . $val . ",";
                        break;
                    case 'LONGITUDE':
                        $SQL .= " (round(dgs.longitude,2)) as " . $val . ",";
                        break;
                }
            }
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM djax_geographical_stats as dgs";
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            {
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "TRAFFICKER")
                {
                    //// GET STATISTICS VALUES FOR AN TRAFFICKER
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER")
                {
                    // LINK ADVERTISER RELATED TABLES
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['adv_account_id']) AND $search['adv_account_id'] != '')
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['adv_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    // LINK TRAFFICKER RELATED TABLES
                    $SQL .= " LEFT JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " LEFT JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '')
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id=" . $search['pub_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id)";
                    }
                }
            }
            $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
                if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND delivery_media_type='" . $search['environment'] . "'";
                }
            }
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'ACC_ID';
                            if ($search['account_type'] !== "TRAFFICKER")
                            {
                                $SQL .= "oxcl.account_id,";
                            }
                            else if ($search['account_type'] !== "ADVERTISER")
                            {
                                $SQL .= "oxaff.account_id,";
                            }
                            break;
                        case 'CAM_ID';
                            $SQL .= "oxc.campaignid,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,";
                            break;
                        case 'SITE_ID';
                            $SQL .= "oxps.site_id,";
                            break;
                        case 'ZONE_ID';
                            $SQL .= "oxz.zoneid,";
                            break;
                        case 'ENV';
                            $SQL .= "delivery_media_type,";
                            break;
                        case 'CITY';
                            $SQL .= " dgs.city,";
                            break;
                        case 'LATITUDE';
                            $SQL .= " dgs.latitude,";
                            break;
                        case 'LONGITUDE';
                            $SQL .= " dgs.longitude,";
                            break;
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }
        $query = $this->db->query($SQL);
        //~ return $this->db->last_query();
        if ($dataTable)
        {
            $data = $query->result_array();
            if ($data)
            {
                $data = array_map('callbackformat', $data);
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;
            }
        }
    }
    function get_inventory_count($user, $date, $agency_id)
    {
        switch ($user)
        {
            case 'ADMIN':
                $SQL   = "SELECT 
					(SELECT SUM(c)  as adv_count
						FROM ( 
						(SELECT count(*) as c FROM `ox_clients` WHERE  DATE(`dj_added_date`) = '" . $date . "' AND agencyid='" . $agency_id . "')  UNION  
						(SELECT count(*) as c  FROM  djax_temp_user WHERE DATE(`created_date`)  = '" . $date . "' AND account_type='ADVERTISER' AND agency_id='" . $agency_id . "') 
					) as t) as adv_count,
					
					(SELECT SUM(c) as pub_count
					FROM ( 
						(SELECT count(*) as c FROM `ox_affiliates` WHERE  DATE(`dj_added_date`) = '" . $date . "' AND agencyid='" . $agency_id . "')  UNION  
						(SELECT count(*) as c  FROM  djax_temp_user WHERE DATE(`created_date`)  = '" . $date . "' AND account_type='TRAFFICKER' AND agency_id='" . $agency_id . "') 
					) as t) as pub_count,
					
					(SELECT count(*) FROM `ox_banners` as oxb JOIN ox_campaigns as oxc ON oxb.campaignid=oxc.campaignid JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid='" . $agency_id . "') WHERE DATE(oxb.`dj_added_date`)='" . $date . "') as ban_count,
					
					(SELECT count(*) FROM `ox_campaigns` as oxc JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid='" . $agency_id . "')  WHERE DATE(oxc.`dj_added_date`)='" . $date . "') as cam_count,
					
					(SELECT count(*) FROM `ox_zones` as oxz JOIN ox_affiliates as oxaff ON (oxz.affiliateid=oxaff.affiliateid AND oxaff.agencyid='" . $agency_id . "') WHERE DATE(oxz.`dj_added_date`)='" . $date . "') as zone_count";
                $query = $this->db->query($SQL);
                $data  = $query->result_array();
                if ($data)
                {
                    return $data[0];
                }
                else
                {
                    return FALSE;
                }
                break;
        }
    }
      function fetch_video($columns, $search, $group, $order, $limit, $dataTable = FALSE,$camp_id=FALSE)
    {
		$exchangeRate	=	$this->config->item('exchangeRate');
		
		//~ return $search;
		if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */if($search['page']=='REPORT_VIDEOADNETWORK'){
$SQL = "SELECT dva.id as ID,dva.adnetwork_name as ADNETWORKNAME,IFNULL(SUM(oxah.impressions),0)  as IMP,IFNULL(SUM(oxah.clicks),0) as CLK,ROUND(($exchangeRate * IFNULL((((SUM(oxah.dj_total_revenue)/SUM(oxah.impressions))*1000)),0)),2) as PUB_ECPM,ROUND(($exchangeRate * IFNULL((oxah.dj_total_revenue),0)),2) as REVENUE FROM `djax_video_adnetwork` as dva left
				join ox_banners as oxb on dva.id=oxb.exchange_id left join ox_data_summary_ad_hourly as oxah on oxah.ad_id=oxb.bannerid  WHERE dva.is_deleted=0";
				
		if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '') {
            $SQL .= " AND (DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
        } else if (isset($search['date_from']) AND $search['date_from'] != '') {
            $SQL .= " AND DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
        }
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '') {
            $SQL .= " AND (DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
        } else if (isset($search['date_from']) AND $search['date_from'] != '') {
            $SQL .= " AND DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
        }
        
        
        if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '') {
            $SQL .= " AND dva.id=".$search['pub_account_id'];
        } 
        
        
        $SQL .= " group by dva.id";	
        if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
            $SQL = rtrim($SQL, ",");
      // return $SQL;
        } // Vast mediation vast creative query
        // Vast mediation vast creative query
        else  if($search['page']=='REPORT_VIDEOADBLOCK'){
		//print_r($columns);die();
		//return $search['page'];
		 $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'CREATEVIEW';
                         $SQL .= " IFNULL(SUM(vid.Started),0) as " . $val . ',';
                        break;
                    case 'START';
                        $SQL .= " IFNULL(SUM(vid.Started),0) as " . $val . ',';
                        break;
                    case 'FQ';
                        $SQL .= " IFNULL(SUM(vid.firstQuartile),0) as " . $val . ',';
                        break;
                    case 'MP';
                        $SQL .= " IFNULL(SUM(vid.midpoint),0) as " . $val . ',';
                        break;
                    case 'TQ';
                        $SQL .= " IFNULL(SUM(vid.thirdQuartile),0) as " . $val . ',';
                        break;
                    case 'COMP';
                        $SQL .= " IFNULL(SUM(vid.Completed),0) as " . $val . ',';
                        break;
                    case 'PAUSED';
                        $SQL .= " IFNULL(SUM(vid.Paused),0) as " . $val . ',';
                        break;
              
                   case 'REPLAYED';
                        $SQL .= " IFNULL(SUM(vid.Replayed),0) as " . $val . ',';
                        break;
                        
                    case 'MUTE';
                        $SQL .= " IFNULL(SUM(vid.Muted) ,0)as " . $val . ',';
                        break;
                    case 'UNMUTE';
                        $SQL .= " IFNULL(SUM(vid.Unmute),0) as " . $val . ',';
                        break;
                    case 'FS';
                     $SQL .= " IFNULL(SUM(vid.Fullscreen),0) as " . $val . ',';
                        break;
                        
                   case 'ACCEPT';
                          $SQL .= " IFNULL(SUM(vid.Fullscreen),0) as " . $val . ',';
                        break;
                        
                        
                    case 'SKIP';
                         $SQL .= " IFNULL(SUM(vid.Fullscreen),0) as " . $val . ',';
                        break;
                    case 'ZONENAME';
                       $SQL .= " (vid.zonename) as ZONENAME,";
                        break;
                    case 'ST';
                        $SQL .= " IFNULL(SUM(vid.StartTime),0) as " . $val . ',';
                    break;
                     case 'SC';
                        $SQL .= " IFNULL(SUM(vid.Stalled),0) as " . $val . ',';
                    break;
                     case 'UI';
                        $SQL .= " vid.User as " . $val . ',';
                    break;
                    case 'TP';
                        $SQL .= " IFNULL(SUM(vid.TotalPlaytime),0) as " . $val . ',';
                    break;
					case 'ENV';
                         $SQL .= " vid.delivery_media_type,";
                         break;
                }
		}
		 $SQL = rtrim($SQL, ",");
            $SQL .= " FROM
						(
							SELECT
								DATE(vas.interval_start) AS date,
								vas.zone_id,vas.site_id,
								vas.stall_count as Stalled,
								vas.user_id as User,
								vas.playtime as TotalPlaytime,
			                    vas.zonename,vas.delivery_media_type,vas.affiliateid,
								CASE WHEN vast_event_name = 'Started' THEN vas.count END AS Started,
								CASE WHEN vast_event_name = 'midpoint' THEN vas.count END AS midpoint,
								CASE WHEN vast_event_name = 'firstQuartile' THEN vas.count END AS firstQuartile,
								CASE WHEN vast_event_name = 'thirdQuartile' THEN vas.count END AS thirdQuartile,
								CASE WHEN vast_event_name = 'Completed' THEN vas.count END AS Completed, 
								CASE WHEN vast_event_name = 'Muted' THEN vas.count END AS Muted,
								CASE WHEN vast_event_name = 'Fullscreen' THEN vas.count END AS Fullscreen,
								CASE WHEN vast_event_name = 'Unmute' THEN vas.count END AS Unmute,
								CASE WHEN vast_event_name = 'Replayed' THEN vas.count END AS Replayed,
								CASE WHEN vast_event_name = 'Paused' THEN vas.count END AS Paused,
								CASE WHEN vas.vast_event_id = '13' THEN vas.start_time END AS StartTime
							  FROM 
							  	djax_conf_banner_vast_events
							  JOIN 
							  (
									 SELECT vast.start_time,vast.playtime,vast.stall_count,vast.user_id,vast.interval_start, vast.zone_id,vast.zonename,vast.vast_event_id,vast.delivery_media_type, SUM(vast.count) as count,vast.site_id,vast.affiliateid
									FROM
									(
										SELECT 
											ox_stats_vast.interval_start, 
											ox_stats_vast.creative_id, 
											ox_stats_vast.zone_id, 
											ox_stats_vast.vast_event_id, 
											ox_stats_vast.count,
											ox_zones.zonename,
											dsza.site_id,
											dvs.delivery_media_type,
											ox_zones.affiliateid,
											ox_stats_vast.start_time,
											ox_stats_vast.playtime,
											ox_stats_vast.stall_count,
											ox_stats_vast.user_id
										FROM ox_stats_vast 
										JOIN  djax_conf_banner_vast_events 
										ON djax_conf_banner_vast_events.vast_event_id=ox_stats_vast.vast_event_id 
										JOIN djax_viewer_stats as dvs on  ox_stats_vast.creative_id=dvs.ad_id AND ox_stats_vast.zone_id=dvs.zone_id
										left join ox_zones ON ox_zones.zoneid=ox_stats_vast.zone_id
										left join djax_site_zone_assoc as dsza ON ox_zones.zoneid=dsza.zone_id";
										if($search['pub_account_id']!='')
										{
										$SQL .=" where ox_zones.zoneid=".$search['pub_account_id'];
										}
									$SQL .="	GROUP BY 
	ox_stats_vast.vast_event_id,ox_stats_vast.zone_id,ox_stats_vast.creative_id,ox_stats_vast.interval_start
									) AS vast
									GROUP BY vast_event_id, zone_id, creative_id, interval_start
									ORDER BY interval_start, creative_id, zone_id
							  ) AS vas ON vas.vast_event_id=djax_conf_banner_vast_events.vast_event_id	) AS vid ";
				 if ($search['account_type'] == "TRAFFICKER")
                 {
					 $SQL .= " JOIN ox_affiliates as aff ON (aff.affiliateid = vid.affiliateid AND aff.account_id='". $search['account_id']."')  ";
				 }
		 $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
            }
         if (isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term'] != '')
        {
            $SQL .= " AND (";
            foreach ($search['search_fields'] as $sObj)
            {
                $SQL .= "  {$sObj} LIKE '%" . $search['search_term'] . "%' OR";
            }
            $SQL = rtrim($SQL, "OR");
            $SQL .= " )";
        }
                        if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND delivery_media_type='" . $search['environment'] . "'";
                }
                 if (isset($search['site_id']) AND $search['site_id'] != '')
                {
                    $SQL .=" AND vid.site_id =  ".$search['site_id'] ;
				}
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY zone_id,vid.User";
                
            }
           if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
            $SQL = rtrim($SQL, ",");
           
	}	 //if
			
		}// Vast mediation vast creative query
              else
        { 
		//return $columns; exit;	
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'START';
                        $SQL .= " IFNULL(SUM(vid.Started),0) as " . $val . ',';
                        break;
                    case 'FQ';
                        $SQL .= " IFNULL(SUM(vid.firstQuartile),0) as " . $val . ',';
                        break;
                    case 'MP';
                        $SQL .= " IFNULL(SUM(vid.midpoint),0) as " . $val . ',';
                        break;
                    case 'TQ';
                        $SQL .= " IFNULL(SUM(vid.thirdQuartile),0) as " . $val . ',';
                        break;
                    case 'COMP';
                        $SQL .= " IFNULL(SUM(vid.Completed),0) as " . $val . ',';
                        break;
                    case 'PAUSED';
                        $SQL .= " IFNULL(SUM(vid.Paused),0) as " . $val . ',';
                        break;
                    case 'PTP';
                        $SQL .= " IFNULL(SUM(vid.PausetoPlay),0) as " . $val . ',';
                        break;
                    case 'MUTE';
                        $SQL .= " IFNULL(SUM(vid.Muted) ,0)as " . $val . ',';
                        break;
                    case 'UNMUTE';
                        $SQL .= " IFNULL(SUM(vid.Unmute),0) as " . $val . ',';
                        break;
                    case 'FS';
                        $SQL .= " IFNULL(SUM(vid.Fullscreen),0) as " . $val . ',';
                        break;
                    case 'ST';
                        $SQL .= " IFNULL(SUM(vid.StartTime),0) as " . $val . ',';
                    break;
                     case 'SC';
                        $SQL .= " IFNULL(SUM(vid.Stalled),0) as " . $val . ',';
                    break;
                     case 'UI';
                        $SQL .= " vid.User as " . $val . ',';
                    break;
                    case 'TP';
                        $SQL .= " IFNULL(SUM(vid.TotalPlaytime),0) as " . $val . ',';
                    break;
                    case 'BAN_ID';
                        $SQL .= " vid.creative_id as " . $val . ',';
                        $SQL .= " (oxb.description) as BAN_NAME,";
                        break;
                }
            }
			          
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM
						(
							SELECT
								DATE(vas.interval_start) AS date,
								vas.creative_id,
								vas.stall_count as Stalled,
								vas.user_id as User,
								vas.playtime as TotalPlaytime,
								CASE WHEN vast_event_name = 'Started' THEN vas.count END AS Started,
								CASE WHEN vast_event_name = 'midpoint' THEN vas.count END AS midpoint,
								CASE WHEN vast_event_name = 'firstQuartile' THEN vas.count END AS firstQuartile,
								CASE WHEN vast_event_name = 'thirdQuartile' THEN vas.count END AS thirdQuartile,
								CASE WHEN vast_event_name = 'Completed' THEN vas.count END AS Completed, 
								CASE WHEN vast_event_name = 'Muted' THEN vas.count END AS Muted,
								CASE WHEN vast_event_name = 'Fullscreen' THEN vas.count END AS Fullscreen,
								CASE WHEN vast_event_name = 'Unmute' THEN vas.count END AS Unmute,
								CASE WHEN vast_event_name = 'PausetoPlay' THEN vas.count END AS PausetoPlay,
								CASE WHEN vast_event_name = 'Paused' THEN vas.count END AS Paused,
								CASE WHEN vas.vast_event_id = '13' THEN vas.start_time END AS StartTime
							  FROM 
							  	djax_conf_banner_vast_events
							  JOIN 
							  (
									SELECT vast.start_time,vast.playtime,vast.stall_count,vast.user_id,vast.interval_start, vast.creative_id, vast.zone_id, vast.vast_event_id, SUM(vast.count) as count
									FROM
									(
										SELECT 
											ox_stats_vast.interval_start, 
											ox_stats_vast.creative_id, 
											ox_stats_vast.zone_id, 
											ox_stats_vast.vast_event_id, 
											ox_stats_vast.count,
											ox_stats_vast.start_time,
											ox_stats_vast.playtime,
											ox_stats_vast.stall_count,
											ox_stats_vast.user_id
										FROM ox_stats_vast 
										JOIN  djax_conf_banner_vast_events 
										ON djax_conf_banner_vast_events.vast_event_id=ox_stats_vast.vast_event_id 
										GROUP BY 
	ox_stats_vast.vast_event_id,ox_stats_vast.zone_id,ox_stats_vast.creative_id,ox_stats_vast.interval_start,ox_stats_vast.user_id
									) AS vast
									GROUP BY vast_event_id, zone_id, creative_id, interval_start, user_id
									ORDER BY interval_start, creative_id, zone_id
							  ) AS vas ON vas.vast_event_id=djax_conf_banner_vast_events.vast_event_id							  						) AS vid ";
							 
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            {
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    if (isset($search['creative_id']) AND $search['creative_id'] != '')
                    {
                        $SQL .= " JOIN ox_banners as oxb ON (oxb.bannerid=vid.creative_id AND oxb.bannerid='" . $search['creative_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=vid.creative_id";
                    }
                    $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . "  AND  oxcl.agencyid=" . $search['agency_id'] . ")";
                 }
				 else if ($search['account_type'] === "ADMIN")
                 {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    if (isset($search['creative_id']) AND $search['creative_id'] != '')
                    {
                        $SQL .= " JOIN ox_banners as oxb ON (oxb.bannerid=vid.creative_id AND oxb.bannerid='" . $search['creative_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=vid.creative_id";
                    }
                 }
				 else if ($search['account_type'] === "MANAGER")
                 {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    if (isset($search['creative_id']) AND $search['creative_id'] != '')
                    {
                        $SQL .= " JOIN ox_banners as oxb ON (oxb.bannerid=vid.creative_id AND oxb.bannerid='" . $search['creative_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=vid.creative_id";
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND
						oxcl.agencyid='".$search['agency_id']."')";
                    }
                 }

                 
               
            }
            $SQL .= "  WHERE 1";
            
            
            
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
                
                if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                {
                    $SQL .= " AND oxb.campaignid='" . $search['campaign_id'] . "'";
                }
            }
			//~ if (isset($search['environment']) AND $search['environment'] != '') {
						//~ $SQL .= " AND ox.dj_delivery_media_type='" . $search['environment'] . "'";
					//~ }
					
				   // return $SQL;
					if (isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term'] != '') {
						$SQL .= " AND (";
						foreach ($search['search_fields'] as $sObj) {
							$SQL .= "  {$sObj} LIKE '%" . $search['search_term'] . "%' OR";
						}
						
						$SQL = rtrim($SQL, "OR");
						
						$SQL .= " )";
						
					}            
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,vid.User";
                            break;
                       
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }
         log_message('error',$SQL);
        //return $SQL; exit;
	}
     //echo $SQL; exit;
       
        //return $SQL; exit;
        
        $query = $this->db->query($SQL);
        //return $query;
        
     log_message('error',$this->db->last_query());
        if ($dataTable)
        {
			
            $data = $query->result_array();

            if ($data)
            {
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
			//return "false";
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;
            }
        }
    }
    /*
     * 
     * name: fetch_campaign
     * @param :
     * @return : $result
     * 
     * Lists a campaign of an advertiser and list specific campaign of an advertiser
     */
    function fetch_campaign($account_id, $campaign_type = false, $agency_id = FALSE, $campaign_id = FALSE)
    {
        $this->db->select('oxc.campaignid, oxc.campaignname');
        $this->db->join(TAB_CLIENTS . ' as oxcl', 'oxcl.clientid=oxc.clientid');
        if ($agency_id != FALSE && $agency_id != 'all')
        {
            $this->db->where('oxcl.agencyid', $agency_id);
            $this->db->where('oxcl.exchange_id',0);
        }
        if ($account_id != FALSE && $account_id != 'all')
            $this->db->where('oxcl.account_id', $account_id);
        if ($campaign_type != FALSE && $campaign_type != 'all')
            $this->db->where('oxc.dj_targetting_type', $campaign_type);
        // to fetch specific campaign
        if ($campaign_id != FALSE && $campaign_id != 'all')
            $this->db->where('oxc.campaignid', $campaign_id);
        $this->db->order_by('oxc.dj_added_date ');
        $query  = $this->db->get(TAB_CAMPAIGNS . ' as oxc');
        $result = $query->result_array();
        if ($result)
        {
            foreach ($result as $idx => $value)
            {
                $result[$idx]['DATE'] = dateformat(strtotime($value['DATE']));
            }
            return $result;
        }
        else
        {
            return FALSE;
        }
    }
    /*
     * 
     * name: fetch_video
     * @param :
     * @return : TRUE (or) FALSE
     * 
     * Get the video creative from the database
     */
    function fetch_video_creatives($account_id)
    {
        if ($account_id)
        {
            /*Get records from ox_banner_vast_element */
            $this->db->where('dj_account_id', $account_id);
            $this->db->where_in('dj_banner_type', array(
                VIDEO_CREATIVE_OVERLAY,
                MOBILE_VIDEO_CREATIVE_INLINE,
                MOBILE_VIDEO_CREATIVE_OVERLAY,
                VIDEO_CREATIVE_INLINE
            ));
            $query  = $this->db->get(TAB_BANNERS);
            $result = $query->result_array();
            if ($result)
                return $result;
            else
                return FALSE;
        }
        else
            return FALSE;
    }
    /*
     * 
     * name: fetch_site
     * @param : $data
     * @return : $result
     * 
     * Lists all sites for the report
     */
    function fetch_sites($data = FALSE, $site_id = FALSE)
    {
        if (!empty($data['account_id']) && isset($data['account_id']))
        {
            $account_id = $data['account_id'];
            $this->db->where('sites.account_id', $account_id);
        }
        $this->db->select('sites.site_id,sites.account_id,sites.site_name,sites.site_url');
        $this->db->order_by('added_date');
        if ($site_id != FALSE && $site_id != 'all')
        {
            $this->db->where('sites.site_id', $site_id);
        }
        if (!empty($data['agency_id']))
        {
            $this->db->where('oxa.agencyid', $data['agency_id']);
            $this->db->where('oxa.dj_is_dsp is NULL');
        }
        $this->db->join(TAB_AFFILIATE . ' as oxa', 'oxa.account_id=sites.account_id');
        $query  = $this->db->get(TAB_PUB_SITES . ' as sites');
        $result = $query->result_array();
        if ($result)
        {
            return $result;
        }
        else
        {
            return FALSE;
        }
    }
    /*
     * 
     * name: fetch_advertiser
     * @param : $data
     * @return : $result
     * 
     * Lists all advertisers for the report
     */
     
     function fetch_advertiser($network_id = FALSE, $network_account_id = FALSE, $account_id = FALSE)
    {
		$exchangeRate	=	$this->config->item('exchangeRate');
		
        if ($account_id != FALSE)
        {
            $this->db->where('oxa.account_id', $account_id);
        }
        if ($network_account_id != FALSE)
        {
            $where = array(
                'dnm.network_account_id' => $network_account_id,
                'dnm.manager_account_id' => $network_id,
                'dnm.is_deleted' => 0,
                'oxcl.dj_is_deleted' => 0
            );
        }
        else
        {
            $where = array(
                'dnm.network_account_id' => $network_id,
                'dnm.default_manager' => 1,
                'dnm.is_deleted' => 0,
                'oxcl.dj_is_deleted' => 0
            );
        }
        $this->db->select('COUNT(oxca.clientid) as camp_count,
							('.$exchangeRate.' * SUM(oxds.dj_total_revenue)) as spend_amount,
							oxcl.clientid,
							oxcl.agencyid as agencyid,
							oxcl.clientname as name,
							oxcl.email,
							oxcl.dj_first_name as first_name,
							oxcl.dj_last_name as last_name,
							oxcl.dj_is_denied as status,
							oxa.account_id as account_id,
							oxa.account_type as account_type');
        $this->db->from(TAB_USERS . ' as oxu');
        $this->db->join(TAB_ACCOUNTS . ' as oxa', 'oxa.account_id=oxu.default_account_id');
        $this->db->join(TAB_CLIENTS . ' as oxcl', 'oxcl.account_id=oxa.account_id');
        $this->db->join(TAB_NWK_MANAGERS . ' as dnm', 'dnm.agency_id=oxcl.agencyid');
        $this->db->join(TAB_CAMPAIGNS . ' as oxca', 'oxca.clientid=oxcl.clientid AND oxca.dj_is_deleted="0"', 'left');
        $this->db->join(TAB_BANNERS . ' as oxb', 'oxb.campaignid=oxca.campaignid AND oxb.dj_is_deleted="0"', 'left');
        $this->db->join(TAB_DATA_SUM_AD_HOURLY . ' as oxds', 'oxds.ad_id=oxb.bannerid', 'left');
        $this->db->where($where);
        $this->db->group_by('oxa.account_id');
        $this->db->order_by('oxa.account_id', 'desc');
        $query = $this->db->get();
        if ($query->num_rows() > 0)
        {
            $result = $query->result_array();
            return $result;
        }
        else
        {
            return FALSE;
        }
    }
    
    
 function fetch_affiliates($columns, $search, $group, $order, $limit, $dataTable = FALSE)
	{	
		
		$SQL = "SELECT 
				`dnm`.*,
				`oxa`.`name`,
				`oxa`.`email`,
				`oxa`.`active`,
				`oxa`.`account_id` as ACC_ID,
				`oxa`.`agencyid`,
				`dns`.`impressions`  as IMP,
				`dns`.`clicks` as CLKS, 
				`dns`.`conversions` as CON, 
				`advertiser_spend`   as ADV_REV,
				`publisher_share` as PUB_REV, 
				`network_revenue` as NET_REV, 
				`admin_revenue` as ADM_SHARE,
				ROUND(dns.dj_dsp_share,4) as DSP_SHARE,
				ROUND(dnm.invoice_revenue,4) as INV_SHARE
				FROM 
				(`ox_agency` as oxa) JOIN `djax_network_managers` as dnm  ON  `dnm`.`manager_account_id`=`oxa`.`account_id`
				 JOIN `ox_accounts` as oxac ON `oxac`.`account_id`=`oxa`.`account_id` JOIN  `ox_users` as oxu ON `oxu`.`email_address`=`oxa`.`email` LEFT JOIN  `djax_network_stats` as dns ON `dns`.`agency_id` = `oxa`.`agencyid` LEFT JOIN `ox_data_summary_ad_hourly` as ox ON `ox`.`zone_id` = `dns`.`zone_id` WHERE  `oxac`.`account_type` = 'MANAGER' AND `dnm`.`is_deleted` = '0' ";
				
				
				 if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
				{
					$SQL .= " AND (DATE(CONVERT_TZ(dns.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(dns.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
				}
			/*if($search!=FALSE && isset($search['date_from']) && isset($search['date_to']))
		{
			$SQL .= " AND date(dns.date_time) BETWEEN '".$search['date_from']."' AND '".$search['date_to']."' ";	
		}*/	
		if (isset($search['environment']) AND $search['environment'] != '') {
                    $SQL .= " AND ox.dj_delivery_media_type='" . $search['environment'] . "'";
                }
                
                
                if (isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term'] != '') {
                    $SQL .= " AND (";
                    foreach ($search['search_fields'] as $sObj) {
                        $SQL .= "  {$sObj} LIKE '%" . $search['search_term'] . "%' OR";
                    }
                    
                    $SQL = rtrim($SQL, "OR");
                    
                    $SQL .= " )";
                    
                }
			$SQL .= "GROUP BY oxa.agencyid";
			
			if (is_array($order) AND count($order) > 0) {
                
                $SQL .= " ORDER BY ";
                
                foreach ($order as $key => $option) {
                    $SQL .= " {$key} {$option},";
                }
                
                //REMOVE comma at End of the string
                
                $SQL = rtrim($SQL, ",");
            }
			
			if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
			{
				$SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
			}
			else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
			{
				$SQL .= " LIMIT " . $limit['end'] . "";
			}
			
				//return $SQL;			
			
			$query = $this->db->query($SQL);
			
		    log_message('error','fdhgdfjhgh');
			log_message('error',$this->db->last_query());
			//$result = $query->result_array();
			 
			  if ($dataTable) {
		
            $data = $query->result_array();
            if($data) {
	            $data = array_map('callbackformat', $data); //in helper file callback function called
	  
		      
		     //date from overview from helper
                return $data;
            } else {
                return FALSE;
            }
        } else {
            $fields = $query->list_fields();
            
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            
            if ($data) {
				
                return $res;
            } else {
                return FALSE;
            }
        }
			
	}	      
   
   


    /*
     * 
     * name: fetch_publisher
     * @param : $data
     * @return : $result
     * 
     * Lists all publishers for the report
     */
    function fetch_publisher($network_id = FALSE, $network_account_id = FALSE, $account_id = FALSE)
    {
        $exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
        
        $SQL = "SELECT  site_count, ($exchangeRate * COALESCE(ROUND(SUM(oxds.dj_publisher_earnings),2),0)) as earning, `oxaf`.`affiliateid`, `oxaf`.`agencyid`, `oxaf`.`name`, `oxaf`.`email`, `oxaf`.`website`, `oxaf`.`dj_first_name` as first_name, `oxaf`.`dj_last_name` as last_name, `oxaf`.`dj_is_denied` as status, `oxaf`.`account_id` as account_id
			FROM (" . TAB_USERS . " as oxu) 
			JOIN " . TAB_AFFILIATE . " as oxaf ON `oxaf`.`account_id`=`oxu`.`default_account_id` 
			JOIN " . TAB_NWK_MANAGERS . " as dnm ON `dnm`.`agency_id`=`oxaf`.`agencyid` 
			LEFT JOIN (SELECT dps.account_id,count(*) as site_count FROM " . TAB_PUB_SITES . " as dps WHERE dps.is_deleted='0' GROUP BY dps.account_id) m ON `m`.`account_id`=`oxaf`.`account_id` 
			LEFT JOIN " . TAB_ZONES . " as oxz ON `oxz`.`affiliateid`=`oxaf`.`affiliateid` 
			LEFT JOIN " . TAB_DATA_SUM_AD_HOURLY . " as oxds ON `oxds`.`zone_id`=`oxz`.`zoneid`";
        
        $SQL .= " WHERE dnm.is_deleted =0";
        if ($network_account_id) {
            $SQL .= " AND dnm.network_account_id= " . $network_account_id . " AND dnm.manager_account_id = " . $network_id . "";
        } else {
            $SQL .= " AND dnm.network_account_id= " . $network_id . " AND dnm.default_manager = 1";
        }
        
        if ($account_id) {
            $SQL .= " AND oxaf.account_id= " . $account_id . "";
        }
        
        $SQL .= " GROUP BY `oxaf`.`account_id` ORDER BY `oxaf`.`account_id` DESC";
        
        $query = $this->db->query($SQL);
       
       
        if ($query->num_rows() > 0) {
  
            $query = $query->result_array();
            
            return $query;
        } else {
            return FALSE;
        }
    }
    /*
     * 
     * name: fetch_dsp_stats
     * @param : $data
     * @return : $result
     * 
     * Lists all dsp stats for the report
     */
	function fetch_dsp_stats($search, $order = null, $limit = false)
    {
		if(isset($search['exchangeval'])){
			$exchangeRate = $search['exchangeval'];
		}else{
			$exchangeRate = $this->config->item('exchangeRate');
		}
		
		//Without multi currency
							//IFNULL(SUM(res.dj_dsp_share)/1000,0) as win_price,
	/*$SQL = "SELECT 
					sum(res.request) as req,
					sum(res.response) as res,
					sum(res.won_request) as win_count,
					IFNULL(SUM(res.won_bid)/1000,0) as bid_price,
					IFNULL(SUM(res.won_bid)/1000,0) as win_price,
					adx.exchange_name,
					adx.exchange_id as exchange_id
					FROM
					djax_ssp_dspstatistics as res
					JOIN djax_3rd_party_ad_exchange as adx ON adx.exchange_id=res.dsp_id 
											where	adx.type='DSP'";*/
		// added for multi currency, not tested in real time, incase of error revoke above query
		$SQL = "SELECT 
					sum(res.request) as req,
					sum(res.response) as res,
					sum(res.won_request) as win_count,
					ROUND(($exchangeRate * SUM(res.won_bid)/1000),2) as bid_price,
					ROUND(($exchangeRate * SUM(res.won_bid)/1000),2) as win_price,
					adx.exchange_name,
					adx.exchange_id as exchange_id
					FROM
					djax_ssp_dspstatistics as res
					JOIN djax_3rd_party_ad_exchange as adx ON adx.exchange_id=res.dsp_id 
											where	adx.type='DSP'";
											
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '') {
            $SQL .= " AND (DATE(res.interval_start)  >= '" . $search['date_from'] . "' AND DATE(res.interval_start) <= '" . $search['date_to'] . "')";
        } else if (isset($search['date_from']) AND $search['date_from'] != '') {
            $SQL .= " AND DATE(res.interval_start) = '" . $search['date_from'] . "'";
        }
         $SQL .= "GROUP BY res.dsp_id ";
        if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '') {
            $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
        } else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '') {
            $SQL .= " LIMIT " . $limit['end'] . "";
        }
         
           $query = $this->db->query($SQL);
        if ($query->num_rows() > 0) {
            $views_val = $query->row_array();
            if (($views_val['exchange_id']) == '') {
                return FALSE;
            } else {
                $result = $query->result_array();
                
                return $result;
            }
        } else {
            return FALSE;
        }
    }
    /*
     * 
     * name: fetch_dsp_stats
     * @param : $data
     * @return : $result
     * 
     * Lists all dsp stats for the report
     */
     function fetch_dsp_date_stats($exchange_id, $search, $order = null, $limit = false)
    {
		if(isset($search['exchangeval'])){
			$exchangeRate = $search['exchangeval'];
		}else{
			$exchangeRate = $this->config->item('exchangeRate');
		}
		
//	IFNULL(SUM(res.dj_dsp_share)/1000,0) as win_price,
       /* $SQL = "SELECT 
					DATE(CONVERT_TZ(res.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) as date,
					sum(res.request) as req_count,
					sum(res.response) as res_count,
					sum(res.won_request) as win_count,
				
					IFNULL(SUM(res.won_bid)/1000,0) as bid_price,
					adx.exchange_name,
					adx.exchange_id as exchange_id
					FROM
					djax_ssp_dspstatistics as res
					JOIN djax_3rd_party_ad_exchange as adx ON adx.exchange_id=res.dsp_id 
											where	adx.type='DSP' AND res.dsp_id='" . $exchange_id . "' ";*/
			// added for multi currency, not tested in real time, incase of error revoke above query								
		 $SQL = "SELECT 
					DATE(CONVERT_TZ(res.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) as date,
					sum(res.request) as req_count,
					sum(res.response) as res_count,
					sum(res.won_request) as win_count,
				
					ROUND(($exchangeRate * SUM(res.won_bid)/1000),2) as bid_price,
					adx.exchange_name,
					adx.exchange_id as exchange_id
					FROM
					djax_ssp_dspstatistics as res
					JOIN djax_3rd_party_ad_exchange as adx ON adx.exchange_id=res.dsp_id 
											where	adx.type='DSP' AND res.dsp_id='" . $exchange_id . "' ";
      if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '') {
            $SQL .= " AND (DATE(CONVERT_TZ(res.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(res.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
        } else if (isset($search['date_from']) AND $search['date_from'] != '') {
            $SQL .= " AND DATE(CONVERT_TZ(res.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
        }
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '') {
            $SQL .= " AND (DATE(CONVERT_TZ(res.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(res.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
        } else if (isset($search['date_from']) AND $search['date_from'] != '') {
            $SQL .= " AND DATE(CONVERT_TZ(res.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
        }
        $SQL .= "GROUP BY DATE(CONVERT_TZ(res.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')), res.dsp_id ";
        if ($order != null && !empty($order['field']) && !empty($order['order'])) {
        $SQL .= " ORDER BY DATE(CONVERT_TZ(res.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) DESC";
        } else {
            $SQL .= " ORDER BY DATE(CONVERT_TZ(res.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) DESC";
        }
        if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '') {
            $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
        } else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '') {
            $SQL .= " LIMIT " . $limit['end'] . "";
        }
//return $SQL;
        $query = $this->db->query($SQL);
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            $result = array_map('callbackformat', $result);
            return $result;
        } else {
            return FALSE;
        }
    }
    /*
     * 
     * name: fetch_dsp_stats
     * @param : $data
     * @return : $result
     * 
     * Lists all dsp stats for the report
     */
     function fetch_dsp_detail_stats($exchange_id, $date, $search, $order = null, $limit = false)
    {
		
		//IFNULL(SUM(res.dj_dsp_share)/1000,0) as win_price,
			$SQL = "SELECT 
					DATE(CONVERT_TZ(res.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) as date,
					sum(res.request) as res_count,
					sum(res.response) as req_count,
					sum(res.won_request) as win_count,
					oxcl.clientname as client_name, 
					oxc.campaignname as camp_name, 
					oxb.description as ban_name,
					
					IFNULL(SUM(res.won_bid)/1000,0) as bid_price,
					adx.exchange_name,
					adx.exchange_id as exchange_id
					FROM
					djax_ssp_dspstatistics as res
					join  ox_data_summary_ad_hourly as hr  on hr.dj_total_revenue = res.won_bid
					JOIN djax_3rd_party_ad_exchange as adx ON adx.exchange_id=res.dsp_id 
					join ox_banners as oxb ON oxb.bannerid=hr.ad_id
					join ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid
					join ox_clients as oxcl ON oxcl.clientid=oxc.clientid  				
					where	adx.type='DSP'	 AND res.dsp_id='" . $exchange_id . "' ";
					
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '') {
            $SQL .= " AND (DATE(res.interval_start)  >= '" . $search['date_from'] . "' AND DATE(res.interval_start) <= '" . $search['date_to'] . "')";
        } else if (isset($search['date_from']) AND $search['date_from'] != '') {
            $SQL .= " AND DATE(interval_start) = '" . $search['date_from'] . "'";
        }
        
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '') {
            $SQL .= " AND (DATE(res.interval_start)  >= '" . $search['date_from'] . "' AND DATE(res.interval_start) <= '" . $search['date_to'] . "')";
        } else if (isset($search['date_from']) AND $search['date_from'] != '') {
            $SQL .= " AND DATE(interval_start) = '" . $search['date_from'] . "'";
        }
        $SQL .= "GROUP BY DATE(res.interval_start),res.dsp_id ";
        if ($order != null && !empty($order['field']) && !empty($order['order'])) {
            $SQL .= " ORDER BY " . $order['field'] . " " . $order['order'];
        } else {
            $SQL .= " ORDER BY DATE(res.interval_start) DESC";
        }
        if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '') {
            $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
        } else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '') {
            $SQL .= " LIMIT " . $limit['end'] . "";
        }
       // return $SQL;
        $query = $this->db->query($SQL);
        
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            return FALSE;
        }
    }
   //~ Modified:Murugeswari
    //~ Date :15-Mar-2017
       // function fetch_ssp_stats($search, $order = null, $limit = false)
    function fetch_ssp_stats($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
		if(isset($search['exchangeval'])){
			$exchangeRate = $search['exchangeval'];
		}else{
			$exchangeRate = $this->config->item('exchangeRate');
		}		
        $SQL = "SELECT
				SUM(req.response_count) as res_count,
				SUM(req.request_count) as req_count,
				SUM(win_count) as win_count,				
			    SUM(req.impressions) as impression,				
				SUM(req.clicks) as clicks,			    
				req.adexchange as exchange_id,
				adx.exchange_name,
				ROUND(($exchangeRate * SUM(req.dj_dsp_share)),2) as win_price,
				ROUND(($exchangeRate * SUM(req.total_revenue)),2) as bid_price,
				ROUND(($exchangeRate * (SUM(req.total_revenue)-SUM(req.dj_dsp_share))),2) as admin_earnings
			FROM
				djax_dsp_request_stats as req
			JOIN 
				djax_3rd_party_ad_exchange as adx ON adx.exchange_id=req.adexchange 
			WHERE
				adx.type='SSP'";
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
        {
            $SQL .= " AND (DATE(CONVERT_TZ(req.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(req.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
        }
        else if (isset($search['date_from']) AND $search['date_from'] != '')
        {
            $SQL .= " AND DATE(CONVERT_TZ(req.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
        }
        
               if (isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term'] != '') {
                    $SQL .= " AND (";
                    foreach ($search['search_fields'] as $sObj) {
                        $SQL .= "  {$sObj} LIKE '%" . $search['search_term'] . "%' OR";
                    }
                    
                    $SQL = rtrim($SQL, "OR");
                    
                    $SQL .= " )";
                    
                }        

			$SQL .= "GROUP BY req.adexchange ";
			
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }			    			
        
        if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
        {
            $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
        }
        else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
        {
            $SQL .= " LIMIT " . $limit['end'] . "";
        }
        //~ return $SQL;
        log_message('error',$SQL);
        $query = $this->db->query($SQL);
       
		//return $this->db->last_query();
      
		  if ($dataTable) {
		
            $data = $query->result_array();
            if($data) {
	            $data = array_map('callbackformat', $data); //in helper file callback function called
	  
		      
		     //date from overview from helper
                return $data;
            } else {
                return FALSE;
            }
		} else {
            $fields = $query->list_fields();
            
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            
            if ($data) {
				
                return $res;
            } else {
                return FALSE;
            }
        }
     }
    /*
     * 
     * name: fetch_ssp_stats
     * @param : $data
     * @return : $result
     * 
     * Lists all ssp stats for the report
     */
    
    //~ Date :15-Mar-2017
	function fetch_ssp_date_stats($exchange_id, $search, $order = null, $limit = false)
	{
		if(isset($search['exchangeval'])){
			$exchangeRate = $search['exchangeval'];
		}else{
			$exchangeRate = $this->config->item('exchangeRate');
		}			
        $SQL = "SELECT        
				SUM(req.response_count) as res_count,
				SUM(req.request_count) as req_count,
				req.adexchange as exchange_id,
				adx.exchange_name,
				DATE(CONVERT_TZ(req.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) as date,
				SUM(win_count) as win_count,
				($exchangeRate * SUM(req.dj_dsp_share)) as win_price,
				($exchangeRate * SUM(req.total_revenue)) as bid_price,
				SUM(req.impressions) as impression,
				SUM(req.clicks) as clicks,
				ROUND(($exchangeRate * (SUM(req.total_revenue)-SUM(req.dj_dsp_share))),2) as admin_earnings
				 
			FROM
				djax_dsp_request_stats as req
			JOIN 
				djax_3rd_party_ad_exchange as adx ON adx.exchange_id=req.adexchange 
			WHERE
				adx.type='SSP' AND req.adexchange='" . $exchange_id . "' ";
				
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
        {
            $SQL .= " AND (DATE(CONVERT_TZ(req.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(req.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
        }
        else if (isset($search['date_from']) AND $search['date_from'] != '')
        {
            $SQL .= " AND DATE(CONVERT_TZ(req.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
        }
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
        {
            $SQL .= " AND (DATE(CONVERT_TZ(req.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(req.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
        }
        else if (isset($search['date_from']) AND $search['date_from'] != '')
        {
            $SQL .= " AND DATE(CONVERT_TZ(req.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
        }
        $SQL .= "GROUP BY DATE(CONVERT_TZ(req.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')), req.adexchange ";
        if ($order != null && !empty($order['field']) && !empty($order['order']))
        {
            //$SQL .= " ORDER BY " . $order['field'] . " " . $order['order'];
            $SQL .= " ORDER BY date " . $order['order'];
        }
        else
        {
            $SQL .= " ORDER BY DATE(CONVERT_TZ(req.interval_start,'+00:00','" . $this->config->item('time_zone_offset') . "')) DESC";
        }
        if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
        {
            $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
        }
        else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
        {
            $SQL .= " LIMIT " . $limit['end'] . "";
        }
        
        $query = $this->db->query($SQL);
       
        if ($query->num_rows() > 0)
        {
			$result = $query->result_array();
			//$result = array_map('callbackformat', $result);
            return $result;
        }
        else
        {
            return FALSE;
        }
    }
     /* 
     * name: fetch_dsp_stats
     * @param : $data
     * @return : $result
     * 
     * Lists all ssp stats for the report
     */

    //~ Modified : Murugeswari
    //~ Date  : 15-Mar-2017
     function fetch_ssp_detail_stats($exchange_id, $date, $search, $order = null, $limit = false)
    {
		$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		
		$SQL = "SELECT        
				SUM(req.response_count) as res_count,
				SUM(req.request_count) as req_count,
				SUM(req.impressions) as impression,
				SUM(req.clicks) as clicks,
				req.adexchange as exchange_id,
				adx.exchange_name,
				oxcl.clientname as client_name, 
				oxc.campaignname as camp_name, 
				oxb.description as ban_name,
				DATE(req.interval_start) as dbdate,
				oxh.ad_id AS adid,
				SUM(win_count) as win_count,
				($exchangeRate * SUM(req.dj_dsp_share)) as win_price,
				($exchangeRate * SUM(req.total_revenue)) as bid_price,
				($exchangeRate * sum(oxh.dj_publisher_earnings)) as publisher_earning

			FROM 
				djax_dsp_request_stats as req
			JOIN 
				djax_3rd_party_ad_exchange as adx ON adx.exchange_id=req.adexchange 
			JOIN
				ox_data_summary_ad_hourly as oxh ON oxh.adexchange = adx.exchange_id AND DATE(oxh.date_time) = DATE(req.interval_start)
			JOIN 
				ox_banners as oxb ON oxb.bannerid=oxh.ad_id
			JOIN 
				ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid
			JOIN 
				ox_clients as oxcl ON oxcl.clientid=oxc.clientid 
			WHERE
				adx.type='SSP' ";
				
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
        {
            $SQL .= " AND (DATE(req.interval_start)  >= '" . $search['date_from'] . "' AND DATE(req.interval_start) <= '" . $search['date_to'] . "')";
        }
        else if (isset($search['date_from']) AND $search['date_from'] != '')
        {
            $SQL .= " AND DATE(req.interval_start) = '" . $search['date_from'] . "'";
        }
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
        {
            $SQL .= " AND (DATE(req.interval_start)  >= '" . $search['date_from'] . "' AND DATE(req.interval_start) <= '" . $search['date_to'] . "')";
        }
        else if (isset($search['date_from']) AND $search['date_from'] != '')
        {
            $SQL .= " AND DATE(req.interval_start) = '" . $search['date_from'] . "'";
        }
        $SQL .= "GROUP BY DATE(req.interval_start), req.adexchange, oxh.ad_id ";
        if ($order != null && !empty($order['field']) && !empty($order['order']))
        {
            $SQL .= " ORDER BY " . $order['field'] . " " . $order['order'];
        }
        else
        {
            $SQL .= " ORDER BY DATE(req.interval_start) DESC";
        }
        if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
        {
            $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
        }
        else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
        {
            $SQL .= " LIMIT " . $limit['end'] . "";
        }
      //  return $SQL;
        $query = $this->db->query($SQL);
        
        if ($query->num_rows() > 0)
        {
            $result = $query->result_array();
            return $result;
        }
        else
        {
            return FALSE;
        }
    }
    /*
     * 
     * name: fetch_dsp_stats
     * @param : $data
     * @return : $result
     * 
     * Lists all dsp stats for the report
     */
    function fetch_advertiser_dsp_stats($search, $order = null, $limit = false, $adv_account_id)
    {
        $SQL = "SELECT 
					IFNULL(count(res.response_id),0) as res,
					IFNULL(count(req.id),0) as req,
					req.exchange_id as exchange_id,
					adx.exchange_name,
					IFNULL(COUNT(win.id),0) as win_count,
					IFNULL(SUM(win.price)/1000,0) as win_price,
					IFNULL(SUM(res.advertiser_bid_price)/1000,0) as bid_price

					FROM 
							djax_dsp_bid_request as req
							left join djax_dsp_response as res force key(requset_id) on res.requset_id = req.id
							left join djax_dsp_win_notice as win on res.requset_id = win.request_id 			
							JOIN djax_3rd_party_ad_exchange as adx ON adx.exchange_id=req.exchange_id 
						JOIN 
							ox_banners as oxb ON oxb.bannerid=res.adid
						JOIN 
							ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid
						JOIN 
							ox_clients as oxcl ON oxcl.clientid=oxc.clientid 
					WHERE 
							adx.type='DSP' AND oxcl.account_id='" . $adv_account_id . "' AND oxcl.account_id='" . $adv_account_id . "'";
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
        {
            $SQL .= " AND (DATE(res.datetime)  >= '" . $search['date_from'] . "' AND DATE(res.datetime) <= '" . $search['date_to'] . "')";
        }
        else if (isset($search['date_from']) AND $search['date_from'] != '')
        {
            $SQL .= " AND DATE(res.datetime) = '" . $search['date_from'] . "'";
        }
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
        {
            $SQL .= " AND (DATE(win.datetime)  >= '" . $search['date_from'] . "' AND DATE(win.datetime) <= '" . $search['date_to'] . "')";
        }
        else if (isset($search['date_from']) AND $search['date_from'] != '')
        {
            $SQL .= " AND DATE(win.datetime) = '" . $search['date_from'] . "'";
        }
        if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
        {
            $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
        }
        else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
        {
            $SQL .= " LIMIT " . $limit['end'] . "";
        }
        $query = $this->db->query($SQL);
        if ($query->num_rows() > 0)
        {
            $views_val = $query->row_array();
            if (($views_val['exchange_id']) == '')
            {
                return FALSE;
            }
            else
            {
                $result = $query->result_array();
                return $result;
            }
        }
        else
        {
            return FALSE;
        }
    }
    function fetch_advertiser_dsp_date_stats($exchange_id, $search, $order = null, $limit = false, $adv_account_id)
    {
        $SQL = "SELECT 
					IFNULL(count(res.response_id),0) as res,
					IFNULL(count(req.id),0) as req,
					req.exchange_id as exchange_id,
					adx.exchange_name,
					 DATE(req.datetime) as dbdate,
					IFNULL(COUNT(win.id),0) as win_count,
					IFNULL(SUM(win.price)/1000,0) as win_price,
					IFNULL(SUM(res.advertiser_bid_price)/1000,0) as bid_price

					FROM 
							djax_dsp_bid_request as req
							left join djax_dsp_response as res force key(requset_id) on res.requset_id = req.id
							left join djax_dsp_win_notice as win on res.requset_id = win.request_id 			
							JOIN djax_3rd_party_ad_exchange as adx ON adx.exchange_id=req.exchange_id 
						JOIN 
							ox_banners as oxb ON oxb.bannerid=res.adid
						JOIN 
							ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid
						JOIN 
							ox_clients as oxcl ON oxcl.clientid=oxc.clientid
					WHERE 
							  adx.type='DSP' AND req.exchange_id='" . $exchange_id . "' AND oxcl.account_id='" . $adv_account_id . "'";
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
        {
            $SQL .= " AND (DATE(res.datetime)  >= '" . $search['date_from'] . "' AND DATE(res.datetime) <= '" . $search['date_to'] . "')";
        }
        else if (isset($search['date_from']) AND $search['date_from'] != '')
        {
            $SQL .= " AND DATE(datetime) = '" . $search['date_from'] . "'";
        }
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
        {
            $SQL .= " AND (DATE(res.datetime)  >= '" . $search['date_from'] . "' AND DATE(res.datetime) <= '" . $search['date_to'] . "')";
        }
        else if (isset($search['date_from']) AND $search['date_from'] != '')
        {
            $SQL .= " AND DATE(datetime) = '" . $search['date_from'] . "'";
        }
        $SQL .= "GROUP BY DATE(req.datetime),req.exchange_id ";
        if ($order != null && !empty($order['field']) && !empty($order['order']))
        {
            $SQL .= " ORDER BY " . $order['field'] . " " . $order['order'];
        }
        else
        {
            $SQL .= " ORDER BY DATE(req.datetime) DESC";
        }
        if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
        {
            $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
        }
        else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
        {
            $SQL .= " LIMIT " . $limit['end'] . "";
        }
        $query = $this->db->query($SQL);
        if ($query->num_rows() > 0)
        {
            $result = $query->result_array();
            return $result;
        }
        else
        {
            return FALSE;
        }
    }
    function fetch_advertiser_dsp_detail_stats($exchange_id, $date, $search, $order = null, $limit = false, $adv_account_id)
    {
        $SQL = "SELECT 
					IFNULL(count(res.response_id),0) as res,
					IFNULL(count(req.id),0) as req,
					req.exchange_id as exchange_id,
					adx.exchange_name,
					oxcl.clientname as client_name, 
							oxc.campaignname as camp_name, 
							oxb.description as ban_name,
					 DATE(req.datetime) as dbdate,
					IFNULL(COUNT(win.id),0) as win_count,
					IFNULL(SUM(win.price)/1000,0) as win_price,
					IFNULL(SUM(res.advertiser_bid_price)/1000,0) as bid_price

					FROM 
							djax_dsp_win_notice as win 
						left join djax_dsp_response as res on res.requset_id= win.request_id 
						left join  djax_dsp_bid_request as req on req.id=res.requset_id 				
						LEFT JOIN djax_3rd_party_ad_exchange as adx ON adx.exchange_id=req.exchange_id
						JOIN 
							ox_banners as oxb ON oxb.bannerid=res.adid
						JOIN 
							ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid
						JOIN 
							ox_clients as oxcl ON oxcl.clientid=oxc.clientid  
					WHERE 
					
					  adx.type='DSP' AND req.exchange_id='" . $exchange_id . "' AND oxcl.account_id='" . $adv_account_id . "'";
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
        {
            $SQL .= " AND (DATE(res.datetime)  >= '" . $search['date_from'] . "' AND DATE(res.datetime) <= '" . $search['date_to'] . "')";
        }
        else if (isset($search['date_from']) AND $search['date_from'] != '')
        {
            $SQL .= " AND DATE(datetime) = '" . $search['date_from'] . "'";
        }
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
        {
            $SQL .= " AND (DATE(res.datetime)  >= '" . $search['date_from'] . "' AND DATE(res.datetime) <= '" . $search['date_to'] . "')";
        }
        else if (isset($search['date_from']) AND $search['date_from'] != '')
        {
            $SQL .= " AND DATE(datetime) = '" . $search['date_from'] . "'";
        }
        $SQL .= "GROUP BY DATE(req.datetime),req.exchange_id ";
        if ($order != null && !empty($order['field']) && !empty($order['order']))
        {
            $SQL .= " ORDER BY " . $order['field'] . " " . $order['order'];
        }
        else
        {
            $SQL .= " ORDER BY DATE(req.datetime) DESC";
        }
        if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
        {
            $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
        }
        else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
        {
            $SQL .= " LIMIT " . $limit['end'] . "";
        }
        $query = $this->db->query($SQL);
        if ($query->num_rows() > 0)
        {
            $result = $query->result_array();
            return $result;
        }
        else
        {
            return FALSE;
        }
    }
    
 //Added by Murugeswari on 18-05-2017
     function fetch_all_dsp()
    {
		$SQL = "SELECT id as ID, adnetwork_name as ADNETWORKNAME FROM ".TAB_VIDEO_ADNETWORK." WHERE is_deleted = 0";

		$SQL .= " ORDER BY adnetwork_name ASC";
		
		$query = $this->db->query($SQL);
		
		if($query->num_rows() >0)
		{
				$result = 	$query->result_array();	
				return $result;
		}else{
				return FALSE;	
		}	
	}
	function fetch_video_vast($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
		if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */
         if($search['page']=='REPORT_VIDEOADNETWORK'){
$SQL = "SELECT dva.id as ID,dva.adnetwork_name as ADNETWORKNAME,IFNULL((oxah.impressions),0)  as IMP,IFNULL((oxah.clicks),0) as CLK,ROUND(IFNULL((((SUM(oxah.dj_total_revenue)/SUM(oxah.impressions))*1000)),0),2) as PUB_ECPM,ROUND(IFNULL((oxah.dj_total_revenue),0),2) as REVENUE FROM `djax_video_adnetwork` as dva left
				join ox_banners as oxb on dva.id=oxb.exchange_id left join ox_data_summary_ad_hourly as oxah on oxah.ad_id=oxb.bannerid  WHERE dva.is_deleted=0";
				
		if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '') {
            $SQL .= " AND (DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
        } else if (isset($search['date_from']) AND $search['date_from'] != '') {
            $SQL .= " AND DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
        }
        if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '') {
            $SQL .= " AND (DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
        } else if (isset($search['date_from']) AND $search['date_from'] != '') {
            $SQL .= " AND DATE(CONVERT_TZ(oxah.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
        }
        
        
        if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '') {
            $SQL .= " AND dva.id=".$search['pub_account_id'];
        } 
        
        
        $SQL .= " group by dva.id";	
       
        } // Vast mediation vast creative query
        else  if($search['page']=='REPORT_VIDEOADBLOCK'){
		//print_r($columns);die();
		//return $search['page'];
		 $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'CREATEVIEW';
                         $SQL .= " IFNULL(SUM(vid.Started),0) as " . $val . ',';
                        break;
                    case 'START';
                        $SQL .= " IFNULL(SUM(vid.Started),0) as " . $val . ',';
                        break;
                    case 'FQ';
                        $SQL .= " IFNULL(SUM(vid.firstQuartile),0) as " . $val . ',';
                        break;
                    case 'MP';
                        $SQL .= " IFNULL(SUM(vid.midpoint),0) as " . $val . ',';
                        break;
                    case 'TQ';
                        $SQL .= " IFNULL(SUM(vid.thirdQuartile),0) as " . $val . ',';
                        break;
                    case 'COMP';
                        $SQL .= " IFNULL(SUM(vid.Completed),0) as " . $val . ',';
                        break;
                    case 'PAUSED';
                        $SQL .= " IFNULL(SUM(vid.Paused),0) as " . $val . ',';
                        break;
              
                    case 'MUTE';
                        $SQL .= " IFNULL(SUM(vid.Muted) ,0)as " . $val . ',';
                        break;
                    case 'UNMUTE';
                        $SQL .= " IFNULL(SUM(vid.Unmute),0) as " . $val . ',';
                        break;
                    case 'FS';
                     $SQL .= " IFNULL(SUM(vid.Fullscreen),0) as " . $val . ',';
                        break;
                        
                   case 'ACCEPT';
                          $SQL .= " IFNULL(SUM(vid.Fullscreen),0) as " . $val . ',';
                        break;
                        
                        
                    case 'SKIP';
                         $SQL .= " IFNULL(SUM(vid.Fullscreen),0) as " . $val . ',';
                        break;
                    case 'ZONENAME';
                       $SQL .= " (vid.zonename) as ZONENAME,";
                        break;
 
                }
		}
		 $SQL = rtrim($SQL, ",");
            $SQL .= " FROM
						(
							SELECT
								DATE(vas.interval_start) AS date,
								vas.zone_id,
			                    vas.zonename,
								CASE WHEN vast_event_name = 'Started' THEN vas.count END AS Started,
								CASE WHEN vast_event_name = 'midpoint' THEN vas.count END AS midpoint,
								CASE WHEN vast_event_name = 'firstQuartile' THEN vas.count END AS firstQuartile,
								CASE WHEN vast_event_name = 'thirdQuartile' THEN vas.count END AS thirdQuartile,
								CASE WHEN vast_event_name = 'Completed' THEN vas.count END AS Completed, 
								CASE WHEN vast_event_name = 'Muted' THEN vas.count END AS Muted,
								CASE WHEN vast_event_name = 'Fullscreen' THEN vas.count END AS Fullscreen,
								CASE WHEN vast_event_name = 'Unmute' THEN vas.count END AS Unmute,
								CASE WHEN vast_event_name = 'PausetoPlay' THEN vas.count END AS PausetoPlay,
								CASE WHEN vast_event_name = 'Paused' THEN vas.count END AS Paused
							  FROM 
							  	djax_conf_banner_vast_events
							  JOIN 
							  (
									SELECT vast.interval_start, vast.zone_id,vast.zonename,vast.vast_event_id, SUM(vast.count) as count
									FROM
									(
										SELECT 
											ox_stats_vast.interval_start, 
											ox_stats_vast.creative_id, 
											ox_stats_vast.zone_id, 
											ox_stats_vast.vast_event_id, 
											ox_stats_vast.count,
											ox_zones.zonename
										FROM ox_stats_vast 
										JOIN  djax_conf_banner_vast_events 
										ON djax_conf_banner_vast_events.vast_event_id=ox_stats_vast.vast_event_id 
										left join ox_zones ON ox_zones.zoneid=ox_stats_vast.zone_id";
										if($search['pub_account_id']!='')
										{
										$SQL .=" where ox_zones.zoneid=".$search['pub_account_id'];
										}
									$SQL .="	GROUP BY 
	ox_stats_vast.vast_event_id,ox_stats_vast.zone_id,ox_stats_vast.creative_id,ox_stats_vast.interval_start
									) AS vast
									GROUP BY vast_event_id, zone_id, creative_id, interval_start
									ORDER BY interval_start, creative_id, zone_id
							  ) AS vas ON vas.vast_event_id=djax_conf_banner_vast_events.vast_event_id							  						) AS vid ";
		 $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
            }
         if (isset($search['search_fields']) AND $search['search_fields'] !== FALSE AND $search['search_term'] != '')
        {
            $SQL .= " AND (";
            foreach ($search['search_fields'] as $sObj)
            {
                $SQL .= "  {$sObj} LIKE '%" . $search['search_term'] . "%' OR";
            }
            $SQL = rtrim($SQL, "OR");
            $SQL .= " )";
        }
                        if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND dj_delivery_media_type='" . $search['environment'] . "'";
                }
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY zone_id";
                
            }
           if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
            $SQL = rtrim($SQL, ",");
           
	}	 //if
			
		}// Vast mediation vast creative query
        else
        { 
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'START';
                        $SQL .= " IFNULL(SUM(vid.Started),0) as " . $val . ',';
                        break;
                    case 'FQ';
                        $SQL .= " IFNULL(SUM(vid.firstQuartile),0) as " . $val . ',';
                        break;
                    case 'MP';
                        $SQL .= " IFNULL(SUM(vid.midpoint),0) as " . $val . ',';
                        break;
                    case 'TQ';
                        $SQL .= " IFNULL(SUM(vid.thirdQuartile),0) as " . $val . ',';
                        break;
                    case 'COMP';
                        $SQL .= " IFNULL(SUM(vid.Completed),0) as " . $val . ',';
                        break;
                    case 'PAUSED';
                        $SQL .= " IFNULL(SUM(vid.Paused),0) as " . $val . ',';
                        break;
                    case 'PTP';
                        $SQL .= " IFNULL(SUM(vid.PausetoPlay),0) as " . $val . ',';
                        break;
                    case 'MUTE';
                        $SQL .= " IFNULL(SUM(vid.Muted) ,0)as " . $val . ',';
                        break;
                    case 'UNMUTE';
                        $SQL .= " IFNULL(SUM(vid.Unmute),0) as " . $val . ',';
                        break;
                    case 'FS';
                        $SQL .= " IFNULL(SUM(vid.Fullscreen),0) as " . $val . ',';
                        break;
                      case 'CV';
                        $SQL .= " IFNULL(SUM(vid.CreativeView),0) as " . $val . ',';
                        break;
                    case 'EP';
                        $SQL .= " IFNULL(SUM(vid.Expand),0) as " . $val . ',';
                        break;
                    case 'CL';
                        $SQL .= " IFNULL(SUM(vid.Collapse),0) as " . $val . ',';
                        break;
                    case 'AI';
                        $SQL .= " IFNULL(SUM(vid.AcceptInvitation),0) as " . $val . ',';
                        break;
                    case 'CO';
                        $SQL .= " IFNULL(SUM(vid.Close),0) as " . $val . ',';
                        break;
                    case 'PG';
                        $SQL .= " IFNULL(SUM(vid.Progress),0) as " . $val . ',';
                        break;
                    case 'SK';
                        $SQL .= " IFNULL(SUM(vid.Skip),0) as " . $val . ',';
                        break;
                    case 'CLL';
                        $SQL .= " IFNULL(SUM(vid.CloseLinear),0) as " . $val . ',';
                        break;
                    case 'EFS';
                        $SQL .= " IFNULL(SUM(vid.Exitfullscreen),0) as " . $val . ',';
                        break;
                    case 'AIL';
                        $SQL .= " IFNULL(SUM(vid.AcceptInvitationLinear) ,0)as " . $val . ',';
                        break;
                    case 'RW';
                        $SQL .= " IFNULL(SUM(vid.Rewind),0) as " . $val . ',';
                        break;
                    case 'BSTR';
                        $SQL .= " IFNULL(SUM(vid.Breakstart),0) as " . $val . ',';
                        break;
                    case 'BEND';
                        $SQL .= " IFNULL(SUM(vid.Breakend),0) as " . $val . ',';
                        break;    
                    case 'BAN_ID';
                        $SQL .= " vid.creative_id as " . $val . ',';
                        $SQL .= " (oxb.description) as BAN_NAME,";
                        break;
                  
                }
            }
            
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM
						(
							SELECT
								DATE(vas.interval_start) AS date,
								vas.creative_id,
								CASE WHEN vast_event_name = 'Started' THEN vas.count END AS Started,
								CASE WHEN vast_event_name = 'midpoint' THEN vas.count END AS midpoint,
								CASE WHEN vast_event_name = 'firstQuartile' THEN vas.count END AS firstQuartile,
								CASE WHEN vast_event_name = 'thirdQuartile' THEN vas.count END AS thirdQuartile,
								CASE WHEN vast_event_name = 'Completed' THEN vas.count END AS Completed, 
								CASE WHEN vast_event_name = 'Muted' THEN vas.count END AS Muted,
								CASE WHEN vast_event_name = 'Fullscreen' THEN vas.count END AS Fullscreen,
								CASE WHEN vast_event_name = 'Unmute' THEN vas.count END AS Unmute,
								CASE WHEN vast_event_name = 'PausetoPlay' THEN vas.count END AS PausetoPlay,
								CASE WHEN vast_event_name = 'Paused' THEN vas.count END AS Paused,
								CASE WHEN vast_event_name = 'CreativeView' THEN vas.count END AS CreativeView,
								CASE WHEN vast_event_name = 'Expand' THEN vas.count END AS Expand,
								CASE WHEN vast_event_name = 'Collapse' THEN vas.count END AS Collapse,
								CASE WHEN vast_event_name = 'AcceptInvitation' THEN vas.count END AS AcceptInvitation,
								CASE WHEN vast_event_name = 'Close' THEN vas.count END AS Close, 
								CASE WHEN vast_event_name = 'Progress' THEN vas.count END AS Progress,
								CASE WHEN vast_event_name = 'Skip' THEN vas.count END AS Skip,
								CASE WHEN vast_event_name = 'CloseLinear' THEN vas.count END AS CloseLinear,
								CASE WHEN vast_event_name = 'Exitfullscreen' THEN vas.count END AS Exitfullscreen,
								CASE WHEN vast_event_name = 'AcceptInvitationLinear' THEN vas.count END AS AcceptInvitationLinear,
								CASE WHEN vast_event_name = 'Rewind' THEN vas.count END AS Rewind,
								CASE WHEN vast_event_name = 'breakStart' THEN vas.count END AS Breakstart,
								CASE WHEN vast_event_name = 'breakEnd' THEN vas.count END AS Breakend
								
							  FROM 
							  	djax_conf_banner_vast_events
							  JOIN 
							  (
									SELECT vast.interval_start, vast.creative_id, vast.zone_id, vast.vast_event_id, SUM(vast.count) as count
									FROM
									(
										SELECT 
											ox_stats_vast.interval_start, 
											ox_stats_vast.creative_id, 
											ox_stats_vast.zone_id, 
											ox_stats_vast.vast_event_id, 
											ox_stats_vast.count 
										FROM ox_stats_vast 
										JOIN  djax_conf_banner_vast_events 
										ON djax_conf_banner_vast_events.vast_event_id=ox_stats_vast.vast_event_id 
										GROUP BY 
	ox_stats_vast.vast_event_id,ox_stats_vast.zone_id,ox_stats_vast.creative_id,ox_stats_vast.interval_start
									) AS vast
									GROUP BY vast_event_id, zone_id, creative_id, interval_start
									ORDER BY interval_start, creative_id, zone_id
							  ) AS vas ON vas.vast_event_id=djax_conf_banner_vast_events.vast_event_id							  						) AS vid ";
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            { 
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    if (isset($search['creative_id']) AND $search['creative_id'] != '')
                    {
                        $SQL .= " JOIN ox_banners as oxb ON (oxb.bannerid=vid.creative_id AND oxb.bannerid='" . $search['creative_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=vid.creative_id";
                    }
                    $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . "  AND  oxcl.agencyid=" . $search['agency_id'] . ")";
                }
            }
            $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(vid.date,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
            }
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,";
                            break;
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }
	}
	//return $SQL;
        $query = $this->db->query($SQL);
        
       //echo  $SQL;exit("kjkk");
       //log_message("error",$this->db->last_query());
        if ($dataTable)
        {
            $data = $query->result_array();
            if ($data)
            {
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;
            }
        }
    }
    
	 function fetch_video_adblock($network_id = FALSE, $network_account_id = FALSE, $account_id = FALSE)
    {
        
        $SQL = "SELECT zonename,affiliateid,zoneid FROM `ox_zones` WHERE 1 ORDER BY zonename ASC";
        
        $query = $this->db->query($SQL);
       
       
        if ($query->num_rows() > 0) {
  
            $query = $query->result_array();
            
            return $query;
        } else {
            return FALSE;
        }
    }
    
    function fetch_age_stats($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
	    if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'IMP';
                        $SQL .= " SUM(dgs.impressions) as " . $val . ',';
                        break;
                    case 'CLK';
                        $SQL .= " SUM(dgs.clicks) as " . $val . ',';
                        break;
                    case 'UIMP';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_impressions) as " . $val . ",";
                        }
                        break;
                    case 'UCLK';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_clicks) as " . $val . ",";
                        }
                        break;
                    case 'CON';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.conversions) as " . $val . ',';
                        }
                        break;
                    case 'CTR';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " FORMAT(((SUM(dgs.clicks)/SUM(dgs.impressions))*100),2) as " . $val . ',';
                        }
                        break;
                    case 'ACC_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxcl.account_id) as " . $val . ',';
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                        }
                        else if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxaff.account_id) as " . $val . ',';
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        break;
                    case 'CAM_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxc.campaignid) as " . $val . ',';
                            $SQL .= " (oxc.campaignname) as CAM_NAME,";
                        }
                        break;
                    case 'BAN_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxb.bannerid) as " . $val . ',';
                            $SQL .= " (oxb.description) as BAN_NAME,";
                        }
                        break;
                    case 'SITE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxps.site_id) as " . $val . ',';
                            $SQL .= " (oxps.site_name) as SITE_NAME,";
                            $SQL .= " (oxps.site_url) as SITE_URL,";
                        }
                        break;
                    case 'ZONE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxz.zoneid) as " . $val . ',';
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                        }
                        break;
                    case 'ENV';
                        $SQL .= " (dgs.delivery_media_type) as " . $val . ",";
                        break;
                    case 'AGE';
                        $SQL .= " (dgs.age) as " . $val . ",";
                        break;
                   
                }
            }
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM djax_age_stats as dgs";
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            {
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    
                    if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
                    $SQL .= " AND dgs.age='" . $search['site'] . "'";
                    }
                     $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "TRAFFICKER")
                {
                    //// GET STATISTICS VALUES FOR AN TRAFFICKER
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER")
                {
                    // LINK ADVERTISER RELATED TABLES
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['adv_account_id']) AND $search['adv_account_id'] != '')
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['adv_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
                    }
                    //$SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    // LINK TRAFFICKER RELATED TABLES
                    $SQL .= " LEFT JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " LEFT JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '')
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id=" . $search['pub_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id)";
                    }
                }
            }
            $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
                if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND delivery_media_type='" . $search['environment'] . "'";
                }if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
                    $SQL .= " AND dgs.age='" . $search['site'] . "'";
                    }
            }
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'ACC_ID';
                            if ($search['account_type'] !== "TRAFFICKER")
                            {
                                $SQL .= "oxcl.account_id,";
                            }
                            else if ($search['account_type'] !== "ADVERTISER")
                            {
                                $SQL .= "oxaff.account_id,";
                            }
                            break;
                        case 'CAM_ID';
                            $SQL .= "oxc.campaignid,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,";
                            break;
                        case 'SITE_ID';
                            $SQL .= "oxps.site_id,";
                            break;
                        case 'ZONE_ID';
                            $SQL .= "oxz.zoneid,";
                            break;
                        case 'ENV';
                            $SQL .= "delivery_media_type,";
                            break;
                        case 'AGE';
                            $SQL .= "dgs.age,";
                            break;
                       
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
					if($key=='AGE')
					{
						$SQL.=" length(age),age";
					}
					else
					{
						$SQL .= " {$key} {$option},";   	
					}
					
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }
        //return $SQL; exit;
        $query = $this->db->query($SQL);
        log_message('error',$this->db->last_query());
        if ($dataTable)
        {
            $data = $query->result_array();
            if ($data)
            {
                //~ $data = array_map('callbackformat', $data);
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;
            }
        }
    }
  function fetch_gender_stats($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
		
        if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'IMP';
                        $SQL .= " SUM(dgs.impressions) as " . $val . ',';
                        break;
                    case 'CLK';
                        $SQL .= " SUM(dgs.clicks) as " . $val . ',';
                        break;
                    case 'UIMP';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_impressions) as " . $val . ",";
                        }
                        break;
                    case 'UCLK';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_clicks) as " . $val . ",";
                        }
                        break;
                    case 'CON';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.conversions) as " . $val . ',';
                        }
                        break;
                    case 'CTR';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " FORMAT(((SUM(dgs.clicks)/SUM(dgs.impressions))*100),2) as " . $val . ',';
                        }
                        break;
                    case 'ACC_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxcl.account_id) as " . $val . ',';
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                        }
                        else if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxaff.account_id) as " . $val . ',';
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        break;
                    case 'CAM_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxc.campaignid) as " . $val . ',';
                            $SQL .= " (oxc.campaignname) as CAM_NAME,";
                        }
                        break;
                    case 'BAN_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxb.bannerid) as " . $val . ',';
                            $SQL .= " (oxb.description) as BAN_NAME,";
                        }
                        break;
                    case 'SITE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxps.site_id) as " . $val . ',';
                            $SQL .= " (oxps.site_name) as SITE_NAME,";
                            $SQL .= " (oxps.site_url) as SITE_URL,";
                        }
                        break;
                    case 'ZONE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxz.zoneid) as " . $val . ',';
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                        }
                        break;
                    case 'ENV';
                        $SQL .= " (dgs.delivery_media_type) as " . $val . ",";
                        break;
                    case 'GENDER';
                        $SQL .= " (dgs.gender) as " . $val . ",";
                        break;
                   
                }
            }
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM djax_gender_stats as dgs";
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            {
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
						
						/*DAC020 On Feb 15,2020*/
						
                    $SQL .= " AND dgs.gender='" . $search['site'] . "'";
                    }
                     $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "TRAFFICKER")
                {
                    //// GET STATISTICS VALUES FOR AN TRAFFICKER
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER")
                {
                    // LINK ADVERTISER RELATED TABLES
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['adv_account_id']) AND $search['adv_account_id'] != '')
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['adv_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
                    }
                    //$SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    // LINK TRAFFICKER RELATED TABLES
                    $SQL .= " LEFT JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " LEFT JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '')
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id=" . $search['pub_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id)";
                    }
                }
            }
            $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
                if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND delivery_media_type='" . $search['environment'] . "'";
                }if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
						/*DAC020 On Feb 15,2020*/
                    $SQL .= " AND dgs.gender='" . $search['site'] . "'";
                    }
            }
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'ACC_ID';
                            if ($search['account_type'] !== "TRAFFICKER")
                            {
                                $SQL .= "oxcl.account_id,";
                            }
                            else if ($search['account_type'] !== "ADVERTISER")
                            {
                                $SQL .= "oxaff.account_id,";
                            }
                            break;
                        case 'CAM_ID';
                            $SQL .= "oxc.campaignid,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,";
                            break;
                        case 'SITE_ID';
                            $SQL .= "oxps.site_id,";
                            break;
                        case 'ZONE_ID';
                            $SQL .= "oxz.zoneid,";
                            break;
                        case 'ENV';
                            $SQL .= "delivery_media_type,";
                            break;
                        case 'GENDER';
                            $SQL .= " dgs.gender,";
                            break;
                       
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }
		
		//print_r($SQL);   exit;
      
        $query = $this->db->query($SQL);
       
        if ($dataTable)
        {
            $data = $query->result_array();
            if ($data)
            {
                $data = array_map('callbackformat', $data);
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;
            }
        }
    }    
   function fetch_site_stats($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
      		
        if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'IMP';
                        $SQL .= " SUM(dgs.impressions) as " . $val . ',';
                        break;
                    case 'CLK';
                        $SQL .= " SUM(dgs.clicks) as " . $val . ',';
                        break;
                    case 'UIMP';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_impressions) as " . $val . ",";
                        }
                        break;
                    case 'UCLK';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_clicks) as " . $val . ",";
                        }
                        break;
                    case 'CON';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.conversions) as " . $val . ',';
                        }
                        break;
                    case 'CTR';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " FORMAT(((SUM(dgs.clicks)/SUM(dgs.impressions))*100),2) as " . $val . ',';
                        }
                        break;
                    case 'ACC_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxcl.account_id) as " . $val . ',';
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                        }
                        else if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxaff.account_id) as " . $val . ',';
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        break;
                    case 'CAM_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxc.campaignid) as " . $val . ',';
                            $SQL .= " (oxc.campaignname) as CAM_NAME,";
                        }
                        break;
                    case 'BAN_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxb.bannerid) as " . $val . ',';
                            $SQL .= " (oxb.description) as BAN_NAME,";
                        }
                        break;
                    case 'SITE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxps.site_id) as " . $val . ',';
                            $SQL .= " (oxps.site_name) as SITE_NAME,";
                            $SQL .= " (oxps.site_url) as SITE_URL,";
                        }
                        break;
                    case 'ZONE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxz.zoneid) as " . $val . ',';
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                        }
                        break;
                    case 'ENV';
                        $SQL .= " (dgs.delivery_media_type) as " . $val . ",";
                        break;
                    case 'SITE';
                        $SQL .= " (dgs.site) as " . $val . ",";
                        break;
                   
                }
            }
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM djax_site_stats as dgs";
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            {
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                   {
					   /*DAC020 ON FEB15,2020*/
                    //$SQL .= " AND dgs.site_id='" . $search['site'] . "'";
					 $SQL .= " AND dgs.site='" . $search['site'] . "'";  
                   }
                     
                     $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "TRAFFICKER")
                {
                    //// GET STATISTICS VALUES FOR AN TRAFFICKER
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER")
                {
                    // LINK ADVERTISER RELATED TABLES
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['adv_account_id']) AND $search['adv_account_id'] != '')
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['adv_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
                    }
                    //$SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    // LINK TRAFFICKER RELATED TABLES
                    $SQL .= " LEFT JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " LEFT JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '')
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id=" . $search['pub_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id)";
                    }
                }
            }
            $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
                if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND delivery_media_type='" . $search['environment'] . "'";
                }
              if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
						/*DAC020 - Feb15,2020*/
						
                    //$SQL .= " AND dgs.site_id='" . $search['site'] . "'";
					
					$SQL .= " AND dgs.site='" . $search['site'] . "'";
					
                    }
            }
              
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'ACC_ID';
                            if ($search['account_type'] !== "TRAFFICKER")
                            {
                                $SQL .= "oxcl.account_id,";
                            }
                            else if ($search['account_type'] !== "ADVERTISER")
                            {
                                $SQL .= "oxaff.account_id,";
                            }
                            break;
                        case 'CAM_ID';
                            $SQL .= "oxc.campaignid,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,";
                            break;
                        case 'SITE_ID';
                            $SQL .= "oxps.site_id,";
                            break;
                        case 'ZONE_ID';
                            $SQL .= "oxz.zoneid,";
                            break;
                        case 'ENV';
                            $SQL .= "delivery_media_type,";
                            break;
                        case 'SITE';
                            $SQL .= " dgs.site,";
                            break;
                       
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }
				      
        $query = $this->db->query($SQL);
       
        if ($dataTable)
        {
            $data = $query->result_array();
            if ($data)
            {
                $data = array_map('callbackformat', $data);
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;
            }
        }
    }    
    
  function fetch_sentiment_stats($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
	    if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'IMP';
                        $SQL .= " SUM(dgs.impressions) as " . $val . ',';
                        break;
                    case 'CLK';
                        $SQL .= " SUM(dgs.clicks) as " . $val . ',';
                        break;
                    case 'UIMP';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_impressions) as " . $val . ",";
                        }
                        break;
                    case 'UCLK';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_clicks) as " . $val . ",";
                        }
                        break;
                    case 'CON';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.conversions) as " . $val . ',';
                        }
                        break;
                    case 'CTR';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " FORMAT(((SUM(dgs.clicks)/SUM(dgs.impressions))*100),2) as " . $val . ',';
                        }
                        break;
                    case 'ACC_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxcl.account_id) as " . $val . ',';
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                        }
                        else if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxaff.account_id) as " . $val . ',';
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        break;
                    case 'CAM_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxc.campaignid) as " . $val . ',';
                            $SQL .= " (oxc.campaignname) as CAM_NAME,";
                        }
                        break;
                    case 'BAN_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxb.bannerid) as " . $val . ',';
                            $SQL .= " (oxb.description) as BAN_NAME,";
                        }
                        break;
                    case 'SITE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxps.site_id) as " . $val . ',';
                            $SQL .= " (oxps.site_name) as SITE_NAME,";
                            $SQL .= " (oxps.site_url) as SITE_URL,";
                        }
                        break;
                    case 'ZONE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxz.zoneid) as " . $val . ',';
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                        }
                        break;
                    case 'ENV';
                        $SQL .= " (dgs.delivery_media_type) as " . $val . ",";
                        break;
                    case 'SENTIMENT';
                        $SQL .= " (dgs.sentiment) as " . $val . ",";
                        break;
                   
                }
            }
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM djax_sentiment_stats as dgs";
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            {
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
                    $SQL .= " AND dgs.sentiment='" . $search['site'] . "'";
                    }
                     $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "TRAFFICKER")
                {
                    //// GET STATISTICS VALUES FOR AN TRAFFICKER
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER")
                {
                    // LINK ADVERTISER RELATED TABLES
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['adv_account_id']) AND $search['adv_account_id'] != '')
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['adv_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
                    }
                    //$SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    // LINK TRAFFICKER RELATED TABLES
                    $SQL .= " LEFT JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " LEFT JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '')
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id=" . $search['pub_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id)";
                    }
                    
                }
            }
            $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
                if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND delivery_media_type='" . $search['environment'] . "'";
                }
                 if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
                    $SQL .= " AND dgs.sentiment='" . $search['site'] . "'";
                    }
            }
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'ACC_ID';
                            if ($search['account_type'] !== "TRAFFICKER")
                            {
                                $SQL .= "oxcl.account_id,";
                            }
                            else if ($search['account_type'] !== "ADVERTISER")
                            {
                                $SQL .= "oxaff.account_id,";
                            }
                            break;
                        case 'CAM_ID';
                            $SQL .= "oxc.campaignid,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,";
                            break;
                        case 'SITE_ID';
                            $SQL .= "oxps.site_id,";
                            break;
                        case 'ZONE_ID';
                            $SQL .= "oxz.zoneid,";
                            break;
                        case 'ENV';
                            $SQL .= "delivery_media_type,";
                            break;
                        case 'SENTIMENT';
                            $SQL .= " dgs.sentiment,";
                            break;
                       
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }	
		      
        $query = $this->db->query($SQL);
        
        if ($dataTable)
        {
            $data = $query->result_array();
            if ($data)
            {
                $data = array_map('callbackformat', $data);
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;  
            }
        }
    }       


   function fetch_targeting_sites($detail)
   {
	   if(!empty($detail['account_id']))
	   {		
		   $SQL = "select distinct(site) FROM djax_site_stats as dgs join ox_clients as oxcl join ox_campaigns as oxc ON oxc.clientid=oxcl.clientid join ox_banners as oxb ON oxc.campaignid=oxb.campaignid and dgs.ad_id=oxb.bannerid where oxcl.account_id=".$detail['account_id']." AND site!=''";
	   }
	   else
	   {
		   $SQL="select distinct(site) FROM djax_site_stats as dgs";
	   }
	   
	   $query = $this->db->query($SQL);
	   $data  = $query->result_array();  
	   if($data)
	   {
		   return $data;
	   }
	   else	   
	   {
		   return FALSE;
	   }
	      
   }
   
   function fetch_targeting_gender($detail)
   {
	   if(!empty($detail['account_id']))
	   {
		   $SQL = "select distinct(gender) FROM djax_gender_stats as dgs join ox_clients as oxcl join ox_campaigns as oxc ON oxc.clientid=oxcl.clientid join ox_banners as oxb ON oxc.campaignid=oxb.campaignid and dgs.ad_id=oxb.bannerid where oxcl.account_id=".$detail['account_id']." AND gender!=''";
	   }
	   else
	   {
		   $SQL="select distinct(gender) FROM djax_gender_stats as dgs";
	   }
	   $query = $this->db->query($SQL);
	   $data  = $query->result_array();
	   if($data)
	   {
		   return $data;
	   }
	   else	   
	   {
		   return FALSE;
	   }
   }
   
   function fetch_targeting_sentiment($detail)
   {
	   if(!empty($detail['account_id']))
	   {
		   $SQL = "select distinct(sentiment) FROM djax_sentiment_stats as dgs join ox_clients as oxcl join ox_campaigns as oxc ON oxc.clientid=oxcl.clientid join ox_banners as oxb ON oxc.campaignid=oxb.campaignid and dgs.ad_id=oxb.bannerid where oxcl.account_id=".$detail['account_id']." AND sentiment!=''";
	   }
	   else
	   {
		   $SQL = "select distinct(sentiment) FROM djax_sentiment_stats";
	   }
	   $query = $this->db->query($SQL);
	   $data  = $query->result_array();  
	   if($data)
	   {
		   return $data;
	   }
	   else	   
	   {
		   return FALSE;
	   }
   }
   
   function fetch_targeting_age($detail)
   {	
	   if(!empty($detail['account_id']))
	   {
		  $SQL = "select distinct(age) FROM djax_age_stats as dgs join ox_clients as oxcl join ox_campaigns as oxc ON oxc.clientid=oxcl.clientid join ox_banners as oxb ON oxc.campaignid=oxb.campaignid and dgs.ad_id=oxb.bannerid where oxcl.account_id=".$detail['account_id']." AND age!='' order by length(age),age";
	   }
	   else
	   {
		  $SQL = "select distinct(age) FROM djax_age_stats";
	   }
	   $query = $this->db->query($SQL);
	   $data  = $query->result_array();
	   if($data)
	   {
		   return $data;
	   }
	   else	   
	   {
		   return FALSE;
	   }	   
   }
   
   	public function fetch_custom_targeting1()
	{
		$query = $this->db->get(TAB_CUSTOM_TARGETING1_STATS);
        if ($query->num_rows() > 0) 
		{
            $result = $query->result_array();
            return $result;
        }
		else
		{
            return FALSE;
        }
	}
	
	function fetch_targeting_customtarg1($detail)
   {
	   
	   if(!empty($detail['account_id']))
	   {
		   $SQL = "select distinct(customtarg1) FROM djax_customtarg1_stats as dgs join ox_clients as oxcl join ox_campaigns as oxc ON oxc.clientid=oxcl.clientid join ox_banners as oxb ON oxc.campaignid=oxb.campaignid and dgs.ad_id=oxb.bannerid where oxcl.account_id=".$detail['account_id']." AND customtarg1!=''";
	   }
	   else
	   {
		   $SQL = "select distinct(customtarg1) FROM djax_customtarg1_stats";
	   }
	   $query = $this->db->query($SQL);
	   //~ return $this->db->last_query();
	   $data  = $query->result_array();  
	   if($data)
	   {
		   return $data;
	   }
	   else	   
	   {
		   return FALSE;
	   }
   }
   
	function fetch_targeting_customtarg2($detail)
	   {
	   
	   if(!empty($detail['account_id']))
	   {
		   $SQL = "select distinct(customtarg2) FROM djax_customtarg2_stats as dgs join ox_clients as oxcl join ox_campaigns as oxc ON oxc.clientid=oxcl.clientid join ox_banners as oxb ON oxc.campaignid=oxb.campaignid and dgs.ad_id=oxb.bannerid where oxcl.account_id=".$detail['account_id']." AND customtarg2!=''";
	   }
	   else
	   {
		   $SQL = "select distinct(customtarg2) FROM djax_customtarg2_stats";
	   }
	   $query = $this->db->query($SQL);
	   //~ return $this->db->last_query();
	   $data  = $query->result_array();  
	   if($data)
	   {
		   return $data;
	   }
	   else	   
	   {
		   return FALSE;
	   }
   }
   
   function fetch_targeting_customtarg3($detail)
	   {
	   
	   if(!empty($detail['account_id']))
	   {
		   $SQL = "select distinct(customtarg3) FROM djax_customtarg3_stats as dgs join ox_clients as oxcl join ox_campaigns as oxc ON oxc.clientid=oxcl.clientid join ox_banners as oxb ON oxc.campaignid=oxb.campaignid and dgs.ad_id=oxb.bannerid where oxcl.account_id=".$detail['account_id']." AND customtarg3!=''";
	   }
	   else
	   {
		   $SQL = "select distinct(customtarg3) FROM djax_customtarg3_stats";
	   }
	   $query = $this->db->query($SQL);
	   //~ return $this->db->last_query();
	   $data  = $query->result_array();  
	   if($data)
	   {
		   return $data;
	   }
	   else	   
	   {
		   return FALSE;
	   }
   }
   function fetch_targeting_customtarg4($detail)
	   {
	   
	   if(!empty($detail['account_id']))
	   {
		   $SQL = "select distinct(customtarg4) FROM djax_customtarg4_stats as dgs join ox_clients as oxcl join ox_campaigns as oxc ON oxc.clientid=oxcl.clientid join ox_banners as oxb ON oxc.campaignid=oxb.campaignid and dgs.ad_id=oxb.bannerid where oxcl.account_id=".$detail['account_id']." AND customtarg4!=''";
	   }
	   else
	   {
		   $SQL = "select distinct(customtarg4) FROM djax_customtarg4_stats";
	   }
	   $query = $this->db->query($SQL);
	   //~ return $this->db->last_query();
	   $data  = $query->result_array();  
	   if($data)
	   {
		   return $data;
	   }
	   else	   
	   {
		   return FALSE;
	   }
   }
   
    function fetch_customtarg1_stats($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
		
	    if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'IMP';
                        $SQL .= " SUM(dgs.impressions) as " . $val . ',';
                        break;
                    case 'CLK';
                        $SQL .= " SUM(dgs.clicks) as " . $val . ',';
                        break;
                    case 'UIMP';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_impressions) as " . $val . ",";
                        }
                        break;
                    case 'UCLK';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_clicks) as " . $val . ",";
                        }
                        break;
                    case 'CON';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.conversions) as " . $val . ',';
                        }
                        break;
                    case 'CTR';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " FORMAT(((SUM(dgs.clicks)/SUM(dgs.impressions))*100),2) as " . $val . ',';
                        }
                        break;
                    case 'ACC_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxcl.account_id) as " . $val . ',';
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                        }
                        else if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxaff.account_id) as " . $val . ',';
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        break;
                    case 'CAM_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxc.campaignid) as " . $val . ',';
                            $SQL .= " (oxc.campaignname) as CAM_NAME,";
                        }
                        break;
                    case 'BAN_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxb.bannerid) as " . $val . ',';
                            $SQL .= " (oxb.description) as BAN_NAME,";
                        }
                        break;
                    case 'SITE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxps.site_id) as " . $val . ',';
                            $SQL .= " (oxps.site_name) as SITE_NAME,";
                            $SQL .= " (oxps.site_url) as SITE_URL,";
                        }
                        break;
                    case 'ZONE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxz.zoneid) as " . $val . ',';
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                        }
                        break;
                    case 'ENV';
                        $SQL .= " (dgs.delivery_media_type) as " . $val . ",";
                        break;
                    case 'CUSTOMTARG1';
                        $SQL .= " (dgs.customtarg1) as " . $val . ",";
                        break;
                   
                }
            }
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM djax_customtarg1_stats as dgs";
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            {
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
                    $SQL .= " AND dgs.customtarg1='" . $search['site'] . "'";
                    }
                     $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "TRAFFICKER")
                {
                    //// GET STATISTICS VALUES FOR AN TRAFFICKER
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER")
                {
                    // LINK ADVERTISER RELATED TABLES
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['adv_account_id']) AND $search['adv_account_id'] != '')
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['adv_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
                    }
                    //$SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    // LINK TRAFFICKER RELATED TABLES
                    $SQL .= " LEFT JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " LEFT JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '')
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id=" . $search['pub_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id)";
                    }
                    
                }
            }
            $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
                if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND delivery_media_type='" . $search['environment'] . "'";
                }
                 if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
                    $SQL .= " AND dgs.customtarg1='" . $search['site'] . "'";
                    }
            }
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'ACC_ID';
                            if ($search['account_type'] !== "TRAFFICKER")
                            {
                                $SQL .= "oxcl.account_id,";
                            }
                            else if ($search['account_type'] !== "ADVERTISER")
                            {
                                $SQL .= "oxaff.account_id,";
                            }
                            break;
                        case 'CAM_ID';
                            $SQL .= "oxc.campaignid,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,";
                            break;
                        case 'SITE_ID';
                            $SQL .= "oxps.site_id,";
                            break;
                        case 'ZONE_ID';
                            $SQL .= "oxz.zoneid,";
                            break;
                        case 'ENV';
                            $SQL .= "delivery_media_type,";
                            break;
                        case 'CUSTOMTARG1';
                            $SQL .= " dgs.customtarg1,";
                            break;
                       
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }	
		      
        $query = $this->db->query($SQL);
       //~ return $this->db->last_query(); 
        if ($dataTable)
        {
            $data = $query->result_array();
            if ($data)
            {
                $data = array_map('callbackformat', $data);
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;  
            }
        }
    }       

	function fetch_customtarg2_stats($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
		
	    if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'IMP';
                        $SQL .= " SUM(dgs.impressions) as " . $val . ',';
                        break;
                    case 'CLK';
                        $SQL .= " SUM(dgs.clicks) as " . $val . ',';
                        break;
                    case 'UIMP';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_impressions) as " . $val . ",";
                        }
                        break;
                    case 'UCLK';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_clicks) as " . $val . ",";
                        }
                        break;
                    case 'CON';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.conversions) as " . $val . ',';
                        }
                        break;
                    case 'CTR';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " FORMAT(((SUM(dgs.clicks)/SUM(dgs.impressions))*100),2) as " . $val . ',';
                        }
                        break;
                    case 'ACC_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxcl.account_id) as " . $val . ',';
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                        }
                        else if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxaff.account_id) as " . $val . ',';
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        break;
                    case 'CAM_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxc.campaignid) as " . $val . ',';
                            $SQL .= " (oxc.campaignname) as CAM_NAME,";
                        }
                        break;
                    case 'BAN_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxb.bannerid) as " . $val . ',';
                            $SQL .= " (oxb.description) as BAN_NAME,";
                        }
                        break;
                    case 'SITE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxps.site_id) as " . $val . ',';
                            $SQL .= " (oxps.site_name) as SITE_NAME,";
                            $SQL .= " (oxps.site_url) as SITE_URL,";
                        }
                        break;
                    case 'ZONE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxz.zoneid) as " . $val . ',';
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                        }
                        break;
                    case 'ENV';
                        $SQL .= " (dgs.delivery_media_type) as " . $val . ",";
                        break;
                    case 'CUSTOMTARG2';
                        $SQL .= " (dgs.customtarg2) as " . $val . ",";
                        break;
                   
                }
            }
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM djax_customtarg2_stats as dgs";
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            {
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
                    $SQL .= " AND dgs.customtarg2='" . $search['site'] . "'";
                    }
                     $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "TRAFFICKER")
                {
                    //// GET STATISTICS VALUES FOR AN TRAFFICKER
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER")
                {
                    // LINK ADVERTISER RELATED TABLES
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['adv_account_id']) AND $search['adv_account_id'] != '')
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['adv_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
                    }
                    //$SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    // LINK TRAFFICKER RELATED TABLES
                    $SQL .= " LEFT JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " LEFT JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '')
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id=" . $search['pub_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id)";
                    }
                    
                }
            }
            $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
                if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND delivery_media_type='" . $search['environment'] . "'";
                }
                 if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
                    $SQL .= " AND dgs.customtarg2='" . $search['site'] . "'";
                    }
            }
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'ACC_ID';
                            if ($search['account_type'] !== "TRAFFICKER")
                            {
                                $SQL .= "oxcl.account_id,";
                            }
                            else if ($search['account_type'] !== "ADVERTISER")
                            {
                                $SQL .= "oxaff.account_id,";
                            }
                            break;
                        case 'CAM_ID';
                            $SQL .= "oxc.campaignid,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,";
                            break;
                        case 'SITE_ID';
                            $SQL .= "oxps.site_id,";
                            break;
                        case 'ZONE_ID';
                            $SQL .= "oxz.zoneid,";
                            break;
                        case 'ENV';
                            $SQL .= "delivery_media_type,";
                            break;
                        case 'CUSTOMTARG2';
                            $SQL .= " dgs.customtarg2,";
                            break;
                       
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }	
		      
        $query = $this->db->query($SQL);
       //~ return $this->db->last_query(); 
        if ($dataTable)
        {
            $data = $query->result_array();
            if ($data)
            {
                $data = array_map('callbackformat', $data);
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;  
            }
        }
    }       


	function fetch_customtarg3_stats($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
		
	    if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'IMP';
                        $SQL .= " SUM(dgs.impressions) as " . $val . ',';
                        break;
                    case 'CLK';
                        $SQL .= " SUM(dgs.clicks) as " . $val . ',';
                        break;
                    case 'UIMP';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_impressions) as " . $val . ",";
                        }
                        break;
                    case 'UCLK';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_clicks) as " . $val . ",";
                        }
                        break;
                    case 'CON';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.conversions) as " . $val . ',';
                        }
                        break;
                    case 'CTR';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " FORMAT(((SUM(dgs.clicks)/SUM(dgs.impressions))*100),2) as " . $val . ',';
                        }
                        break;
                    case 'ACC_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxcl.account_id) as " . $val . ',';
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                        }
                        else if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxaff.account_id) as " . $val . ',';
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        break;
                    case 'CAM_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxc.campaignid) as " . $val . ',';
                            $SQL .= " (oxc.campaignname) as CAM_NAME,";
                        }
                        break;
                    case 'BAN_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxb.bannerid) as " . $val . ',';
                            $SQL .= " (oxb.description) as BAN_NAME,";
                        }
                        break;
                    case 'SITE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxps.site_id) as " . $val . ',';
                            $SQL .= " (oxps.site_name) as SITE_NAME,";
                            $SQL .= " (oxps.site_url) as SITE_URL,";
                        }
                        break;
                    case 'ZONE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxz.zoneid) as " . $val . ',';
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                        }
                        break;
                    case 'ENV';
                        $SQL .= " (dgs.delivery_media_type) as " . $val . ",";
                        break;
                    case 'CUSTOMTARG3';
                        $SQL .= " (dgs.customtarg3) as " . $val . ",";
                        break;
                   
                }
            }
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM djax_customtarg3_stats as dgs";
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            {
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
                    $SQL .= " AND dgs.customtarg3='" . $search['site'] . "'";
                    }
                     $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "TRAFFICKER")
                {
                    //// GET STATISTICS VALUES FOR AN TRAFFICKER
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER")
                {
                    // LINK ADVERTISER RELATED TABLES
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['adv_account_id']) AND $search['adv_account_id'] != '')
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['adv_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
                    }
                    //$SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    // LINK TRAFFICKER RELATED TABLES
                    $SQL .= " LEFT JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " LEFT JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '')
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id=" . $search['pub_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id)";
                    }
                    
                }
            }
            $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
                if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND delivery_media_type='" . $search['environment'] . "'";
                }
                 if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
                    $SQL .= " AND dgs.customtarg3='" . $search['site'] . "'";
                    }
            }
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'ACC_ID';
                            if ($search['account_type'] !== "TRAFFICKER")
                            {
                                $SQL .= "oxcl.account_id,";
                            }
                            else if ($search['account_type'] !== "ADVERTISER")
                            {
                                $SQL .= "oxaff.account_id,";
                            }
                            break;
                        case 'CAM_ID';
                            $SQL .= "oxc.campaignid,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,";
                            break;
                        case 'SITE_ID';
                            $SQL .= "oxps.site_id,";
                            break;
                        case 'ZONE_ID';
                            $SQL .= "oxz.zoneid,";
                            break;
                        case 'ENV';
                            $SQL .= "delivery_media_type,";
                            break;
                        case 'CUSTOMTARG3';
                            $SQL .= " dgs.customtarg3,";
                            break;
                       
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }	
		      
        $query = $this->db->query($SQL);
       //~ return $this->db->last_query(); 
        if ($dataTable)
        {
            $data = $query->result_array();
            if ($data)
            {
                $data = array_map('callbackformat', $data);
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;  
            }
        }
    }       
    
     function fetch_customtarg4_stats($columns, $search, $group, $order, $limit, $dataTable = FALSE)
    {
		
	    if (is_array($group) AND in_array('DATE', $group))
        {
            $date_field = "DATE(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('TIME', $group))
        {
            $date_field = "TIME(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))";
        }
        else if (is_array($group) AND in_array('MONTH', $group))
        {
            $date_field = "DATE_FORMAT(CONVERT_TZ(dgs.date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'),'%b %Y')";
        }
        /*
        DATE
        IMP
        CLK
        UIMP // !Publisher
        UCLK // !Publisher
        CON
        SPEND // !Publisher
        PUB_EARN // ! Advertiser
        ADM_EARN // ! Advertiser & !Publisher
        CTR // !Publisher
        ECPM // !Publisher
        PUB_ECPM // !advertiser
        CAM_ID
        CAM_NAME
        BAN_ID
        BAN_NAME
        ACC_ID
        SITE_ID
        ZONE_ID
        
        */
        $SQL = "SELECT";
        if (is_array($columns) AND count($columns) > 0)
        {
            foreach ($columns as $val)
            {
                switch (strtoupper($val))
                {
                    case 'DATE';
                        $SQL .= " {$date_field} as " . $val . ',';
                        break;
                    case 'IMP';
                        $SQL .= " SUM(dgs.impressions) as " . $val . ',';
                        break;
                    case 'CLK';
                        $SQL .= " SUM(dgs.clicks) as " . $val . ',';
                        break;
                    case 'UIMP';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_impressions) as " . $val . ",";
                        }
                        break;
                    case 'UCLK';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.uniq_clicks) as " . $val . ",";
                        }
                        break;
                    case 'CON';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " SUM(dgs.conversions) as " . $val . ',';
                        }
                        break;
                    case 'CTR';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " FORMAT(((SUM(dgs.clicks)/SUM(dgs.impressions))*100),2) as " . $val . ',';
                        }
                        break;
                    case 'ACC_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxcl.account_id) as " . $val . ',';
                            $SQL .= " (oxcl.clientname) as ACC_NAME,";
                        }
                        else if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxaff.account_id) as " . $val . ',';
                            $SQL .= " (oxaff.name) as ACC_NAME,";
                        }
                        break;
                    case 'CAM_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxc.campaignid) as " . $val . ',';
                            $SQL .= " (oxc.campaignname) as CAM_NAME,";
                        }
                        break;
                    case 'BAN_ID';
                        if ($search['account_type'] !== 'TRAFFICKER')
                        {
                            $SQL .= " (oxb.bannerid) as " . $val . ',';
                            $SQL .= " (oxb.description) as BAN_NAME,";
                        }
                        break;
                    case 'SITE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxps.site_id) as " . $val . ',';
                            $SQL .= " (oxps.site_name) as SITE_NAME,";
                            $SQL .= " (oxps.site_url) as SITE_URL,";
                        }
                        break;
                    case 'ZONE_ID';
                        if ($search['account_type'] !== 'ADVERTISER')
                        {
                            $SQL .= " (oxz.zoneid) as " . $val . ',';
                            $SQL .= " (oxz.zonename) as ZONE_NAME,";
                        }
                        break;
                    case 'ENV';
                        $SQL .= " (dgs.delivery_media_type) as " . $val . ",";
                        break;
                    case 'CUSTOMTARG4';
                        $SQL .= " (dgs.customtarg4) as " . $val . ",";
                        break;
                   
                }
            }
            //REMOVE comma at End of the string
            $SQL = rtrim($SQL, ",");
            $SQL .= " FROM djax_customtarg4_stats as dgs";
            if (is_array($search) AND count($search) > 0 AND array_key_exists('account_id', $search) AND $search['account_id'] != '')
            {
                if ($search['account_type'] === "ADVERTISER")
                {
                    //// GET STATISTICS VALUES FOR AN ADVERTISER
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
                    $SQL .= " AND dgs.customtarg4='" . $search['site'] . "'";
                    }
                     $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "TRAFFICKER")
                {
                    //// GET STATISTICS VALUES FOR AN TRAFFICKER
                    $SQL .= " JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    $SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    $SQL .= " JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id AND oxaff.account_id=" . $search['account_id'] . ")";
                }
                else if ($search['account_type'] === "ADMIN" || $search['account_type'] === "MANAGER")
                {
                    // LINK ADVERTISER RELATED TABLES
                    $SQL .= " JOIN ox_banners as oxb ON oxb.bannerid=dgs.ad_id";
                    if (isset($search['campaign_id']) AND $search['campaign_id'] != '')
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON (oxc.campaignid=oxb.campaignid AND oxb.campaignid='" . $search['campaign_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_campaigns as oxc ON oxc.campaignid=oxb.campaignid";
                    }
                    if (isset($search['adv_account_id']) AND $search['adv_account_id'] != '')
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.account_id=" . $search['adv_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid AND oxcl.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " JOIN ox_clients as oxcl ON (oxc.clientid=oxcl.clientid)";
                    }
                    //$SQL .= " JOIN djax_conf_targ_country as dtc ON (dtc.value=dgs.country_code)";
                    // LINK TRAFFICKER RELATED TABLES
                    $SQL .= " LEFT JOIN ox_zones as oxz ON oxz.zoneid=dgs.zone_id";
                    $SQL .= " LEFT JOIN djax_site_zone_assoc as dsza ON dsza.zone_id=oxz.zoneid";
                    if (isset($search['site_id']) AND $search['site_id'] != '')
                    {
                        $SQL .= " JOIN djax_publisher_sites as oxps ON (oxps.site_id=dsza.site_id AND oxps.site_id='" . $search['site_id'] . "')";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN djax_publisher_sites as oxps ON oxps.site_id=dsza.site_id";
                    }
                    if (isset($search['pub_account_id']) AND $search['pub_account_id'] != '')
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id  AND oxaff.account_id=" . $search['pub_account_id'] . ")";
                    }
                    else if (isset($search['agency_id']) AND $search['agency_id'] !== '' AND $search['agency_id'] > 0)
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON (oxaff.account_id=oxps.account_id AND oxaff.agencyid=" . $search['agency_id'] . ")";
                    }
                    else
                    {
                        $SQL .= " LEFT JOIN ox_affiliates as oxaff ON ( oxaff.account_id=oxps.account_id)";
                    }
                    
                }
            }
            $SQL .= "  WHERE 1";
            if (is_array($search) AND count($search) > 0)
            {
                if (isset($search['date_from']) AND $search['date_from'] != '' AND isset($search['date_to']) AND $search['date_to'] != '')
                {
                    $SQL .= " AND (DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "'))  >= '" . $search['date_from'] . "' AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) <= '" . $search['date_to'] . "')";
                }
                else if (isset($search['date_from']) AND $search['date_from'] != '')
                {
                    $SQL .= " AND DATE(CONVERT_TZ(date_time,'+00:00','" . $this->config->item('time_zone_offset') . "')) = '" . $search['date_from'] . "'";
                }
                if (isset($search['environment']) AND $search['environment'] != '')
                {
                    $SQL .= " AND delivery_media_type='" . $search['environment'] . "'";
                }
                 if (isset($search['site']) AND $search['site'] != ''AND $search['site'] != 'all')
                    {
                    $SQL .= " AND dgs.customtarg4='" . $search['site'] . "'";
                    }
            }
            if (is_array($group) AND count($group) > 0)
            {
                $SQL .= " GROUP BY ";
                foreach ($group as $val)
                {
                    switch ($val)
                    {
                        case 'DATE';
                        case 'TIME';
                        case 'MONTH';
                            $SQL .= " {$date_field} ,";
                            break;
                        case 'ACC_ID';
                            if ($search['account_type'] !== "TRAFFICKER")
                            {
                                $SQL .= "oxcl.account_id,";
                            }
                            else if ($search['account_type'] !== "ADVERTISER")
                            {
                                $SQL .= "oxaff.account_id,";
                            }
                            break;
                        case 'CAM_ID';
                            $SQL .= "oxc.campaignid,";
                            break;
                        case 'BAN_ID';
                            $SQL .= "oxb.bannerid,";
                            break;
                        case 'SITE_ID';
                            $SQL .= "oxps.site_id,";
                            break;
                        case 'ZONE_ID';
                            $SQL .= "oxz.zoneid,";
                            break;
                        case 'ENV';
                            $SQL .= "delivery_media_type,";
                            break;
                        case 'CUSTOMTARG4';
                            $SQL .= " dgs.customtarg4,";
                            break;
                       
                    }
                }
            }
            $SQL = rtrim($SQL, ",");
            if (is_array($order) AND count($order) > 0)
            {
                $SQL .= " ORDER BY ";
                foreach ($order as $key => $option)
                {
                    $SQL .= " {$key} {$option},";
                }
                //REMOVE comma at End of the string
                $SQL = rtrim($SQL, ",");
            }
            if (is_array($limit) AND array_key_exists('start', $limit) AND $limit['start'] != 0 AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['start'] . "," . $limit['end'] . "";
            }
            else if (is_array($limit) AND array_key_exists('end', $limit) AND $limit['end'] != '')
            {
                $SQL .= " LIMIT " . $limit['end'] . "";
            }
        }	
		      
        $query = $this->db->query($SQL);
       //~ return $this->db->last_query(); 
        if ($dataTable)
        {
            $data = $query->result_array();
            if ($data)
            {
                $data = array_map('callbackformat', $data);
                return $data;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            $fields         = $query->list_fields();
            $data           = $query->result_array();
            $res['fields']  = $fields;
            $res['records'] = $data;
            if ($data)
            {
                return $res;
            }
            else
            {
                return FALSE;  
            }
        }
    }       




   
}
