<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Do_payments extends CI_Model 
{
    
    /*  djax_payment_transaction
    
    * ---------------------
    
    *  id
    
    account_id
    
    name
    
    email
    
    payment_type
    
    date
    
    amount
    
    currency
    
    account_no
    
    payment_no
    
    clearing_date
    
    status
    
    id_no
    
    transaction
    
    payment_response_id
    
    admin_approval_status
    
    approved_date
    
    * */
    
    
    
    /*
    
    * Adds the Advertiser fund and waiting for admin approval
    
    * 
    
    * name: add_fund
    
    * @param : $fund_details
    
    * @return :Insert id OR FALSE
    
    * 
    
    */
    
    
    
    function add_fund($fund_details, $account_id)
     {
        
         
        
        $this->db->trans_begin();
        
        
        
        //Fetch the advertiser information
        
        $adv_details = $this->Do_advertiser->get_user_information($account_id);
        
       // return $adv_details; exit;
        
        $adv_final_details = $adv_details[0];
        
        
        
        if ($fund_details['payment_type'] == 'wire') {
            
            $pay_type = 1;
            
            $billing_detail = array(
                
                'name' => $adv_final_details['clientname'],
                
                'email' => $adv_final_details['email'],
                
                'payment_type' => $pay_type,
                
                'bank_name' => $fund_details['bank_name'],
                
                'bank_address' => $fund_details['bank_address'],
                
                'bank_account_no' => $fund_details['bank_acc_no'],
                
                //'paypal_id'			=> $fund_details['paypal_id'],
                
                'created_date' => date('Y-m-d H:i:s')
                
            );
            
           // return $billing_detail; exit;
            
            
            $this->db->insert(TAB_BILL_INFO, $billing_detail);
            log_message('error',$this->db->last_query());
            $billing_ins_id = $this->db->insert_id();
            
        }
        
        else 
        {
           
            $pay_type = 2;
            
            $admin_paypal = $this->get_admin_payment_info();
            
            $billing_detail = array(
                
                'name' => $adv_final_details['clientname'],
                
                'email' => $adv_final_details['email'],
                
                'payment_type' => $pay_type,
                
                'paypal_id' => $fund_details['paypal_id'],
                
                'created_date' => date('Y-m-d H:i:s')
                
            );
            
            
            
            $this->db->insert(TAB_BILL_INFO, $billing_detail);
            
            $billing_ins_id = $this->db->insert_id();
            
        }
        
        
        
        //Adds the advertiser fund into db
        
        $addfundObj = array(
            "account_id" => $account_id,
            
            "name" => $adv_final_details['clientname'],
            
            "email" => $adv_final_details['email'],
            
            "payment_type" => $fund_details['payment_type'],
            
            "amount" => $fund_details['amount'],
            
            "currency" => $this->config->item('currency'),
            
            "transaction" => 'credit',
            
            "admin_approval_status" => 0,
            
            "date" => date('Y-m-d H:i:s'),
            
            "ref_billing_id" => $billing_ins_id
            
        );
        //return $addfundObj; exit;
        $this->db->insert(TAB_PAY_TRANS, $addfundObj);
        
        $last_insert_id = $this->db->insert_id();
        
        if ($last_insert_id) 
        {
            
            if ($this->db->trans_status() === FALSE) 
            {
                
                $this->db->trans_rollback();
                
                return FALSE;
                
            }
            
            else {
                
                $this->db->trans_commit();
                
                return $last_insert_id;
                
            }
            
        }
        
        else {
            
            return FALSE;
            
        }
        
    }
    
    public function get_admin_payment_info($agency_id) 
    {
        
      /*  $this->db->select('paypal_id');
        $this->db->where('payment_type', 2);
        $query  = $this->db->get(TAB_ADMIN_PAYD);
        $result = $query->result_array();
        */
        
        $this->db->select('ti.paypal_id');
        $this->db->where('ti.payment_type', 2);
        $this->db->where('tnm.agency_id', $agency_id);
        $this->db->from(TAB_ADMIN_PAYD . ' as ti ');
        $this->db->join(TAB_NWK_MANAGERS . ' as tnm ', 'tnm.manager_account_id=ti.account_id');
        $query  = $this->db->get();
        $result = $query->result_array();
        
        if ($result) {
            return $result[0]['paypal_id'];
        } else {
            return FALSE;
        }
    }
  
    /*
    
    * Make Payment for publisher based on invoices
    
    * 
    
    * name: make_payment
    
    * @param : $fund_details
    
    * @return :Insert id OR FALSE
    
    * 
    
    */
    
    
    
    function make_payment($details) 
    {
        
        
        
        $invoice_id = $details['invoice_id'];
        
        
        
        //Get the Invoice Details based on invoice_id
        $invoice_details = $this->fetch_invoice_account_id($invoice_id);
		if($invoice_details['is_super_admin'] != 1)
		{
        $invoice_details = $this->fetch_invoice_account_details($invoice_id);
        
        
        
        $invoice_details = $invoice_details[0];
		 //Get the Account details 
       
		 $account_details = $this->fetch_publisher_account_details($invoice_details['account_id']);
		}
		else
		{
			 $account_details = $this->fetch_admin_account_details(2);
		}
       
        
        
        //Transaction Begin
        
        $this->db->trans_begin();
        
        
        
        //Inserts array for payment response
        
        $ins_pay_response = array(
            'account_id' => $invoice_details['account_id'],
            
            'payment_type' => $account_details['payment_type'],
            
            'payment_request_id' => $invoice_details['id'],
            
            'payer_email' => get_session('email'),
            
            'receiver_email' => $invoice_details['email'],
            
            'payment_gross' => $invoice_details['amount'],
            
            'payment_status' => '1,3',
            
            'payment_date' => $invoice_details['in_date'],
            
            'payment_paid_date' => date('Y-m-d H:i:s')
            
        );
        
        
        
        $this->db->insert(TAB_PAY_RES, $ins_pay_response);
        
        
        
        $payment_response_id = $this->db->insert_id();
        
        
        
        if ($payment_response_id) 
        {
            
            // Billing information name to be considered
            
            $ins_pay_trans = array(
                'account_id' => $account_details['account_id'],
                
                'name' => $invoice_details['name'],
                
                'email' => $invoice_details['email'],
                
                'payment_type' => $account_details['payment_type'],
                
                'date' => date('Y-m-d H:i:s'),
                
                'amount' => $invoice_details['amount'],
                
                'currency' => $this->config->item('currency'),
                
                'account_no' => $account_details['bank_account_no'],
                
                'clearing_date' => date('Y-m-d H:i:s'),
                
                'status' => 1,
                
                'transaction' => 'debit',
                
                'payment_response_id' => $payment_response_id,
                
                'admin_approval_status' => 1
                
            );
            
            
            
            $this->db->insert(TAB_PAY_TRANS, $ins_pay_trans);
            
            
            
            $payment_transaction_id = $this->db->insert_id();
            
        } else {
            
            $payment_transaction_id = '';
            
        }
        
        
        
        if ($payment_transaction_id) 
        {
            
            //Insert one mapping table for further reference
            
            $ins_pay_invoice_payment = array(
                'payment_id' => $payment_transaction_id,
                
                'invoice_id' => $invoice_details['id']
                
            );
            
            
            
            $this->db->insert(TAB_INVOICE_PAY, $ins_pay_invoice_payment);
            
        }
        
        
        
        //Update the Billing Information
        
        
        
        $billing_address = $invoice_details['address'] . ',' . $invoice_details['city'] . ',' . $invoice_details['state'] . ',' . $invoice_details['country'];
        
        
        
        $ins_bill_info = array(
            'name' => $invoice_details['name'],
            
            'email' => $invoice_details['email'],
            
            'company_name' => $invoice_details['company_name'],
            
            'billing_address' => $billing_address,
            
            'payment_type' => $account_details['payment_type'],
            
            'bank_name' => $account_details['bank_name'],
            
            'bank_address' => $account_details['bank_address'],
            
            'swift_bic' => $account_details['swift_bic'],
            
            'iban' => $account_details['iban'],
            
            'routing_number' => $account_details['routing_number'],
            
            'bank_account_no' => $account_details['bank_account_no'],
            
            'account_holder_name' => $account_details['account_holder_name'],
            
            'paypal_id' => $account_details['paypal_id'],
            
            'created_Date' => date('Y-m-d H:i:s')
            
        );
        
        
        
        $this->db->insert(TAB_BILL_INFO, $ins_bill_info);
        
        
        
        $billing_id = $this->db->insert_id();
        
        
        
        //Updates the Invoice is paid
        
        $this->db->update(TAB_INVOICE, array(
            'invoice_status' => 1,
            'billing_id' => $billing_id
        ), array(
            'invoice_id' => $invoice_details['id']
        ));
        
        
        
        
        
        if ($this->db->trans_status() === FALSE) 
        {
            
            $this->db->trans_rollback();
            
            return FALSE;
            
        }
        
        else {
            
            $this->db->trans_commit();
            
            $invoice_details = array(
                'invoice' => $invoice_details
            );
            
            $account_details = array(
                'account' => $account_details
            );
            
            
            
            $final_details = array_merge($invoice_details, $account_details);
            
            
            
            return $final_details;
            
        }
        
    }
    
    
    
    function fetch($where = FALSE) 
    {
        
        
        
        if ($where != FALSE) 
        {
            
            $this->db->where($where);
            
        }
        
        
        
        $this->db->select('site_id,account_id,site_name,site_url');
        
        $this->db->where('is_deleted', '0');
        
        
        
        $this->db->order_by('added_date');
        
        
        
        
        
        $query = $this->db->get(TAB_PUB_SITES);
        
        
        
        $result = $query->result_array();
        
        
        
        if ($result) 
        {
            
            return $result;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
        
        
        
        
    }
    
    
    
    /*
    
    * 
    
    * name: fetch_payment_list
    
    * @param : none
    
    * @return :$result
    
    * 
    
    * Fetch list of payments need to be approve
    
    */
    
    
    
    public function fetch_payment_list($agencyid,$exchangeval) 
    {
		if($exchangeval){
			$exchangeRate = $exchangeval;
		}else{
			$exchangeRate = $this->config->item('exchangeRate');
		}	        
        $this->db->select('*');
        
        $this->db->where('tpt.transaction', "credit");
        
        $this->db->where_not_in('tpt.account_id', 0);
        
        $this->db->where('tpt.admin_approval_status', 0);
        
        $this->db->where('tc.agencyid', $agencyid);
        
        $this->db->join(TAB_CLIENTS . ' as tc', 'tpt.account_id=tc.account_id');
        
        $this->db->order_by('tpt.date');
        
        $query = $this->db->get(TAB_PAY_TRANS . ' as tpt');
        
        $result = $query->result_array();
        
        if ($result) 
        {
            //currency conversion for 4 digits
            foreach ($result as $idx => $value) 
            {
                $result[$idx]['amount'] = currencyformat($exchangeRate * $value['amount']);
                $result[$idx]['date']   = dateformat(strtotime($value['date'])); //date format cinversion
                
            }
            
            return $result;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
    
    
    
    /*
    
    * 
    
    * name: fetch_unapproved_advertiser_payment
    
    * @param : none
    
    * @return :$result
    
    * 
    
    * Fetch list of payments need to be approve
    
    */
    
    
    
    public function fetch_unapproved_advertiser_payment($agency_id, $adv_account_id = FALSE) 
    {
        
        
        
        $SQL = "

				SELECT oxp.`date` as last_create_date, (

						SELECT count(*) FROM 

							" . TAB_PAY_TRANS . " as oxp

							JOIN " . TAB_CLIENTS . " as oxcl  ON oxcl.account_id=oxp.account_id

						WHERE

						oxcl.agencyid={$agency_id} ";
        
        
        
        if ($adv_account_id != FALSE) 
        {
            
            $SQL .= "  AND oxcl.account_id = {$adv_account_id}";
            
        }
        
        
        
        
        
        $SQL .= "  AND oxp.`admin_approval_status`=0 AND 

					   oxp.`transaction` = 'credit'

					) as deposit_count 

				FROM 

					" . TAB_PAY_TRANS . " as oxp

					JOIN " . TAB_CLIENTS . " as oxcl ON oxcl.account_id=oxp.account_id

				WHERE

					oxcl.agencyid={$agency_id}	";
        
        
        
        if ($adv_account_id != FALSE) 
        {
            
            $SQL .= "  AND oxcl.account_id = {$adv_account_id}";
            
        }
        
        
        
        $SQL .= "	AND oxp.`admin_approval_status`=0 AND 

					   oxp.`transaction` = 'credit'";
        
        
        
        $SQL .= " ORDER BY 

					oxp.`date` DESC LIMIT 0,1";
        
        
        
        $query = $this->db->query($SQL);
        
        
        
        $result = $query->result_array();
        
        
        
        if ($result) 
        {
            
            
            
            return $result[0];
            
            
            
        }
        
        
        
        else 
        {
            
            
            
            return FALSE;
            
            
            
        }
        
    }
    
    
    
    
    
    /*
    
    * 
    
    * name: fetch_approved_advertiser_payment
    
    * @param : none
    
    * @return :$result
    
    * 
    
    * Fetch list of payments need to be approve
    
    */
    
    
    
    public function fetch_approved_advertiser_payment($agency_id, $adv_account_id = FALSE) 
    {
        
        
        
        $SQL = "

				SELECT oxp.`date` as last_create_date, (

						SELECT count(*) FROM 

							" . TAB_PAY_TRANS . " as oxp

							JOIN " . TAB_CLIENTS . " as oxcl  ON oxcl.account_id=oxp.account_id

						WHERE

						oxcl.agencyid={$agency_id} ";
        
        
        
        if ($adv_account_id != FALSE) 
        {
            
            $SQL .= "  AND oxcl.account_id = {$adv_account_id}";
            
        }
        
        
        
        
        
        $SQL .= "  AND oxp.`admin_approval_status`=1 AND 

					   oxp.`transaction` = 'credit'

					) as deposit_count 

				FROM 

					" . TAB_PAY_TRANS . " as oxp

					JOIN " . TAB_CLIENTS . " as oxcl ON oxcl.account_id=oxp.account_id

				WHERE

					oxcl.agencyid={$agency_id}	";
        
        
        
        if ($adv_account_id != FALSE) 
        {
            
            $SQL .= "  AND oxcl.account_id = {$adv_account_id}";
            
        }
        
        
        
        $SQL .= "	AND oxp.`admin_approval_status`=1 AND 

					   oxp.`transaction` = 'credit'";
        
        
        
        $SQL .= " ORDER BY 

					oxp.`date` DESC LIMIT 0,1";
        
        
        
        $query = $this->db->query($SQL);
        
        
        
        $result = $query->result_array();
        
        
        
        if ($result) 
        {
            
            
            
            return $result[0];
            
            
            
        }
        
        
        
        else {
            
            
            
            return FALSE;
            
            
            
        }
        
    }
    
    
    
    /*
    
    * 
    
    * name: fetch_unapproved_advertiser_payment
    
    * @param : none
    
    * @return :$result
    
    * 
    
    * Fetch list of payments need to be approve
    
    */
    
    
    
    public function fetch_unapproved_publisher_payment($agency_id, $pub_account_id = FALSE) 
    {
        
        
        
        $SQL = "

				SELECT oxi.`invoice_date` as last_create_date, (

						SELECT count(*) FROM 

							" . TAB_INVOICE . " as oxi

							JOIN " . TAB_AFFILIATE . " as oxaff  ON oxaff.account_id=oxi.account_id

							JOIN " . TAB_PUB_PAYD . " as pp  ON oxaff.account_id=pp.account_id

						WHERE

						oxaff.agencyid={$agency_id} AND pp.is_default=1 ";
        
        
        
        if ($pub_account_id != FALSE) 
        {
            
            $SQL .= "  AND oxaff.account_id = {$pub_account_id}";
            
        }
        
        
        
        
        
        $SQL .= "  AND oxi.`invoice_status`=0 

					) as invoice_count 

				FROM 

					" . TAB_INVOICE . " as oxi

					JOIN " . TAB_AFFILIATE . " as oxaff ON oxaff.account_id=oxi.account_id

					JOIN " . TAB_PUB_PAYD . " as pp  ON oxaff.account_id=pp.account_id

				WHERE

					oxaff.agencyid={$agency_id}	AND pp.is_default=1 ";
        
        
        
        if ($pub_account_id != FALSE)
         {
            
            $SQL .= "  AND oxaff.account_id = {$pub_account_id}";
            
        }
        
        
        
        $SQL .= "	AND oxi.`invoice_status`=0 ";
        
        
        
        $SQL .= " ORDER BY 

					oxi.`invoice_date` DESC LIMIT 0,1";
        
        
        
        $query = $this->db->query($SQL);
        
        
        
        $result = $query->result_array();
        
        
        
        if ($result) {
            
            
            
            return $result[0];
            
            
            
        }
        
        
        
        else {
            
            
            
            return FALSE;
            
            
            
        }
        
    }
    
    
    
    
    
    /*
    
    * 
    
    * name: fetch_approved_publisher_payment
    
    * @param : none
    
    * @return :$result
    
    * 
    
    * Fetch list of payments need to be approve
    
    */
    
    
    
    public function fetch_approved_publisher_payment($agency_id, $pub_account_id = FALSE, $date = FALSE) 
    {
        
        
        
        
        
        $SQL = "

				SELECT oxi.`invoice_date` as last_create_date, (

						SELECT count(*) FROM 

							" . TAB_INVOICE . " as oxi

							JOIN " . TAB_AFFILIATE . " as oxaff  ON oxaff.account_id=oxi.account_id

						WHERE

						oxaff.agencyid={$agency_id}  ";
        
        
        
        if ($pub_account_id != FALSE) 
        {
            
            $SQL .= "  AND oxaff.account_id = {$pub_account_id}";
            
        }
        
        
        
        if ($date != FALSE) 
        {
            
            $SQL .= "  AND DATE(oxi.invoice_paid_date) = '" . $date . "'";
            
        }
        
        
        
        
        
        $SQL .= "  AND oxi.`invoice_status`=1 

					) as invoice_count 

				FROM 

					" . TAB_INVOICE . " as oxi

					JOIN " . TAB_AFFILIATE . " as oxaff ON oxaff.account_id=oxi.account_id

				WHERE

					oxaff.agencyid={$agency_id}	";
        
        
        
        if ($pub_account_id != FALSE) 
        {
            
            $SQL .= "  AND oxaff.account_id = {$pub_account_id}";
            
        }
        
        
        
        if ($date != FALSE) {
            
            $SQL .= "  AND DATE(oxi.invoice_paid_date) = '" . $date . "'";
            
        }
        
        
        
        
        
        $SQL .= "	AND oxi.`invoice_status`=1 ";
        
        
        
        $SQL .= " ORDER BY 

					oxi.`invoice_date` DESC LIMIT 0,1";
        
        
        
        $query = $this->db->query($SQL);
        
        
        
        $result = $query->result_array();
        
        
        
        if ($result)
         {
            
            
            
            return $result[0];
            
            
            
        }
        
        
        
        else
        {
            
            
            
            return FALSE;
            
            
            
        }
        
    }
    
    
    
    /*
    
    * 
    
    * name: payment_approve
    
    * @param : payment id,amount,account_id
    
    * @return :Payment id OR FLASE
    
    * 
    
    */
    
    public function payment_approve($id = FALSE, $amount = FALSE, $account_id = FALSE) 
    {
        
        $data = array(
            
            'admin_approval_status' => 1,
            
            'approved_date' => date('Y-m-d H:m:s'),
            
            'clearing_date' => date('Y-m-d H:m:s')
            
        );
        
        if (!empty($data)) 
        {
            
            $this->db->where('id', $id);
            
            $this->db->update(TAB_PAY_TRANS, $data);
            
            //add approve amount into ox_clients
            
            //widget  update amount value from transaction table
            
            $this->db->select('t.amount');
            $this->db->where('id', $id);
            $this->db->join(TAB_PAY_TRANS . ' as t ', 't.account_id=c.account_id');
            $sql = $this->db->get(TAB_CLIENTS . ' as c');
            $res = $sql->result_array();
            //widget  update amount value from transaction table
            $this->db->select('dj_cur_balance');
            
            $this->db->where('account_id', $account_id);
            
            $query = $this->db->get(TAB_CLIENTS);
            
            $result = $query->result_array();
            
            $amt = str_replace("$", "", $amount);
            
            $tot_amount = $result[0]['dj_cur_balance'] + $res[0]['amount'];
            
            $add = array(
                'dj_cur_balance' => $tot_amount
            );
            
            $this->db->where('account_id', $account_id);
            
            $this->db->update(TAB_CLIENTS, $add);
            
            return $id;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * 
    
    * name: payment_reject
    
    * @param : payment id
    
    * @return :Payment id OR FLASE
    
    * 
    
    */
    
    public function payment_reject($id = FALSE) 
    {
        
        $data = array(
            
            'admin_approval_status' => -1,
            
            'approved_date' => date('Y-m-d H:m:s'),
            
            'clearing_date' => date('Y-m-d H:m:s')
            
        );
        
        if (!empty($data)) {
            
            //update reject status and return account_id
            
            $this->db->select('account_id');
            
            $this->db->where('id', $id);
            
            $this->db->update(TAB_PAY_TRANS, $data);
            
            $this->db->where('id', $id);
            
            $query = $this->db->get(TAB_PAY_TRANS);
            
            $result = $query->result_array();
            
            if ($result) {
                
                $acc_id = $result[0]['account_id'];
                
                return $acc_id;
                
            }
            
        }
        
        else {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * 
    
    * name: payment_viewmore
    
    * @param : payment id
    
    * @return :Payment detailed list of payment
    
    * 
    
    */
    
    public function payment_viewmore($id = FALSE,$exchangeval) {
		
		if($exchangeval){
			$exchangeRate = $exchangeval;
		}else{
			$exchangeRate = $this->config->item('exchangeRate');
		}	
        
        $this->db->select(' `id`, `account_id`, `name`, `email`, `payment_type`, `date`, `currency`, `account_no`, `payment_no`, `clearing_date`, `status`, `id_no`, `transaction`, `payment_response_id`, `admin_approval_status`, `approved_date`, `ref_billing_id` ,('.$exchangeRate.' * amount) as amount');
        $this->db->where('id', $id);
        
        $query = $this->db->get(TAB_PAY_TRANS);
        
        $result = $query->result_array();
        
        if ($result) {
			$result=array_map('callbackformat',$result);//callback from helper
      
       
            foreach ($result as $idx => $value) {
                $result[$idx]['date'] = dateformat(strtotime($value['date']));
               
                
            }

       
            return $result;
            
        }
        
        else {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * 
    
    * name: fetch_pub_payment_list
    
    * @param : none
    
    * @return :detailed list of publisher payment
    
    * 
    
    */
    
    public function fetch_pub_payment_list($invoice_id = FALSE, $agencyid = FALSE, $exchangeval = FALSE) {
        
		if($exchangeval){
			$exchangeRate = $exchangeval;
		}else{
			$exchangeRate = $this->config->item('exchangeRate');
		}       
		 
        $this->db->select('ti.invoice_id,ti.account_id as account_id,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,ti.invoice_period_days as days,ti.invoice_status,('.$exchangeRate.' * ti.invoice_net_amount) as amount,tu.contact_name as name,tu.email_address as email,tpp.*');
        
        $this->db->where('ti.invoice_status', 0);
        
        $this->db->join(TAB_USERS . ' as tu ', 'tu.default_account_id=ti.account_id');
        
        $this->db->join(TAB_PUB_PAYD . ' as tpp ', 'tpp.account_id=ti.account_id');
        
        $this->db->where('tpp.is_default', 1);
        
        if ($agencyid != FALSE) {
            
            $this->db->where('tf.agencyid', $agencyid);
            
            $this->db->join(TAB_AFFILIATE . ' as tf', 'tpp.account_id=tf.account_id');
            
        }
        
        if ($invoice_id) {
            
            $query = $this->db->get_where(TAB_INVOICE . ' as ti ', array(
                'invoice_id' => $invoice_id
            ));
            
        } else {
            
            $query = $this->db->get(TAB_INVOICE . ' as ti ');
            
        }
        
        $result = $query->result_array();
        
        
        
        if ($result) 
        {
            //currency  and dateconversion
            foreach ($result as $idx => $value) 
            {
                $result[$idx]['amount']     = currencyformat($value['amount']);
                $result[$idx]['in_date']    = dateformat(strtotime($value['in_date']));
                $result[$idx]['start_date'] = dateformat(strtotime($value['start_date']));
                $result[$idx]['end_date']   = dateformat(strtotime($value['end_date']));
                
          
            }
            
            return $result;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * name: publisher_invoice_viewmore
    
    * @param : $invoice_id
    
    * @return :detailed list of publisher payment 
    
    */
    
    public function fetch_individual_invoice($invoice_id = FALSE,$payment_type = FALSE,$exchangeval) {
		
		if($exchangeval){
			$exchangeRate = $exchangeval;
		}else{
			$exchangeRate = $this->config->item('exchangeRate');
		} 		
		//$this->db->distinct(); // added by karthika on dec-17
		        
        $this->db->select('ti.invoice_id as id,aff.agencyid,tpp.paypal_id,tii.currency,ti.account_id,('.$exchangeRate.' * ti.invoice_net_amount) as total_earn,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,ti.invoice_period_days as days,ti.invoice_status,tu.contact_name as name,tu.email_address as email,tii.item_code,tii.item_desc,tii.amount,tii.currency,ta.name as na_name,ta.email as na_email');
        
        $this->db->where('ti.invoice_id', $invoice_id);
        
        $this->db->from(TAB_INVOICE . ' as ti ');
        
        $this->db->join(TAB_INVOICE_ITEM . ' as tii ', 'tii.invoice_id=ti.invoice_id');
        
        $this->db->join(TAB_USERS . ' as tu ', 'tu.default_account_id=ti.account_id');
       
        $this->db->join(TAB_AFFILIATE . ' as aff ', 'aff.account_id=ti.account_id');
        $this->db->join(TAB_AGENCY.' as ta ','ta.agencyid=aff.agencyid');
        $this->db->group_by('ti.invoice_id', $invoice_id); // added by karthika on dec -19        
        
        if($payment_type){        
			$this->db->join(TAB_PUB_PAYD . ' as tpp ', 'tpp.account_id=ti.account_id AND payment_type = "'.$payment_type.'"');
		}else{
			$this->db->join(TAB_PUB_PAYD . ' as tpp ', 'tpp.account_id=ti.account_id');
		}
        $query = $this->db->get();
        
        $result = $query->result_array();
       
        //return $this->db->last_query();
        
       
        if ($result) {
            
            return $result;
            
        }
        
        else {
            
            return FALSE;
            
        }
        
    }
    
   
     /*
    
    * name: fetch_admin_detail
    
    * @param : $agency_id
    
    * @return :detailed of admin
    
    * @ added by karthika on dec -27
    
    */
    
    public function fetch_admin_detail($agency_id = FALSE) {
		
        $this->db->select('ti.account_id as id,ti.email as admin_email,tu.contact_name as admin_name');
        
        $this->db->where('ti.agencyid', $agency_id);
       
        $this->db->from(TAB_AGENCY . ' as ti ');
        
        $this->db->join(TAB_USERS . ' as tu ', 'tu.default_account_id=ti.account_id');
         
        $this->db->group_by('ti.agencyid', $agency_id); // added by karthika on dec -19
		
		//return $this->db->last_query();
		
        $query = $this->db->get();
        $result = $query->result_array();
        if ($result) {
            return $result;
        }
        else {
            return FALSE;
        }
    } 
    
    
    /*
    
    * name: publisher_invoice_viewmore
    
    * @param : $invoice_id
    
    * @return :detailed list of publisher payment 
    
    */
    
    public function fetch_publisher_account_details($account_id = FALSE) {
        
        if ($account_id) {
            
            $this->db->where('is_default', 1);
            
            $query = $this->db->get_where(TAB_PUB_PAYD, array(
                'account_id' => $account_id
            ));
            
            
            
            if ($query->num_rows > 0) {
                
                $result = $query->result_array();
                
                return $result[0];
                
            } else {
                
                return FALSE;
                
            }
            
            
            
        } else {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * name: fetch_publisher_invoice_list
    
    * @param : none
    
    * @return :detailed list of publisher payment 
    
    */
    
    public function fetch_publisher_invoice_list($account_id = FALSE,$network_id=FALSE,$exchangeval) {
        
		if($exchangeval){
		$exchangeRate	=	$exchangeval;
		}else{
		$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		}
		        
        $this->db->select('tu.contact_name as name,MONTHNAME(ti.invoice_date)as month,YEAR(ti.invoice_date)as year,date(ti.invoice_date)as in_date,ti.invoice_status,ti.invoice_id,ti.invoice_code,('.$exchangeRate.' * ti.invoice_net_amount) as netamount');
        
        if ($account_id) {
            
            $this->db->where('ti.account_id', $account_id);
            
            
        }
        if($network_id)
	    {
		$this->db->where('dnm.manager_account_id',$network_id);
	    }
        $this->db->where('ti.invoice_status !=', 4);
        $this->db->where('ti.invoice_type =','int_pub');
       
        $this->db->from(TAB_INVOICE . ' as ti ');
        
        $this->db->join(TAB_USERS . ' as tu ', 'tu.default_account_id=ti.account_id');
        $this->db->join(TAB_AFFILIATE.' as oxaf ','tu.default_account_id=oxaf.account_id');
	    $this->db->join(TAB_NWK_MANAGERS.' as dnm ','dnm.agency_id=oxaf.agencyid');
        
        $query = $this->db->get();
        
        $result = $query->result_array();
        
        if ($result) 
        {
            //currency conversion
            foreach ($result as $idx => $value) 
            {
                
                $result[$idx]['netamount'] = currencyformat($value['netamount']);
                $result[$idx]['month']     = dateformat(strtotime($value['month'])); //date conversion
                $result[$idx]['in_date']    = dateformat(strtotime($value['in_date']));                
                
                
            }
            
            return $result;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /**
    
    * Retreives the categories associated with this site
    
    * 
    
    * @param numeric $site_id Site id
    
    * 
    
    * @return boolean Returns TRUE (or) FALSE
    
    */
    
    
    
    public function fetch_publisher_invoice_item($invoice_id = FALSE) {
        
        if ($invoice_id) {
            
            $this->db->select('item_desc,amount,currency');
            
            $query = $this->db->get_where(TAB_INVOICE_ITEM, array(
                'invoice_id' => $invoice_id
            ));
            
            $result = $query->result_array();
            
            return $result;
            
        } else {
            
            return FALSE;
            
        }
        
        
        
    }
    
    
    
    /*
    
    * 
    
    * name: fetch_invoice_account_details
    
    * @param : none
    
    * @return :detailed list of publisher payment
    
    * 
    
    */
    
    public function fetch_invoice_account_details($invoice_id = FALSE) {
        
        $this->db->select('ti.invoice_id as id,ti.account_id as account_id,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,ti.invoice_period_days as days,ti.invoice_status,ti.invoice_net_amount as amount,tu.contact_name as name,tu.email_address as email,ta.dj_company_name as company_name,ta.dj_address as address,ta.dj_state as state,ta.dj_city as city,ta.dj_country as country');
        
        $this->db->where('ti.invoice_status', 0);
      
        $this->db->join(TAB_USERS . ' as tu ', 'tu.default_account_id=ti.account_id');
        
        $this->db->join(TAB_AFFILIATE . ' as ta', 'ta.account_id=ti.account_id');
        
        if ($invoice_id) {
            
            $query = $this->db->get_where(TAB_INVOICE . ' as ti ', array(
                'invoice_id' => $invoice_id
            ));
            
        } else {
            
            $query = $this->db->get(TAB_INVOICE . ' as ti ');
            
        }
        
        $result = $query->result_array();
        
        if ($result) {
            
            return $result;
            
        }
        
        else {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * 
    
    * name: insert_paypal_response
    
    * @param : $paypal_order
    
    * @return :TRUE or FALSE
    
    * 
    
    */
    
    function insert_paypal_order($paypal_order) {
        
        $this->db->insert(TAB_PAY_RES, $paypal_order);
        
        
        
        if ($this->db->affected_rows() > 0) {
            
            return $this->db->insert_id();
            
        }
        
        else {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * 
    
    * name: fetch_advertiser_payment
    
    * @param : $account_id
    
    * @return : Sumary details of advertiser payments
    
    * 
    
    */
    
    public function fetch_advertiser_payment($account_id = FALSE) {
        $exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
        
        $sql = "SELECT ROUND(($exchangeRate * SUM(spend)),4) as tot_spend,ROUND(($exchangeRate * SUM(paid)),4) as tot_paid,ROUND(($exchangeRate * (SUM(paid) - SUM(spend))),4) as balance, month,year,month_number,account_id

	    FROM 

	   (SELECT sum(tds.dj_total_revenue) as spend,0 as paid, MONTHNAME(tds.date_time) as month, YEAR(tds.date_time) as year, MONTH(tds.date_time) as month_number,tcl.account_id as account_id FROM `ox_data_summary_ad_hourly` as tds JOIN `ox_banners` as tb ON `tds`.`ad_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(tds.date_time) 

		UNION

		SELECT 0 as spend,sum(amount)as paid, MONTHNAME(approved_date) as month,YEAR(approved_date) as year, MONTH(approved_date) as month_number, account_id FROM `djax_payment_transaction` WHERE  `account_id` = $account_id  AND  `transaction` = 'credit'  AND `admin_approval_status` = 1 GROUP BY MONTH(approved_date)

		UNION

		SELECT sum(oba.dj_win_bid) as spend ,0 as paid,MONTHNAME(oba.date_time) as month,0 as year, 0 as month_number,tcl.account_id as account_id FROM `ox_data_bkt_a` as oba JOIN `ox_banners` as tb ON `oba`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(oba.date_time)

		UNION

		SELECT sum(obc.dj_win_bid * obc.count) as spend ,0 as paid,MONTHNAME(obc.interval_start) as month,0 as year, 0 as month_number,tcl.account_id as account_id FROM `ox_data_bkt_c` as obc JOIN `ox_banners` as tb ON `obc`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(obc.interval_start)

		UNION

		SELECT sum(obm.dj_win_bid * obm.count) as spend ,0 as paid,MONTHNAME(obm.interval_start) as month,0 as year, 0 as month_number,tcl.account_id as account_id FROM `ox_data_bkt_m` as obm JOIN `ox_banners` as tb ON `obm`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(obm.interval_start)

		) as final GROUP BY month";
        
        $result = $this->db->query($sql);
        
        $data = $result->result_array();
        
        if ($data) 
        {
			$data=array_map('callbackformat',$data);
            //currency conversion
            /**
            foreach ($data as $idx => $value) 
            {
                $data[$idx]['tot_paid']  = currencyformat($value['tot_paid']);
                $data[$idx]['tot_spend'] = currencyformat($value['tot_spend']);
                
                
                
                
            }
            * **/
            
            return $data;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
      
    public function fetch_advertiser_payment1($account_id = FALSE, $exchangeval = FALSE) {
		if($exchangeval){
			$exchangeRate	=	$exchangeval;
		}else{
			$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		}
        $sql = "SELECT ROUND(($exchangeRate * SUM(spend)),4) as tot_spend,ROUND(($exchangeRate * SUM(paid)),4) as tot_paid,ROUND(($exchangeRate * (SUM(paid) - SUM(spend))),4) as balance, month,year,month_number,account_id

	    FROM 

	   (SELECT sum(tds.dj_total_revenue) as spend,0 as paid, MONTHNAME(tds.date_time) as month, YEAR(tds.date_time) as year, MONTH(tds.date_time) as month_number,tcl.account_id as account_id FROM `ox_data_summary_ad_hourly` as tds JOIN `ox_banners` as tb ON `tds`.`ad_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(tds.date_time) 

		UNION

		SELECT 0 as spend,sum(amount)as paid, MONTHNAME(approved_date) as month,YEAR(approved_date) as year, MONTH(approved_date) as month_number, account_id FROM `djax_payment_transaction` WHERE  `account_id` = $account_id  AND  `transaction` = 'credit'  AND `admin_approval_status` = 1 GROUP BY MONTH(approved_date)

		UNION

		SELECT sum(oba.dj_win_bid) as spend ,0 as paid,MONTHNAME(oba.date_time) as month,YEAR(oba.date_time) AS YEAR,MONTH(oba.date_time) AS month_number,tcl.account_id as account_id FROM `ox_data_bkt_a` as oba JOIN `ox_banners` as tb ON `oba`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(oba.date_time)

		UNION

		SELECT sum(obc.dj_win_bid) as spend ,0 as paid,MONTHNAME(obc.interval_start) as month,YEAR(obc.interval_start) AS YEAR,MONTH(obc.interval_start)AS month_number,tcl.account_id as account_id FROM `ox_data_bkt_c` as obc JOIN `ox_banners` as tb ON `obc`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(obc.interval_start)

		UNION

		SELECT sum(obm.dj_win_bid * obm.count) as spend ,0 as paid,MONTHNAME(obm.interval_start) as month, YEAR(obm.interval_start) AS YEAR,MONTH(obm.interval_start) AS month_number,tcl.account_id as account_id FROM `ox_data_bkt_m` as obm JOIN `ox_banners` as tb ON `obm`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(obm.interval_start)

		) as final GROUP BY month";
        
        $result = $this->db->query($sql);
        //~ return $sql;
        $data = $result->result_array();
     
        if ($data) 
        {
			$data = array_map('callbackformat', $data); //getting date from helper
			
            return $data;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    public function fetch_advertiser_paymentnew($account_id = FALSE) {
        $exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
        
        $sql = "SELECT ROUND(($exchangeRate * SUM(spend)),4) as tot_spend,ROUND(($exchangeRate * SUM(paid)),4) as tot_paid,ROUND(($exchangeRate * (SUM(paid) - SUM(spend))),4) as balance, month,year,month_number,account_id

	    FROM 

	   (SELECT sum(tds.dj_total_revenue) as spend,0 as paid, MONTHNAME(tds.date_time) as month, YEAR(tds.date_time) as year, MONTH(tds.date_time) as month_number,tcl.account_id as account_id FROM `ox_data_summary_ad_hourly` as tds JOIN `ox_banners` as tb ON `tds`.`ad_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(tds.date_time) 

		UNION

		SELECT 0 as spend,sum(amount)as paid, MONTHNAME(approved_date) as month,YEAR(approved_date) as year, MONTH(approved_date) as month_number, account_id FROM `djax_payment_transaction` WHERE  `account_id` = $account_id  AND  `transaction` = 'credit'  AND `admin_approval_status` = 1 GROUP BY MONTH(approved_date)

		UNION

		SELECT sum(oba.dj_win_bid) as spend ,0 as paid,MONTHNAME(oba.date_time) as month,YEAR(oba.date_time) AS YEAR,MONTH(oba.date_time) AS month_number,tcl.account_id as account_id FROM `ox_data_bkt_a` as oba JOIN `ox_banners` as tb ON `oba`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(oba.date_time)

		UNION

		SELECT sum(obc.dj_win_bid) as spend ,0 as paid,MONTHNAME(obc.interval_start) as month,YEAR(obc.interval_start) AS YEAR,MONTH(obc.interval_start)AS month_number,tcl.account_id as account_id FROM `ox_data_bkt_c` as obc JOIN `ox_banners` as tb ON `obc`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(obc.interval_start)

		UNION

		SELECT sum(obm.dj_win_bid * obm.count) as spend ,0 as paid,MONTHNAME(obm.interval_start) as month, YEAR(obm.interval_start) AS YEAR,MONTH(obm.interval_start) AS month_number,tcl.account_id as account_id FROM `ox_data_bkt_m` as obm JOIN `ox_banners` as tb ON `obm`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY MONTH(obm.interval_start)

		) as final GROUP BY month";
        
        $result = $this->db->query($sql);
        
        $data = $result->result_array();
     
        if ($data) 
        {
			//~ $data = array_map('callbackformat', $data); //getting date from helper
			
            return $data;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
    /*
    
    * 
    
    * name: fetch_advertiser_date_wise_payment
    
    * @param : $account_id
    
    * @return : detailed info of advertiser payments date wise
    
    * 
    
    */
    
    public function fetch_advertiser_date_wise_payment($month = FALSE, $year = FALSE, $account_id = FALSE, $exchangeval = FALSE) {
        
        
		//~ $exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate
		
		if($exchangeval){
			$exchangeRate	=	$exchangeval;
		}else{
			$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		}
		
        $sql = "SELECT ROUND(($exchangeRate * sum(spend)),4) as tot_spend,ROUND(($exchangeRate * sum(paid)),4) as tot_paid,date FROM

	   (

			SELECT (sum(tds.dj_total_revenue)) as spend,0 as paid, DATE(tds.date_time) as date FROM `ox_data_summary_ad_hourly` as tds JOIN `ox_banners` as tb ON `tds`.`ad_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id  GROUP BY DATE(tds.date_time)UNION

			SELECT 0 as spend,sum(amount) as paid, DATE(approved_date) as date FROM `djax_payment_transaction` WHERE `account_id` = $account_id AND `transaction` = 'credit' AND `admin_approval_status` = 1 GROUP BY DATE(approved_date)

			UNION

SELECT sum(oba.dj_win_bid) as spend ,0 as paid,DATE(oba.date_time) as date FROM `ox_data_bkt_a` as oba JOIN `ox_banners` as tb ON `oba`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY DATE(oba.date_time)

UNION

SELECT sum(obc.dj_win_bid * obc.count) as spend ,0 as paid,DATE(obc.interval_start) as date FROM `ox_data_bkt_c` as obc JOIN `ox_banners` as tb ON `obc`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY DATE(obc.interval_start)

UNION

SELECT sum(obm.dj_win_bid * obm.count) as spend ,0 as paid,DATE(obm.interval_start) as date FROM `ox_data_bkt_m` as obm JOIN `ox_banners` as tb ON `obm`.`creative_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE `tcl`.`account_id` = $account_id GROUP BY DATE(obm.interval_start)

			)as final WHERE MONTH(date)=$month AND YEAR(date)=$year GROUP BY date";
        
        $result = $this->db->query($sql);
        
        $data = $result->result_array();
        
        if ($data)
         {
             $data = array_map('callbackformat', $data); //getting date from helper
           /*
            foreach ($data as $idx => $value) 
            {
                
               
                
                $data[$idx]['tot_paid']  = currencyformat($value['tot_paid']);
                $data[$idx]['tot_spend'] = currencyformat($value['tot_spend']);
                
                
                
                
            }
            * */
            
            return $data;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
    
    
    
    /*
    
    * 
    
    * name: fetch_publisher_invoice_payment_list
    
    * @param : $account_id
    
    * @return : detailed info of publisher payments invoice 
    
    * 
    
    */
    
    public function fetch_publisher_invoice_payment_list($account_id = FALSE,$exchangeval) 
    {
		if($exchangeval){
		$exchangeRate	=	$exchangeval;
		}else{
		$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		}		
        $sql = "SELECT month_name,year,month,($exchangeRate * pub_earn) as pub_earn,($exchangeRate * cumm_earn) as cumm_earn,($exchangeRate * cumm_paid) as cumm_paid,($exchangeRate * (@final_paid:= @final_paid + cumm_paid)) as final_paid, ROUND(($exchangeRate * (ROUND(SUM(cumm_earn),4)-ROUND(@final_paid + cumm_paid,4))),4) as balance,accountid FROM (

SELECT MONTHNAME(date)as month_name,YEAR(date) as year,MONTH(date) as month,ROUND(SUM(pub_earn),4) as pub_earn,ROUND(SUM(cumm_earn),4) as cumm_earn,

		   ROUND(SUM(cumm_paid),4) as cumm_paid,accountid FROM 

		   (

			SELECT date_time as date,account_id as accountid,pub_earn,(@cearn := @cearn + pub_earn) as cumm_earn,0 as cumm_paid 

			FROM

			  (

				SELECT t1.date_time,tf.account_id,SUM(t1.`dj_publisher_earnings`)  as pub_earn FROM `ox_data_summary_ad_hourly` 

				as t1 JOIN ox_zones as tz ON tz.zoneid=t1.zone_id JOIN ox_affiliates as tf  ON tf.affiliateid=tz.affiliateid, (SELECT @cearn:=0) as temp 

				WHERE tf.account_id=$account_id GROUP BY YEAR(t1.date_time),MONTH(t1.date_time) 

			   )as final

			UNION

			SELECT invoice_paid_date as date,0 as accountid,0 as pub_earn,0 as cumm_earn,(@csum := @csum + invoice_amount) as cumm_paid

			FROM 

			  (

				SELECT invoice_paid_date, SUM(invoice_net_amount) as invoice_amount

				from djax_invoice,(SELECT @csum:=0) as t WHERE account_id=$account_id AND invoice_status=1 GROUP BY YEAR(invoice_paid_date),MONTH(invoice_paid_date)

			  ) as t

            ) as l_final GROUP BY YEAR(date),MONTH(date)

        )as td,(SELECT @final_paid:=0) as final_paid WHERE td.accountid=$account_id GROUP BY year,month ORDER BY year DESC,month DESC";
        
        $result = $this->db->query($sql);
        
        $data = $result->result_array();
        
        if ($data) 
        {
            
            foreach ($data as $idx => $value) 
            {
                $data[$idx]['pub_earn']   = currencyformat($value['pub_earn']);
                $data[$idx]['balance']    = currencyformat($value['balance']);
                $data[$idx]['month_name'] = dateformat(strtotime($value['month_name'])); //get date in config format
                
                
            }
            
            return $data;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * 
    
    * name  : fetch_pub_date_wise_payment
    
    * @param: account_id,month,year
    
    * @return:detailed info of publisher payments history 
    
    * 
    
    */
    
    public function fetch_pub_date_wise_payment($month = FALSE, $year = FALSE, $account_id = FALSE,$exchangeval) 
    {
		if($exchangeval){
		$exchangeRate	=	$exchangeval;
		}else{
		$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		}	        
        $sql = "SELECT DATE(date)as date,ROUND(($exchangeRate * SUM(pub_earn)),4) as pub_earn,ROUND(($exchangeRate * SUM(cumm_earn)),4) as cumm_earn,

		   ROUND(($exchangeRate * SUM(cumm_paid)),4) as cumm_paid,accountid FROM 

		   (

			SELECT date_time as date,account_id as accountid,pub_earn,(@cearn := @cearn + pub_earn) as cumm_earn,0 as cumm_paid 

			FROM

			  (

				SELECT t1.date_time,tf.account_id,SUM(t1.`dj_publisher_earnings`)  as pub_earn FROM `ox_data_summary_ad_hourly` 

				as t1 JOIN ox_zones as tz ON tz.zoneid=t1.zone_id JOIN ox_affiliates as tf  ON tf.affiliateid=tz.affiliateid,

				(SELECT @cearn:=0) as temp WHERE tf.account_id=$account_id GROUP BY DATE(t1.date_time) 

			   )as final

			UNION

			SELECT invoice_date as date,0 as accountid,0 as pub_earn,0 as cumm_earn,(@csum := @csum + invoice_amount) as cumm_paid

			FROM 

			  (

				select invoice_date, SUM(invoice_net_amount) as invoice_amount

				from djax_invoice,(SELECT @csum:=0) as t WHERE account_id=$account_id AND invoice_status='1' GROUP BY MONTH(invoice_date) 

			  ) as t

            ) as l_final WHERE MONTH(date)=$month AND YEAR(date)=$year GROUP BY date ORDER BY date DESC";
        
        
        
        $result = $this->db->query($sql);
        
        $data = $result->result_array();
        
        if ($data) 
        {
            foreach ($data as $idx => $value)
             {
                $data[$idx]['netamount'] = currencyformat($value['netamount']);
                $data[$idx]['date']      = dateformat(strtotime($value['date']));
                $data[$idx]['pub_earn']  = currencyformat($value['pub_earn']);
                $data[$idx]['cumm_paid'] = currencyformat($value['cumm_paid']);
            }
            
            return $data;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * ADMIN PANEL
    
    * name  : advertiser_payment_history
    
    * @param: none
    
    * @return:detailed info of advertiser payments history 
    
    * 
    
    */
    
    public function advertiser_payment_history($agencyid,$exchangeval) 
    {
		if($exchangeval){
		$exchangeRate	=	$exchangeval;
		}else{
		$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		}
		
		
        $sql = "SELECT name,ROUND(($exchangeRate * SUM(spend)),4) as tot_spend,ROUND(($exchangeRate * SUM(paid)),4) as tot_paid,ROUND(($exchangeRate * (SUM(paid) - SUM(spend))),4) as balance,month,year,month_number,account_id

	    FROM 

		  (SELECT tcl.contact as name,sum(tds.dj_total_revenue) as spend,0 as paid, MONTHNAME(tds.date_time) as month, YEAR(tds.date_time) as year, MONTH(tds.date_time) as month_number,tcl.account_id FROM `ox_data_summary_ad_hourly` as tds JOIN `ox_banners` as tb ON `tds`.`ad_id`=`tb`.`bannerid` JOIN `ox_campaigns` as tc ON `tb`.`campaignid`=`tc`.`campaignid` JOIN `ox_clients` as tcl ON `tc`.`clientid`=`tcl`.`clientid` WHERE tcl.agencyid=$agencyid AND tds.date_time BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW())  GROUP BY MONTH(tds.date_time) , `tcl`.`account_id`

	UNION

	SELECT tcl.contact as name,0 as spend,sum(amount)as paid, MONTHNAME(approved_date) as month,YEAR(approved_date) as year,MONTH(approved_date)as month_number, dpt.account_id as account_id FROM `djax_payment_transaction` as dpt JOIN ox_clients as tcl ON dpt.account_id=tcl.account_id WHERE dpt.approved_date BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW()) AND  dpt.transaction = 'credit'  AND dpt.admin_approval_status = 1 AND tcl.agencyid=$agencyid GROUP BY MONTH(dpt.approved_date),account_id

) as final GROUP BY month,account_id ORDER BY year DESC,month_number DESC";
        
        
        //~ return $sql;
        $result = $this->db->query($sql);
        
        $data = $result->result_array();
        
        if ($data) 
        {
			
			$data=array_map('callbackformat',$data);
            //currency conversion for 4 digits
            /***
            foreach ($data as $idx => $value) 
            {
		
				$data[$idx]['balance']   = currencyformat($value['balance']);
                $data[$idx]['tot_spend'] = currencyformat($value['tot_spend']);
                $data[$idx]['tot_paid']  = currencyformat($value['tot_paid']);
                $data[$idx]['month']     = dateformat(strtotime($value['month']));
            }
            
            **/
            return $data;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    /*
    
    * ADMIN PANEL
    
    * name  : fetch_advertiser_date_wise_payment_history
    
    * @param: account_id,month,year
    
    * @return:detailed info of advertiser payments history date wise
    
    * 
    
    */
    
    public function fetch_advertiser_date_wise_payment_history($month = FALSE, $year = FALSE, $account_id = FALSE) {
        
        $exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
        
        $sql = "SELECT name,email,payment_type,ROUND(($exchangeRate * SUM(amount)),4) as paid_amt,DATE(approved_date) as date, 		  	        

	   YEAR(approved_date) as year,account_id,admin_approval_status as approve FROM djax_payment_transaction 

	   WHERE approved_date BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW()) AND transaction='credit' AND admin_approval_status=1 AND account_id=$account_id 

	   AND MONTH(approved_date)=$month AND YEAR(approved_date)=$year GROUP BY date ORDER BY MONTH(approved_date)";
        
        $result = $this->db->query($sql);
        
        $data = $result->result_array();
        
        if ($data) 
        {
			$data=array_map('callbackformat',$data);
            
            /*
            foreach ($data as $idx => $value) 
            {
                
                $data[$idx]['date']     = dateformat(strtotime($value['date'])); //converting date format
                $data[$idx]['paid_amt'] = currencyformat($value['paid_amt']);
                
                
                
            }*/
            return $data;
            
        }
        
        else {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * ADMIN PANEL
    
    * name  : publisher_payment_history
    
    * @param: none
    
    * @return:detailed info of publisher payments history 
    
    * 
    
    */
    
    public function publisher_payment_history($agencyid, $exchangeval) 
    {
		if($exchangeval){
		$exchangeRate	=	$exchangeval;
		}else{
		$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		}        
        /*$sql="SELECT dpt.name,ROUND(SUM(dpt.amount),4) as paid_amt,MONTHNAME(dpt.approved_date) as month,MONTH(dpt.approved_date) as 		  	        
        
        month_number,YEAR(dpt.approved_date) as year,dpt.account_id,0 as spend_amt FROM djax_payment_transaction as dpt JOIN ox_affiliates as dof ON dpt.account_id=dof.account_id
        
        WHERE dpt.approved_date BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW() - INTERVAL 1 MONTH) AND dpt.transaction='debit' AND dpt.admin_approval_status=1 
        
        AND dof.agencyid=$agencyid GROUP BY YEAR(dpt.approved_date),MONTH(dpt.approved_date),account_id ORDER BY DATE(dpt.approved_date)";*/
        
        $sql = "SELECT dpt.name,ROUND(($exchangeRate * SUM(dpt.amount)),4) as paid_amt,MONTHNAME(dpt.date) as month,MONTH(dpt.date) as  month_number,YEAR(dpt.date) as year,dpt.account_id,0 as spend_amt FROM djax_payment_transaction as dpt JOIN ox_affiliates as dof ON dpt.account_id=dof.account_id      WHERE dpt.date  AND dpt.transaction='debit' AND dpt.admin_approval_status=1 

	   AND dof.agencyid=$agencyid GROUP BY YEAR(dpt.date),MONTH(dpt.date),account_id ORDER BY DATE(dpt.date) DESC";
        return $sql;
        $result = $this->db->query($sql);
        
        $data = $result->result_array();
        
        if ($data)
         {
            //currency conversion for 4 digits
            foreach ($data as $idx => $value) 
            {
                $data[$idx]['paid_amt'] = currencyformat($value['paid_amt']);
                $data[$idx]['month']    = dateformat(strtotime($value['month']));
                
            }
            
            
            return $data;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * ADMIN PANEL
    
    * name  : fetch_publisher_date_wise_payment_history
    
    * @param: account_id,month,year
    
    * @return:detailed info of publisher payments history date wise
    
    * 
    
    */
    
    public function fetch_publisher_date_wise_payment_history($month = FALSE, $year = FALSE, $account_id = FALSE) {
        
        $exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
        
        /*$sql= "SELECT name,email,payment_type,ROUND(SUM(amount),4) as paid_amt,DATE(approved_date) as date, 		  	        
        
        YEAR(approved_date) as year,account_id,admin_approval_status as approve FROM djax_payment_transaction 
        
        WHERE approved_date BETWEEN date_format(NOW() - INTERVAL 2 MONTH, '%Y-%m-01') AND last_day(NOW() - INTERVAL 1 MONTH) AND transaction='debit' AND 	          			       admin_approval_status=1 AND account_id=$account_id AND MONTH(approved_date)=$month AND YEAR(approved_date)=$year GROUP BY date ORDER BY date";*/
        
        $sql = "SELECT name,email,payment_type,ROUND(($exchangeRate * SUM(amount)),4) as paid_amt,DATE(date) as date, 		  	        

	   YEAR(date) as year,account_id,admin_approval_status as approve FROM djax_payment_transaction 

	   WHERE  transaction='debit' AND admin_approval_status=1 AND account_id=$account_id AND MONTH(date)=$month AND YEAR(date)=$year GROUP BY date ORDER BY date";
        
        $result = $this->db->query($sql);
        
        $data = $result->result_array();
        
        if ($data) 
        {
			  //currency and date format for publisher datewise payments
            foreach ($data as $idx => $value) 
            {   $data[$idx]['date']      = dateformat(strtotime($value['date']));
                $data[$idx]['paid_amt']  = currencyformat($value['paid_amt']);
                $data[$idx]['netamount'] = currencyformat($value['netamount']);
                $data[$idx]['pub_earn']  = currencyformat($value['pub_earn']);
                $data[$idx]['cumm_earn'] = currencyformat($value['cumm_earn']);
                $data[$idx]['cumm_paid'] = currencyformat($value['cumm_paid']);
				if($value['payment_type'] == 1)
				{
					$data[$idx]['payment_type'] ="Wire";
				}
				else
				{
					$data[$idx]['payment_type'] ="Paypal";
				}
				
                
            }
            
            
            return $data;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * ADMIN PANEL
    
    * name  : fetch_admin_payment_history
    
    * @param: none
    
    * @return:detailed info of every month payment history
    
    */
    
    public function fetch_admin_payment_history($agencyid,$exchangeval) {
        
		if($exchangeval){
			$exchangeRate	=	$exchangeval;
		}else{
			$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		}        
        $sql = "SELECT ROUND(($exchangeRate * SUM(adv_amt)),4) as total_credit,ROUND(($exchangeRate * SUM(pub_amt)),4) as total_debit,ROUND(($exchangeRate * (SUM(adv_amt)-SUM(pub_amt))),4) as revenue,month,year

			FROM (

			   SELECT SUM(dpt.amount) as adv_amt, 0 as pub_amt,MONTHNAME(dpt.date) as month,YEAR(dpt.date) as year,dpt.date as app

			  FROM  djax_payment_transaction as dpt JOIN ox_clients as dcl ON dpt.account_id=dcl.account_id

			  WHERE dpt.transaction='credit' AND dpt.admin_approval_status=1 AND dcl.agencyid=$agencyid GROUP BY MONTH(dpt.date)

			  UNION 

			   SELECT 0 as adv_amt,SUM(dpt.amount) as pub_amt,MONTHNAME(dpt.date) as month,YEAR(dpt.date) as year,dpt.date as app

			  FROM  djax_payment_transaction as dpt JOIN ox_affiliates as dcl ON dpt.account_id=dcl.account_id 

			  WHERE dpt.transaction='debit' AND dpt.admin_approval_status=1 AND dcl.agencyid=$agencyid GROUP BY MONTH(dpt.date)

			) AS final  GROUP BY year,month ORDER BY year,month";
        
        $result = $this->db->query($sql);
        log_message('error',$this->db->last_query());
        $data = $result->result_array();
        
        if ($data) 
        {
            // currency conversion  //
            foreach ($data as $idx => $value) 
            {
                $data[$idx]['month']        = dateformat(strtotime($value['month'])); //date form helper
                $data[$idx]['total_debit']  = currencyformat($value['total_debit']);
                $data[$idx]['total_credit'] = currencyformat($value['total_credit']);
                $data[$idx]['month_name'] = $value['month'];
               
            }
            // currency conversion  //
            return $data;
            
        }
        
        else {
            
            return FALSE;
            
        }
        
        
        
    }
    
    
    
    
    
    /*
    
    * ADMIN PANEL
    
    * name  : reject_invoice_payment
    
    * @param: invoice_id
    
    * @return: invoice Payment canceled by admin
    
    */
    
    public function reject_invoice_payment($invoice_id) {
        
        if ($invoice_id)
            $this->db->select('account_id');
        
        $this->db->where('invoice_id', $invoice_id);
        
        $result = $this->db->get(TAB_INVOICE);
        
        $account_id = $result->result_array();
        
        if ($account_id)
        //CHANGE THE INVOICE STATUS TO CANCEL AND RETURN account_id
            $data = array(
                'invoice_status' => 2
            );
        
        $this->db->where('invoice_id', $invoice_id);
        
        $this->db->update(TAB_INVOICE, $data);
        
        $acc_id = $account_id[0]['account_id'];
        
        return $acc_id;
        
    }
    
    
    
    /*
    
    * ADVERTISER PANEL
    
    * name  : fetch_deposit_list
    
    * @param: invoice_id
    
    * @return: invoice Payment canceled by admin
    
    */
    
    public function fetch_deposit_list($account_id, $exchangeval) {
        
		if($exchangeval){
		$exchangeRate	=	$exchangeval;
		}else{
		$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		}        
        $this->db->select('*');
        
        $this->db->where('tpt.transaction', "credit");
        
        $this->db->where('tpt.account_id', $account_id);
        
        $this->db->from(TAB_PAY_TRANS . ' as tpt ');
        
        $this->db->join(TAB_BILL_INFO . ' as tbi ', 'tpt.ref_billing_id=tbi.billing_id');
        
        $query = $this->db->get();
        
        $result = $query->result_array();
        
        if ($result) 
        {
            
            foreach ($result as $idx => $value) 
            {
                $result[$idx]['amount'] = currencyformat($exchangeRate * $value['amount']);
                $result[$idx]['date']   = dateformat(strtotime($value['date']));
            }
            
            return $result;
            
        }
        
        else {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * ADMIN PANEL
    
    * name  : fetch_adv_deposit_list
    
    * @param: invoice_id
    
    * @return: Advertiser Deposit Payment
    
    */
    
    public function fetch_adv_deposit_list($agencyid,$exchangeval) 
    {
		if($exchangeval){
		$exchangeRate	=	$exchangeval;
		}else{
		$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		}            
        $this->db->select('*');
        
        $this->db->where('tpt.transaction', "credit");
        
        $this->db->where('tpt.admin_approval_status', 1);
        
        $this->db->where('tc.agencyid', $agencyid);
        
        $this->db->where_not_in('tpt.account_id', 0);
        
        $this->db->from(TAB_PAY_TRANS . ' as tpt ');
        
        $this->db->join(TAB_BILL_INFO . ' as tbi ', 'tpt.ref_billing_id=tbi.billing_id');
        
        $this->db->join(TAB_CLIENTS . ' as tc ', 'tc.account_id=tpt.account_id');
        
        $query = $this->db->get();
        
        $result = $query->result_array();
        
        if ($result) {
            // currency conversion  //
            foreach ($result as $idx => $value) 
            {
                $result[$idx]['amount'] = currencyformat($exchangeRate * $value['amount']);
                $result[$idx]['date']   = dateformat(strtotime($value['date'])); //date from helper 
                
            }
            
            
            return $result;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
    
    /*
    
    * ADMIN PANEL
    
    * name  : fetch_billing_details
    
    * @param: invoice_id
    
    * @return: Advertiser Billing Details
    
    */
    
    public function fetch_billing_details($bi_id) {
        
        $this->db->select('*');
        
        $this->db->where('billing_id', $bi_id);
        
        $query = $this->db->get(TAB_BILL_INFO);
        
        $result = $query->result_array();
        
        if ($result) {
            
            return $result;
            
        }
        
        else {
            
            return FALSE;
            
        }
        
    }
    
    
    
    
    
    /*
    
    * ADMIN PANEL
    
    * name  : check_payment_process
    
    * @param: pay_id
    
    * @return: return its approved or rejected
    
    */
    
    public function check_payment_process($pay_id) {
        
        $query = $this->db->get_where(TAB_PAY_TRANS, array(
            'admin_approval_status' => 0,
            'id' => $pay_id
        ));
        
        if ($query->num_rows > 0)
            return TRUE;
        
        else
            return FALSE;
        
    }
    
    
    
    /*
    
    * ADMIN PANEL
    
    * name  : check_invoice_payment_process
    
    * @param: invoice_id
    
    * @return: return its approved or rejected
    
    */
    
    public function check_invoice_payment_process($invoice_id) {
        
        $query = $this->db->get_where(TAB_INVOICE, array(
            'invoice_id' => $invoice_id,
            'invoice_status' => 0
        ));
        
        if ($query->num_rows > 0)
            return TRUE;
        
        else
            return FALSE;
        
    }
    
    
    
    /*
    
    * ADMIN PANEL
    
    * name  : fetch_admin_revenue_details
    
    * @param: agencyid
    
    * @return: return month wise revenue details
    
    */
    
    public function fetch_admin_revenue_details($agencyid,$exchangeval) {
		if($exchangeval){
		$exchangeRate	=	$exchangeval;
		}else{
		$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		}              // get active exchange id .Added on 03-11-2015 By sakthivel.P
        $select_exchange = "SELECT a.exchange_id,a.exchange_name  FROM `djax_3rd_party_ad_exchange` a join ox_zones b on b.dj_is_dsp=a.exchange_id where a.status=1";
        $exchange_query  = $this->db->query($select_exchange)->result_array();
        if (count($exchange_query) > 0) {
            $sum_append_string = '';
            foreach ($exchange_query as $key => $exchange):
                $sum_append_string .= 'IFNULL( ROUND( SUM( IF(oxz.dj_is_dsp =' . $exchange['exchange_id'] . ', oxds.dj_total_revenue, 0)) - SUM( IF(oxz.dj_is_dsp =' . $exchange['exchange_id'] . ', oxds.dj_publisher_earnings, 0)) , 2 ) , 0 ) AS ' . str_replace(' ','_',$exchange['exchange_name']) . '_revenue,';
            endforeach;
            $SQL = "SELECT ($exchangeRate * IFNULL( ROUND( SUM( IF(oxz.dj_is_dsp is null, oxds.dj_total_revenue, 0)) - SUM( IF(oxz.dj_is_dsp is null, oxds.dj_publisher_earnings, 0)) , 2 ) , 0 )) AS tot_revenue," . $sum_append_string . " MONTHNAME( oxds.date_time ) AS month_name, MONTH( oxds.date_time ) AS MONTH , YEAR( oxds.date_time ) AS YEAR,oxds.zone_id ,oxz.dj_is_dsp,oxa.agencyid as agencyid FROM `ox_data_summary_ad_hourly` oxds JOIN ox_zones AS oxz ON oxz.zoneid = oxds.zone_id left join djax_3rd_party_ad_exchange dsp on dsp.exchange_id= oxz.dj_is_dsp JOIN ox_affiliates AS oxa ON ( oxa.affiliateid = oxz.affiliateid AND oxa.agencyid ={$agencyid} ) group by MONTH order by MONTH";
        } else {
            $SQL = "SELECT ($exchangeRate * IFNULL(ROUND(SUM(oxds.dj_total_revenue) - SUM(oxds.dj_publisher_earnings),4),0)) as tot_revenue,MONTHNAME(oxds.date_time) as month_name,

	            MONTH(oxds.date_time) as month,oxa.agencyid as agencyid,YEAR(oxds.date_time) as year

				FROM " . TAB_DATA_SUM_AD_HOURLY . " as oxds

				JOIN " . TAB_ZONES . " as oxz ON oxz.zoneid=oxds.zone_id

				JOIN " . TAB_AFFILIATE . " as oxa ON (oxa.affiliateid=oxz.affiliateid AND oxa.agencyid={$agencyid}) GROUP BY MONTH(oxds.date_time) DESC

				";
        }
        $query = $this->db->query($SQL);
        
        
        
        $result = $query->result_array();
        
        
        
        if ($result) 
        {
          
            foreach ($result as $idx => $value) 
            {
                
                $result[$idx]['tot_revenue']    = currencyformat($value['tot_revenue']);
                $result[$idx]['smaato_revenue'] = currencyformat($value['smaato_revenue']);
               
                 
                
            }
            
            return $result;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
    }
    
    
    
    
    
    /*
    
    * ADMIN PANEL
    
    * name  : fetch_admin_revenue_details_date_wise
    
    * @param: month,year,agencyid
    
    * @return: return date wise revenue details
    
    */
    
    public function fetch_admin_revenue_details_date_wise($month, $year, $agencyid) 
    {
		$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
        $select_exchange = "SELECT a.exchange_id,a.exchange_name  FROM `djax_3rd_party_ad_exchange` a join ox_zones b on b.dj_is_dsp=a.exchange_id where a.status=1";
        $exchange_query  = $this->db->query($select_exchange)->result_array();
        if (count($exchange_query) > 0) {
            $sum_append_string = '';
            foreach ($exchange_query as $exchange):
                $sum_append_string .= 'IFNULL( ROUND( SUM( IF(oxz.dj_is_dsp =' . $exchange['exchange_id'] . ', oxds.dj_total_revenue, 0)) - SUM( IF(oxz.dj_is_dsp =' . $exchange['exchange_id'] . ', oxds.dj_publisher_earnings, 0)) , 2 ) , 0 ) AS ' . str_replace(' ', '_',$exchange['exchange_name']) . '_revenue,';
            endforeach;
            $SQL = " SELECT date_format(oxds.date_time,'%d-%m-%Y') as date ,($exchangeRate * IFNULL( ROUND( SUM( IF(oxz.dj_is_dsp is null, oxds.dj_total_revenue, 0)) - SUM( IF(oxz.dj_is_dsp is null, oxds.dj_publisher_earnings, 0)) , 2 ) , 0 )) AS tot_revenue," . $sum_append_string . " MONTHNAME( oxds.date_time ) AS month_name, MONTH( oxds.date_time ) AS MONTH , YEAR( oxds.date_time ) AS YEAR,oxds.zone_id ,oxz.dj_is_dsp FROM `ox_data_summary_ad_hourly` oxds JOIN ox_zones AS oxz ON oxz.zoneid = oxds.zone_id left join djax_3rd_party_ad_exchange dsp on dsp.exchange_id= oxz.dj_is_dsp JOIN ox_affiliates AS oxa ON ( oxa.affiliateid = oxz.affiliateid AND oxa.agencyid ={$agencyid} ) WHERE MONTH(oxds.date_time)={$month} AND YEAR(oxds.date_time)={$year} group by date(oxds.date_time)";
            
        } else {
            $SQL = "SELECT ($exchangeRate * IFNULL(ROUND(SUM(oxds.dj_total_revenue) - SUM(oxds.dj_publisher_earnings),4),0)) as tot_revenue,MONTHNAME(oxds.date_time) as month_name,
					MONTH(oxds.date_time) as MONTH,oxds.zone_id ,oxz.dj_is_dsp,oxa.agencyid as agencyid,YEAR(oxds.date_time) as YEAR,DATE(oxds.date_time) as date

				FROM " . TAB_DATA_SUM_AD_HOURLY . " as oxds

				JOIN " . TAB_ZONES . " as oxz ON oxz.zoneid=oxds.zone_id

				JOIN " . TAB_AFFILIATE . " as oxa ON (oxa.affiliateid=oxz.affiliateid AND oxa.agencyid={$agencyid}) WHERE MONTH(oxds.date_time)={$month} AND YEAR(oxds.date_time)={$year}

				GROUP BY DATE(oxds.date_time)";
        }
        
        
        $query = $this->db->query($SQL);
        
        
        
        $result = $query->result_array();
        
       
        
        if ($result) 
        {  
            foreach ($result as $idx => $value) 
            {
                $result[$idx]['tot_revenue']    = currencyformat($value['tot_revenue']);
                $result[$idx]['smaato_revenue'] = currencyformat($value['smaato_revenue']);
                $result[$idx]['date']           = dateformat(strtotime($value['date'])); //date from helper
                $result[$idx]['month_name']     = dateformat(strtotime($value['month_name']));
                
             
            }
            
            return $result;
            
        }
        
        else 
        {
            
            return FALSE;
            
        }
        
        
        
    }
    
    
    
    
    
    /*	
     * name: publisher_invoice_viewmore	
     * @param : $invoice_id	
     * @return :detailed list of publisher payment 	
     */
    public function fetch_aff_individual_invoice($invoice_id = FALSE) {
        $exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
        $this->db->select('ti.invoice_id as id,('.$exchangeRate.' * ti.invoice_net_amount) as total_earn,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,ti.invoice_period_days as days,ti.invoice_status,tu.contact_name as name,tu.email_address as email,tii.item_code,tii.item_desc,tii.amount,tii.currency,`ta`.`name` as nw_name, `ta`.`email` as nw_email');
        $this->db->from(TAB_INVOICE . ' as ti ');
        $this->db->join(TAB_INVOICE_ITEM . ' as tii ', 'tii.invoice_id=ti.invoice_id');
        $this->db->join(TAB_NWK_MANAGERS . ' as tnm ', 'tnm.manager_account_id=ti.nw_mngr_acc_id');
        $this->db->join(TAB_NETWORKS . ' as tn ', 'tn.network_id=tnm.network_account_id');
        $this->db->join(TAB_USERS . ' as tu ', 'tu.user_id=tn.default_user_id');
        $this->db->join(TAB_AGENCY . ' as ta', 'ta.agencyid=tnm.agency_id');
        $this->db->where('ti.invoice_type', "int_aff");
        $this->db->where('ti.invoice_id', $invoice_id);
        $query  = $this->db->get();
        $result = $query->result_array();
        
        if ($result) {
            return $result;
        } else {
            return FALSE;
        }
    }
    
    
    /*
    
    * name: fetch_affiliate_invoice_list
    
    * @param : none
    
    * @return :detailed list of affiliate payment 
    
    */
    public function fetch_affiliate_invoice_list($agencyid = FALSE) {
		$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
        $this->db->select('tu.contact_name as name,MONTHNAME(ti.invoice_date)as month,YEAR(ti.invoice_date)as year,ti.invoice_status,ti.invoice_id,ti.invoice_code,('.$exchangeRate.' * ti.invoice_net_amount) as netamount,`tu`.`email_address` as email, `ta`.`name` as nw_name, `ta`.`email` as nw_email');
        $this->db->from(TAB_INVOICE . ' as ti ');
        $this->db->join(TAB_NWK_MANAGERS . ' as tnm ', 'tnm.manager_account_id=ti.nw_mngr_acc_id');
        $this->db->join(TAB_NETWORKS . ' as tn ', 'tn.network_id=tnm.network_account_id');
        $this->db->join(TAB_USERS . ' as tu ', 'tu.user_id=tn.default_user_id');
        $this->db->join(TAB_AGENCY . ' as ta', 'ta.agencyid=tnm.agency_id');
        $this->db->where('ti.invoice_type', "int_aff");
        if ($agencyid != FALSE && $agencyid != 1) {
            $this->db->where('tnm.agency_id', $agencyid);
        }
		
        $query = $this->db->get();
        
        $result = $query->result_array();
	
	
        if ($result) {
            return $result;
        } else {
            return FALSE;
        }
    }
    public function get_third_party() {
        $select_exchange = "SELECT a.exchange_id,a.exchange_name  FROM `djax_3rd_party_ad_exchange` a join ox_zones b on b.dj_is_dsp=a.exchange_id where a.status=1";
        $exchange_query  = $this->db->query($select_exchange)->result_array();
        return count($exchange_query);
        if (count($exchange_query) > 0) {
            return $exchange_query;
        } else {
            return FALSE;
        }
    }
    
  
	public function fetch_aff_payment_list($invoice_id = FALSE, $agencyid = FALSE,$currency= FALSE)
	{
		
		$exchangeRate	=	$this->config->item('exchangeRate');//Exchange Rate	
		
		/*$this->db->select('ti.invoice_id,ti.account_id as accnt_id,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,ti.invoice_period_days as days,ti.invoice_status,ti.invoice_net_amount as amount,ti.nw_mngr_acc_id as acc_id, ta.agencyid as agid,ta.name as name,ta.email as email,`tu`.`contact_name` as admin_name,`tu`.`email_address` as admin_email,tn.company_city as city,tn.company_state as state,tn.company_country as country_id,tn.company_address as address,tc.name as country,tn.company_name,tu.*,`tapd`.`paypal_id`,tapd.payment_type',false);
		$this->db->join(TAB_NWK_MANAGERS . ' as tnm ', 'tnm.network_account_id=ti.account_id AND tnm.manager_account_id=ti.nw_mngr_acc_id');
		$this->db->join(TAB_NETWORKS . ' as tn ', 'tn.network_id=tnm.network_account_id');
		$this->db->join(TAB_USERS . ' as tu ', 'tu.user_id=tn.default_user_id');
		$this->db->join(TAB_ADMIN_PAYD . ' as tapd ', 'tapd.account_id=ti.nw_mngr_acc_id');
		$this->db->join(TAB_TARG_COUNTRY . ' as tc', 'tc.id=tn.company_country');
		$this->db->join(TAB_AGENCY . ' as ta', 'ta.agencyid=tnm.agency_id');
		$this->db->where('tapd.status', 1);
		$this->db->where('ti.invoice_status', 0);
		$this->db->where('ti.type', 1);*/
		$additional = "";
		$join = "";
		if ($agencyid != FALSE)
		{
			$additional.= " AND tnm.agency_id = $agencyid ";
		}
		if ($invoice_id)
		{
			$join .= "join ".TAB_INVOICE ."  as ti on ti.invoice_id = ".$invoice_id."";
	
		}
		else
		{
			$join .= "join ".TAB_INVOICE ." as ti ";
		}
				
		
	$sql = "SELECT ti.invoice_id,ti.account_id as accnt_id,ti.invoice_code,date(ti.invoice_date)as in_date,date(ti.invoice_start_date)as start_date,date(ti.invoice_end_date)as end_date,ti.invoice_period_days as days,ti.invoice_status,($exchangeRate * ti.invoice_net_amount) as amount,ti.nw_mngr_acc_id as acc_id, ta.agencyid as agid,ta.name as name,ta.email as email,`tu`.`contact_name` as admin_name,`tu`.`email_address` as admin_email,tn.company_city as city,tn.company_state as state,tn.company_country as country_id,tn.company_address as address,tc.name as country,tn.company_name,tu.*,`tapd`.`paypal_id`,tapd.payment_type";

	$sql.=" FROM ".TAB_AGENCY." as ta ";
	$sql.= " $join JOIN ".TAB_NWK_MANAGERS."  as tnm ON tnm.network_account_id=ti.account_id AND tnm.manager_account_id=ti.nw_mngr_acc_id "; 
	$sql.="  JOIN ".TAB_NETWORKS."  as tn ON tn.network_id=tnm.network_account_id";
	$sql.=" JOIN ".TAB_USERS."  as tu ON tu.user_id=tn.default_user_id ";
	$sql.=" JOIN ".TAB_ADMIN_PAYD." as tapd ON tapd.account_id=ti.nw_mngr_acc_id ";
	$sql.=" JOIN ".TAB_TARG_COUNTRY."  as tc ON tc.id=tn.company_country ";
	$sql.=" where tapd.status = 1 AND ti.invoice_status = 0  AND ti.invoice_type = 'int_aff' AND ti.invoice_description !='BAL' AND ta.agencyid=tnm.agency_id $additional group by ti.invoice_id"; 


	
		$query = $this->db->query($sql);	
		$result = $query->result_array();



		if ($result)
		{ 	foreach ($result as $idx => $value) 
            {
                
                $result[$idx]['in_date']   = dateformat(strtotime($value['in_date'])); //date format cinversion
				$result[$idx]['date_list']   = date('Y-m-d',strtotime($value['in_date'])); //date format cinversion
                $result[$idx]['start_date'] = dateformat(strtotime($value['start_date']));
                $result[$idx]['end_date']   = dateformat(strtotime($value['end_date']));
                $result[$idx]['amount'] = $value['amount'];
                  
	//$tmp=$this->currency_converter->currency_convert_account(array('datetime'=>$result[$idx]['date_list'] ,
	//'currency_code'=>$currency,'amount'=>$result[$idx]['amount']));
               // print_r($tmp);die("ddd");
			   // $currency_con =currencyformat($tmp,$currency); 
			   // $result[$idx]['currency_con'] =$currency_con;
			    // $result[$idx]['con_amount'] = $tmp; 
            }
          
			return $result;
		}
		else
		{
			return FALSE;
		}
		
		
		

	}
	
	public function fetch_invoice_account_id($invoice_id = FALSE)
	{
		 $select_exchange = "SELECT net.company_name,ti.account_id, ti.invoice_id as id,ti.invoice_date as in_date, ti.invoice_net_amount as amount, net.email_address as email, net.is_super_admin, concat(net.first_name, net.last_name) as name  FROM `djax_invoice` as ti join djax_networks net on net.account_id=ti.account_id where ti.invoice_status=0 and ti.invoice_id ='".$invoice_id."' ";
        $exchange_query  = $this->db->query($select_exchange)->result_array();
        
        if (count($exchange_query) > 0) {
            return $exchange_query[0];
        } else {
            return FALSE;
        }
	}
	

	  public function fetch_admin_account_details($account_id = FALSE) {
        
        if ($account_id) {
             $this->db->select('*,bank_acc_no as bank_account_no');
            $this->db->where('status', 1);
            $this->db->order_by("id", "desc");
            $query = $this->db->get_where('djax_admin_payment_details', array(
                'account_id' => $account_id
            ));
            
            
           
            if ($query->num_rows > 0) {
                
                $result = $query->result_array();
                
                return $result[0];
                
            } else {
                
                return FALSE;
                
            }
            
            
            
        } else {
            
            return FALSE;
            
        }
        
    }
	
	
	}





