<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Do_mobile_creative extends CI_Model
{
    /*
	 * 
	 * name: fetch_mobile_screen_sizes
	 * @param :
	 * @return : $result
	 * 
	 * Fetch mobile screen sizes for image
	 */
		
	function fetch_mobile_screen_sizes()
	{
		$this->db->select('name, value, width, height');
		$query = $this->db->get(TAB_CONF_MOBILE_SCREEN_SIZE);	
		$result = $query->result_array();
		if($result)
		{
			return $result;
		}
		else
			return FALSE;
	}
		
	function add($creative_data,$agency_id=FALSE,$is_house_ad=FALSE)
	{
		if($creative_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banners */
			$this->db->insert(TAB_BANNERS,$creative_data);
			
			$insert_id	= $this->db->insert_id();
			
			// Process of auto link adblocks
			
			 /*Manual linking*/
			$link_type=$this->default_configurations->get('linking_type');
			  
			if($link_type !='manual linking')
			{ 
					$res=$this->Do_mobile_auto_link->link_mobile_adblocks($insert_id,$agency_id,$is_house_ad);
				
			}else{
				if($is_house_ad==1)
				{
					$res=$this->Do_mobile_auto_link->link_mobile_adblocks($insert_id,$agency_id,$is_house_ad);
					
				}
			}	
				    
			/*Manual linking*/
			
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $insert_id;
			}
		}
		else
			return FALSE;
	}
	
	
	/*
	 * 
	 * name: add_child
	 * @param :
	 * @return : TRUE (or) FALSE
	 * 
	 * Add the child creative into the database
	 */
	function add_child($creative_data)
	{
		if($creative_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banners */
			$this->db->insert(TAB_BAN_DEPEND,$creative_data);
			#echo $this->db->last_query();exit;
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: edit_web
	 * @param :$creative_data,$creative_id,$blob_data
	 * @return : TRUE (or) FALSE
	 * 
	 * Edit the WEB creative
	 */
	function edit_mobile($creative_data,$creative_id=false,$agency_id=FALSE,$is_house_ad=false)
	{
		if($creative_data && $creative_id)
		{
			$this->db->trans_start();

			/*Update in ox_banners */
			$this->db->where('bannerid',$creative_id);
			$this->db->update(TAB_BANNERS,$creative_data);
			
			// Process of auto link adblocks
			if($agency_id!=FALSE && $is_house_ad==1)
			{
			  $this->Do_mobile_auto_link->link_mobile_adblocks($creative_id,$agency_id,$is_house_ad);
			}
			
			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
	}
	/*
	 * 
	 * name: edit_expand
	 * @param :$creative_data,$creative_id
	 * @return : TRUE (or) FALSE
	 * 
	 * Edit the EXPAND creative
	 */
	function edit_child_mobile($creative_data,$where=false)
	{
		if($creative_data && $where)
		{
			$this->db->trans_start();

			/*Update in ox_banners */
			$this->db->where($where);
			$this->db->update(TAB_BAN_DEPEND,$creative_data);
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
	}
	
	function fetch_creative($creative_id=false)
	 {
	 	if($creative_id)
		{
			// For getting parent banner
			$this->db->select('oxb.contenttype,oxb.bannerid,oxb.campaignid,oxb.description,oxb.filename,oxb.storagetype,oxb.url,oxb.imageurl,oxb.bannertext,oxb.htmltemplate,oxb.dj_master_banner');
			$this->db->from(TAB_BANNERS .'as oxb');
			$this->db->where('bannerid ',$creative_id);
			$this->db->where('dj_is_deleted ','0');
			$this->db->order_by('dj_added_date ');
			$query = $this->db->get();	
			$result = $query->result_array();

			if($result)
				// For getting child banners
				$this->db->select('file_path,width,height,content_type');
				$this->db->where('banner_id', $creative_id);
				$query_child = $this->db->get(TAB_BAN_DEPEND);
				$result_child = $query_child->result_array();

			if($result_child)
				$data = array("0"=>$result, "1"=>$result_child);

			return $data;		
		}
		else
			return FALSE;
	}
	
	function fetch_parent_creative($creative_id=false)
	 {
	 	if($creative_id)
		{
			$this->db->select('*');
			$this->db->where('bannerid ',$creative_id);
			$this->db->where('dj_is_deleted ','0');
			$this->db->order_by('dj_added_date ');
			$query = $this->db->get(TAB_BANNERS);	
			$result = $query->result_array();
			if($result)
			{
				return $result;
			}
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	function fetch_child_creative($creative_id=false)
	{
	 	if($creative_id)
		{	
			$this->db->select('*');
			$this->db->where('banner_id', $creative_id);
			$this->db->order_by('image_id ');
			$query 	= 	$this->db->get(TAB_BAN_DEPEND);
			$result = 	$query->result_array();
			if($result)
				return $result;		
			else
				return FALSE;
		}
		else
			return FALSE;
	}
}

