<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Do_mobile_auto_link extends CI_Model

{


	public $agency_id = '';

	

	/*

	 * 

	 * name: fetch_mobile_adblock

	 * @param :

	 * @return : $result

	 * 

	 * Lists a mobile ad block of an advertiser

	 */

	 

	 function fetch_mobile_adblock($zone_id=false)

	 {

		if($zone_id)

		{

			$this->db->select('width,height,delivery,dj_zone_type');		

			$this->db->where('zoneid ',$zone_id);

			$this->db->where('dj_is_deleted ','0');

			$query = $this->db->get(TAB_ZONES);		

			$result = $query->result_array();

			if($result)

				return $result;

			else

				return FALSE;

		}

		else

			return FALSE;

		

	}

	

	/*

	 * 

	 * name: fetch_creative

	 * @param :

	 * @return : $result

	 * 

	 * Get Creatives

	 */

	 

	 function fetch_creative($creative_id=false)

	 {

		if($creative_id)

		{

			$this->db->select('dj_banner_type,campaignid');		

			$this->db->where('bannerid ',$creative_id);

			$this->db->where('dj_is_deleted ','0');

			$query = $this->db->get(TAB_BANNERS);	

			$result = $query->result_array();

			if($result)

				return $result;

			else

				return FALSE;

		}

		else

			return FALSE;

		

	}

	function mobile_link_cross_ads($zone_id=FALSE,$type=FALSE)
	{
		if($zone_id)
		{
			$ad_type = $this->adtype_selection($type);
			$get_campaignid = $this->get_banner_details($zone_id,$ad_type);
			if($get_campaignid)
			{
			$creative_ids = array_column($get_campaignid, 'bannerid');
			$camp_ids = array_column($get_campaignid, 'campaignid');
			$del_banner = $this->banner_delete($creative_ids,$zone_id);
			$camp = $this->get_campaign_detail($zone_id);
			}
			//~ $creative_ids = array_column($get_campaignid, 'bannerid');
			//~ $del_banner = $this->banner_delete($creative_ids,$zone_id);
		}
	}
	function get_campaign_detail($zone_id=FALSE)
	{
			
				$this->db->select('*');		
				$this->db->where('zone_id',$zone_id);
				$query = $this->db->get(TAB_PLACE_ZONE_ASSOC);	
				$result = $query->result_array();
				if($result)
				{
					$banner = $this->get_banner_details($zone_id);
					$creative_ids = array_column($result, 'placement_id');
					$camp_ids = array_column($banner, 'campaignid');
					
					$delete_id = array_diff($creative_ids,$camp_ids);
					//$del = array_keys(array_intersect(array_count_values($delete_id),[1]));
					//print_r($del);die("-");
					$this->unlink_ads_placement_exist($zone_id,$delete_id);
				}
	} 
	function unlink_ads_placement_exist($zone_id=false,$del=false)
	 {
		if($zone_id)
		{

			$this->db->trans_start();
			$this->db->where_in('placement_id',$del);
			$this->db->where('zone_id',$zone_id);
			$this->db->delete(TAB_PLACE_ZONE_ASSOC);
				//echo $this->db->last_query();exit;
			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();
	   }
	}
	function banner_delete($creative_ids=FALSE,$zone_id=FALSE)
	{
		
		$this->db->trans_start();
		$this->db->where_in('ad_id',$creative_ids);
		$this->db->where('zone_id',$zone_id);
		$this->db->delete(TAB_AD_ZONE_ASSOC);
		if ($this->db->trans_status() === FALSE)
			$this->db->trans_rollback();
		else
			$this->db->trans_commit();
	}
	function adtype_selection($type=FALSE)
	{
				switch($type)
				{
					case MOBILE_AD_BLOCK_INLINE:
						$adblocks = "V_IN";
						break;
					case MOBILE_AD_BLOCK_IMAGE:
						$adblocks = "W_IMG";
						break;
					case MOBILE_AD_BLOCK_TEXT:
						$adblocks = "W_TEXT";
						break;
					case MOBILE_AD_BLOCK_OVERLAY:
						$adblocks = "V_OL";						
						break;
				}
			return $adblocks;
	}
	
	function get_banner_details($zone_id=FALSE,$type=FALSE)
	{
		
		$this->db->select('oxb.bannerid,oxb.campaignid');

		$this->db->join(TAB_AD_ZONE_ASSOC.' as oxcamp','oxcamp.ad_id=oxb.bannerid');

		$this->db->where('oxb.dj_banner_type', $type);
		
		$this->db->where('oxcamp.zone_id', $zone_id);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();
//echo $this->db->last_query();exit;
		if($result)
		{

				return $result;
			}

			else
			{

				return FALSE;
			}
		
		
	}
	/*

	 * 

	 * name:mobile_link_ads_get

	 * @param : zone_id

	 * @return : NULL

	 * 

	 * Link zone to creative

	 */

	

	function mobile_link_ads($zone_id,$agency_id=FALSE,$house_ad=FALSE)
	{
		if($zone_id)

		{
			//Sets the agency_id

			if($agency_id!=FALSE)
			{
			 $this->agency_id = $agency_id;
		    }

			// Unlink the previously linked creatives for zone

			$this->unlink_ads($zone_id);
			$this->unlink_ads_placement($zone_id);
			$zone_details = $this->fetch_mobile_adblock($zone_id);

			$zone = $zone_details[0];

			$zone_type = $zone['dj_zone_type'];

			switch($zone_type)

			{

				case MOBILE_AD_BLOCK_IMAGE:

								$creatives = $this->fetch_image_creatives($house_ad);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);
									}

								}

								break;
					case CROSS_AD_BLOCK_BANNER:
								$cross=1;
								$creatives = $this->fetch_image_creatives($house_ad,$cross);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);
									}

								}

								break;

				case MOBILE_AD_BLOCK_INTERSTITIAL:

								$creatives = $this->fetch_interstitial_creatives($house_ad);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);
	
									}

								}

								break;

				case MOBILE_AD_BLOCK_EXPAND:

								$creatives = $this->fetch_expand_creatives($house_ad);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);	
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);

									}

								}

								break;

				case MOBILE_AD_BLOCK_REVEAL:

								$creatives = $this->fetch_reveal_creatives($house_ad);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);

									}

								}

								break;

				case MOBILE_AD_BLOCK_FLEX:

								$creatives = $this->fetch_flex_creatives($house_ad);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);

									}

								}

								break;

				case MOBILE_AD_BLOCK_ADHESION: 


								$creatives = $this->fetch_adhension_creatives($house_ad);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);

									}

								}

								break;

				case MOBILE_AD_BLOCK_FLIMSTRIP:

								$creatives = $this->fetch_filmstrip_creatives($house_ad);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);

									}

								}

								break;

				case MOBILE_AD_BLOCK_SLIDER:

								$creatives = $this->fetch_slider_creatives($house_ad);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);	
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);

									}

								}

								break;

				case MOBILE_AD_BLOCK_PULL:

								$creatives = $this->fetch_pull_creatives($house_ad);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);

									}

								}

								break;

				
				case MOBILE_AD_BLOCK_TEXT:

								$creatives = $this->fetch_text_creatives($house_ad);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	

									}

								}

								break;	
				case CROSS_AD_BLOCK_TEXT:
				$cross=1;

								$creatives = $this->fetch_text_creatives($house_ad,$cross);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	

									}

								}

								break;		
				
				
					case MOBILE_AD_BLOCK_OVERLAY:
									
								$creatives = $this->fetch_overlay_creatives($house_ad);
								
								
								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

									$this->add_link_ads($link_assoc_data);
									$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									

									}

								}
								break;
				  case CROSS_AD_BLOCK_OVERLAY:
								$cross=1;	
								$creatives = $this->fetch_overlay_creatives($house_ad,$cross);
								
								
								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

									$this->add_link_ads($link_assoc_data);
									$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									

									}

								}
								break;	
                  case MOBILE_AD_BLOCK_INLINE:
									
								$creatives = $this->fetch_inline_creatives($house_ad);
								
								
								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

									$this->add_link_ads($link_assoc_data);	
									$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);
									

									}

								}
								break;	
						 case CROSS_AD_BLOCK_INLINE:
									$cross=1;
								$creatives = $this->fetch_inline_creatives($house_ad,$cross);
								
								
								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

									$this->add_link_ads($link_assoc_data);	
									$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);
									

									}

								}
								break;	
						case MOBILE_AD_BLOCK_INTERSTITIAL_VIDEO:

								$creatives = $this->fetch_interstital_video_creatives($house_ad);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);
										
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);

									}

								}

								break;
								
						case MOBILE_AD_BLOCK_NATIVE_VIDEO:

								$creatives = $this->fetch_native_video_creatives($house_ad);

								if($creatives!=FALSE)

								{

									foreach($creatives as $c)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);

										$this->add_link_ads($link_assoc_data);
										
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);

									}

								}

								break;			
								
						case MOBILE_AD_BLOCK_REWARDED:
									
								$creatives = $this->fetch_rewarded_creatives($house_ad);
							//echo '<pre>'; print_r($creatives); exit();	
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	

									$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
									$this->add_link_ads($link_assoc_data);	
									$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);
									}
								}
						break;	

						case MOBILE_AD_BLOCK_PAUSE:
									
								$creatives = $this->fetch_pause_creatives($house_ad);
							//echo '<pre>'; print_r($creatives); exit();	
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	

									$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
									$this->add_link_ads($link_assoc_data);	
									$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);
									}
								}
						break;

						case MOBILE_AD_BLOCK_NATIVE_IMAGE:
									
								$creatives = $this->fetch_native_image_creatives($house_ad);
							//echo '<pre>'; print_r($creatives); exit();	
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	

									$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
									$this->add_link_ads($link_assoc_data);	
									$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);
									}
								}
						break;	

						case MOBILE_AD_BLOCK_DHTML:
									
								$creatives = $this->fetch_mob_dhtml_creatives($house_ad);
							//echo '<pre>'; print_r($creatives); exit();	
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	

									$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
									$this->add_link_ads($link_assoc_data);	
									$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);
									}
								}
						break;

						case MOBILE_AD_BLOCK_DHTML5:
									
								$creatives = $this->fetch_mob_dhtml5_creatives($house_ad);
							//echo '<pre>'; print_r($creatives); exit();	
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	

									$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
									$this->add_link_ads($link_assoc_data);	
									$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);
									}
								}
						break;
					

			}

		}

	}

	

	/*

	 * 

	 * name: fetch_image_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile image creative

	 */

	 function fetch_image_creatives($house_ad=FALSE,$cross=FALSE)

	 {

		$this->db->select('oxb.bannerid,oxb.campaignid');

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($house_ad){
		$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
		}
		if($this->agency_id)

		{
			$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		$this->db->where('oxb.storagetype', 'web');
		if($cross == 1)
		{
			$this->db->where_in('oxb.dj_banner_type', array(MOBILE_IMAGE_CREATIVE,WEB_CREATIVE_WEB));
		}
		else
		{
		$this->db->where('oxb.dj_banner_type', MOBILE_IMAGE_CREATIVE);
		}

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_interstitial_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile interstitial creative

	 */

	 function fetch_interstitial_creatives($house_ad=FALSE)

	 {
		$this->db->select('oxb.bannerid,oxb.campaignid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($house_ad){
		$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
		}
		
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		
		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_MRAID_CREATIVE_INTERSTITAL);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_expand_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile expand creative

	 */

	 function fetch_expand_creatives($house_ad=FALSE)

	 {
		$this->db->select('oxb.bannerid,oxb.campaignid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($house_ad){
		$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
		}
		
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_MRAID_CREATIVE_EXPAND);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');

		$result = $query->result_array(TAB_BANNERS.' as oxb');

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_reveal_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile reveal creative

	 */

	 function fetch_reveal_creatives($house_ad=FALSE)

	 {
		$this->db->select('oxb.bannerid,oxb.campaignid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($house_ad){
		$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
		}
		
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_MRAID_CREATIVE_REVEAL);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_flex_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile flex creative

	 */

	 function fetch_flex_creatives($house_ad=FALSE)

	 {
		$this->db->select('oxb.bannerid,oxb.campaignid');

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($house_ad){
		$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
		}
		
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_FLEX);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_adhension_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile adhension creative

	 */

	 function fetch_adhension_creatives($house_ad=FALSE)

	 {

		$this->db->select('oxb.bannerid,oxb.campaignid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($house_ad){
		$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
		}

		if($this->agency_id)

		{

			$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_ADHESION);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_filmstrip_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile filmstrip creative

	 */

	 function fetch_filmstrip_creatives($house_ad=FALSE)

	 {

		$this->db->select('oxb.bannerid,oxb.campaignid');

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($house_ad){
		$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
		}

		if($this->agency_id)

		{

			$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_FILMSTRIP);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_slider_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile slider creative

	 */

	 function fetch_slider_creatives($house_ad=FALSE)

	 {

		$this->db->select('oxb.bannerid,oxb.campaignid');

		

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		
		$this->db->where('oxcl.dj_is_deleted', '0');
		
		if($house_ad){
		$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
		}

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_SLIDER);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_pull_creatives

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile pull creative

	 */

	 function fetch_pull_creatives($house_ad=FALSE)

	 {

		$this->db->select('oxb.bannerid,oxb.campaignid');

		

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		if($house_ad){
		$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
		}

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_RS_CREATIVE_PULL);

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_text_creative

	 * @param :

	 * @return : $result

	 * 

	 * Get a text creative

	 */

	 function fetch_text_creatives($house_ad=FALSE,$cross=FALSE)

	 {

		$this->db->select('oxb.bannerid,oxb.campaignid');

		

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		
		$this->db->where('oxcl.dj_is_deleted', '0');
		
		if($house_ad){
		$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
		}

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		$this->db->where('oxb.storagetype', 'txt');
		if($cross == 1)
		{
			$this->db->where_in('oxb.dj_banner_type',array(MOBILE_TEXT_CREATIVE,WEB_CREATIVE_TEXT));
		}
		else
		{
		$this->db->where('oxb.dj_banner_type', MOBILE_TEXT_CREATIVE);
		}

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		//echo $this->db->last_query(); exit;	
		//log_message('error',$this->db->last_query());
		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	function add_link_ads($link_assoc_data)

	{

		if($link_assoc_data)

		{

			$this->db->trans_start();

			/*Insert in ox_banners */

			$this->db->insert(TAB_AD_ZONE_ASSOC,$link_assoc_data);

			

			$insert_id	= $this->db->insert_id();



			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)

			{

				$this->db->trans_rollback();

				return FALSE;

			}

			else

			{

				$this->db->trans_commit();

				return $insert_id;

			}

		}

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: unlink_ads

	 * @param : zone_id

	 * @return : $result

	 * 

	 * Delete the zone assoc

	 */

	 function unlink_ads($zone_id=false)

	 {

		if($zone_id)

		{

			$this->db->trans_start();

			

			$this->db->where('zone_id',$zone_id);

			$this->db->delete(TAB_AD_ZONE_ASSOC);



			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();

		}

		else

			return FALSE;

		

	}

	

	/*

	 * 

	 * name: unlink_blocks

	 * @param : creative_id

	 * @return : $result

	 * 

	 * Delete the zone assoc

	 */

	 function unlink_mobile_blocks($creative_id=false)

	 {

		if($creative_id)

		{

			$this->db->trans_start();

			

			$this->db->where('ad_id',$creative_id);

			$this->db->delete(TAB_AD_ZONE_ASSOC);



			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();

		}

		else

			return FALSE;

		

	}

	
	/*

	 * 

	 * name: unlink_mobile_blocks_placement

	 * @param : campaign_id

	 * @return : $result

	 * 

	 * Delete the zone assoc

	 */

	 function unlink_mobile_blocks_placement($campaign_id=false)

	 {

		if($campaign_id)

		{

			$this->db->trans_start();

			

			$this->db->where('placement_id',$campaign_id);

			$this->db->delete(TAB_PLACE_ZONE_ASSOC);



			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();

		}

		else

			return FALSE;

		

	}
	/*

	 * 

	 * name:link_adblocks

	 * @param : creative_id

	 * @return : NULL

	 * 

	 * Link creative to blocks

	 */

	

	function link_mobile_adblocks($creative_id=FALSE,$agency_id=FALSE,$is_house_ad=FALSE)

	{
		if($creative_id)

		{
			$this->agency_id= $agency_id;
			// Unlink the previously linked creatives for zone

			$this->unlink_mobile_blocks($creative_id);
			
			 /*Manual linking*/
			$link_type=$this->default_configurations->get('linking_type');
			
			//if($is_house_ad == 1)
			//{

			$creative_details = $this->fetch_creative($creative_id);

			$creative = $creative_details[0];

			$banner_type = $creative['dj_banner_type'];
			$campaignid 	= $creative['campaignid'];
			$this->unlink_mobile_blocks_placement($campaignid);
			switch($banner_type)

			{

				case MOBILE_IMAGE_CREATIVE:

								$adblocks = $this->fetch_image_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	

										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);

									}

								}

								break;

				case MOBILE_TEXT_CREATIVE:

								$adblocks = $this->fetch_text_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
									}

								}

								break;

				case MOBILE_MRAID_CREATIVE_INTERSTITAL:

								$adblocks = $this->fetch_interstitial_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{
										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);
									}

								}

								break;

				case MOBILE_MRAID_CREATIVE_EXPAND:

								$adblocks = $this->fetch_expand_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{
										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);
									}

								}

								break;

				case MOBILE_MRAID_CREATIVE_REVEAL:

								$adblocks = $this->fetch_reveal_adblocks();

								if($adblocks!=FALSE)
								{

									foreach($adblocks as $bl)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
									}

								}

								break;

				case MOBILE_RS_CREATIVE_FLEX:

								$adblocks = $this->fetch_flex_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);		

									}

								}

								break;

				case MOBILE_RS_CREATIVE_ADHESION:

								$adblocks = $this->fetch_adhension_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);	
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);

									}

								}

								break;

				case MOBILE_RS_CREATIVE_FILMSTRIP:

								$adblocks = $this->fetch_filmstrip_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	

									}

								}

								break;

				case MOBILE_RS_CREATIVE_PULL:

								$adblocks = $this->fetch_pull_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	

									}

								}

								break;

				case MOBILE_RS_CREATIVE_SLIDER:

								$adblocks = $this->fetch_slider_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	

									}

								}

								break;
								
					case MOBILE_VIDEO_CREATIVE_INTERSTITAL:
					
								$adblocks = $this->fetch_video_inter_adblocks();

								if($adblocks!=FALSE)

								{

									foreach($adblocks as $bl)

									{

										//UPDATE ZONE AND CREATIVE MAPPING	

										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);

										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	

									}

								}

								break;		

						case MOBILE_NATIVE_IMAGE_CREATIVE:

								$adblocks = $this->fetch_native_image_adblocks();
								//echo "<pre>"; print_r($adblocks); exit;
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
								break;		

						case MOBILE_HTML_CREATIVE:

								$adblocks = $this->fetch_mob_dhtml_adblocks();
								//echo "<pre>"; print_r($adblocks); exit;
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
					break;	

					case MOBILE_HTML5_CREATIVE:

								$adblocks = $this->fetch_mob_dhtml5_adblocks();
								//echo "<pre>"; print_r($adblocks); exit;
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
					break;	

				

			}

			//$this->response($zone);
		//}	

		}

	}

	

	/*

	 * 

	 * name: fetch_text_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a text blocks

	 */

	

	function fetch_text_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_TEXT);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_image_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a image blocks

	 */

	

	function fetch_image_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_IMAGE);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_interstitial_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a interstitial blocks

	 */

	

	function fetch_interstitial_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_INTERSTITIAL);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		$result = $query->result_array();
//echo $this->db->last_query(); exit;	
		if($result)

			return $result;

		else

			return FALSE;

	}

	 

	/*

	 * 

	 * name: fetch_expand_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a expand blocks

	 */

	

	function fetch_expand_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_EXPAND);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_reveal_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a reveal blocks

	 */

	

	function fetch_reveal_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_REVEAL);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_flex_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a flex blocks

	 */

	

	function fetch_flex_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_FLEX);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_adhension_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a adhension blocks

	 */

	

	function fetch_adhension_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_ADHESION);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_adhension_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a adhension blocks

	 */

	

	function fetch_filmstrip_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_FLIMSTRIP);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_slider_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a slider blocks

	 */

	

	function fetch_slider_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_SLIDER);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	

	/*

	 * 

	 * name: fetch_pull_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a pull blocks

	 */

	

	function fetch_pull_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_PULL);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	function fetch_interstital_video_creatives($house_ad=FALSE)

	 {

		$this->db->select('oxb.bannerid,oxb.campaignid');

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		//$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_VIDEO_CREATIVE_INTERSTITAL);

		$this->db->where('oxb.dj_is_deleted ','0');
		if($house_ad)
		{
			$this->db->where('oxcl.clientid ',1);
		}

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}
	function fetch_native_video_creatives($house_ad=FALSE)

	 {

		$this->db->select('oxb.bannerid,oxb.campaignid');

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		//$this->db->where('oxb.storagetype', 'web');

		$this->db->where('oxb.dj_banner_type', MOBILE_VIDEO_CREATIVE_NATIVE);

		$this->db->where('oxb.dj_is_deleted ','0');
		if($house_ad)
		{
			$this->db->where('oxcl.clientid ',1);
		}

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}
	function fetch_inline_creatives($house_ad=FALSE,$cross=FALSE)
	 {

		$this->db->select('oxb.bannerid,oxb.campaignid');

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		//$this->db->where('oxb.storagetype', 'web');
		if($cross == 1)
		{
		$this->db->where_in('oxb.dj_banner_type', array(MOBILE_VIDEO_CREATIVE_INLINE,VIDEO_CREATIVE_INLINE));	
	
		}
		else
		{
		$this->db->where('oxb.dj_banner_type', MOBILE_VIDEO_CREATIVE_INLINE);
		}

		$this->db->where('oxb.dj_is_deleted ','0');
		if($house_ad)
		{
			$this->db->where('oxcl.clientid ',1);
		}

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	function fetch_rewarded_creatives($house_ad=FALSE,$cross=FALSE)
	 {

		$this->db->select('oxb.bannerid,oxb.campaignid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		
		if($this->agency_id)
		{
				$this->db->where('oxcl.agencyid',$this->agency_id);
		}

		//$this->db->where('oxb.storagetype', 'web');
		if($cross == 1)
		{
			$this->db->where_in('oxb.dj_banner_type', array(MOBILE_VIDEO_CREATIVE_REWARDED));	
		}
		else
		{
			$this->db->where('oxb.dj_banner_type', MOBILE_VIDEO_CREATIVE_REWARDED);
		}

		$this->db->where('oxb.dj_is_deleted ','0');
		if($house_ad)
		{
			$this->db->where('oxcl.clientid ',1);
		}

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)
			return $result;
		else
			return FALSE;

	}

	function fetch_native_image_creatives($house_ad=FALSE,$cross=FALSE)
	{
		$this->db->select('oxb.bannerid,oxb.campaignid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		
		if($this->agency_id)
		{
				$this->db->where('oxcl.agencyid',$this->agency_id);
		}

		$this->db->where('oxb.dj_banner_type', MOBILE_NATIVE_IMAGE_CREATIVE);

		$this->db->where('oxb.dj_is_deleted ','0');
		if($house_ad)
		{
			$this->db->where('oxcl.clientid ',1);
		}

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)
			return $result;
		else
			return FALSE;
	}

	function fetch_mob_dhtml_creatives($house_ad=FALSE,$cross=FALSE)
	{
		$this->db->select('oxb.bannerid,oxb.campaignid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		
		if($this->agency_id)
		{
				$this->db->where('oxcl.agencyid',$this->agency_id);
		}

		$this->db->where('oxb.dj_banner_type', MOBILE_HTML_CREATIVE);

		$this->db->where('oxb.dj_is_deleted ','0');
		if($house_ad)
		{
			$this->db->where('oxcl.clientid ',1);
		}

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)
			return $result;
		else
			return FALSE;
	}

	function fetch_mob_dhtml5_creatives($house_ad=FALSE,$cross=FALSE)
	{
		$this->db->select('oxb.bannerid,oxb.campaignid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		
		if($this->agency_id)
		{
				$this->db->where('oxcl.agencyid',$this->agency_id);
		}

		$this->db->where('oxb.dj_banner_type', MOBILE_HTML5_CREATIVE);

		$this->db->where('oxb.dj_is_deleted ','0');
		if($house_ad)
		{
			$this->db->where('oxcl.clientid ',1);
		}

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)
			return $result;
		else
			return FALSE;
	}

	function fetch_pause_creatives($house_ad=FALSE,$cross=FALSE)
	{

		$this->db->select('oxb.bannerid,oxb.campaignid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		
		if($this->agency_id)
		{
				$this->db->where('oxcl.agencyid',$this->agency_id);
		}

		//$this->db->where('oxb.storagetype', 'web');
		if($cross == 1)
		{
			$this->db->where_in('oxb.dj_banner_type', array(MOBILE_VIDEO_CREATIVE_PAUSE));	
		}
		else
		{
			$this->db->where('oxb.dj_banner_type', MOBILE_VIDEO_CREATIVE_PAUSE);
		}

		$this->db->where('oxb.dj_is_deleted ','0');
		if($house_ad)
		{
			$this->db->where('oxcl.clientid ',1);
		}

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)
			return $result;
		else
			return FALSE;

	}

	function fetch_overlay_creatives($house_ad=FALSE,$cross=FALSE)

	 {

		$this->db->select('oxb.bannerid,oxb.campaignid');

		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');

		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		

		if($this->agency_id)

		{

				$this->db->where('oxcl.agencyid',$this->agency_id);

		}

		

		//$this->db->where('oxb.storagetype', 'web');
		if($cross==1)
		{
			$this->db->where_in('oxb.dj_banner_type',array(MOBILE_VIDEO_CREATIVE_OVERLAY,VIDEO_CREATIVE_OVERLAY));
		}
		else
		{
		$this->db->where('oxb.dj_banner_type', MOBILE_VIDEO_CREATIVE_OVERLAY);
		}

		$this->db->where('oxb.dj_is_deleted ','0');
		if($house_ad)
		{
			$this->db->where('oxcl.clientid ',1);
		}

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}
	/*

	 * 

	 * name: fetch_video_inter_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile video interstitial blocks

	 */

	

	function fetch_video_inter_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_INTERSTITIAL_VIDEO);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}

	function fetch_native_image_adblocks()
	{
		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_NATIVE_IMAGE);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;
	}

	function fetch_mob_dhtml_adblocks(){

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_DHTML);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;
	}

	function fetch_mob_dhtml5_adblocks(){

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_DHTML5);

		$this->db->where('oxz.dj_is_deleted ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;
	}


	 function unlink_ads_placement($zone_id=false)

	 {

		if($zone_id)

		{

			$this->db->trans_start();

			$this->db->select("zone_id");
			$this->db->where('zone_id',$zone_id);
			$query = $this->db->get(TAB_PLACE_ZONE_ASSOC);
			
				if($query->num_rows() > 0 ){
					$this->db->where('zone_id',$zone_id);

					$this->db->delete(TAB_PLACE_ZONE_ASSOC);



					if ($this->db->trans_status() === FALSE)

						$this->db->trans_rollback();

					else

						$this->db->trans_commit();

				}
				else
				return FALSE;
			}

		else

			return FALSE;

		

	}
	function add_link_ads_placement($link_assoc)

	{

		if($link_assoc)

		{

			$this->db->trans_start();

			$this->db->select("zone_id");
			$this->db->where($link_assoc);
			$query = $this->db->get(TAB_PLACE_ZONE_ASSOC);
			
				if($query->num_rows() <= 0 ){

			$this->db->insert(TAB_PLACE_ZONE_ASSOC,$link_assoc);

			

			$insert_id	= $this->db->insert_id();

			

			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)

			{

				$this->db->trans_rollback();

				return FALSE;

			}
		
		
			else

			{

				$this->db->trans_commit();

				return $insert_id;

			}
			}
			else

			return FALSE;

		}

		else

			return FALSE;

	}
}

