<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Do_linking extends CI_Model
{
	
	public $agency_id='';
	
	
	/*
	 * 
	 * name: fetch_adblock
	 * @param :
	 * @return : $result
	 * 
	 * Lists a ad blocks
	 */
	 
	 function fetch_adblock($zone_id=false)
	 {
		if($zone_id)
		{
			$this->db->select('width,height,delivery,dj_zone_type,rtb_type');		
			$this->db->where('zoneid ',$zone_id);
			$this->db->where('dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES);	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get Creatives
	 */
	 
	 function fetch_creative($creative_id=false)
	 {
		if($creative_id)
		{
			$this->db->select('width,height,dj_banner_type');		
			$this->db->where('bannerid ',$creative_id);
			$this->db->where('dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS);	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	function fetch_creative_details($campaign_id=false)
	{
		if($campaign_id)
		{
			$this->db->select('width,height,dj_banner_type');		
			$this->db->where_in('campaignid ',$campaign_id);
			$this->db->where('dj_is_deleted ','0');
			$this->db->where('dj_admin_approve', '1');
			$query = $this->db->get(TAB_BANNERS);
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
		{
			return FALSE;
		}	
	}
	
	/*
	 * 
	 * name: fetch_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get Creatives
	 */
	 
	 function fetch_campaign_creatives($campaign_id)
	 { 
		if($campaign_id)
		{
			$this->db->select('bannerid');		
			$this->db->where_in('campaignid ',$campaign_id);
			$this->db->where('dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS);	
			$result = $query->result_array();
			//echo $this->db->last_query();exit;
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	function fetch_campaings($ads,$type){
		
		//$aff = get_session('affiliate_id');
		//$affall = array($aff,'all');
		
		$val = -1;
		foreach($ads as $ad_ids)
		{$val++;
			$adid[] = $ads[$val]['bannerid'];
		}
		if($adid)
		{
			$this->db->distinct();
			
			$this->db->select('oxcamp.campaignid, oxcamp.campaignname,oxcl.clientid, oxcl.contact');
			
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			//$this->db->where_in('oxcamp.affiliate_id', $affall);
			
			if($type==1){
			$this->db->where('oxcamp.dj_is_rtb_campaign', '1');//extra code added by jayashree
			}else
			{
			$this->db->where('oxcamp.dj_is_rtb_campaign', '0');//extra code added by jayashree
			}
		
			$this->db->where_in('oxb.bannerid',$adid);
			
			$query = $this->db->get(TAB_BANNERS.' as oxb');
	
			$result = $query->result_array();
			//echo $this->db->last_query();exit;
			if($result)
			{
				return $result;
			}
			else
			{
				return FALSE;
			}
		}
		else
			return FALSE;
	}
	
	
	/*
	 * 
	 * name:link_ads_get
	 * @param : zone_id
	 * @return : NULL
	 * 
	 * Link zone to creative
	 */
	
	function link_ads($zone_id=false,$agencyid=false)
	{
		//If auto linking FALSE this will return;
		if($this->config->item('zone_ad_auto_link') != TRUE) return;
		
		if($zone_id)
		{
			
			//Sets the agency_id
			$this->agency_id = $agencyid;
			
			// Unlink the previously linked creatives for zone
			$this->unlink_ads($zone_id);
			
			$zone_details = $this->fetch_adblock($zone_id);
			$zone = $zone_details[0];
			//echo "<pre>"; print_r($zone); exit;
			$zone_type = $zone['dj_zone_type'];
			switch($zone_type)
			{
				case WEB_AD_BLOCK_BANNER:
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_web_creatives($where_web);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
									}
								}
								break;
				case WEB_AD_BLOCK_TEXT:
								$creatives = $this->fetch_text_creatives();
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
											
									}
								}
								break;
				case WEB_AD_BLOCK_DHTML:
								$where_dhtml = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_dhtml_creatives($where_dhtml);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									}
								}
								break;
				case VIDEO_AD_BLOCK_OVERLAY:
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_overlay_creatives($where_overlay);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									}
								}
								break;
				case VIDEO_AD_BLOCK_INLINE:
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_inline_creatives($where_inline);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									}
								}
								break;
				case MOBILE_AD_BLOCK_NATIVE_VIDEO:
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_native_creatives($where_inline);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
									}
								}
								break;
				
			}
			//$this->response($zone);
		}
	}
		
	/*
	 * 
	 * name: fetch_web_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a web creative
	 */
	 function fetch_web_creatives($where=false, $categories=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where_in('oxb.storagetype', array('web','sql','html','url'));
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_dhtml_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a web creative
	 */
	 function fetch_dhtml_creatives($where=false, $categories=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where_in('oxb.storagetype', array('web','sql','html','url'));
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}

	/*
	 * 
	 * name: fetch_text_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a text creative
	 */
	 function fetch_text_creatives($categories=FALSE)
	 {
		$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		if($categories)
		{
			$this->db->where_in('oxcamp.dj_category_id', $categories);
		}
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		$this->db->where('oxcl.dj_is_default', '0');
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		$this->db->where('oxb.dj_admin_approve', '1');
		$this->db->where('oxb.storagetype', 'txt');
		$this->db->where('oxb.dj_banner_type', WEB_CREATIVE_TEXT);
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	
	/*
	 * 
	 * name: fetch_campaign_text_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a text creative
	 */
	 function fetch_campaign_text_creatives($categories=FALSE, $campaign_id=FALSE,$cross = FALSE)
	 {
		// echo $cross;exit;
		$this->db->select('oxb.bannerid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->where_in('oxcamp.campaignid', $campaign_id);
		if($categories)
		{
			$this->db->where_in('oxcamp.dj_category_id', $categories);
		}
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		$this->db->where('oxcl.dj_is_default', '0');
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		$this->db->where('oxb.dj_admin_approve', '1');
		$this->db->where('oxb.storagetype', 'txt');
		if($cross)
		{
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_TEXT,MOBILE_TEXT_CREATIVE));
		}
		else
		{
		$this->db->where('oxb.dj_banner_type', WEB_CREATIVE_TEXT);
     	}
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		$result = $query->result_array();
		//echo $this->db->last_query();exit;
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_campaign_web_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a web creative
	 */
	 function fetch_campaign_web_creatives($where=false, $categories=FALSE, $campaign_id=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->where_in('oxcamp.campaignid', $campaign_id);
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where_in('oxb.storagetype', array('web','sql','html','url'));
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_campaign_dhtml_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a web creative
	 */
	 function fetch_campaign_dhtml_creatives($where=false, $categories=FALSE, $campaign_id=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->where_in('oxcamp.campaignid', $campaign_id);
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
				$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where_in('oxb.storagetype', array('web','sql','html','url'));
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_campaign_overlay_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay creative
	 */
	 function fetch_campaign_overlay_creatives($where=false, $categories=FALSE, $campaign_id=FALSE,$both=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->where_in('oxcamp.campaignid', $campaign_id);
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
				$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			//~ if($both == "")
			//~ {
			//~ $this->db->where($where);
			//~ }
			$this->db->where('oxb.storagetype', 'html');
			if($both)
			{
				$this->db->where_in('oxb.dj_banner_type', array(VIDEO_CREATIVE_OVERLAY,MOBILE_VIDEO_CREATIVE_OVERLAY));
			}
			else
			{
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_OVERLAY);
			}
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_campaign_inline_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline creative
	 */
	 function fetch_campaign_inline_creatives($where=false, $categories=FALSE, $campaign_id=FALSE,$both=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->where_in('oxcamp.campaignid', $campaign_id);
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
				$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			//~ if($both == "")
			//~ {
			//~ $this->db->where($where);
			//~ }
			$this->db->where('oxb.storagetype', 'html');
			if($both)
			{
				$this->db->where_in('oxb.dj_banner_type', array(VIDEO_CREATIVE_INLINE,MOBILE_VIDEO_CREATIVE_INLINE));
			}
			else
			{
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_INLINE);
			}
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_inline_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline creative
	 */
	 function fetch_inline_creatives($where=false, $categories=FALSE,$both=FALSE)
	 {
		
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			
			$this->db->where('oxb.dj_admin_approve', '1');
			//~ if($both == "")
			//~ {
			//~ $this->db->where($where);
			//~ }
			$this->db->where('oxb.storagetype', 'html');
			if($both)
			{
				$this->db->where_in('oxb.dj_banner_type', array(VIDEO_CREATIVE_INLINE,MOBILE_VIDEO_CREATIVE_INLINE));
			}
			else
			{
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_INLINE);
			}
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			// return $this->db->last_query(); 
		
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	 function fetch_native_creatives($where=false, $categories=FALSE,$both=FALSE)
	 {
		
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			
			$this->db->where('oxb.dj_admin_approve', '1');
			//~ if($both == "")
			//~ {
			//~ $this->db->where($where);
			//~ }
			$this->db->where('oxb.storagetype', 'html');
			if($both)
			{
				$this->db->where_in('oxb.dj_banner_type', array(MOBILE_VIDEO_CREATIVE_NATIVE));
			}
			else
			{
			$this->db->where('oxb.dj_banner_type', MOBILE_VIDEO_CREATIVE_NATIVE);
			}
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			// return $this->db->last_query(); 
		
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	 function fetch_mob_inline_creatives($where=false, $categories=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			//$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			$this->db->where('oxb.dj_banner_type', MOBILE_VIDEO_CREATIVE_INLINE);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	
	
	/*
	 * 
	 * name: fetch_overlay_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay creative
	 */
	 function fetch_overlay_creatives($where=false, $categories=FALSE,$both=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			//~ if($both == "")
			//~ {
			//~ $this->db->where($where);
			//~ }
			$this->db->where('oxb.storagetype', 'html');
			if($both)
			{
				$this->db->where_in('oxb.dj_banner_type', array(VIDEO_CREATIVE_OVERLAY,MOBILE_VIDEO_CREATIVE_OVERLAY));
			}
			else
			{
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_OVERLAY);
			}
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	function add_link_ads($link_assoc_data)
	{
		if($link_assoc_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banners */
			$this->db->insert(TAB_AD_ZONE_ASSOC,$link_assoc_data);
			
			$insert_id	= $this->db->insert_id();

			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $insert_id;
			}
		}
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: unlink_ads
	 * @param : zone_id
	 * @return : $result
	 * 
	 * Delete the zone assoc
	 */
	 function unlink_ads($zone_id=false)
	 {
		if($zone_id)
		{
			$this->db->trans_start();
			
			$this->db->where('zone_id',$zone_id);
			$this->db->delete(TAB_AD_ZONE_ASSOC);

			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();
			else
				$this->db->trans_commit();
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: unlink_blocks
	 * @param : creative_id
	 * @return : $result
	 * 
	 * Delete the zone assoc
	 */
	 function unlink_blocks($creative_id=false)
	 {
		if($creative_id)
		{
			$this->db->trans_start();
			
			$this->db->where('ad_id',$creative_id);
			$this->db->delete(TAB_AD_ZONE_ASSOC);

			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();
			else
				$this->db->trans_commit();
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name:link_adblocks
	 * @param : creative_id
	 * @return : NULL
	 * 
	 * Link creative to blocks
	 */
	
	function link_adblocks($creative_id=false,$agencyid=false)
	{
		//If auto linking FALSE this will return;
		if($this->config->item('zone_ad_auto_link') != TRUE) return;
		
		if($creative_id)
		{
			
			$this->agency_id = $agencyid;
			
			// Unlink the previously linked creatives for zone
			$this->unlink_blocks($creative_id);
			
			$creative_details = $this->fetch_creative($creative_id);
			$creative = $creative_details[0];
			//echo "<pre>"; print_r($zone); exit;
			$banner_type = $creative['dj_banner_type'];
			switch($banner_type)
			{
				case WEB_CREATIVE_WEB:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case WEB_CREATIVE_SQL:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case WEB_CREATIVE_SWF:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case WEB_CREATIVE_HTML:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case WEB_CREATIVE_URL:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case WEB_CREATIVE_TEXT:
								$adblocks = $this->fetch_text_adblocks();
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case VIDEO_CREATIVE_OVERLAY:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_overlay_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				case VIDEO_CREATIVE_INLINE:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_inline_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										
									}
								}
								break;
				
			}
			//$this->response($zone);
		}
	}
	
	/*
	 * 
	 * name: fetch_banner_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a web blocks
	 */
	 function fetch_banner_adblocks($where=false, $categories = FALSE)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid, oxz.zonename, oxa.name, oxa.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($categories)
			{
				$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
				$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', 's2c.site_id = s2z.site_id');
				$this->db->where_in('(s2c.category_id', $categories);
				$this->db->or_where('s2z.site_id NOT IN(SELECT DISTINCT site_id FROM ' . TAB_SITE_CAT_ASSOC . '))', NULL, FALSE);
			}
			$this->db->where('oxa.dj_approval_status', '1');
			$this->db->where('oxa.dj_is_denied', '0');
			$this->db->where('oxa.dj_is_deleted', '0');
			$this->db->where($where);
			$this->db->where_in('oxz.dj_zone_type', array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML));
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_text_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a text blocks
	 */
	
	function fetch_text_adblocks($categories = FALSE)
	{
		$this->db->select('oxz.zoneid, oxz.zonename, oxa.name, oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id){
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		if($categories)
		{
			$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
			$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', 's2c.site_id = s2z.site_id', 'LEFT');
			$this->db->where_in('(s2c.category_id', $categories);
			$this->db->or_where('s2z.site_id NOT IN(SELECT DISTINCT site_id FROM ' . TAB_SITE_CAT_ASSOC . '))', NULL, FALSE);
		}
		$this->db->where('oxa.dj_approval_status', '1');
		$this->db->where('oxa.dj_is_denied', '0');
		$this->db->where('oxa.dj_is_deleted', '0');
		$this->db->where_in('oxz.dj_zone_type', array(WEB_AD_BLOCK_TEXT));
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_overlay_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay blocks
	 */
	 function fetch_overlay_adblocks($where=false, $categories = FALSE)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid, oxz.zonename, oxa.name, oxa.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($categories)
			{
				$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
				$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', 's2c.site_id = s2z.site_id');
				$this->db->where_in('(s2c.category_id', $categories);
				$this->db->or_where('s2z.site_id NOT IN(SELECT DISTINCT site_id FROM ' . TAB_SITE_CAT_ASSOC . '))', NULL, FALSE);
			}
			$this->db->where('oxa.dj_approval_status', '1');
			$this->db->where('oxa.dj_is_denied', '0');
			$this->db->where('oxa.dj_is_deleted', '0');
			$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_OVERLAY);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_inline_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline blocks
	 */
	 function fetch_inline_adblocks($where=false, $categories = FALSE)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid, oxz.zonename, oxa.name, oxa.affiliateid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($categories)
			{
				$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
				$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', 's2c.site_id = s2z.site_id');
				$this->db->where_in('(s2c.category_id', $categories);
				$this->db->or_where('s2z.site_id NOT IN(SELECT DISTINCT site_id FROM ' . TAB_SITE_CAT_ASSOC . '))', NULL, FALSE);
			}
			$this->db->where('oxa.dj_approval_status', '1');
			$this->db->where('oxa.dj_is_denied', '0');
			$this->db->where('oxa.dj_is_deleted', '0');
			$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_INLINE);
			$this->db->where('oxz.dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_adblocks
	 * @param : creative_id
	 * @return : Adblocks
	 * 
	 * Fetch adblocks that matched with the creative 
	 */
	
	function fetch_adblocks($creative_id=false)
	{
		if($creative_id)
		{
			$this->agency_id 	= 	$agencyid;
			
			$creative_details 	=	$this->fetch_creative($creative_id);
			$creative 			=	$creative_details[0];
			$banner_type 		=	$creative['dj_banner_type'];
			$categories			=	$this->fetch_ads_categories($creative_id);
			
			//echo print_r($categories);exit;
			$linked_zones		=	$this->fetch_adblocks_linked($creative_id);
			
			switch($banner_type)
			{
				case WEB_CREATIVE_WEB:
				case WEB_CREATIVE_SQL:
				case WEB_CREATIVE_SWF:
				case WEB_CREATIVE_HTML:
				case WEB_CREATIVE_URL:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$result	=	$this->fetch_banner_adblocks($where_block);								
								break;
								
				case WEB_CREATIVE_TEXT:
								$result	=	$this->fetch_text_adblocks();
								break;
								
				case VIDEO_CREATIVE_OVERLAY:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$result	=	$this->fetch_overlay_adblocks($where_block);
								break;
								
				case VIDEO_CREATIVE_INLINE:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$result	=	$this->fetch_inline_adblocks($where_block);
								break;	
				
				case MOBILE_IMAGE_CREATIVE:
								$result = $this->fetch_image_adblocks();
								break;
								
				case MOBILE_TEXT_CREATIVE:
								$result = $this->fetch_mob_text_adblocks();		
								break;	
				
				case MOBILE_MRAID_CREATIVE_INTERSTITAL:
								$result = $this->fetch_interstitial_adblocks();	
								break;
								
				case MOBILE_MRAID_CREATIVE_EXPAND:
								$result = $this->fetch_expand_adblocks();
								break;
								
				case MOBILE_MRAID_CREATIVE_REVEAL:
								$result = $this->fetch_reveal_adblocks();
								break;	
								
				case MOBILE_RS_CREATIVE_FLEX:
								$result = $this->fetch_flex_adblocks();
								break;	
								
				case MOBILE_RS_CREATIVE_ADHESION:
								$result = $this->fetch_adhension_adblocks();
								break;
				
				case MOBILE_RS_CREATIVE_FILMSTRIP:
								$result = $this->fetch_filmstrip_adblocks();
								break;
								
				case MOBILE_RS_CREATIVE_PULL:
								$result = $this->fetch_pull_adblocks();
								break;
								
				case MOBILE_RS_CREATIVE_SLIDER:
								$result = $this->fetch_slider_adblocks();
								break;
				case MOBILE_VIDEO_CREATIVE_INLINE:
				$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$result	=	$this->fetch_mob_inline_creatives($where_block);
								break;	
				
				
			
				case MOBILE_RS_CREATIVE_SLIDER:
								$result = $this->fetch_slider_adblocks();
								break;				break;
												
			}
			
			
			foreach($result as $zone)
			{
				$ad_block[$zone['affiliateid']]['name'] 								=	$zone['name'];
				$ad_block[$zone['affiliateid']]['zones'][$zone['zoneid']]['name'] 		=	$zone['zonename'];
				$ad_block[$zone['affiliateid']]['zones'][$zone['zoneid']]['linked'] 	=	(is_array($linked_zones) && (in_array($zone['zoneid'], $linked_zones))) ? TRUE : FALSE;
			}
			
			$res = array();
			foreach($ad_block as $key => $value) 
			{
				$tmp		= array();
				foreach($value['zones'] as $zoneid => $zonename){
					$tmp[] 	= array('title' => $zonename['name'],
									'key' => $zoneid,
									'select' => $zonename['linked']);
				}
				
				$res[]		= array('title' 	=> $value['name'],
									'key'		=> $key,									
									'isFolder'	=> TRUE,
									'expand'	=> TRUE,
									'children'	=> $tmp);
			}
			
			
			return $res;
		}
	}
	
	/*
	 * 
	 * name: fetch_adblocks_linked
	 * @param : creative_id
	 * @return : Array
	 * 
	 * Return associated zone ids 
	 */
	
	function fetch_adblocks_linked($creative_id = FALSE)
	{
		if($creative_id)
		{
			$this->db->select('zone_id')->where('ad_id', $creative_id);
			$query 		=	$this->db->get(TAB_AD_ZONE_ASSOC)->result_array();
			$result		=	FALSE;
			foreach($query as $linked)
			{
				$result[]=	$linked['zone_id'];
			}
			return $result;
		}
	}
	
	/*
	 * 
	 * name: fetch_ads_linked
	 * @param : zone_id
	 * @return : Array
	 * 
	 * Return associated ads ids 
	 */
	
	function fetch_ads_linked($zone_id = FALSE,$campaign_id = FALSE)
	{
		if($zone_id && $campaign_id == FALSE)
		{
			$this->db->select('adzon.ad_id');
			$this->db->from(TAB_AD_ZONE_ASSOC.' as adzon');
			$this->db->join(TAB_BANNERS.' as ban','ban.bannerid = adzon.ad_id');
			$this->db->where('adzon.zone_id', $zone_id);
			$this->db->where('ban.exchange_id', 0);
			$query 		=	$this->db->get();
			$query 		=	$query->result_array();
			
			
			$result		=	FALSE;
			foreach($query as $linked)
			{
				$result[]=	$linked['ad_id'];
			}
		
			return $result;
		}
		else
		{
			$whe = array('zone_id'=>$zone_id, 'campaign_id'=>$campaign_id);
			$this->db->select('ad_id')->where($whe);
			$query 		=	$this->db->get(TAB_AD_ZONE_ASSOC)->result_array();
			$result		=	FALSE;
			foreach($query as $linked)
			{
				$result[]=	$linked['ad_id'];
			}
			return $result;
		}
	}
	
	/*
	 * 
	 * name: linked_process
	 * @param : creative_id, zone_ids
	 * @return : Array
	 * 
	 * Return associated zone ids 
	 */
	function linked_process($creative_id = FALSE, $zone_ids	= FALSE)
	{
		if($creative_id)
		{
			$update_ids		=	is_array($zone_ids) ? array_map('trim', $zone_ids) : array();
			$exist_ids		=	$this->fetch_adblocks_linked($creative_id);
			$temp_ids		=	$this->fetch_adblocks($creative_id);
			$possible_ids	= 	array();
			foreach($temp_ids as $pub)
			{
				foreach($pub['children'] as $zone)
				{
					$possible_ids[]	=	$zone['key'];
				}
			}
			
			$not_exists		=	array_diff($update_ids, $exist_ids);			
			$remove_ids		=	array_diff($exist_ids, $update_ids);
			
			$insert_ids		=	($exist_ids == FALSE) ? array_intersect($possible_ids, $update_ids) : array_intersect($possible_ids, $not_exists);
			
			//Updating Association Table
			$this->db->trans_start();
			
			$result			=	0;
			//Removing unchecked boxes from Association table
			/*if(is_array($remove_ids) && count($remove_ids) > 0)
			{
				$this->db->where('ad_id',$creative_id);
				$this->db->where_in('zone_id',$remove_ids);
				$this->db->delete(TAB_AD_ZONE_ASSOC);
				$result	   +=	1;
			}*/
			
			//Insert New entries
			if(is_array($insert_ids) && count($insert_ids) > 0)
			{
				foreach($insert_ids as $zone_id)
				{
					$this->db->insert(TAB_AD_ZONE_ASSOC, array('zone_id' =>	$zone_id, 'ad_id' => $creative_id));				
				}
				$result	   +=	2;
			}
			
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $result;
			}
		}
	}
	
	
	function link_campaigns($zone_id = FALSE, $campaign_ids = FALSE, $agency_id = FALSE)
	{
		if($zone_id)
		{
			//$creatives = $this->fetch_campaign_creatives($campaign_ids);
			$creatives = $this->fetch_campaign_ads($zone_id, $campaign_ids, $agency_id);
			 //~ return $creatives;


			$creative_ids = array_column($creatives, 'bannerid');
			 //~ return $creative_ids;
			$result = $this->linked_ads_process($zone_id, $creative_ids);
			return $result;
		}
	}
	      /*
	 * 
	 * name		: check_revenue_type
	 * @param 	: creative_id
	 * @return 	: Array
	 * 
	 * Returns campaign revenue types 
	 */
      function check_revenue_type($bannerid)
      {
		if($bannerid)
		{
			$this->db->select('oxcamp.revenue_type');
			$this->db->join(TAB_CAMPAIGNS . ' AS oxcamp', 'oxcamp.campaignid = oxb.campaignid');
			
			$this->db->where('oxb.bannerid', $bannerid);
			
			$result		=	$this->db->get(TAB_BANNERS . ' AS oxb')->result_array();
			if($result[0]['revenue_type']==5)
			{
				return 0;
		    }	
		    else
		    {
		        
				return 1;
		    }	
		}
		
	  }  
	
	/*
	 * 
	 * name		: linked_process
	 * @param 	: creative_id, zone_ids
	 * @return 	: Array
	 * 
	 * Returns linked status zones with ads 
	 */
	function linked_ads_process($zone_id = FALSE, $ads_ids	= FALSE, $campaign_id = FALSE)
	{
		
	// echo $zone_id."-".print_r($ads_ids)."-".$campaign_id;
		if($zone_id && $campaign_id == FALSE)
		{
			
			$update_ids		=	is_array($ads_ids) ? array_map('trim', $ads_ids) : array();
			
			$exist_ids		=	$this->fetch_ads_linked($zone_id);

			$temp_ids		=	$this->fetch_ads($zone_id);
			
			// print_r($temp_ids);die("++");
			
			$possible_ids	= 	array();

			foreach($temp_ids as $adv)
			{
				foreach($adv['children'] as $zone)
				{
					$possible_ids[]	=	$zone['key'];
				}
			}
		
// 		print_r($possible_ids);

// 		echo"<br>";
// print_r($update_ids);

// 		die("--");
			$not_exists		=	array_diff($update_ids, ($exist_ids)?$exist_ids:array());

			$remove_ids		=	array_diff(($exist_ids)?$exist_ids:array(), $update_ids);
			if($ads_ids==false)		//DAC 094
			{
				$remove_ids		=	array_intersect(($exist_ids)?$exist_ids:array(), $possible_ids);
			}
			
			$insert_ids		=	($exist_ids == FALSE) ? array_intersect($possible_ids, $update_ids) : array_intersect($possible_ids, $not_exists);
			

			if(count($insert_ids)>0)
			{
				$placement_ids  	=	$this->fetch_placement_id($zone_id,$insert_ids);  //Fetch campaign id for the particular creative id's
			
			}
			if(count($remove_ids)>0)
			{
					$placement_ids_remove  	=	$this->fetch_placement_id_remove($zone_id,$remove_ids);  //Fetch campaign id to remove for the particular creative id's
					
			}
		
			$unlink_campaigns_of_single_creative = $this->unlink_campaigns($zone_id,$placement_ids_remove);

			//Updating Association Table
			$this->db->trans_start();
			
			$result			=	0;
	
			//Removing unchecked boxes from Association table
			if(is_array($remove_ids) && count($remove_ids) > 0)
			{
				
				$this->db->select('cli.dj_is_default,zoa.ad_id,ba.campaignid,zoa.zone_id');
				$this->db->join('ox_banners ba', 'ba.bannerid = zoa.ad_id');
                $this->db->join('ox_campaigns as oxc', 'oxc.campaignid = ba.campaignid');
				$this->db->join('ox_clients as cli', 'cli.clientid = oxc.clientid');
				$this->db->where_in('ad_id',$remove_ids);
				$this->db->group_by('ad_id');
                $query = $this->db->get('ox_ad_zone_assoc as zoa');
				if($query->num_rows() > 0)
				{
					$res = $query->result_array(); 
					
					foreach($res as $linked)
					{
						
						if($linked['dj_is_default'] == '0')
						{
							$this->db->where('zone_id',$zone_id);
							$this->db->where('ad_id',$linked['ad_id']);
							$this->db->delete(TAB_AD_ZONE_ASSOC);
						}
					}
					$result	   +=	1;
				}					
				
			}

			// print_r($placement_ids);die("--");
	
			//Insert New entries
			if(is_array($insert_ids) && count($insert_ids) > 0)
			{
				foreach($insert_ids as $ad_id)
				{
					
				 $this->db->insert(TAB_AD_ZONE_ASSOC, array('zone_id' =>	$zone_id, 'ad_id' => $ad_id));
										
				}
				
				
					$SQL1 = "Select adz.ad_id,ban.campaignid  from ox_ad_zone_assoc as adz left join ox_banners as ban on adz.ad_id = ban.bannerid  where zone_id = $zone_id";
					$query = $this->db->query($SQL1);
					$res_camid = $query->result_array(); 
					foreach($res_camid as $camp_id)
					{
					$data=array('campaign_id'=>$camp_id['campaignid']);
					$this->db->where('ad_id',$camp_id['ad_id']);
					$this->db->update('ox_ad_zone_assoc',$data);
					}
					
					
				$result	   +=	1;
			}
			
			if(is_array($placement_ids) && count($placement_ids) > 0)
			{
				foreach($placement_ids as $camp_id)
				{
		 $SQL1 = " Select * from ox_placement_zone_assoc where placement_id = $camp_id and zone_id = $zone_id";
					$query = $this->db->query($SQL1);

					if ($query->num_rows() == 0) 
					{
					  $this->db->insert(TAB_PLACE_ZONE_ASSOC, array('zone_id' => $zone_id, 'placement_id' => $camp_id));
					 
					}
							  
					
				}
				
					$result	   +=	1;
			}
			
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $result;
			}
		}
		else
		{
			
				$update_ids		=	is_array($ads_ids) ? array_map('trim', $ads_ids) : array();

				$exist_ids		=	$this->fetch_ads_linked($zone_id,$campaign_id);

				$temp_ids		=	$this->fetch_ads($zone_id);

				$possible_ids	= 	array();

				foreach($temp_ids as $adv)
				{
				foreach($adv['children'] as $zone)
				{
				$possible_ids[]	=	$zone['key'];
				}
				}

				$not_exists		=	array_diff($update_ids, ($exist_ids)?$exist_ids:array());

				$remove_ids		=	array_diff(($exist_ids)?$exist_ids:array(), $update_ids);

				$insert_ids		=	($exist_ids == FALSE) ? array_intersect($possible_ids, $update_ids) : array_intersect($possible_ids, $not_exists);
				//print_r($possible_ids);exit;
				if(count($insert_ids)>0)
				{
				$placement_ids  	=	$this->fetch_placement_id($zone_id,$insert_ids);  //Fetch campaign id for the particular creative id's

				}
				if(count($remove_ids)>0)
				{
				$placement_ids_remove  	=	$this->fetch_placement_id_remove($zone_id,$remove_ids);  //Fetch campaign id to remove for the particular creative id's

				}

				$unlink_campaigns_of_single_creative = $this->unlink_campaigns($zone_id,$placement_ids_remove);

				//Updating Association Table
				$this->db->trans_start();

				$result			=	0;

				//Removing unchecked boxes from Association table
				if(is_array($remove_ids) && count($remove_ids) > 0)
				{
				$this->db->where('zone_id',$zone_id);
				$this->db->where_in('ad_id',$remove_ids);
				$this->db->delete(TAB_AD_ZONE_ASSOC);
				$result	   +=	1;
				}

				//Insert New entries
				if(is_array($insert_ids) && count($insert_ids) > 0)
				{
				foreach($insert_ids as $ad_id)
				{
				$this->db->insert(TAB_AD_ZONE_ASSOC, array('zone_id' =>	$zone_id, 'ad_id' => $ad_id,'campaign_id'=>$campaign_id));				
				}

				$result	   +=	1;
				}

				if(is_array($placement_ids) && count($placement_ids) > 0)
				{
				foreach($placement_ids as $camp_id)
				{
				$SQL1 = " Select * from ox_placement_zone_assoc where placement_id = $camp_id and zone_id = $zone_id";
				$query = $this->db->query($SQL1);

				if ($query->num_rows() == 0) 
				{
				$this->db->insert(TAB_PLACE_ZONE_ASSOC, array('zone_id' => $zone_id, 'placement_id' => $camp_id));

				}


				}

				$result	   +=	1;
				}

				$this->db->trans_complete();
				if ($this->db->trans_status() === FALSE)
				{
				$this->db->trans_rollback();
				return FALSE;
				}
				else
				{
				$this->db->trans_commit();
				return $result;
				}
		}
		
		
	}
		
		function link_zones($creative_id = FALSE)
	{
		if($creative_id)
		{
			$this->db->select('p2z.zone_id');
			$this->db->join(TAB_BANNERS . ' AS oxb', 'oxb.campaignid = p2z.placement_id');
			$this->db->where('oxb.bannerid', $creative_id);
			$result	=	$this->db->get(TAB_PLACE_ZONE_ASSOC . ' AS p2z')->result_array();
			
			if(!empty($result))
			{
				$zone_ids = FALSE;
				foreach($result AS $zones)
				{
					$zone_ids[]	=	$zones['zone_id'];
				}
				$this->linked_process($creative_id, $zone_ids);
			}
			else
			{
				return FALSE;
			}
		}
		return FALSE;
	}
		
		
		
		
		function fetch_placement_id($zone_id,$ad_idd)
 {
	 if($zone_id)
		{
	
			$this->db->select('b.campaignid');
			$this->db->where_in('b.bannerid', $ad_idd);
			$this->db->join(TAB_CAMPAIGNS.' as c','c.campaignid=b.campaignid');
			$this->db->join(TAB_CLIENTS.' as cl','cl.clientid = c.clientid');
			$this->db->where('cl.dj_is_default', '0');
		
			$query 		=	$this->db->get(TAB_BANNERS .' as b')->result_array();
	
			$ans		=	FALSE;
			foreach($query as $linked)
			{
				$ans[]=	$linked['campaignid'];
			}
			if($ans)
				{
					return $ans;
				}
			else
				{
					return FALSE;
				}
		}
 }
 
 //manual linking aprl 18
 function fetch_placement_id_remove($zone_id,$remove_ads)
 {
		if($zone_id)
		{
			$this->db->distinct();
			$this->db->select('b.campaignid');
			$this->db->where_in('b.bannerid', $remove_ads);
			$this->db->join(TAB_CAMPAIGNS.' as c','c.campaignid=b.campaignid');
			$this->db->join(TAB_CLIENTS.' as cl','cl.clientid = c.clientid');
			$this->db->where('cl.dj_is_default', '0');
			$query 		=	$this->db->get(TAB_BANNERS .' as b')->result_array();
	
			$ans		=	FALSE;
			foreach($query as $linked)
			{
				$ans[]=	$linked['campaignid'];
			}
			if($ans)
				{
					return $ans;
				}
			else
				{
					return FALSE;
				}
		}
 }
		
		
		
		
	/*
	 * 
	 * name: fetch_ads
	 * @param : zone_id
	 * @return : Array
	 * 
	 * Returns array of banners
	 */
	
	function fetch_ads($zone_id=false,$agencyid=false)
	{
		if($zone_id)
		{
			//Sets the agency_id
			$this->agency_id 	=	$agencyid;
			
			$zone_details 		= 	$this->fetch_adblock($zone_id);
			$zone 				=	$zone_details[0];
			
			$zone_type 			=	$zone['dj_zone_type'];
			$categories			=	$this->fetch_zones_categories($zone_id);
			$linked_ads			=	$this->fetch_ads_linked($zone_id);
			// echo $zone_type;exit("2344");
			switch($zone_type)
			{
				case WEB_AD_BLOCK_BANNER:
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_web_creatives($where_web, $categories);	
								break;
								
				case CROSS_AD_BLOCK_BANNER:
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_both_bann_creatives($where_web, $categories);
								//$campaings = $this->fetch_campaings($creatives);	
								break;
								
				case CROSS_AD_BLOCK_TEXT:
				$creatives = $this->fetch_both_text_creatives($categories);
			//	$campaings = $this->fetch_campaings($creatives);
				break;
				case WEB_AD_BLOCK_TEXT:
				
								$creatives = $this->fetch_text_creatives($categories);
								break;
				case WEB_AD_BLOCK_DHTML:
								$where_dhtml = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_dhtml_creatives($where_dhtml, $categories);
								break;
				case VIDEO_AD_BLOCK_OVERLAY:
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_overlay_creatives($where_overlay, $categories);
								break;
				case CROSS_AD_BLOCK_OVERLAY:
				$both = 1;
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_overlay_creatives($where_overlay, $categories,$both);
								break;
				case VIDEO_AD_BLOCK_INLINE:
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_inline_creatives($where_inline, $categories);
								break;
				case CROSS_AD_BLOCK_INLINE:
				$both= 1;
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_inline_creatives($where_inline, $categories,$both);
								break;
								
				case  MOBILE_AD_BLOCK_IMAGE:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_IMAGE_CREATIVE, $categories);
		                    
					     		break;
				case  MOBILE_AD_BLOCK_TEXT:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_TEXT_CREATIVE, $categories);
		                    
					     		break;	     						
		        case MOBILE_AD_BLOCK_INTERSTITIAL:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_MRAID_CREATIVE_INTERSTITAL, $categories);
		                    
								break;
								
		        case MOBILE_AD_BLOCK_EXPAND:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_MRAID_CREATIVE_EXPAND, $categories);
		                     
								break;
			    				
		        case MOBILE_AD_BLOCK_REVEAL:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_MRAID_CREATIVE_REVEAL, $categories);
		                      
								break;
								
		        case MOBILE_AD_BLOCK_FLEX:
		       
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_RS_CREATIVE_FLEX, $categories);
		                   
								break;	
			     case MOBILE_AD_BLOCK_ADHESION:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_RS_CREATIVE_ADHESION, $categories);

								break;	
				 case MOBILE_AD_BLOCK_FLIMSTRIP:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_RS_CREATIVE_FILMSTRIP, $categories);
		                     
								break;	
				 case MOBILE_AD_BLOCK_SLIDER:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_RS_CREATIVE_SLIDER, $categories);
		                    
								break;
			     case MOBILE_AD_BLOCK_PULL:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_RS_CREATIVE_PULL, $categories);
		                     
								break;		
				 case MOBILE_AD_BLOCK_INLINE:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_VIDEO_CREATIVE_INLINE, $categories);
		                     
								break;		
				 case MOBILE_AD_BLOCK_OVERLAY:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_VIDEO_CREATIVE_OVERLAY, $categories);
								break;	
				 case MOBILE_AD_BLOCK_INTERSTITIAL_VIDEO:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_VIDEO_CREATIVE_INTERSTITAL, $categories);
								break;
				 case MOBILE_AD_BLOCK_NATIVE_VIDEO:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_VIDEO_CREATIVE_NATIVE, $categories);
								break;		
				case MOBILE_AD_BLOCK_PAUSE:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_VIDEO_CREATIVE_PAUSE, $categories);
								break;		
				case MOBILE_AD_BLOCK_DHTML:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_HTML_CREATIVE, $categories);
								break;	
				case MOBILE_AD_BLOCK_DHTML5:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_HTML5_CREATIVE, $categories);
								break;			
			}
			
			foreach($creatives as $ads)
			{
				$ad_block[$ads['clientid']]['name'] 							=	$ads['contact'];
				$ad_block[$ads['clientid']]['ads'][$ads['bannerid']]['name'] 	=	$ads['description'];
				$ad_block[$ads['clientid']]['ads'][$ads['bannerid']]['linked'] 	=	(is_array($linked_ads) && (in_array($ads['bannerid'], $linked_ads))) ? TRUE : FALSE;
			}
			
			$res = array();
			foreach($ad_block as $key => $value) 
			{		
				$tmp		= array();		
				foreach($value['ads'] as $ad_id => 	$ads){
					$tmp[] 	= array('title' 	=>	$ads['name'],
									'key' 		=>	$ad_id,
									'select' 	=>	$ads['linked']);
				}
				
				$res[]		= array('title' 	=> $value['name'],
									'key'		=> $key,									
									'isFolder'	=> TRUE,
									'expand'	=> TRUE,
									'children'	=> $tmp);
			}
					
			return $res;
		}
	}
	
	
	/*
	 * 
	 * name: fetch_ads
	 * @param : zone_id
	 * @return : Array
	 * 
	 * Returns array of banners
	 */
	
	function fetch_campaign_ads($zone_id=false, $campaign_id=false, $agencyid=false)
	{
		if($zone_id)
		{
			//Sets the agency_id
			$this->agency_id 	=	$agencyid;
			
			$zone_details 		= 	$this->fetch_adblock($zone_id);
			$zone 				=	$zone_details[0];
			
			$zone_type 			=	$zone['dj_zone_type'];
			$categories			=	$this->fetch_zones_categories($zone_id);
			$linked_ads			=	$this->fetch_ads_linked($zone_id);
			
			//echo $zone_type;exit;
			switch($zone_type)
			{
				case WEB_AD_BLOCK_BANNER:
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_campaign_web_creatives($where_web, $categories, $campaign_id);
								break;
				case CROSS_AD_BLOCK_BANNER:
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_both_creatives($where_web, $categories, $campaign_id);
								//$campaings = $this->fetch_campaings($creatives);	
								break;
								
				case CROSS_AD_BLOCK_TEXT:
				$cross = 1;
				$creatives = $this->fetch_campaign_text_creatives($categories,$campaign_id,$cross);
			//	$campaings = $this->fetch_campaings($creatives);
				break;
				case WEB_AD_BLOCK_TEXT:
								$creatives = $this->fetch_campaign_text_creatives($categories, $campaign_id);
								break;
				case WEB_AD_BLOCK_DHTML:
								$where_dhtml = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_campaign_dhtml_creatives($where_dhtml, $categories, $campaign_id);
								break;
				case VIDEO_AD_BLOCK_OVERLAY:
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_campaign_overlay_creatives($where_overlay, $categories, $campaign_id);
								break;
				case CROSS_AD_BLOCK_OVERLAY:
								$both =1;
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_campaign_overlay_creatives($where_overlay, $categories, $campaign_id,$both);
								break;
							
				case VIDEO_AD_BLOCK_INLINE:
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_campaign_inline_creatives($where_inline, $categories,$campaign_id);
								break;
				case CROSS_AD_BLOCK_INLINE:
								$both = 1;
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_campaign_inline_creatives($where_inline, $categories,$campaign_id,$both);
								break;
				case  MOBILE_AD_BLOCK_IMAGE:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_IMAGE_CREATIVE, $categories, $campaign_id);
		                    
					     		break;
				case  MOBILE_AD_BLOCK_TEXT:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_TEXT_CREATIVE, $categories, $campaign_id);
					     		break;	     						
		        case MOBILE_AD_BLOCK_INTERSTITIAL:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_MRAID_CREATIVE_INTERSTITAL, $categories, $campaign_id);
		                    
								break;
								
		        case MOBILE_AD_BLOCK_EXPAND:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_MRAID_CREATIVE_EXPAND, $categories, $campaign_id);
		                     
								break;
			    				
		        case MOBILE_AD_BLOCK_REVEAL:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_MRAID_CREATIVE_REVEAL, $categories, $campaign_id);
		                      
								break;
								
		        case MOBILE_AD_BLOCK_FLEX:
		       
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_RS_CREATIVE_FLEX, $categories, $campaign_id);
		                   
								break;	
			     case MOBILE_AD_BLOCK_ADHESION:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_RS_CREATIVE_ADHESION, $categories, $campaign_id);

								break;	
				 case MOBILE_AD_BLOCK_FLIMSTRIP:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_RS_CREATIVE_FILMSTRIP, $categories, $campaign_id);
		                     
								break;	
				 case MOBILE_AD_BLOCK_SLIDER:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_RS_CREATIVE_SLIDER, $categories, $campaign_id);
		                    
								break;
			     case MOBILE_AD_BLOCK_PULL:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_RS_CREATIVE_PULL, $categories, $campaign_id);
		                     
								break;		
				 case MOBILE_AD_BLOCK_INLINE:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_VIDEO_CREATIVE_INLINE, $categories, $campaign_id);
		                     
								break;
				 case MOBILE_AD_BLOCK_OVERLAY:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_VIDEO_CREATIVE_OVERLAY, $categories, $campaign_id);
		                     
								break;
				 case MOBILE_AD_BLOCK_INTERSTITIAL_VIDEO:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_VIDEO_CREATIVE_INTERSTITAL, $categories, $campaign_id);
		                     
								break;
				case MOBILE_AD_BLOCK_NATIVE_VIDEO:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_VIDEO_CREATIVE_NATIVE, $categories, $campaign_id);
		                     
								break;

				case MOBILE_AD_BLOCK_PAUSE:
							 
		                       $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_VIDEO_CREATIVE_PAUSE, $categories, $campaign_id);
							  break;

				case MOBILE_AD_BLOCK_REWARDED:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_VIDEO_CREATIVE_REWARDED, $categories, $campaign_id);
		                     
								break;
				case MOBILE_AD_BLOCK_DHTML:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_HTML_CREATIVE, $categories, $campaign_id);
		                     
								break;
				case MOBILE_AD_BLOCK_NATIVE_IMAGE:
							$creatives = $this->fetch_campaign_mobile_creatives(MOBILE_NATIVE_IMAGE_CREATIVE, $categories, $campaign_id);
							  break;
				case MOBILE_AD_BLOCK_DHTML5:
		                      $creatives = $this->fetch_campaign_mobile_creatives(MOBILE_HTML5_CREATIVE, $categories, $campaign_id);
		                     
								break;
			}
			return $creatives;
		}
	}
	
	
	/*
	 * 
	 * name: fetch_ads_campaigns
	 * @param : zone_id
	 * @return : Array
	 * 
	 * Returns array of banners
	 */
	
	function fetch_ads_campaigns($zone_id=false,$agencyid=false)
	{
		
		if($zone_id)
		{
		
			//Sets the agency_id
			$this->agency_id 	=	$agencyid;
			
			$zone_details 		= 	$this->fetch_adblock($zone_id);
			$zone 				=	$zone_details[0];
			
			$zone_type 			=	$zone['dj_zone_type'];
			$categories			=	$this->fetch_zones_categories($zone_id);
			
			$linked_ads			=	$this->fetch_linked_campaigns($zone_id);
			//~ return ($categories);
			switch($zone_type)
			{
				case WEB_AD_BLOCK_BANNER:
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
											
								$creatives = $this->fetch_web_creatives($where_web, $categories);
								
								$campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);	
								
								break;
				case CROSS_AD_BLOCK_BANNER:
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_both_bann_creatives($where_web, $categories);
								$campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);	
								break;
								
				case CROSS_AD_BLOCK_TEXT:
				$creatives = $this->fetch_both_text_creatives($categories);
				$campaings = $this->fetch_campaings($creatives);
				break;
				case WEB_AD_BLOCK_TEXT:
								$creatives = $this->fetch_text_creatives($categories);
								$campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;
				case WEB_AD_BLOCK_DHTML:
								$where_dhtml = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_dhtml_creatives($where_dhtml, $categories);
								$campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;
				case VIDEO_AD_BLOCK_OVERLAY:
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_overlay_creatives($where_overlay, $categories);
								$campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;
				case CROSS_AD_BLOCK_OVERLAY:
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_both_overlay_creatives($where_overlay, $categories);
								$campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;
				case VIDEO_AD_BLOCK_INLINE:
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_inline_creatives($where_inline, $categories);
							
								$campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;
				case CROSS_AD_BLOCK_INLINE:
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_both_inline_creatives($where_inline, $categories);
								$campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;
				case  MOBILE_AD_BLOCK_IMAGE:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_IMAGE_CREATIVE, $categories);
							  $campaings = $this->fetch_campaings($creatives);
					     		break;
				case  MOBILE_AD_BLOCK_TEXT:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_TEXT_CREATIVE, $categories);
							  $campaings = $this->fetch_campaings($creatives ,$zone['rtb_type']);
					     		break;	     						
		        case MOBILE_AD_BLOCK_INTERSTITIAL:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_MRAID_CREATIVE_INTERSTITAL, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;
								
		        case MOBILE_AD_BLOCK_EXPAND:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_MRAID_CREATIVE_EXPAND, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;
			    				
		        case MOBILE_AD_BLOCK_REVEAL:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_MRAID_CREATIVE_REVEAL, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;
								
		        case MOBILE_AD_BLOCK_FLEX:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_RS_CREATIVE_FLEX, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;	
			     case MOBILE_AD_BLOCK_ADHESION:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_RS_CREATIVE_ADHESION, $categories);
							  $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;	
				 case MOBILE_AD_BLOCK_FLIMSTRIP:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_RS_CREATIVE_FILMSTRIP, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;	
				 case MOBILE_AD_BLOCK_SLIDER:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_RS_CREATIVE_SLIDER, $categories);
							  $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;
			     case MOBILE_AD_BLOCK_PULL:
		                      $creatives = $this->fetch_mobile_creatives(MOBILE_RS_CREATIVE_PULL, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;	
				 case MOBILE_AD_BLOCK_INLINE:
							  $creatives = $this->fetch_mobile_creatives(MOBILE_VIDEO_CREATIVE_INLINE, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;	
				 case MOBILE_AD_BLOCK_OVERLAY:
							  $creatives = $this->fetch_mobile_creatives(MOBILE_VIDEO_CREATIVE_OVERLAY, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;	
				case MOBILE_AD_BLOCK_INTERSTITIAL_VIDEO:
							  $creatives = $this->fetch_mobile_creatives(MOBILE_VIDEO_CREATIVE_INTERSTITAL, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;
				case MOBILE_AD_BLOCK_NATIVE_VIDEO:
							  $creatives = $this->fetch_mobile_creatives(MOBILE_VIDEO_CREATIVE_NATIVE, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
								break;
				case MOBILE_AD_BLOCK_PAUSE:
							  $creatives = $this->fetch_mobile_creatives(MOBILE_VIDEO_CREATIVE_PAUSE, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
							  break;
				case MOBILE_AD_BLOCK_REWARDED:
							  $creatives = $this->fetch_mobile_creatives(MOBILE_VIDEO_CREATIVE_REWARDED, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
							  break;
				case MOBILE_AD_BLOCK_DHTML:
							  $creatives = $this->fetch_mobile_creatives(MOBILE_HTML_CREATIVE, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
							  break;
				case MOBILE_AD_BLOCK_NATIVE_IMAGE:
							  $creatives = $this->fetch_mobile_creatives(MOBILE_NATIVE_IMAGE_CREATIVE, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
							  break;
				case MOBILE_AD_BLOCK_DHTML5:
							  $creatives = $this->fetch_mobile_creatives(MOBILE_HTML5_CREATIVE, $categories);
		                      $campaings = $this->fetch_campaings($creatives,$zone['rtb_type']);
							  break;
							  											
										
			}
			
			foreach($campaings as $ads)
			{
				$ad_block[$ads['clientid']]['name'] 							=	$ads['contact'];
				$ad_block[$ads['clientid']]['ads'][$ads['campaignid']]['name'] 	=	$ads['campaignname'];
				$ad_block[$ads['clientid']]['ads'][$ads['campaignid']]['linked'] 	=	(is_array($linked_ads) && (in_array($ads['campaignid'], $linked_ads))) ? TRUE : FALSE;
			}
			
			$res = array();
			foreach($ad_block as $key => $value) 
			{		
				$tmp		= array();		
				foreach($value['ads'] as $ad_id => 	$ads){
					$tmp[] 	= array('title' 	=>	$ads['name'],
									'key' 		=>	$ad_id,
									'select' 	=>	$ads['linked']);
				}
				
				$res[]		= array('title' 	=> $value['name'],
									'key'		=> $key,									
									'isFolder'	=> TRUE,
									'expand'	=> TRUE,
									'children'	=> $tmp);
			}
					
			return $res;
		}
	}
	
	/*
	 * 
	 * name: fetch_zones_categories
	 * @param : zone_id
	 * @return : Array
	 * 
	 * Returns Parent Categories
	 */
	function fetch_zones_categories($zone_id = FALSE)
	{
		if($zone_id)
		{
			$this->db->select('s2z.zone_id, sc.value, sc.parent_category_id');			
			$this->db->join(TAB_SITE_CAT_ASSOC . ' AS s2c', "s2c.site_id=s2z.site_id");	
			$this->db->join(TAB_SITE_CATEGORIES . ' AS sc', "sc.value = s2c.category_id");		
			$this->db->where('s2z.zone_id', $zone_id);
			$this->db->where('sc.is_deleted', '0');
			$result		=	$this->db->get(TAB_SITE_ZONE_ASSOC . ' AS s2z')->result_array();

			if($result)
			{
				$categories		=	FALSE;
				foreach($result as $cat)
				{
					$categories[]	=	$cat['parent_category_id'];
				}
				return $categories;
			}
			else 
			{
				return FALSE;
			}
		}
		else
		{
			return FALSE;
		}
	}
	
	/*
	 * 
	 * name: fetch_ads_categories
	 * @param : creative_id
	 * @return : Array
	 * 
	 * Returns Categories
	 */
	function fetch_ads_categories($creative_id = FALSE)
	{
		if($creative_id)
		{
			$this->db->select('sc.value');
			$this->db->join(TAB_CAMPAIGNS . ' AS oxcamp', 'oxcamp.campaignid = oxb.campaignid');
			$this->db->join(TAB_SITE_CATEGORIES . ' AS sc', 'sc.parent_category_id = oxcamp.dj_category_id');
			$this->db->where('oxb.bannerid', $creative_id);
			$result		=	$this->db->get(TAB_BANNERS . ' AS oxb')->result_array();
			if($result)
			{
				$categories		=	FALSE;
				foreach($result as $cat)
				{
					$categories[]	=	$cat['value'];
				}
				return $categories;
			}
			else 
			{
				return FALSE;
			}
		}
		else
		{
			return FALSE;
		}
	}
	
	
	function fetch_campaign_type($campaign_id = FALSE)
{
        $camp_type = FALSE;
		if($campaign_id)
		{

			
				
						$this->db->select('oxcmp.dj_targetting_type');
						$this->db->where('oxcmp.campaignid', $campaign_id);	
						$query=$this->db->get(TAB_CAMPAIGNS . ' AS oxcmp');
						$camp_type = $query->result_array();
						return $camp_type;

 

		}

}

	
	
	
	
	/*
	 * 
	 * name: fetch_campaign_adblocks
	 * @param : campaign_id
	 * @return : Array
	 * 
	 * Returns Adblocks
	 */
	function fetch_campaign_adblocks($campaign_id = FALSE,$agency_id= FALSE)
	{
					$campaign_type  =   $this->fetch_campaign_type($campaign_id);
					$camp_type      =   $campaign_type[0]['dj_targetting_type'];
					$linked_zones	=	$this->fetch_campaigns_linked($campaign_id);
					$camp_category  =   $this->fetch_campaign_category($campaign_id);
					
					//category matching => Manual Linking 
					$result			=	$this->fetch_all_adblocks($agency_id,$camp_category,$camp_type);
		//print_r($result);exit;
	foreach($result as $zone)
		{
			$ad_block[$zone['site_id']]['name'] 							=	$zone['name'] . ' - ' . $zone['site_name'] . ' (<u>' . $zone['site_url'] . '</u>)';
			$ad_block[$zone['site_id']]['zones'][$zone['zoneid']]['name'] 	=	$zone['zonename'];
			$ad_block[$zone['site_id']]['zones'][$zone['zoneid']]['linked'] =	(is_array($linked_zones) && (in_array($zone['zoneid'], $linked_zones))) ? TRUE : FALSE;
		}
		
		$res = array();
		foreach($ad_block as $key => $value) 
		{
			$tmp		= array();
			foreach($value['zones'] as $zoneid 	=>	$zonename){
				$tmp[] 	= array('title' 		=>	$zonename['name'],
								'key' 			=>	$zoneid,
								'select' 		=>	$zonename['linked']);
			}
			
			$res[]		= array('title' 		=>	$value['name'],
								'key'			=>	$key,									
								'isFolder'		=>	TRUE,
								'expand'		=>	TRUE,
								'children'		=>	$tmp);
		}
		return $res;
	}
	
	/*
	 * 
	 * name: fetch_adblocks_campaign
	 * @param : campaign_id
	 * @return : Array
	 * 
	 * Returns Adblocks
	 */
	function fetch_adblocks_campaign($campaign_id = FALSE,$agency_id= FALSE)
	{
		
					$campaign_type  =   $this->fetch_campaign_type($campaign_id);
					$camp_type      =   $campaign_type[0]['dj_targetting_type'];
					$linked_zones	=	$this->fetch_campaigns_linked($campaign_id);
					$camp_category  =   $this->fetch_campaign_category($campaign_id);
					$get_camp_category_id  =   $this->fetch_camp_category_id($campaign_id);//print_r($get_camp_category_id);exit;
					$creative_detail = 	$this->fetch_creative_details($campaign_id);
					
					//category matching => Manual Linking 
					if($creative_detail)
					{
					$result = $this->fetch_adblocks_creatives($creative_detail,$camp_type,$agency_id);
					}
					else
					{
						$result = "";
					}
					
	foreach($result as $zone)
		{
			$campaign_category=explode(',',$zone['parent_category']);
			$cat_result=false;		
			if (in_array("$get_camp_category_id", $campaign_category))
			{
				$cat_result=true;
			}
			 
			if($zone['parent_category']=='' || $zone['parent_category']==null || $cat_result==true)
			{				
				$ad_block[$zone['site_id']]['name'] 							=	$zone['name'] . ' - ' . $zone['site_name'] . ' (<u>' . $zone['site_url'] . '</u>)';
				$ad_block[$zone['site_id']]['zones'][$zone['zoneid']]['name'] 	=	$zone['zonename'];
				$ad_block[$zone['site_id']]['zones'][$zone['zoneid']]['linked'] =	(is_array($linked_zones) && (in_array($zone['zoneid'], $linked_zones))) ? TRUE : FALSE;
			}			
		}
		
		$res = array();
		foreach($ad_block as $key => $value) 
		{
			$tmp		= array();
			foreach($value['zones'] as $zoneid 	=>	$zonename){
				$tmp[] 	= array('title' 		=>	$zonename['name'],
								'key' 			=>	$zoneid,
								'select' 		=>	$zonename['linked']);
			}
			
			$res[]		= array('title' 		=>	$value['name'],
								'key'			=>	$key,									
								'isFolder'		=>	TRUE,
								'expand'		=>	TRUE,
								'children'		=>	$tmp);
		}
		return $res;
	}
	
	function fetch_mobile_creatives($creative_type=FALSE,$categories=FALSE)
	 {
		if($creative_type)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			$this->db->where('oxcl.dj_is_default', '0');
			
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where('oxb.dj_banner_type', $creative_type);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query();exit;
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		  }
		 else
			return FALSE;
	}
	
	function fetch_campaign_mobile_creatives($creative_type=FALSE,$categories=FALSE, $campaign_id=FALSE)
	 {
		if($creative_type)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->where_in('oxcamp.campaignid', $campaign_id);
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			$this->db->where('oxcl.dj_is_default', '0');
			
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			$this->db->where('oxb.dj_banner_type', $creative_type);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			// echo $this->db->last_query();exit;
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		  }
		 else
			return FALSE;
	}
	
	function fetch_campaign_category($campaign_id = FALSE) //category matching => Manual Linking 
	{

		if($campaign_id)
		{
			
						$this->db->select('ps.site_id,sc.category_id,sz.zone_id,dsc.value,dsc.parent_category_id,oxcmp.dj_targetting_type');
						$this->db->join(TAB_SITE_CAT_ASSOC . ' AS sc', 'sc.site_id= ps.site_id');
						$this->db->join(TAB_SITE_ZONE_ASSOC  . ' AS sz', 'sz.site_id= sc.site_id');
						$this->db->join(TAB_SITE_CATEGORIES . ' AS dsc', 'dsc.value = sc.category_id');
						$this->db->join(TAB_CAMPAIGNS . ' AS oxcmp', 'oxcmp.dj_category_id=dsc.parent_category_id');
						$this->db->where('oxcmp.campaignid', $campaign_id);
						$this->db->where('dsc.is_deleted', 0);
						$this->db->where('dsc.is_blocked', 0);
						$result		=	$this->db->get(TAB_PUB_SITES . ' AS ps')->result_array();

					if($result)
					{

											$categories		=	FALSE;

											foreach($result as $cat)
											{
												$categories[]	=	$cat['value'];
											}

												return $categories;
					}
					else 
					{
												return FALSE;
					}


		}
		else
		{
					return FALSE;
		}

    }

	 
	/*
	 * 
	 * name: fetch_adblock
	 * @param :
	 * @return : $result
	 * 
	 * Lists a ad blocks
	 */
	function fetch_all_adblocks($agency_id=FALSE,$categories=FALSE,$camp_type=FALSE) //Manual Linking
	{
		$this->db->select('oxz.zoneid, oxz.zonename, oxz.affiliateid, oxa.name, oxs.site_name, oxs.site_id, oxs.site_url');		
		$this->db->where(array('oxz.dj_is_deleted ' => '0', 'oxa.dj_is_deleted '=>'0', 'oxa.dj_is_denied '=>'0', 'oxa.dj_approval_status' => '1'));
		if($agency_id)
		{
				$this->db->where('oxa.agencyid',$agency_id);
		}
		if($camp_type=="WEB")
		{
				$adblocks = array('W_BAN', 'W_DHTML', 'W_TEXT','V_A_OL','V_A_IN','C_A_BAN','C_A_TEXT','C_A_IN','C_A_OL');
				$this->db->where_in('dj_zone_type', $adblocks);
		}	
		else if($camp_type=="CROSS")
		{
			$adblocks = array('W_BAN', 'W_DHTML', 'W_TEXT','V_A_OL','V_A_IN','C_A_BAN','C_A_TEXT','C_A_IN','C_A_OL','M_A_IM', 'M_A_TXT', 'M_A_INT','M_A_EXD','M_A_RVL','M_A_FX','M_A_AD','M_A_FS','M_A_SLI','M_A_PULL','M_A_IM','M_A_IN','M_A_OL','M_A_IR','M_A_DHTML','M_A_DHTML5');
			$this->db->where_in('dj_zone_type', $adblocks);
		}
		else
		{
				$adblocks = array('M_A_IM', 'M_A_TXT', 'M_A_INT','M_A_EXD','M_A_RVL','M_A_FX','M_A_AD','M_A_FS','M_A_SLI','M_A_PULL','M_A_IM','M_A_IN','M_A_OL','M_A_IR','C_A_BAN','C_A_TEXT','M_A_DHTML','M_A_DHTML5');
				$this->db->where_in('dj_zone_type', $adblocks);
		}
		
		$this->db->join(TAB_AFFILIATE . ' AS oxa', 'oxa.affiliateid = oxz.affiliateid');
		$this->db->join(TAB_SITE_ZONE_ASSOC . ' AS s2z', 's2z.zone_id = oxz.zoneid');
		$this->db->join(TAB_PUB_SITES . ' AS oxs', 'oxs.site_id = s2z.site_id');
		$query = $this->db->get(TAB_ZONES . ' AS oxz');	
		//echo $this->db->last_query();exit;
		return $query->result_array();
		

	}
	
	function fetch_adblocks_creatives($creative_detail=FALSE,$camp_type = FALSE,$agency_id = FALSE)
	{
		
		$where = '';
		if($camp_type=="WEB")
		{
			
			$i = 1;
			$creative_count = count($creative_detail);
			
			if($creative_detail)
			{	$where .='and (';
				foreach($creative_detail as $creative){
					$where .= '(';
					$where .= 'oxz.width='.$creative['width'].' AND oxz.height='.$creative['height'];
					$where .= ')';
					if($creative_count > $i)
					{
						$where .= ' OR ';
					}
					$i++;
				}
				$where .=')';
			}
		
			$adblocks = "'W_BAN', 'W_DHTML', 'W_TEXT','V_A_OL','V_A_IN','C_A_IM','C_A_TXT'";
			$blk_type="'web','cross'";
		}
		
		else if($camp_type=="CROSS")
		{
			
			$adblocks = "'M_A_IM', 'M_A_TXT', 'M_A_INT','M_A_EXD','M_A_RVL','M_A_FX','M_A_AD','M_A_FS','M_A_SLI','M_A_PULL','M_A_IM','M_A_IN','M_A_OL','W_BAN', 'W_DHTML', 'W_TEXT','V_A_OL','V_A_IN','C_A_IM','C_A_TXT','C_IN','C_OL','M_A_PV','M_A_RW','M_A_DHTML','M_A_IMG_NAT','M_A_DHTML5'";
			$blk_type="'cross'";
		}	
		else
		{
			
			$adblocks = "'M_A_IM', 'M_A_TXT', 'M_A_INT','M_A_EXD','M_A_RVL','M_A_FX','M_A_AD','M_A_FS','M_A_SLI','M_A_PULL','M_A_IM','M_A_IN','M_A_OL','C_A_IM','C_A_TXT','M_A_PV','M_A_RW','M_A_DHTML','M_A_IMG_NAT','M_A_DHTML5'";
			$blk_type="'mobile','cross'";
		}
		
		$sql = "select oxa.agencyid,oxz.zoneid,oxz.zonename,oxz.affiliateid,oxa.name,oxs.site_name ,oxs.site_id,oxs.site_url from ox_zones as oxz,ox_affiliates as oxa,djax_publisher_sites as oxs,djax_site_zone_assoc as s2z where oxa.affiliateid = oxz.affiliateid and s2z.zone_id = oxz.zoneid and oxs.site_id = s2z.site_id and oxz.dj_is_deleted = 0 ".$where." and oxz.dj_zone_type in (".$adblocks.") and oxa.agencyid = ".$agency_id." ";
		//echo $sql; exit;
		$query = $this->db->query($sql);
	
		$result = $query->result_array();

		if($result)
			return $result;
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_campaigns_linked
	 * @param : campaign_id
	 * @return : $result
	 * 
	 * Lists a ad blocks
	 */
	function fetch_campaigns_linked($campaign_id = FALSE)
	{
		if($campaign_id)
		{
			$this->db->select('zone_id')->where('placement_id', $campaign_id);
			$query 		=	$this->db->get(TAB_PLACE_ZONE_ASSOC)->result_array();			
			$result		=	FALSE;
			foreach($query as $linked)
			{
				$result[]=	$linked['zone_id'];
			}
			return $result;
		}
	}
	
	/*
	 * 
	 * name: fetch_linked_campaigns
	 * @param : zone_id
	 * @return : $result
	 * 
	 * Lists a ad blocks
	 */
	function fetch_linked_campaigns($zone_id = FALSE)
	{
		if($zone_id)
		{
			$this->db->select('placement_id')->where('zone_id', $zone_id);
			$query 		=	$this->db->get(TAB_PLACE_ZONE_ASSOC)->result_array();			
			$result		=	FALSE;
			foreach($query as $linked)
			{
				$result[]=	$linked['placement_id'];
			}
			return $result;
		}
	}
	
	/*
	 * 
	 * name: linked_campaign_process
	 * @param : campaign_id, zone_ids
	 * @return : $result
	 * 
	 * Lists a ad blocks
	 */	 
	function linked_campaign_process($campaign_id = FALSE, $zone_ids = FALSE)
	{
	
	
		if($campaign_id)
		{
			$update_ids		=	is_array($zone_ids) ? array_map('trim', $zone_ids) : array();
			
			$exist_ids		=	$this->fetch_campaigns_linked($campaign_id);
			$temp_ids		=	$this->fetch_campaign_adblocks($campaign_id);
			$possible_ids	= 	array();
			//print_r($temp_ids);die("--");
			foreach($temp_ids as $adv)
			{
				foreach($adv['children'] as $zone)
				{
					$possible_ids[]	=	$zone['key'];
				}
			}
			
			$not_exists		=	array_diff($update_ids, $exist_ids);
			$remove_ids		=	array_diff($exist_ids, $update_ids);
			
			$insert_ids		=	($exist_ids == FALSE) ? $update_ids : array_intersect($possible_ids, $not_exists);	
			
			//Updating Association Table
			$this->db->trans_start();
			
			$result			=	0;
			//Removing unchecked boxes from Association table
			if(is_array($remove_ids) && count($remove_ids) > 0)
			{
				
				$this->db->where('placement_id', $campaign_id);
				$this->db->where_in('zone_id', $remove_ids);
				$this->db->delete(TAB_PLACE_ZONE_ASSOC);
				$result	   +=	1;
				$sql	=	"DELETE a2z FROM " . TAB_AD_ZONE_ASSOC . " AS a2z 
							JOIN " . TAB_BANNERS . " AS oxb ON oxb.bannerid = a2z.ad_id 
							WHERE oxb.campaignid = " . $campaign_id . " AND a2z.zone_id IN(" . implode(',', $remove_ids) . ")";
				$this->db->query($sql);    //Manual
			}
			
			//Insert New entries
			//print_r($insert_ids);exit;
			if(is_array($insert_ids) && count($insert_ids) > 0)
			{
				
				foreach($insert_ids as $zone_id)
				{
					$this->db->insert(TAB_PLACE_ZONE_ASSOC, array('zone_id' =>	$zone_id, 'placement_id' => $campaign_id));
				}
				$result	   +=	2;
			}
			
			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				
				$this->link_campaign_banners($campaign_id);
				return $result;
			}
		}
	}
	
	function link_campaign_banners($campaign_id	= FALSE)
	{

		if($campaign_id)
		{
			$zone_ids		=	$this->fetch_campaigns_linked($campaign_id);
				
			$ads_ids		=	$this->fetch_campaign_creative($campaign_id);
			//print_r($zone_ids);die("--");
			if(is_array($zone_ids) && is_array($ads_ids))
			{
				foreach($zone_ids as $zone_id)
				{
					$this->linked_ads_process($zone_id, $ads_ids, $campaign_id);
					
				}
					
			}
		}
	}
	
	function fetch_campaign_creative($campaign_id = FALSE)
	{
		if($campaign_id)
		{
			$this->db->select('bannerid')->where('campaignid', $campaign_id);
			$query 		=	$this->db->get(TAB_BANNERS)->result_array();
			$result		=	FALSE;
			foreach($query as $linked)
			{
				$result[]=	$linked['bannerid'];
			}
			return $result;
		}
	}
	
	/*
	 * 
	 * name: fetch_image_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a image blocks
	 */
	function fetch_image_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_IMAGE);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');		
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_mob_text_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a text blocks
	 */
	function fetch_mob_text_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_TEXT);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
			
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_interstitial_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a interstitial blocks
	 */
	function fetch_interstitial_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_INTERSTITIAL);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_expand_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a expand blocks
	 */
	function fetch_expand_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_EXPAND);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_reveal_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a reveal blocks
	 */
	function fetch_reveal_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_REVEAL);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_flex_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a flex blocks
	 */
	function fetch_flex_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_FLEX);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
			
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_adhension_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a adhension blocks
	 */
	function fetch_adhension_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_ADHENSION);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_filmstrip_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a adhension blocks
	 */
	function fetch_filmstrip_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_FLIMSTRIP);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_pull_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a pull blocks
	 */
	function fetch_pull_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_PULL);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_slider_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a slider blocks
	 */
	function fetch_slider_adblocks()
	{
		$this->db->select('oxz.zoneid,oxz.zonename,oxa.name,oxa.affiliateid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id)
		{
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_SLIDER);
		$this->db->where('oxz.dj_is_deleted ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	function linked_ads_test($zone_id = FALSE, $ads_ids	= FALSE)
	{

		if($zone_id)
		{

			$update_ids		=	is_array($ads_ids) ? array_map('trim', $ads_ids) : array();
			$exist_ids		=	$this->fetch_ads_linked($zone_id);
			$temp_ids		=	$this->fetch_ads($zone_id);
			$possible_ids	= 	array();
			
			
			foreach($temp_ids as $adv)
			{
				foreach($adv['children'] as $zone)
				{
					$possible_ids[]	=	$zone['key'];
				}
			}
			
			//~ $not_exists				=	array_diff($update_ids, $exist_ids);			
			//~ $remove_adids			=	array_diff($exist_ids, $update_ids);
			
			$not_exists		=	array_diff($update_ids, ($exist_ids)?$exist_ids:array());			
			$remove_adids	=	array_diff(($exist_ids)?$exist_ids:array(), $update_ids);
	
			$insert_adids			=	($exist_ids == FALSE) ? array_intersect($possible_ids, $update_ids) : array_intersect($possible_ids, $not_exists);

		if(count($insert_adids)>0)
		{
			$placement_ids  		=	$this->fetch_placement_id($zone_id,$insert_adids);  //Fetch campaign id for the particular creative id's
		}
		if(count($remove_adids)>0)
		{
			$placement_ids_remove  	=	$this->fetch_placement_id_remove($zone_id,$remove_adids);  //Fetch campaign id to remove for the particular creative id's
		}
			//Updating Association Table
			$this->db->trans_start();
			
			$result	= 0;
			//Removing unchecked boxes from Association table
			if(is_array($remove_ids) && count($remove_ids) > 0)
			{
				$this->db->where('zone_id',$zone_id);
				$this->db->where_in('ad_id',$remove_ids);
				$this->db->delete(TAB_AD_ZONE_ASSOC);
			    $result	   +=	1;
				
			    
			}
		//Insert New entries

			if(is_array($insert_adids) && count($insert_adids) > 0)
			{
				
				foreach($insert_adids as $ad_id)
				{
					$this->db->insert(TAB_AD_ZONE_ASSOC, array('zone_id' =>	$zone_id, 'ad_id' => $ad_id));				
				}
				
				$result	   +=	1;
			
			}
		
			if(is_array($placement_ids) && count($placement_ids) > 0)
			{
				foreach($placement_ids as $camp_id)
				{
					$SQL1 = " Select * from ox_placement_zone_assoc where placement_id = $camp_id and zone_id = $zone_id";
					$query = $this->db->query($SQL1);

					if ($query->num_rows() == 0) 
					{
					  $this->db->insert(TAB_PLACE_ZONE_ASSOC, array('zone_id' => $zone_id, 'placement_id' => $camp_id));
					}
							  
					
				}
					
					$result	   +=	1;
			}
			
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $result;
				
			}
		}
	}
	function unlink_campaigns_of_single_creative($zone_id,$placement_ids_remove)
	{
	$ids = rtrim(implode(',', $placement_ids_remove), ',');

	 if($zone_id)
		{
			$sql = "Select b.bannerid from ox_banners as b 
					join ox_ad_zone_assoc as az on az.ad_id = b.bannerid and az.zone_id = '".$zone_id."'
					where b.campaignid = '".$ids."' ";
			
			$query = $this->db->query($sql);
			if ($query->num_rows() >= 1) 
			{
				$this->db->where('zone_id',$zone_id);
				$this->db->where_in('placement_id',$placement_ids_remove);
				$this->db->delete(TAB_PLACE_ZONE_ASSOC);
			}
			else
			{
				return FALSE;
			}
	
			
		}
		
	}
	function unlink_campaigns($zone_id,$placement_ids_remove){
		if($zone_id && $placement_ids_remove)
		{
			$this->db->select('zone_id,placement_id');		
			$this->db->where('zone_id',$zone_id);
			$this->db->where_in('placement_id',$placement_ids_remove);
			$query = $this->db->get(TAB_PLACE_ZONE_ASSOC);	
	
			if ($query->num_rows() > 0) 
			{
				
				$this->db->where('zone_id',$zone_id);
				$this->db->where_in('placement_id',$placement_ids_remove);
				$this->db->delete(TAB_PLACE_ZONE_ASSOC);
				
			}
			else
			{
				return FALSE;
			}
		}
	}
	
	function fetch_camp_category_id($campaignid)
	{
		$this->db->select('dj_category_id');		
		$this->db->where('campaignid',$campaignid);
		$query = $this->db->get(TAB_CAMPAIGNS);	
		$result = $query->result_array();
		return $result[0]['dj_category_id'];
	}
	
	 function fetch_both_bann_creatives($where=false, $categories=FALSE)
	 {
		//~ if($where)
		//~ {
			//~ $where_w = array($where['oxb.width'],0);
			//~ $where_h = array($where['oxb.height'],0);
			//~ $where_web = array(
												//~ "oxb.width" => 320,
												//~ "oxb.height" => 480
											//~ );
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			//~ $this->db->where_in('oxb.width',$where_w);
			//~ $this->db->where_in('oxb.height',$where_h);
			//$this->db->where_in($where_web);
			
			
			$this->db->where_in('oxb.storagetype', array('web','sql','html','url'));
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_WEB,MOBILE_IMAGE_CREATIVE));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		//~ }
		//~ else
			//~ return FALSE;
		
	}
	
	function fetch_both_text_creatives($categories=FALSE)
	 {
		$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		if($categories)
		{
			$this->db->where_in('oxcamp.dj_category_id', $categories);
		}
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		$this->db->where('oxcl.dj_is_deleted', '0');
		$this->db->where('oxcl.dj_is_default', '0');
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		$this->db->where('oxb.dj_admin_approve', '1');
		$this->db->where('oxb.storagetype', 'txt');
		$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_TEXT,MOBILE_TEXT_CREATIVE));
		$this->db->where('oxb.dj_is_deleted ','0');
		$query = $this->db->get(TAB_BANNERS.' as oxb');	
		//echo $this->db->last_query(); exit;	
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	 function fetch_both_creatives($where=false, $categories=FALSE, $campaign_id=FALSE)
	 {
		//~ if($where)
		//~ {
			//~ 
			//~ $where_w = array($where['oxb.width'],0);
			//~ $where_h = array($where['oxb.height'],0);
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->where_in('oxcamp.campaignid', $campaign_id);
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			//~ $this->db->where_in($where_w);
			//~ $this->db->where_in($where_h);
			$this->db->where_in('oxb.storagetype', array('web','sql','html','url'));
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_WEB,MOBILE_IMAGE_CREATIVE));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		//~ }
		//~ else
			//~ return FALSE;
		
	}
	
	function fetch_both_inline_creatives($where=false, $categories=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			//$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			$this->db->where_in('oxb.dj_banner_type', array(VIDEO_CREATIVE_INLINE,MOBILE_VIDEO_CREATIVE_INLINE));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
	function fetch_both_overlay_creatives($where=false, $categories=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid, oxb.description, oxcl.clientid, oxcl.contact');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			if($categories)
			{
				$this->db->where_in('oxcamp.dj_category_id', $categories);
			}
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			$this->db->where('oxcl.dj_is_deleted', '0');
			$this->db->where('oxcl.dj_is_default', '0');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxb.dj_admin_approve', '1');
			//$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			$this->db->where_in('oxb.dj_banner_type', array(VIDEO_CREATIVE_OVERLAY,MOBILE_VIDEO_CREATIVE_OVERLAY));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	
}
