<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Do_invoices extends CI_Model
{
    
    //Generates Invoices Based on the specific time period
    public function generate_invoices($period_days = FALSE, $invoice_type = 'int_pub')
    {
        
        if ($invoice_type == "int_pub") {
            //Retreive Total payment for each publisher		
            $total_invoice_list = $this->retreive_publisher_list();
			
            //Retreive the minimum publisher payments
            $min_payment = $this->default_configurations->get('pub_min_amount_invoice');
            
            $period_days = $period_days ? $period_days : $this->default_configurations->get('pub_invoice_period');
            
        } else {
            $total_invoice_list = $this->retreive_advertiser_list();
            //Retreive the minimum publisher payments
            $min_payment        = $this->default_configurations->get('adv_min_amount_invoice');
            //Retreive the period days for advertiser
            $period_days        = $period_days ? $period_days : $this->default_configurations->get('pub_invoice_period');
        }
        
        $this->db->trans_begin();
        
        foreach ($total_invoice_list as $invoice) {
            
            //Retreive user name from  id
            $user_name    = $invoice->contact;
            $account_id   = $invoice->account_id;
            $user_email   = $invoice->email;
            $user_address = $invoice->address;
            $user_id      = $invoice->user_id;
                 
            $start_date    = $invoice->start_date;
            $end_date      = date('Y-m-d');
            $end_date_hour = date('Y-m-d H:i:s');
            
            $start_diff = strtotime($invoice->start_date);
            $end_diff   = strtotime(date('Y-m-d H:i:s'));
            $difference = $end_diff - $start_diff;
            $days       = floor($difference / (60 * 60 * 24));
			$get_transaction_details_date = $this->retreive_aff_last_invoice_generate_details($account_id);
			
			
			if(!empty($get_transaction_details_date))
			{
				$get_transaction_details_date;
			}else
			{
				$get_transaction_details_date = $start_date;
			}
			
            if ($start_date <= date('Y-m-d', strtotime('-' . $period_days . ' days'))) {
         // echo $account_id.'=>'.$get_transaction_details_date ;
                //Retreive the overall payment details for the specific invoice
                $total_pub_payment = $this->retreive_overall_payment_details($account_id, $start_date);
				   
                //Check whether the overall payment is greater than config minimum payment
                if (!empty($total_pub_payment['tot_payment'])) {
                    //Generate invoice only minimum payment is greater than minimum publisher payment
                    //$min_payment =0;
                  
                    if ($total_pub_payment['tot_payment']->tot_amount >= $min_payment) {
						
                        $days_period        = ($days == $period_days) ? $period_days : $days;
                        $invoice_code       = random_string('numeric', 10);
                        $invoice_end_date   = date('Y-m-d', strtotime('-' . ' 1 days'));
                        $invoice_tot_amount = $total_pub_payment['tot_payment']->tot_amount;
                        $prev_invoice_id    = $total_pub_payment['tot_payment']->invoice_id;
                        
                        //Creates the insert variables for invoice
                        $ins_arr = array(
                            'account_id' => $account_id,
                            'invoice_code' => $invoice_code,
                            'invoice_date' => $end_date,
                            'invoice_net_amount ' => $invoice_tot_amount,
                            'invoice_status' => 0,
                            'invoice_description' => $this->lang->line('invoice_desc'),
                            'invoice_start_date' => $get_transaction_details_date,
                            'invoice_end_date' => $invoice_end_date,
                            'invoice_period_days' => $days_period,
                            'invoice_type' => $invoice_type
                        );
                        
                        
                        $this->db->insert(TAB_INVOICE, $ins_arr);
                        
                        $last_invoice_id = $this->db->insert_id();
                        
                        $earnings_desc = $this->lang->line('publisher_invoice_desc') . $start_date . " to " . $invoice_end_date;
                        
                        
                        //Inserts the invoice item into TAB_INVOICE_ITEM
                        $ins_item_arr = array();
                        
                        $ins_item_arr[] = array(
                            'invoice_id' => $last_invoice_id,
                            'item_code' => 'ERN',
                            'item_desc' => $earnings_desc,
                            'amount' => $total_pub_payment['tot_payment']->cur_earn,
                            'currency' => $this->config->item('currency_transaction_symbol')
                        );
                        
                        
                        
                        
                        if ($total_pub_payment['tot_payment']->cry_bal > 0) {
                            $ins_item_arr[] = array(
                                'invoice_id' => $last_invoice_id,
                                'item_code' => 'CRYBAL',
                                'item_desc' => $this->lang->line('publisher_prev_invoice_desc'),
                                'amount' => $total_pub_payment['tot_payment']->cry_bal,
                                'currency' => $this->config->item('currency_transaction_symbol')
                            );
                        }
                        
                        $this->db->insert_batch(TAB_INVOICE_ITEM, $ins_item_arr);
                        
                        if ($prev_invoice_id != 0) {
                            $this->db->update(TAB_INVOICE, array(
                                'invoice_status' => 2
                            ), array(
                                'invoice_id' => $prev_invoice_id
                            ));
                        }
                        
                        $admin_details_enq = $this->get_network_details();
                        
                        $admin_details = $admin_details_enq[0];
                        
                        $admin_name    = $admin_details['first_name'] . "-" . $admin_details['last_name'];
                        $admin_email   = $admin_details['email_address'];
                        $admin_address = $admin_details['company_block_no'];
                        $admin_addr    = $admin_details['company_address'];
                        $admin_number  = $admin_details['mobile_number'];
                        
                        if ($invoice_type == "int_pub") {
                            $type = "PUB_INVOICE";
                        }
                        /*	if($invoice_type=="int_adv")
                        {
                        $type="ADV_INVOICE";
                        }
                        */
                        $from = $admin_email;
                        $to   = $user_email;
                        //$to = 'sruthi.ps@dreamajax.com';
                        $mail_content = array(
                            "subject" => "Invoice",
                            "to_name" => $user_name,
                             "to_mail"=>$user_email,
                            "from_name" => $admin_name,
                            "from_email" => $admin_email,
                            "address" => $admin_address . " , " . $admin_addr,
                            "number" => $admin_number,
                            "user_address" => $user_address,
                            "invoiceid" => $last_invoice_id,
                            "user_address" => $user_address,
                            "invoice_date" => $end_date,
                            "payment_terms" => $period_days,
                            "earnings_desc" => $earnings_desc,
                            "invoice_start_date"=>$get_transaction_details_date,
                            "invoice_end_date" => $invoice_end_date,
                            "invoice_amount" => $invoice_tot_amount,
                    
                            "invoice_code"=>$invoice_code,
                         
                    'earn_amount' => $total_pub_payment['tot_payment']->cur_earn,
                    'prev_amt'=> $total_pub_payment['tot_payment']->cry_bal,
                           "invoice_detaits"=>array("invoice_date" => $end_date,"invoice_net_amount"=> $invoice_tot_amount),
                        );
                                                
                        $attachement = FALSE;
                        $bcc         = FALSE;
                        send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                        //send_mail($type, $from, $to, $mail_content, $attachement, $bcc, $invoice_type);
                        
                    }
                    
                }
            }
        }
        
       
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        
        return TRUE;
    }
    
    
    public function get_network_details()
    {
        
        
        $this->db->select('*');
        $this->db->where('account_id', 1);
        $query  = $this->db->get(TAB_NETWORKS);
        $result = $query->result_array();
        if ($result) {
            return $result;
        }
    }
    
    /*******************************
     * Method 		: retreive_overall_payment_details
     * @param 		: publisher account id
     * @return 		: return overall payment_details on TRUE (or) FALSE
     * Description	: Retreive the overall payment details 
     * *****************************/
    function retreive_overall_payment_details($acc_id, $start_date)
    {
        
        
        
        if ($acc_id) {
            //Create an empty array for the payment
            $overall_payment_details = array();
            
            //Checks Whether Previous Invoices are Available or not
            $start_date = $start_date;
            
            //assign total payment based on condition
            $tot_payment_sql = "SELECT accountid,SUM(totalrev) as cur_earn,SUM(prev_bal) as cry_bal,(SUM(totalrev) + SUM(prev_bal)) as tot_amount,invoice_id 
								FROM 
								(
								  (SELECT `account_id` as accountid,0 as totalrev,djin.invoice_net_amount as prev_bal,djin.invoice_id as invoice_id
								  FROM " . TAB_INVOICE . " as djin
								  WHERE djin.invoice_status=0 AND account_id= $acc_id 
								  ORDER BY djin.invoice_date DESC LIMIT 1) UNION (SELECT oxa.account_id as accountid,ROUND(IFNULL(SUM(oxadh.dj_publisher_earnings),0),4) as totalrev,0 as prev_bal,0 as invoice_id 
								FROM " . TAB_DATA_SUM_AD_HOURLY . " as oxadh 
								JOIN " . TAB_ZONES . " as oxz ON oxz.zoneid=oxadh.zone_id 
								JOIN " . TAB_AFFILIATE . " as oxa ON oxa.affiliateid=oxz.affiliateid 
								WHERE oxa.account_id= $acc_id";
            if (isset($start_date) && !empty($start_date)) //zone_id
                {
                $tot_payment_sql .= " AND DATE(date_time) BETWEEN 'DATE($start_date)' AND DATE_SUB(CURDATE(),INTERVAL 1 DAY)";
            } else {
                $tot_payment_sql .= " AND DATE_SUB(CURDATE(),INTERVAL 1 DAY)>= DATE(date_time)";
            }
            $tot_payment_sql .= " GROUP BY oxa.affiliateid 
								  ORDER BY DATE(date_time) DESC)) as final HAVING final.accountid IS NOT NULL";
            
            
          
            $tot_payment_query = $this->db->query($tot_payment_sql);
            
            
            
            
            
            if ($tot_payment_query->num_rows() > 0) {
                $tot_payment_result = $tot_payment_query->row();
                
                $overall_payment_details['tot_payment'] = $tot_payment_result;
                
                
                if ($currency != FALSE) {
                    $invdate                                   = date('Y:m:d', strtotime($tot_payment_result->invoice_date));
                    $tot_amount                                = $this->currency_converter->currency_convert_account(array(
                        'datetime' => $invdate,
                        'currency_code' => $currency,
                        'amount' => $tot_payment_result->tot_amount
                    ));
                    $currency_con                              = currencyformat($tot_amount, $currency);
                    $overall_payment_details['totamount_conv'] = $currency_con;
                    
                    $cur_earn                                = $this->currency_converter->currency_convert_account(array(
                        'datetime' => $invdate,
                        'currency_code' => $currency,
                        'amount' => $tot_payment_result->cur_earn
                    ));
                    $earn_con                                = currencyformat($cur_earn, $currency);
                    $overall_payment_details['totearn_conv'] = $earn_con;
                    
                    $cry_bal                                = $this->currency_converter->currency_convert_account(array(
                        'datetime' => $invdate,
                        'currency_code' => $currency,
                        'amount' => $tot_payment_result->cry_bal
                    ));
                    $bal_con                                = currencyformat($cry_bal, $currency);
                    $overall_payment_details['totbal_conv'] = $bal_con;
                }
            } else {
                $tot_payment                            = 0;
                $overall_payment_details['tot_payment'] = 0;
            }
            
            return $overall_payment_details;
            
        } else {
            return FALSE;
        }
    }
    /*******************************
     * Method 		: retreive_last_invoice_generate_date
     * @param 		: publisher account id
     * @return 		: return payment_details on TRUE (or) FALSE
     * Description	: Retreive the overall payment details 
     * *****************************/
    function retreive_last_invoice_generate_date($pub_acc_id = FALSE)
    {
        
        $this->db->select('DATE(invoice_date) as last_generate_date');
        $this->db->order_by('invoice_id desc,invoice_date desc');
        
        if ($pub_acc_id) {
            $query = $this->db->get_where('djax_invoice', array(
                'account_id' => $pub_acc_id
            ));
            
            
        } else {
            $query = $this->db->get('djax_invoice');
            
        }
        return $this->db->last_query();
        if ($query->num_rows > 0) {
            $result = $query->row();
            return $result->last_generate_date;
        } else {
            return FALSE;
        }
    }
    
    
    
    //Retreive Total payment for each publisher from oxm_report table
    public function retreive_total_payment($period_days)
    {
        //  WHERE DATE_SUB(CURDATE(),INTERVAL 1 DAY)>= DATE(date) 
        
        $query = $this->db->query('SELECT sum(oxmr.publisher_amount) as totalrev, oxa.account_id as publisherid 
						 FROM `oxm_report` as oxmr JOIN ox_affiliates as oxa ON oxa.affiliateid=oxmr.publisherid
						 WHERE DATE_SUB(CURDATE(),INTERVAL 1 DAY)>= DATE(date)
						 GROUP BY publisherid 
						 ORDER BY DATE(date) desc');
        
        //echo $this->db->last_query();
        
        
        return $query->result();
    }
    
    //Retreive Total Paid payment for each publisher from oxm_admin_payment table
    public function retreive_paid_payment($pub_id = FALSE)
    {
        if ($pub_id) {
            
            $query = $this->db->query('SELECT sum(oxm_admin_payment.amount) as reportpaid 
							FROM oxm_admin_payment
							WHERE DATE_SUB(CURDATE(),INTERVAL 1 DAY)>= DATE(date) AND status =1 AND publisherid = ' . $pub_id . '
							GROUP BY `publisherid`
							');
            
            if ($query->num_rows() > 0) {
                $result = $query->result();
                return $result[0]->reportpaid;
            } else {
                return FALSE;
            }
        } else {
            return FALSE;
        }
    }
    
    //Retreive Publisher Name 
    public function retreive_publisher_name($pub_id = FALSE)
    {
        if ($pub_id) {
            $this->db->select('username');
            $query = $this->db->get_where('oxm_userdetails', array(
                'accountid' => $pub_id
            ));
            if ($query->num_rows() > 0) {
                $result = $query->result();
                return $result[0]->username;
            } else {
                return FALSE;
            }
        } else {
            
        }
    }
    
    //Generate Payment invoice for the publishers
    public function generate_payment_invoice($inv_id)
    {
        $app_invoice = $this->check_approved_invoice($inv_id);
        if ($app_invoice) {
            $data['payment_info'] = $this->payment_invoice_information($inv_id);
            
            //$view = $this->load->view('admin/invoice_pub',$data,true);
            
            $payment_date = date('Y-m-d', strtotime($data['payment_info']['invoice_paid_date']));
            $pdf_name     = 'invoice_' . $data['payment_info']['invoice_code'] . '_' . $payment_date;
            
            $this->pdf->load_view('admin/invoices/invoice_pub', $data);
            $this->pdf->render();
            $this->pdf->stream("$pdf_name.pdf");
            
        } else {
            return FALSE;
        }
    }
    
    //Check whether the Invoice has ben approved or not
    public function check_approved_invoice($inv_id)
    {
        $this->db->join('djax_invoice_payment as dip', 'dip.invoice_id=di.invoice_id');
        $query = $this->db->get_where('djax_invoices as di', array(
            'di.invoice_status' => 1,
            'di.invoice_id' => $inv_id
        ));
        
        if ($query->num_rows() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    
    //Retreive Payment invoice informations based on their invoice id
    public function payment_invoice_information($inv_id)
    {
        $this->db->join('oxm_userdetails as oxu', 'oxu.accountid=di.publisher_id');
        $this->db->join('djax_invoice_payment as dip', 'dip.invoice_id = di.invoice_id');
        $this->db->join('oxm_admin_payment as oxap', 'oxap.id=dip.payment_id');
        $query = $this->db->get_where('djax_invoices as di', array(
            'di.invoice_status' => 1,
            'di.invoice_id' => $inv_id
        ));
        
        if ($query->num_rows() > 0) {
            $result = $query->row_array();
            $this->db->select('username,address as admin_address,city as admin_city,state as admin_state,country as admin_country,site_title,site_url,logo');
            $ad_query = $this->db->get_where('oxm_admindetails', array(
                'accountid' => $this->session->userdata('mads_sess_admin_id')
            ));
            if ($ad_query->num_rows() > 0) {
                $ad_result = $ad_query->row_array();
                $result    = array_merge($result, $ad_result);
            }
            return $result;
        } else {
            return FALSE;
        }
    }
    
    function get_advertiser_payments_datewise($search_array, $start = 0, $limit = false)
    {
        
        $this->db->select('*');
        $this->db->from('djax_advertiser_add_fund as daaf');
        $this->db->join('ox_clients as oxc', 'oxc.clientid=daaf.advertiser_id');
        $sub = $this->subquery->start_subquery('where_in');
        $sub->select('djax_account_id')->from('ad_exchange_mapping');
        $this->subquery->end_subquery('oxc.account_id', FALSE);
        $this->db->order_by('clientname');
        
        if (!empty($search_array['search_field_adv']) && $search_array['search_field_adv'][0] != 'all') {
            $this->db->where_in('daaf.advertiser_id', $search_array['search_field_adv']);
        }
        
        if (!empty($search_array) AND isset($search_array['from_date']) AND isset($search_array['to_date']) AND $search_array['from_date'] != '' AND $search_array['to_date'] != '' AND $search_array['search_type'] != 'all') {
            $this->db->where('DATE(daaf.added_date) >=', date("Y-m-d", strtotime($search_array['from_date'])));
            $this->db->where('DATE(daaf.added_date) <=', date("Y-m-d", strtotime($search_array['to_date'])));
            //$this->db->where("DATE(di.invoice_date) BETWEEN $search_array['from_date'] AND $search_array['to_date']");
        }
        
        
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            
            return FALSE;
        }
    }
    
    function retreive_advertiser_payment_history()
    {
        
        $this->db->select('*');
        $this->db->from('djax_advertiser_add_fund as daaf');
        $this->db->join('ox_clients as oxc', 'oxc.clientid=daaf.advertiser_id');
        $sub = $this->subquery->start_subquery('where_in');
        $sub->select('djax_account_id')->from('ad_exchange_mapping');
        $this->subquery->end_subquery('oxc.account_id', FALSE);
        $this->db->order_by('clientname');
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            return $result;
        } else {
            
            return FALSE;
        }
        
    }
    
    //Retreive All the generated invoices
    function retreive_invoice_history()
    {
        $this->db->join('oxm_userdetails as oxu', 'oxu.accountid=di.publisher_id');
        //$this->db->join('djax_invoice_payment as dip','dip.invoice_id = di.invoice_id');
        //$this->db->join('oxm_admin_payment as oxap','oxap.id=dip.payment_id');
        $query = $this->db->get('djax_invoices as di');
        
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            
            
            $result_pay = array();
            //Retreive the Payment Other details
            foreach ($result as $payment) {
                if ($payment['invoice_status'] == 1) {
                    $payment_details = $this->retreive_payment_details($payment['invoice_id']);
                    $payment         = array_merge($payment, $payment_details);
                }
                array_push($result_pay, $payment);
            }
            
            
            //retreive the admin userdetails
            /*$this->db->select('username,address as admin_address,city as admin_city,state as admin_state,country as admin_country,site_title,site_url,logo');
            $ad_query = $this->db->get_where('oxm_admindetails',array('accountid'=>$this->session->userdata('mads_sess_admin_id')));
            if($ad_query->num_rows()>0)
            {
            $ad_result = $ad_query->row_array();
            }*/
            $final_result = $result_pay;
            //$final_result = array('invoice_list'=>$result_pay,'admin_detail'=>$ad_result);
            return $final_result;
        } else {
            return FALSE;
        }
    }
    
    //Retreive payment details from oxm_admin_payment
    public function retreive_payment_details($inv_id = FALSE)
    {
        if ($inv_id) {
            $this->db->select('email as pub_email,paymenttype');
            $this->db->join('djax_invoice_payment as dip', 'dip.payment_id = oxap.id');
            $query = $this->db->get_where('oxm_admin_payment as oxap', array(
                'dip.invoice_id' => $inv_id
            ));
            
            if ($query->num_rows > 0) {
                return $query->row_array();
            } else {
                return FALSE;
            }
        } else {
            return FALSE;
        }
    }
    
    //Retreive Individual Invoice
    function retreive_individual_invoice_history($inv_id = FALSE)
    {
        if ($inv_id) {
            $this->db->join('oxm_userdetails as oxu', 'oxu.accountid=di.publisher_id');
            //$this->db->join('djax_invoice_payment as dip','dip.invoice_id = di.invoice_id');
            //$this->db->join('oxm_admin_payment as oxap','oxap.id=dip.payment_id');
            $query = $this->db->get_where('djax_invoices as di', array(
                'di.invoice_id' => $inv_id
            ));
            
            if ($query->num_rows() > 0) {
                $result = $query->row_array();
                
                
                
                $result_pay = array();
                //Retreive the Payment Other details
                
                if ($result['invoice_status'] == 1) {
                    $payment_details = $this->retreive_payment_details($result['invoice_id']);
                    $result          = array_merge($result, $payment_details);
                }
                array_push($result_pay, $result);
                
                
                //retreive the admin userdetails
                $this->db->select('username,address as admin_address,city as admin_city,state as admin_state,country as admin_country,site_title,site_url,logo');
                $ad_query = $this->db->get_where('oxm_admindetails', array(
                    'accountid' => $this->session->userdata('mads_sess_admin_id')
                ));
                if ($ad_query->num_rows() > 0) {
                    $ad_result = $ad_query->row_array();
                }
                
                $final_result = array_merge($result_pay[0], $ad_result);
                
                //$final_result = array('invoice_detail'=>$result_pay,'admin_detail'=>$ad_result);
                return $final_result;
            } else {
                return FALSE;
            }
        } else {
            return FALSE;
        }
    }
    
    /*Retreive the start date from the invoice history */
    function get_start_date()
    {
        $query = $this->db->query("SELECT date(`invoice_date`) as start_date FROM `djax_invoices` ORDER BY `invoice_date` ASC LIMIT 0,1");
        if ($query->num_rows > 0) {
            $t = $query->result_array();
            return $t[0]['start_date'];
        } else {
            return date("Y-m-d");
        }
    }
    
    /*Retreive the invoices based on datewise*/
    function get_invoices_datewise($search_array, $start = 0, $limit = false)
    {
        
        $this->db->join('oxm_userdetails as oxu', 'oxu.accountid=di.publisher_id');
        
        
        if (!empty($search_array['search_field_pub']) && $search_array['search_field_pub'][0] != 'all') {
            $this->db->where_in('di.publisher_id', $search_array['search_field_pub']);
        }
        
        
        if (!empty($search_array) AND isset($search_array['from_date']) AND isset($search_array['to_date']) AND $search_array['from_date'] != '' AND $search_array['to_date'] != '' AND $search_array['search_type'] != 'all') {
            
            
            $this->db->where('DATE(di.invoice_date) >=', $search_array['from_date']);
            $this->db->where('DATE(di.invoice_date) <=', $search_array['to_date']);
            //$this->db->where("DATE(di.invoice_date) BETWEEN $search_array['from_date'] AND $search_array['to_date']");
            $query = $this->db->get('djax_invoices as di');
        } else {
            $query = $this->db->get('djax_invoices as di');
        }
        if ($query->num_rows() > 0) {
            $result = $query->result_array();
            
            
            $result_pay = array();
            //Retreive the Payment Other details
            foreach ($result as $payment) {
                if ($payment['invoice_status'] == 1) {
                    $payment_details = $this->retreive_payment_details($payment['invoice_id']);
                    $payment         = array_merge($payment, $payment_details);
                }
                array_push($result_pay, $payment);
            }
            
            
            //retreive the admin userdetails
            /*$this->db->select('username,address as admin_address,city as admin_city,state as admin_state,country as admin_country,site_title,site_url,logo');
            $ad_query = $this->db->get_where('oxm_admindetails',array('accountid'=>$this->session->userdata('mads_sess_admin_id')));
            if($ad_query->num_rows()>0)
            {
            $ad_result = $ad_query->row_array();
            }*/
            $final_result = $result_pay;
            //$final_result = array('invoice_list'=>$result_pay,'admin_detail'=>$ad_result);
            return $final_result;
        } else {
            return FALSE;
        }
    }
    
    //Modified to Retreive for Active Publisher Invoice List by Suganiya.R on 29-02-2016
    function retreive_publisher_list()
    {
        $query = $this->db->query("SELECT name,contact,dj_company_address as address,email,oa.account_id,affiliateid as user_id,IFNULL(DATE(di.invoice_date),DATE(oa.dj_added_date)) as start_date FROM ox_affiliates as oa LEFT JOIN `djax_invoice` as di ON di.account_id=oa.account_id ORDER BY `affiliateid`  ");
        
        /*	$this->db->select('name,contact,email,oa.account_id,affiliateid as user_id,IFNULL(di.invoice_start_date,oa.dj_added_date) as start_date');
        $this->db->order_by('affiliateid');
        $this->db->join('djax_invoice as di','di.account_id=oa.account_id');
        $query = $this->db->get('ox_affiliates as oa');
        */
        if ($query->num_rows() > 0) {
            $result = $query->result();
            return $result;
        } else {
            
            return FALSE;
        }
    }
    
    //Retreive Active Publisher List
    /*function retreive_advertiser_list()
    {
    $this->db->select('oxc.clientname,oxc.contact,oxc.email,oxc.account_id,oxc.clientid');
    $this->db->join('oxm_userdetails as oxmu','oxmu.accountid=oxc.account_id');
    $this->db->where('oxmu.super_advertiser !=','1');
    $sub = $this->subquery->start_subquery('where_in');
    $sub->select('djax_account_id')->from('ad_exchange_mapping');
    $this->subquery->end_subquery('oxc.account_id', FALSE);
    $this->db->order_by('clientname');
    $query = $this->db->get('ox_clients as oxc');
    
    if($query->num_rows() >0)
    {
    $result = $query->result();
    return $result;
    }else{
    
    return FALSE;
    }
    }*/
    
    /******************************
     * Method 		: retreive_referral_commission_earning
     * @params		: Publisher_id
     * description 	: Retreive the referral commission for each publisher
     * *****************************/
    function retreive_referral_commission_earning($pub_id = FALSE)
    {
        if (isset($pub_id) && !empty($pub_id)) {
            $this->db->select_sum('referer_share_amount');
            $this->db->group_by('referer_publisher_id');
            $query = $this->db->get_where('oxm_report', array(
                'referer_publisher_id' => $pub_id
            ));
            if ($query->num_rows() > 0) {
                $result  = $query->row_array();
                $ref_com = $result['referer_share_amount'];
                return $ref_com;
            } else {
                return 0;
            }
        } else {
            return FALSE;
        }
    }
    
    /******************************
     * Method 		: retreive_affiliate_id
     * @params		: Publisher_acc_id
     * description 	: Retreive the referral commission for each publisher
     * *****************************/
    function retreive_affiliate_id($pub_acc_id = FALSE)
    {
        if ($pub_acc_id) {
            $query = $this->db->select('affiliateid')->get_where('ox_affiliates', array(
                'account_id' => $pub_acc_id
            ));
            if ($query->num_rows() > 0) {
                $result = $query->row_array();
                return $result['affiliateid'];
            } else {
                return FALSE;
            }
            
        } else {
            return FALSE;
        }
    }
    
    /******************************
     * Method 		: retreive_count_invoices
     * @params		: None
     * @return		: Count should be returned
     * description 	: Retreive the count of the invoice generation
     * *****************************/
    function retreive_count_invoices()
    {
        $this->db->where('invoice_type', 'int_pub');
        $count = $this->db->count_all_results('djax_invoice_generation');
        return $count;
    }
    
    /*******************************
     * Method 		: retreive_last_invoice_generation
     * @param 		: publisher account id
     * @return 		: return payment_details on TRUE (or) FALSE
     * Description	: Retreive the overall payment details 
     * *****************************/
    function retreive_last_invoice_generation()
    {
        
        if ($this->retreive_count_invoices() > 0) {
            $this->db->select('DATE(generation_date) as last_generate_date');
            $this->db->order_by('id desc,generation_date desc');
            $query = $this->db->get_where('djax_invoice_generation', array(
                'invoice_type' => 'int_pub'
            ));
            if ($query->num_rows > 0) {
                $result = $query->row();
                return $result->last_generate_date;
            } else {
                return FALSE;
            }
        } else {
            $this->db->select('DATE(date_created) as last_generate_date');
            $this->db->order_by('user_id asc');
            $query = $this->db->get('ox_users', '1');
            if ($query->num_rows > 0) {
                $result = $query->row();
                return $result->last_generate_date;
            } else {
                return FALSE;
            }
        }
    }
    
    /**** Affiliate Functionality ****/
    //Generates Invoices Based on the specific time period
    public function generate_network_invoices($period_days = FALSE, $invoice_type = 'int_aff')
    {
        //Retreive Total payment for each network
        
        //print_r($period_days); die("sdss");
        $invoice_type = 'int_aff';
        
        
        $total_nw_list = $this->retreive_network_list();
        
        
        $sql = "SELECT * FROM " . TAB_APP_CONFIG . " WHERE agency_id=1 AND config_key IN('aff_invoice_period','aff_min_amount_invoice')  ";
        
        $query = $this->db->query($sql);
        
        $app_config = $query->result_array();
        
        $period_days = $period_days ? $period_days : $app_config[1]['config_value'];
        
        
        
        //Period Days
        //Retreive the minimum network payments
        $min_nw_share = $app_config[0]['config_value'];
        
        //invoice generation count
        $i = 0;
        foreach ($total_nw_list as $network) {
            //Retreive network manager details
            $nw_mngr_acc_id = $network->manager_account_id;
            
            $agencyid = $network->agency_id;
            
            $manager_share      = $network->manager_share;
            $nw_acc_id          = $network->network_account_id;
            $manager_account_id = $network->manager_account_id;
            $user_name          = $network->name;
            $user_email         = $network->email;
            
            $start_date    = $network->start_date;
            $end_date      = date('Y-m-d');
            $end_date_hour = date('Y-m-d H:i:s');
            
            $start_diff        = strtotime($network->start_date);
            $end_diff          = strtotime(date('Y-m-d H:i:s'));
            $difference        = $end_diff - $start_diff;
            $days              = floor($difference / (60 * 60 * 24));
            //Retreive the overall payment details for the specific invoice
            $total_aff_payment = $this->retreive_aff_payment_details($agencyid, $nw_acc_id, $manager_account_id, $start_date);
            
        // $min_nw_share=0.0001;
           // print_r($min_nw_share);exit;
            $admin_details_enq = $this->get_network_details();
            
            $admin_details = $admin_details_enq[0];
            
            $a_name = $admin_details['first_name'] . "-" . $admin_details['last_name'];
            
            //Check whether the overall payment is greater than config minimum payment
            if (!empty($total_aff_payment)) {
                
                //Generate invoice only minimum payment is greater than minimum publisher payment
                if ($total_aff_payment['tot_payment']->tot_amount >= $min_nw_share) {
                    
                    //$invoice_code = random_string('numeric',10);
                    //$invoice_date = date('Y-m-d H:i:s');
                    //$invoice_tot_amount =isset($total_aff_payment['revenue'])?$total_aff_payment['revenue']:0;
                    //$invoice_tot_amount=$total_aff_payment['tot_amount'];
                    //$prev_invoice_id = $total_aff_payment['invoice_id'];
                    
                    $period_days        = ($days == $period_days) ? $period_days : $days;
                    $invoice_code       = random_string('numeric', 10);
                    $invoice_end_date   = date('Y-m-d H:i:s', strtotime('-' . ' 1 days'));
                    $invoice_tot_amount = $total_aff_payment['tot_payment']->tot_amount;
                    $prev_invoice_id    = $total_aff_payment['tot_payment']->invoice_id;
                    
                    //Creates the insert variables for invoice
                    $ins_arr = array(
                        'account_id' => $nw_acc_id,
                        'invoice_code' => $invoice_code,
                        'invoice_date' => $end_date,
                        'invoice_net_amount ' => $invoice_tot_amount,
                        'invoice_status' => 0,
                        'invoice_start_date' => $start_date,
                        'invoice_end_date' => $invoice_end_date,
                        'invoice_period_days' => $period_days,
                        'nw_mngr_acc_id' => $nw_mngr_acc_id,
                        'invoice_type' => $invoice_type/* ,
                        'type' => 1 */
                    );
                    
                    
                    
                    $this->db->insert(TAB_INVOICE, $ins_arr);
                    
                    $last_invoice_id = $this->db->insert_id();
                   
                    //Inserts the invoice item into TAB_INVOICE_ITEM
                    $ins_item_arr = array();
                    
                    $ins_item_arr[] = array(
                        'invoice_id' => $last_invoice_id,
                        'item_code' => 'ERN',
                        'item_desc' => 'Earnings for the "' . $a_name . '" from period ' . date($this->default_configurations->date_format, strtotime($start_date)) . ' to ' . date($this->default_configurations->date_format, strtotime($end_date)),
                        'amount' => $total_aff_payment['tot_payment']->revenue,
                        'currency' => $this->config->item('currency')
                    );
                    if ($total_aff_payment['tot_payment']->prev_rev > 0) {
                        $ins_item_arr[] = array(
                            'invoice_id' => $last_invoice_id,
                            'item_code' => 'CRYBAL',
                            'item_desc' => "Previous Balance",
                            'amount' => $total_aff_payment['tot_payment']->prev_rev,
                            'currency' => $this->config->item('currency')
                        );
                        //print_r($ins_item_arr);
                    }
                    
                    $this->db->insert_batch(TAB_INVOICE_ITEM, $ins_item_arr);
                    
                   
                    if ($prev_invoice_id != 0) {
                        
                        
                        
                        //Cancel the previous invoice
                        $this->db->update(TAB_INVOICE, array(
                            'invoice_status' => 2
                        ), array(
                            'account_id' => $nw_acc_id,
                            'invoice_id' => $prev_invoice_id
                        ));
                    }
					
                    $admin_details_enq = $this->get_network_details();
                    
                    $admin_details = $admin_details_enq[0];
                    
                    $admin_name    = $admin_details['first_name'] . "-" . $admin_details['last_name'];
                    $admin_email   = $admin_details['email_address'];
                    $admin_address = $admin_details['company_block_no'];
                    $admin_addr    = $admin_details['company_address'];
                    $admin_number  = $admin_details['mobile_number'];
                    if ($invoice_type == "int_aff") {
                        $type = "AFF_INVOICE";
                    }
                    
                    $from = $user_email;
                    $to   = $admin_email;
                    //$to = "ramya.p@dreamajax.com";
                    
                    $mail_content = array(
                        "subject" => "Invoice",
                        "from_name" => $user_name,
                        "to_name" => $admin_name,
                        "from_email" => $user_email,
                        "address" => $admin_address . " , " . $admin_addr,
                        "number" => $admin_number,
                        "user_address" => $user_address,
                        "invoiceid" => $last_invoice_id,
                        "user_address" => $user_address,
                        "invoice_date" => $end_date,
                        "payment_terms" => $period_days,
                        "earnings_desc" => $earnings_desc,
                        "invoice_amount" => $invoice_tot_amount,
                        "invoice_start_date" => $start_date,
                        "invoice_end_date" => $invoice_end_date,
                        "invoice_code"=>$invoice_code,
						"earn_amount" => $total_aff_payment['tot_payment']->revenue,
						"prev_amt"=> $total_aff_payment['tot_payment']->prev_rev,
                        "invoice_detaits"=>array("invoice_date" => $end_date,"invoice_net_amount"=> $invoice_tot_amount),
                    );
                    
                    
                    $attachement = FALSE;
                    $bcc         = FALSE;
                    send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                    //send_mail($type, $from, $to, $mail_content, $attachement, $bcc, $invoice_type);
                    
                }
                
            }
        }
        
        
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        
        return TRUE;
    }
    
    
    //Retreive All Network Managers List
    
    /* Affiliate 30 days Listing*/
    function retreive_network_list()
    {
        
        $query = $this->db->query("SELECT dn.agency_id,og.name,dn.manager_share,dn.network_account_id,dn.manager_account_id,IFNULL(di.invoice_date,dnt.date_added) as start_date,og.email FROM ox_agency as og
		LEFT JOIN `djax_network_managers` as dn ON dn.manager_account_id=og.account_id
		LEFT JOIN `djax_networks` as dnt ON dnt.account_id=dn.manager_account_id  
		LEFT JOIN `djax_invoice` as di ON di.account_id=og.account_id where manager_account_id!=2 
		ORDER BY `agency_id` ");
        
        if ($query->num_rows() > 0) {
            $result = $query->result();
            return $result;
        } else {
            
            return FALSE;
        }
    }
     function retreive_aff_last_invoice_generate_details($aff_acc_id = FALSE)
    {
        
        $this->db->select('DATE(invoice_date) as last_generate_date,invoice_start_date,invoice_end_date');
        $this->db->order_by('invoice_id desc,invoice_date desc');
        
        if ($aff_acc_id) {
            $query = $this->db->get_where('djax_invoice', array(
                'account_id' => $aff_acc_id
            ));
        } else {
            $query = $this->db->get('djax_invoice');
        }
        
        
        if ($query->num_rows > 0) {
            $result = $query->row();
            if($result->invoice_status ==0 || $result->invoice_status ==2)
            {
				return $result->invoice_start_date;
			}
			else
			{
				
				return $result->invoice_end_date;
			}	
        } else {
            return FALSE;
        }
    }
    
    /* Affiliate 30 days Listing*/
    
    function retreive_aff_last_invoice_generate_date($aff_acc_id = FALSE)
    {
        
        $this->db->select('DATE(invoice_date) as last_generate_date');
        $this->db->order_by('invoice_id desc,invoice_date desc');
        
        if ($aff_acc_id) {
            $query = $this->db->get_where('djax_invoice', array(
                'nw_mngr_acc_id' => $aff_acc_id
            ));
        } else {
            $query = $this->db->get('djax_invoice');
        }
        
        
        if ($query->num_rows > 0) {
            $result = $query->row();
            return $result->last_generate_date;
        } else {
            return FALSE;
        }
    }
    //Retreive All Network Managers Revenue List
    function retreive_aff_payment_details($agencyid, $nw_acc_id, $manager_acc_id, $start_date)
    {
        
        // $start_date=$this->retreive_aff_last_invoice_generate_date($manager_acc_id);
        if ($nw_acc_id) {
            $overall_aff_payment_details = array();
            
            $tot_payment_sql = "SELECT accountid,agency_id,SUM(revenue) as revenue,SUM(prev_bal) as prev_rev,(SUM(revenue) + SUM(prev_bal)) as tot_amount,invoice_id 
								FROM 
								((SELECT dnm.manager_account_id as accountid,dnm.agency_id,dns.admin_revenue as revenue,0 as prev_bal,di.invoice_id as invoice_id 
								FROM djax_network_stats as dns
								JOIN djax_network_managers as dnm ON dnm.agency_id=dns.agency_id
								LEFT JOIN djax_invoice as di ON (di.nw_mngr_acc_id=dnm.manager_account_id AND di.invoice_status=0)
								WHERE dnm.manager_account_id=$manager_acc_id";
            
            if (isset($start_date) && !empty($start_date)) //zone_id
                {
                $tot_payment_sql .= " AND DATE(date_time) BETWEEN 'DATE($start_date)' AND DATE_SUB(CURDATE(),INTERVAL 1 DAY)";
            } else {
                
                $tot_payment_sql .= " AND DATE_SUB(CURDATE(),INTERVAL 1 DAY)>= DATE(date_time)";
            }
            $tot_payment_sql .= "  
			                       
								  ORDER BY DATE(date_time) DESC)
								  UNION
								  (SELECT djin.nw_mngr_acc_id as accountid,oxag.agencyid as agency_id,0 as revenue,djin.invoice_net_amount as prev_bal,djin.invoice_id as invoice_id
								  FROM " . TAB_INVOICE . " as djin
								  JOIN ox_agency as oxag ON oxag.account_id = djin.nw_mngr_acc_id
								  WHERE djin.invoice_status=0 AND djin.nw_mngr_acc_id= $manager_acc_id 
								  ORDER BY djin.invoice_date DESC LIMIT 1)) as final GROUP BY accountid HAVING final.accountid IS NOT NULL";
            
            
            //print_r($tot_payment_sql); exit;
           
            
            $tot_payment_query = $this->db->query($tot_payment_sql);
            //return $this->db->last_query();
            //echo $tot_payment_sql; exit;
            //echo $tot_payment_sql; exit;
            if ($tot_payment_query->num_rows() > 0) {
                $tot_payment_result                         = $tot_payment_query->row();
                $overall_aff_payment_details['tot_payment'] = $tot_payment_result;
            } else {
                $tot_payment                                = 0;
                $overall_aff_payment_details['tot_payment'] = 0;
            }
            
            return $overall_aff_payment_details;
            
        } else {
            return FALSE;
        }
        
        
        
    }
    
    /******************************
     * Method 		: retreive_aff_count_invoices
     * @params		: None
     * @return		: Count should be returned
     * description 	: Retreive the count of the invoice generation
     * *****************************/
    function retreive_aff_count_invoices()
    {
        $this->db->where('invoice_type', 'int_aff');
        $count = $this->db->count_all_results('djax_invoice_generation');
        return $count;
    }
    
    function retreive_last_aff_invoice_generation()
    {
        
        if ($this->retreive_aff_count_invoices() > 0) {
            $this->db->select('DATE(generation_date) as last_generate_date');
            $this->db->order_by('id desc,generation_date desc');
            $query = $this->db->get_where('djax_invoice_generation', array(
                'invoice_type' => 'int_aff'
            ));
            if ($query->num_rows > 0) {
                $result = $query->row();
                return $result->last_generate_date;
            } else {
                return FALSE;
            }
        } else {
            $this->db->select('DATE(date_created) as last_generate_date');
            $this->db->order_by('user_id asc');
            $query = $this->db->get('ox_users', '1');
            if ($query->num_rows > 0) {
                $result = $query->row();
                return $result->last_generate_date;
            } else {
                return FALSE;
            }
        }
    }
}
