<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Do_creative extends CI_Model

{

	/*
     * 
     * name: fetch_advertiser
     * @param :
     * @return : $result
     * 
	 * on : dec-12-2016
     */
    function fetch_advertiser($banner_id)
    {
        $SQL = "SELECT a.clientid,b.account_id,c.campaignid
				FROM 
					" . TAB_CAMPAIGNS . " as a,
					" . TAB_CLIENTS . " as b,
					" . TAB_BANNERS . " as c
				WHERE 
					 a.dj_is_deleted =0 AND c.bannerid=$banner_id 
					 AND
					 c.campaignid = a.campaignid
					 AND
					a.clientid = b.clientid 
				";
			
        $query = $this->db->query($SQL);

        $result = $query->result_array();
        
        if ($result)
            return $result;
        else
            return FALSE;
    }   



	 /*

	 * 

	 * name: fetch

	 * @param :

	 * @return : $result

	 * 

	 * Lists all the web creative of an advertiser

	 */

	function fetch($account_id,$campaign_id=FALSE)
	{
		 $SQL = "SELECT oxb.bannerid,oxb.campaignid,oxc.campaignname,oxb.description,oxb.filename,oxb.storagetype,oxb.dj_banner_type,oxb.url,oxb.dj_added_date as dj_added_date,oxb.dj_admin_approve,oxb.imageurl,oxbe.vast_video_clickthrough_url,oxb.width,oxb.height,

				CASE

					WHEN oxb.`dj_banner_type` = 'W_IMG'  THEN 'Image creative'

					WHEN oxb.`dj_banner_type` = 'W_URL' THEN 'URL creative'

					WHEN oxb.`dj_banner_type` = 'W_SQL'  THEN 'Database creative'

					WHEN oxb.`dj_banner_type` = 'W_HTML'  THEN 'HTML creative'

					WHEN oxb.`dj_banner_type` = 'V_IN'  THEN 'Inline video creative'

					WHEN oxb.`dj_banner_type` = 'V_OL'  THEN 'Overlay video creative'
					
					WHEN oxb.`dj_banner_type` = 'MV_IN'  THEN 'Inline video creative'
					
					WHEN oxb.`dj_banner_type` = 'MV_OL'  THEN 'Overlay video creative'
					
					WHEN oxb.`dj_banner_type` = 'MV_IR'  THEN 'Interstital  video creative'
					
					WHEN oxb.`dj_banner_type` = 'MC_IMG'  THEN 'Image creative'

					WHEN oxb.`dj_banner_type` = 'M_MR_INT'  THEN 'Interstital creative'

					WHEN oxb.`dj_banner_type` = 'M_MR_EXP'  THEN 'Expand creative'

					WHEN oxb.`dj_banner_type` = 'M_MR_REV'  THEN 'Reveal creative'

					WHEN oxb.`dj_banner_type` = 'M_RS_FS'  THEN 'Filmstrip creative'

					WHEN oxb.`dj_banner_type` = 'M_RS_FL'  THEN 'Flex creative'

					WHEN oxb.`dj_banner_type` = 'M_RS_PL'  THEN 'Pull creative'

					WHEN oxb.`dj_banner_type` = 'M_RS_ADH'  THEN 'Adhesion creative'

					WHEN oxb.`dj_banner_type` = 'M_RS_SL'  THEN 'Slider creative'

					WHEN oxb.`dj_banner_type` = 'M_IMG'  THEN 'Image creative'

					WHEN oxb.`dj_banner_type` = 'M_TEXT'  THEN 'Text creative'

					WHEN oxb.`dj_banner_type` = 'W_TEXT'  THEN 'Text creative'

					WHEN oxb.`dj_banner_type` = 'W_SWF'  THEN 'Flash creative'

				END as creative_type
				
				FROM 

					".TAB_BANNERS." AS oxb
				LEFT JOIN ".TAB_BAN_VAST_ELE." AS oxbe ON oxb.bannerid=oxbe.banner_id
				JOIN ".TAB_CAMPAIGNS." as oxc ON oxc.campaignid=oxb.campaignid				
				
				WHERE 

					 oxb.dj_is_deleted =0 AND dj_account_id='$account_id'";
		
		//to fetch creatives from specific campaigns
		if($campaign_id)
		 $SQL .= " AND oxc.campaignid='$campaign_id'";
		 
		 $SQL .= " ORDER BY oxb.dj_added_date" ;

		$query = $this->db->query($SQL);

		$result = $query->result_array();

		if($result){

             $result=array_map('callbackformat',$result);
            
			return $result;
              }
		else
		{
			return FALSE;
		}
	}

	 /*

	 * 

	 * name: fetch_creative

	 * @param :

	 * @return : $result

	 * 

	 * Lists a web creative of an advertiser

	 */

	 function fetch_creative($creative_id=false)

	 {

		if($creative_id)

		{

			$this->db->select('contenttype,bannerid,campaignid,description,filename,storagetype,url,width,height,imageurl,bannertext,htmltemplate,dj_banner_type,dj_admin_approve,keyword,html5');		

			$this->db->where('bannerid ',$creative_id);

			$this->db->where('dj_is_deleted ','0');
			
			//$this->db->where('dj_admin_approve !=','-1'); // commented by karthika on dec-1

			$this->db->order_by('dj_added_date ');

			$query = $this->db->get(TAB_BANNERS);		

			$result = $query->result_array();

			if($result)

				return $result;

			else

				return FALSE;

		}

		else

			return FALSE;

		

	}

	 /*

	 * 

	 * name: fetch_creative_dependiences

	 * @param :

	 * @return : $result

	 * 

	 * Lists a creative dependiences if exist

	 */

	 function fetch_creative_dependiences($creative_id=false)

	 {

		if($creative_id)

		{

			$this->db->select('file_path,content_type');		

			$this->db->where('banner_id ',$creative_id);

			$query = $this->db->get(TAB_BAN_DEPEND);



			$result = $query->result_array();

			if($result)

				return $result;

			else

				return FALSE;

		}

		else

			return FALSE;

		

	}

	 /*

	 * 

	 * name: fetch_creative_approval_type

	 * @param :

	 * @return : $result

	 * 

	 * Says what type of approval is set in the application 

	 */

	 function fetch_creative_approval_type()

	 {

			$this->db->select('config_value as creative_approval_type');		
			$this->db->where('config_key','creative_approval_type');
			$this->db->where('agency_id',get_session('agencyid'));
			$query = $this->db->get(TAB_APP_CONFIG);

			$result = $query->result_array();

			if($query->num_rows()>0)

				return $result[0]['creative_approval_type'];

			else

				return FALSE;

	}

	 /*

	 * 

	 * name: delete_creative

	 * @param : creative_id

	 * @return : $result

	 * 

	 * Delete the creative

	 */

	 function delete_creative($creative_id=false)

	 {

		if($creative_id)

		{

			$this->db->trans_start();

			

			$this->db->where('bannerid',$creative_id); 

			$this->db->update(TAB_BANNERS,array('dj_is_deleted'=>'1'));

			

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
			}
			else
			{
				$this->db->where('ad_id', $creative_id);
				$this->db->delete(TAB_AD_ZONE_ASSOC);
				$this->db->trans_commit();
			}
		}

		else

			return FALSE;

		

	}

	/*

	 * 

	 * name: fetch_campaign

	 * @param :

	 * @return : $result

	 * 

	 * Lists a campaign of an advertiser

	 */

	 function fetch_campaign($account_id,$campaign_type=false)

	 {
		$type = array($campaign_type,"CROSS");
	 	$this->db->select('oxc.campaignid, oxc.campaignname');

		$this->db->join(TAB_CLIENTS.' as oxcl', 'oxcl.clientid=oxc.clientid AND oxcl.dj_is_deleted=0');
			
		$this->db->join(TAB_AGENCY.' as oxa', 'oxa.agencyid=oxcl.agencyid');	

		$this->db->where('oxc.dj_is_deleted ','0');
		$this->db->where_not_in('oxc.status','3');//added for completed campaign
		

		if($account_id)

			$this->db->where('oxcl.account_id', $account_id);

		if($campaign_type)

			$this->db->where_in('oxc.dj_targetting_type', $type);

		

		$this->db->order_by('oxc.dj_added_date ');

		$query = $this->db->get(TAB_CAMPAIGNS.' as oxc');

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}
	 function fetch_campaign_creative($account_id,$campaign_type=false)

	 {
		$type = array($campaign_type,"CROSS");
	 	$this->db->select('oxc.campaignid, oxc.campaignname');

		$this->db->join(TAB_CLIENTS.' as oxcl', 'oxcl.clientid=oxc.clientid AND oxcl.dj_is_deleted=0');
			
		$this->db->join(TAB_AGENCY.' as oxa', 'oxa.agencyid=oxcl.agencyid');	

		$this->db->where('oxc.dj_is_deleted ','0');
		$this->db->where_not_in('oxc.status','3');//added for completed campaign
		

		if($account_id)

			$this->db->where('oxcl.account_id', $account_id);

		if($campaign_type)

			$this->db->where_in('oxc.dj_targetting_type', $type);
			//~ $this->db->where_in('oxc.bidding_type', '0');

		

		$this->db->order_by('oxc.dj_added_date ');

		$query = $this->db->get(TAB_CAMPAIGNS.' as oxc');

		$result = $query->result_array();
		//~ return $this->db->last_query();
		if($result)

			return $result;

		else

			return FALSE;

	}

	
	
	public function fetch_creative_by_approve($approve_status='NAPPROVE',$agency_id,$adv_account_id=FALSE)
    {  

	
		if($approve_status === 'NAPPROVE'){
			$admin_approve = 0;
		}
		else if($approve_status === 'APPROVED_TODAY')
		{
			$admin_approve = 1;
			$date = date("Y-m-d");
		}
		 
		$SQL = "
				SELECT oxb.`dj_added_date` as last_create_date, (
						SELECT count(*) FROM 
							".TAB_BANNERS." as oxb
							JOIN ".TAB_CAMPAIGNS." as oxc ON oxb.campaignid=oxc.campaignid
							JOIN ".TAB_CLIENTS." as oxcl ON oxcl.account_id=oxb.dj_account_id
						WHERE
						oxcl.agencyid={$agency_id} ";
						
		if($adv_account_id != FALSE){
			$SQL .= "  AND oxcl.account_id = {$adv_account_id}"; 
		}		
		
		if($approve_status === 'APPROVED_TODAY'){
			$SQL .= " AND DATE(oxb.dj_approved_date)='".$date."'";
		}
				
								
		$SQL .= "  AND oxb.`dj_admin_approve`={$admin_approve} AND 
						oxb.`dj_is_deleted` != 1
					) as banner_count 
				FROM 
					".TAB_BANNERS." as oxb
					JOIN ".TAB_CAMPAIGNS." as oxc ON oxb.campaignid=oxc.campaignid
					JOIN ".TAB_CLIENTS." as oxcl ON oxcl.account_id=oxb.dj_account_id
				WHERE
					oxcl.agencyid={$agency_id}	";
		
		if($adv_account_id != FALSE){
			$SQL .= "  AND oxcl.account_id = {$adv_account_id}"; 
		}		
		
		if($approve_status === 'APPROVED_TODAY'){
			$SQL .= " AND DATE(oxb.dj_approved_date)='".$date."'";
		}	
		
		$SQL  .= "	AND oxb.`dj_admin_approve`={$admin_approve} AND
					  oxb.`dj_is_deleted` != 1 ";
					
		$SQL .= " ORDER BY 
					oxb.`dj_added_date` DESC LIMIT 0,1";
					
	
	  $query = $this->db->query($SQL);

	  $result=$query->result_array(); 

		 if($result)
		{			

			return $result[0];

		}

		else

		{

			return FALSE;

		}	

	}
	

	/*

	* 

	* name: fetch_all_creative

	* @param : 

	* @return :$result

	* 

	* Fetch details of creatives

	*/ 

	

	public function fetch_all_creative($agency_id)

    {  

      $this->db->select('tb.bannerid,tb.description,tb.filename,tb.url,tb.width,tb.height,tb.imageurl,tb.dj_account_id,tu.contact_name,tu.email_address,tb.storagetype,tb.dj_banner_type');

	  $this->db->where('tb.dj_admin_approve',0);
	  
	  $this->db->where('tb.dj_is_deleted',0);
	  
	  $this->db->where('ta.agencyid',$agency_id);
	  
	  //$this->db->where('dj_admin_approve !=','-1');

	  $this->db->from(TAB_BANNERS .'as tb');

	  $this->db->join(TAB_USERS .' as tu','tu.default_account_id=tb.dj_account_id');
	  
	  $this->db->join(TAB_CLIENTS .' as tc','tc.account_id=tb.dj_account_id');
	  
	  $this->db->join(TAB_AGENCY .' as ta','ta.agencyid=tc.agencyid');

	  $this->db->order_by('tb.bannerid');

	  $query = $this->db->get();

	  $result=$query->result_array(); 
     
	  if($result)

		{			

			return $result;

		}

		else

		{

			return FALSE;

		}	

	}

	   

   /*

	* 

	* name: approve_creative

	* @param : banner_id

	* @return : TRUE or FALSE

	* 

	* Approve the creative

	*/  

	

	public function approve_creative($banner_id=FALSE)

	{

	  $data=array(

	               'dj_admin_approve'=>1,

				    'dj_approved_date'=>date('Y-m-d H:i:s')

		     ); 

	  $this->db->where('bannerid', $banner_id);
	  $this->db->update(TAB_BANNERS, $data);
	  if($this->db->affected_rows()>0){
        $this->db->select('*');
		$this->db->where('bannerid',$banner_id);
		$query=$this->db->get(TAB_BANNERS);
		$result=$query->result_array();
	    return $result[0];
	   }

	    else{

			return FALSE;	

		}

	}

   	public function approve_all_creative($banner_ids=FALSE)

	{
		
	  $data=array(

	               'dj_admin_approve'=>1,

				    'dj_approved_date'=>date('Y-m-d H:i:s')

		     ); 

	  $this->db->where_in("bannerid",$banner_ids);
	  $this->db->update(TAB_BANNERS, $data);
	  
	 
	  
	  
	  if($this->db->affected_rows()>0){
        $this->db->select('*');
		$this->db->where_in("bannerid",$banner_ids);
		$query=$this->db->get(TAB_BANNERS);
		
		
		$result=$query->result_array();
		
	    return $result;
	   }

	    else{

			return FALSE;	

		}

return false;
	}
   

   /*

	* 

	* name: reject_creative

	* @param : banner_id

	* @return : TRUE or FALSE

	* 

	* Reject the creative

	*/

	

	public function reject_creative($banner_id=FALSE)

	{

	  $data=array(

	               'dj_admin_approve'=>-1,

				    'dj_approved_date'=>date('Y-m-d H:i:s')

		     ); 

	  

	  $this->db->where('bannerid', $banner_id);

      

	  $this->db->update(TAB_BANNERS, $data);

	  

	  if($this->db->affected_rows()>0){
        $this->db->select('*');
		$this->db->where('bannerid',$banner_id);
		$query=$this->db->get(TAB_BANNERS);
		$result=$query->result_array();
	    return $result[0];
       }

	    else{

			return FALSE;	

		}

    }



   /*
	* name: awaiting status 
	* @param : banner_id
	* @return : TRUE or FALSE
	*/
	public function edit_approve_creative($banner_id=FALSE,$dj_admin_approve=FALSE)
	{
	  $data=array(
				'dj_admin_approve'=>$dj_admin_approve,
				'dj_approved_date'=>date('Y-m-d H:i:s')
		     ); 
	  $this->db->where('bannerid', $banner_id);
	  $this->db->update(TAB_BANNERS, $data);

	  if($this->db->affected_rows()>0){
        $this->db->select('*');
		$this->db->where('bannerid',$banner_id);
		$query=$this->db->get(TAB_BANNERS);
		$result=$query->result_array();
	    return $result[0];
       }else{
			return FALSE;	
		}
    }

  

   /*

	* 

	* name: reject_creative

	* @param : banner_id

	* @return : TRUE or FALSE

	* 

	* Reject the creative

	*/

	

	public function reject_all_creative($banner_id=FALSE)

	{

	  $data=array(

	               'dj_admin_approve'=>-1,

				    'dj_approved_date'=>date('Y-m-d H:i:s')

		     ); 

	  

	  $this->db->where_in('bannerid', $banner_id);

      

	  $this->db->update(TAB_BANNERS, $data);

	  

	  if($this->db->affected_rows()>0){
        $this->db->select('*');
		$this->db->where_in('bannerid',$banner_id);
		$query=$this->db->get(TAB_BANNERS);
		$result=$query->result_array();
		return $result;
       }

	    else{

			return FALSE;	

		}

    }
    
    

	
       /*

	* 

	* name: is_creative_id

	* @param : banner_id

	* @return : TRUE or FALSE

	* Check the banner is approved / rejected previously 
	
	*/  

	

	public function is_creative_id($banner_id=FALSE)
	{

	  $query=$this->db->get_where(TAB_BANNERS,array('dj_admin_approve'=>0,'bannerid'=>$banner_id));
	  if($query->num_rows>0)
	  {
	    return TRUE;
	  }
	  else
	  {
	    return FALSE;
	  }

	}
	
	
	
   

	
	
	
	
	
	/*

	* 

	* name: preview_creative

	* @param : banner_id

	* @return :creative details->creativename,width,height etc..

	* 

	*/

	public function preview_creative($banner_id=FALSE){

   		$this->db->select('contenttype,storagetype,dj_banner_type,imageurl,description,dj_added_date,width,height,weight,filename,bannertext,url,htmltemplate');

	    $this->db->where('bannerid',$banner_id);

        $query = $this->db->get(TAB_BANNERS);

		$result=$query->result_array(); 

		if($result){

			$check_width	=	$result['0']['width'];
			$content_type	=	$result['0']['contenttype'];
			$banner_type	=   $result['0']['dj_banner_type'];

    		if($check_width=='-3' || $check_width=='-2' || $check_width=='-4')
    		{
			$this->db->select('tbv.vast_creative_type,tb.contenttype,tb.url,tb.description,tb.dj_added_date,tb.dj_banner_type,tb.width,tb.height,tb.weight,tb.filename,tbv.vast_video_outgoing_filename as video_filename,tbv.vast_overlay_text_description as text_description,tbv.vast_overlay_format as overlay_format,tbv.vast_video_delivery,tbv.vast_video_clickthrough_url');

				$this->db->where('bannerid',$banner_id);

				$this->db->from(TAB_BANNERS.' as tb');

				$this->db->join(TAB_BAN_VAST_ELE.' as tbv','tbv.banner_id=tb.bannerid');

				$query 	= 	$this->db->get();
                
				$result	=	$query->result_array();
				return $result;

			}

			elseif($check_width==0 && $content_type!="txt")

			{

				$this->db->select('tb.description,tb.url,tb.dj_banner_type,tb.dj_added_date,tbd.width,tbd.height,tb.weight,tbd.file_path as filename,tbd.content_type as contenttype');

				$this->db->where('bannerid',$banner_id);

				$this->db->from(TAB_BANNERS.' as tb');

				$this->db->join(TAB_BAN_DEPEND.' as tbd','tb.bannerid=tbd.banner_id');

				$query 	= 	$this->db->get();
                
				$result	=	$query->result_array();

				return $result;

			}
			elseif($check_width=='-6' || $check_width=='-6')
			{
			
					$this->db->select('tb.description,tb.contenttype,tb.url,tb.dj_banner_type,tb.dj_added_date,tb.width,tb.height,tb.weight,tb.filename as video_filename,');

				$this->db->where('bannerid',$banner_id);

				$this->db->from(TAB_BANNERS.' as tb');

				

				$query 	= 	$this->db->get();
                    log_message($this->db->last_query());
				$result	=	$query->result_array();

				return $result;
			}
           //interstital video creative 

			else

			{			

				return $result;

			}

		}

		else

		{

			return FALSE;

		}

	}

	

	/*

	 * 

	 * name: fetch_video

	 * @param :

	 * @return : TRUE (or) FALSE

	 * 

	 * Get the video creative from the database

	 */

	

	function fetch_video_creatives($account_id)

	{	

		if($account_id)

		{	

			/*Get records from ox_banner_vast_element */

			$this->db->where('dj_account_id',$account_id);

			$this->db->where('dj_is_deleted',0);

			$this->db->where_in('dj_banner_type',array(VIDEO_CREATIVE_OVERLAY,VIDEO_CREATIVE_INLINE));

			$query	=	$this->db->get(TAB_BANNERS);

			$result	=	$query->result_array();

			//echo $this->db->last_query();

			if($result)

				return $result;

			else

				return FALSE;

		}

		else

			return FALSE;

	

	}

 	public function geofencing_fetch($campaignid=false)
	{
		$this->db->select('lat,lng,radius');
		$this->db->where('campaign_id',$campaignid);
		$query=$this->db->get('geogencing');
		$result=$query->result_array();
		
		if($result)
		{
			return $result;
		}else
		{
			return false;
		}

	}

	public function geofencing_add($campaignid=false,$circles=array())
	{
		$this->db->where('campaign_id', $campaignid);
		$this->db->delete('geogencing'); 

		foreach ($circles as $circle) {
			$circle['campaign_id']=$campaignid;
			$this->db->insert('geogencing',$circle);
			
		}
		if($this->db->insert_id())
		{
			return $this->db->insert_id(); 
		}else
		{
			return false;
		}

	}

	

	
    



}
