<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Do_campaign extends CI_Model
{
    /*
     * name: fetch_type
     * @param
     * @return
     *
     * This method get list of campaign type
     * 
     */
    
    function fetch_type($type_value=NULL,$advertiser_geo=NULl)
    {
        $geo_fencing=$this->default_configurations->get('geo_fencing');

        $this->db->select('revenue_type as campaign_type_name,revenue_type_value  as campaign_type_value');
        $this->db->where('status', '1');
        if($type_value == 1 && $type_value!=NULL)
        {
            if($geo_fencing=='Disable' || $advertiser_geo == 0 ){
    			$this->db->where('revenue_type_value', '1');
            } else {
                $this->db->where_in('revenue_type_value',array(1,4));
            }
            
		}
        
        if($geo_fencing=='Disable'){
             $this->db->limit(3);
        }else
        {   

            if($advertiser_geo==0)
                $this->db->limit(3);
            else
                $this->db->limit(4);
        }
        $query  = $this->db->get(TAB_CONF_REVENUE_TYPE);
       // return $this->db->last_query(); exit();
        $result = $query->result_array();
        if ($result)
            return $result;
        else
            return FALSE;

    }
    
    /*
     * name: add_new_campaign
     * @param
     * @return
     *
     * This method creates a new campaign for
     * the advretiser
     * 
     */
    
    function add_new_campaign($camapign_data, $client_id)
    {
        
        if ($camapign_data AND $client_id) {
            
            $this->db->trans_start();
            
            $this->db->insert(TAB_CAMPAIGNS, $camapign_data);
            
            $campaign_id = $this->db->insert_id();
            
            
            //Create trackers for a campaign
            $tracker_data = array(
                "trackername" => $camapign_data['campaignname'] . '_tracker',
                "clientid" => $camapign_data['clientid'],
                "updated" => $camapign_data['dj_added_date']
            );
            $this->db->insert(TAB_TRACKERS, $tracker_data);
            $tacker_id            = $this->db->insert_id();
            $tracker_mapigng_data = array(
                "campaignid" => $campaign_id,
                "trackerid" => $tacker_id
            );
            $this->db->insert(TAB_CAM_TRACKERS, $tracker_mapigng_data);
            
            
            $this->db->trans_complete();
            
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return FALSE;
            } else {
                $this->db->trans_commit();
                return $campaign_id;
            }
        } else
            return FALSE;
    }
    
    /*
     * name: fetch_linked_creative
     * @param
     * @return
     *
     * In this method will fetch all the creatives linked to given campaign id
     * 
     */
    
    function fetch_linked_creative($campaign_id)
    {
        
        if ($campaign_id) {
            $SQL = "SELECT bannerid,campaignid,description,filename,storagetype,dj_banner_type,url,dj_admin_approve,imageurl,
					CASE
						WHEN `dj_banner_type` = 'W_IMG'  THEN 'Image creative'
						WHEN `dj_banner_type` = 'W_URL' THEN 'URL creative'
						WHEN `dj_banner_type` = 'W_SQL'  THEN 'Database creative'
						WHEN `dj_banner_type` = 'W_HTML'  THEN 'HTML creative'
						WHEN `dj_banner_type` = 'V_IN'  THEN 'Inline video creative'
						WHEN `dj_banner_type` = 'V_OL'  THEN 'Overlay video creative'
						WHEN `dj_banner_type` = 'MV_IN'  THEN 'Mobile Inline video creative'
						WHEN `dj_banner_type` = 'MC_IMG' THEN 'Companion creative'	
						WHEN `dj_banner_type` = 'MV_OL'  THEN 'Mobile Overlay video creative'
						WHEN `dj_banner_type` = 'MV_IR'  THEN 'Interstital Video creative'
						WHEN `dj_banner_type` = 'M_MR_INT'  THEN 'Interstital creative'
						WHEN `dj_banner_type` = 'M_MR_EXP'  THEN 'Expand creative'
						WHEN `dj_banner_type` = 'M_MR_REV'  THEN 'Reveal creative'
						WHEN `dj_banner_type` = 'M_NAT_VID'  THEN 'Mobile Native video creative'
						WHEN `dj_banner_type` = 'M_RS_FS'  THEN 'Filmstrip creative'
						WHEN `dj_banner_type` = 'M_RS_FL'  THEN 'Flex creative'
						WHEN `dj_banner_type` = 'M_RS_PL'  THEN 'Pull creative'
						WHEN `dj_banner_type` = 'M_RS_ADH'  THEN 'Adhesion creative'
						WHEN `dj_banner_type` = 'M_RS_SL'  THEN 'Slider creative'
						WHEN `dj_banner_type` = 'M_IMG'  THEN 'Image creative'
						WHEN `dj_banner_type` = 'M_TEXT'  THEN 'Text creative'
						WHEN `dj_banner_type` = 'W_TEXT'  THEN 'Text creative'
						WHEN `dj_banner_type` = 'W_SWF'  THEN 'Flash creative'
						WHEN `dj_banner_type` = 'W_S_P_V'  THEN 'Sidepopup video creative'
						WHEN `dj_banner_type` = 'W_300_250_V_U'  THEN '300x250 video creative'
						WHEN `dj_banner_type` = 'M_S_P_V'  THEN 'Mobile Sidepopup video creative'
						WHEN `dj_banner_type` = 'M_300_250_V_U'  THEN 'Mobile 300x250 video creative'
                        WHEN `dj_banner_type` = 'MV_RW' THEN 'Rewarded creative'
                        WHEN `dj_banner_type` = 'MV_CP' THEN 'Pause video creative'
                        WHEN `dj_banner_type` = 'M_NAT_IMG' THEN 'Mobile native image creative'
 					END as creative_type

					FROM 
						" . TAB_BANNERS . "
					WHERE  dj_is_deleted =0 AND dj_admin_approve != '-1' AND campaignid=$campaign_id";
            
            
            
            $SQL .= " ORDER BY dj_added_date";
            
            $query = $this->db->query($SQL);
            
            $result = $query->result_array();
            
            
            if ($result)
                return $result;
            else
                return FALSE;
        } else
            return FALSE;
    }
    /*
     * name: add_campaign_creative_assoc
     * @param
     * @return
     *
     * This method links the campaign to the creative
     * 
     */
    
    function add_campaign_creative_assoc($campaign_id, $creative_ids)
    {
        if ($campaign_id AND $creative_ids) {
            $this->db->trans_start();
            
            foreach ($creative_ids as $creative_id) {
                //CHECK IF ALREADY EXIST
                $this->db->select('ban_camp_assoc_id');
                $this->db->where('banner_id', $creative_id);
                $this->db->where('campaign_id', $campaign_id);
                $query = $this->db->get(TAB_BAN_CAM_ASSOC);
                
                if ($query->num_rows() > 0) {
                    $result = $query->result_array();
                    
                    if ($result) {
                        $this->db->where('banner_id', $creative_id);
                        $this->db->where('campaign_id', $campaign_id);
                        $this->db->delete(TAB_BAN_CAM_ASSOC);
                    }
                }
                
                $camp_crative_assoc_data = array(
                    'banner_id' => $creative_id,
                    'campaign_id' => $campaign_id
                );
                $this->db->insert(TAB_BAN_CAM_ASSOC, $camp_crative_assoc_data);
            }
            
            $this->db->trans_complete();
            
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return FALSE;
            } else {
                $this->db->trans_commit();
                return TRUE;
            }
        } else
            return FALSE;
    }
    /*
     * name: edit_campaign
     * @param
     * @return
     *
     * This method edits a campaign for
     * the advretiser
     * 
     */
    
    function edit_campaign($camapign_data, $client_id, $campaign_id)
    {
        if ($camapign_data AND $client_id AND $campaign_id) {
            $this->db->trans_start();
            
            $this->db->where('campaignid', $campaign_id);
            $this->db->update(TAB_CAMPAIGNS, $camapign_data);
            
            $this->db->trans_complete();
           
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return FALSE;
            } else {
                $this->db->trans_commit();
                return TRUE;
                
            }
        } else
            return FALSE;
    }
    /*
     * name: complete_campaign
     * @param
     * @return
     *
     * This method edits a campaign for
     * the advretiser
     * 
     */
    
    function complete_campaign($camapign_id, $campaign_status_data)
    {
        
        if ($camapign_id AND $campaign_status_data) {
            $this->db->trans_start();
            
            $this->db->where('campaignid', $camapign_id);
            
            $this->db->update(TAB_CAMPAIGNS, $campaign_status_data);
            
            $this->db->trans_complete();
            
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return FALSE;
            } else {
                $this->db->trans_commit();
                return TRUE;
            }
        } else
            return FALSE;
    }
    
    
    /*
     * 
     * name: fetch
     * @param :
     * @return : $result
     * 
     * Lists all the Campaign of an advertiser
     */
    function fetch($account_id = false)
    {
        $SQL = "SELECT a.dj_is_rtb_campaign as rtb,a.campaignid,a.campaignname,a.dj_targetting_type,a.dj_campaign_budget,a.dj_campaign_remain_total_budget,a.status,DATE_FORMAT(a.dj_added_date,'%d-%m-%Y') as dj_added_date,
				CASE
					WHEN `dj_targetting_type` = 'WEB'  THEN 'Web campaign'
					WHEN `dj_targetting_type` = 'MOBILE' THEN 'Mobile campaign'
					WHEN `dj_targetting_type` = 'CROSS' THEN 'Cross campaign'
					
				END as formated_dj_targetting_type,
				CASE
					WHEN `status` = '1' THEN 'Running'
					WHEN `status` = '0' THEN 'Paused'
					WHEN `status` = '2' THEN 'Awaiting'
					WHEN `status` = '3' THEN 'Completed'
					WHEN `status` = '4' THEN 'Halt'
					WHEN `status` = '5' THEN 'Budget Completed'
					
				END as formated_status

				FROM 
					 " . TAB_CAMPAIGNS . " as a

				JOIN " . TAB_CLIENTS . " as b ON b.clientid=a.clientid
				
				WHERE 
					 a.dj_is_deleted =0 AND b.account_id=$account_id";
        
        $SQL .= " ORDER BY a.dj_added_date";
        
        
        $query = $this->db->query($SQL);
        
        $result = $query->result_array();
        
        
        if ($result)
        
            return $result;
        else
            return FALSE;
        
    }
    /*
     * 
     * name: delete_campaign
     * @param : creative_id
     * @return : $result
     * 
     * Delete the creative
     */
    function delete_campaign($campaign_id = false)
    {
        if ($campaign_id) {
            $this->db->trans_start();
            
            $this->db->where('campaignid', $campaign_id);
            $this->db->update(TAB_CAMPAIGNS, array(
                'dj_is_deleted' => '1'
            ));
            
            //UPDATE THE LINKED CREAIVE TOO
            
            $this->db->select('bannerid');
            $this->db->where('campaignid', $campaign_id);
            $query = $this->db->get(TAB_BANNERS);
            if ($query->num_rows() > 0) {
                $result = $query->result_array();
                
                if ($result) {
                    foreach ($result as $data_array) {
                        $this->db->where('bannerid', $data_array['bannerid']);
                        $this->db->update(TAB_BANNERS, array(
                            'dj_is_deleted' => '1'
                        ));
                    }
                }
            }
            if ($this->db->trans_status() === FALSE)
                $this->db->trans_rollback();
            else
                $this->db->trans_commit();
        } else
            return FALSE;
        
    }
    /*
     * 
     * name: camapign_status
     * @param : campaighn_id
     * @return : $result
     * 
     * run a campaign
     */
    function camapign_status($campaign_id = false, $update_data)
    {
        if ($campaign_id) {
            $this->db->trans_start();
            
            $this->db->where('campaignid', $campaign_id);
            $this->db->update(TAB_CAMPAIGNS, $update_data);
            
            if ($this->db->trans_status() === FALSE)
                $this->db->trans_rollback();
            else
                $this->db->trans_commit();
        } else
            return FALSE;
    }
    
    
    /*
     * 
     * name: fetch_campaign
     * @param :
     * @return : $result
     * 
     * Lists all the Campaign of an advertiser
     */
    function fetch_campaign($campaign_id)
    {
        $SQL = "SELECT a.clientid,a.campaignid,a.campaignname,a.dj_targetting_type,a.status,a.activate_time,a.activate_time as activate_time1,a.expire_time,a.revenue_type as revenue_type,a.session_capping as capping,a.block,a.dj_category_id,a.dj_campaign_budget,a.dj_campaign_remain_total_budget,(SELECT GROUP_CONCAT(category_name) as dsp_category_name FROM " . TAB_SITE_CATEGORIES . " WHERE FIND_IN_SET(value, a.dsp_category)) AS dsp_category_name,a.dsp_category,a.bidding_type,a.affiliate_id,a.dsplist,a.dj_campaign_budget,a.dj_daily_budget,a.revenue,a.weight,b.category_name,a.dj_is_retargeted,a.dj_max_retargetting,dj_is_rtb_campaign,dj_rtb_buyer_id,a.dj_weekly_distribute,
				CASE
					WHEN `dj_targetting_type` = 'WEB'  THEN 'Web targeting'
					WHEN `dj_targetting_type` = 'MOBILE' THEN 'Mobile targeting'
					WHEN `dj_targetting_type` = 'CROSS' THEN 'Cross campaign'
				END as formated_dj_targetting_type,
				CASE
					WHEN `status` = '1' THEN 'Running'
					WHEN `status` = '0' THEN 'Paused'
					WHEN `status` = '2' THEN 'Awaiting'
					WHEN `status` = '3' THEN 'Completed'
					WHEN `status` = '4' THEN 'Halt'
					WHEN `status` = '5' THEN 'Budget Completed'
					WHEN `status` = '6' THEN 'Daily Budget Completed'
				END as formated_status,

				CASE
					WHEN `revenue_type` = '1' THEN 'CPM'
					WHEN `revenue_type` = '2' THEN 'CPC'
					WHEN `revenue_type` = '3' THEN 'CPA'
                    WHEN `revenue_type` = '4' THEN 'GEO'
				END as formated_revenue_type

				FROM 
					" . TAB_CAMPAIGNS . " as a
				LEFT JOIN
				" . TAB_SITE_CATEGORIES . " as b ON (b.value = a.dj_category_id || b.category_id = a.dj_category_id)

				WHERE 
					 a.dj_is_deleted =0 AND a.campaignid=$campaign_id";
        
        $SQL .= " ORDER BY a.dj_added_date";
        
        
        
        $query = $this->db->query($SQL);
        
        
        
        
        
        $result = $query->result_array();
        
        if ($result)
        {
        
       foreach($result as $idx => $value)
		{
				
				$result[$idx]['activate_time'] = dateformat(strtotime($value['activate_time']));
				if($value['expire_time'])
				{
					$result[$idx]['expire_time'] = dateformat(strtotime($value['expire_time']));
				}
				
				$result[$idx]['activate_default_time'] =$value['activate_time'];
				$result[$idx]['expire_default_time'] = $value['expire_time'];
		}	
	
            return $result;
		}
        else
        {
            return FALSE;
        }
    }
    
    /*
     * 
     * name: fetch_houseads_campaign
     * @param :
     * @return : $result
     * 
     * Lists all the Campaign of an admin
     */
    function fetch_houseads_campaign($campaign_id)
    {
		
        $SQL = "SELECT a.clientid,a.campaignid,a.campaignname,a.dj_targetting_type,a.status,a.activate_time,a.expire_time,a.revenue_type as revenue_type,a.session_capping as capping,a.block,a.dj_category_id,a.dj_campaign_budget,a.dj_daily_budget,a.revenue,a.weight,a.dj_is_retargeted,a.dj_max_retargetting,a.dj_weekly_distribute,
				CASE
					WHEN `dj_targetting_type` = 'WEB'  THEN 'Web targeting'
					WHEN `dj_targetting_type` = 'MOBILE' THEN 'Mobile targeting'
					
				END as formated_dj_targetting_type,
				CASE
					WHEN `status` = '1' THEN 'Running'
					WHEN `status` = '0' THEN 'Paused'
					WHEN `status` = '2' THEN 'Awaiting'
					WHEN `status` = '3' THEN 'Completed'
					WHEN `status` = '4' THEN 'Halt'
				END as formated_status,

				CASE
					WHEN `revenue_type` = '1' THEN 'CPM'
					WHEN `revenue_type` = '2' THEN 'CPC'
					WHEN `revenue_type` = '3' THEN 'CPA'
				END as formated_revenue_type

				FROM 
					" . TAB_CAMPAIGNS . " as a

				WHERE 
					 a.dj_is_deleted =0 AND a.campaignid=$campaign_id";
        
        $SQL .= " ORDER BY a.dj_added_date";
       
        $query = $this->db->query($SQL);
        //log_message("error",$this->db->last_query());
        $result = $query->result_array();
        
        if ($result)
            return $result;
        else
            return FALSE;
        
    }
    
    /*
     * 
     * name: fetch_houseads_campaign
     * @param :
     * @return : $result
     * 
     * Lists all the Campaign of an admin
     */
    function check_houseads_campaign($campaign_id)
    {
        $SQL = "SELECT a.clientid,a.campaignid,
				CASE
					WHEN `dj_targetting_type` = 'WEB'  THEN 'Web targeting'
					WHEN `dj_targetting_type` = 'MOBILE' THEN 'Mobile targeting'
					
				END as formated_dj_targetting_type,
				CASE
					WHEN `status` = '1' THEN 'Running'
					WHEN `status` = '0' THEN 'Paused'
					WHEN `status` = '2' THEN 'Awaiting'
					WHEN `status` = '3' THEN 'Completed'
					WHEN `status` = '4' THEN 'Halt'
				END as formated_status,

				CASE
					WHEN `revenue_type` = '1' THEN 'CPM'
					WHEN `revenue_type` = '2' THEN 'CPC'
					WHEN `revenue_type` = '3' THEN 'CPA'
				END as formated_revenue_type

				FROM 
					" . TAB_CAMPAIGNS . " as a

				WHERE 
					 a.dj_is_deleted =0 AND a.campaignid=$campaign_id AND a.clientid=1";
        
        $SQL .= " ORDER BY a.dj_added_date";
        
        $query = $this->db->query($SQL);
        
        $result = $query->result_array();
        
        if ($result)
            return $result;
        
        
        else
            return FALSE;
        
    }
    

  /*
     * 
     * name: check_advertiser_campaign
     * @param :
     * @return : $result
     * added : karthika
	 * on : dec-10-2016
     */
    function check_advertiser_campaign($campaign_id)
    {
        $SQL = "SELECT a.clientid,b.account_id
				FROM 
					" . TAB_CAMPAIGNS . " as a,
					" . TAB_CLIENTS . " as b
				WHERE 
					 a.dj_is_deleted =0 AND a.campaignid=$campaign_id 
					 AND
					a.clientid = b.clientid 
				";
			
        $query = $this->db->query($SQL);

        $result = $query->result_array();
        
        if ($result)
            return $result;
        else
            return FALSE;
    }   
    
    /*
     * name: fetch_camapign_targeting
     * @param
     * @return
     *
     * This method get list of campaign targeting details
     * 
     */
    
    function fetch_camapign_targeting($where = false)
    {
		
        if ($where) {
            $this->db->select('data');
            $this->db->where($where);
            
            $query  = $this->db->get(TAB_ACLS);
            //~ return $this->db->last_query();
            $result = $query->result_array();
            if ($result)
                return $result;
            else
                return FALSE;
        } else
            return FALSE;
    }
  
    /*
     * name: fetch_campaign_tracker
     * @param
     * @return
     *
     * This method get the campaign corresponding tracker code
     * 
     */
    
    function fetch_campaign_tracker($campaign_id = false)
    {
        
        if ($campaign_id) {
            $this->db->select('trackerid');
            $this->db->where('campaignid', $campaign_id);
            
            $query  = $this->db->get(TAB_CAM_TRACKERS);
            $result = $query->result_array();
            
            if ($query->num_rows() > 0)
                return $result;
            else
                return FALSE;
        } else
            return FALSE;
    }
    /*
     * name: fetch_ssp_type
     * @param
     * @return
     *
     * This method get list of ssp type
     * 
     */
    
    function fetch_ssp_type($agency_id = false)
    {
        $this->db->select('exchange_name as ssp_type_name,exchange_id as exchangeid');
        $this->db->where('type', 'SSP');
        $this->db->where('status', '1');
        if ($agency_id != '') {
            $this->db->where('agency_id', $agency_id);
        }
        $query  = $this->db->get(TAB_PARTY_ADX);
        $result = $query->result_array();
        if ($result)
            return $result;
        else
            return FALSE;
    }
    
    
    
    
    /*
     * 
     * name: fetch
     * @param :
     * @return : $result
     * 
     * Lists all the Campaign of an advertiser
     */
    function fetch_inventory_campaign($account_id = false)
    {
        
        $acc = ($account_id) ? "a.dj_is_deleted =0 AND a.clientid != 1 AND b.dj_is_default != 1 AND b.account_id=" . $account_id : "a.dj_is_deleted =0 AND b.dj_is_default != 1 AND a.clientid != 1";
        $SQL = "SELECT a.campaignid,b.account_id,a.campaignname,a.dj_targetting_type,a.status,b.clientname,
				CASE
					WHEN `dj_targetting_type` = 'WEB'  THEN 'Web campaign'
					WHEN `dj_targetting_type` = 'MOBILE' THEN 'Mobile campaign'
					
				END as formated_dj_targetting_type,
				CASE
					WHEN `status` = '1' THEN 'Running'
					WHEN `status` = '0' THEN 'Paused'
					WHEN `status` = '2' THEN 'Awaiting'
					WHEN `status` = '3' THEN 'Completed'
					WHEN `status` = '4' THEN 'Halt'
					
				END as formated_status

				FROM 
					 " . TAB_CAMPAIGNS . " as a

				JOIN " . TAB_CLIENTS . " as b ON b.clientid=a.clientid
				
				WHERE  " . $acc;
        
        
        $SQL .= " ORDER BY a.dj_added_date";
        
        
        $query = $this->db->query($SQL);
        
        $result = $query->result_array();
        
        
        if ($result)
            return $result;
        else
            return FALSE;
        
    }
    
    /*
     * name: add_campaign_favourite
     * @param
     * @return
     *
     * This method links the campaign to the creative
     * 
     */
     function add_campaign_favourite($campaignid = false,$favourite_status=false)
	{
		if($campaignid) 
		{
			$this->db->trans_start();

			$this->db->where('campaignid',$campaignid);
			
			$this->db->update(TAB_CAMPAIGNS,$favourite_status);

			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				//return $this->db->last_query();	
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				//return $this->db->last_query();	
				return TRUE;
			}
		}
		else
			return FALSE;
		
	}
	
	function fetch_publisherslist($agency_id = false)
    {
        $this->db->select('g.site_name as publisher_name,affiliateid as pub_id,website as publisher_site, c.dj_company_name as company_name');
        if ($agency_id != '') {
            $this->db->where('agencyid', $agency_id);
        }
        $this->db->where('c.dj_is_deleted', 0);
        $this->db->where('g.is_default', 1);
        $this->db->where('c.dj_is_dsp IS NULL', null, false);
        $this->db->from('ox_affiliates as c');
        $this->db->JOIN('djax_publisher_sites as g','g.account_id=c.account_id');
        $query  = $this->db->get();
        log_message('error',$this->db->last_query());
        $result = $query->result_array();
        if ($result)
            return $result;
        else
            return FALSE;
    }
    function fetch_publishersid($agency_id = false)
    {
        $sel_id="SELECT GROUP_CONCAT( `affiliateid` ) as aff_ids FROM ".TAB_AFFILIATE." WHERE `agencyid` = $agency_id AND dj_is_deleted=0 AND dj_is_dsp IS NULL ";
        $query  = $this->db->query($sel_id);
        $result = $query->result_array();
        if ($result)
            return $result[0]['aff_ids'];
        else
            return FALSE;
    }
    
     function fetch_dsp_type($agency_id = false)
    {
        //~ Modified : Mehathaf
        //~ Date : 05/01/17
        $check_agency_admin = $this->user_authentication->agency_id;
        if($check_agency_admin == 1)
        {
            $this->db->select('exchange_name as dsp_type_name,exchange_id as exchangeid');
            $this->db->where('type', 'SSP');
            $this->db->where('status', '1');
            if ($agency_id != '') {
                $this->db->where('agency_id', $agency_id);
            }
            $query  = $this->db->get(TAB_PARTY_ADX);
            $result = $query->result_array();
        }else
        {
            
            
            $this->db->select('exchange_name as dsp_type_name,exchange_id as exchangeid');
            $this->db->where('type', 'SSP');
            $this->db->where('status', '1');
            if ($agency_id != '') {
                $this->db->where('agency_id', $agency_id);
            }
            $query  = $this->db->get(TAB_PARTY_ADX);
            $result_data = $query->result_array();
            //~ return $result_data;
            $this->db->select('blocked_exchanges');
            $this->db->where('agencyid',$check_agency_admin);
            $query_blocked_ex  = $this->db->get('ox_agency');
            $result_blocked_ex = $query_blocked_ex->result_array();
            $ex_arr = explode(',', ($result_blocked_ex[0]['blocked_exchanges']));
            foreach ($result_data as $key=>$value)
            {
                if(in_array($value['exchangeid'],$ex_arr))
                {
                
                $a[] = $value['exchangeid'];
                unset($result_data[$key]);
                }
                
            }
            
            $result =  $result_data;
            
        }
        if ($result)
            return $result;
        else
            return FALSE;
    }
    function fetch_dspid($agency_id = false)
    {
        $dspid="SELECT GROUP_CONCAT( `exchange_id` ) as exchange_ids FROM ".TAB_PARTY_ADX." WHERE `agency_id` =$agency_id";
        $query  = $this->db->query($dspid);
        $result = $query->result_array();
        if ($result)
            return $result[0]['exchange_ids'];
        else
            return FALSE;
    }
    
    /************/
    
    /*
     * 
     * name: update_domain
     * @param : domainname,domainid
     * @return : domain id
     * 
     */
    /* public function add_campaign_domain_link($campaign_id=false,$domain_link){
    
    
    
    if(!empty($domain_link)){
    $this->db->where('campaignid',$campaign_id);
    $this->db->update(TAB_CAMPAIGNS,$domain_link);
    return $campaign_id;
    }
    else
    {
    return FALSE;
    }
    
    } */
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /****************/
     function fetch_camapign_targeting_acls($where = false)
    {
        if ($where) {
            $this->db->select('*');
            $this->db->where($where);
            
            $query  = $this->db->get(TAB_ACLS);
            $result = $query->result_array();
            if ($result)
                return $result;
            else
                return FALSE;
        } else
            return FALSE;
    }
    
    function fetch_creative($campaign_id=false)
	 {
		if($campaign_id)
		{
			$this->db->select('bannerid');		
			$this->db->where('campaignid ',$campaign_id);
			$this->db->where('dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS);	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	 /*
     * name: fetch_battery_target_targeting
     * @param
     * @return
     *
     * This method get list of campaign targeting details
     * 
     */
    
    function fetch_battery_target_targeting($where = false)
    {
        if ($where) {
            $this->db->select('data');
            $this->db->where($where);
            
            $query  = $this->db->get(TAB_ACLS);
            $result = $query->result_array();
            if ($result)
                return $result;
            else
                return FALSE;
        } else
            return FALSE;
    }
    
    function fetch_campaign_custom_targeting($targ1 =false,$targ2 =false,$targ3 =false,$targ4=false)
    {
		
            $this->db->select('data');
            $this->db->where($targ1);            
            $query1  = $this->db->get(TAB_ACLS);
            $targ1 = $query1->result_array();

            $this->db->select('data');
            $this->db->where($targ2);            
            $query2  = $this->db->get(TAB_ACLS);
            $targ2 = $query2->result_array();
            
            $this->db->select('data');
            $this->db->where($targ3);            
            $query3  = $this->db->get(TAB_ACLS);
            $targ3 = $query3->result_array();
            
            $this->db->select('data');
            $this->db->where($targ4);            
            $query4  = $this->db->get(TAB_ACLS);
            $targ4 = $query4->result_array();
            
            $result = array ("custom_targ1"=>$targ1[0],"custom_targ2"=>$targ2[0],"custom_targ3"=>$targ3[0],"custom_targ4"=>$targ4[0]);
            
            if ($result)
                return $result;
            else
                return FALSE;
    }

    function fetch_campaign_geo($campaign_id)
    {
        $SQL = "SELECT * FROM geogencing WHERE campaign_id=".$campaign_id;
        $query = $this->db->query($SQL);
        $result = $query->result_array();
        if($result)
        {
            return $result;
        }
        else
        {
            return FALSE;
        }
    }
}
