<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Do_auto_link extends CI_Model
{
	
	public $agency_id='';
	
	/*
	 * 
	 * name: fetch_adblock
	 * @param :
	 * @return : $result
	 * 
	 * Lists a ad blocks
	 */
	 
	 function fetch_adblock($zone_id=false)
	 {
		if($zone_id)
		{
			$this->db->select('width,height,delivery,dj_zone_type');		
			$this->db->where('zoneid ',$zone_id);
			$this->db->where('dj_is_deleted ','0');
			$query = $this->db->get(TAB_ZONES);	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get Creatives
	 */
	 
	 function fetch_creative($creative_id=false)
	 {
		if($creative_id)
		{
			$this->db->select('width,height,dj_banner_type,campaignid');		
			$this->db->where('bannerid ',$creative_id);
			$this->db->where('dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS);	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	function link_cross_ads($zone_id=FALSE,$type=FALSE,$where=FALSE)
	{
		
		if($zone_id)
		{
			$ad_type = $this->adtype_selection($type);
			$get_campaignid = $this->get_banner_details($zone_id,$ad_type,$where);
			if($get_campaignid)
			{
			$creative_ids = array_column($get_campaignid, 'bannerid');
			$camp_ids = array_column($get_campaignid, 'campaignid');
			$del_banner = $this->banner_delete($creative_ids,$zone_id);
			$camp = $this->get_campaign_detail($zone_id);
			}
		}
	}
	function banner_delete($creative_ids=FALSE,$zone_id=FALSE)
	{
		
		$this->db->trans_start();
		$this->db->where_in('ad_id',$creative_ids);
		$this->db->where('zone_id',$zone_id);
		$this->db->delete(TAB_AD_ZONE_ASSOC);
		if ($this->db->trans_status() === FALSE)
			$this->db->trans_rollback();
		else
			$this->db->trans_commit();
			//$this->get_commoncampaign($zone_id);
	}
	function get_campaign_detail($zone_id=FALSE)
	{
		
			$this->db->select('*');		
			$this->db->where('zone_id',$zone_id);
			$query = $this->db->get(TAB_PLACE_ZONE_ASSOC);	
			$result = $query->result_array();
			if($result)
			{
				$banner = $this->get_banner_details($zone_id);
				$creative_ids = array_column($result, 'placement_id');
				$camp_ids = array_column($banner, 'campaignid');
				
				$delete_id = array_diff($creative_ids,$camp_ids);
				$del = array_keys(array_intersect(array_count_values($delete_id),[1]));
				//print_r($del);die("-");
				$this->unlink_ads_placement_exist($zone_id,$del);
			}
	} 
	function unlink_ads_placement_exist($zone_id=false,$del=false)
	 {
		if($zone_id)
		{

			$this->db->trans_start();
			$this->db->where_in('placement_id',$del);
			$this->db->where('zone_id',$zone_id);
			$this->db->delete(TAB_PLACE_ZONE_ASSOC);
				//echo $this->db->last_query();exit;
			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();
	   }
	}
	function campaign_delete($camp_ids=FALSE,$zone_id=FALSE)
	{
		
		$this->db->trans_start();
		$this->db->where_in('placement_id',$camp_ids);
		$this->db->where('zone_id',$zone_id);
		$this->db->delete(TAB_PLACE_ZONE_ASSOC);
		if ($this->db->trans_status() === FALSE)
			$this->db->trans_rollback();
		else
			$this->db->trans_commit();
	}
	function adtype_selection($type=FALSE)
	{
				switch($type)
				{
					case WEB_AD_BLOCK_BANNER:
						$adblocks = "M_IMG,W_IMG";
						break;
					case WEB_AD_BLOCK_TEXT:
						$adblocks = "M_TEXT";
						break;
					case VIDEO_AD_BLOCK_INLINE:
						$adblocks = "MV_IN";
						break;
					case VIDEO_AD_BLOCK_OVERLAY:
						$adblocks = "MV_OL";						
						break;
				}
				$ad = explode(",",$adblocks);
			return $ad;
	}
	function get_banner_details($zone_id=FALSE,$type=FALSE,$where=FALSE)
	{
		//print_r($where);exit;
		$this->db->select('oxb.bannerid,oxb.campaignid');

		$this->db->join(TAB_AD_ZONE_ASSOC.' as oxcamp','oxcamp.ad_id=oxb.bannerid');
		if($type)
		{
		$this->db->where_in('oxb.dj_banner_type', $type);
		}
		
		$this->db->where('oxcamp.zone_id', $zone_id);
		if($where)
		{
		$this->db->where($where);
		}

		$this->db->where('oxb.dj_is_deleted ','0');

		$query = $this->db->get(TAB_BANNERS.' as oxb');	

		$result = $query->result_array();
//echo $this->db->last_query();exit;
		if($result)
		{

				return $result;
			}

			else
			{

				return FALSE;
			}
		
		
	}
	
	/*
	 * 
	 * name:link_ads_get
	 * @param : zone_id
	 * @return : NULL
	 * 
	 * Link zone to creative
	 */
	
	function link_ads($zone_id=false,$agencyid=false,$house_ad=FALSE)
	{
		
		if($zone_id)
		{
			
			//Sets the agency_id
			$this->agency_id = $agencyid;
			
			// Unlink the previously linked creatives for zone
			$this->unlink_ads($zone_id);
			$this->unlink_ads_placement($zone_id);
			$zone_details = $this->fetch_adblock($zone_id);
			$zone = $zone_details[0];
			
			$zone_type = $zone['dj_zone_type'];
			switch($zone_type)
			{
				case WEB_AD_BLOCK_BANNER:
				
								$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
											
								$creatives = $this->fetch_web_creatives($where_web,$house_ad);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
								break;
				 case CROSS_AD_BLOCK_BANNER:
				 $cross=1;
							$where_web = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
											
								$creatives = $this->fetch_web_creatives($where_web,$house_ad,$cross);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
								break;
				case WEB_AD_BLOCK_TEXT:
				
								$creatives = $this->fetch_text_creatives($house_ad);
								
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);		
									}
								}
								break;
				case CROSS_AD_BLOCK_TEXT:
							$cross=1;
								$creatives = $this->fetch_text_creatives($house_ad,$cross);
								
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);		
									}
								}
								break;
				case WEB_AD_BLOCK_DHTML:
								$where_dhtml = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_dhtml_creatives($where_dhtml,$house_ad);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
								break;
								
				case WEB_AD_RISING_BILLBOARD:
								$where_billboard = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_billboard_creatives($where_billboard,$house_ad);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);	
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
								break;
						
				case WEB_AD_RISING_PUSHDOWN:
								$where_pushdown = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_raisingstar_creatives($where_pushdown,$house_ad);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);		
									}
								}
								break;	
				case WEB_AD_RISING_SIDEKICK:
								$where_sidekick = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_raisingstar_creatives($where_sidekick,$house_ad);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);		
									}
								}
								break;	
				case WEB_AD_RISING_SLIDERBAR:
								$where_slider = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_raisingstar_creatives($where_slider,$house_ad);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);		
									}
								}
								break;								
								
				
				case VIDEO_AD_BLOCK_OVERLAY:
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_overlay_creatives($where_overlay,$house_ad);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
								break;
								
					case CROSS_AD_BLOCK_OVERLAY:
					$cross=1;
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_overlay_creatives($where_overlay,$house_ad,$cross);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
								break;
								
	             // HTML 5 video ads
	             
	            case VIDEO_AD_BLOCK_HTML:
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_html5_creatives($where_overlay,$house_ad);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
								break;	
								
	            // In-Banner video ads
	             
	            case VIDEO_AD_BLOCK_INBANNER:
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_inbanner_creatives($where_overlay,$house_ad);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
								break;										
										
	             // Third party video ads
	             
	            case VIDEO_AD_BLOCK_THIRDPARTY:
								$where_overlay = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_thirdpartyvideo_creatives($where_overlay,$house_ad);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
								break;									
								
				// New customisation Ad Formats 
				case WEB_AD_BLOCK_POPUNDER:
				
					$where 	= 	array(
									"size"			=>	array(
															"oxb.width"	=> 	$zone['width'],
															"oxb.height"=> 	$zone['height']
														),
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(WEB_CREATIVE_POPUNDER)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where,$house_ad);
			
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
							$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);		
						}
					}
					break;
				case WEB_AD_BLOCK_POPUP:
				
					$where 	= 	array(
									
									"storagetype"	=>	array('web'),
						
									"bannertype"	=>	array(WEB_CREATIVE_POPUP)
								);
					
					$creatives 	= 	$this->fetch_match_creatives($where,$house_ad);
					
					if($creatives!=FALSE)
					{
						foreach($creatives as $c)
						{
							//UPDATE ZONE AND CREATIVE MAPPING	
							$link_assoc_data =	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
							$this->add_link_ads($link_assoc_data);
							$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);		
						}
					}
					break;
					
				case VIDEO_AD_BLOCK_INLINE:
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_inline_creatives($where_inline,$house_ad);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
								break;
				case CROSS_AD_BLOCK_INLINE:
				$cross=1;
								$where_inline = array(
												"oxb.width" => $zone['width'],
												"oxb.height" => $zone['height']
											);
								$creatives = $this->fetch_inline_creatives($where_inline,$house_ad,$cross);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$zone_id, 'placement_id' => $c['campaignid']);
										$this->add_link_ads_placement($link_assoc);	
									}
								}
								break;
				
			}
			
		}
	}
	
	
	/**************************************************************************************
	 * 									Match AD CREATIVE
	 * ************************************************************************************/
	 
	/*
	 * 
	 * name: fetch_match_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a matched creative with adblock
	 */
	function fetch_match_creatives($where=false,$house_ad=false)
	{
		if($where)
		{
			$this->db->select('oxb.bannerid,oxb.campaignid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			if($house_ad){
				$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
			}
			
			$this->db->where_in('oxb.storagetype', $where['storagetype']);
			$this->db->where_in('oxb.dj_banner_type', $where['bannertype']);
			$this->db->where('oxb.dj_is_deleted ','0');
			
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	
	/*
	 * 
	 * name: fetch_web_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a web creative
	 */
	 
	 function fetch_web_creatives($where=false,$house_ad=false,$cross=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid,oxb.campaignid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			$this->db->where('oxcl.dj_is_deleted', '0');
			if($house_ad){
				$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
			}
			if($cross == "")
			{
			$this->db->where($where);
			}
			$this->db->where_in('oxb.storagetype', array('web','sql','html','url'));
			if($cross == 1)
			{
				$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_WEB,MOBILE_IMAGE_CREATIVE));
			}
			else
			{
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF));
			}
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			//echo $this->db->last_query();exit;
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_dhtml_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a web creative
	 */
	 function fetch_dhtml_creatives($where=false,$house_ad=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid,oxb.campaignid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			if($house_ad){
				$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
			}
			
			$this->db->where($where);
			$this->db->where_in('oxb.storagetype', array('web','sql','html','url'));
			
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_SQL,WEB_CREATIVE_URL,WEB_CREATIVE_WEB,WEB_CREATIVE_HTML,WEB_CREATIVE_SWF));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_text_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a text creative
	 */
	 function fetch_text_creatives($house_ad=false,$cross=false)
	 {
		$this->db->select('oxb.bannerid,oxb.campaignid');
		$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
		$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
		if($this->agency_id)
		{
			$this->db->where('oxcl.agencyid',$this->agency_id);
		}
		
		if($house_ad){
				$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
			}
		
		$this->db->where('oxb.storagetype', 'txt');
		if($cross ==1)
		{
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_TEXT,MOBILE_TEXT_CREATIVE));
		}
		else
		{
		$this->db->where('oxb.dj_banner_type', WEB_CREATIVE_TEXT);
		}
		$this->db->where('oxb.dj_is_deleted ','0');
		
		$query = $this->db->get(TAB_BANNERS.' as oxb');
		
		$result = $query->result_array(); 
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_inline_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline creative
	 */
		 function fetch_inline_creatives($where=false,$house_ad=false,$cross=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid,oxb.campaignid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			if($house_ad){
				$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
			}
			if($cross == "")
			{
			$this->db->where($where);
			}
			$this->db->where('oxb.storagetype', 'html');
			if($cross == 1)
			{
				$this->db->where_in('oxb.dj_banner_type', array(VIDEO_CREATIVE_INLINE,MOBILE_VIDEO_CREATIVE_INLINE));
			}
			else
			{
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_INLINE);
		}
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	
	/*
	 * 
	 * name: fetch_overlay_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay creative
	 */
	 function fetch_overlay_creatives($where=false,$house_ad=false,$cross=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid,oxb.campaignid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			if($house_ad){
				$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
			}
			if($cross == "")
			{
			$this->db->where($where);
			}
			$this->db->where('oxb.storagetype', 'html');
			if($cross == 1)
			{
				$this->db->where_in('oxb.dj_banner_type', array(VIDEO_CREATIVE_OVERLAY,MOBILE_VIDEO_CREATIVE_OVERLAY));
			}
			else
			{
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_OVERLAY);
		}
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_html5_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay creative
	 */
	 function fetch_html5_creatives($where=false,$house_ad=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid,oxb.campaignid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			if($house_ad){
				$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
			}
			$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_HTML5);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
		/*
	 * 
	 * name: fetch_html5_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay creative
	 */
	 function fetch_inbanner_creatives($where=false,$house_ad=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid,oxb.campaignid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			if($house_ad){
				$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
			}
			$this->db->where($where);
			$this->db->where('oxb.storagetype', 'html');
			
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_INBANNER);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_html5_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay creative
	 */
	 function fetch_thirdpartyvideo_creatives($where=false,$house_ad=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid,oxb.campaignid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			if($house_ad){
				$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
			}
			$this->db->where('oxb.storagetype', 'html');
			$this->db->where('oxb.dj_banner_type', VIDEO_CREATIVE_THIRDPARTY);
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	function add_link_ads($link_assoc_data)
	{
		if($link_assoc_data)
		{
			$this->db->trans_start();
			/*Insert in ox_banners */
			$this->db->insert(TAB_AD_ZONE_ASSOC,$link_assoc_data);
			
			$insert_id	= $this->db->insert_id();

			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $insert_id;
			}
		}
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: unlink_ads
	 * @param : zone_id
	 * @return : $result
	 * 
	 * Delete the zone assoc
	 */
	 function unlink_ads($zone_id=false)
	 {
		if($zone_id)
		{
			$this->db->trans_start();
			
			$this->db->where('zone_id',$zone_id);
			$this->db->delete(TAB_AD_ZONE_ASSOC);

			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();
			else
				$this->db->trans_commit();
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: unlink_blocks
	 * @param : creative_id
	 * @return : $result
	 * 
	 * Delete the zone assoc
	 */
	 function unlink_blocks($creative_id=false)
	 {
		if($creative_id)
		{
			$this->db->trans_start();
			
			$this->db->where('ad_id',$creative_id);
			$this->db->delete(TAB_AD_ZONE_ASSOC);

			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();
			else
				$this->db->trans_commit();
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name:link_adblocks
	 * @param : creative_id
	 * @return : NULL
	 * 
	 * Link creative to blocks
	 */
	
	function link_adblocks($creative_id=false,$agencyid=false)
	{
		if($creative_id)
		{
			
			$this->agency_id = $agencyid;
			
			// Unlink the previously linked creatives for zone
			$this->unlink_blocks($creative_id);
		 /*Manual linking*/
		$link_type=$this->default_configurations->get('linking_type');
		
			$creative_details = $this->fetch_creative($creative_id);
			$creative = $creative_details[0];
			
			$banner_type = $creative['dj_banner_type'];
			$campaignid 	= $creative['campaignid'];
			$this->unlink_blocks_placement($campaignid);
		//~ echo $banner_type;exit;
		
			switch($banner_type)
			{
				case WEB_CREATIVE_WEB:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;
				case WEB_CREATIVE_SQL:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;
				case WEB_CREATIVE_SWF:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;
				case WEB_CREATIVE_HTML:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;
				case WEB_CREATIVE_URL:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_banner_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;
				case WEB_CREATIVE_TEXT:
								$adblocks = $this->fetch_text_adblocks();
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;
				case VIDEO_CREATIVE_OVERLAY:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
										
								$adblocks = $this->fetch_overlay_adblocks($where_block);
									//~ return $adblocks;
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;
				case VIDEO_CREATIVE_INLINE:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_inline_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;
					case VIDEO_CREATIVE_THIRDPARTY:
				
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_thirdpartyvideo_adblocks($where_block);
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;	
				 	case VIDEO_CREATIVE_HTML5:
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_html5video_adblocks();
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;								
				case WEB_CREATIVE_BILLBOARD:				
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_rising_adblocks($where_block);
															
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);	
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);
										
									}
								}
								break;
				
				
					case WEB_CREATIVE_PUSHDOWN:				
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_rising_adblocks($where_block);
															
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;	
					case WEB_CREATIVE_SIDEKICK:				
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_rising_adblocks($where_block);
															
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;													
					case WEB_CREATIVE_SLIDERBAR:				
								$where_block = array(
												"oxz.width" => $creative['width'],
												"oxz.height" => $creative['height']
											);
								$adblocks = $this->fetch_rising_adblocks($where_block);
															
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{
										
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
										
									}
								}
								break;	
								
							case WEB_CREATIVE_POP:
				
								$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_POPUP);
											
								$adblocks 	= 	$this->fetch_match_adblocks($where_web);
								
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{							
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);
									}
								}
								break;									
												
				case WEB_CREATIVE_POPUNDER:
				
								$where_web["zonetype"] 	= 	array(WEB_AD_BLOCK_POPUNDER);
											
								$adblocks 	= 	$this->fetch_match_adblocks($where_web);
								
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{							
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);
									}
								}
								break;
				case MOBILE_VIDEO_CREATIVE_INLINE:
					
								$adblocks = $this->fetch_mob_inline_adblocks();
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{

										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
									}

								}
								break;
				case MOBILE_VIDEO_CREATIVE_OVERLAY:
					
								$adblocks = $this->fetch_mob_overlay_adblocks();
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{

										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
									}

								}
								break;
			  case MOBILE_VIDEO_CREATIVE_INTERSTITAL:
					
								$adblocks = $this->fetch_video_inter_adblocks();
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{

										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
									}

								}
								break;	
				case MOBILE_VIDEO_CREATIVE_NATIVE:
					
								$adblocks = $this->fetch_video_native_adblocks();
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{

										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
									}

								}
								break;	
					case MOBILE_VIDEO_CREATIVE_PAUSE:
					
								$adblocks = $this->fetch_pause_video_adblocks();
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{

										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
									}

								}
								break;
					case MOBILE_VIDEO_CREATIVE_REWARDED:
								$adblocks = $this->fetch_mob_rewarded_adblocks();
								if($adblocks!=FALSE)
								{
									foreach($adblocks as $bl)
									{

										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$bl['zoneid'], 'ad_id' => $creative_id);
										$this->add_link_ads($link_assoc_data);
										$link_assoc 	=	array('zone_id' =>	$bl['zoneid'], 'placement_id' => $campaignid);
										$this->add_link_ads_placement($link_assoc);	
									}

								}
								break;						    
			}
		}
	}
	
	/**************************************************************************************
	 * 									Match AD BLOCK
	 * ************************************************************************************/
	 
	/*
	 * 
	 * name: fetch_match_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a matched blocks with creative
	 */
	 function fetch_match_adblocks($where=false)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if(isset($where['size']))
			{
				$this->db->where($where['size']);
			}
			$this->db->where_in('oxz.dj_zone_type', $where['zonetype']);
			$this->db->where('oxz.dj_is_deleted ','0');
			$this->db->where('oxz.rtb_type ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	/*
	 * 
	 * name: fetch_rising_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a Rising blocks
	 */
	
	 function fetch_rising_adblocks($where=false,$rtb=FALSE)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			$this->db->where($where);
			$this->db->where_in('oxz.dj_zone_type', array(WEB_AD_RISING_BILLBOARD,WEB_AD_RISING_PUSHDOWN,WEB_AD_RISING_SIDEKICK,WEB_AD_RISING_SLIDERBAR));
			$this->db->where('oxz.dj_is_deleted ','0');
			$this->db->where('oxz.rtb_type ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	 
					
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
		
	}
	
	
	
	
	/*
	 * 
	 * name: fetch_banner_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a web blocks
	 */
	 function fetch_banner_adblocks($where=false)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			$this->db->where($where);
			$this->db->where_in('oxz.dj_zone_type', array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML));
			$this->db->where('oxz.dj_is_deleted ','0');
			$this->db->where('oxz.rtb_type ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			//echo $this->db->last_query(); exit;	
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_text_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a text blocks
	 */
	
	function fetch_text_adblocks()
	{
		$this->db->select('oxz.zoneid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id){
		$this->db->where('oxa.agencyid',$this->agency_id);
		}
		$this->db->where_in('oxz.dj_zone_type', array(WEB_AD_BLOCK_TEXT));
		$this->db->where('oxz.dj_is_deleted ','0');
		$this->db->where('oxz.rtb_type ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * 
	 * name: fetch_overlay_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay blocks
	 */
	 function fetch_overlay_adblocks($where=false)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_OVERLAY);
			$this->db->where('oxz.dj_is_deleted ','0');
			$this->db->where('oxz.rtb_type ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_thirdpartyvideo_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay blocks
	 */
	 function fetch_thirdpartyvideo_adblocks($where=false)
	 {
		if($where)
		{
			
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_THIRDPARTY);
			$this->db->where('oxz.dj_is_deleted ','0');
			$this->db->where('oxz.rtb_type ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
		
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	/*
	 * 
	 * name: fetch_html5_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a overlay blocks
	 */
	 function fetch_html5video_adblocks($where=false)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
	
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_HTML);
			$this->db->where('oxz.dj_is_deleted ','0');
			$this->db->where('oxz.rtb_type ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	
	
	/*
	 * 
	 * name: fetch_raisingstar_creative
	 * @param :
	 * @return : $result
	 * 
	 * Get a portrait creative
	 */
	 function fetch_raisingstar_creatives($where=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid,oxb.campaignid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			//$this->db->where('oxcl.clientid', '1');//Admin - client id
		    if($house_ad){
				$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
			}
			$this->db->where($where);
			$this->db->where_in('oxb.storagetype', array('web'));
			
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_PUSHDOWN,WEB_CREATIVE_SIDEKICK,WEB_CREATIVE_SLIDERBAR));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
				
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	

    /*
	 * 
	 * name: fetch_billboard_creatives
	 * @param :
	 * @return : $result
	 * 
	 * Get a Billboard creative
	 */
	 function fetch_billboard_creatives($where=false)
	 {
		if($where)
		{
			$this->db->select('oxb.bannerid,oxb.campaignid');
			$this->db->join(TAB_CAMPAIGNS.' as oxcamp','oxcamp.campaignid=oxb.campaignid');
			$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.clientid=oxcamp.clientid');
			if($this->agency_id)
			{
				$this->db->where('oxcl.agencyid',$this->agency_id);
			}
			if($house_ad){
				$this->db->where('oxcl.dj_is_default', '1');//Admin - client id
			}
			$this->db->where($where);
			$this->db->where_in('oxb.storagetype', array('web'));
			
			$this->db->where_in('oxb.dj_banner_type', array(WEB_CREATIVE_BILLBOARD));
			$this->db->where('oxb.dj_is_deleted ','0');
			$query = $this->db->get(TAB_BANNERS.' as oxb');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	




	/*
	 * 
	 * name: fetch_inline_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline blocks
	 */
	 function fetch_inline_adblocks($where=false)
	 {
		if($where)
		{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			$this->db->where($where);
			$this->db->where('oxz.dj_zone_type', VIDEO_AD_BLOCK_INLINE);
			$this->db->where('oxz.dj_is_deleted ','0');
			$this->db->where('oxz.rtb_type ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
		
	}
	/*
	 * 
	 * name: fetch_mob_inline_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline blocks
	 */
	 function fetch_mob_inline_adblocks($where=false)
	 {
		//if($where)
		//{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($where){
			$this->db->where($where);
			}
			$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_INLINE);
			$this->db->where('oxz.dj_is_deleted ','0');
			$this->db->where('oxz.rtb_type ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		//}
		//else
			//return FALSE;
		
	}

	function fetch_mob_rewarded_adblocks($where = false)
	{
		$this->db->select('oxz.zoneid');
		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
		if($this->agency_id){
			$this->db->where('oxa.agencyid',$this->agency_id);
		}
		if($where){
		$this->db->where($where);
		}
		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_REWARDED);
		$this->db->where('oxz.dj_is_deleted ','0');
		$this->db->where('oxz.rtb_type ','0');
		$query = $this->db->get(TAB_ZONES.' as oxz');	
		
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	/*
	 * 
	 * name: fetch_mob_overlay_adblocks
	 * @param :
	 * @return : $result
	 * 
	 * Get a inline blocks
	 */
	 function fetch_mob_overlay_adblocks($where=false)
	 {
		//if($where)
		//{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($where){
			$this->db->where($where);
			}
			$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_OVERLAY);
			$this->db->where('oxz.dj_is_deleted ','0');
			$this->db->where('oxz.rtb_type ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		//}
		//else
			//return FALSE;
		
	}

	/*

	*name : fetch_pause_video_adblocks

	*@return : $result

	*/

 
	function fetch_pause_video_adblocks($where=false)
	 {
		//if($where)
		//{
			$this->db->select('oxz.zoneid');
			$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');
			if($this->agency_id){
				$this->db->where('oxa.agencyid',$this->agency_id);
			}
			if($where){
			$this->db->where($where);
			}
			$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_PAUSE);
			$this->db->where('oxz.dj_is_deleted ','0');
			$this->db->where('oxz.rtb_type ','0');
			$query = $this->db->get(TAB_ZONES.' as oxz');	
			
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		//}
		//else
			//return FALSE;
		
	}
	/*

	 * 

	 * name: fetch_video_inter_adblocks

	 * @param :

	 * @return : $result

	 * 

	 * Get a mobile video interstitial blocks

	 */

	

	function fetch_video_inter_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_INTERSTITIAL_VIDEO);

		$this->db->where('oxz.dj_is_deleted ','0');
		
		$this->db->where('oxz.rtb_type ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}
	
	function fetch_video_native_adblocks()

	{

		$this->db->select('oxz.zoneid');

		$this->db->join(TAB_AFFILIATE.' as oxa','oxa.affiliateid=oxz.affiliateid');

		if($this->agency_id){

			$this->db->where('oxa.agencyid',$this->agency_id);

		}

		$this->db->where('oxz.dj_zone_type', MOBILE_AD_BLOCK_NATIVE_VIDEO);

		$this->db->where('oxz.dj_is_deleted ','0');
		
		$this->db->where('oxz.rtb_type ','0');

		$query = $this->db->get(TAB_ZONES.' as oxz');	

		//echo $this->db->last_query(); exit;	

		$result = $query->result_array();

		if($result)

			return $result;

		else

			return FALSE;

	}
	function unlink_ads_placement($zone_id=false)
	 {
		if($zone_id)
		{
			$this->db->trans_start();
			$this->db->select("zone_id");
			$this->db->where('zone_id',$zone_id);
			$query = $this->db->get(TAB_PLACE_ZONE_ASSOC);
				if($query->num_rows() > 0 ){
					$this->db->where('zone_id',$zone_id);
					$this->db->delete(TAB_PLACE_ZONE_ASSOC);
					if ($this->db->trans_status() === FALSE)
						$this->db->trans_rollback();
					else
					$this->db->trans_commit();
				}
				else
				return FALSE;
			}
		else
			return FALSE;
	}
	function add_link_ads_placement($link_assoc)

	{

		if($link_assoc)

		{

			$this->db->trans_start();

			$this->db->select("zone_id");
			$this->db->where($link_assoc);
			$query = $this->db->get(TAB_PLACE_ZONE_ASSOC);
			
				if($query->num_rows() <= 0 ){

			$this->db->insert(TAB_PLACE_ZONE_ASSOC,$link_assoc);

			

			$insert_id	= $this->db->insert_id();

			

			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)

			{

				$this->db->trans_rollback();

				return FALSE;

			}
		
		
			else

			{

				$this->db->trans_commit();

				return $insert_id;

			}
			}
			else

			return FALSE;

		}

		else

			return FALSE;

	}
	
	/*

	 * 

	 * name: unlink_blocks_placement

	 * @param : campaign_id

	 * @return : $result

	 * 

	 * Delete the zone assoc

	 */

	 function unlink_blocks_placement($campaign_id=false)

	 {

		if($campaign_id)

		{

			$this->db->trans_start();

			

			$this->db->where('placement_id',$campaign_id);

			$this->db->delete(TAB_PLACE_ZONE_ASSOC);



			if ($this->db->trans_status() === FALSE)

				$this->db->trans_rollback();

			else

				$this->db->trans_commit();

		}

		else

			return FALSE;

		

	}
}
