<?php defined('BASEPATH') OR exit('No direct script access allowed');
Class Do_antifraud extends CI_Model
{
	
	/*  ox_zones
	 * ---------------------
	 *  zonename
	 * 	width
	 *  Height
	 *  oac_category_id
	 *  dj_added_date
	 * 	is_deleted
	 * */
	 
	 public function list_fraudclicks($search_arr = FALSE)
	 {
		
		$query = $this->db->get(TAB_AD_FRAUD_CLK.' as adfc');
	
		$result = $query->result_array();
		
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		} 
	 }
	 
 	 /*
	* 
	* name: antifraud_valid_list
	* @param : null
	* @return : antifraud list list 
    */
	 public function antifraud_statistics_list($agencyid)
	 {
	    $this->db->select('ta.name,DATE(taf.datetime) as date,SUM(taf.fclicks) as fclicks,SUM(taf.aclicks) as aclicks,taf.url as url,taf.ipaddress as ipaddress');
		$this->db->where('taa.agencyid',$agencyid);
		$this->db->join(TAB_AFFILIATE.' as ta','taf.pubid=ta.affiliateid');
		$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
		$this->db->GROUP_BY('date');
		$this->db->GROUP_BY('ta.name');
		$this->db->GROUP_BY('taf.url');
		$this->db->GROUP_BY('taf.ipaddress');
		$this->db->order_by('taf.id');
	    $query = $this->db->get(TAB_ANTI_FRAUD.' as taf'); 
		$result = $query->result_array();  
		if($result)
		{
		   foreach($result as $idx => $value)
		{
				
				$result[$idx]['date'] =dateformat(strtotime($value['date']));
				
				
				
		}
			return $result;
		}else
			return FALSE;
     }
	 
	 /*
	* 
	* name: antifraud_valid_list
	* @param : null
	* @return : antifraud list list 
    */
	public function antifraud_list($agencyid)
	 {
	    $this->db->select('ta.name,DATE(taf.datetime) as date,SUM(taf.fclicks) as fclicks,SUM(taf.aclicks) as aclicks,taf.url as url,taf.ipaddress as ipaddress,taf.id as id');
		$this->db->where_not_in('taf.fclicks',0);
		$this->db->where('taa.agencyid',$agencyid);
		$this->db->join(TAB_AFFILIATE.' as ta','taf.pubid=ta.affiliateid');
		$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
		$this->db->GROUP_BY('date');
		$this->db->GROUP_BY('ta.name');
		$this->db->GROUP_BY('taf.url');
		$this->db->GROUP_BY('taf.ipaddress');
		$this->db->order_by('taf.id');
	    $query = $this->db->get(TAB_ANTI_FRAUD.' as taf');	    
		$result = $query->result_array();
		if($result)
		{
		foreach($result as $idx => $value)
		{
				
				$result[$idx]['date'] =dateformat(strtotime($value['date']));
				
				
				
		}	
			return $result;
		}else{
			return FALSE;
     }
     }
	 /*
	* 
	* name: fetch_anti_penality_list
	* @param : null
	* @return : penality list 
    */	
	public function penality_list($agencyid)
	{
		$this->db->select('DATE(tp.date_time) as date,tp.pubname as pubname,SUM(tp.penaltypoint) as penaltypoint');
		$this->db->where('taa.agencyid',$agencyid);
		$this->db->join(TAB_AFFILIATE.' as ta','tp.pubid=ta.affiliateid');
		$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
		$this->db->GROUP_BY('tp.pubname');
		$this->db->GROUP_BY('DATE(tp.date_time)');
		$query = $this->db->get(TAB_PENALITIES.' as tp');
		
		$result = $query->result_array();
		if($result)
		{
		foreach($result as $idx => $value)
		{
				
				$result[$idx]['date'] =dateformat(strtotime($value['date']));
				
				
				
		}
			return $result;
		}else
			return FALSE;
	}
	
	public function antifraud_statistics_filter($agencyid,$from_dt,$to_dt)
	{
	    $this->db->select('ta.name,DATE(taf.datetime) as date,SUM(taf.fclicks) as fclicks,SUM(taf.aclicks) as aclicks,taf.url as url,taf.ipaddress as ipaddress,taf.id as id');
		//$this->db->where_not_in('taf.fclicks',0);
		$this->db->where('taa.agencyid',$agencyid);
		$this->db->where('DATE(taf.datetime)>=',$from_dt);
		$this->db->where('DATE(taf.datetime)<=',$to_dt);
		$this->db->join(TAB_AFFILIATE.' as ta','taf.pubid=ta.affiliateid');
		$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
		$this->db->GROUP_BY('date');
		$this->db->GROUP_BY('ta.name');
		$this->db->GROUP_BY('taf.url');
		$this->db->GROUP_BY('taf.ipaddress');
		$this->db->order_by('taf.id');
	    $query = $this->db->get(TAB_ANTI_FRAUD.' as taf');
		$result = $query->result_array();
		if($result)
		{
		foreach($result as $idx => $value)
		{
				
				$result[$idx]['date'] =dateformat(strtotime($value['date']));
				
				
				
		}
			
			
		return $result;
		}else
			return FALSE;
    }
    
    public function penality_statistics_filter($agencyid,$from_dt,$to_dt)
    {
		$this->db->select('DATE(tp.date_time) as date,tp.pubname as pubname,SUM(tp.penaltypoint) as penaltypoint');
		$this->db->where('taa.agencyid',$agencyid);
		$this->db->where('DATE(tp.date_time)>=',$from_dt);
		$this->db->where('DATE(tp.date_time)<=',$to_dt);
		$this->db->join(TAB_AFFILIATE.' as ta','tp.pubid=ta.affiliateid');
		$this->db->join(TAB_AGENCY.' as taa','taa.agencyid=ta.agencyid');
		$this->db->GROUP_BY('tp.pubname');
		$this->db->GROUP_BY('DATE(tp.date_time)');
		$query = $this->db->get(TAB_PENALITIES.' as tp');
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
    
}


