<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Web creatives
 *
 * All web creative will be managed here 
 *
 * @package		ADX
 * @subpackage	Web creatives
 * @category	Controller
 * @author		Vigneswaran a
 * @link		http://www.djaxadserver.com
*/

class Web_creative extends REST_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('Do_web_creative');
		$this->load->helper('utilities_helper');
		$this->load->library('swf_banner');
		$this->load->model('Do_creative');
		$this->load->model('Do_auto_link');
		$this->load->library('user_authentication');
		$this->load->library('default_configurations');
	    $key=$this->input->get_post('api_key'); 
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}

	// validation for image url
	function check_is_image_url()
	{
		$url = $this->post('external_web_creative');
		$img = @getimagesize($url);
		
		$mime_arr = array('image/jpeg','image/png','image/gif');
		
		if( @is_array(@getimagesize($url)) && ( in_array($img['mime'],$mime_arr)))
		{
			return TRUE;
		}
		else
		{
			$this->form_validation->set_message('check_is_image_url', $this->lang->line('ent_valid_image_url') );
			return FALSE;
		}
	}

 	/*
	 * 
	 * name: add_web_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage all the three SQL,WEB
	 * and URL CREATIVE adding process
	 */
	public function add_web_creative_post()
	{
		$this->form_validation->set_rules('web_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('web_creative_size', 'lang:creative_size', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$is_external_web_creative = $this->post('is_external_web_creative');

		if($is_external_web_creative =='on')
		$this->form_validation->set_rules('external_web_creative', 'lang:creative_url', 'required|trim|url|callback_check_is_image_url|check_image_size');
		$campaign = $this->post('_web_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_web_campaign_id');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$is_db_store = $this->post('is_db_store');
			$blob_data=array();
			//Get account/agency_id from library file
			if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			$agency_id=$this->user_authentication->agency_id;

			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
				
			
			
			
			//If it is a database creative
			if($is_db_store=='on')
			{			
				$storage_type='sql';
				$bannertype=WEB_CREATIVE_SQL;
				//Fetch width and height of the creative
				$creative_size=explode('x',$this->post('web_creative_size'));
				$creative_width=$creative_size[0];
				$creative_height=$creative_size[1];
				if(isset($creative_width) AND isset($creative_height) )
				{
					$creative_data = array(
						"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
						"campaignid"=>clean_data($campaign_id),
						"storagetype"=>clean_data($storage_type),
						"description"=>clean_data($this->post('web_creative_name')),
						"filename"=>clean_data($this->post('tmp_web_creative')),
						"width"=>clean_data($creative_width),
						"height"=>clean_data($creative_height),
						"url"=>clean_data($this->post('destination_url')),
						"dj_admin_approve"=>clean_data($dj_admin_approve),
						"dj_approved_date"=>clean_data($dj_approved_date),
						"dj_banner_type"=>clean_data($bannertype),
						"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
						"dj_account_id" => clean_data($dj_account_id)
					);
					$blob_data=array(
									"filename"=>clean_data($this->post('tmp_web_creative')),
									"contents"=>file_get_contents($this->post('tmp_web_creative_url')),
									"t_stamp"=>clean_data(date('Y:m:d :H:i:s')),
									);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_web_creative'));				
				}
			}
			else
			{
				//If it is a URL creative
				if($is_external_web_creative=='on')
				{
					$storage_type='url';
					$bannertype=WEB_CREATIVE_URL;
					//Fetch width and height of the creative
					$creative_size=explode('x',$this->post('web_creative_size'));
					$creative_width=$creative_size[0];
					$creative_height=$creative_size[1];
					if(isset($creative_width) AND isset($creative_height) )
					{
						$creative_data = array(
							"storagetype"=>clean_data($storage_type),
							"campaignid"=>clean_data($campaign_id),
							"description"=>clean_data($this->post('web_creative_name')),
							"imageurl"=>clean_data($this->post('external_web_creative')),
							"width"=>clean_data($creative_width),
							"height"=>clean_data($creative_height),
							"url"=>clean_data($this->post('destination_url')),
							"dj_admin_approve"=>clean_data($dj_admin_approve),
							"dj_approved_date"=>clean_data($dj_approved_date),							
							"dj_banner_type"=>clean_data($bannertype),
							"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_account_id" => clean_data($dj_account_id)
						);
					}
				}
				else
				{
					//If it is a web creative
					$storage_type='web';
					$bannertype=WEB_CREATIVE_WEB;
					//Fetch width and height of the creative
					$creative_size=explode('x',$this->post('web_creative_size'));
					$creative_width=$creative_size[0];
					$creative_height=$creative_size[1];
					if(isset($creative_width) AND isset($creative_height) )
					{
						$creative_data = array(
							"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
							"campaignid"=>clean_data($campaign_id),
							"storagetype"=>clean_data($storage_type),
							"description"=>clean_data($this->post('web_creative_name')),
							"filename"=>clean_data($this->post('tmp_web_creative')),
							"width"=>clean_data($creative_width),
							"height"=>clean_data($creative_height),
							"url"=>clean_data($this->post('destination_url')),
							"dj_admin_approve"=>clean_data($dj_admin_approve),
							"dj_approved_date"=>clean_data($dj_approved_date),							
							"dj_banner_type"=>clean_data($bannertype),
							"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_account_id" => clean_data($dj_account_id)
						);
							
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_web_creative'));
					}
				}
			}
			//Call to add a creative
			
			$creative_add=$this->Do_web_creative->add($creative_data,$blob_data,$agency_id,$is_house_ad);

			if($creative_add)
			{
				$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('mobile_creative_added'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);
				$this->response($success, 200);
				
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
		}
	}
 	/*
	 * 
	 * name: add_flash_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage  adding of flash creatives
	 */
	public function add_flash_creative_post()
	{
		$this->form_validation->set_rules('flash_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('flash_creative_size', 'lang:creative_size', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$campaign = $this->post('_fl_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_fl_campaign_id');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$content_type='swf';
			$storage_type='web';
			$bannertype=WEB_CREATIVE_SWF;
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			$agency_id=$this->user_authentication->agency_id;

			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
			//FOR SWF FILE VALUES
			$banner_url=clean_data($this->post('destination_url'));
			$ban_target='_blank';
			
			//Fetch width and height of the creative
			$creative_size=explode('x',$this->post('flash_creative_size'));
			$creative_width=$creative_size[0];
			$creative_height=$creative_size[1];

			if(isset($creative_width) AND isset($creative_height) )
			{
				$content		=file_get_contents($this->post('tmp_flash_creative_url'));

				if ($this->swf_banner->phpAds_SWFCompressed($content))
				{
					$buffer = $this->swf_banner->phpAds_SWFDecompress($content);								
					$buffer = preg_replace('/clickTAG/i', 'clickTAG', $buffer);
					$content =$this->swf_banner->phpAds_SWFCompress($buffer);
				}
				else
				{									
					$content = preg_replace('/clickTAG/i', 'clickTAG', $content);
				}

				//Store width and height
				list($banner_width, $banner_height) = $this->swf_banner->phpAds_SWFDimensions($content);
				$pluginVersion  = $this->swf_banner->phpAds_SWFVersion($content);									
				$hardcodedLinks = $this->swf_banner->phpAds_SWFInfo($content);	
				if(!empty($hardcodedLinks))
				{
					//Remove Hardcoded link from swf file
					 if ($this->swf_banner->phpAds_SWFVersion($content) >= 3 && $this->swf_banner->phpAds_SWFInfo($content))
					 {
						// SWF's requiring player version 6+ which are already compressed should stay compressed
						if ($this->swf_banner->phpAds_SWFVersion($content) >= 6 && $this->swf_banner->phpAds_SWFCompressed($content))
						{
							$compress = true;
						}
						elseif (isset($compress))
						{
							$compress = true;
						}
						else
						{
							$compress = false;
						}
						if (!isset($convert_links))
						{
							$convert_links = array();
						}
						$convert_links = array_keys($hardcodedLinks);
						list($result, $parameters) = $this->swf_banner->phpAds_SWFConvert($content, $compress, $convert_links);
						if ($result != $content)
						{
							if (count($parameters) > 0)
							{
								// Prepare the parameters
								$parameters_complete = array();
								//Small hack to overwrite hard_coded values with lang:destination_url
								unset($overwrite_link);
								unset($overwrite_target);	
								$overwrite_link = array('0'=>$banner_url);

								$overwrite_target = array('0'=>$ban_target);	

									foreach ($parameters as $key => $val)
									{
										if (isset($overwrite_source) && $overwrite_source[$val] != '')
										{
											$overwrite_link[$val] .= '|source:'.$overwrite_source[$val];
										}
										$parameters_complete[$key] = array(
											'link' => $overwrite_link[0],
											'tar'  =>$overwrite_target[0],
										);
									}
									$parameters = array('swf' => $parameters_complete);
									
							}
							else
							{
								$parameters = '';
							}
							//When storing banner details into table,Don't forget to update parameters field
							$param = empty($parameters) ? null : serialize($parameters);
						}
					}	
				}
				else
				{
					$param = "N;";
				}
				

				$creative_data = array(
					"contenttype"=>clean_data($content_type),
					"campaignid"=>clean_data($campaign_id),
					"storagetype"=>clean_data($storage_type),
					"description"=>clean_data($this->post('flash_creative_name')),
					"filename"=>clean_data($this->post('tmp_flash_creative')),
					"width"=>clean_data($creative_width),
					"height"=>clean_data($creative_height),
					"parameters" => $param,
					"pluginversion" =>$pluginVersion ,
					"url"=>clean_data($this->post('destination_url')),
					"dj_admin_approve"=>clean_data($dj_admin_approve),
					"dj_approved_date"=>clean_data($dj_approved_date),					
					"dj_banner_type"=>clean_data($bannertype),
					"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_account_id" => clean_data($dj_account_id)
				);
            
				//Get agencyid
				$blog_data=FALSE;
				$creative_id=$this->Do_web_creative->add($creative_data,$blog_data,$agency_id,$is_house_ad);

				$backup_image_data=array(
								"banner_id"=>clean_data($creative_id),
								"file_path"=>clean_data($this->post('tmp_backup_flash_creative')),
								"width"=>clean_data($creative_width),
								"height"=>clean_data($creative_height),
								"content_type"=>clean_data($this->post('tmp_backup_flash_creative_content_type')),
								"created_date"=>clean_data(date('Y:m:d :H:i:s')),
								);
				$backup_image_data=$this->Do_web_creative->add_creative_dependiences($backup_image_data);
						
				//On sucess move the web creative from tmp location to original location
				$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_flash_creative'));
				$is_backup_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_backup_flash_creative'));

				if($creative_id)
				{
					$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('mobile_creative_added'),
									'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
									);
					$this->response( $success, 200);
					
				}
				else
				{
					$error = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('error_try_again'),
									'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
									);	
					$this->response( $error, 200);
				}	
			}
		}
	}

	 /*
	 * 
	 * name: add_html_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage HTML creative adding process
	 */
	public function add_html_creative_post()
	{
		$this->form_validation->set_rules('html_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('html_creative_size', 'lang:creative_size', 'required|trim');
		
		$this->form_validation->set_rules('html_content', 'lang:html_content', 'required|trim');
		$campaign = $this->post('_html_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_html_campaign_id');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			//Fetch width and height of the creative
			$storage_type="html";
			$bannertype=WEB_CREATIVE_HTML;
			$creative_size=explode('x',$this->post('html_creative_size'));
			$creative_width=$creative_size[0];
			$creative_height=$creative_size[1];
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			$agency_id=$this->user_authentication->agency_id;
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}			

			$htmlcache=html_anchor_tag_replacer($_REQUEST['html_content']);
			$html_template = stripslashes( str_ireplace('\n', '', $_REQUEST['html_content']));
			
			if(isset($creative_width) AND isset($creative_height) AND isset($htmlcache))
			{
				$creative_data = array(
						"contenttype"=>clean_data($storage_type),
						"campaignid"=>clean_data($campaign_id),
						"storagetype"=>clean_data($storage_type),
						"description"=>clean_data($this->post('html_creative_name')),
						"width"=>clean_data($creative_width),
						"height"=>clean_data($creative_height),
						"url"=>clean_data($this->post('destination_url')),
						"htmltemplate "=>html_entity_decode($html_template),
						"htmlcache"=>stripslashes($htmlcache),
						"dj_admin_approve"=>clean_data($dj_admin_approve),
						"dj_approved_date"=>clean_data($dj_approved_date),												
						"dj_banner_type"=>clean_data($bannertype),
						"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
						"dj_account_id" => clean_data($dj_account_id)
					);
			 //Get agencyid
			 $blog_data=FALSE;
	
			 //Call to add a creative
			 $creative_add=$this->Do_web_creative->add($creative_data,$blog_data,$agency_id,$is_house_ad);
			
			}

			if($creative_add)
			{
				$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('mobile_creative_added'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);
				$this->response( $success, 200);
				
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
		}	

	}
	 /*
	 * 
	 * name: add_text_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage HTML creative adding process
	 */
	public function add_text_creative_post()
	{
		$this->form_validation->set_rules('text_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$this->form_validation->set_rules('text_content', 'lang:html_content', 'required|trim');
		$campaign = $this->post('_wtxt_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_wtxt_campaign_id');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type="txt";
			$bannertype=WEB_CREATIVE_TEXT;
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			$agency_id=$this->user_authentication->agency_id;
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}			

			$creative_data = array(
						"contenttype"=>clean_data($storage_type),
						"campaignid"=>clean_data($campaign_id),
						"storagetype"=>clean_data($storage_type),
						"description"=>clean_data($this->post('text_creative_name')),
						"bannertext"=>htmlentities($this->post('text_content')),
						"url"=>clean_data($this->post('destination_url')),
						"dj_admin_approve"=>clean_data($dj_admin_approve),
						"dj_approved_date"=>clean_data($dj_approved_date),						
						"dj_banner_type"=>clean_data($bannertype),
						"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
						"dj_account_id" => clean_data($dj_account_id)
					);
			//Call to add a creative
			$blob_data=FALSE;
			$creative_add=$this->Do_web_creative->add($creative_data,$blob_data,$agency_id,$is_house_ad);

			if($creative_add)
			{
				$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('mobile_creative_added'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);
				$this->response( $success, 200);
				
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}		

		}
	}

	 /*
	 * 
	 * name: edit_text_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage text creative edit process
	 * 
	 */
	
	public function edit_text_creative_post()
	{
		
		$this->form_validation->set_rules('text_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('text_content','lang:creative_content', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=$this->post('text_creative_id');
			$is_house_ad=$this->post('_is_house_ad');

			$storage_type="txt";
		
			//$this->response($is_house_ad);


			/* dj_admin_approve added on dec-2 */
			$dj_admin_approve = $this->post('dj_admin_approve');
			if($dj_admin_approve == -1)
			{
				$creative_data = array(
							"storagetype"=>clean_data($storage_type),
							"description"=>clean_data($this->post('text_creative_name')),
							"bannertext"=>htmlentities($this->post('text_content')),
							"url"=>clean_data($this->post('destination_url')),
							"dj_admin_approve"=>clean_data(0),							
							
						);
			}else
			{
				$creative_data = array(
							"storagetype"=>clean_data($storage_type),
							"description"=>clean_data($this->post('text_creative_name')),
							"bannertext"=>htmlentities($this->post('text_content')),
							"url"=>clean_data($this->post('destination_url')),
							
						);
				
			}
	
			 //Get agencyid from library file
			 $agency_id=$this->user_authentication->agency_id;			
			 //Call to edit a creative
			$creative_edit=$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id,$is_house_ad);
			$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
			

			
			if($creative_edit)
			{
				$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
		}
	}
	 /*
	 * 
	 * name: edit_html_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage text creative edit process
	 * 
	 */
	
	public function edit_html_creative_post()
	{
		$campaign_id= $this->post('_campaign_id');
		$this->form_validation->set_rules('html_creative_name','lang:creative_name', 'required|trim');
		
		$this->form_validation->set_rules('html_content', 'lang:html_content', 'required|trim');
		

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=$this->post('html_creative_id');
			$is_house_ad=$this->post('_is_house_ad');
			$storage_type="html";
			$htmlcache=html_anchor_tag_replacer($_REQUEST['html_content']);
			$html_template = stripslashes( str_ireplace('\n', '', $_REQUEST['html_content']));
			/* dj_admin_approve added by  karthika on dec-2 */
			$dj_admin_approve = $this->post('dj_admin_approve');
								
			if(isset($htmlcache))
			{
				if($dj_admin_approve == -1)
				{				
					$creative_data = array(
							"description"=>clean_data($this->post('html_creative_name')),
							"url"=>clean_data($this->post('destination_url')),
							"htmltemplate "=>html_entity_decode($html_template),
							"htmlcache"=>stripslashes($htmlcache),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_admin_approve"=>clean_data(0),
						);
				}else
				{
					$creative_data = array(
							"description"=>clean_data($this->post('html_creative_name')),
							"url"=>clean_data($this->post('destination_url')),
							"htmltemplate "=>html_entity_decode($html_template),
							"htmlcache"=>stripslashes($htmlcache),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
						);					
				}	
				/* End */
			//Get agencyid from library
			 $agency_id=$this->user_authentication->agency_id;
			//Call to edit a creative
			$creative_edit=$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id,$is_house_ad);
			
			// added for edited creative status update
			//29-06-2017
			//$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			//~ }
			//~ 
				$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
			}
			if($creative_edit)
			{
				$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
		}
	}

	 /*
	 * 
	 * name: edit_web_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all the three SQL,WEB
	 * and URL CREATIVE edit process
	 */
	public function edit_web_creative_post()
	{
		$storage_type = $this->post('storage_type');

		switch($storage_type)
		{
			case $storage_type=='web':
				$this->edit_image_creative();
			break;	

			case $storage_type=='sql':
				$this->edit_sql_creative();
			break;	

			case $storage_type=='url':
				$this->edit_url_creative();
			break;	
		}
	}

	 /*
	 * 
	 * name: edit_image_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage WEB creative edit process
	 * 
	 */
	
	public function edit_image_creative()
	{
		$this->form_validation->set_rules('web_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$tmp_web_creative=$this->post('tmp_web_creative');
		if (empty($tmp_web_creative))
		{
			$this->form_validation->set_message('required', $this->lang->line('no_creative_selected'));
			$this->form_validation->set_rules('web_creative_edit','lang:creative', 'required');
		}

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=$this->post('web_creative_id');
			$is_house_ad=$this->post('_is_house_ad');
			/* dj_admin_approve added by  karthika on dec-2 */
			$dj_admin_approve = $this->post('dj_admin_approve');
			if($dj_admin_approve == -1)
			{
				$creative_data = array(
					"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
					"description"=>clean_data($this->post('web_creative_name')),
					"filename"=>clean_data($this->post('tmp_web_creative')),
					"url"=>clean_data($this->post('destination_url')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_admin_approve"=>clean_data(0),
				);				
			}else
			{
				$creative_data = array(
					"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
					"description"=>clean_data($this->post('web_creative_name')),
					"filename"=>clean_data($this->post('tmp_web_creative')),
					"url"=>clean_data($this->post('destination_url')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
				);				
			}
			/* // End */	
			//Get clientid from library file
		 	$agency_id=$this->user_authentication->agency_id;

		    //Call to edit a creative
			$creative_edit=$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id,$is_house_ad);

			// added for edited creative status update
			//29-06-2017
			//$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			//~ }
             	$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
			 if($creative_edit)
			 {
				if($this->post('old_creative') != $this->post('tmp_web_creative'))
				{
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_web_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_creative'));
				}
				$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
		}
	}
	 /*
	 * 
	 * name: edit_flash_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage WEB creative edit process
	 * 
	 */
	
	public function edit_flash_creative_post()
	{
		$this->form_validation->set_rules('flash_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('flash_creative_size', 'lang:creative_size', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');

		$tmp_flash_creative=$this->post('tmp_flash_creative');
		$is_house_ad=$this->post('_is_house_ad');
		
		if (empty($tmp_flash_creative))
		{
			$this->form_validation->set_message('required', $this->lang->line('no_creative_selected'));
			$this->form_validation->set_rules('flash_creative_edit','lang:creative', 'required');
		}
		
		$tmp_backup_flash_creative=$this->post('tmp_backup_flash_creative');
		if (empty($tmp_backup_flash_creative))
		{
			$this->form_validation->set_message('required', $this->lang->line('no_creative_selected'));
			$this->form_validation->set_rules('backup_creative_edit','lang:creative', 'required');
		}

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$content_type='swf';
			$storage_type='web';
			$bannertype=WEB_CREATIVE_SWF;
			
			//FOR SWF FILE VALUES
			$banner_url=clean_data($this->post('destination_url'));
			$ban_target='_blank';
			$creative_id=clean_data($this->post('web_creative_id'));
			
			//Fetch width and height of the creative
			$creative_size=explode('x',$this->post('flash_creative_size'));
			$creative_width=$creative_size[0];
			$creative_height=$creative_size[1];

			//IF FLASH CHANGED
			if($this->post('old_flash_creative') != $this->post('tmp_flash_creative'))
			{
				if(isset($creative_width) AND isset($creative_height) )
				{
					$content		=file_get_contents($this->post('tmp_flash_creative_url'));

					if ($this->swf_banner->phpAds_SWFCompressed($content))
					{
						$buffer = $this->swf_banner->phpAds_SWFDecompress($content);								
						$buffer = preg_replace('/clickTAG/i', 'clickTAG', $buffer);
						$content =$this->swf_banner->phpAds_SWFCompress($buffer);
					}
					else
					{									
						$content = preg_replace('/clickTAG/i', 'clickTAG', $content);
					}

					//Store width and height
					list($banner_width, $banner_height) = $this->swf_banner->phpAds_SWFDimensions($content);
					$pluginVersion  = $this->swf_banner->phpAds_SWFVersion($content);									
					$hardcodedLinks = $this->swf_banner->phpAds_SWFInfo($content);	
					if(!empty($hardcodedLinks))
					{
						//Remove Hardcoded link from swf file
						 if ($this->swf_banner->phpAds_SWFVersion($content) >= 3 && $this->swf_banner->phpAds_SWFInfo($content))
						 {
							// SWF's requiring player version 6+ which are already compressed should stay compressed
							if ($this->swf_banner->phpAds_SWFVersion($content) >= 6 && $this->swf_banner->phpAds_SWFCompressed($content))
							{
								$compress = true;
							}
							elseif (isset($compress))
							{
								$compress = true;
							}
							else
							{
								$compress = false;
							}
							if (!isset($convert_links))
							{
								$convert_links = array();
							}
							$convert_links = array_keys($hardcodedLinks);
							list($result, $parameters) = $this->swf_banner->phpAds_SWFConvert($content, $compress, $convert_links);
							if ($result != $content)
							{
								if (count($parameters) > 0)
								{
									// Prepare the parameters
									$parameters_complete = array();
									//Small hack to overwrite hard_coded values with lang:destination_url
									unset($overwrite_link);
									unset($overwrite_target);	
									$overwrite_link = array('0'=>$banner_url);

									$overwrite_target = array('0'=>$ban_target);	

										foreach ($parameters as $key => $val)
										{
											if (isset($overwrite_source) && $overwrite_source[$val] != '')
											{
												$overwrite_link[$val] .= '|source:'.$overwrite_source[$val];
											}
											$parameters_complete[$key] = array(
												'link' => $overwrite_link[0],
												'tar'  =>$overwrite_target[0],
											);
										}
										$parameters = array('swf' => $parameters_complete);
										
								}
								else
								{
									$parameters = '';
								}
								//When storing banner details into table,Don't forget to update parameters field
								$param = empty($parameters) ? null : serialize($parameters);
							}
						}	
					}
					else
					{
						$param = "N;";
					}

			/* dj_admin_approve added on dec-2 */
			$dj_admin_approve = $this->post('dj_admin_approve');
			if($dj_admin_approve == -1)
			{
					$creative_data = array(
						"contenttype"=>clean_data($content_type),
						"storagetype"=>clean_data($storage_type),
						"description"=>clean_data($this->post('flash_creative_name')),
						"filename"=>clean_data($this->post('tmp_flash_creative')),
						"width"=>clean_data($creative_width),
						"height"=>clean_data($creative_height),
						"parameters" => $param,
						"pluginversion" =>$pluginVersion ,
						"url"=>clean_data($this->post('destination_url')),
						"dj_banner_type"=>clean_data($bannertype),
						"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
						"dj_admin_approve"=>clean_data(0),
					);
			}else
			{
					$creative_data = array(
						"contenttype"=>clean_data($content_type),
						"storagetype"=>clean_data($storage_type),
						"description"=>clean_data($this->post('flash_creative_name')),
						"filename"=>clean_data($this->post('tmp_flash_creative')),
						"width"=>clean_data($creative_width),
						"height"=>clean_data($creative_height),
						"parameters" => $param,
						"pluginversion" =>$pluginVersion ,
						"url"=>clean_data($this->post('destination_url')),
						"dj_banner_type"=>clean_data($bannertype),
						"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
					);				
				
			}	
                    //Get agencyid from library
				    $agency_id=$this->user_authentication->agency_id;
					$creative_edit=$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id,$is_house_ad);


			//~ // added for edited creative status update
			//~ //29-06-2017
			//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
					
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_flash_creative'));

					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_flash_creative'));
				}
			}
			//IF FLASH NOT CHANGED
			else
			{
			/* dj_admin_approve added on dec-2 */
			$dj_admin_approve = $this->post('dj_admin_approve');
			if($dj_admin_approve == -1)
			{				
					$creative_data = array(
						"contenttype"=>clean_data($content_type),
						"storagetype"=>clean_data($storage_type),
						"description"=>clean_data($this->post('flash_creative_name')),
						"filename"=>clean_data($this->post('tmp_flash_creative')),
						"width"=>clean_data($creative_width),
						"height"=>clean_data($creative_height),
						"url"=>clean_data($this->post('destination_url')),
						"dj_banner_type"=>clean_data($bannertype),
						"updated"=>clean_data(date('Y:m:d :H:i:s')),
						"dj_admin_approve"=>clean_data(0),
					);
			}else
			{
					$creative_data = array(
						"contenttype"=>clean_data($content_type),
						"storagetype"=>clean_data($storage_type),
						"description"=>clean_data($this->post('flash_creative_name')),
						"filename"=>clean_data($this->post('tmp_flash_creative')),
						"width"=>clean_data($creative_width),
						"height"=>clean_data($creative_height),
						"url"=>clean_data($this->post('destination_url')),
						"dj_banner_type"=>clean_data($bannertype),
						"updated"=>clean_data(date('Y:m:d :H:i:s')),
					);				
				
			}	
					$creative_edit=$this->Do_web_creative->edit($creative_data,$creative_id,$is_house_ad);
					
			// added for edited creative status update
			//29-06-2017
			// $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}		
				
			}
			//IF BACK UP CREATIVE CHANGED
			if($this->post('old_backup_creative') != $this->post('tmp_backup_flash_creative'))
			{

					$backup_image_data=array(
									"banner_id"=>clean_data($creative_id),
									"file_path"=>clean_data($this->post('tmp_backup_flash_creative')),
									"width"=>clean_data($creative_width),
									"height"=>clean_data($creative_height),
									"content_type"=>clean_data($this->post('tmp_backup_flash_creative_content_type')),
									"created_date"=>clean_data(date('Y:m:d :H:i:s')),
									);
									
					$backup_image_data=$this->Do_web_creative->edit_creative_dependiences($backup_image_data,$creative_id);
							
					//On sucess move the web creative from tmp location to original location
					$is_backup_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_backup_flash_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_backup_creative'));
			}

			if($creative_edit)
			{
				$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('advertiser/creatives'),
								);
				$this->response( $success, 200);
				
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/creatives'),
								);	
				$this->response( $error, 200);
			}	
				
		}
	}
		
	 /*
	 * 
	 * name: edit_sql_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage WEB creative edit process
	 * 
	 */
	
	public function edit_sql_creative()
	{
		$this->form_validation->set_rules('web_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');

		$tmp_web_creative=$this->post('tmp_web_creative');
		if (empty($tmp_web_creative))
		{
			$this->form_validation->set_message('required', $this->lang->line('Crtv_iab_std'));
			$this->form_validation->set_rules('web_creative_edit','lang:creative', 'required');
		}

		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=$this->post('web_creative_id');
			$is_house_ad=$this->post('_is_house_ad');
			$old_creative_name=$this->post('old_creative');#FOR BLOB DATA

			$creative_data = array(
				"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
				"description"=>clean_data($this->post('web_creative_name')),
				"filename"=>clean_data($this->post('tmp_web_creative')),
				"url"=>clean_data($this->post('destination_url')),
				"updated"=>clean_data(date('Y:m:d :H:i:s')),
			);
			
			$blob_data=array(
				"filename"=>clean_data($this->post('tmp_web_creative')),
				"contents"=>file_get_contents($this->post('tmp_web_creative_url')),
				"t_stamp"=>clean_data(date('Y:m:d :H:i:s')),
			);

			//Get clientid from library file
		 	$agency_id=$this->user_authentication->agency_id;
			//Call to edit a creative
			$creative_edit=$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id,$is_house_ad);
			
			 if($creative_edit)
			 {
				if($this->post('old_creative') != $this->post('tmp_web_creative'))
				{
					//This method is only for database creative
					$creative_blob_edit=$this->Do_web_creative->edit_blob_data($blob_data,$old_creative_name);
					
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_web_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_creative'));
				}
				$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
		}
	}
		
	 /*
	 * 
	 * name: edit_url_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage WEB creative edit process
	 * 
	 */
	
	public function edit_url_creative()
	{
		$this->form_validation->set_rules('web_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$this->form_validation->set_rules('external_web_creative', 'lang:external_url', 'required|trim|callback_check_is_image_url|check_image_size');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=$this->post('web_creative_id');
			$is_house_ad=$this->post('_is_house_ad');

			$creative_data = array(
				"description"=>clean_data($this->post('web_creative_name')),
				"imageurl"=>clean_data($this->post('external_web_creative')),
				"url"=>clean_data($this->post('destination_url')),
				"updated"=>clean_data(date('Y:m:d :H:i:s')),
			);

			//Get clientid from library file
		 	$agency_id=$this->user_authentication->agency_id;
			//Call to edit a creative
			$creative_edit=$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id,$is_house_ad);
			

			if($creative_edit)
			{
				$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
		}
	}
		

	/*
	 * 
	 * name: creative_to_tmp_location_post
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected web creative to a temporary location
	 * 
	 */
	public function creative_to_tmp_location_post()
	{
		if($_FILES['creative'])
		{
			$creative=array(
					'file_name'   => $_FILES['creative']['name'],
					'tmp_name' => $_FILES['creative']['tmp_name'], 
					);
					
			$tmp_creative=$this->image_lib->move_creative_to_tmp_location($creative);
			
			if($tmp_creative)
			{
				$success = array(
								'response' => $tmp_creative['upload_data'],
								'msg'	 => $this->lang->line('moved_temporary_location')
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'redirect'=>site_url('advertiser/creatives/add_web_creatives'),
								'msg'	 => $this->lang->line('unabale_move_temporary_location')
				);
				$this->response($error, 200);
			}
		}
	}
	/*
	 * 
	 * name: delete_a_creative
	 * @param :
	 * @return :response array
	 * 
	 * Delete the creative in its original location
	 */
	
	public function delete_a_creative_post()
	{
		$tmp_creative_name=$this->post('creative_name');
		
		if($tmp_creative_name)
		{
			$is_tmp_creative=$this->image_lib->delete_creative_in_original_location($tmp_creative_name);

			if($is_tmp_creative)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => $this->lang->line('temporary_creative_deleted')
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_temporary_creative_file')
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_temporary_location_file')
							);
			$this->response($error, 200);
		}
	}
	/*
	 * 
	 * name: delete_a_tmp_creative
	 * @param :
	 * @return :response array
	 * 
	 * Delete the creative in temporary location
	 */
	
	public function delete_a_tmp_creative_post()
	{
		$tmp_creative_name=$this->post('creative_name');

		if($tmp_creative_name)
		{
			$is_tmp_creative=$this->image_lib->delete_creative_in_tmp_location($tmp_creative_name);

			if($is_tmp_creative)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => $this->lang->line('temporary_creative_deleted')
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => $this->alng->line('unable_delete_temporary_creative_file')
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_temporary_location_file')
							);
			$this->response($error, 200);
		}
	}
	/*** Custom Work  ***/
		public function add_billboard_creative_post()
	{
			
		
		$this->form_validation->set_rules('web_creative_name','lang:creative_name', 'required|trim');
		
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$is_external_web_creative = $this->post('is_external_web_creative');

		if($is_external_web_creative =='on')
			$this->form_validation->set_rules('external_web_creative', 'lang:creative_url', 'required|trim|url|callback_check_is_image_url|check_image_size');
		$campaign = $this->post('_web_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_web_campaign_id');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$is_db_store = $this->post('is_db_store');
			$blob_data=array();
			//Get account/agency_id from library file
			if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			$agency_id=$this->user_authentication->agency_id;

			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
				
			
			
			
			//If it is a database creative
			if($is_db_store=='on')
			{

				
				$storage_type='sql';
				$bannertype=WEB_CREATIVE_SQL;
				//Fetch width and height of the creative
				$creative_size=explode('x',$this->post('web_creative_size'));
				$creative_width=$creative_size[0];
				$creative_height=$creative_size[1];
				if(isset($creative_width) AND isset($creative_height) )
				{
					$creative_data = array(
						"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
						"campaignid"=>clean_data($campaign_id),
						"storagetype"=>clean_data($storage_type),
						"description"=>clean_data($this->post('web_creative_name')),
						"filename"=>clean_data($this->post('tmp_web_creative')),
						"width"=>clean_data($creative_width),
						"height"=>clean_data($creative_height),
						"url"=>clean_data($this->post('destination_url')),
						"dj_admin_approve"=>clean_data($dj_admin_approve),
						"dj_approved_date"=>clean_data($dj_approved_date),
						"dj_banner_type"=>"W_RS_B",
						"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
						"dj_account_id" => clean_data($dj_account_id)
					);
					$blob_data=array(
									"filename"=>clean_data($this->post('tmp_web_creative')),
									"contents"=>file_get_contents($this->post('tmp_web_creative_url')),
									"t_stamp"=>clean_data(date('Y:m:d :H:i:s')),
									);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_web_creative'));				
				}
			}
			else
			{
				//If it is a URL creative
				if($is_external_web_creative=='on')
				{
					$storage_type='url';
					$bannertype=WEB_CREATIVE_URL;
					//Fetch width and height of the creative
					$creative_size=explode('x',$this->post('web_creative_size'));
					$creative_width=$creative_size[0];
					$creative_height=$creative_size[1];
					if(isset($creative_width) AND isset($creative_height) )
					{
						$creative_data = array(
							"storagetype"=>clean_data($storage_type),
							"campaignid"=>clean_data($campaign_id),
							"description"=>clean_data($this->post('web_creative_name')),
							"imageurl"=>clean_data($this->post('external_web_creative')),
							"width"=>clean_data($creative_width),
							"height"=>clean_data($creative_height),
							"url"=>clean_data($this->post('destination_url')),
							"dj_admin_approve"=>clean_data($dj_admin_approve),
							"dj_approved_date"=>clean_data($dj_approved_date),							
							"dj_banner_type"=>"W_RS_B",
							"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_account_id" => clean_data($dj_account_id)
						);
					}
				}
				else
				{
					//If it is a web creative
					$storage_type='web';
					$bannertype=WEB_CREATIVE_BILLBOARD;
					//Fetch width and height of the creative
					$creative_size=explode('x',$this->post('web_creative_size'));
					$creative_width=970;
					$creative_height=250;
					if(isset($creative_width) AND isset($creative_height) )
					{
						$creative_data = array(
							"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
							"campaignid"=>clean_data($campaign_id),
							"storagetype"=>clean_data($storage_type),
							"description"=>clean_data($this->post('web_creative_name')),
							"filename"=>clean_data($this->post('tmp_web_creative')),
							"width"=>clean_data($creative_width),
							"height"=>clean_data($creative_height),
							"url"=>clean_data($this->post('destination_url')),
							"dj_admin_approve"=>clean_data($dj_admin_approve),
							"dj_approved_date"=>clean_data($dj_approved_date),							
							"dj_banner_type"=>"W_RS_B",
							"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_account_id" => clean_data($dj_account_id)
						);
							
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_web_creative'));
					}
				}
			}
			//Call to add a creative
			
			$creative_add=$this->Do_web_creative->add($creative_data,$blob_data,$agency_id,$is_house_ad);
			
			if($creative_add)
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('mobile_creative_added'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);
				}else{
					$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('mobile_creative_added'),
								'redirect'	 => site_url('admin/creatives/add_web_creatives/'),
								);
				}				
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);	
				}else{
					$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('admin/creatives/add_web_creatives/'),
								);	
				}					
				$this->response( $error, 200);
			}
		}	
    } 
	
	public function edit_billboard_creative_post()
	{
	
		$this->form_validation->set_rules('web_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$tmp_web_creative=$this->post('tmp_web_creative');
		if (empty($tmp_web_creative))
		{
			$this->form_validation->set_message('required', $this->lang->line('no_creative_selected'));
			$this->form_validation->set_rules('web_creative_edit','lang:creative', 'required');
		}

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=$this->post('web_creative_id');
			$is_house_ad=$this->post('_is_house_ad');

			$creative_data = array(
				"contenttype"=>clean_data($this->post('tmp_web_creative_content_type')),
				"description"=>clean_data($this->post('web_creative_name')),
				"filename"=>clean_data($this->post('tmp_web_creative')),
				"url"=>clean_data($this->post('destination_url')),
				"updated"=>clean_data(date('Y:m:d :H:i:s')),
			);
			
			//Get clientid from library file
		 	$agency_id=$this->user_authentication->agency_id;
		 	

		    //Call to edit a creative
			$creative_edit=$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id,$is_house_ad);
			

			if($creative_edit)
			{
				if($this->post('old_creative') != $this->post('tmp_web_creative'))
				{
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_web_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_creative'));
				}
				if($this->user_authentication->account_type === "ADVERTISER"){
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('advertiser/creatives/'),
								);
				}else{
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('admin/creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);	
				}else{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
	    }	
	
	}
	
	public function add_pushdown_creative_post()
	{		
		$this->form_validation->set_rules('creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$campaign = $this->post('_push_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_push_campaign_id');
		}			
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			
			$storage_type='web';
			$master_banner = '-3';
			
			
			
			//Get account/agency_id from library file
		     if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			$agency_id=$this->user_authentication->agency_id;
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}

			// Set width and height of the creative
			
			    
			   $img_width2=543;
			   $img_height2=307;   
			   $img_width= 970;
			   $img_height=90;
		

			
			$creative_data = array(
					"storagetype"=>clean_data($storage_type),
					"campaignid"=>clean_data($campaign_id),
					"description"=>clean_data($this->post('creative_name')),
					"url"=>clean_data($this->post('destination_url')),
					"width"=>clean_data($img_width),
					"height"=>clean_data($img_height),
					"dj_admin_approve"=>clean_data($dj_admin_approve),
					"dj_approved_date"=>clean_data($dj_approved_date),					
					"dj_banner_type"=>WEB_CREATIVE_PUSHDOWN,
					"dj_master_banner"=>clean_data($master_banner),
					"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_account_id" => clean_data($dj_account_id)
				);
				
				
			 $blob_data=FALSE;
			//Call to add a creative
			$banner_id = $this->Do_web_creative->add($creative_data,$blob_data,$agency_id,$is_house_ad);
				
			
			/*************************** ADD HORIZONTAL CREATIVES***************************/

			// Insert horizantal creative 1
			$additional_creative_data = array(
					"banner_id" => $banner_id,
					"file_path"=>clean_data($this->post('tmp_horizantal_ad1_creative')),
					"width"=>clean_data($img_width),
					"height"=>clean_data($img_height),
					"content_type"=>clean_data($this->post('tmp_horizantal_ad1_content_type')),
					"display_type" => WEB_CREATIVE_PUSHDOWN,
				//	"display_size" => X_LARGE,
					//"position" => MOBILE_CREATIVE_HORIZONTAL,
					"created_date"=>clean_data(date('Y:m:d :H:i:s')),
				);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_horizantal_ad1_creative'));
			$this->Do_web_creative->add_child($additional_creative_data);
			
			 $img_width1= 270;
			 $img_height1=40;
			 
			 
			 $additional_creative_data = array(
					"banner_id" => $banner_id,
					"file_path"=>clean_data($this->post('tmp_content_ad1_creative')),
					"width"=>clean_data($img_width1),
					"height"=>clean_data($img_height1),
					"content_type"=>clean_data($this->post('tmp_content_ad1_content_type')),
					"display_type" => WEB_CREATIVE_PUSHDOWN1,
					//"display_size" => X_LARGE,
					"created_date"=>clean_data(date('Y:m:d :H:i:s')),
				);
			 
				

			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_content_ad1_creative'));
			$this->Do_web_creative->add_child($additional_creative_data);
			


///////end horizantal creative 1////////////////////
              
			// Insert vertical creative 
			$additional_creative_data = array(
					"banner_id" => $banner_id,
					"file_path"=>clean_data($this->post('tmp_vertical_ad1_creative')),
					"width"=>clean_data($img_width2),
					"height"=>clean_data($img_height2),
					"content_type"=>clean_data($this->post('tmp_vertical_ad1_content_type')),
					"display_type" => WEB_CREATIVE_PUSHDOWN2,
					//"display_size" => X_LARGE,
					//"position" => MOBILE_CREATIVE_VERTICAL,
					"created_date"=>clean_data(date('Y:m:d :H:i:s')),
				);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_vertical_ad1_creative'));
			$this->Do_web_creative->add_child($additional_creative_data);
			
            // end vertical creative              
		
			$type1=$this->post('push_creative_size');
			
			if($type1=='img')
			{
				
				  $img_width3=367;
			      $img_height3=307;

			// Insert vertical creative 2
			$additional_creative_data = array(
					"banner_id" => $banner_id,
					"file_path"=>clean_data($this->post('tmp_vertical_ad2_creative')),
					"width"=>clean_data($img_width3),
					"height"=>clean_data($img_height3),
					"content_type"=>clean_data($this->post('tmp_vertical_ad2_content_type')),
					"display_type" => WEB_CREATIVE_PUSHDOWN3,
					//"display_size" => LARGE,
					//"position" => MOBILE_CREATIVE_VERTICAL,
					"created_date"=>clean_data(date('Y:m:d :H:i:s')),
				);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_vertical_ad2_creative'));
			$this->Do_web_creative->add_child($additional_creative_data);

			
		  }
		  else
		  {
			  
			  $additional_creative_data = array(
					"banner_id" => $banner_id,
					//"file_path"=>clean_data($this->post('tmp_vertical_ad2_creative')),
					//"width"=>clean_data($img_width3),
					//"height"=>clean_data($img_height3),
					"content_type"=>"TEXT",
					"display_type" => WEB_CREATIVE_TEXT,
					"dj_content_ad_message" =>htmlentities($this->post('text_content')),
					//"display_size" => LARGE,
					//"position" => MOBILE_CREATIVE_VERTICAL,
					"created_date"=>clean_data(date('Y:m:d :H:i:s')),
				);
				
			//On sucess move the base creative from tmp location to original location
			
			$this->Do_web_creative->add_child($additional_creative_data); 
			  
	      }	 							
			
			if($banner_id)
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);
				}else{
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
								'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);	
				}else{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}	
		
	
		
    }

    public function edit_pushdown_creative_post()
	{
		//$type=$this->post('web_creative_size');
		
	   $this->form_validation->set_rules('creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		
		#HORIZANTAL CREATIVES
		$tmp_horizantal_ad1_creative=$this->post('tmp_horizantal_ad1_creative');
		
		if (empty($tmp_horizantal_ad1_creative))
		{
			$this->form_validation->set_message('required', $this->lang->line('no_creative_selected'));
			$this->form_validation->set_rules('horizantal_ad1','lang:creative', 'required');
		}
		
		$tmp_content_ad1_creative=$this->post('tmp_content_ad1_creative');
		
		if (empty($tmp_content_ad1_creative))
		{
			$this->form_validation->set_message('required', $this->lang->line('no_creative_selected'));
			$this->form_validation->set_rules('content_ad1','lang:creative', 'required');
		}
		
		
		#VERTICAL CREATIVES
		$tmp_vertical_ad1_creative=$this->post('tmp_vertical_ad1_creative');
		
		if (empty($tmp_vertical_ad1_creative))
		{
			$this->form_validation->set_message('required', $this->lang->line('no_creative_selected'));
			$this->form_validation->set_rules('vertical_ad1','lang:creative', 'required');
		}
	    
	   
	    
	    
		$tmp_vertical_ad2_creative=$this->post('tmp_vertical_ad2_creative');
		
		
		
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=$this->post('port_creative_id');
			$is_house_ad=$this->post('_is_house_ad');
						
			$creative_data = array(
				"description"=>clean_data($this->post('creative_name')),
				"url"=>clean_data($this->post('destination_url')),
				"updated"=>clean_data(date('Y:m:d :H:i:s')),
			);
			
			//Get agency_id from library file
			$agency_id=$this->user_authentication->agency_id;
			
			#Call to edit a creative
			$creative_edit=$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id,$is_house_ad);

		
			 if($creative_edit)
			 {
				#Horizantal creatives
				if($this->post('old_horizantal_ad1_creative') != $this->post('tmp_horizantal_ad1_creative'))
				{
					
					
					$horizantal_creative_one = array(
					"file_path"=>clean_data($this->post('tmp_horizantal_ad1_creative')),
					"content_type"=>clean_data($this->post('tmp_horizantal_ad1_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					);
			
					
			
					$where = array('banner_id'=>$creative_id,'display_type'=>WEB_CREATIVE_PUSHDOWN);
					
					$this->Do_web_creative->edit_child_web($horizantal_creative_one,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_horizantal_ad1_creative'));
				
					
					
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_horizantal_ad1'));
			
				}
				
				
				if($this->post('old_content_ad1_creative') != $this->post('tmp_content_ad1_creative'))
				 {
					
					$horizantal_creative_two = array(
							"file_path"=>clean_data($this->post('tmp_content_ad1_creative')),
							"content_type"=>clean_data($this->post('tmp_content_ad1_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>WEB_CREATIVE_PUSHDOWN1);
					$this->Do_web_creative->edit_child_web($horizantal_creative_two,$where);

					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_content_ad1_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_content_ad1'));
				 #Vertical creatives
				 
			
			}
				
			    
				
				if($this->post('old_vertical_ad1_creative') != $this->post('tmp_vertical_ad1_creative'))
				{
					
					$vertical_creative_one = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad1_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad1_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
						); 
						
					
					
					$where = array('banner_id'=>$creative_id,'display_type'=>WEB_CREATIVE_PUSHDOWN2);
					$this->Do_web_creative->edit_child_web($vertical_creative_one,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_vertical_ad1_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_vertical_ad1'));
				}
						
			 if($tmp_vertical_ad2_creative!='')
			 {
				
				if($this->post('old_vertical_ad2_creative') != $this->post('tmp_vertical_ad2_creative'))
				{
					$vertical_creative_two = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad2_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad2_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
						);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>WEB_CREATIVE_PUSHDOWN3);
					$this->Do_web_creative->edit_child_web($vertical_creative_two,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_vertical_ad2_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_vertical_ad2'));
				}
			}
			else
			{
				$vertical_creative_two = array(						
							"dj_content_ad_message"=>htmlentities($this->post('text_content')),							          
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>WEB_CREATIVE_TEXT);
					$this->Do_web_creative->edit_child_web($vertical_creative_two,$where); 
		    }	
				
				#Content creatives
				
			
			}
			
			if($creative_edit)
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('advertiser/creatives/'),
								);
				}else{
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('admin/creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);	
				}else{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
		
    }	
    
    	public function add_sidekick_creative_post()
	{
		$this->form_validation->set_rules('sidekick_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$campaign = $this->post('_sidekick_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_sidekick_campaign_id');
		}			
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type='web';
			$master_banner = '-3';
			
			//Get account/agency_id from library file
		     if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			$agency_id=$this->user_authentication->agency_id;
						
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
				// Set width and height of the creative
			    $creative_size=explode('x',$this->post('sidekick_creative_size'));
				$creative_width=$creative_size[0];
				$creative_height=$creative_size[1];
				
				$creative_data = array(
					"contenttype"=>clean_data($this->post('tmp_base_creative_content_type')),
					"campaignid"=>clean_data($campaign_id),
					"storagetype"=>clean_data($storage_type),
					"description"=>clean_data($this->post('sidekick_creative_name')),
					"url"=>clean_data($this->post('destination_url')),
					"width"=>clean_data($creative_width),
					"height"=>clean_data($creative_height),
					"dj_banner_type"=>WEB_CREATIVE_SIDEKICK,
					"dj_admin_approve"=>clean_data($dj_admin_approve),
					"dj_approved_date"=>clean_data($dj_approved_date),					
					"dj_master_banner"=>clean_data($master_banner),
					"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_account_id" => clean_data($dj_account_id)
				);
				
				
                //Get agency_id from library file
			    $agency_id=$this->user_authentication->agency_id;
			     $blob_data=FALSE;     
				//Call to add a creative
				$banner_id = $this->Do_web_creative->add($creative_data,$blob_data,$agency_id,$is_house_ad);
				
				// Insert base creative 
				
				$base_creative_data = array(
					"banner_id" => $banner_id,
					"file_path"=>clean_data($this->post('tmp_base_creative')),
					"width"=>clean_data($creative_width),
					"height"=>clean_data($creative_height),
					"content_type"=>clean_data($this->post('tmp_base_creative_content_type')),
					"display_type" => WEB_CREATIVE_BASE,
					//"position" => WEB_CREATIVE_PORTRAIT,
					"created_date"=>clean_data(date('Y:m:d :H:i:s')),
				);
				
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_base_creative'));
				$this->Do_web_creative->add_child($base_creative_data);
				
				// Insert expand banner
				
				$expand_creative_width = '850';
				$expand_creative_height='700';
								
				$expand_creative_data = array(
					"banner_id" => $banner_id,
					"file_path"=>clean_data($this->post('tmp_sidekick_creative')),
					"width"=>clean_data($expand_creative_width),
					"height"=>clean_data($expand_creative_height),
					"content_type"=>clean_data($this->post('tmp_sidekick_creative_content_type')),
					"display_type" => WEB_CREATIVE_SIDEKICK,
					//"position" => WEB_CREATIVE_LANDSCAPE,
					"created_date"=>clean_data(date('Y:m:d :H:i:s')),
				);
				
				//On sucess move the expand creative from tmp location to original location
				$is_expand_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_sidekick_creative'));
				
				//Call to add a creative
				$creative_add = $this->Do_web_creative->add_child($expand_creative_data);
							
			
			if($creative_add)
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);
				}else{
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
								'redirect'	 => site_url('admin/creatives/add_web_creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);	
				}else{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	

	public function add_sliderbar_creative_post()
	{
		
		$this->form_validation->set_rules('sliderbar_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$campaign = $this->post('_sliderbar_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_sliderbar_campaign_id');
		}			
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type='web';
			$master_banner = '-3';
			
			//Get account/agency_id from library file
		     if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			$agency_id=$this->user_authentication->agency_id;
						
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
				// Set width and height of the creative
			    $creative_size=explode('x',$this->post('sliderbar_creative_size'));
				$creative_width=$creative_size[0];
				$creative_height=$creative_size[1];
				
				$creative_data = array(
					"contenttype"=>clean_data($this->post('tmp_base_creative_content_type')),
					"campaignid"=>clean_data($campaign_id),
					"storagetype"=>clean_data($storage_type),
					"description"=>clean_data($this->post('sliderbar_creative_name')),
					"url"=>clean_data($this->post('destination_url')),
					"width"=>clean_data($creative_width),
					"height"=>clean_data($creative_height),
					"dj_banner_type"=>WEB_CREATIVE_SLIDERBAR,
					"dj_admin_approve"=>clean_data($dj_admin_approve),
					"dj_approved_date"=>clean_data($dj_approved_date),					
					"dj_master_banner"=>clean_data($master_banner),
					"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_account_id" => clean_data($dj_account_id)
				);
				
				 $blob_data=FALSE;
                //Get agency_id from library file
			    $agency_id=$this->user_authentication->agency_id;
			
				//Call to add a creative
				$banner_id = $this->Do_web_creative->add($creative_data, $blob_data,$agency_id,$is_house_ad);
				
				// Insert base creative 
				
				$base_creative_data = array(
					"banner_id" => $banner_id,
					"file_path"=>clean_data($this->post('tmp_base_creative')),
					"width"=>clean_data($creative_width),
					"height"=>clean_data($creative_height),
					"content_type"=>clean_data($this->post('tmp_base_creative_content_type')),
					"display_type" => WEB_CREATIVE_BASE,
					//"position" => WEB_CREATIVE_PORTRAIT,
					"created_date"=>clean_data(date('Y:m:d :H:i:s')),
				);
				
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_base_creative'));
				$this->Do_web_creative->add_child($base_creative_data);
				
				// Insert expand banner
				
				$expand_creative_width = '950';
				$expand_creative_height='550';
								
				$expand_creative_data = array(
					"banner_id" => $banner_id,
					"file_path"=>clean_data($this->post('tmp_sliderbar_creative')),
					"width"=>clean_data($expand_creative_width),
					"height"=>clean_data($expand_creative_height),
					"content_type"=>clean_data($this->post('tmp_sliderbar_creative_content_type')),
					"display_type" => WEB_CREATIVE_SLIDERBAR,
					//"position" => WEB_CREATIVE_LANDSCAPE,
					"created_date"=>clean_data(date('Y:m:d :H:i:s')),
				);
				
				//On sucess move the expand creative from tmp location to original location
				$is_expand_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_sliderbar_creative'));
				
				//Call to add a creative
				$creative_add = $this->Do_web_creative->add_child($expand_creative_data);
							
			
			if($creative_add)
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);
				}else{
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
								'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);	
				}else{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('admin/creatives/add_web_creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
		
		
		

		
	}
    
  	public function edit_sidekick_creative_post()
	{
		$this->form_validation->set_rules('sidekick_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		#BASE CREATVES
		$tmp_base_creative=$this->post('tmp_base_creative');
		if (empty($tmp_base_creative))
		{
			$this->form_validation->set_message('required', $this->lang->line('no_creative_selected'));
			$this->form_validation->set_rules('base_creative','lang:creative', 'required');
		}
		#REVEAL CREATVES
		$tmp_reveal_creative=$this->post('tmp_sidekick_creative');
		if (empty($tmp_reveal_creative))
		{
			$this->form_validation->set_message('required', $this->lang->line('no_creative_selected'));
			$this->form_validation->set_rules('sidekick_creative','lang:creative', 'required');
		}
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=$this->post('sidekick_creative_id');
			$is_house_ad=$this->post('_is_house_ad');
						
			$creative_data = array(
				"contenttype"=>clean_data($this->post('tmp_base_creative_content_type')),
				"description"=>clean_data($this->post('sidekick_creative_name')),
				"url"=>clean_data($this->post('destination_url')),
				"updated"=>clean_data(date('Y:m:d :H:i:s')),
			);
			
			//Get agency_id from library file
			$agency_id=$this->user_authentication->agency_id;
			 
			//Call to edit a creative
			 $creative_edit=$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id,$is_house_ad);
			if($creative_edit) 
			{
				if($this->post('old_base_creative')!=$this->post('tmp_base_creative'))
				 {
					$base_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_base_creative')),
							"content_type"=>clean_data($this->post('tmp_base_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s'))
						);
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>WEB_CREATIVE_BASE
							
						);	
					
					//Call to edit a creative
					$this->Do_web_creative->edit_child_web($base_creative_data,$where_base);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_base_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_base_creative'));
				 }
				 
				 if($this->post('old_sidekick_creative')!=$this->post('tmp_sidekick_creative'))
				 {
					$sidekick_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_sidekick_creative')),
							"content_type"=>clean_data($this->post('tmp_sidekick_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s'))
						);
					 $where_reveal = array(
							'banner_id'=>$creative_id,
							'display_type'=>WEB_CREATIVE_SIDEKICK
							
						);	
					//Call to edit a creative
					$this->Do_web_creative->edit_child_web($sidekick_creative_data,$where_reveal);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_sidekick_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_sidekick_creative'));
				 }
			}
			
			if($creative_edit)
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('advertiser/creatives/'),
								);
				}else{
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('admin/creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);	
				}else{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	public function edit_sliderbar_creative_post()
	{  
		
		
		$this->form_validation->set_rules('sliderbar_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		#BASE CREATVES
		$tmp_base_creative=$this->post('tmp_base_creative');
		if (empty($tmp_base_creative))
		{
			$this->form_validation->set_message('required', $this->lang->line('no_creative_selected'));
			$this->form_validation->set_rules('base_creative','lang:creative', 'required');
		}
		#SLIDERBAR CREATVES
		$tmp_reveal_creative=$this->post('tmp_sidekick_creative');
		if (empty($tmp_reveal_creative))
		{
			$this->form_validation->set_message('required', $this->lang->line('no_creative_selected'));
			$this->form_validation->set_rules('sidekick_creative','lang:creative', 'required');
		}
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=$this->post('sidekick_creative_id');
			$is_house_ad=$this->post('_is_house_ad');
						
			$creative_data = array(
				"contenttype"=>clean_data($this->post('tmp_base_creative_content_type')),
				"description"=>clean_data($this->post('sliderbar_creative_name')),
				"url"=>clean_data($this->post('destination_url')),
				"updated"=>clean_data(date('Y:m:d :H:i:s')),
			);
			
			//Get agency_id from library file
			$agency_id=$this->user_authentication->agency_id;
			 
			//Call to edit a creative
			 $creative_edit=$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id,$is_house_ad);
			if($creative_edit) 
			{
				if($this->post('old_base_creative')!=$this->post('tmp_base_creative'))
				 {
					$base_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_base_creative')),
							"content_type"=>clean_data($this->post('tmp_base_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s'))
						);
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>WEB_CREATIVE_BASE
							
						);	
					
					//Call to edit a creative
					$this->Do_web_creative->edit_child_web($base_creative_data,$where_base);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_base_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_base_creative'));
				 }
				 
				 if($this->post('old_sidekick_creative')!=$this->post('tmp_sidekick_creative'))
				 {
					$sliderbar_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_sidekick_creative')),
							"content_type"=>clean_data($this->post('tmp_sidekick_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s'))
						);
					 $where_reveal = array(
							'banner_id'=>$creative_id,
							'display_type'=>WEB_CREATIVE_SLIDERBAR
							
						);	
					//Call to edit a creative
					$this->Do_web_creative->edit_child_web($sliderbar_creative_data,$where_reveal);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_sidekick_creative'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location($this->post('old_sidekick_creative'));
				 }
			}
			
			if($creative_edit)
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('advertiser/creatives/'),
								);
				}else{
					$success = array(
								'response' 		=> 	'ok',
								'msg'	 		=> 	$this->lang->line('mobile_creative_edited'),
								'redirect'	 => site_url('admin/creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER"){
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);	
				}else{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('admin/creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
		
	}
	/** ADDITIONAL AD FORMATS **/
	/*
	* Name: Ad formats
	* Worked By : suganthi
	* date: 2015-03-05
	*/
	 
	/*
	* 
	* name: add_popup_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage popup creative adding process
	*/
	
	public function add_popup_creative_post()
	{
		$this->form_validation->set_rules('pop_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$campaign = $this->post('_wpop_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_wpop_campaign_id');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	"web";
			$bannertype;
			if($this->post('poptype')=="popup"){
				$bannertype		=	WEB_CREATIVE_POPUP;
				}
				else{
					$bannertype		=	WEB_CREATIVE_POPUNDER;
					}
			
			
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
			}
			else
			{
				$dj_account_id	=	$this->user_authentication->default_advertiser_account_id;
			}
			
			$agency_id	=	$this->user_authentication->agency_id;
			
			$is_house_ad= 	$this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type	=	$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve	=	'0';
				$dj_approved_date	=	'';
			}			

			$creative_data = 	array(
									"campaignid"		=>	clean_data($campaign_id),
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('pop_creative_name')),
									"url"				=>	clean_data($this->post('destination_url')),"poptype"				=>clean_data($this->post('poptype')),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),						
									"dj_banner_type"	=>	clean_data($bannertype),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id)
								);
			//Call to add a creative
			$blob_data		=	FALSE;
			$creative_add	=	$this->Do_web_creative->add($creative_data,$blob_data,$agency_id,FALSE,$is_house_ad);

			if($creative_add)
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);
				}
				else
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	$this->lang->line('error_try_again'),
										'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);	
				}
				else
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	$this->lang->line('error_try_again'),
										'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	* 
	* name: edit_popup_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage popup creative editing process
	*/
	
	public function edit_popup_creative_post()
	{
		$this->form_validation->set_rules('pop_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id	=	$this->post('web_creative_id');
			$is_house_ad	=	$this->post('_is_house_ad');
			
			$storage_type	=	"web";
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$creative_data 	= 	array(
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('pop_creative_name')),
									"url"				=>	clean_data($this->post('destination_url')),
									"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
								);
			
			//Call to edit a creative
			$creative_edit	=	$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id,$is_house_ad);

			if($creative_edit)
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	=> 	site_url('advertiser/creatives/'),
								);
				}
				else
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	=> 	site_url('admin/creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	$this->lang->line('error_try_again'),
										'redirect'	=> 	site_url('advertiser/creatives/'),
									);	
				}
				else
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	$this->lang->line('error_try_again'),
										'redirect'	=> 	site_url('admin/creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
		
	 
	/*
	* 
	* name: add_xml_creative_post
	* @param
	* @return:response array
	* 
	* In this method we will manage popup creative adding process
	*/
	
	public function add_xml_creative_post()
	{
		$this->form_validation->set_rules('pop_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
	$this->form_validation->set_rules('xml_url', 'XML Path', 'required|trim|url');
		$campaign = $this->post('_wxml_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_wxml_campaign_id');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	"txt";
			$bannertype		=	WEB_CREATIVE_TEXT;
			
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
			}
			else
			{
				$dj_account_id	=	$this->user_authentication->default_advertiser_account_id;
			}
			
			$agency_id	=	$this->user_authentication->agency_id;
			
			$is_house_ad= 	$this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve	=	'1';
				$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type	=	$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve	=	'0';
				$dj_approved_date	=	'';
			}			

			$creative_data = 	array(
									"xml_type"		=>	WEB_CREATIVE_XML,
									"campaignid"		=>	clean_data($campaign_id),
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('pop_creative_name')),
									"url"				=>	clean_data($this->post('destination_url')),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),						
									"dj_banner_type"	=>	clean_data($bannertype),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"xml_path" 	=> 	clean_data($this->post('xml_url'))
								);
			//Call to add a creative
			$blob_data		=	FALSE;
			$creative_add	=	$this->Do_web_creative->add($creative_data,$blob_data,$agency_id,$is_house_ad);

			if($creative_add)
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);
				}
				else
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	$this->lang->line('error_try_again'),
										'redirect'	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);	
				}
				else
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	$this->lang->line('error_try_again'),
										'redirect'	=> 	site_url('admin/creatives/add_web_creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
		public function edit_xml_creative_post()
	{
		$this->form_validation->set_rules('pop_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$this->form_validation->set_rules('xml_url', 'lang:xml_path', 'required|trim|url');
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id	=	$this->post('web_creative_id');
			$is_house_ad	=	$this->post('_is_house_ad');
			
			$storage_type	=	"txt";
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$creative_data 	= 	array(
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('pop_creative_name')),
									"xml_path"			=>	clean_data($this->post('xml_url')),
									"url"				=>	clean_data($this->post('destination_url')),
									"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
								);
			
			//Call to edit a creative
			$creative_edit	=	$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id,$is_house_ad);

			if($creative_edit)
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	=> 	site_url('advertiser/creatives/'),
								);
				}
				else
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	=> 	site_url('admin/creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	$this->lang->line('error_try_again'),
										'redirect'	=> 	site_url('advertiser/creatives/'),
									);	
				}
				else
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	$this->lang->line('error_try_again'),
										'redirect'	=> 	site_url('admin/creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
	}

	public function delete_a_tmp_html_creative_post()
	{
		$tmp_creative_name=$this->post('creative_name');

		if($tmp_creative_name)
		{
			$is_tmp_creative=$this->image_lib->delete_creative_in_tmp_html_location($tmp_creative_name);

			if($is_tmp_creative)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => 'Temporary creative deleted'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the temporary creative file'
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the temporary location file'
							);
			$this->response($error, 200);
		}
	}
	public function creative_to_tmp_html_location_post()
	{

		if($_FILES['creative'])
		{
			$creative=array(
					'file_name'   => $_FILES['creative']['name'],
					'tmp_name' => $_FILES['creative']['tmp_name'], 
					);
	
				
			$tmp_creative=$this->image_lib->move_creative_to_tmp_html_location($creative);
			

			if($tmp_creative)
			{
				$success = array(
								'response' => $tmp_creative['upload_data'],
								'msg'	 => 'Moved to temporary location'
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'redirect'=>site_url('advertiser/creatives/add_web_creatives'),
								'msg'	 => 'Unable to move to temporary location '
				);
				$this->response($error, 200);
			}
		}
	}
	
	  	
}

