<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 *
 * All web Adblocks will be managed here 
 *
 * @package		ADX
 * @subpackage	Web Adblocks
 * @category	Controller
 * Author		Dinesh A
 * @link		http://www.djaxadexchange.com
*/


class Web_adblock extends REST_Controller
{
	protected $zone_type=3;
	public $min_floor_price;
	
	function __construct()
	{
		parent::__construct();	
		$this->load->model('Do_web_adblock');
		$this->load->model('Do_auto_link');	
		$this->load->model('Do_linking');		
		$this->load->model('Do_rtb');
		$this->load->model('Do_zone_link');		
		$this->min_floor_price =  $this->default_configurations->get('pub_min_floor_price');
	    $this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        if($this->user_authentication->is_valid_apikey($key)!='')
	    {
	   		$user_auth  = $this->user_authentication;
		    $this->response($user_auth->error, 200); 
	    }
	}
 	

		
	// api.v_1/web_adblock/add/format/json

    public function add_post(){
			
		$this->form_validation->set_rules('site_name','lang:site_name', 'required|trim');
		$this->form_validation->set_rules('block_name','lang:ad_block_name', 'required|trim');
		
		if($this->post('zone_type')!='W_TEXT')
		{
			//$this->form_validation->set_rules('block_size','lang:adblk_size', 'required|trim');
			$this->form_validation->set_rules('width','lang:width', 'required|trim');
			$this->form_validation->set_rules('height','lang:height', 'required|trim');
		}
		
		//Sets the minimum floor price
		// $min_floor_price = $this->default_configurations->get('pub_min_floor_price');
		
		$this->form_validation->set_rules('floor_price','lang:cpm_floor_price', 'required|trim|greater_than_equal_to['.$this->min_floor_price.']');
		
		if($this->form_validation->run() === FALSE)
		{
			 $error_msg = $this->form_validation->error_array();			

			 $error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{			
		
			$user_auth  = $this->user_authentication;
			$account_id = $user_auth->account_id;
			$agency_id = $user_auth->agency_id;
			#$account_id=$this->post('account_id');	
			
			if($account_id)
			{
				/* Fetch Affiliateid */	
				
				$affiliate_id=$this->Do_web_adblock->fetch_affiliateid($account_id);
				$this->db->trans_start();				
				
				if($this->post('zone_type')=='RISING')
				{
					//delivery number
					$delivery 		= 	delivery_value($this->post('rising_type'));	
					$dj_zone_type	=	$this->post('rising_type');			
				}
				else
				{
					if($this->post('zone_type')=='W_BAN')
					{
						$delivery 		= 	delivery_value($this->post('cross_zone_type'));
						$dj_zone_type	=	$this->post('cross_zone_type');
						if($this->post('cross_zone_type')=='C_A_BAN')
						{
							$width = '320';
							$height = '50';
						}
						else
						{
							$width = $this->post('width');
							$height = $this->post('height');
						}	
					}
					else if($this->post('zone_type')=='W_TEXT')
					{
						$delivery 		= 	delivery_value($this->post('cross_zone_type_txt'));
						$dj_zone_type	=	$this->post('zone_type');//$this->post('cross_zone_type_txt');	
						$width = $this->post('width');
						$height = $this->post('height');
					}
					else if($this->post('zone_type')=='V_A_IN')
					{
						//~ $delivery 		= 	delivery_value($this->post('cross_zone_type_vin'));
						$delivery 		= 	6;
						$dj_zone_type	=	$this->post('cross_zone_type_vin');
						$width = '-3';
						$height = '-3';
							
					}
					else if($this->post('zone_type')=='V_A_OL')
					{
						//~ $delivery 		= 	delivery_value($this->post('cross_zone_type_vol'));
						$delivery 		= 	7;
						$dj_zone_type	=	$this->post('cross_zone_type_vol');	
						$width = '-2';
							$height = '-2';
					}
					else
					{
					//delivery number
					$delivery 		= 	delivery_value($this->post('zone_type'));
					$dj_zone_type	=	$this->post('zone_type');	
					$width = $this->post('width');
					$height = $this->post('height');
					}	
					
				}
				
				 $delivery_priority='';
        	if($this->post('delivery_type')=="housead"){
				
					$delivery_priority='housead';
					
					 }
					 else{
						 $delivery_priority='passback';
						 }
				 	
				$add_web_adblockObj=array(	
											"deliver_type"  	=>	$delivery_priority,				
											"zonename"  	=>	clean_data($this->post('block_name')),
											"affiliateid"	=>	$affiliate_id,
											"zonetype"		=>	$this->zone_type,
											"delivery"		=>  $delivery,
											"dj_zone_type"	=>	$this->post('zone_type'),
											"width" 		=>	$width,
											"height"		=>  $height,
											"dj_floor_price"=>	clean_data($this->post('floor_price')),
											"dj_passback_tag"=>	stripslashes($this->post('passback_tag')),
											"dj_added_date"	=>	date("Y-m-d H:i:s"),
											 "rtb_type"	 => clean_data($this->input->post('type_bidding'))
											
									);								
				$zone_id=$this->Do_web_adblock->add($add_web_adblockObj);			
				
				$add_web_adblockAssoc = array("site_id"=> clean_data($this->post('site_name')),
											  "zone_id"=> $zone_id,	
										);
				$this->Do_web_adblock->addAssoc($add_web_adblockAssoc);
				$link_type=$this->default_configurations->get('linking_type');    
				$bidding_type = $this->input->post('type_bidding');
				if($bidding_type==1) {
				$dsp_id = implode(",",$this->post('select_dsp'));			
				}
				if($link_type !='manual linking')
				{
					if($bidding_type==0)
					{
						$this->Do_auto_link->link_ads($zone_id,$agency_id);
					}
					else if(!empty($dsp_id) && $bidding_type==1)
					{
						//$dsp_id = implode(",",$web_adblock_info['select_dsp']);
						if($dsp_id=='all'){
							$dsp_details=$this->Do_rtb->list_dsp();
						
						foreach($dsp_details as $key=>$value){
							$dspid[] = $value['exchange_id'];
						}
			
						 $dsp_ids = implode(",",$dspid);
							
						}
						else{
							$dsp_ids =$dsp_id;
						}
						$this->Do_zone_link->link_ads($zone_id, $housead = 1,$dsp_ids);
							if($zone_id != FALSE){
				  
							$dsp_id = implode(",",$this->post('select_dsp'));
					 
							if($dsp_id)
							{
				
							$this->Do_rtb->add_aff_dsp_assoc($zone_id, $dsp_id); 
							}
						}
					}
				}
				else{
					$house_ad=1;
					if($bidding_type==1) {
						$dsp_id = implode(",",$this->post('select_dsp'));
					}
					$bidding_type = $this->input->post('type_bidding');
					if($bidding_type==0)
					{
						$this->Do_auto_link->link_ads($zone_id,$agency_id,$house_ad);
					
					}
					else if(!empty($dsp_id) && $bidding_type==1)
					{
						if($dsp_id=='all'){
							$dsp_details=$this->Do_rtb->list_dsp();
						
						foreach($dsp_details as $key=>$value){
							$dspid[] = $value['exchange_id'];
						}
			
						 $dsp_ids = implode(",",$dspid);
							
						}
						else{
							$dsp_ids =$dsp_id;
						}
						$this->Do_zone_link->link_ads($zone_id, $housead = 1,$dsp_ids);
						if($zone_id != FALSE){
				 
						$dsp_id = implode(",",$this->post('select_dsp'));
					
							if($dsp_id)
							{
					
								$this->Do_rtb->add_aff_dsp_assoc($zone_id, $dsp_id); 
							}
						}
					}
				} 
           
            $bidding_type = $this->input->post('type_bidding');
            
			
			 
			if($bidding_type == 1){
		
			$dsp_id = implode(",",$this->post('select_dsp')); 
			
            if($dsp_id)
            {
            $zone_type = $this->post('zone_type');  		
            $site_details = $this->Do_rtb->fetch_site_details($this->post('site_name')); 
             
			if( $this->post('zone_type')=='W_TEXT' || $this->post('zone_type')=='M_A_TXT'){
							$ban_attr = '1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17';
						}else{
							$ban_attr = '1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,17';
						}
						 
            $rtb_zone_update_details = array(
                "zoneid" => $zone_id,
                "req_tmax" => clean_data($this->post('max_time')),
                "ban_btype" => '1,3,4',
                "ban_battr" => $ban_attr,
                "vid_playervideo" => clean_data($this->post('pvideo')),
                "vid_width" => clean_data($this->post('pwidth')),
                "vid_height" => clean_data($this->post('pheight')),
                "vid_min" => clean_data($this->post('video_min')),
                "vid_max" => clean_data($this->post('video_max')),
                "vid_sd" => clean_data($this->post('v_s_delay')),
                "vid_play" => clean_data($this->post('v_playbalck')),
                "vid_skip" => clean_data($this->post('v_skip')),
                "vid_roll_sec" => clean_data($this->post('seconds')),
                "vid_skipafter" => clean_data($this->post('skip_seconds')),
                "vid_comptype" => clean_data($this->post('v_compan_type')),               
                "vid_lin" => clean_data($linear),
                "vid_minbit" => clean_data($this->post('v_min_bit_rate')),
                "vid_maxbit" => clean_data($this->post('v_max_bit_rate')),
                "vid_del" => clean_data($this->post('delvy_methods')),
                "vid_compad" => clean_data($this->post('compad')),
                "vid_comp_width" => clean_data($this->post('c_width')),
                "vid_comp_height" => clean_data($this->post('c_height')),
                "imp_bidfloor" => clean_data($this->post('floor_price')),
                "imp_bidfloorcur" => "USD",
                "user_gender" => 'all',
				//~ "app_id" => clean_data($this->post('app_id')),
                //~ "app_name" => clean_data($this->post('app_name')),
                //~ "app_bundle" => clean_data($this->post('app_bundle')),
                "app_url" => clean_data($this->post('app_url')),
                //~ "app_cat" => $site_details[0]['category_id'],
                //~ "app_section" => $site_details[0]['category_id'],               
                //~ "app_page" => $site_details[0]['category_id'],               
                "app_privacy" => 1,
                //~ "app_ver" => clean_data($this->post('app_ver')),
                "app_paid" => clean_data($this->post('app_paid')),
                "imagertb" => clean_data($this->post('imagertb')),
                "videortb" => clean_data($this->post('videortb')),
                "apprtb" => clean_data($this->post('apprtb')),
                "rtb_id" => $dsp_id,
               // "site_cat" => $site_details[0]['category_id']
            );
          //print_r($rtb_zone_update_details); exit;
            $rtb_zone_update = $this->Do_rtb->rtb_zone_update($rtb_zone_update_details);
		 }
	 }
				// Rtb linking by Kavin 27.7.17
				$this->db->trans_complete();
				
				$success = array(	
								'response' => 'ok',
								'msg'	 => $this->lang->line('web_adblk_succ')
				);
			
							
				$this->response($success, 200);
		
			}else{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('not_valid_acc')
				);	
			}
		}

	}


	
	/* 
	 *post valusea
	 */
    public function set_category_post(){
			
		$targ_value = $this->post('value');
		if($targ_value == 'Empty')
		{
			$targ_value = '';
		}else if(!$targ_value )
		{
			$targ_value = '';
		}
		
	$this->response($targ_value,200);	
		
		
	
	}
	
	
	
	
	
	/* 
	 *sri 
	 */
    public function add_rtb_objects_post(){		
		

		
	$rtb_val =	$this->post('type_obj');
	$zone_id =	$this->post('zoneid');	
	/*************Impression*******************/
	$imp_dm =	$this->post('manager_name');
	$imp_dms =	$this->post('manager_version');
	$imp_currency =	$this->post('imp_currency_code');
	$imp_tagid =	$this->post('tag_id');
	$imp_bidfloor =	$this->post('bid_floor');
	$clk_browser =	$this->post('clk_browser');
	$imp_secure =	$this->post('imp_secure');
	$imp_iframe =	$this->post('iframe_buster');
	$imp_exp =	$this->post('seconds');
		
	
	/**************Request********************/
	
	$req_test =	$this->post('testtype');
	$req_wseat =	$this->post('req_whitelist_buyer_seat');
	$req_allimps =	$this->post('allimps');
	$req_bcat =	$this->post('request_category');
	$req_badv =	$this->post('badv');
	$req_bapp =	$this->post('bapp');
	
	
	/**************Banner********************/
	
	$ban_btype =	implode(',',$this->post('ban_bannertype'));
	$ban_blockattr =	implode(',',$this->post('ban_battr'));
	$ban_mimes =	implode(',',$this->post('ban_mimetype'));		
	
	/*************Deal************************/
	$dl_bid_floor =	$this->post('dl_bid_floor');
	$dl_cur_code =	$this->post('dl_currency_code');
	$dl_whitelist_buyer_seat =	$this->post('dl_whitelist_buyer_seat');
	$dl_adv_domain =	$this->post('dl_adv_domain');
	$dl_auc_type =	$this->post('dl_auc_type');
	$pmp_auction =	$this->post('pmp_private_auction');
		switch($rtb_val)
		{
			case 'imp_obj':
			$rtb_id = 2;
			break;
			case 'req_obj':
			$rtb_id = 1;
			break;
			case 'banner_obj':
			$rtb_id = 4;
			break;
			case 'pmp_obj':
			$rtb_id = 18;
			break;
			case 'deal_obj':
			$rtb_id = 16;
			break;
			default:
			$rtb_id = 0;
			break;
			
			
		}
		
		$data = array('rtb_id'=>$rtb_id,'imp_dm'=>$imp_dm, 'imp_dms'=>	$imp_dms,'imp_currency'=>$imp_currency,'imp_tagid'=>$imp_tagid,'imp_bidfloor'=>$imp_bidfloor,'clk_browser' => $clk_browser,'imp_secure'=>$imp_secure,'imp_iframe'=>$imp_iframe,'imp_exp'=>$imp_exp,'req_test'=>$req_test ,'req_wseat'=>$req_wseat ,'req_allimps'=>$req_allimps,'req_bcat'=>$req_bcat,'req_badv'=>$req_badv,'req_bapp'=>$req_bapp,'dl_bid_floor'=>$dl_bid_floor,'dl_currency_code'=>$dl_cur_code,'dl_whitelist_buyer_seat'=>$dl_whitelist_buyer_seat,'dl_adv_domain'=>$dl_adv_domain,'dl_auc_type'=>$dl_auc_type,'pmp_auction' => $pmp_auction,'ban_btype'=>$ban_btype,'ban_blkattr'=>$ban_blockattr,'ban_mimes'=>$ban_mimes );
		
		$check = $this->Do_web_adblock->fetch_exchange_assoc($zone_id,$data);
				 
		if($check)
		{		
			
		$update = $this->Do_web_adblock->update_exchange_assoc($zone_id,$data);
		if($update)
		{
			
			$response = array(	'response' 	=> 	'ok','msg' => 	$this->lang->line('obj_updated_succ'));
			
			$this->response($response, 200);
		}
		else{
		
			$response = array(	
								'response' 	=> 	'error',
								'msg'		=> 	$this->lang->line('error_updating_objects')	);
			
			
			$this->response($response, 200);
		}
		
		}
		else{
			
		$insert = $this->Do_web_adblock->insert_exchange_assoc($zone_id,$data);
		if($insert)
		{
			
			$response = array(
			'response'=>'ok',
			'msg'=>$this->lang->line('objects_added_suc')
			);
			
			$this->response($response, 200);
		}
		else{
		
			$response = array(
			'response'=>'error',
			'msg'=>$this->lang->line('err_upda_objts')
			);
			
			$this->response($response, 200);
		}
		
		
		}


	}
	
	
	
	/*
	 *sri 
	 */
public	function fetch_currency_get(){
		
		$currency_code = $this->Do_web_adblock->fetch_currency_code($zone_id);
		
	
		if($currency_code)
		{
			
			$this->response($currency_code, 200);
		}
		else{
		
			$response = array('response'=>'error','msg'=>$this->lang->line('currency_code_not_available'));
			
			$this->response($response, 200);
		}
		
		
		   
	 }
	 
	
	
	/*
	 *sri 
	 */
public	function fetch_blocked_attr_get(){
		
		$currency_code = $this->Do_web_adblock->fetch_blockedattr();
		
	
		if($currency_code)
		{
			
			$this->response($currency_code, 200);
		}
		else{
		
			$response = array('response'=>'error','msg'=>$this->lang->line('currency_code_not_available'));
			
			$this->response($response, 200);
		}
		
		
		   
	 }
	 
	
	
	
	/**
       * 
       * name : fetch_exchange_data_get()
       * sri
       * @params : zone_id
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function fetch_exchange_data_get()
	{
		
		$zoneid 	= $this->input->get_post('zone_id');
		
		
		if($zoneid)
		{
			
				$zone_exchange_dat = $this->Do_web_adblock->fetch_exchange_assoc($zoneid);
			
				
							
				$this->response($zone_exchange_dat, 200);
			
		}else{
			$this->response(array('error' => $this->lang->line('zone_is_not_provided')), 404);	
		}
	}
	
	
	
	
	
	
	
	
	function zonesizelist_get()
	 {
					
		    $zone_sizes=$this->Do_web_adblock->list_zonesizes();		  
		   
		   if($zone_sizes)
			{
				$this->response($zone_sizes, 200); // 200 being the HTTP response code
			}

			else
			{
				$this->response(array('error' => $this->lang->line('zone_not_found')), 404);
			}
		   
	 }
	 
	 /*
	 * 
	 * name: fetch_ads_post
	 * @param :
	 * @return : Array
	 * 
	 * Returns a sets off matched Ads
	 */
	 
	function fetch_ads_post()
	{
		$this->load->model('Do_linking');
		
       $agency_id=$this->user_authentication->agency_id;	
	
	   	$zone_id 		=	$this->post('zone_id');
	   	
		
		
		if($zone_id)
		{
			$result		=	array(	
								'response' 	=> 	'ok',
								'msg'		=> 	$this->Do_linking->fetch_ads($zone_id,$agency_id)
							);
		}
		else
		{
			$result 	= array(
							'response' 	=>	'error',
							'msg'	 	=>	$this->lang->line('zoneid_not_found')
						);
		}
		
		$this->response( $result, 200);
	}
	
	 
	 /*
	 * 
	 * name: fetch_campaigns_post
	 * @param :
	 * @return : Array
	 * 
	 * Returns a sets off matched Ads
	 */
	 
	function fetch_campaigns_post()
	{
		
		$this->load->model('Do_linking');
		
		$agency_id=$this->user_authentication->agency_id;	
	
	   	$zone_id 		=	$this->post('zone_id');
	   	
	  
		if($zone_id)
		{
			$result		=	array(	
								'response' 	=> 	'ok',
								'msg'		=> 	$this->Do_linking->fetch_ads_campaigns($zone_id,$agency_id)
							);
		}
		else
		{
			$result 	= array(
							'response' 	=>	'error',
							'msg'	 	=>	$this->lang->line('zoneid_not_found')
						);
		}
		
		$this->response( $result, 200);
	}
	 
	 
	 
	 
	 
	 
	/**
       * 
       * name : fetch_get()
       * 
       * @params : account_id and zone_id
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	 function fetch_get($site_id=FALSE)
	 {
					
		   #$account_id = $this->get('account_id');
		   $user_auth  = $this->user_authentication;
		   $account_id = $user_auth->account_id;
		   
		   $zone_id	   = $this->get('zone_id');	
		   $siteid=$this->input->get('siteid');
		 	
			if($account_id){
			
			
					$site_list = $this->Do_web_adblock->fetch_both_adblock($account_id,$zone_id,$site_id);
			
			
				$this->response($site_list);
				
			}
	}
	
	 function fetch_adblock_get()
	 {
					
		   #$account_id = $this->get('account_id');
		   $user_auth  = $this->user_authentication;
		   $account_id = $user_auth->account_id;
		   
		    $siteid=$this->input->get_post('siteid');
		  // $siteid     = $this->post('siteid');	

			if($account_id){
				
				$site_list = $this->Do_web_adblock->fetch_adblocks($account_id,$siteid);
				$this->response($site_list,200);
				
			}
	}

	
	function fetch_pub_get()
	{
		$zone_id = $this->get('zone_id');

		if($zone_id)
		{
			$zone_data = $this->Do_web_adblock->fetch_publisher($zone_id);
			
			if($zone_data)
			{
			  $this->response($zone_data[0]['account_id'], 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}		
	}

	/**
       * 
       * name : update_put()
       * 
       * @params : zone_id
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		$agency_id	= $this->user_authentication->agency_id;
		$zoneid 	= $this->post('zone_id');
		$rtb_select=$this->post('hidden_rtb');
		 $zone_type = $this->post('zone_type');
		if($zoneid)
		{
			$this->form_validation->set_rules('block_name','lang:ad_block_name', 'required|trim');
		
			if($this->post('zone_type')!='W_TEXT')
			{
				$this->form_validation->set_rules('block_size','lang:adblk_size', 'required|trim');
				$this->form_validation->set_rules('width','lang:width', 'required|trim');
				$this->form_validation->set_rules('height','lang:height', 'required|trim');
			}
			$this->form_validation->set_rules('floor_price','lang:cpm_floor_price', 'required|trim||greater_than_equal_to['.$this->min_floor_price.']');
			
			if($this->form_validation->run() ===FALSE){
			
				$error_msg = $this->form_validation->error_array();
				$error = array(
									'response' => 'error',
									'msg' =>  $error_msg
								);

				 $this->response( $error, 200);
			}else{
			
				$site = $this->Do_web_adblock->update($this->post(),$agency_id);
				
				
			
               $zone_type = $this->post('zone_type');
           
                $bidding_type = $this->input->post('type_bidding');
          
			 
			if($bidding_type == 1){
			//~ /* static pARAM */
				$site_details = $this->Do_rtb->fetch_site_details($this->post('rtb_site')); 
						if( $this->post('zone_type')=='W_TEXT' || $this->post('zone_type')=='M_A_TXT'){
							$ban_attr = '1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17';
						}else{
							$ban_attr = '1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,17';
						}
			 
               
			
			$dsp_id = implode(",",$this->post('select_dsp'));
		
			if($dsp_id)
			{
//~ 
				$this->Do_rtb->add_aff_dsp_assoc($zoneid, $dsp_id); 
			
			}
			//~ /*STATIC PARAM */
            $rtb_zone_update_details = array(
                "zoneid" => $zoneid,
                "req_tmax" => '200',
                "ban_btype" => '1,3,4',
                "ban_battr" => $ban_attr,
                "vid_playervideo" => clean_data($this->post('pvideo')),
                "vid_width" => clean_data($this->post('pwidth')),
                "vid_height" => clean_data($this->post('pheight')),
                "vid_min" => clean_data($this->post('video_min')),
                "vid_max" => clean_data($this->post('video_max')),
                "vid_sd" => clean_data($this->post('v_s_delay')),
                "vid_play" => clean_data($this->post('v_playbalck')),
                "vid_skip" => clean_data($this->post('v_skip')),
                "vid_roll_sec" => clean_data($this->post('seconds')),
                "vid_skipafter" => clean_data($this->post('skip_seconds')),
                "vid_comptype" => clean_data($this->post('v_compan_type')),               
                "vid_lin" => clean_data($linear),
                "vid_minbit" => clean_data($this->post('v_min_bit_rate')),
                "vid_maxbit" => clean_data($this->post('v_max_bit_rate')),
                "vid_del" => clean_data($this->post('delvy_methods')),
                "vid_compad" => clean_data($this->post('compad')),
                "vid_comp_width" => clean_data($this->post('c_width')),
                "vid_comp_height" => clean_data($this->post('c_height')),
                "imp_bidfloor" => clean_data($this->post('floor_price')),
                "imp_bidfloorcur" => "USD",
                "user_gender" => 'all',
				//~ "app_id" => clean_data($this->post('app_id')),
                //~ "app_name" => clean_data($this->post('app_name')),
                //~ "app_bundle" => clean_data($this->post('app_bundle')),
                "app_url" => clean_data($this->post('app_url')),
                //~ "app_cat" => $site_details[0]['category_id'],
                //~ "app_section" => $site_details[0]['category_id'],               
                //~ "app_page" => $site_details[0]['category_id'],               
                "app_privacy" => 1,
                //"app_ver" => clean_data($this->post('app_ver')),
                "app_paid" => clean_data($this->post('app_paid')),
                "imagertb" => clean_data($this->post('imagertb')),
                "videortb" => clean_data($this->post('videortb')),
                "apprtb" => clean_data($this->post('apprtb')),
                "rtb_id" => $dsp_id,
                //"site_cat" => $site_details[0]['category_id']
            );
            
              
				$this->db->select('*');
                $this->db->where(array('zoneid'=>$zoneid));
                $param_query = $this->db->get('ox_exchange_zone_assoc');
                	
                if($param_query->num_rows()>0){
					
                    $rtb_zone_update = $this->Do_rtb->rtb_zone_edit_update($rtb_zone_update_details);
                    
                }else{
					
                    $this->db->insert('ox_exchange_zone_assoc',$rtb_zone_update_details);
                   
                }
                
              //~ }else{
				  //~ 
                  //~ $this->rtb_zone_edit_params_remove($rtb_zone_update_details);
                  //~ }
              //~ $rtb_zone_update = $this->Do_rtb->rtb_zone_edit_update($rtb_zone_update_details);
               
           }
				
				$success = array(
								'response' => 'ok',
								'redirect'=>site_url('publisher/web_ad_blocks'),
								'msg'	 => $this->lang->line('web_ad_updt_suc')
				);
			
							
				$this->response($success, 200);
			}
		}else{
			$this->response(array('error' => $this->lang->line('zone_not_available_id')), 404);	
		}
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{
		
		$zone_id = $this->get('zone_id');	
		
		if($zone_id)
		{
			$zone_id = $this->Do_web_adblock->delete($zone_id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('adblk_deleted')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('zoneid_not_found')
					);
			
			$this->response( $error, 200);
		}
	}
	/*
	 * 
	 * name: linked_process_post
	 * @param :
	 * @return : Update status
	 * 
	 * Insert/Update zone-ad assoc
	 */
	function linked_process_post()
	{
		 
		
		
		$zone_id 		=	$this->post('zone_id');
		$ad_ids 		=	$this->post('ad_ids');
	
	
		for($i=0;$i<count($ad_ids);$i++)
		{
			
				$result=$this->Do_linking->check_revenue_type($ad_ids[$i]);
					
				if($result==1)
		        {
					$banner_ids[]=$ad_ids[$i];
			    }	
			    
				
         }
	 
				if($zone_id)
				{
					$result		=	array(	
										'response' 	=> 'ok',
										'msg'		=> $this->Do_linking->linked_ads_process($zone_id, $banner_ids)
									);
				}
				else
				{
					$result 	= 	array(
										'response' 	=>	'error',
										'msg'	 	=>	$this->lang->line('zoneid_not_found')
									);
				}
				
			 

	          $this->response($result, 200);
	 
	}
	 
	
	function link_campaigns_post() 
	{
		
		$zone_id 		=	$this->post('zone_id');
		$campaign_ids 		=	$this->post('ad_ids');
		$agency_id=$this->user_authentication->agency_id;
		if($zone_id)
		{
			$result		=	array(	
								'response' 	=> 'ok',
								'msg'		=> $this->Do_linking->link_campaigns($zone_id, $campaign_ids, $agency_id)
							);
		}
		else
		{
			$result 	= 	array(
								'response' 	=>	'error',
								'msg'	 	=>	$this->lang->line('zoneid_not_found')
							);
		}

	  $this->response($result, 200);
	 
	}
	
	
	/**
       * 
       * name : generate_adtags_post()
       * 
       * Generates the Ad tags with custom settings
       * 
       * @return the generated response
    */
	
	
	function generate_adtags_post()
	{
		
		$zone_id = $this->post('zoneid');
	
		
		if($zone_id)
		{
			
			$webadblock_tag = $this->generate_webadblock_tag($this->post());
			
			$success = array('response'=>'ok',
							 'msg'=>$webadblock_tag
						);	 	
			
			
			$this->response($success);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('zoneid_not_found')
					);
			
			$this->response( $error, 200);
		}
	}
	
	/*get dsp site status start */
	function fetch_dsp_get()
	{
		$zoneid 	= $this->get('zone_id');
		$dsp_site = $this->Do_web_adblock->dsp_site_status($zoneid);
		$this->response($dsp_site, 200);
	}
	function fetch_video_details_get()
	{
		$zoneid 	= $this->get('zone_id');
		$video_details = $this->Do_web_adblock->video_details($zoneid);
		$this->response($video_details, 200);
	}
	/* get dsp site status end*/
	private function generate_webadblock_tag($values =FALSE)
	{
		if($values !='')
		{
			//$encoded_string = base64_decode($values['encode_string']);
			$encoded_string = http_build_query($values);
			
			$site_url = str_replace("index.php","",site_url());
			
			$path = $site_url."".$this->config->item("ads_delivery_path_file")."?";
			
			//$source  = $values['source'];
			
			return '<script type="text/javascript" src="'.$path.''.$encoded_string.'"></script>';	
		}else{
			return FALSE;	
		}	
	}
	
	function generate_adtags_no_player_post()
    {
		$ad_type = $this->post('ad_type');
        $zone_id = $this->post('zoneid1');
        $vast    = $this->post('vast');
        
        $tag_type    = $this->post('tag_type');
        

      
        
        if ($vast == 1) {
            $format = 'vast1';
        } else if ($vast == 2) {
            $format = 'vast2';
        } else if ($vast == 3) {
            $format = 'vast3';
        } else if ($vast == 4) {
            $format = 'vast_pod';
        } else if ($vast == 5) {
            $format = 'vast1_wrapper';
        } else if ($vast == 6) {
            $format = 'vast2_wrapper';
        } else if ($vast == 7) {
            $format = 'vast3_wrapper';
        } else if ($vast == 8) {
            $format = 'vast_pod_wrapper';
        }
        else if ($vast == 9) {
            $format = 'vmap';
        } 
        else if ($vast == 10) {
            $format = 'vpaid1';
        }
        else if ($vast == 11) {
            $format = 'vpaid2';
        }
        else if ($vast == 12) {
            $format = 'vpaid3';
        }
        else if ($vast == 13) {
            $format = 'vpaid2_wrapper';
        }
        else if ($vast == 14) {
            $format = 'vpaid3_wrapper';
        }
        else {
            $format = '';
        }
        
          if($tag_type == 3)
        {
			$success        = array(
                'response' => 'ok',
                'msg' => site_url().'/vast_api/ads?zone_id='.$zone_id.'&format='.$format
            );
			$this->response($success);
		}
        
        $oposition = $this->post('oposition');
        if ($oposition == 1) {
            $zones = 'preroll';
        } else if ($oposition == 2) {
            $zones = 'midroll';
        } else if ($oposition == 3) {
            $zones = 'postroll';
        } else {
            $zones = '';
        }
        $midroll = $this->post('adstime');
          if( $this->post('limit') != '')
        {
			$limit   = $this->post('limit');
		}
		else
		{
			$limit = 15;
		}
        if($tag_type == 4){
			/*$msg = '<script type="text/javascript" src="'.base_url().'vast_mediation/vast.js?pwidth='.$this->post('pwidth').'&pheight='.$this->post('pheight').'&ptype='.$this->post('ptype').'&pvideo='.$this->post('pvideo').'&rtmpurl='.$this->post('rtmpurl').'&pimg=&autoplay='.$this->post('autoplay').'&format='.$format.'&vast='. $vast .'&limit=&oposition='.$this->post('oposition').'&adstime='.$this->post('adstime').'&sharing='.$this->post('sharing').'&mute='.$this->post('mute').'&repeat='.$this->post('repeat').'&title_desc='.$this->post('title_desc').'&p_title='.$this->post('p_title').'&p_desc='.$this->post('p_desc').'&stretching='.$this->post('stretching').'&overadstime=&adduration=&zonetype='.$ad_type.'&zoneid='.$zone_id.'&player='.$this->post('playtype').'&compad='.$this->post('compad').'&cheight='.$this->post('cheight').'&cwidth='.$this->post('cwidth').'&age={age}&gender={gender}&site={site}&sentiment={sentiment}&eventid={eventid}&'.$this->lang->line('cust_targeting_1').'='.$this->lang->line('CUSTOM_TARG1').'&'.$this->lang->line('cust_targeting_2').'='.$this->lang->line('CUSTOM_TARG2').'&'.$this->lang->line('cust_targeting_3').'='.$this->lang->line('CUSTOM_TARG3').'&'.$this->lang->line('cust_targeting_4').'='.$this->lang->line('CUSTOM_TARG4').'"></script>';*/

			$msg = '<script type="text/javascript" src="'.base_url().'vast_mediation/vast.js?pwidth='.$this->post('pwidth').'&pheight='.$this->post('pheight').'&ptype='.$this->post('ptype').'&pvideo='.$this->post('pvideo').'&rtmpurl='.$this->post('rtmpurl').'&pimg=&autoplay='.$this->post('autoplay').'&format='.$format.'&vast='. $vast .'&limit=&oposition='.$this->post('oposition').'&adstime='.$this->post('adstime').'&sharing='.$this->post('sharing').'&mute='.$this->post('mute').'&repeat='.$this->post('repeat').'&title_desc='.$this->post('title_desc').'&p_title='.$this->post('p_title').'&p_desc='.$this->post('p_desc').'&stretching='.$this->post('stretching').'&overadstime=&adduration=&zonetype='.$ad_type.'&zoneid='.$zone_id.'&player='.$this->post('playtype').'&compad='.$this->post('compad').'&cheight='.$this->post('cheight').'&cwidth='.$this->post('cwidth').'"></script>';
			
			$success        = array(
                'response' => 'ok',
                'msg' => $msg
            );
			$this->response($success);
		}
        
        $values = array(
			'ad_type' => $ad_type,
            'vast' => $format,
            'adstime' => $midroll,
            'oposition' => $zones,
            'zoneid' => $zone_id,
            'limit' => $limit
        );
       
        
        	if($tag_type == 2){  
			$site_url = str_replace("index.php","",site_url());
					
			$path = $site_url."".$this->config->item("ads_delivery_path_file")."?zoneid=".$zone_id."&player=".$this->post('playtype')."&compad=".$this->post('compad')."&cwidth=".$this->post('cwidth')."&cheight=".$this->post('cheight')."&rtmpurl=".$this->post('rtmpurl')."&p_title=".$this->post('p_title')."&p_desc=".$this->post('p_desc')."&";
					
			/*$msg = '<script type="text/javascript" src="'.$path.'pwidth='.$this->post('pwidth').'&pheight='.$this->post('pheight').'&ptype=1&pvideo='.$this->post('pvideo').'&pimg=&autoplay='.$this->post('autoplay').'&format='.$format.'&vast='. $vast .'&mute='. $this->post('mute') .'&repeat='. $this->post('repeat') .'&stretching='. $this->post('stretching') .'&title_desc='. $this->post('title_desc') .'&limit='.$limit.'&oposition='.$this->post('oposition').'&adstime='.$this->post('adstime').'&zoneid='.$zone_id.'&age={age}&gender={gender}&site={site}&sentiment={sentiment}&eventid={eventid}&'.$this->lang->line("cust_targeting_1").'='.$this->lang->line('CUSTOM_TARG1').'&'.$this->lang->line("cust_targeting_2").'='.$this->lang->line('CUSTOM_TARG2').'&'.$this->lang->line("cust_targeting_3").'='.$this->lang->line('CUSTOM_TARG3').'&'.$this->lang->line("cust_targeting_4").'='.$this->lang->line('CUSTOM_TARG4').'"></script>';*/

			$msg = '<script type="text/javascript" src="'.$path.'pwidth='.$this->post('pwidth').'&pheight='.$this->post('pheight').'&ptype=1&pvideo='.$this->post('pvideo').'&pimg=&autoplay='.$this->post('autoplay').'&format='.$format.'&vast='. $vast .'&mute='. $this->post('mute') .'&repeat='. $this->post('repeat') .'&stretching='. $this->post('stretching') .'&title_desc='. $this->post('title_desc') .'&limit='.$limit.'&oposition='.$this->post('oposition').'&adstime='.$this->post('adstime').'&zoneid='.$zone_id.'"></script>';
			
			$success        = array(
                'response' => 'ok',
                'msg' => $msg
            );
			$this->response($success);
		}
		
        if ($zone_id) {
            
            $webadblock_tag = $this->generate_webadblock_tag_no_player($values);
            $success        = array(
                'response' => 'ok',
                'msg' => $webadblock_tag
            );
            
            
            $this->response($success);
            
        } else {
            
            $error = array(
                'response' => 'error',
                'msg' =>$this->lang->line('zoneid_not_found')
            );
            
            $this->response($error, 200);
        }
    }
    
    private function generate_webadblock_tag_no_player($values = FALSE)
    {
        if ($values != '') {
            $ad_type   = $values['ad_type'];
            $zoneid    = $values['zoneid'];
            $vtype 		= $values['vast'];
			$oposition = $values['oposition'];
            $limit     = $values['limit'];
          
            if($ad_type != 'overlay'){
				$oposition = $values['oposition'];
			}
			else
			{
				$oposition = 'overlay';
			}
            $oposition='preroll';
            $encoded_string = http_build_query($values);
            
            $site_url = str_replace("index.php", "", site_url());
            
            $path = $site_url . "" . "ads/www/delivery/fc.php" . "?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&";
            if ($vtype == 'vast_pod') {
				   /*$string = "zones=$oposition:0.0-0%3D$zoneid&nz=1&source=&r=R0.05822725687175989&block=1&limit=$limit&format=$vtype&charset=UTF-8&age={age}&gender={gender}&site={site}&sentiment={sentiment}&eventid={eventid}&".$this->lang->line('cust_targeting_1')."=".$this->lang->line('CUSTOM_TARG1')."&".$this->lang->line('cust_targeting_2')."=".$this->lang->line('CUSTOM_TARG2')."&".$this->lang->line('cust_targeting_3')."=".$this->lang->line('CUSTOM_TARG3')."&".$this->lang->line('cust_targeting_4')."=".$this->lang->line('CUSTOM_TARG4');*/
				   $string = "zones=$oposition:0.0-0%3D$zoneid&nz=1&source=&r=R0.05822725687175989&block=1&limit=$limit&format=$vtype&charset=UTF-8";
                
            } 
             else if ($vtype == 'vast_pod_wrapper') {
				   // $string = "zones=$oposition:0.0-0%3D$zoneid&nz=1&source=&r=R0.05822725687175989&block=1&limit=$limit&format=$vtype&charset=UTF-8&age={age}&gender={gender}&site={site}&sentiment={sentiment}&eventid={eventid}&".$this->lang->line('cust_targeting_1')."=".$this->lang->line('CUSTOM_TARG1')."&".$this->lang->line('cust_targeting_2')."=".$this->lang->line('CUSTOM_TARG2')."&".$this->lang->line('cust_targeting_3')."=".$this->lang->line('CUSTOM_TARG3')."&".$this->lang->line('cust_targeting_4')."=".$this->lang->line('CUSTOM_TARG4');
             	$string = "zones=$oposition:0.0-0%3D$zoneid&nz=1&source=&r=R0.05822725687175989&block=1&limit=$limit&format=$vtype&charset=UTF-8";
            }else {
                  // $string = "zones=$oposition:0.0-0%3D$zoneid&nz=1&source=&r=R0.05822725687175989&block=1&format=$vtype&charset=UTF-8&age={age}&gender={gender}&site={site}&sentiment={sentiment}&eventid={eventid}&".$this->lang->line('cust_targeting_1')."=".$this->lang->line('CUSTOM_TARG1')."&".$this->lang->line('cust_targeting_2')."=".$this->lang->line('CUSTOM_TARG2')."&".$this->lang->line('cust_targeting_3')."=".$this->lang->line('CUSTOM_TARG3')."&".$this->lang->line('cust_targeting_4')."=".$this->lang->line('CUSTOM_TARG4');
            	$string = "zones=$oposition:0.0-0%3D$zoneid&nz=1&source=&r=R0.05822725687175989&block=1&format=$vtype&charset=UTF-8";
             
            }
            return '' . $path . '' . $string . '';
            
        } else {
            return FALSE;
        }
    }
    function dsp_zone_wise_linking_update($site_details, $zone_type,$zoneid){

			$dsp_exchange_id[0] = $site_details[0]['dsp_id'];
		
			if($dsp_exchange_id == 'all'){
				
				$this->db->select('bannerid, campaignid, dj_banner_type');
				$this->db->where( array('exchange_id !=' => 0,'dj_admin_approve' => 1,'dj_is_deleted' => 0));
				
				//DAC - end
				 if($zone_type == 'W_TEXT')
                {   
                    $this->db->where("dj_banner_type",'W_TEXT');
                }elseif($zone_type == 'W_BAN')
                {
                    $this->db->where("dj_banner_type",'W_IMG');
                }

                // mobile zone linkign 
                 if($zone_type == 'M_A_IM')
                {   
                    $this->db->where("dj_banner_type",'M_IMG');
                }elseif($zone_type == 'M_A_TXT')
                {
                    $this->db->where("dj_banner_type",'M_TEXT');
                }

                // cross zone linking
                  if($zone_type == 'C_A_IM')
                {   
                    $this->db->where_in("dj_banner_type",'M_IMG,W_IMG');
                }elseif($zone_type == 'C_A_TXT')
                {
                    $this->db->where_in("dj_banner_type",'M_TEXT,W_TEXT');
                }
                // video zone linking 
                elseif($zone_type == 'V_A_IN' || $zone_type == 'V_A_OL')
                {
                    $this->db->where("dj_banner_type",'V_IN');
                }
				
				$query = $this->db->get(TAB_BANNERS);
				
				$banner_details = $query->result_array();
	
				}else{

					$banner_details = $this->Do_rtb->fetch_banner_details_zonewise($dsp_exchange_id,$zone_type);
			
				}
				
				
				if($banner_details)
				{

					foreach($banner_details as $banner)
					{
                    	
						$zone_baner_det = array(
										'zone_id'=>$zoneid,
										'ad_id'=>$banner['bannerid'],
										'campaign_id' => $banner['campaignid']
																		);
						$campaignid = $banner['campaignid'];

						$banner_details = $this->Do_rtb->linking_dsp_ad($zone_baner_det);
						
						
					}

					return TRUE;
				}
				else
				{
					return FALSE;
				}
			
		}
		function fetch_rtb_params_get()
		{
			
			$zone_id    = $this->input->get('zone_id');  
			$rtb_params = $this->Do_rtb->fetch_rtb_params($zone_id);
		  
			if ($rtb_params) {
				$this->response($rtb_params, 200); // 200 being the HTTP response code
			} else {
				$this->response(array(
					'error' => 'Zone Sizes could not be found'
				), 404);
			}
			
		}
    
	
}
