<?php defined('BASEPATH') OR exit('No direct script access allowed');

/** 
 * Video creatives
 *
 * All Video creative will be managed here 
 *
 * @package		ADX
 * @subpackage	Video creatives
 * @category	Controller
 * @author		Suganthi s
 * @link		http://www.djaxadserver.com
*/

class Video_creative extends REST_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('Do_video_creative');
		$this->load->model('Do_auto_link');
		$this->load->model('Do_web_creative');
		$this->load->model('Do_creative');
		$this->load->library('user_authentication');
		$this->load->library('default_configurations');
		$key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
	
 	/*
	 * 
	 * name: add_video_inline_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all INLINE VIDEO CREATIVE add process	 
	 */
	public function add_video_inline_creative_post()
	{	
		
		//print_r($this->post());exit;
		$delivery	=	$this->post('inline_delivery_method');		
		
		$this->form_validation->set_rules('video_inline_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('inline_delivery_method', 'lang:delivery_type', 'required|trim');		
		//vpaid jayashree
		
		$vpaid_enable=$this->post('vapid_enable');
		if($vpaid_enable==1)
		{
			$vpaid_api_url=$this->post('vpaid_url');
			$vpaid_expand=$this->post('vapid_expand');
			$vpaid_type=$this->post('vpaid_type');
			if($vpaid_expand==1)
			{
				$vpaid_expand_width=$this->post('resize_width');
				$vpaid_expand_height=$this->post('resize_height');
			}
			else if($vpaid_expand==0)
			{
				$vpaid_expand_width='';
				$vpaid_expand_height='';
			}
			$vpaid_remain_time=$this->post('vpaid_remain_time');
			$vpaid_icon_url=$this->post('vpaid_icon_url');
			$vpaid_video_volume=$this->post('vpaid_video_volume');
		}
		
		
		
		//Vpaid jayashree
		if($this->post('inline_url'))
		{
			$this->form_validation->set_rules('inline_url', 'Destination URL', 'required|trim|url');
		}	
		
		$skip_offset 		= $this->post('skip_offset');	
		$progress_offset 	= $this->post('progress_offset');	
		/*3rd Party ad tag 
		 * Name:Pradeep.M
		 * Date:23-05-2016*/
		 if($delivery=='vast')
		{
		$thirdparty_vast_tag	=	$this->post('thirdparty_vast_tag');
		$vast_version			=	$this->post('vast_version');
	}
		/*VMAP URL and Tag*/
		$adbreak1_tag 		= $this->post('adbreak1_tag');
		$adbreak2_tag 		= $this->post('adbreak2_tag');	
		$adbreak3_tag 		= $this->post('adbreak3_tag');
		$vmap_midroll_skipoffset = $this->post('vmap_skip_offset');		
		$campaign = $this->post('_vin_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_vin_campaign_id');
		}
		
		if($delivery=='streaming')
		{
			$this->form_validation->set_rules('inline_rtmpurl', 'lang:rtmp_url', 'required|trim|url');
			$this->form_validation->set_rules('inline_rtmp_filename', 'lang:rtmp_file_name', 'required|trim');
			$this->form_validation->set_rules('inline_rtmp_duration', 'lang:rtmp_video_duration', 'required|trim');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'1';
			$bannertype		=	($this->post('_type') == 'mobile') ? MOBILE_VIDEO_CREATIVE_INLINE : VIDEO_CREATIVE_INLINE;				
			$storagetype	=	'html';
			$width			=	'-3';
			$height			=	'-3';
			$ext_bannertype = 	"bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml";
				$clicktrackurl			=	$this->post('clicktrackurl');
			$clicktrackcustomurl	=	$this->post('clicktrackcustomurl');
			//Get account/agency_id from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			
			$agency_id=$this->user_authentication->agency_id;
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
			
			if($delivery=='progressive')
			{	
				if($this->post('tmp_video_inline_creative')!='')
				{
					//~ $this->response($this->post());
					$is_video_creative_moved_ffmpeg	=	$this->image_lib->move_creative_to_ffmpeg_location($this->post('tmp_video_inline_creative'));
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_inline_creative'));
					//~ $this->response("MOVED",200); 
					if($this->commandExists("ffmpeg")>0) 
					{
						$upload_path		=	$this->config->item('creative_path');
						
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	$this->post('tmp_video_inline_creative');
						$output 			= 	$this->post('tmp_video_inline_creative_raw_name').'.flv';
						
						
						$raw_name			=	$this->post('tmp_video_inline_creative_raw_name');

						$ext				=	$this->post('tmp_video_inline_creative_file_ext');

						$input_with_path  	= 	$upload_path.$this->post('tmp_video_inline_creative');
						$output_with_path 	= 	$upload_path.$output;
						
						
						$hlsStreaming = $this->HlsStreaming($this->post());
						
						$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						//~ $this->response( $video_duration, 200);
						
						$video_duration		=	!empty($video_duration) ? $video_duration : 30;	
					}
					else 
					{
						$video_duration		=	'30';	
					}
							
					$video_name			=	$this->post('tmp_video_inline_creative');
					if($this->post('tmp_video_inline_creative_content_type')=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	$this->post('tmp_video_inline_creative_content_type');
					}
					
					$toCheckExist = $this->config->item('creative_path').$this->post('tmp_video_inline_creative_raw_name')."/playlist.m3u8";
					$headers=get_headers($toCheckExist);
					if(stripos($headers[0],"200 OK"))
					{
						$outgoing_filename_m3u8 = $this->config->item('creative_path').$this->post('tmp_video_inline_creative_raw_name')."/playlist.m3u8";
						$outType = "m3u8";
					}
					else
					{
						$outgoing_filename_m3u8	=	"nope";
						$outType = "nope";
					}					
					$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_inline_creative');
				}
			}
			elseif($delivery=='streaming')
			{	
				$video_name			=	'';				
				$video_duration		=	$this->post('inline_rtmp_duration');
				$rtmp_url			=	$this->post('inline_rtmpurl');
				$rtmp_filename		=	$this->post('inline_rtmp_filename');
				if(strpos($rtmp_filename, '.') != false)
				{
					$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
				}
				else
				{
					$type			=	'flv';
				}
				$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
				$video_type			=	'video/x-'.$type;
				
			}

			//jayashree
			
			$companion_width 	= 	$this->post('inline_companion_width');
				$companion_height 	= 	$this->post('inline_companion_height');
				$companionclicktrackurl 	= 	$this->post('companionclicktrackurl');
				$expanded_width 	= 	$this->post('expanded_width');
				$expanded_height 	= 	$this->post('expanded_height');
				
			
			if($this->post('inline_companion_size')!='')
			{
				$size 				= 	explode("x",$this->post('inline_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				
			
				if($this->post('tmp_inline_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_inline_creative_name').' Companion';
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_inline_companion_creative_content_type')),
												"campaignid"		=>	clean_data($campaign_id),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_inline_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data($this->post('inline_url')),
												"dj_master_banner"	=>	clean_data($master_banner),
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_banner_type" 	=> 	($this->post('_type') == 'mobile') ? MOBILE_COMPANION_IMAGE_CREATIVE : WEB_CREATIVE_WEB,
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id" 	=> 	clean_data($dj_account_id)
											);
										
						$companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,$is_house_ad);
						//$this->response( $companion_id, 200);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_inline_companion_creative'));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				else
				{
					$companion_id	=	$this->post('vast_companion_id');
					if($companion_id !='')
					{
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					
					}else
					{$companion_id	=	$this->post('vast_companion_id');
						
					}
				}
			}
			else
			{
				$companion_id	=	0;
			}				
			//vpaid jayashree			
			$vpaid_enable=$this->post('vapid_enable');
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_outgoing_filename_m3u8' 	=>	$outgoing_filename_m3u8,
									'vast_video_outgoing_streaming_type' =>	$outType, 
									'vast_video_clickthrough_url' 	=> 	$this->post('inline_url'),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	'',
									'vast_video_skip_duration'					=>  $skip_offset,
									'vast_video_skip_progress_duration'				=>  $progress_offset,
									'vast_thirdparty_companion_clicktracking'=>	clean_data($companionclicktrackurl),
									'vast_thirdparty_companion_expandedwidth'		=>	clean_data($expanded_width),
									'vast_thirdparty_companion_expandedheight'		=>	clean_data($expanded_height),
									'is_vpaid'	=> clean_data($vpaid_enable),
									'vpaid_url'	=> clean_data($vpaid_api_url),
									'vpaid_type'	=> clean_data($vpaid_type),
									'vpaid_expanded'=> clean_data($vpaid_expand),
									'vpaid_width'	=> clean_data($vpaid_expand_width),
									'vpaid_height'	=> clean_data($vpaid_expand_height),
									'vpaid_icons'	=> clean_data($vpaid_icon_url),
									'vpaid_remainingTime'	=> clean_data($vpaid_remain_time),
									'vpaid_volume'	=> clean_data($vpaid_video_volume),
									
									'adbreak_tag1'	=> clean_data($adbreak1_tag),
									'adbreak_tag2'	=> clean_data($adbreak2_tag),
									'adbreak_tag3'	=> clean_data($adbreak3_tag),
									'vmap_midroll_skipoffset'	=> clean_data($vmap_midroll_skipoffset),
									'vast_wrapper_url'	=> clean_data($thirdparty_vast_tag)
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$contenttype = $this->post('tmp_video_inline_creative_content_type');
			
			$creative_data 	= array(		 										
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"contenttype"		=>	clean_data($video_type),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_inline_creative_name')),
									"filename"			=>	clean_data($video_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('inline_url')),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id)
								);
			//Call to add a creative
			$creative_id	=	$this->Do_video_creative->add_video($creative_data,$agency_id,$is_house_ad);
	//$this->response( $creative_id, 200);
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('inline_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_video_skip_duration"		=>  $skip_offset,
										"vast_video_skip_progress_duration"=>  $progress_offset,
										"vast_thirdparty_clicktracking"		=>	clean_data($clicktrackurl),
									    "vast_thirdparty_clickcustom"    =>	clean_data($clicktrackcustomurl),	
										"vast_thirdparty_companion_clicktracking"=>	clean_data($companionclicktrackurl),
										"vast_thirdparty_companion_expandedwidth"=>	clean_data($expanded_width),
										"vast_thirdparty_companion_expandedheight"=>	clean_data($expanded_height),
										"vast_wrapper_url"	=> clean_data($thirdparty_vast_tag),
										"is_vpaid"	=> clean_data($vpaid_enable),
										"vpaid_url"	=> clean_data($vpaid_api_url),
										"vpaid_type"	=> clean_data($vpaid_type),
										"vpaid_expanded"=> clean_data($vpaid_expand),
										"vpaid_width"	=> clean_data($vpaid_expand_width),
										"vpaid_height"	=> clean_data($vpaid_expand_height),
										"vpaid_icons"	=> clean_data($vpaid_icon_url),
										"vpaid_remainingTime"	=> clean_data($vpaid_remain_time),
										"vpaid_volume"	=> clean_data($vpaid_video_volume),
										"adbreak_tag1"	=> clean_data($adbreak1_tag),
										"adbreak_tag2"	=> clean_data($adbreak2_tag),
										"adbreak_tag3"	=> clean_data($adbreak3_tag),
										"vmap_midroll_skipoffset"	=> clean_data($vmap_midroll_skipoffset),
										"vast_version" => clean_data($vast_version)		
									);
									
				$vast_add	=	$this->Do_video_creative->add_video_vast($vast_data);
				
				if($vast_add)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);
					$this->response( $success, 200);
					
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}

	public function add_video_rewarded_creative_post()
	{	
		
		//print_r($this->post());exit;
		$delivery	=	$this->post('rewarded_delivery_method');		
		
		$this->form_validation->set_rules('video_rewarded_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('rewarded_delivery_method', 'lang:delivery_type', 'required|trim');		
		//vpaid jayashree
		
		$vpaid_enable=$this->post('vapid_enable');
		if($vpaid_enable==1)
		{
			$vpaid_api_url=$this->post('vpaid_url');
			$vpaid_expand=$this->post('vapid_expand');
			$vpaid_type=$this->post('vpaid_type');
			if($vpaid_expand==1)
			{
				$vpaid_expand_width=$this->post('resize_width');
				$vpaid_expand_height=$this->post('resize_height');
			}
			else if($vpaid_expand==0)
			{
				$vpaid_expand_width='';
				$vpaid_expand_height='';
			}
			$vpaid_remain_time=$this->post('vpaid_remain_time');
			$vpaid_icon_url=$this->post('vpaid_icon_url');
			$vpaid_video_volume=$this->post('vpaid_video_volume');
		}
		else
		{
			$vpaid_api_url = "";
			$vpaid_expand = "";
			$vpaid_type = "";
			$vpaid_expand_width='';
			$vpaid_expand_height='';
			$vpaid_remain_time= "";
			$vpaid_icon_url= "";
			$vpaid_video_volume= "";
		}
		
		
		//Vpaid jayashree
		if($this->post('rewarded_url'))
		{
			$this->form_validation->set_rules('rewarded_url', 'Destination URL', 'required|trim|url');
		}	
		
		$skip_offset 		= $this->post('skip_offset');	
		$progress_offset 	= $this->post('progress_offset');	
		/*3rd Party ad tag 
		 * Name:Pradeep.M
		 * Date:23-05-2016*/
		 if($delivery=='vast')
		{
			$thirdparty_vast_tag	=	$this->post('thirdparty_vast_tag');
			$vast_version			=	$this->post('vast_version');
		}
		else
		{
			$thirdparty_vast_tag	=	"";
		}
		/*VMAP URL and Tag*/
		$adbreak1_tag 		= $this->post('adbreak1_tag');
		$adbreak2_tag 		= $this->post('adbreak2_tag');	
		$adbreak3_tag 		= $this->post('adbreak3_tag');
		$vmap_midroll_skipoffset = $this->post('vmap_skip_offset');		
		$campaign = $this->post('_vin_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_vin_campaign_id');
		}
		
		if($delivery=='streaming')
		{
			$this->form_validation->set_rules('rewarded_rtmpurl', 'lang:rtmp_url', 'required|trim|url');
			$this->form_validation->set_rules('rewarded_rtmp_filename', 'lang:rtmp_file_name', 'required|trim');
			$this->form_validation->set_rules('rewarded_rtmp_duration', 'lang:rtmp_video_duration', 'required|trim');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'1';
			//$bannertype		=	($this->post('_type') == 'mobile') ? MOBILE_VIDEO_CREATIVE_INLINE : VIDEO_CREATIVE_INLINE;				
			$bannertype		=	MOBILE_VIDEO_CREATIVE_REWARDED;				
			$storagetype	=	'html';
			$width			=	'-3';
			$height			=	'-3';
			$ext_bannertype = 	"bannerTypeHtml:djaxRewardedInlineVideoad:vastInlineHtml";
			$clicktrackurl			=	$this->post('clicktrackurl');
			$clicktrackcustomurl	=	$this->post('clicktrackcustomurl');
			//Get account/agency_id from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			
			$agency_id=$this->user_authentication->agency_id;
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
			
			if($delivery=='progressive')
			{	
				if($this->post('tmp_video_rewarded_creative')!='')
				{
					//~ $this->response($this->post());
					$is_video_creative_moved_ffmpeg	=	$this->image_lib->move_creative_to_ffmpeg_location($this->post('tmp_video_rewarded_creative'));
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_rewarded_creative'));
					//~ $this->response("MOVED",200); 
					if($this->commandExists("ffmpeg")>0) 
					{
						$upload_path		=	$this->config->item('creative_path');
						
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	$this->post('tmp_video_rewarded_creative');
						$output 			= 	$this->post('tmp_video_rewarded_creative_raw_name').'.flv';
						$raw_name			=	$this->post('tmp_video_rewarded_creative_raw_name');
						$ext				=	$this->post('tmp_video_rewarded_creative_file_ext');
						$input_with_path  	= 	$upload_path.$this->post('tmp_video_rewarded_creative');
						$output_with_path 	= 	$upload_path.$output;
						
						
						$hlsStreaming = $this->HlsStreaming($this->post());
						
						//$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						//~ $this->response( $video_duration, 200);
						
						//$video_duration		=	!empty($video_duration) ? $video_duration : 30;	
					}
					
							
					$video_name			=	$this->post('tmp_video_rewarded_creative');
					if($this->post('tmp_video_rewarded_creative_content_type')=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	$this->post('tmp_video_rewarded_creative_content_type');
					}
					
					$toCheckExist = $this->config->item('creative_path').$this->post('tmp_video_rewarded_creative_raw_name')."/playlist.m3u8";
					$headers=get_headers($toCheckExist);
					if(stripos($headers[0],"200 OK"))
					{
						$outgoing_filename_m3u8 = $this->config->item('creative_path').$this->post('tmp_video_rewarded_creative_raw_name')."/playlist.m3u8";
						$outType = "m3u8";
					}
					else
					{
						$outgoing_filename_m3u8	=	"nope";
						$outType = "nope";
					}					
					$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_rewarded_creative');
				}
			}
			
			//$video_name	=	"";
			$video_duration = $this->post("video_duration");
			$video_type = $this->post("video_type");
			
			//jayashree
			
			$companion_width 	= 	$this->post('inline_companion_width');
				$companion_height 	= 	$this->post('inline_companion_height');
				$companionclicktrackurl 	= 	$this->post('companionclicktrackurl');
				$expanded_width 	= 	$this->post('expanded_width');
				$expanded_height 	= 	$this->post('expanded_height');
				
			
			if($this->post('rewarded_companion_size')!='')
			{
				$size 				= 	explode("x",$this->post('rewarded_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				
			
				if($this->post('tmp_rewarded_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_rewarded_creative_name').' Companion';
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_rewarded_companion_creative_content_type')),
												"campaignid"		=>	clean_data($campaign_id),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_rewarded_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data($this->post('rewarded_url')),
												"dj_master_banner"	=>	clean_data($master_banner),
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_banner_type" 	=> 	($this->post('_type') == 'mobile') ? MOBILE_COMPANION_IMAGE_CREATIVE : WEB_CREATIVE_WEB,
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id" 	=> 	clean_data($dj_account_id)
											);
										
						$companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,$is_house_ad);
						//$this->response( $companion_id, 200);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_rewarded_companion_creative'));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				else
				{
					$companion_id	=	$this->post('vast_companion_id');
					if($companion_id !='')
					{
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					
					}else
					{$companion_id	=	$this->post('vast_companion_id');
						
					}
				}
			}
			else
			{
				$companion_id	=	0;
			}				
			//vpaid jayashree			
			$vpaid_enable=$this->post('vapid_enable');
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_outgoing_filename_m3u8' 	=>	$outgoing_filename_m3u8,
									'vast_video_outgoing_streaming_type' =>	$outType, 
									'vast_video_clickthrough_url' 	=> 	$this->post('rewarded_url'),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	'',
									'vast_video_skip_duration'					=>  $skip_offset,
									'vast_video_skip_progress_duration'				=>  $progress_offset,
									'vast_thirdparty_companion_clicktracking'=>	clean_data($companionclicktrackurl),
									'vast_thirdparty_companion_expandedwidth'		=>	clean_data($expanded_width),
									'vast_thirdparty_companion_expandedheight'		=>	clean_data($expanded_height),
									'is_vpaid'	=> clean_data($vpaid_enable),
									'vpaid_url'	=> clean_data($vpaid_api_url),
									'vpaid_type'	=> clean_data($vpaid_type),
									'vpaid_expanded'=> clean_data($vpaid_expand),
									'vpaid_width'	=> clean_data($vpaid_expand_width),
									'vpaid_height'	=> clean_data($vpaid_expand_height),
									'vpaid_icons'	=> clean_data($vpaid_icon_url),
									'vpaid_remainingTime'	=> clean_data($vpaid_remain_time),
									'vpaid_volume'	=> clean_data($vpaid_video_volume),
									
									'adbreak_tag1'	=> clean_data($adbreak1_tag),
									'adbreak_tag2'	=> clean_data($adbreak2_tag),
									'adbreak_tag3'	=> clean_data($adbreak3_tag),
									'vmap_midroll_skipoffset'	=> clean_data($vmap_midroll_skipoffset),
									'vast_wrapper_url'	=> clean_data($thirdparty_vast_tag)
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$contenttype = $this->post('tmp_video_inline_creative_content_type');
			
			$creative_data 	= array(		 										
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"contenttype"		=>	clean_data($video_type),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_rewarded_creative_name')),
									"filename"			=>	clean_data($video_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('rewarded_url')),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id)
								);
			//Call to add a creative
			$creative_id	=	$this->Do_video_creative->add_video($creative_data,$agency_id,$is_house_ad);
	//$this->response( $creative_id, 200);
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('rewarded_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_video_skip_duration"		=>  $skip_offset,
										"vast_video_skip_progress_duration"=>  $progress_offset,
										"vast_thirdparty_clicktracking"		=>	clean_data($clicktrackurl),
									    "vast_thirdparty_clickcustom"    =>	clean_data($clicktrackcustomurl),	
										"vast_thirdparty_companion_clicktracking"=>	clean_data($companionclicktrackurl),
										"vast_thirdparty_companion_expandedwidth"=>	clean_data($expanded_width),
										"vast_thirdparty_companion_expandedheight"=>	clean_data($expanded_height),
										"vast_wrapper_url"	=> clean_data($thirdparty_vast_tag),
										"is_vpaid"	=> clean_data($vpaid_enable),
										"vpaid_url"	=> clean_data($vpaid_api_url),
										"vpaid_type"	=> clean_data($vpaid_type),
										"vpaid_expanded"=> clean_data($vpaid_expand),
										"vpaid_width"	=> clean_data($vpaid_expand_width),
										"vpaid_height"	=> clean_data($vpaid_expand_height),
										"vpaid_icons"	=> clean_data($vpaid_icon_url),
										"vpaid_remainingTime"	=> clean_data($vpaid_remain_time),
										"vpaid_volume"	=> clean_data($vpaid_video_volume),
										"adbreak_tag1"	=> clean_data($adbreak1_tag),
										"adbreak_tag2"	=> clean_data($adbreak2_tag),
										"adbreak_tag3"	=> clean_data($adbreak3_tag),
										"vmap_midroll_skipoffset"	=> clean_data($vmap_midroll_skipoffset),
										"vast_version" => clean_data($vast_version)	
									);
									
				$vast_add	=	$this->Do_video_creative->add_video_vast($vast_data);
				
				if($vast_add)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);
					$this->response( $success, 200);
					
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}

	public function edit_video_rewarded_creative_post()
	{
		$creative_id	=	$this->post('creative_id');
		
		$delivery		=	$this->post('rewarded_delivery_method');
		$this->form_validation->set_rules('video_rewarded_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('rewarded_delivery_method', 'lang:delivery_type', 'required|trim');
		
		$vpaid_enable=$this->post('vapid_enable');
		if($vpaid_enable==1)
		{
			$vpaid_api_url=$this->post('vpaid_url');
			$vpaid_expand=$this->post('vapid_expand');
			$vpaid_type=$this->post('vapid_type');
			if($vpaid_expand==1)
			{
				$vpaid_expand_width=$this->post('resize_width');
				$vpaid_expand_height=$this->post('resize_height');
			}
			else if($vpaid_expand==0)
			{
				$vpaid_expand_width='';
				$vpaid_expand_height='';
			}
			$vpaid_remain_time=$this->post('vpaid_remain_time');
			$vpaid_icon_url=$this->post('vpaid_icon_url');
			$vpaid_video_volume=$this->post('vpaid_video_volume');
		}
		
		
		if($delivery == 'vmap' || $delivery == 'vast')
		{	
				
		$dest_url='';
		}
		else
		{
			$dest_url=$this->post('rewarded_url');
			$this->form_validation->set_rules('rewarded_url', 'lang:Destination_URL', 'required|trim|url');
		}	
		
		$skip_offset 		= $this->post('skip_offset');	
		$progress_offset 	= $this->post('progress_offset');	
		/*3rd Party ad tag 
		 * Name:Pradeep.M
		 * Date:23-05-2016*/
		 if($delivery=='vast')
		{
		$thirdparty_vast_tag	=	$this->post('thirdparty_vast_tag');
		$vast_version			=	$this->post('vast_version');
		}
		/*VMAP URL and Tag*/
		$adbreak1_tag 		= $this->post('adbreak1_tag');
		$adbreak2_tag 		= $this->post('adbreak2_tag');	
		$adbreak3_tag 		= $this->post('adbreak3_tag');
		$vmap_midroll_skipoffset = $this->post('vmap_skip_offset');		
		$campaign = $this->post('_vin_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_vin_campaign_id');
		}
		
		
		if($this->form_validation->run() === FALSE)
		{

			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'1';
			
			$video_data			=	$this->Do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->Do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}

			$clicktrackurl			=	$this->post('clicktrackurl');
			$clicktrackcustomurl	=	$this->post('clicktrackcustomurl');
			
			if($delivery=='progressive')
			{	
				if($this->post('tmp_video_rewarded_creative')!='')
				{	
					if($vast['vast_video_delivery']=='progressive')
					{	
						
						$shF = explode(".",$video['filename'])[0];
						if(file_exists("./ads/www/images/".$shF."/"))
						{
							system("rm -rf ".escapeshellarg("./ads/www/images/".$shF."/"));
						}
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);

					}
					
					$is_video_creative_moved_ffmpeg	=	$this->image_lib->move_creative_to_ffmpeg_location($this->post('tmp_video_rewarded_creative'));
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_rewarded_creative'));
                                        
                    if($this->commandExists("ffmpeg")>0) 
					{
					
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	$this->post('tmp_video_rewarded_creative');
						$output 			= 	$this->post('tmp_video_rewarded_creative_raw_name').'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	$this->post('tmp_video_rewarded_creative_raw_name');

						$ext				=	$this->post('tmp_video_rewarded_creative_file_ext');

						$input_with_path  	= 	$upload_path.$this->post('tmp_video_rewarded_creative');
						$output_with_path 	= 	$upload_path.$output;
						
				
						$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						//$this->response( $video_duration, 200);
						
						$video_duration		=	!empty($video_duration) ? $video_duration : 30;	
					}
					else 
					{
						$video_duration		=	'30';	
					} 

					
					$video_name			=	$this->post('tmp_video_rewarded_creative');
					if($this->post('tmp_video_rewarded_creative_content_type')=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	$this->post('tmp_video_rewarded_creative_content_type');
					}
					
								
					$hlsStreaming = $this->HlsStreaming($this->post());		
					
					$toCheckExist = $this->config->item('creative_path').$this->post('tmp_video_rewarded_creative_raw_name')."/playlist.m3u8";
					$headers=get_headers($toCheckExist);
					if(stripos($headers[0],"200 OK"))
					{
						$outgoing_filename_m3u8 = $this->config->item('creative_path').$this->post('tmp_video_rewarded_creative_raw_name')."/playlist.m3u8";
						$outType = "m3u8";
					}
					else
					{
						$outgoing_filename_m3u8	=	"nope";		
						$outType = "nope";
					}
					$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_rewarded_creative');		
				}
				else
				{
					$video_name			=	$video['filename'];
					$video_type			=	$vast['vast_video_type'];
					$video_duration		=	$vast['vast_video_duration'];	
					$outgoing_filename	=	$vast['vast_video_outgoing_filename'];	
				}
				
				
			}
			
			$video_duration = $this->post("video_duration");
			$video_type = $this->post("video_type");
			$outgoing_filename = $this->post("rewarded_video_url");
			
			$companion_width 	= 	$this->post('rewarded_companion_width');
			$companion_height 	= 	$this->post('rewarded_companion_height');
			$companionclicktrackurl 	= 	$this->post('companionclicktrackurl');
			$expanded_width 	= 	$this->post('expanded_width');
			$expanded_height 	= 	$this->post('expanded_height');

			if($this->post('rewarded_companion_size')!='')
			{

				$size 				= 	explode("x",$this->post('rewarded_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				if($this->post('tmp_rewarded_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_rewarded_creative_name').' Companion';
					
					if($this->user_authentication->account_type=='ADVERTISER')
					{
					  $dj_account_id=$this->user_authentication->account_id;
					}
					else
					{
					  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
					}
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_rewarded_companion_creative_content_type')),
												"campaignid"		=>	clean_data($this->post('campaign')),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_rewarded_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data($dest_url),
												"dj_master_banner"	=>	clean_data($master_banner),
												"dj_banner_type" 	=> 	WEB_CREATIVE_WEB,
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id"		=>  clean_data($dj_account_id)
											);
											
						$companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,FALSE,$is_house_ad);
					//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_rewarded_companion_creative'));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				else
				{
					$companion_id	=	$this->post('vast_companion_id');


				}
			}
			else
			{
				$companion_id	=	0;

			}
			
						
			$aVastVariables = array('banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_outgoing_filename_m3u8' =>	$outgoing_filename_m3u8,
									'vast_video_outgoing_streaming_type' =>	$outType, 
									'vast_video_clickthrough_url' 	=> 	$dest_url,
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	'',
									'vast_video_skip_duration'					=>  $skip_offset,
									'vast_video_skip_progress_duration'				=>  $progress_offset,
									'vast_thirdparty_companion_clicktracking'=>	clean_data($companionclicktrackurl),
									'vast_thirdparty_companion_expandedwidth'		=>	clean_data($expanded_width),
									'vast_thirdparty_companion_expandedheight'		=>	clean_data($expanded_height),
									'is_vpaid'	=> clean_data($vpaid_enable),
									'vpaid_url'	=> clean_data($vpaid_api_url),
									'vpaid_type'	=> clean_data($vpaid_type),
									'vpaid_expanded'=> clean_data($vpaid_expand),
									'vpaid_width'	=> clean_data($vpaid_expand_width),
									'vpaid_height'	=> clean_data($vpaid_expand_height),
									'vpaid_icons'	=> clean_data($vpaid_icon_url),
									'vpaid_remainingTime'	=> clean_data($vpaid_remain_time),
									'vpaid_volume'	=> clean_data($vpaid_video_volume),
									'adbreak_tag1'	=> clean_data($adbreak1_tag),
									'adbreak_tag2'	=> clean_data($adbreak2_tag),
									'adbreak_tag3'	=> clean_data($adbreak3_tag),
									'vmap_midroll_skipoffset'	=> clean_data($vmap_midroll_skipoffset),
									'vast_wrapper_url'	=> clean_data($thirdparty_vast_tag),
								);


			$parameters 	= serialize($aVastVariables);


			if($dj_admin_approve == -1)
			{
			
			$creative_data 	= array(
							         "contenttype"		=>	clean_data($video_type),
							         "campaignid" => clean_data($campaign_id),
									"description"		=>	clean_data($this->post('video_rewarded_creative_name')),
									"filename"			=>	clean_data($video_name),
									"url"				=>	clean_data($dest_url),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),	
									"dj_admin_approve"			=>	clean_data(0),	
								);
			} else
			{
			$creative_data 	= array(
							        "contenttype"		=>	clean_data($video_type),
							         "campaignid" => clean_data($campaign_id),
									"description"		=>	clean_data($this->post('video_rewarded_creative_name')),
									"filename"			=>	clean_data($video_name),
									"url"				=>	clean_data($dest_url),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),	
								);				
				
			}
			/* //end */
			//Get agencyid from library file
			$agency_id=$this->user_authentication->agency_id;

			
			//Call to update a creative
			$updated		=	$this->Do_video_creative->update_video($creative_data,$creative_id,$agency_id,$is_house_ad);
			
			// added for edited creative status update
			//29-06-2017
			//$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			//~ }						
				$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
			$link_type=$this->default_configurations->get('linking_type');
				
				if($link_type !='manual linking')
				{
					$this->Do_auto_link->link_adblocks($creative_id,$agency_id,$campaign_id);
				}
				//echo $is_house_ad;exit;
				if($is_house_ad == 1)
				{
					
					$this->Do_auto_link->link_adblocks($creative_id,$agency_id,$campaign_id);
				}
			
			if($updated)
			{					
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($dest_url),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_video_skip_duration"		=>  $skip_offset,
										"vast_video_skip_progress_duration"=>  $progress_offset,
										"vast_thirdparty_clicktracking"		=>	clean_data($clicktrackurl),
									    "vast_thirdparty_clickcustom"    =>	clean_data($clicktrackcustomurl),	
										"vast_thirdparty_companion_clicktracking"=>	clean_data($companionclicktrackurl),
										"vast_thirdparty_companion_expandedwidth"=>	clean_data($expanded_width),
										"vast_thirdparty_companion_expandedheight"=>	clean_data($expanded_height),
										"vast_wrapper_url"	=> clean_data($thirdparty_vast_tag),
										"is_vpaid"	=> clean_data($vpaid_enable),
										"vpaid_url"	=> clean_data($vpaid_api_url),
										"vpaid_type"	=> clean_data($vpaid_type),
										"vpaid_expanded"=> clean_data($vpaid_expand),
										"vpaid_width"	=> clean_data($vpaid_expand_width),
										"vpaid_height"	=> clean_data($vpaid_expand_height),
										"vpaid_icons"	=> clean_data($vpaid_icon_url),
										"vpaid_remainingTime"	=> clean_data($vpaid_remain_time),
										"vpaid_volume"	=> clean_data($vpaid_video_volume),
										"adbreak_tag1"	=> clean_data($adbreak1_tag),
										"adbreak_tag2"	=> clean_data($adbreak2_tag),
										"adbreak_tag3"	=> clean_data($adbreak3_tag),
										"vmap_midroll_skipoffset"	=> clean_data($vmap_midroll_skipoffset),
										"vast_version" => clean_data($vast_version)		
									);
									
				$vast_update	=	$this->Do_video_creative->update_video_vast($vast_data,$creative_id);
				
			// added for edited creative status update
			//29-06-2017
			//$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			//~ }						
					$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
				if($vast_update)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('creative_successfully_updated'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
					$this->response( $success, 200);
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}
	/*
	 * 
	 * name: HlsStreaming
	 * @param
	 * @return:response array
	 *  
	 */
	
	public function HlsStreaming($input)
	{
		$dest = ".._".$this->config->item('base_package_name')."_ads_www_images_";
		$gt = $this->config->item('delivery_domain_base')."ffmpeg/ffmpeg.php?creative=".$input['tmp_video_inline_creative']."&file=".$input['tmp_video_inline_creative_raw_name']."&path=".$dest;
		$file = file_get_contents($gt);
		return true;
	}
	/*
	 * 
	 * name: add_video_overlay_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all OVERLAY VIDEO CREATIVE add process	 
	 */
	public function add_video_overlay_creative_post()
	{
		
		$ovl_type		=	$this->post('overlay_type');
		$ovl_action		=	$this->post('click_action');
		$ovl_delivery	=	$this->post('overlay_delivery_method');
		
		/* Jayashrree */
		
		
		
		/* Overlay Advanced setting values */
		$expanded_width			=	$this->post('expanded_width');
		$expanded_height		=	$this->post('expanded_height');
		$min_suggested_duration	=	$this->post('min_suggested_duration');
		/* Overlay Advanced setting values */
		$clicktrackurl			=	$this->post('clicktrackurl');
		$clicktrackcustomurl	=	$this->post('clicktrackcustomurl');
		/*3rd Party ad tag 
		 * Name:Pradeep.M
		 * Date:23-05-2016*/
		$thirdparty_vast_tag	=	$this->post('thirdparty_vast_tag');
		$vast_overlay_version	=	$this->post('vast_overlay_version');
		
		/* VMAP Overlay*/
		
		if($ovl_type=='vmap')
		{
			$overlay_vmap_count	=	$this->post('overlay_vmap_count');
			if($overlay_vmap_count==2)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				
			}
			else if($overlay_vmap_count==3)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	$this->post('adbreak3_tag');
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	$this->post('vmap_adbreak3_offset');
			}
			else if($overlay_vmap_count==4)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	$this->post('adbreak3_tag');
				$adbreak4_tag	=	$this->post('adbreak4_tag');
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	$this->post('vmap_adbreak3_offset');
				$vmap_adbreak4_offset=	$this->post('vmap_adbreak4_offset');
			}
			else if($overlay_vmap_count==5)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	$this->post('adbreak3_tag');
				$adbreak4_tag	=	$this->post('adbreak4_tag');
				$adbreak5_tag	=	$this->post('adbreak5_tag');
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	$this->post('vmap_adbreak3_offset');
				$vmap_adbreak4_offset=	$this->post('vmap_adbreak4_offset');
				$vmap_adbreak5_offset=	$this->post('vmap_adbreak5_offset');
			}
			
		}
		//vpaid jayashree
		$vpaid_enable=$this->post('vapid_enable');
		if($vpaid_enable==1)
		{
			$vpaid_api_url=$this->post('vpaid_url');
			$vpaid_expand=$this->post('vapid_expand');
			$vpaid_type=$this->post('vpaid_type');
			if($vpaid_expand==1)
			{
				$vpaid_expand_width=$this->post('resize_width');
				$vpaid_expand_height=$this->post('resize_height');
			}
			else if($vpaid_expand==0)
			{
				$vpaid_expand_width='';
				$vpaid_expand_height='';
			}
		}
		
		
		
		
		/* jayashree End */
		
		$this->form_validation->set_rules('video_overlay_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('overlay_type', 'lang:overlay_type', 'required|trim');		
		$this->form_validation->set_rules('click_action', 'lang:overlay_type', 'required|trim');		
		$this->form_validation->set_rules('overlay_delivery_method', 'lang:delivery_type', 'required|trim');
		
		$campaign = $this->post('_vol_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('overlay_campaign','lang:campaign', 'required|trim');
			$campaign_id	= $this->post('overlay_campaign');
		}
		else
		{
			$campaign_id= $this->post('_vol_campaign_id');
		}
			
		if($ovl_type=='text_overlay')
		{
			$this->form_validation->set_rules('txt_title', 'lang:text_overlay_title', 'required|trim');		
			$this->form_validation->set_rules('txt_action', 'lang:text_overlay_action', 'trim|url');		
		}
		
		if($ovl_action=='click_to_video')
		{	
			$this->form_validation->set_rules('overlay_click_url', 'lang:overlay_clk_url', 'required|trim|url');
		}
		else if($this->post('overlay_url')!='')
		{
			$this->form_validation->set_rules('overlay_url', 'lang:Destination_URL', 'required|trim|url');
		}
		
		if($ovl_delivery=='streaming')
		{
			$this->form_validation->set_rules('overlay_rtmpurl', 'lang:rtmp_url', 'required|trim');
			$this->form_validation->set_rules('overlay_rtmp_filename', 'lang:rtmp_file_name', 'required|trim');
			$this->form_validation->set_rules('overlay_rtmp_duration', 'lang:rtmp_video_duration', 'required|trim');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			/* Static values */
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'1';
			$bannertype		=	($this->post('_type') == 'mobile') ? MOBILE_VIDEO_CREATIVE_OVERLAY : VIDEO_CREATIVE_OVERLAY;		
			$storagetype	=	'html';
			$width			=	'-2';
			$height			=	'-2';
			$ext_bannertype = 	"bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml";
			
			//Get account/clientid from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			
			$agency_id=$this->user_authentication->agency_id;
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
					
			/* Overlay Type - Image Overlay */
			if($ovl_type=='image_overlay')
			{
				if($this->post('tmp_overlay_image_creative')!='')
				{
					$file_name			=	$this->post('tmp_overlay_image_creative');
					$creative_type		=	$this->post('tmp_overlay_image_creative_content_type');
					$ovl_width			=	'300';
					$ovl_height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_overlay_image_creative'));
				}
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			/* Overlay Type - SWF Overlay */
			elseif($ovl_type=='swf_overlay')
			{
				if($this->post('tmp_overlay_swf_creative')!='')
				{
					$file_name			=	$this->post('tmp_overlay_swf_creative');
					$creative_type		=	'swf';
					$ovl_width			=	'300';
					$ovl_height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_overlay_swf_creative'));
				}
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			/* Overlay Type - Text Overlay */
			elseif($ovl_type=='text_overlay')
			{
				$file_name			=	'';
				$creative_type		=	NULL;
				$ovl_width			=	NULL;
				$ovl_height			=	NULL;
				$txt_title			=	$this->post('txt_title');
				$txt_description	=	$this->post('txt_description');
				$txt_action			=	$this->post('txt_action');
			}
			
			/* Overlay Action - Click to Page */
			if($ovl_action=='click_to_page')
			{
				if($this->post('overlay_url'))
				{
					$destination_url	=	$this->post('overlay_url');
				}
				else
				{
					$destination_url='';
				}
				$htmlcache			=	'<a href="{clickurl}" target="{target}"></a>';
				$ovl_delivery		=	NULL;
				$click_url			=	NULL;
				$video_type			=	NULL;
				$video_duration		=	NULL;
				$outgoing_filename	=	NULL;
			}
			/* Overlay Action - Click to Video */
			elseif($ovl_action=='click_to_video')
			{	
				/* Overlay Delivery type - Progressive */			
				if($ovl_delivery=='progressive')
				{	
					if($this->post('tmp_video_overlay_creative')!='')
					{
						if($this->commandExists("ffmpeg")>0) 
						{
							##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
							$input  			= 	$this->post('tmp_video_overlay_creative');
							$output 			= 	$this->post('tmp_video_overlay_creative_raw_name').'.flv';
							
							$upload_path		=	$this->config->item('creative_path');
							$raw_name			=	$this->post('tmp_video_overlay_creative_raw_name');

							$ext				=	$this->post('tmp_video_overlay_creative_file_ext');

							$input_with_path  	= 	$upload_path.$this->post('tmp_video_overlay_creative');
							$output_with_path 	= 	$upload_path.$output;
							
							#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
							$video_duration		=	'30';	
						}
						else 
						{
							$video_duration		=	'30';	
						}
						
						$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_overlay_creative'));
						
						if($this->post('tmp_video_overlay_creative_content_type')=='video/mp4')
						{
							$video_type		=	'video/x-mp4';
						}
						else
						{
							$video_type		=	$this->post('tmp_video_overlay_creative_content_type');
						}
						$video_duration		=	'30';	
						$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_overlay_creative');					
						
					}
				}
				/* Overlay Delivery type - Streaming */			
				elseif($ovl_delivery=='streaming')
				{	
					$video_duration		=	$this->post('overlay_rtmp_duration');
					$rtmp_url			=	$this->post('overlay_rtmpurl');
					$rtmp_filename		=	$this->post('overlay_rtmp_filename');
					if(strpos($rtmp_filename, '.') != false)
					{
						$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
					}
					else
					{
						$type			=	'flv';
					}
					$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
					$video_type			=	'video/x-'.$type;
				}
				$destination_url	=	'';
				$htmlcache			=	'';
				$click_url			=	$this->post('overlay_click_url');
			}
			//jayashree
				$companion_width 	= 	$this->post('overlay_companion_width');
				$companion_height 	= 	$this->post('overlay_companion_height');
				$companionclicktrackurl = 	$this->post('companionclicktrackurl');
				$com_expanded_width 	= 	$this->post('comp_expanded_width');
				$com_expanded_height 	= 	$this->post('comp_expanded_height');
			
			/* Overlay Companion */			
			if($this->post('overlay_companion_size')!='')
			{
				$size 				= 	explode("x",$this->post('overlay_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				/* Overlay Companion - Upload */			
				if($this->post('tmp_overlay_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_overlay_creative_name').' Companion';
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_overlay_companion_creative_content_type')),
												"campaignid"		=>	clean_data($campaign_id),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_overlay_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data(($destination_url!='')?$destination_url:$click_url),
												"dj_master_banner"	=>	clean_data($master_banner),
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_banner_type" 	=> 	($this->post('_type') == 'mobile') ? MOBILE_COMPANION_IMAGE_CREATIVE : WEB_CREATIVE_WEB,
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id" 	=> 	clean_data($dj_account_id)
											);
											
						$companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,$is_house_ad);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_overlay_companion_creative'));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				/* Overlay Companion - Selection */			
				else
				{
					$companion_id	=	$this->post('vast_companion_id');
				}
			}
			else
			{
				$companion_id	=	0;
			}				
			
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$ovl_delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	$click_url,
									'vast_overlay_height' 			=> 	$ovl_height,
									'vast_overlay_width' 			=> 	$ovl_width,
									'vast_overlay_text_title' 		=> 	$txt_title,
									'vast_overlay_text_description' => 	$txt_description,
									'vast_overlay_text_call' 		=> 	$txt_action,
									'vast_overlay_format' 			=>	$ovl_type,
									'vast_overlay_action' 			=> 	$ovl_action,
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	$creative_type,
									'vast_thirdparty_impression' 	=> 	'',
									'vast_overlay_expanded_width'			=>	$expanded_width,
									'vast_overlay_expanded_height'			=>	$expanded_height,
									'vast_overlay_expandedminduration'		=>	$min_suggested_duration,
									'vast_thirdparty_companion_clicktracking'=>	clean_data($companionclicktrackurl),
									'vast_thirdparty_companion_expandedwidth'		=>	clean_data($com_expanded_width),
									'vast_thirdparty_companion_expandedheight'		=>	clean_data($com_expanded_height),
									'vast_overlay_version' => clean_data($vast_overlay_version),
									//vpaid jayshree
									'is_vpaid'	=> clean_data($vpaid_enable),
									'vpaid_url'	=> clean_data($vpaid_api_url),
									'vpaid_type'	=> clean_data($vpaid_type),
									'vpaid_expanded'=> clean_data($vpaid_expand),
									'vpaid_width'	=> clean_data($vpaid_expand_width),
									'vpaid_height'	=> clean_data($vpaid_expand_height),
									'adbreak_tag1'	=> clean_data($adbreak1_tag),
									'adbreak_tag2'	=> clean_data($adbreak2_tag),
									'adbreak_tag3'	=> clean_data($adbreak3_tag),
									'adbreak_tag4'	=> clean_data($adbreak4_tag),
									'adbreak_tag5'	=> clean_data($adbreak5_tag),
									'vmap_overlay_count'	=> clean_data($overlay_vmap_count),
									'vmap_offset_adbreak1'	=> clean_data($vmap_adbreak1_offset),
									'vmap_offset_adbreak2'	=> clean_data($vmap_adbreak2_offset),
									'vmap_offset_adbreak3'	=> clean_data($vmap_adbreak3_offset),
									'vmap_offset_adbreak4'	=> clean_data($vmap_adbreak4_offset),
									'vmap_offset_adbreak5'	=> clean_data($vmap_adbreak5_offset),
									'vast_overlay_wrapper' => clean_data($thirdparty_vast_tag)
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$creative_data 	= array(		
									"contenttype"		=>	clean_data($this->post('tmp_overlay_image_creative_content_type')),							
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_overlay_creative_name')),
									"filename"			=>	clean_data($file_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"url"				=>	clean_data($destination_url),
									"htmlcache"			=>	$htmlcache,
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id)
								);
			
			 //Call to add a creative
			  $creative_id	=	$this->Do_video_creative->add_video($creative_data,$agency_id,$is_house_ad);			
				
			if($creative_id)
			{				
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$ovl_delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	$ovl_height,
										"vast_overlay_width"			=>	$ovl_width,
										"vast_video_clickthrough_url"	=>	$click_url,
										"vast_overlay_action"			=>	$ovl_action,
										"vast_overlay_format"			=>	$ovl_type,
										"vast_overlay_text_title"		=>	$txt_title,
										"vast_overlay_text_description"	=>	$txt_description,
										"vast_overlay_text_call"		=>	$txt_action,
										"vast_creative_type"			=>	$creative_type,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_overlay_expanded_width"			=>	$expanded_width,
										"vast_overlay_expanded_height"			=>	$expanded_height,
										"vast_overlay_expandedminduration"		=>	$min_suggested_duration,
										"vast_thirdparty_companion_clicktracking"=>	clean_data($companionclicktrackurl),
										"vast_thirdparty_companion_expandedwidth"		=>	clean_data($com_expanded_width),
										"vast_thirdparty_companion_expandedheight"		=>	clean_data($com_expanded_height),
										"vast_thirdparty_clicktracking"		=>	clean_data($clicktrackurl),
										"vast_thirdparty_clickcustom"=>	clean_data($clicktrackcustomurl),
										"vast_overlay_version" => clean_data($vast_overlay_version),
										//vpaid jayshree
										"is_vpaid"	=> clean_data($vpaid_enable),
										"vpaid_url"	=> clean_data($vpaid_api_url),
										"vpaid_type"	=> clean_data($vpaid_type),
										"vpaid_expanded"=> clean_data($vpaid_expand),
										"vpaid_width"	=> clean_data($vpaid_expand_width),
										"vpaid_height"	=> clean_data($vpaid_expand_height),
										"adbreak_tag1"	=> clean_data($adbreak1_tag),
										"adbreak_tag2"	=> clean_data($adbreak2_tag),
										"adbreak_tag3"	=> clean_data($adbreak3_tag),
										"adbreak_tag4"	=> clean_data($adbreak4_tag),
										"adbreak_tag5"	=> clean_data($adbreak5_tag),
										"vmap_overlay_count"	=> clean_data($overlay_vmap_count),
										"vmap_offset_adbreak1"	=> clean_data($vmap_adbreak1_offset),
										"vmap_offset_adbreak2"	=> clean_data($vmap_adbreak2_offset),
										"vmap_offset_adbreak3"	=> clean_data($vmap_adbreak3_offset),
										"vmap_offset_adbreak4"	=> clean_data($vmap_adbreak4_offset),
										"vmap_offset_adbreak5"	=> clean_data($vmap_adbreak5_offset),
									    "vast_overlay_wrapper" => clean_data($thirdparty_vast_tag)	
									);
									
				$vast_add	=	$this->Do_video_creative->add_video_vast($vast_data);
				
				if($vast_add)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);
					$this->response( $success, 200);
					
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}

	public function add_pause_video_creative_post()
	{
		
		$ovl_type		=	$this->post('overlay_type');
		$ovl_action		=	$this->post('click_action');
		$ovl_delivery	=	$this->post('overlay_delivery_method');
		
		/* Jayashrree */
		
		
		
		/* Overlay Advanced setting values */
		$expanded_width			=	$this->post('expanded_width');
		$expanded_height		=	$this->post('expanded_height');
		$min_suggested_duration	=	$this->post('min_suggested_duration');
		/* Overlay Advanced setting values */
		$clicktrackurl			=	$this->post('clicktrackurl');
		$clicktrackcustomurl	=	$this->post('clicktrackcustomurl');
		/*3rd Party ad tag 
		 * Name:Pradeep.M
		 * Date:23-05-2016*/
		$thirdparty_vast_tag	=	$this->post('thirdparty_vast_tag');
		$vast_overlay_version	=	$this->post('vast_overlay_version');
		
		/* VMAP Overlay*/
		
		if($ovl_type=='vmap')
		{
			$overlay_vmap_count	=	$this->post('overlay_vmap_count');
			if($overlay_vmap_count==2)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				
			}
			else if($overlay_vmap_count==3)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	$this->post('adbreak3_tag');
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	$this->post('vmap_adbreak3_offset');
			}
			else if($overlay_vmap_count==4)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	$this->post('adbreak3_tag');
				$adbreak4_tag	=	$this->post('adbreak4_tag');
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	$this->post('vmap_adbreak3_offset');
				$vmap_adbreak4_offset=	$this->post('vmap_adbreak4_offset');
			}
			else if($overlay_vmap_count==5)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	$this->post('adbreak3_tag');
				$adbreak4_tag	=	$this->post('adbreak4_tag');
				$adbreak5_tag	=	$this->post('adbreak5_tag');
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	$this->post('vmap_adbreak3_offset');
				$vmap_adbreak4_offset=	$this->post('vmap_adbreak4_offset');
				$vmap_adbreak5_offset=	$this->post('vmap_adbreak5_offset');
			}
			
		}
		//vpaid jayashree
		$vpaid_enable=$this->post('vapid_enable');
		if($vpaid_enable==1)
		{
			$vpaid_api_url=$this->post('vpaid_url');
			$vpaid_expand=$this->post('vapid_expand');
			$vpaid_type=$this->post('vpaid_type');
			if($vpaid_expand==1)
			{
				$vpaid_expand_width=$this->post('resize_width');
				$vpaid_expand_height=$this->post('resize_height');
			}
			else if($vpaid_expand==0)
			{
				$vpaid_expand_width='';
				$vpaid_expand_height='';
			}
		}
		
		
		
		
		/* jayashree End */
		
		$this->form_validation->set_rules('video_overlay_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('overlay_type', 'lang:overlay_type', 'required|trim');		
		$this->form_validation->set_rules('click_action', 'lang:overlay_type', 'required|trim');		
		$this->form_validation->set_rules('overlay_delivery_method', 'lang:delivery_type', 'required|trim');
		
		$campaign = $this->post('_vol_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('overlay_campaign','lang:campaign', 'required|trim');
			$campaign_id	= $this->post('overlay_campaign');
		}
		else
		{
			$campaign_id= $this->post('_vol_campaign_id');
		}
			
		if($ovl_type=='text_overlay')
		{
			$this->form_validation->set_rules('txt_title', 'lang:text_overlay_title', 'required|trim');		
			$this->form_validation->set_rules('txt_action', 'lang:text_overlay_action', 'trim|url');		
		}
		
		if($ovl_action=='click_to_video')
		{	
			$this->form_validation->set_rules('overlay_click_url', 'lang:overlay_clk_url', 'required|trim|url');
		}
		else if($this->post('overlay_url')!='')
		{
			$this->form_validation->set_rules('overlay_url', 'lang:Destination_URL', 'required|trim|url');
		}
		
		if($ovl_delivery=='streaming')
		{
			$this->form_validation->set_rules('overlay_rtmpurl', 'lang:rtmp_url', 'required|trim');
			$this->form_validation->set_rules('overlay_rtmp_filename', 'lang:rtmp_file_name', 'required|trim');
			$this->form_validation->set_rules('overlay_rtmp_duration', 'lang:rtmp_video_duration', 'required|trim');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			//MP_VC - Mobile pause video creative
			/* Static values */
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'1';
			$bannertype		=	($this->post('_type') == 'mobile') ? 'MV_CP' : '';		
			$storagetype	=	'html';
			$width			=	'-2';
			$height			=	'-2';
			$ext_bannertype = 	"bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml";
			
			//Get account/clientid from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			
			$agency_id=$this->user_authentication->agency_id;
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
					
			/* Overlay Type - Image Overlay */
			if($ovl_type=='image_overlay')
			{
				if($this->post('tmp_overlay_image_creative')!='')
				{
					$file_name			=	$this->post('tmp_overlay_image_creative');
					$creative_type		=	$this->post('tmp_overlay_image_creative_content_type');
					$ovl_width			=	'300';
					$ovl_height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_overlay_image_creative'));
				}
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			/* Overlay Type - SWF Overlay */
			elseif($ovl_type=='swf_overlay')
			{
				if($this->post('tmp_overlay_swf_creative')!='')
				{
					$file_name			=	$this->post('tmp_overlay_swf_creative');
					$creative_type		=	'swf';
					$ovl_width			=	'300';
					$ovl_height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_overlay_swf_creative'));
				}
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			/* Overlay Type - Text Overlay */
			elseif($ovl_type=='text_overlay')
			{
				$file_name			=	'';
				$creative_type		=	NULL;
				$ovl_width			=	NULL;
				$ovl_height			=	NULL;
				$txt_title			=	$this->post('txt_title');
				$txt_description	=	$this->post('txt_description');
				$txt_action			=	$this->post('txt_action');
			}
			
			/* Overlay Action - Click to Page */
			if($ovl_action=='click_to_page')
			{
				if($this->post('overlay_url'))
				{
					$destination_url	=	$this->post('overlay_url');
				}
				else
				{
					$destination_url='';
				}
				$htmlcache			=	'<a href="{clickurl}" target="{target}"></a>';
				$ovl_delivery		=	NULL;
				$click_url			=	NULL;
				$video_type			=	NULL;
				$video_duration		=	NULL;
				$outgoing_filename	=	NULL;
			}
			/* Overlay Action - Click to Video */
			elseif($ovl_action=='click_to_video')
			{	
				/* Overlay Delivery type - Progressive */			
				if($ovl_delivery=='progressive')
				{	
					if($this->post('tmp_video_overlay_creative')!='')
					{
						if($this->commandExists("ffmpeg")>0) 
						{
							##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
							$input  			= 	$this->post('tmp_video_overlay_creative');
							$output 			= 	$this->post('tmp_video_overlay_creative_raw_name').'.flv';
							
							$upload_path		=	$this->config->item('creative_path');
							$raw_name			=	$this->post('tmp_video_overlay_creative_raw_name');

							$ext				=	$this->post('tmp_video_overlay_creative_file_ext');

							$input_with_path  	= 	$upload_path.$this->post('tmp_video_overlay_creative');
							$output_with_path 	= 	$upload_path.$output;
							
							#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
							$video_duration		=	'30';	
						}
						else 
						{
							$video_duration		=	'30';	
						}
						
						$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_overlay_creative'));
						
						if($this->post('tmp_video_overlay_creative_content_type')=='video/mp4')
						{
							$video_type		=	'video/x-mp4';
						}
						else
						{
							$video_type		=	$this->post('tmp_video_overlay_creative_content_type');
						}
						$video_duration		=	'30';	
						$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_overlay_creative');					
						
					}
				}
				/* Overlay Delivery type - Streaming */			
				elseif($ovl_delivery=='streaming')
				{	
					$video_duration		=	$this->post('overlay_rtmp_duration');
					$rtmp_url			=	$this->post('overlay_rtmpurl');
					$rtmp_filename		=	$this->post('overlay_rtmp_filename');
					if(strpos($rtmp_filename, '.') != false)
					{
						$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
					}
					else
					{
						$type			=	'flv';
					}
					$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
					$video_type			=	'video/x-'.$type;
				}
				$destination_url	=	'';
				$htmlcache			=	'';
				$click_url			=	$this->post('overlay_click_url');
			}
			//jayashree
				$companion_width 	= 	$this->post('overlay_companion_width');
				$companion_height 	= 	$this->post('overlay_companion_height');
				$companionclicktrackurl = 	$this->post('companionclicktrackurl');
				$com_expanded_width 	= 	$this->post('comp_expanded_width');
				$com_expanded_height 	= 	$this->post('comp_expanded_height');
			
			/* Overlay Companion */			
			if($this->post('overlay_companion_size')!='')
			{
				$size 				= 	explode("x",$this->post('overlay_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				/* Overlay Companion - Upload */			
				if($this->post('tmp_overlay_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_overlay_creative_name').' Companion';
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_overlay_companion_creative_content_type')),
												"campaignid"		=>	clean_data($campaign_id),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_overlay_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data(($destination_url!='')?$destination_url:$click_url),
												"dj_master_banner"	=>	clean_data($master_banner),
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_banner_type" 	=> 	($this->post('_type') == 'mobile') ? MOBILE_COMPANION_IMAGE_CREATIVE : WEB_CREATIVE_WEB,
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id" 	=> 	clean_data($dj_account_id)
											);
											
						$companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,$is_house_ad);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_overlay_companion_creative'));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				/* Overlay Companion - Selection */			
				else
				{
					$companion_id	=	$this->post('vast_companion_id');
				}
			}
			else
			{
				$companion_id	=	0;
			}				
			
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$ovl_delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	$click_url,
									'vast_overlay_height' 			=> 	$ovl_height,
									'vast_overlay_width' 			=> 	$ovl_width,
									'vast_overlay_text_title' 		=> 	$txt_title,
									'vast_overlay_text_description' => 	$txt_description,
									'vast_overlay_text_call' 		=> 	$txt_action,
									'vast_overlay_format' 			=>	$ovl_type,
									'vast_overlay_action' 			=> 	$ovl_action,
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	$creative_type,
									'vast_thirdparty_impression' 	=> 	'',
									'vast_overlay_expanded_width'			=>	$expanded_width,
									'vast_overlay_expanded_height'			=>	$expanded_height,
									'vast_overlay_expandedminduration'		=>	$min_suggested_duration,
									'vast_thirdparty_companion_clicktracking'=>	clean_data($companionclicktrackurl),
									'vast_thirdparty_companion_expandedwidth'		=>	clean_data($com_expanded_width),
									'vast_thirdparty_companion_expandedheight'		=>	clean_data($com_expanded_height),
									'vast_overlay_version' => clean_data($vast_overlay_version),
									//vpaid jayshree
									'is_vpaid'	=> clean_data($vpaid_enable),
									'vpaid_url'	=> clean_data($vpaid_api_url),
									'vpaid_type'	=> clean_data($vpaid_type),
									'vpaid_expanded'=> clean_data($vpaid_expand),
									'vpaid_width'	=> clean_data($vpaid_expand_width),
									'vpaid_height'	=> clean_data($vpaid_expand_height),
									'adbreak_tag1'	=> clean_data($adbreak1_tag),
									'adbreak_tag2'	=> clean_data($adbreak2_tag),
									'adbreak_tag3'	=> clean_data($adbreak3_tag),
									'adbreak_tag4'	=> clean_data($adbreak4_tag),
									'adbreak_tag5'	=> clean_data($adbreak5_tag),
									'vmap_overlay_count'	=> clean_data($overlay_vmap_count),
									'vmap_offset_adbreak1'	=> clean_data($vmap_adbreak1_offset),
									'vmap_offset_adbreak2'	=> clean_data($vmap_adbreak2_offset),
									'vmap_offset_adbreak3'	=> clean_data($vmap_adbreak3_offset),
									'vmap_offset_adbreak4'	=> clean_data($vmap_adbreak4_offset),
									'vmap_offset_adbreak5'	=> clean_data($vmap_adbreak5_offset),
									'vast_overlay_wrapper' => clean_data($thirdparty_vast_tag)
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$creative_data 	= array(		
									"contenttype"		=>	clean_data($this->post('tmp_overlay_image_creative_content_type')),							
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_overlay_creative_name')),
									"filename"			=>	clean_data($file_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"url"				=>	clean_data($destination_url),
									"htmlcache"			=>	$htmlcache,
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id)
								);
			
			 //Call to add a creative
			  $creative_id	=	$this->Do_video_creative->add_video($creative_data,$agency_id,$is_house_ad);			
				
			if($creative_id)
			{				
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$ovl_delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	$ovl_height,
										"vast_overlay_width"			=>	$ovl_width,
										"vast_video_clickthrough_url"	=>	$click_url,
										"vast_overlay_action"			=>	$ovl_action,
										"vast_overlay_format"			=>	$ovl_type,
										"vast_overlay_text_title"		=>	$txt_title,
										"vast_overlay_text_description"	=>	$txt_description,
										"vast_overlay_text_call"		=>	$txt_action,
										"vast_creative_type"			=>	$creative_type,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_overlay_expanded_width"			=>	$expanded_width,
										"vast_overlay_expanded_height"			=>	$expanded_height,
										"vast_overlay_expandedminduration"		=>	$min_suggested_duration,
										"vast_thirdparty_companion_clicktracking"=>	clean_data($companionclicktrackurl),
										"vast_thirdparty_companion_expandedwidth"		=>	clean_data($com_expanded_width),
										"vast_thirdparty_companion_expandedheight"		=>	clean_data($com_expanded_height),
										"vast_thirdparty_clicktracking"		=>	clean_data($clicktrackurl),
										"vast_thirdparty_clickcustom"=>	clean_data($clicktrackcustomurl),
										"vast_overlay_version" => clean_data($vast_overlay_version),
										//vpaid jayshree
										"is_vpaid"	=> clean_data($vpaid_enable),
										"vpaid_url"	=> clean_data($vpaid_api_url),
										"vpaid_type"	=> clean_data($vpaid_type),
										"vpaid_expanded"=> clean_data($vpaid_expand),
										"vpaid_width"	=> clean_data($vpaid_expand_width),
										"vpaid_height"	=> clean_data($vpaid_expand_height),
										"adbreak_tag1"	=> clean_data($adbreak1_tag),
										"adbreak_tag2"	=> clean_data($adbreak2_tag),
										"adbreak_tag3"	=> clean_data($adbreak3_tag),
										"adbreak_tag4"	=> clean_data($adbreak4_tag),
										"adbreak_tag5"	=> clean_data($adbreak5_tag),
										"vmap_overlay_count"	=> clean_data($overlay_vmap_count),
										"vmap_offset_adbreak1"	=> clean_data($vmap_adbreak1_offset),
										"vmap_offset_adbreak2"	=> clean_data($vmap_adbreak2_offset),
										"vmap_offset_adbreak3"	=> clean_data($vmap_adbreak3_offset),
										"vmap_offset_adbreak4"	=> clean_data($vmap_adbreak4_offset),
										"vmap_offset_adbreak5"	=> clean_data($vmap_adbreak5_offset),
									    "vast_overlay_wrapper" => clean_data($thirdparty_vast_tag)	
									);
									
				$vast_add	=	$this->Do_video_creative->add_video_vast($vast_data);
				
				if($vast_add)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);
					$this->response( $success, 200);
					
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}
	
	
	/*
	 * 
	 * name: fetch_video
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage all VIDEO CREATIVE
	 */
	
	public function fetch_video_get()
	{	
		$creative_id	=	$this->get('creative_id');
		
		if($creative_id)
		{
			$video			=	$this->Do_video_creative->fetch_video($creative_id);	
			
			if($video)
			{	
				$this->response( $video, 200);
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('crtv_not_exist')
								);
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: fetch_video_vast
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage all VIDEO CREATIVE
	 */
	public function fetch_video_vast_get()
	{	
		$creative_id	=	$this->get('creative_id');
		
		if($creative_id)
		{
			$vast			=	$this->Do_video_creative->fetch_video_vast($creative_id);	
			
			if($vast)
			{	
				$this->response( $vast, 200);
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('crtv_not_exist')
								);
				$this->response( $error, 200);
			}
		}
	}

	 /*
	 * 
	 * name: edit_video_inline_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all INLINE VIDEO CREATIVE add process	 
	 */
	
	public function edit_video_inline_creative_post()
	{
		$creative_id	=	$this->post('creative_id');
		
		$delivery		=	$this->post('inline_delivery_method');
		$this->form_validation->set_rules('video_inline_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('inline_delivery_method', 'lang:delivery_type', 'required|trim');
		
		$vpaid_enable=$this->post('vapid_enable');
		if($vpaid_enable==1)
		{
			$vpaid_api_url=$this->post('vpaid_url');
			$vpaid_expand=$this->post('vapid_expand');
			$vpaid_type=$this->post('vapid_type');
			if($vpaid_expand==1)
			{
				$vpaid_expand_width=$this->post('resize_width');
				$vpaid_expand_height=$this->post('resize_height');
			}
			else if($vpaid_expand==0)
			{
				$vpaid_expand_width='';
				$vpaid_expand_height='';
			}
			$vpaid_remain_time=$this->post('vpaid_remain_time');
			$vpaid_icon_url=$this->post('vpaid_icon_url');
			$vpaid_video_volume=$this->post('vpaid_video_volume');
		}
		
		
if($delivery == 'vmap' || $delivery == 'vast')
		{	
				
		$dest_url='';
		}
		else
		{
			$dest_url=$this->post('inline_url');
			$this->form_validation->set_rules('inline_url', 'lang:Destination_URL', 'required|trim|url');
		}	
		
		$skip_offset 		= $this->post('skip_offset');	
		$progress_offset 	= $this->post('progress_offset');	
		/*3rd Party ad tag 
		 * Name:Pradeep.M
		 * Date:23-05-2016*/
		 if($delivery=='vast')
		{
		$thirdparty_vast_tag	=	$this->post('thirdparty_vast_tag');
		$vast_version			=	$this->post('vast_version');
		}
		/*VMAP URL and Tag*/
		$adbreak1_tag 		= $this->post('adbreak1_tag');
		$adbreak2_tag 		= $this->post('adbreak2_tag');	
		$adbreak3_tag 		= $this->post('adbreak3_tag');
		$vmap_midroll_skipoffset = $this->post('vmap_skip_offset');		
		$campaign = $this->post('_vin_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_vin_campaign_id');
		}
		
		if($delivery=='streaming')
		{
			$this->form_validation->set_rules('inline_rtmpurl', 'lang:rtmp_url', 'required|trim');
			$this->form_validation->set_rules('inline_rtmp_filename', 'lang:rtmp_file_name', 'required|trim');
			$this->form_validation->set_rules('inline_rtmp_duration', 'lang:rtmp_video_duration', 'required|trim');
		}
		else if($delivery=='progressive')
		{

			if($this->post('tmp_video_inline')=='')
			{

				$this->form_validation->set_rules('video_inline_creative', 'lang:video_file', 'required|trim');
			}
		}
		
		if($this->form_validation->run() === FALSE)
		{

			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'1';
			
			$video_data			=	$this->Do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->Do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
			if($delivery=='progressive')
			{	
				if($this->post('tmp_video_inline_creative')!='')
				{	
					if($vast['vast_video_delivery']=='progressive')
					{	
						
						$shF = explode(".",$video['filename'])[0];
						if(file_exists("./ads/www/images/".$shF."/"))
						{
							system("rm -rf ".escapeshellarg("./ads/www/images/".$shF."/"));
						}
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);

					}
					
					$is_video_creative_moved_ffmpeg	=	$this->image_lib->move_creative_to_ffmpeg_location($this->post('tmp_video_inline_creative'));
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_inline_creative'));
                                        
                    if($this->commandExists("ffmpeg")>0) 
					{
					
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	$this->post('tmp_video_inline_creative');
						$output 			= 	$this->post('tmp_video_inline_creative_raw_name').'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	$this->post('tmp_video_inline_creative_raw_name');

						$ext				=	$this->post('tmp_video_inline_creative_file_ext');

						$input_with_path  	= 	$upload_path.$this->post('tmp_video_inline_creative');
						$output_with_path 	= 	$upload_path.$output;
						
				
						$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						//$this->response( $video_duration, 200);
						
						$video_duration		=	!empty($video_duration) ? $video_duration : 30;	
					}
					else 
					{
						$video_duration		=	'30';	
					} 

					
					$video_name			=	$this->post('tmp_video_inline_creative');
					if($this->post('tmp_video_inline_creative_content_type')=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	$this->post('tmp_video_inline_creative_content_type');
					}
					
								
					$hlsStreaming = $this->HlsStreaming($this->post());		
					
					$toCheckExist = $this->config->item('creative_path').$this->post('tmp_video_inline_creative_raw_name')."/playlist.m3u8";
					$headers=get_headers($toCheckExist);
					if(stripos($headers[0],"200 OK"))
					{
						$outgoing_filename_m3u8 = $this->config->item('creative_path').$this->post('tmp_video_inline_creative_raw_name')."/playlist.m3u8";
						$outType = "m3u8";
					}
					else
					{
						$outgoing_filename_m3u8	=	"nope";		
						$outType = "nope";
					}
					$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_inline_creative');		
				}
				else
				{
					$video_name			=	$video['filename'];
					$video_type			=	$vast['vast_video_type'];
					$video_duration		=	$vast['vast_video_duration'];	
					$outgoing_filename	=	$vast['vast_video_outgoing_filename'];	
				}
				
				
			}
			elseif($delivery=='streaming')
			{
				if($vast['vast_video_delivery']=='progressive')
				{
					$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
				}	
				$video_name			=	'';				
				$video_duration		=	$this->post('inline_rtmp_duration');
				$rtmp_url			=	$this->post('inline_rtmpurl');
				$rtmp_filename		=	$this->post('inline_rtmp_filename');
				if(strpos($rtmp_filename, '.') != false)
				{
					$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
				}
				else
				{
					$type			=	'flv';
				}
				$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
				$video_type			=	'video/x-'.$type;
				
			}
			
			if($this->post('inline_companion_size')!='')
			{

				$size 				= 	explode("x",$this->post('inline_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				if($this->post('tmp_inline_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_inline_creative_name').' Companion';
					
					if($this->user_authentication->account_type=='ADVERTISER')
					{
					  $dj_account_id=$this->user_authentication->account_id;
					}
					else
					{
					  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
					}
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_inline_companion_creative_content_type')),
												"campaignid"		=>	clean_data($this->post('campaign')),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_inline_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data($dest_url),
												"dj_master_banner"	=>	clean_data($master_banner),
												"dj_banner_type" 	=> 	WEB_CREATIVE_WEB,
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id"		=>  clean_data($dj_account_id)
											);
											
						$companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,FALSE,$is_house_ad);
					//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_inline_companion_creative'));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				else
				{
					$companion_id	=	$this->post('vast_companion_id');


				}
			}
			else
			{
				$companion_id	=	0;

			}
			
						
			$aVastVariables = array('banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_outgoing_filename_m3u8' =>	$outgoing_filename_m3u8,
									'vast_video_outgoing_streaming_type' =>	$outType, 
									'vast_video_clickthrough_url' 	=> 	$dest_url,
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	'',
									'vast_video_skip_duration'					=>  $skip_offset,
									'vast_video_skip_progress_duration'				=>  $progress_offset,
									'vast_thirdparty_companion_clicktracking'=>	clean_data($companionclicktrackurl),
									'vast_thirdparty_companion_expandedwidth'		=>	clean_data($expanded_width),
									'vast_thirdparty_companion_expandedheight'		=>	clean_data($expanded_height),
									'is_vpaid'	=> clean_data($vpaid_enable),
									'vpaid_url'	=> clean_data($vpaid_api_url),
									'vpaid_type'	=> clean_data($vpaid_type),
									'vpaid_expanded'=> clean_data($vpaid_expand),
									'vpaid_width'	=> clean_data($vpaid_expand_width),
									'vpaid_height'	=> clean_data($vpaid_expand_height),
									'vpaid_icons'	=> clean_data($vpaid_icon_url),
									'vpaid_remainingTime'	=> clean_data($vpaid_remain_time),
									'vpaid_volume'	=> clean_data($vpaid_video_volume),
									'adbreak_tag1'	=> clean_data($adbreak1_tag),
									'adbreak_tag2'	=> clean_data($adbreak2_tag),
									'adbreak_tag3'	=> clean_data($adbreak3_tag),
									'vmap_midroll_skipoffset'	=> clean_data($vmap_midroll_skipoffset),
									'vast_wrapper_url'	=> clean_data($thirdparty_vast_tag),
								);


			$parameters 	= serialize($aVastVariables);


			if($dj_admin_approve == -1)
			{
			
			$creative_data 	= array(
							         "contenttype"		=>	clean_data($video_type),
							         "campaignid" => clean_data($campaign_id),
									"description"		=>	clean_data($this->post('video_inline_creative_name')),
									"filename"			=>	clean_data($video_name),
									"url"				=>	clean_data($dest_url),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),	
									"dj_admin_approve"			=>	clean_data(0),	
								);
			} else
			{
			$creative_data 	= array(
							        "contenttype"		=>	clean_data($video_type),
							         "campaignid" => clean_data($campaign_id),
									"description"		=>	clean_data($this->post('video_inline_creative_name')),
									"filename"			=>	clean_data($video_name),
									"url"				=>	clean_data($dest_url),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),	
								);				
				
			}
			/* //end */
			//Get agencyid from library file
			$agency_id=$this->user_authentication->agency_id;

			
			//Call to update a creative
			$updated		=	$this->Do_video_creative->update_video($creative_data,$creative_id,$agency_id,$is_house_ad);
			
			// added for edited creative status update
			//29-06-2017
			//$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			//~ }						
				$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
			$link_type=$this->default_configurations->get('linking_type');
				
				if($link_type !='manual linking')
				{
					$this->Do_auto_link->link_adblocks($creative_id,$agency_id,$campaign_id);
				}
				//echo $is_house_ad;exit;
				if($is_house_ad == 1)
				{
					
					$this->Do_auto_link->link_adblocks($creative_id,$agency_id,$campaign_id);
				}
			
			if($updated)
			{					
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($dest_url),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_video_skip_duration"		=>  $skip_offset,
										"vast_video_skip_progress_duration"=>  $progress_offset,
										"vast_thirdparty_clicktracking"		=>	clean_data($clicktrackurl),
									    "vast_thirdparty_clickcustom"    =>	clean_data($clicktrackcustomurl),	
										"vast_thirdparty_companion_clicktracking"=>	clean_data($companionclicktrackurl),
										"vast_thirdparty_companion_expandedwidth"=>	clean_data($expanded_width),
										"vast_thirdparty_companion_expandedheight"=>	clean_data($expanded_height),
										"vast_wrapper_url"	=> clean_data($thirdparty_vast_tag),
										"is_vpaid"	=> clean_data($vpaid_enable),
										"vpaid_url"	=> clean_data($vpaid_api_url),
										"vpaid_type"	=> clean_data($vpaid_type),
										"vpaid_expanded"=> clean_data($vpaid_expand),
										"vpaid_width"	=> clean_data($vpaid_expand_width),
										"vpaid_height"	=> clean_data($vpaid_expand_height),
										"vpaid_icons"	=> clean_data($vpaid_icon_url),
										"vpaid_remainingTime"	=> clean_data($vpaid_remain_time),
										"vpaid_volume"	=> clean_data($vpaid_video_volume),
										"adbreak_tag1"	=> clean_data($adbreak1_tag),
										"adbreak_tag2"	=> clean_data($adbreak2_tag),
										"adbreak_tag3"	=> clean_data($adbreak3_tag),
										"vmap_midroll_skipoffset"	=> clean_data($vmap_midroll_skipoffset),
										"vast_version" => clean_data($vast_version)		
									);
									
				$vast_update	=	$this->Do_video_creative->update_video_vast($vast_data,$creative_id);
				
			// added for edited creative status update
			//29-06-2017
			//$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			//~ }						
					$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
				if($vast_update)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('creative_successfully_updated'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
					$this->response( $success, 200);
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
		
	}
	
	public function edit_video_interstital_creative_post()
	{
		$creative_id	=	$this->post('creative_id');
		$url	=	$this->post('inline_url');
		
		//$delivery		=	$this->post('inline_delivery_method');
		$this->form_validation->set_rules('video_inline_creative_name','lang:creative_name', 'required|trim');		
		//$this->form_validation->set_rules('inline_delivery_method', 'Delivery Type', 'required|trim');
		

		
if($delivery == 'vmap' || $delivery == 'vast')
		{		
		
		}
		else
		{
			$this->form_validation->set_rules('inline_url', 'lang:Destination_URL', 'required|trim|url');
		}	
		
	
	
		
		$campaign = $this->post('_vin_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_vin_campaign_id');
		}
		$delivery='progressive';
		if($delivery=='streaming')
		{
			$this->form_validation->set_rules('inline_rtmpurl', 'lang:rtmp_url', 'required|trim|url');
			$this->form_validation->set_rules('inline_rtmp_filename', 'lang:rtmp_file_name', 'required|trim');
			$this->form_validation->set_rules('inline_rtmp_duration', 'lang:rtmp_video_duration', 'required|trim');
		}
		else if($delivery=='progressive')
		{

			if($this->post('tmp_video_inline')=='')
			{

				$this->form_validation->set_rules('video_inline_creative', 'lang:video_file', 'required|trim');
			}
		}
		
		if($this->form_validation->run() === FALSE)
		{

			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'1';
			
			$video_data			=	$this->Do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->Do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
			if($delivery=='progressive')
			{	
				if($this->post('tmp_video_inline_creative')!='')
				{	
					if($vast['vast_video_delivery']=='progressive')
					{	
						
						$shF = explode(".",$video['filename'])[0];
						if(file_exists("./ads/www/images/".$shF."/"))
						{
							system("rm -rf ".escapeshellarg("./ads/www/images/".$shF."/"));
						}
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
						
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
					}
					
					
					$is_video_creative_moved_ffmpeg	=	$this->image_lib->move_creative_to_ffmpeg_location($this->post('tmp_video_inline_creative'));
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_inline_creative'));
                                        
                    if($this->commandExists("ffmpeg")>0) 
					{
					
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	$this->post('tmp_video_inline_creative');
						$output 			= 	$this->post('tmp_video_inline_creative_raw_name').'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	$this->post('tmp_video_inline_creative_raw_name');

						$ext				=	$this->post('tmp_video_inline_creative_file_ext');

						$input_with_path  	= 	$upload_path.$this->post('tmp_video_inline_creative');
						$output_with_path 	= 	$upload_path.$output;
						
				
						$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						//$this->response( $video_duration, 200);
						
						$video_duration		=	!empty($video_duration) ? $video_duration : 30;	
					}
					else 
					{
						$video_duration		=	'30';	
					} 

					
					$video_name			=	$this->post('tmp_video_inline_creative');
					if($this->post('tmp_video_inline_creative_content_type')=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	$this->post('tmp_video_inline_creative_content_type');
					}
					
					$hlsStreaming = $this->HlsStreaming($this->post());		
					
					$toCheckExist = $this->config->item('creative_path').$this->post('tmp_video_inline_creative_raw_name')."/playlist.m3u8";
					$headers=get_headers($toCheckExist);
					if(stripos($headers[0],"200 OK"))
					{
						$outgoing_filename_m3u8 = $this->config->item('creative_path').$this->post('tmp_video_inline_creative_raw_name')."/playlist.m3u8";
						$outType = "m3u8";
					}
					else
					{
						$outgoing_filename_m3u8	=	"nope";		
						$outType = "nope";
					}
					
					$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_inline_creative');					
					
				}
				else
				{
					$video_name			=	$video['filename'];
					$video_type			=	$vast['vast_video_type'];
					$video_duration		=	$vast['vast_video_duration'];	
					$outgoing_filename	=	$vast['vast_video_outgoing_filename'];	
				}
			}
			elseif($delivery=='streaming')
			{
				if($vast['vast_video_delivery']=='progressive')
				{
					$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
				}	
				$video_name			=	'';				
				$video_duration		=	$this->post('inline_rtmp_duration');
				$rtmp_url			=	$this->post('inline_rtmpurl');
				$rtmp_filename		=	$this->post('inline_rtmp_filename');
				if(strpos($rtmp_filename, '.') != false)
				{
					$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
				}
				else
				{
					$type			=	'flv';
				}
				$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
				$video_type			=	'video/x-'.$type;
				
			}
			
			if($this->post('inline_companion_size')!='')
			{

				$size 				= 	explode("x",$this->post('inline_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				if($this->post('tmp_inline_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_inline_creative_name').' Companion';
					
					if($this->user_authentication->account_type=='ADVERTISER')
					{
					  $dj_account_id=$this->user_authentication->account_id;
					}
					else
					{
					  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
					}
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_inline_companion_creative_content_type')),
												"campaignid"		=>	clean_data($this->post('campaign')),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_inline_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data($this->post('inline_url')),
												"dj_master_banner"	=>	clean_data($master_banner),
												"dj_banner_type" 	=> 	WEB_CREATIVE_WEB,
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id"		=>  clean_data($dj_account_id)
											);
											
						$companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,FALSE,$is_house_ad);
					//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_inline_companion_creative'));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				else
				{
					$companion_id	=	$this->post('vast_companion_id');


				}
			}
			else
			{
				$companion_id	=	0;

			}
			
			$aVastVariables = array('banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_outgoing_filename_m3u8' =>	$outgoing_filename_m3u8,
									'vast_video_outgoing_streaming_type' =>	$outType, 
									'vast_video_clickthrough_url' 	=> 	$this->post('inline_url'),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	'',
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	'',
									'vast_video_skip_duration'					=>  '',
									'vast_video_skip_progress_duration'				=>  '',
									'vast_thirdparty_companion_clicktracking'=>	'',
									'vast_thirdparty_companion_expandedwidth'		=>	'',
									'vast_thirdparty_companion_expandedheight'		=>	'',
									'is_vpaid'	=> '',
									'vpaid_url'	=> '',
									'vpaid_type'	=> '',
									'vpaid_expanded'=> '',
									'vpaid_width'	=> '',
									'vpaid_height'	=> '',
									'vpaid_icons'	=> '',
									'vpaid_remainingTime'	=> '',
									'vpaid_volume'	=> '',
									'adbreak_tag1'	=> '',
									'adbreak_tag2'	=> '',
									'adbreak_tag3'	=> '',
									'vmap_midroll_skipoffset'	=> '',
									'vast_wrapper_url'	=> '',
								);


			$parameters 	= serialize($aVastVariables);

			/* modified by karthika on dec-2 */
			if($dj_admin_approve == -1)
			{
			
			$creative_data 	= array(
									"description"		=>	clean_data($this->post('video_inline_creative_name')),
									 "campaignid" => clean_data($campaign_id),
									"filename"			=>	clean_data($video_name),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),	
									"dj_admin_approve"			=>	clean_data(0),	
									"url"=>$url,
								);
			} else
			{
			$creative_data 	= array(
									"description"		=>	clean_data($this->post('video_inline_creative_name')),
									 "campaignid" => clean_data($campaign_id),
									"filename"			=>	clean_data($video_name),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),	
									"url"=>$url,
								);				
				
			}
			/* //end */
			//Get agencyid from library file
			$agency_id=$this->user_authentication->agency_id;

			
			//Call to update a creative
			$updated		=	$this->Do_video_creative->update_video($creative_data,$creative_id,$agency_id,$is_house_ad);
			
		    // added for edited creative status update
			//29-06-2017
			//$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			//~ }						
				$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
			$link_type=$this->default_configurations->get('linking_type');
				
				if($link_type !='manual linking')
				{
					$this->Do_auto_link->link_adblocks($creative_id,$agency_id,$campaign_id);
				}
				//echo $is_house_ad;exit;
				if($is_house_ad == 1)
				{
					
					$this->Do_auto_link->link_adblocks($creative_id,$agency_id,$campaign_id);
				}
			
			
			
			if($updated)
			{					
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('inline_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_video_skip_duration"		=>  '',
										"vast_video_skip_progress_duration"=>  '',
										"vast_thirdparty_clicktracking"		=>	'',
									    "vast_thirdparty_clickcustom"    =>	'',	
										"vast_thirdparty_companion_clicktracking"=>	'',
										"vast_thirdparty_companion_expandedwidth"=>	'',
										"vast_thirdparty_companion_expandedheight"=>'',
										"vast_wrapper_url"	=> '',
										"is_vpaid"	=> '',
										"vpaid_url"	=> '',
										"vpaid_type"	=> '',
										"vpaid_expanded"=> '',
										"vpaid_width"	=> '',
										"vpaid_height"	=> '',
										"vpaid_icons"	=> '',
										"vpaid_remainingTime"	=> '',
										"vpaid_volume"	=> '',
										"adbreak_tag1"	=> '',
										"adbreak_tag2"	=> '',
										"adbreak_tag3"	=> '',
										"vmap_midroll_skipoffset"	=> '',
										"vast_version" => ''	
									);
									
				$vast_update	=	$this->Do_video_creative->update_video_vast($vast_data,$creative_id);
				
				if($vast_update)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('ctv_succ_updated'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
					$this->response( $success, 200);
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
		
	}
	
	/*
	 * 
	 * name: edit_video_overlay_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all OVERLAY VIDEO CREATIVE edit process	 
	 */
	public function edit_video_overlay_creative_post()
	{
		$creative_id			=	$this->post('creative_id');
		$ovl_type				=	$this->post('overlay_type');
		$ovl_action				=	$this->post('click_action');
		$ovl_delivery			=	$this->post('overlay_delivery_method');
		
		/*Overlay Advanced setting values */	
		$expanded_width			=	$this->post('expanded_width');
		$expanded_height		=	$this->post('expanded_height');
		$min_suggested_duration	=	$this->post('min_suggested_duration');
		/*Overlay Advanced setting values */
		$clicktrackurl			=	$this->post('clicktrackurl');
		$clicktrackcustomurl	=	$this->post('clicktrackcustomurl');
		/*3rd Party ad tag 
		 * Name:Pradeep.M
		 * Date:23-05-2016*/
		$thirdparty_vast_tag	=	$this->post('thirdparty_vast_tag');
		$vast_overlay_version	=	$this->post('vast_overlay_version');	
			if($ovl_type=='vmap')
		{
			$overlay_vmap_count	=	$this->post('overlay_vmap_count');
			if($overlay_vmap_count==2)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	'';
				$adbreak4_tag	=	'';
				$adbreak5_tag	=	'';
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	'';
				$vmap_adbreak4_offset=	'';
				$vmap_adbreak5_offset=	'';
				
			}
			else if($overlay_vmap_count==3)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	$this->post('adbreak3_tag');
				$adbreak4_tag	=	'';
				$adbreak5_tag	=	'';
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	$this->post('vmap_adbreak3_offset');
				$vmap_adbreak4_offset=	'';
				$vmap_adbreak5_offset=	'';
			}
			else if($overlay_vmap_count==4)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	$this->post('adbreak3_tag');
				$adbreak4_tag	=	$this->post('adbreak4_tag');
				$adbreak5_tag	=	'';
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	$this->post('vmap_adbreak3_offset');
				$vmap_adbreak4_offset=	$this->post('vmap_adbreak4_offset');
				$vmap_adbreak5_offset=	'';
			}
			else if($overlay_vmap_count==5)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	$this->post('adbreak3_tag');
				$adbreak4_tag	=	$this->post('adbreak4_tag');
				$adbreak5_tag	=	$this->post('adbreak5_tag');
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	$this->post('vmap_adbreak3_offset');
				$vmap_adbreak4_offset=	$this->post('vmap_adbreak4_offset');
				$vmap_adbreak5_offset=	$this->post('vmap_adbreak5_offset');
			}
			
		}
		else
		{
				$adbreak1_tag	=	'';
				$adbreak2_tag	=	'';
				$adbreak3_tag	=	'';
				$adbreak4_tag	=	'';
				$adbreak5_tag	=	'';
				$vmap_adbreak1_offset=	'';
				$vmap_adbreak2_offset=	'';
				$vmap_adbreak3_offset=	'';
				$vmap_adbreak4_offset=	'';
				$vmap_adbreak5_offset=	'';
}
		//vpaid jayashree
		$vpaid_enable=$this->post('vapid_enable');
		if($vpaid_enable==1)
		{
			$vpaid_api_url=$this->post('vpaid_url');
			$vpaid_expand=$this->post('vapid_expand');
			$vpaid_type=$this->post('vapid_type'); 
			if($vpaid_expand==1)
			{
				$vpaid_expand_width=$this->post('resize_width');
				$vpaid_expand_height=$this->post('resize_height');
			}
			else if($vpaid_expand==0)
			{
				$vpaid_expand_width='';
				$vpaid_expand_height='';
			}
		}
		$clicktrackurl			=	$this->post('clicktrackurl');
		$clicktrackcustomurl	=	$this->post('clicktrackcustomurl');
		if($ovl_type=='wrapper_overlay')
		{
			$thirdparty_vast_tag	=	$this->post('thirdparty_vast_tag');
			$vast_overlay_version	=	$this->post('vast_overlay_version');
		}
		else
		{
			$thirdparty_vast_tag	=	'';
			$vast_overlay_version	=	'';
		}
		
		$this->form_validation->set_rules('video_overlay_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('overlay_type', 'lang:overlay_type', 'required|trim');		
		$this->form_validation->set_rules('click_action', 'lang:overlay_type', 'required|trim');		
		$this->form_validation->set_rules('overlay_delivery_method', 'lang:del_type', 'required|trim');
			
		if($ovl_type=='image_overlay')
		{
			if($this->post('tmp_overlay_image')=='')
			{
				$this->form_validation->set_rules('overlay_image', 'lang:image_file', 'required|trim');
			}
		}
		elseif($ovl_type=='swf_overlay')
		{
			if($this->post('tmp_overlay_swf')=='')
			{
				$this->form_validation->set_rules('overlay_swf', 'lang:swf_file', 'required|trim');
			}
		}
		elseif($ovl_type=='text_overlay')
		{
			$this->form_validation->set_rules('txt_title', 'lang:text_overlay_title', 'required|trim');		
			$this->form_validation->set_rules('txt_action', 'lang:text_overlay_action', 'trim|url');		
		}
		
		elseif($ovl_type=='wrapper_overlay')
		{
			$this->form_validation->set_rules('thirdparty_vast_tag', 'lang:third_party_vast_tag', 'required|trim');		
			
		}	
		
		if($ovl_action=='click_to_video')
		{	
			$this->form_validation->set_rules('overlay_click_url', 'lang:overlay_click_url', 'required|trim|url');
			if($this->post('tmp_video_overlay')=='')
			{
				$this->form_validation->set_rules('video_overlay_creative', 'lang:video_file', 'required|trim');
			}
		}
		elseif($ovl_type!='wrapper_overlay' && $ovl_type!='vmap')
		{
			$this->form_validation->set_rules('overlay_url', 'lang:destination_url', 'required|trim');
		}
		
		if($ovl_delivery=='streaming')
		{
			$this->form_validation->set_rules('overlay_rtmpurl', 'lang:rtmp_url', 'required|trim');
			$this->form_validation->set_rules('overlay_rtmp_filename', 'lang:rtmp_file_name', 'required|trim');
			$this->form_validation->set_rules('overlay_rtmp_duration', 'lang:rtmp_video_duration', 'required|trim');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			/* Static values */
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'1';
				
			$video_data			=	$this->Do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->Do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
				
			/* Overlay Type - Image Overlay */
			if($ovl_type=='image_overlay')
			{
				if($this->post('tmp_overlay_image_creative')!='')
				{
					if($video['filename']!='')
					{
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
					}
					$file_name			=	$this->post('tmp_overlay_image_creative');
					$creative_type		=	$this->post('tmp_overlay_image_creative_content_type');
					$ovl_width			=	'300';
					$ovl_height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_overlay_image_creative'));
				}
				else
				{
					$file_name		=	$video['filename'];
					$creative_type	=	$vast['vast_creative_type'];
					$ovl_width		=	$vast['vast_overlay_width'];
					$ovl_height		=	$vast['vast_overlay_height'];
				}
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			/* Overlay Type - SWF Overlay */
			elseif($ovl_type=='swf_overlay')
			{
				if($this->post('tmp_overlay_swf_creative')!='')
				{
					if($video['filename']!='')
					{
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
					}
					$file_name			=	$this->post('tmp_overlay_swf_creative');
					$creative_type		=	'swf';
					$ovl_width			=	'300';
					$ovl_height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_overlay_swf_creative'));
				}
				else
				{
					$file_name		=	$video['filename'];
					$creative_type	=	$vast['vast_creative_type'];
					$ovl_width		=	$vast['vast_overlay_width'];
					$ovl_height		=	$vast['vast_overlay_height'];
				}
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			/* Overlay Type - Text Overlay */
			elseif($ovl_type=='text_overlay')
			{
				if($video['filename']!='')
				{
					$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
				}
				$file_name			=	'';
				$creative_type		=	NULL;
				$ovl_width			=	NULL;
				$ovl_height			=	NULL;
				$txt_title			=	$this->post('txt_title');
				$txt_description	=	$this->post('txt_description');
				$txt_action			=	$this->post('txt_action');
			}
			
			/* Overlay Action - Click to Page */
			if($ovl_action=='click_to_page')
			{
				if($vast['vast_video_delivery']=='progressive')
				{
					$xmlFile		= 	pathinfo($vast['vast_video_outgoing_filename']);
					$videoname		= 	$xmlFile['basename'];
					$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($videoname);
				}
				if($ovl_type=='wrapper_overlay')
				{
					$destination_url	='';
				}
				else
				{
					$destination_url=$this->post('overlay_url');
				}
				//$destination_url	=	'';
				$htmlcache			=	'<a href="{clickurl}" target="{target}"></a>';
				$ovl_delivery		=	NULL;
				$click_url			=	NULL;
				$video_type			=	NULL;
				$video_duration		=	NULL;
				$outgoing_filename	=	NULL;
			}
			/* Overlay Action - Click to Video */
			elseif($ovl_action=='click_to_video')
			{	
				/* Overlay Delivery type - Progressive */			
				if($ovl_delivery=='progressive')
				{	
					if($this->post('tmp_video_overlay_creative')!='')
					{	
						if($vast['vast_video_delivery']=='progressive')
						{
							$xmlFile		= 	pathinfo($vast['vast_video_outgoing_filename']);
							$videoname		= 	$xmlFile['basename'];
							$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($videoname);
						}
						
						if($this->commandExists("ffmpeg")>0) 
						{
							##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
							$input  			= 	$this->post('tmp_video_overlay_creative');
							$output 			= 	$this->post('tmp_video_overlay_creative_raw_name').'.flv';
							
							$upload_path		=	$this->config->item('creative_path');
							$raw_name			=	$this->post('tmp_video_overlay_creative_raw_name');

							$ext				=	$this->post('tmp_video_overlay_creative_file_ext');

							$input_with_path  	= 	$upload_path.$this->post('tmp_video_overlay_creative');
							$output_with_path 	= 	$upload_path.$output;
							
							#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
							$video_duration		=	'30';	
						}
						else 
						{
							$video_duration		=	'30';	
						}
						
						$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_overlay_creative'));
						
						if($this->post('tmp_video_overlay_creative_content_type')=='video/mp4')
						{
							$video_type		=	'video/x-mp4';
						}
						else
						{
							$video_type		=	$this->post('tmp_video_overlay_creative_content_type');
						}
						$video_duration		=	'30';	
						$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_overlay_creative');					
												
					}
					else
					{
						$video_name			=	$video['filename'];
						$video_type			=	$vast['vast_video_type'];
						$video_duration		=	$vast['vast_video_duration'];	
						$outgoing_filename	=	$vast['vast_video_outgoing_filename'];	
					}
				}
				/* Overlay Delivery type - Streaming */			
				elseif($ovl_delivery=='streaming')
				{	
					if($vast['vast_video_delivery']=='progressive')
					{
						$xmlFile		= 	pathinfo($vast['vast_video_outgoing_filename']);
						$videoname		= 	$xmlFile['basename'];
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($videoname);
					}	
					
					$video_duration		=	$this->post('overlay_rtmp_duration');
					$rtmp_url			=	$this->post('overlay_rtmpurl');
					$rtmp_filename		=	$this->post('overlay_rtmp_filename');
					if(strpos($rtmp_filename, '.') != false)
					{
						$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
					}
					else
					{
						$type			=	'flv';
					}
					$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
					$video_type			=	'video/x-'.$type;
				}
				$destination_url	=	'';
				$htmlcache			=	'';
				$click_url			=	$this->post('overlay_click_url');
			}
			$companion_width 	= 	$this->post('overlay_companion_width');
				$companion_height 	= 	$this->post('overlay_companion_height');
				$companionclicktrackurl = 	$this->post('companionclicktrackurl');
				$com_expanded_width 	= 	$this->post('comp_expanded_width');
				$com_expanded_height 	= 	$this->post('comp_expanded_height');
			/* Overlay Companion */			
			if($this->post('overlay_companion_size')!='')
			{
				$size 				= 	explode("x",$this->post('overlay_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				
				
				/* Overlay Companion - Upload */			
				if($this->post('tmp_overlay_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_overlay_creative_name').' Companion';
					
					if($this->user_authentication->account_type=='ADVERTISER')
					{
					  $dj_account_id=$this->user_authentication->account_id;
					}
					else
					{
					  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
					}
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_overlay_companion_creative_content_type')),
												"campaignid"		=>	clean_data($this->post('campaign')),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_overlay_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data(($destination_url!='')?$destination_url:$click_url),
												"dj_master_banner"	=>	clean_data($master_banner),
												"dj_banner_type" 	=> 	WEB_CREATIVE_WEB,
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id"		=>  clean_data($dj_account_id)
											);
											
						$companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,$is_house_ad);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_overlay_companion_creative'));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				/* Overlay Companion - Selection */			
				else
				{
					$companion_id	=	$this->post('vast_companion_id');
					
					if($companion_id !='')
					{
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					
					}else
					{$companion_id	=	$this->post('vast_companion_id');
						
					}
				}
			}
			else
			{
				$companion_id	=	0;
			}				
			
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$ovl_delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	$click_url,
									'vast_overlay_height' 			=> 	$ovl_height,
									'vast_overlay_width' 			=> 	$ovl_width,
									'vast_overlay_text_title' 		=> 	$txt_title,
									'vast_overlay_text_description' => 	$txt_description,
									'vast_overlay_text_call' 		=> 	$txt_action,
									'vast_overlay_format' 			=>	$ovl_type,
									'vast_overlay_action' 			=> 	$ovl_action,
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	$creative_type,
									'vast_thirdparty_impression' 	=> 	'',
									'vast_overlay_expanded_width'			=>	$expanded_width,
									'vast_overlay_expanded_height'			=> 	$expanded_height,
									'vast_overlay_expandedminduration'		=>	$min_suggested_duration,
									'vast_thirdparty_companion_clicktracking'=>	clean_data($companionclicktrackurl),
									'vast_thirdparty_companion_expandedwidth'		=>	clean_data($com_expanded_width),
									'vast_thirdparty_companion_expandedheight'		=>	clean_data($com_expanded_height),
									'vast_overlay_version' => clean_data($vast_overlay_version),
									//vpaid jayshree
									'is_vpaid'	=> clean_data($vpaid_enable),
									'vpaid_url'	=> clean_data($vpaid_api_url),
									'vpaid_type'	=> clean_data($vpaid_type),
									'vpaid_expanded'=> clean_data($vpaid_expand),
									'vpaid_width'	=> clean_data($vpaid_expand_width),
									'vpaid_height'	=> clean_data($vpaid_expand_height),
									'adbreak_tag1'	=> clean_data($adbreak1_tag),
									'adbreak_tag2'	=> clean_data($adbreak2_tag),
									'adbreak_tag3'	=> clean_data($adbreak3_tag),
									'adbreak_tag4'	=> clean_data($adbreak4_tag),
									'adbreak_tag5'	=> clean_data($adbreak5_tag),
									'vmap_overlay_count'	=> clean_data($overlay_vmap_count),
									'vmap_offset_adbreak1'	=> clean_data($vmap_adbreak1_offset),
									'vmap_offset_adbreak2'	=> clean_data($vmap_adbreak2_offset),
									'vmap_offset_adbreak3'	=> clean_data($vmap_adbreak3_offset),
									'vmap_offset_adbreak4'	=> clean_data($vmap_adbreak4_offset),
									'vmap_offset_adbreak5'	=> clean_data($vmap_adbreak5_offset),
									'vast_overlay_wrapper' => clean_data($thirdparty_vast_tag)
								);
						
			$parameters 	= serialize($aVastVariables);
			
			/* dj_admin_approve added on dec-2 */
			$dj_admin_approve = $this->post('dj_admin_approve');
			if($dj_admin_approve == -1)
			{
				$creative_data 	= array(
										"contenttype"		=>	clean_data($creative_type),
										 "campaignid" => clean_data($this->post('campaign')),
										"description"		=>	clean_data($this->post('video_overlay_creative_name')),
										"filename"			=>	clean_data($file_name),
										"parameters"		=>	$parameters,
										"url"				=>	clean_data($destination_url),
										"htmlcache"			=>	$htmlcache,
										"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_admin_approve"  =>  clean_data(0)							
									);
			}else
			{
				$creative_data 	= array(
										"contenttype"		=>	clean_data($creative_type),
										 "campaignid" => clean_data($this->post('campaign')),
										"description"		=>	clean_data($this->post('video_overlay_creative_name')),
										"filename"			=>	clean_data($file_name),
										"parameters"		=>	$parameters,
										"url"				=>	clean_data($destination_url),
										"htmlcache"			=>	$htmlcache,
										"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
									);				
			}
			
			//Call to add a creative
			$updated		=	$this->Do_video_creative->update_video($creative_data,$creative_id,FALSE,$is_house_ad);		
			
			// added for edited creative status update
			//29-06-2017
			//$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			//~ }						
				$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
				$link_type=$this->default_configurations->get('linking_type');
				
				if($link_type !='manual linking')
				{
					$this->Do_auto_link->link_adblocks($creative_id,$agency_id,$this->post('campaign'));
				}
				//echo $is_house_ad;exit;
				if($is_house_ad == 1)
				{
					
					$this->Do_auto_link->link_adblocks($creative_id,$agency_id,$this->post('campaign'));
				}
			 //$this->Do_auto_link->link_adblocks($creative_id);
			
				
			if($updated)	
			{			
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$ovl_delivery,
										"vast_video_type"				=>	$video_type,							
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	$ovl_height,
										"vast_overlay_width"			=>	$ovl_width,
										"vast_video_clickthrough_url"	=>	$click_url,
										"vast_overlay_action"			=>	$ovl_action,
										"vast_overlay_format"			=>	$ovl_type,
										"vast_overlay_text_title"		=>	$txt_title,
										"vast_overlay_text_description"	=>	$txt_description,
										"vast_overlay_text_call"		=>	$txt_action,
										"vast_creative_type"			=>	$creative_type,
										"vast_overlay_expanded_width"			=>	$expanded_width,
										"vast_overlay_expanded_height"			=> 	$expanded_height,
										"vast_overlay_expandedminduration"		=>	$min_suggested_duration,
										"vast_thirdparty_companion_clicktracking"=>	clean_data($companionclicktrackurl),
										"vast_thirdparty_companion_expandedwidth"		=>	clean_data($com_expanded_width),
										"vast_thirdparty_companion_expandedheight"		=>	clean_data($com_expanded_height),
										"vast_thirdparty_clicktracking"		=>	clean_data($clicktrackurl),
										"vast_thirdparty_clickcustom"=>	clean_data($clicktrackcustomurl),
										"vast_overlay_version" => clean_data($vast_overlay_version),
										//vpaid jayshree
										"is_vpaid"	=> clean_data($vpaid_enable),
										"vpaid_url"	=> clean_data($vpaid_api_url),
										"vpaid_type"	=> clean_data($vpaid_type),
										"vpaid_expanded"=> clean_data($vpaid_expand),
										"vpaid_width"	=> clean_data($vpaid_expand_width),
										"vpaid_height"	=> clean_data($vpaid_expand_height),
										"adbreak_tag1"	=> clean_data($adbreak1_tag),
										"adbreak_tag2"	=> clean_data($adbreak2_tag),
										"adbreak_tag3"	=> clean_data($adbreak3_tag),
										"adbreak_tag4"	=> clean_data($adbreak4_tag),
										"adbreak_tag5"	=> clean_data($adbreak5_tag),
										"vmap_overlay_count"	=> clean_data($overlay_vmap_count),
										"vmap_offset_adbreak1"	=> clean_data($vmap_adbreak1_offset),
										"vmap_offset_adbreak2"	=> clean_data($vmap_adbreak2_offset),
										"vmap_offset_adbreak3"	=> clean_data($vmap_adbreak3_offset),
										"vmap_offset_adbreak4"	=> clean_data($vmap_adbreak4_offset),
										"vmap_offset_adbreak5"	=> clean_data($vmap_adbreak5_offset),
									    "vast_overlay_wrapper" => clean_data($thirdparty_vast_tag)
									);
									
				$vast_update	=	$this->Do_video_creative->update_video_vast($vast_data,$creative_id);
				
			// added for edited creative status update
			//29-06-2017
			//$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			//~ }						
					$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
				if($vast_update)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('ctv_succ_updated'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
					$this->response( $success, 200);
					
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> $this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}


	public function edit_pause_video_creative_post()
	{
		$creative_id			=	$this->post('creative_id');
		$ovl_type				=	$this->post('overlay_type');
		$ovl_action				=	$this->post('click_action');
		$ovl_delivery			=	$this->post('overlay_delivery_method');
		
		/*Overlay Advanced setting values */	
		$expanded_width			=	$this->post('expanded_width');
		$expanded_height		=	$this->post('expanded_height');
		$min_suggested_duration	=	$this->post('min_suggested_duration');
		/*Overlay Advanced setting values */
		$clicktrackurl			=	$this->post('clicktrackurl');
		$clicktrackcustomurl	=	$this->post('clicktrackcustomurl');
		/*3rd Party ad tag 
		 * Name:Pradeep.M
		 * Date:23-05-2016*/
		$thirdparty_vast_tag	=	$this->post('thirdparty_vast_tag');
		$vast_overlay_version	=	$this->post('vast_overlay_version');	
			if($ovl_type=='vmap')
		{
			$overlay_vmap_count	=	$this->post('overlay_vmap_count');
			if($overlay_vmap_count==2)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	'';
				$adbreak4_tag	=	'';
				$adbreak5_tag	=	'';
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	'';
				$vmap_adbreak4_offset=	'';
				$vmap_adbreak5_offset=	'';
				
			}
			else if($overlay_vmap_count==3)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	$this->post('adbreak3_tag');
				$adbreak4_tag	=	'';
				$adbreak5_tag	=	'';
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	$this->post('vmap_adbreak3_offset');
				$vmap_adbreak4_offset=	'';
				$vmap_adbreak5_offset=	'';
			}
			else if($overlay_vmap_count==4)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	$this->post('adbreak3_tag');
				$adbreak4_tag	=	$this->post('adbreak4_tag');
				$adbreak5_tag	=	'';
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	$this->post('vmap_adbreak3_offset');
				$vmap_adbreak4_offset=	$this->post('vmap_adbreak4_offset');
				$vmap_adbreak5_offset=	'';
			}
			else if($overlay_vmap_count==5)
			{
				$adbreak1_tag	=	$this->post('adbreak1_tag');
				$adbreak2_tag	=	$this->post('adbreak2_tag');
				$adbreak3_tag	=	$this->post('adbreak3_tag');
				$adbreak4_tag	=	$this->post('adbreak4_tag');
				$adbreak5_tag	=	$this->post('adbreak5_tag');
				$vmap_adbreak1_offset=	$this->post('vmap_adbreak1_offset');
				$vmap_adbreak2_offset=	$this->post('vmap_adbreak2_offset');
				$vmap_adbreak3_offset=	$this->post('vmap_adbreak3_offset');
				$vmap_adbreak4_offset=	$this->post('vmap_adbreak4_offset');
				$vmap_adbreak5_offset=	$this->post('vmap_adbreak5_offset');
			}
			
		}
		else
		{
				$adbreak1_tag	=	'';
				$adbreak2_tag	=	'';
				$adbreak3_tag	=	'';
				$adbreak4_tag	=	'';
				$adbreak5_tag	=	'';
				$vmap_adbreak1_offset=	'';
				$vmap_adbreak2_offset=	'';
				$vmap_adbreak3_offset=	'';
				$vmap_adbreak4_offset=	'';
				$vmap_adbreak5_offset=	'';
}
		//vpaid jayashree
		$vpaid_enable=$this->post('vapid_enable');
		if($vpaid_enable==1)
		{
			$vpaid_api_url=$this->post('vpaid_url');
			$vpaid_expand=$this->post('vapid_expand');
			$vpaid_type=$this->post('vapid_type'); 
			if($vpaid_expand==1)
			{
				$vpaid_expand_width=$this->post('resize_width');
				$vpaid_expand_height=$this->post('resize_height');
			}
			else if($vpaid_expand==0)
			{
				$vpaid_expand_width='';
				$vpaid_expand_height='';
			}
		}
		$clicktrackurl			=	$this->post('clicktrackurl');
		$clicktrackcustomurl	=	$this->post('clicktrackcustomurl');
		if($ovl_type=='wrapper_overlay')
		{
			$thirdparty_vast_tag	=	$this->post('thirdparty_vast_tag');
			$vast_overlay_version	=	$this->post('vast_overlay_version');
		}
		else
		{
			$thirdparty_vast_tag	=	'';
			$vast_overlay_version	=	'';
		}
		
		$this->form_validation->set_rules('video_overlay_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('overlay_type', 'lang:overlay_type', 'required|trim');		
		$this->form_validation->set_rules('click_action', 'lang:overlay_type', 'required|trim');		
		$this->form_validation->set_rules('overlay_delivery_method', 'lang:del_type', 'required|trim');
			
		if($ovl_type=='image_overlay')
		{
			if($this->post('tmp_overlay_image')=='')
			{
				$this->form_validation->set_rules('overlay_image', 'lang:image_file', 'required|trim');
			}
		}
		elseif($ovl_type=='swf_overlay')
		{
			if($this->post('tmp_overlay_swf')=='')
			{
				$this->form_validation->set_rules('overlay_swf', 'lang:swf_file', 'required|trim');
			}
		}
		elseif($ovl_type=='text_overlay')
		{
			$this->form_validation->set_rules('txt_title', 'lang:text_overlay_title', 'required|trim');		
			$this->form_validation->set_rules('txt_action', 'lang:text_overlay_action', 'trim|url');		
		}
		
		elseif($ovl_type=='wrapper_overlay')
		{
			$this->form_validation->set_rules('thirdparty_vast_tag', 'lang:third_party_vast_tag', 'required|trim');		
			
		}	
		
		if($ovl_action=='click_to_video')
		{	
			$this->form_validation->set_rules('overlay_click_url', 'lang:overlay_click_url', 'required|trim|url');
			if($this->post('tmp_video_overlay')=='')
			{
				$this->form_validation->set_rules('video_overlay_creative', 'lang:video_file', 'required|trim');
			}
		}
		elseif($ovl_type!='wrapper_overlay' && $ovl_type!='vmap')
		{
			$this->form_validation->set_rules('overlay_url', 'lang:destination_url', 'required|trim');
		}
		
		if($ovl_delivery=='streaming')
		{
			$this->form_validation->set_rules('overlay_rtmpurl', 'lang:rtmp_url', 'required|trim');
			$this->form_validation->set_rules('overlay_rtmp_filename', 'lang:rtmp_file_name', 'required|trim');
			$this->form_validation->set_rules('overlay_rtmp_duration', 'lang:rtmp_video_duration', 'required|trim');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			/* Static values */
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'1';
				
			$video_data			=	$this->Do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->Do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
				
			/* Overlay Type - Image Overlay */
			if($ovl_type=='image_overlay')
			{
				if($this->post('tmp_overlay_image_creative')!='')
				{
					if($video['filename']!='')
					{
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
					}
					$file_name			=	$this->post('tmp_overlay_image_creative');
					$creative_type		=	$this->post('tmp_overlay_image_creative_content_type');
					$ovl_width			=	'300';
					$ovl_height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_overlay_image_creative'));
				}
				else
				{
					$file_name		=	$video['filename'];
					$creative_type	=	$vast['vast_creative_type'];
					$ovl_width		=	$vast['vast_overlay_width'];
					$ovl_height		=	$vast['vast_overlay_height'];
				}
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			/* Overlay Type - SWF Overlay */
			elseif($ovl_type=='swf_overlay')
			{
				if($this->post('tmp_overlay_swf_creative')!='')
				{
					if($video['filename']!='')
					{
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
					}
					$file_name			=	$this->post('tmp_overlay_swf_creative');
					$creative_type		=	'swf';
					$ovl_width			=	'300';
					$ovl_height			=	'250';
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_overlay_swf_creative'));
				}
				else
				{
					$file_name		=	$video['filename'];
					$creative_type	=	$vast['vast_creative_type'];
					$ovl_width		=	$vast['vast_overlay_width'];
					$ovl_height		=	$vast['vast_overlay_height'];
				}
				$txt_title			=	NULL;
				$txt_description	=	NULL;
				$txt_action			=	NULL;
			}
			/* Overlay Type - Text Overlay */
			elseif($ovl_type=='text_overlay')
			{
				if($video['filename']!='')
				{
					$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
				}
				$file_name			=	'';
				$creative_type		=	NULL;
				$ovl_width			=	NULL;
				$ovl_height			=	NULL;
				$txt_title			=	$this->post('txt_title');
				$txt_description	=	$this->post('txt_description');
				$txt_action			=	$this->post('txt_action');
			}
			
			/* Overlay Action - Click to Page */
			if($ovl_action=='click_to_page')
			{
				if($vast['vast_video_delivery']=='progressive')
				{
					$xmlFile		= 	pathinfo($vast['vast_video_outgoing_filename']);
					$videoname		= 	$xmlFile['basename'];
					$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($videoname);
				}
				if($ovl_type=='wrapper_overlay')
				{
					$destination_url	='';
				}
				else
				{
					$destination_url=$this->post('overlay_url');
				}
				//$destination_url	=	'';
				$htmlcache			=	'<a href="{clickurl}" target="{target}"></a>';
				$ovl_delivery		=	NULL;
				$click_url			=	NULL;
				$video_type			=	NULL;
				$video_duration		=	NULL;
				$outgoing_filename	=	NULL;
			}
			/* Overlay Action - Click to Video */
			elseif($ovl_action=='click_to_video')
			{	
				/* Overlay Delivery type - Progressive */			
				if($ovl_delivery=='progressive')
				{	
					if($this->post('tmp_video_overlay_creative')!='')
					{	
						if($vast['vast_video_delivery']=='progressive')
						{
							$xmlFile		= 	pathinfo($vast['vast_video_outgoing_filename']);
							$videoname		= 	$xmlFile['basename'];
							$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($videoname);
						}
						
						if($this->commandExists("ffmpeg")>0) 
						{
							##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
							$input  			= 	$this->post('tmp_video_overlay_creative');
							$output 			= 	$this->post('tmp_video_overlay_creative_raw_name').'.flv';
							
							$upload_path		=	$this->config->item('creative_path');
							$raw_name			=	$this->post('tmp_video_overlay_creative_raw_name');

							$ext				=	$this->post('tmp_video_overlay_creative_file_ext');

							$input_with_path  	= 	$upload_path.$this->post('tmp_video_overlay_creative');
							$output_with_path 	= 	$upload_path.$output;
							
							#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
							$video_duration		=	'30';	
						}
						else 
						{
							$video_duration		=	'30';	
						}
						
						$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_overlay_creative'));
						
						if($this->post('tmp_video_overlay_creative_content_type')=='video/mp4')
						{
							$video_type		=	'video/x-mp4';
						}
						else
						{
							$video_type		=	$this->post('tmp_video_overlay_creative_content_type');
						}
						$video_duration		=	'30';	
						$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_overlay_creative');					
												
					}
					else
					{
						$video_name			=	$video['filename'];
						$video_type			=	$vast['vast_video_type'];
						$video_duration		=	$vast['vast_video_duration'];	
						$outgoing_filename	=	$vast['vast_video_outgoing_filename'];	
					}
				}
				/* Overlay Delivery type - Streaming */			
				elseif($ovl_delivery=='streaming')
				{	
					if($vast['vast_video_delivery']=='progressive')
					{
						$xmlFile		= 	pathinfo($vast['vast_video_outgoing_filename']);
						$videoname		= 	$xmlFile['basename'];
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($videoname);
					}	
					
					$video_duration		=	$this->post('overlay_rtmp_duration');
					$rtmp_url			=	$this->post('overlay_rtmpurl');
					$rtmp_filename		=	$this->post('overlay_rtmp_filename');
					if(strpos($rtmp_filename, '.') != false)
					{
						$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
					}
					else
					{
						$type			=	'flv';
					}
					$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
					$video_type			=	'video/x-'.$type;
				}
				$destination_url	=	'';
				$htmlcache			=	'';
				$click_url			=	$this->post('overlay_click_url');
			}
			$companion_width 	= 	$this->post('overlay_companion_width');
				$companion_height 	= 	$this->post('overlay_companion_height');
				$companionclicktrackurl = 	$this->post('companionclicktrackurl');
				$com_expanded_width 	= 	$this->post('comp_expanded_width');
				$com_expanded_height 	= 	$this->post('comp_expanded_height');
			/* Overlay Companion */			
			if($this->post('overlay_companion_size')!='')
			{
				$size 				= 	explode("x",$this->post('overlay_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				
				
				/* Overlay Companion - Upload */			
				if($this->post('tmp_overlay_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_overlay_creative_name').' Companion';
					
					if($this->user_authentication->account_type=='ADVERTISER')
					{
					  $dj_account_id=$this->user_authentication->account_id;
					}
					else
					{
					  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
					}
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_overlay_companion_creative_content_type')),
												"campaignid"		=>	clean_data($this->post('campaign')),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_overlay_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data(($destination_url!='')?$destination_url:$click_url),
												"dj_master_banner"	=>	clean_data($master_banner),
												"dj_banner_type" 	=> 	WEB_CREATIVE_WEB,
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id"		=>  clean_data($dj_account_id)
											);
											
						$companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,$is_house_ad);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_overlay_companion_creative'));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				/* Overlay Companion - Selection */			
				else
				{
					$companion_id	=	$this->post('vast_companion_id');
					
					if($companion_id !='')
					{
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					
					}else
					{$companion_id	=	$this->post('vast_companion_id');
						
					}
				}
			}
			else
			{
				$companion_id	=	0;
			}				
			
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$ovl_delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	$click_url,
									'vast_overlay_height' 			=> 	$ovl_height,
									'vast_overlay_width' 			=> 	$ovl_width,
									'vast_overlay_text_title' 		=> 	$txt_title,
									'vast_overlay_text_description' => 	$txt_description,
									'vast_overlay_text_call' 		=> 	$txt_action,
									'vast_overlay_format' 			=>	$ovl_type,
									'vast_overlay_action' 			=> 	$ovl_action,
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	$creative_type,
									'vast_thirdparty_impression' 	=> 	'',
									'vast_overlay_expanded_width'			=>	$expanded_width,
									'vast_overlay_expanded_height'			=> 	$expanded_height,
									'vast_overlay_expandedminduration'		=>	$min_suggested_duration,
									'vast_thirdparty_companion_clicktracking'=>	clean_data($companionclicktrackurl),
									'vast_thirdparty_companion_expandedwidth'		=>	clean_data($com_expanded_width),
									'vast_thirdparty_companion_expandedheight'		=>	clean_data($com_expanded_height),
									'vast_overlay_version' => clean_data($vast_overlay_version),
									//vpaid jayshree
									'is_vpaid'	=> clean_data($vpaid_enable),
									'vpaid_url'	=> clean_data($vpaid_api_url),
									'vpaid_type'	=> clean_data($vpaid_type),
									'vpaid_expanded'=> clean_data($vpaid_expand),
									'vpaid_width'	=> clean_data($vpaid_expand_width),
									'vpaid_height'	=> clean_data($vpaid_expand_height),
									'adbreak_tag1'	=> clean_data($adbreak1_tag),
									'adbreak_tag2'	=> clean_data($adbreak2_tag),
									'adbreak_tag3'	=> clean_data($adbreak3_tag),
									'adbreak_tag4'	=> clean_data($adbreak4_tag),
									'adbreak_tag5'	=> clean_data($adbreak5_tag),
									'vmap_overlay_count'	=> clean_data($overlay_vmap_count),
									'vmap_offset_adbreak1'	=> clean_data($vmap_adbreak1_offset),
									'vmap_offset_adbreak2'	=> clean_data($vmap_adbreak2_offset),
									'vmap_offset_adbreak3'	=> clean_data($vmap_adbreak3_offset),
									'vmap_offset_adbreak4'	=> clean_data($vmap_adbreak4_offset),
									'vmap_offset_adbreak5'	=> clean_data($vmap_adbreak5_offset),
									'vast_overlay_wrapper' => clean_data($thirdparty_vast_tag)
								);
						
			$parameters 	= serialize($aVastVariables);
			
			/* dj_admin_approve added on dec-2 */
			$dj_admin_approve = $this->post('dj_admin_approve');
			if($dj_admin_approve == -1)
			{
				$creative_data 	= array(
										"contenttype"		=>	clean_data($creative_type),
										 "campaignid" => clean_data($this->post('campaign')),
										"description"		=>	clean_data($this->post('video_overlay_creative_name')),
										"filename"			=>	clean_data($file_name),
										"parameters"		=>	$parameters,
										"url"				=>	clean_data($destination_url),
										"htmlcache"			=>	$htmlcache,
										"updated"			=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_admin_approve"  =>  clean_data(0)							
									);
			}else
			{
				$creative_data 	= array(
										"contenttype"		=>	clean_data($creative_type),
										 "campaignid" => clean_data($this->post('campaign')),
										"description"		=>	clean_data($this->post('video_overlay_creative_name')),
										"filename"			=>	clean_data($file_name),
										"parameters"		=>	$parameters,
										"url"				=>	clean_data($destination_url),
										"htmlcache"			=>	$htmlcache,
										"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
									);				
			}
			
			//Call to add a creative
			$updated		=	$this->Do_video_creative->update_video($creative_data,$creative_id,FALSE,$is_house_ad);		
			
			// added for edited creative status update
			//29-06-2017
			//$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			//~ }						
				$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
				$link_type=$this->default_configurations->get('linking_type');
				
				if($link_type !='manual linking')
				{
					$this->Do_auto_link->link_adblocks($creative_id,$agency_id,$this->post('campaign'));
				}
				//echo $is_house_ad;exit;
				if($is_house_ad == 1)
				{
					
					$this->Do_auto_link->link_adblocks($creative_id,$agency_id,$this->post('campaign'));
				}
			 //$this->Do_auto_link->link_adblocks($creative_id);
			
				
			if($updated)	
			{			
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$ovl_delivery,
										"vast_video_type"				=>	$video_type,							
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	$ovl_height,
										"vast_overlay_width"			=>	$ovl_width,
										"vast_video_clickthrough_url"	=>	$click_url,
										"vast_overlay_action"			=>	$ovl_action,
										"vast_overlay_format"			=>	$ovl_type,
										"vast_overlay_text_title"		=>	$txt_title,
										"vast_overlay_text_description"	=>	$txt_description,
										"vast_overlay_text_call"		=>	$txt_action,
										"vast_creative_type"			=>	$creative_type,
										"vast_overlay_expanded_width"			=>	$expanded_width,
										"vast_overlay_expanded_height"			=> 	$expanded_height,
										"vast_overlay_expandedminduration"		=>	$min_suggested_duration,
										"vast_thirdparty_companion_clicktracking"=>	clean_data($companionclicktrackurl),
										"vast_thirdparty_companion_expandedwidth"		=>	clean_data($com_expanded_width),
										"vast_thirdparty_companion_expandedheight"		=>	clean_data($com_expanded_height),
										"vast_thirdparty_clicktracking"		=>	clean_data($clicktrackurl),
										"vast_thirdparty_clickcustom"=>	clean_data($clicktrackcustomurl),
										"vast_overlay_version" => clean_data($vast_overlay_version),
										//vpaid jayshree
										"is_vpaid"	=> clean_data($vpaid_enable),
										"vpaid_url"	=> clean_data($vpaid_api_url),
										"vpaid_type"	=> clean_data($vpaid_type),
										"vpaid_expanded"=> clean_data($vpaid_expand),
										"vpaid_width"	=> clean_data($vpaid_expand_width),
										"vpaid_height"	=> clean_data($vpaid_expand_height),
										"adbreak_tag1"	=> clean_data($adbreak1_tag),
										"adbreak_tag2"	=> clean_data($adbreak2_tag),
										"adbreak_tag3"	=> clean_data($adbreak3_tag),
										"adbreak_tag4"	=> clean_data($adbreak4_tag),
										"adbreak_tag5"	=> clean_data($adbreak5_tag),
										"vmap_overlay_count"	=> clean_data($overlay_vmap_count),
										"vmap_offset_adbreak1"	=> clean_data($vmap_adbreak1_offset),
										"vmap_offset_adbreak2"	=> clean_data($vmap_adbreak2_offset),
										"vmap_offset_adbreak3"	=> clean_data($vmap_adbreak3_offset),
										"vmap_offset_adbreak4"	=> clean_data($vmap_adbreak4_offset),
										"vmap_offset_adbreak5"	=> clean_data($vmap_adbreak5_offset),
									    "vast_overlay_wrapper" => clean_data($thirdparty_vast_tag)
									);
									
				$vast_update	=	$this->Do_video_creative->update_video_vast($vast_data,$creative_id);
				
			// added for edited creative status update
			//29-06-2017
			//$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			//~ }						
					$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
				if($vast_update)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('ctv_succ_updated'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
					$this->response( $success, 200);
					
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> $this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}

	/*
	 * 
	 * name: creative_to_tmp_location
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected video creative to a temporary location
	 * 
	 */
	public function creative_to_tmp_location_post()
	{
		if($_FILES['creative'])
		{
			$creative=array(
					'file_name'   	=> 	$_FILES['creative']['name'],
					'tmp_name' 		=> 	$_FILES['creative']['tmp_name'], 
					);
					
			$tmp_creative=$this->image_lib->move_creative_to_tmp_location($creative);

			if($tmp_creative)
			{
				$success = array(
								'response' 	=> 	$tmp_creative['upload_data'],
								'msg'	 	=> 	$this->lang->line('moved_temporary_location')
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('advertiser/creative/add_web_creative'),
								'msg'		=> 	$this->lang->line('unabale_move_temporary_location')
				);
				$this->response($error, 200);
			}
		}
		
	}
	
	/*
	 * 
	 * name: creative_video_to_tmp_location
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected video creative video to a temporary location
	 * 
	 */
	public function creative_video_to_tmp_location_post()
	{
		if($_FILES['creative'])
		{
			$creative=array(
					'file_name'  	=> 	$_FILES['creative']['name'],
					'tmp_name' 		=> 	$_FILES['creative']['tmp_name'], 
					);
					
			$tmp_creative=$this->image_lib->move_video_creative_to_tmp_location($creative);
			
			if($tmp_creative)
			{
				$success = array(
								'response' 	=> 	$tmp_creative['upload_data'],
								'msg'	 	=> 	$this->lang->line('moved_temporary_location')
				);
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
							$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('advertiser/creative/add_web_creative'),
								'msg'	 	=> 	$this->lang->line('unabale_move_temporary_location')			
								);
							$this->response($error, 200);
				}
				else
				{
						$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('admin/creative/add_web_creative'),
								'msg'	 	=> 	$this->lang->line('unabale_move_temporary_location')			
								);
							$this->response($error, 200);
				}
			}
		}
		
	}
	
	/*
	 * 
	 * name: creative_swf_to_tmp_location
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected video creative video to a temporary location
	 * 
	 */
	public function creative_swf_to_tmp_location_post()
	{
		if($_FILES['creative'])
		{
			$creative=array(
					'file_name'  	=> 	$_FILES['creative']['name'],
					'tmp_name' 		=> 	$_FILES['creative']['tmp_name'], 
					);
					
			$tmp_creative=$this->image_lib->move_swf_creative_to_tmp_location($creative);

			if($tmp_creative)
			{
				$success = array(
								'response' 	=> 	$tmp_creative['upload_data'],
								'msg'	 	=> 	$this->lang->line('moved_temporary_location')
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('advertiser/creative/add_web_creative'),
								'msg'	 	=> 	$this->lang->line('unabale_move_temporary_location')
				);
				$this->response($error, 200);
			}
		}
		
	}
	
	/*
	 * 
	 * name: delete_a_creative
	 * @param :
	 * @return :response array
	 * 
	 * Delete the video creative in its original location
	 */
	
	public function delete_a_creative_post()
	{
		$tmp_creative_name	=	$this->post('creative_name');
		
		if($tmp_creative_name)
		{
			$is_tmp_creative=$this->image_lib->delete_creative_in_original_location($tmp_creative_name);

			if($is_tmp_creative)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => $this->lang->line('temporary_creative_deleted')
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_temporary_creative_file')
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_temporary_creative_file')
							);
			$this->response($error, 200);
		}
	}
	/*
	 * 
	 * name: delete_a_tmp_creative
	 * @param :
	 * @return :response array
	 * 
	 * Delete the video creative in temporary location
	 */
	
	public function delete_a_tmp_creative_post()
	{
		$tmp_creative_name	=	$this->post('creative_name');
		if($tmp_creative_name)
		{
			$is_tmp_creative	=	$this->image_lib->delete_creative_in_tmp_location($tmp_creative_name);

			if($is_tmp_creative)
			{
				$success = array(
							'response' 	=> 'success',
							'msg'	 	=> $this->lang->line('temporary_creative_deleted')
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' 	=> 'error',
							'msg'	 	=> $this->lang->line('unable_delete_temporary_creative_file')
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' 	=> 'error',
							'msg'	 	=> $this->lang->line('unable_delete_temporary_creative_file')
							);
			$this->response($error, 200);
		}
	}
	
	/*
	 * 
	 * name: check_companion_size
	 * @param :
	 * @return :response array
	 * 
	 * Delete the creative in temporary location
	 */
	
	public function check_companion_size_post()
	{
		$campaign_id	=	$this->post('campaign_id');
		$width			=	$this->post('companion_width');
		$height			=	$this->post('companion_height');
		if($width && $height)
		{
			$companion			=	$this->Do_video_creative->check_companion_size($campaign_id,$width,$height);
			if($companion)
			{
				$success = array(
							'response' 	=> 'ok',
							'msg'	 	=> $this->lang->line('ctv_select_comp_size')
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' 	=> 'error',
							'msg'	 	=> $this->lang->line('ctv_not_comp_size')
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' 	=> 'error',
							'msg'	 	=> $this->lang->line('un_ava_comp')
							);
			$this->response($error, 200);
		}
	}
	
	/*
	 * 
	 * name: filter_companions
	 * @param
	 * @return:response array
	 * 
	 * In this method we will filter all COMPANION CREATIVE
	 */
	
	public function filter_companions_get()
	{
		$campaign_id=	$this->get('campaign_id');
		$width		=	$this->get('width');
		$height		=	$this->get('height');
		if($width && $height)
		{
			$companion	=	$this->Do_video_creative->check_companion_size($campaign_id,$width,$height);
			if($companion)
			{	
				$this->response($companion, 200);
			}
			else
			{
				$error = array('error'	=> $this->lang->line('ctv_not_comp_size'));
				$this->response($error, 200);
			}
		}
	
	}
	
	/*
	 * 
	 * name: fetch_companion_details
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage COMPANION CREATIVE details
	 */
	
	public function fetch_companion_details_get()
	{	
		$companion_id	=	$this->get('companion_id');
		
		if($companion_id)
		{
			$companion		=	$this->Do_video_creative->fetch_video($companion_id);	
			
			if($companion)
			{	
				$this->response( $companion, 200);
			}
			else
			{
				$error 		= 	array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('crtv_not_exist')
								);
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: convertToFlv
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage VIDEO CREATIVE details in ffmpeg
	 */
	
	function convertToFlv($input,$output,$raw_name,$upload_path,$ext)
	{
		$time		=	time();
		##CONVERT VIDEO	
		
		//$command = "ffmpeg -i $input -ar 44100 -r 12 $output";
		$command 	= 	"ffmpeg -i $input -vcodec flv -qscale 3 -ar 44100 -f flv $output";
		##FETCH TOTAL TIME

		$time 					=  	shell_exec("ffmpeg -i $input 2>&1 | grep 'Duration' | cut -d ' ' -f 4 | sed s/,//");   
		$duration 				= 	explode(":",$time);   
		$duration_in_seconds 	= 	$duration[0]*3600 + $duration[1]*60+ round($duration[2]);   
		$duration_in_seconds	=	round($duration_in_seconds);
		$time_for_thumb_one		=	0;
		$time_for_thumb_two		=	$duration_in_seconds/2;
		$time_for_thumb_three	=	$duration_in_seconds-1;
		
		##CREATE THUMBNAILS	
		$thumb_230X150_command1 = "ffmpeg  -itsoffset -$time_for_thumb_one  -i $input -vcodec mjpeg -vframes 1 -an -f rawvideo -s 230X150 ".$upload_path.$raw_name."-230X150-1.jpg";
		
		$thumb_230X150_command2 = "ffmpeg  -itsoffset -$time_for_thumb_two  -i $input -vcodec mjpeg -vframes 1 -an -f rawvideo -s 230X150 ".$upload_path.$raw_name."-230X150-2.jpg";
		
		$thumb_230X150_command3 = "ffmpeg  -itsoffset -$time_for_thumb_three  -i $input -vcodec mjpeg -vframes 1 -an -f rawvideo -s 230X150 ".$upload_path.$raw_name."-230X150-3.jpg";
		
		$thumb_486X412_command1 = "ffmpeg  -itsoffset -$time_for_thumb_one  -i $input -vcodec mjpeg -vframes 1 -an -f rawvideo -s 486X412 ".$upload_path.$raw_name."-486X412-1.jpg";
		
		$thumb_486X412_command2 = "ffmpeg  -itsoffset -$time_for_thumb_two  -i $input -vcodec mjpeg -vframes 1 -an -f rawvideo -s 486X412 ".$upload_path.$raw_name."-486X412-2.jpg";
		
		$thumb_486X412_command3 = "ffmpeg  -itsoffset -$time_for_thumb_three  -i $input -vcodec mjpeg -vframes 1 -an -f rawvideo -s 486X412 ".$upload_path.$raw_name."-486X412-3.jpg";

		
		##EXECUTE SHELL COMMANDS
		shell_exec($command);
		shell_exec( $thumb_230X150_command1 );
		shell_exec( $thumb_230X150_command2 );
		shell_exec( $thumb_230X150_command3 );
		
		shell_exec( $thumb_486X412_command1 );
		shell_exec( $thumb_486X412_command2 );
		shell_exec( $thumb_486X412_command3 );
		
		return $duration_in_seconds;
	}
	
	/* FFMPEG EXIST OR NOT */
	public function commandExists($command) 
	{
		$command = escapeshellarg($command);
		$exists = exec("man ".$command,$out);
		return sizeof($out);
	}
	
	 	/*
	 * 
	 * name: add_video_inline_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all INLINE VIDEO CREATIVE add process	 
	 */
	public function add_video_html5_creative_post()
	{
		$delivery	=	$this->post('html5_delivery_method');		
		
		$this->form_validation->set_rules('video_html5_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('html5_delivery_method', 'lang:del_type', 'required|trim');		
		$this->form_validation->set_rules('html5_url', 'lang:destination_url', 'required|trim|url');
		$campaign = $this->post('_vhtml5_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_vhtml5_campaign_id');
		}
		
		/***  
		if($delivery=='streaming')
		{
			$this->form_validation->set_rules('html5_rtmpurl', 'lang:rtmp_url', 'required|trim|url');
			$this->form_validation->set_rules('html5_rtmp_filename', 'lang:rtmp_file_name', 'required|trim');
			$this->form_validation->set_rules('html5_rtmp_duration', 'lang:rtmp_video_duration', 'required|trim');
		}
		***/
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			$bannertype		=	VIDEO_CREATIVE_HTML5;			
			$storagetype	=	'html';
			$width			=	'-3';
			$height			=	'-3';
			$ext_bannertype = 	"bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml";

			//Get account/agency_id from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			
			$agency_id=$this->user_authentication->agency_id;
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
			
			if($delivery=='progressive')
			{	
				if($this->post('tmp_video_html5_creative')!='')
				{	
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
						$input  			= 	$this->post('tmp_video_html5_creative');
						$output 			= 	$this->post('tmp_video_html5_creative_raw_name').'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	$this->post('tmp_video_html5_creative_raw_name');

						$ext				=	$this->post('tmp_video_html5_creative_file_ext');

						$input_with_path  	= 	$upload_path.$this->post('tmp_video_html5_creative');
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_html5_creative'));
							
					$video_name			=	$this->post('tmp_video_html5_creative');
if($this->post('tmp_video_html5_creative_content_type')=='video/mp4' || $this->post('tmp_video_html5_creative_content_type')=='mp4')
					{
						$video_type		=	'mp4';
					}
else if($this->post('tmp_video_html5_creative_content_type')=='video/webm' || $this->post('tmp_video_html5_creative_content_type')=='webm')
					{
						$video_type		=	'webm';
					}
else if($this->post('tmp_video_html5_creative_content_type')=='video/ogg' || $this->post('tmp_video_html5_creative_content_type')=='ogg')
					{
						$video_type		=	'ogg';
					}
					else
					{
						$video_type		=	$this->post('tmp_video_html5_creative_content_type');
					}
					
					$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_html5_creative');					
					
				}
			}
			/****
			elseif($delivery=='streaming')
			{	
				$video_name			=	'';				
				$video_duration		=	$this->post('html5_rtmp_duration');
				$rtmp_url			=	$this->post('html5_rtmpurl');
				$rtmp_filename		=	$this->post('html5_rtmp_filename');
				if(strpos($rtmp_filename, '.') != false)
				{
					$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
				}
				else
				{
					$type			=	'flv';
				}
				$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
				$video_type			=	'video/x-'.$type;
				
			}
			******/
			
			if($this->post('html5_companion_size')!='')
			{
				$size 				= 	explode("x",$this->post('html5_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				if($this->post('tmp_html5_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_html5_creative_name').' Companion';
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_html5_companion_creative_content_type')),
												"campaignid"		=>	clean_data($campaign_id),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_html5_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data($this->post('html5_url')),
												"dj_master_banner"	=>	clean_data($master_banner),
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_banner_type" 	=> 	WEB_CREATIVE_WEB,
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id" 	=> 	clean_data($dj_account_id)
											);
											
						$companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,
						FALSE,$is_house_ad);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_html5_companion_creative'));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				else
				{
					$companion_id	=	$this->post('vast_companion_id');
				}
			}
			else
			{
				$companion_id	=	0;
			}				
			
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	$this->post('html5_url'),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	''
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$creative_data 	= array(												
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_html5_creative_name')),
									"filename"			=>	clean_data($video_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('html5_url')),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id)
								);
			//Call to add a creative
			$creative_id	=	$this->Do_video_creative->add_video($creative_data,$agency_id,$is_house_ad);
			
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('html5_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL	
									);
									
				$vast_add	=	$this->Do_video_creative->add_video_vast($vast_data);
				
				if($vast_add)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);
					$this->response( $success, 200);
					
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}
	
		 /*
	 * 
	 * name: edit_video_html5_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all html5 VIDEO CREATIVE add process	 
	 */
	
	public function edit_video_html5_creative_post()
	{
		$creative_id	=	$this->post('creative_id');
		
		$delivery		=	$this->post('html5_delivery_method');
		$this->form_validation->set_rules('video_html5_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('html5_delivery_method', 'lang:del_type', 'required|trim');		
		$this->form_validation->set_rules('html5_url', 'lang:destination_url', 'required|trim|url');
		
		/***
		if($delivery=='streaming')
		{
			$this->form_validation->set_rules('html5_rtmpurl', 'lang:rtmp_url', 'required|trim|url');
			$this->form_validation->set_rules('html5_rtmp_filename', 'RTMP File Name', 'required|trim');
			$this->form_validation->set_rules('html5_rtmp_duration', 'lang:rtmp_video_duration', 'required|trim');
		}
		 
		* ***/
		 if($delivery=='progressive')
		{
			if($this->post('tmp_video_html5')=='')
			{
				$this->form_validation->set_rules('video_html5_creative', 'lang:video_file', 'required|trim');
			}
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			
			$video_data			=	$this->Do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->Do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
			if($delivery=='progressive')
			{	
				if($this->post('tmp_video_html5_creative')!='')
				{	
					if($vast['vast_video_delivery']=='progressive')
					{	
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
					}
					
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	$this->post('tmp_video_html5_creative');
						$output 			= 	$this->post('tmp_video_html5_creative_raw_name').'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	$this->post('tmp_video_html5_creative_raw_name');

						$ext				=	$this->post('tmp_video_html5_creative_file_ext');

						$input_with_path  	= 	$upload_path.$this->post('tmp_video_html5_creative');
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_html5_creative'));
					
					$video_name			=	$this->post('tmp_video_html5_creative');
	if($this->post('tmp_video_html5_creative_content_type')=='video/mp4' || $this->post('tmp_video_html5_creative_content_type')=='.mp4')
					{
						$video_type		=	'mp4';
					}
else if($this->post('tmp_video_html5_creative_content_type')=='video/webm' || $this->post('tmp_video_html5_creative_content_type')=='.webm' || $this->post('tmp_video_html5_creative_file_ext')=='.webm' || $this->post('tmp_video_html5_creative_file_ext')=='webm')
					{
						$video_type		=	'webm';
					}
else if($this->post('tmp_video_html5_creative_content_type')=='video/ogg' || $this->post('tmp_video_html5_creative_content_type')=='.ogg' || $this->post('tmp_video_html5_creative_file_ext')=='.ogg' || $this->post('tmp_video_html5_creative_file_ext')=='ogg')
					{
						$video_type		=	'ogg';
					}
					else
					{
						$video_type		=	$this->post('tmp_video_html5_creative_content_type');
					}
					$video_duration		=	'30';	
					$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_html5_creative');					
					
				}
				else
				{
					$video_name			=	$video['filename'];
					$video_type			=	$vast['vast_video_type'];
					
					$video_duration		=	$vast['vast_video_duration'];	
					$outgoing_filename	=	$vast['vast_video_outgoing_filename'];	
				}
			}
		
			
			
		$companion_id	=	0;
			
			
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	$this->post('html5_url'),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	''
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$creative_data 	= array(
			"url"		=>	clean_data($this->post('html5_url')),
									"description"		=>	clean_data($this->post('video_html5_creative_name')),
									"filename"			=>	clean_data($video_name),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),	
								);
			
			//Get agencyid from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to update a creative
			$updated		=	$this->Do_video_creative->update_video($creative_data,$creative_id,$agency_id,$is_house_ad);
			
			if($updated)
			{					
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,									
										"vast_video_clickthrough_url"	=>	clean_data($this->post('html5_url'))									
									);
									
				$vast_update	=	$this->Do_video_creative->update_video_vast($vast_data,$creative_id);
				
				if($vast_update)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$video_type,
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
					$this->response( $success, 200);
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}
	
		 /*
	 * 
	 * name: add_text_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage HTML creative adding process
	 */
	public function add_video_thirdparty_creative_post()
	{
		$this->form_validation->set_rules('video_thirdparty_creative_name','lang:creative_name', 'required|trim');
		//$this->form_validation->set_rules('adtag', 'Ad Tag', 'required|trim');
		$campaign = $this->post('_vtp_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_vtp_campaign_id');
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type="html";
			$bannertype=VIDEO_CREATIVE_THIRDPARTY;
			//Get account/clientid from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			$agency_id=$this->user_authentication->agency_id;
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}			

           $aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	'',
									'vast_video_delivery'			=> 	'',
									'vast_video_type' 				=> 	'',
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	'',
									'vast_video_clickthrough_url' 	=> 	$this->post('inline_url'),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	'',
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	''
								);
						
			$parameters 	= serialize($aVastVariables);

	        $ext_bannertype = 	"bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml";
	
			$creative_data = array(
						"contenttype"=>clean_data($storage_type),
						"width"=>"-4",
						"height"=>"-4",
						"campaignid"=>clean_data($campaign_id),
						"storagetype"=>clean_data($storage_type),
						"description"=>clean_data($this->post('video_thirdparty_creative_name')),
						"vast_tag"=>$this->post('adtag'),
						"ext_bannertype"	=>	clean_data($ext_bannertype),
						"parameters"		=>	$parameters,
						"dj_admin_approve"=>clean_data($dj_admin_approve),
						"dj_approved_date"=>clean_data($dj_approved_date),						
						"dj_banner_type"=>clean_data($bannertype),
						"dj_added_date"=>clean_data(date('Y:m:d :H:i:s')),
						"dj_account_id" => clean_data($dj_account_id)
					);
			//Call to add a creative
			$blob_data=FALSE;
			//calling Do_web_creative model for saving html5 video tag
			$creative_id=$this->Do_web_creative->add($creative_data,$blob_data,$agency_id);
			
			
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	'',
										"vast_video_delivery"			=>	'',
										"vast_video_type"				=>	'',
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	'',
										"vast_companion_banner_id"		=>	'',
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	NULL,
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL	
									);
									
				$vast_add	=	$this->Do_video_creative->add_video_vast($vast_data);
		
		  }
			if($vast_add)
			{
				$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('mobile_creative_added'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);
				$this->response( $success, 200);
				
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}		

		}
	}
	
public function edit_xml_creative_post()
	{
		$this->form_validation->set_rules('pop_creative_name','lang:creative_name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'lang:destination_url', 'required|trim|url');
		$this->form_validation->set_rules('xml_url', 'lang:xml_path', 'required|trim|url');
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id	=	$this->post('web_creative_id');
			
			$storage_type	=	"txt";
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$creative_data 	= 	array(
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('pop_creative_name')),
									"xml_path"		=>	clean_data($this->post('xml_url')),
									"url"				=>	clean_data($this->post('destination_url')),
									"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
								);
			
			//Call to edit a creative
			$creative_edit	=	$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id);

			if($creative_edit)
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	=> 	site_url('advertiser/creatives/'),
								);
				}
				else
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('error_try_again'),
									'redirect'	=> 	site_url('admin/creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	$this->lang->line('error_try_again'),
										'redirect'	=> 	site_url('advertiser/creatives/'),
									);	
				}
				else
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	$this->lang->line('error_try_again'),
										'redirect'	=> 	site_url('admin/creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	public function edit_video_thirdparty_creative_post()
	{ 
	
		$this->form_validation->set_rules('video_thirdparty_creative_name','lang:creative_name', 'required|trim');
	
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id	=	$this->post('creative_id');
			
			$storage_type	=	"html";
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$creative_data 	= 	array(
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('video_thirdparty_creative_name')),
									"vast_tag"		=>	$this->post('adtag'),
									"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
								);
			
			//Call to edit a creative
			$creative_edit	=	$this->Do_web_creative->edit($creative_data,$creative_id,$agency_id);

			if($creative_edit)
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	=> 	site_url('advertiser/creatives/'),
								);
				}
				else
				{
					$success = 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	=> 	site_url('admin/creatives/'),
								);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type === "ADVERTISER")
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	$this->lang->line('error_try_again'),
										'redirect'	=> 	site_url('advertiser/creatives/'),
									);	
				}
				else
				{
					$error 	= 	array(
										'response' 	=> 	'error',
										'msg'	 	=> 	$this->lang->line('error_try_again'),
										'redirect'	=> 	site_url('admin/creatives/'),
									);	
				}
				$this->response( $error, 200);
			}
		}
	} 
	



	 	/*
	 * 
	 * name: add_video_inbanner_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all INLINE VIDEO CREATIVE add process	 
	 */
	public function add_video_inbanner_creative_post()
	{
		$delivery	=	$this->post('inbanner_delivery_method');		
		
		$this->form_validation->set_rules('video_inbanner_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('inbanner_delivery_method', 'lang:del_type', 'required|trim');		
		//$this->form_validation->set_rules('inbanner_url', 'lang:destination_url', 'required|trim|url');
		$campaign = $this->post('_vinbanner_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_vinbanner_campaign_id');
		}
		
	
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			$bannertype		=	VIDEO_CREATIVE_INBANNER;			
			$storagetype	=	'html';
			$width			=	'-5';
			$height			=	'-5';
			$ext_bannertype = 	"bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml";

			//Get account/agency_id from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			
			$agency_id=$this->user_authentication->agency_id;
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
			
			if($delivery=='progressive')
			{	
				if($this->post('tmp_video_inbanner_creative')!='')
				{	
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
						$input  			= 	$this->post('tmp_video_inbanner_creative');
						$output 			= 	$this->post('tmp_video_inbanner_creative_raw_name').'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	$this->post('tmp_video_inbanner_creative_raw_name');

						$ext				=	$this->post('tmp_video_inbanner_creative_file_ext');

						$input_with_path  	= 	$upload_path.$this->post('tmp_video_inbanner_creative');
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_inbanner_creative'));
							
					$video_name			=	$this->post('tmp_video_inbanner_creative');
if($this->post('tmp_video_inbanner_creative_content_type')=='video/mp4' || $this->post('tmp_video_inbanner_creative_content_type')=='mp4')
					{
						$video_type		=	'mp4';
					}
else if($this->post('tmp_video_inbanner_creative_content_type')=='video/flv' || $this->post('tmp_video_inbanner_creative_content_type')=='flv')
					{
						$video_type		=	'flv';
					}
else if($this->post('tmp_video_inbanner_creative_content_type')=='video/webm' || $this->post('tmp_video_inbanner_creative_content_type')=='webm')
					{
						$video_type		=	'webm';
					}
else if($this->post('tmp_video_inbanner_creative_content_type')=='video/ogg' || $this->post('tmp_video_inbanner_creative_content_type')=='ogg')
					{
						$video_type		=	'ogg';
					}
					else
					{
						$video_type		=	$this->post('tmp_video_inbanner_creative_content_type');
					}
					
					$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_inbanner_creative');					
					
				}
			}
			/****
			elseif($delivery=='streaming')
			{	
				$video_name			=	'';				
				$video_duration		=	$this->post('inbanner_rtmp_duration');
				$rtmp_url			=	$this->post('inbanner_rtmpurl');
				$rtmp_filename		=	$this->post('inbanner_rtmp_filename');
				if(strpos($rtmp_filename, '.') != false)
				{
					$type			=	substr($rtmp_filename, strrpos($rtmp_filename, '.')+1);
				}
				else
				{
					$type			=	'flv';
				}
				$outgoing_filename	=	$rtmp_url.$type.':'.$rtmp_filename;
				$video_type			=	'video/x-'.$type;
				
			}
			******/
			
			if($this->post('inbanner_companion_size')!='')
			{
				$size 				= 	explode("x",$this->post('inbanner_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				if($this->post('tmp_inbanner_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_inbanner_creative_name').' Companion';
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_inbanner_companion_creative_content_type')),
												"campaignid"		=>	clean_data($campaign_id),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_inbanner_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data($this->post('inbanner_url')),
												"dj_master_banner"	=>	clean_data($master_banner),
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_banner_type" 	=> 	WEB_CREATIVE_WEB,
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id" 	=> 	clean_data($dj_account_id)
											);
											
						$companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,FALSE,$is_house_ad);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_inbanner_companion_creative'));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				else
				{
					$companion_id	=	$this->post('vast_companion_id');
				}
			}
			else
			{
				$companion_id	=	0;
			}				
			
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	$this->post('inbanner_url'),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	''
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$creative_data 	= array(												
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_inbanner_creative_name')),
									"filename"			=>	clean_data($video_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('inbanner_url')),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id)
								);
			//Call to add a creative
			$creative_id	=	$this->Do_video_creative->add_video($creative_data,$agency_id,$is_house_ad);
			
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('inbanner_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL	
									);
									
				$vast_add	=	$this->Do_video_creative->add_video_vast($vast_data);
				
				if($vast_add)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);
					$this->response( $success, 200);
					
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}



		 /*
	 * 
	 * name: edit_video_inbanner_creative
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage all inbanner VIDEO CREATIVE add process	 
	 */
	
	public function edit_video_inbanner_creative_post()
	{
		$creative_id	=	$this->post('creative_id');
		
		$delivery		=	$this->post('inbanner_delivery_method');
		$this->form_validation->set_rules('video_inbanner_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('inbanner_delivery_method', 'lang:del_type', 'required|trim');		
	//	$this->form_validation->set_rules('inbanner_url', 'lang:destination_url', 'required|trim|url');
		
		/***
		if($delivery=='streaming')
		{
			$this->form_validation->set_rules('inbanner_rtmpurl', 'lang:rtmp_url', 'required|trim|url');
			$this->form_validation->set_rules('inbanner_rtmp_filename', 'lang:rtmp_file_name', 'required|trim');
			$this->form_validation->set_rules('inbanner_rtmp_duration', 'lang:rtmp_video_duration', 'required|trim');
		}
		 
		* ***/
		 if($delivery=='progressive')
		{
			if($this->post('tmp_video_inbanner')=='')
			{
				$this->form_validation->set_rules('video_inbanner_creative', 'lang:video_file', 'required|trim');
			}
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'0';
			
			$video_data			=	$this->Do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->Do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
			if($delivery=='progressive')
			{	
				if($this->post('tmp_video_inbanner_creative')!='')
				{	
					if($vast['vast_video_delivery']=='progressive')
					{	
						$is_old_creative_deleted=	$this->image_lib->delete_creative_in_original_location($video['filename']);
					}
					
					if($this->commandExists("ffmpeg")>0) 
					{
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	$this->post('tmp_video_inbanner_creative');
						$output 			= 	$this->post('tmp_video_inbanner_creative_raw_name').'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	$this->post('tmp_video_inbanner_creative_raw_name');

						$ext				=	$this->post('tmp_video_inbanner_creative_file_ext');

						$input_with_path  	= 	$upload_path.$this->post('tmp_video_inbanner_creative');
						$output_with_path 	= 	$upload_path.$output;
						
						#$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						$video_duration		=	'30';	
					}
					else 
					{
						$video_duration		=	'30';	
					}
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_inbanner_creative'));
					
					$video_name			=	$this->post('tmp_video_inbanner_creative');
	if($this->post('tmp_video_inbanner_creative_content_type')=='video/mp4' || $this->post('tmp_video_inbanner_creative_content_type')=='.mp4')
					{
						$video_type		=	'mp4';
					}
else if($this->post('tmp_video_inbanner_creative_content_type')=='video/webm' || $this->post('tmp_video_inbanner_creative_content_type')=='.webm' || $this->post('tmp_video_inbanner_creative_file_ext')=='.webm' || $this->post('tmp_video_inbanner_creative_file_ext')=='webm')
					{
						$video_type		=	'webm';
					}
else if($this->post('tmp_video_inbanner_creative_content_type')=='video/flv' || $this->post('tmp_video_inbanner_creative_content_type')=='.flv' || $this->post('tmp_video_inbanner_creative_file_ext')=='.flv' || $this->post('tmp_video_inbanner_creative_file_ext')=='flv')
					{
						$video_type		=	'flv';
					}
else if($this->post('tmp_video_inbanner_creative_content_type')=='video/ogg' || $this->post('tmp_video_inbanner_creative_content_type')=='.ogg' || $this->post('tmp_video_inbanner_creative_file_ext')=='.ogg' || $this->post('tmp_video_inbanner_creative_file_ext')=='ogg')
					{
						$video_type		=	'ogg';
					}
					else
					{
						$video_type		=	$this->post('tmp_video_inbanner_creative_content_type');
					}
					$video_duration		=	'30';	
					$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_inbanner_creative');					
					
				}
				else
				{
					$video_name			=	$video['filename'];
					$video_type			=	$vast['vast_video_type'];
					
					$video_duration		=	$vast['vast_video_duration'];	
					$outgoing_filename	=	$vast['vast_video_outgoing_filename'];	
				}
			}
		
			
			
		$companion_id	=	0;
			
			
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
									'vast_video_clickthrough_url' 	=> 	$this->post('inbanner_url'),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	$companion_id,
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	''
								);
						
			$parameters 	= serialize($aVastVariables);
			
			$creative_data 	= array(
			"url"		=>	clean_data($this->post('inbanner_url')),
									"description"		=>	clean_data($this->post('video_inbanner_creative_name')),
									"filename"			=>	clean_data($video_name),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),	
								);
			
			//Get agencyid from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to update a creative
			$updated		=	$this->Do_video_creative->update_video($creative_data,$creative_id,$agency_id,$is_house_ad);
			
			if($updated)
			{					
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,									
										"vast_video_clickthrough_url"	=>	clean_data($this->post('inbanner_url'))									
									);
									
				$vast_update	=	$this->Do_video_creative->update_video_vast($vast_data,$creative_id);
				
				if($vast_update)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$video_type,
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
					$this->response( $success, 200);
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}
//start
public function add_video_interstital_creative_post()
	{	
			
		//print_r($this->post());exit; 
		$this->form_validation->set_rules('video_inline_creative_name','lang:creative_name', 'required|trim');		
		if($this->post('inline_url'))
		{
			$this->form_validation->set_rules('inline_url', 'lang:Destination_URL', 'required|trim|url');
		}	
		$campaign = $this->post('_vin_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:Campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_vin_campaign_id');
		}
		
	
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'1';
			$bannertype		=	($this->post('_type') == 'mobile') ? MOBILE_VIDEO_CREATIVE_INTERSTITAL : VIDEO_CREATIVE_INTERSTITAL;				
			$storagetype	=	'html';
			$width			=	'-3';
			$height			=	'-3';
			$ext_bannertype = 	"bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml";

		
			//Get account/agency_id from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			
			$agency_id=$this->user_authentication->agency_id;
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
		      $delivery='progressive';
		  
			if($delivery=='progressive')
			{	
				
				
				if($this->post('tmp_video_inline_creative')!='')
				{
					
					$is_video_creative_moved_ffmpeg	=	$this->image_lib->move_creative_to_ffmpeg_location($this->post('tmp_video_inline_creative'));
					
					$is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_inline_creative'));
					
					if($this->commandExists("ffmpeg")>0) 
					{
					
						##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							
						$input  			= 	$this->post('tmp_video_inline_creative');
						$output 			= 	$this->post('tmp_video_inline_creative_raw_name').'.flv';
						
						$upload_path		=	$this->config->item('creative_path');
						$raw_name			=	$this->post('tmp_video_inline_creative_raw_name');

						$ext				=	$this->post('tmp_video_inline_creative_file_ext');

						$input_with_path  	= 	$upload_path.$this->post('tmp_video_inline_creative');
						$output_with_path 	= 	$upload_path.$output;
						
						$hlsStreaming = $this->HlsStreaming($this->post());
							
						$video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						//$this->response( $video_duration, 200);
						
						$video_duration		=	!empty($video_duration) ? $video_duration : 30;	
					}
					else 
					{
						$video_duration		=	'30';	
					}
							
					$video_name			=	$this->post('tmp_video_inline_creative');
					if($this->post('tmp_video_inline_creative_content_type')=='video/mp4')
					{
						$video_type		=	'video/x-mp4';
					}
					else
					{
						$video_type		=	$this->post('tmp_video_inline_creative_content_type');
					}
					
					$toCheckExist = $this->config->item('creative_path').$this->post('tmp_video_inline_creative_raw_name')."/playlist.m3u8";
					$headers=get_headers($toCheckExist);
					if(stripos($headers[0],"200 OK"))
					{
						$outgoing_filename_m3u8 = $this->config->item('creative_path').$this->post('tmp_video_inline_creative_raw_name')."/playlist.m3u8";
						$outType = "m3u8";
					}
					else
					{
						$outgoing_filename_m3u8	=	"nope";
						$outType = "nope";
					}
					
					$outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_inline_creative');					
					
				}
			}
	
			
				$companion_width 	= 	$this->post('inline_companion_width');
				$companion_height 	= 	$this->post('inline_companion_height');
				$companionclicktrackurl 	= 	$this->post('companionclicktrackurl');
				$expanded_width 	= 	$this->post('expanded_width');
				$expanded_height 	= 	$this->post('expanded_height');
				
			
			if($this->post('inline_companion_size')!='')
			{
				$size 				= 	explode("x",$this->post('inline_companion_size'));
				$companion_width 	= 	$size[0];
				$companion_height 	= 	$size[1];
				
			
				if($this->post('tmp_inline_companion_creative')!='')
				{
					$storage_type	=	'web';
					$description	=	$this->post('video_inline_creative_name').' Companion';
					
					if(isset($companion_width) AND isset($companion_height) )
					{
						$comp_creative_data = array(
												"contenttype"		=>	clean_data($this->post('tmp_inline_companion_creative_content_type')),
												"campaignid"		=>	clean_data($campaign_id),
												"storagetype"		=>	clean_data($storage_type),
												"description"		=>	clean_data($description),
												"filename"			=>	clean_data($this->post('tmp_inline_companion_creative')),
												"width"				=>	clean_data($companion_width),
												"height"			=>	clean_data($companion_height),
												"url"				=>	clean_data($this->post('inline_url')),
												"dj_master_banner"	=>	clean_data($master_banner),
												"status"			=>	clean_data($status),
												"dj_admin_approve"	=>	clean_data($dj_admin_approve),
												"dj_approved_date"	=>	clean_data($dj_approved_date),
												"dj_banner_type" 	=> 	($this->post('_type') == 'mobile') ? MOBILE_COMPANION_IMAGE_CREATIVE : WEB_CREATIVE_WEB,
												"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_account_id" 	=> 	clean_data($dj_account_id)
											);
										
						$companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,$is_house_ad);
						//On sucess move the web creative from tmp location to original location
						$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_inline_companion_creative'));
						
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					}
				}
				else
				{
					$companion_id	=	$this->post('vast_companion_id');
					if($companion_id !='')
					{
						$insert_data = array(
										'zone_id'			=>	0,
										'ad_id'				=>	$companion_id,
										'priority_factor' 	=> 	1,
										'to_be_delivered'	=>	1
										);
						$this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					
					}else
					{$companion_id	=	$this->post('vast_companion_id');
						
					}
				}
			}
			else
			{
				$companion_id	=	0;
			}				
			//vpaid jayashree			
			$vpaid_enable=$this->post('vapid_enable');
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$outgoing_filename,
										'vast_video_outgoing_filename_m3u8' 	=>	$outgoing_filename_m3u8,
									'vast_video_outgoing_streaming_type' =>	$outType, 
									'vast_video_clickthrough_url' 	=> 	$this->post('inline_url'),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	'',
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	'',
									'vast_video_skip_duration'		=>  '',
									'vast_video_skip_progress_duration'				=>  '',
									'vast_thirdparty_companion_clicktracking'=>	'',
									'vast_thirdparty_companion_expandedwidth'		=>	'',
									'vast_thirdparty_companion_expandedheight'		=>	'',
									'is_vpaid'	=> '',
									'vpaid_url'	=> '',
									'vpaid_type'	=> '',
									'vpaid_expanded'=> '',
									'vpaid_width'	=> '',
									'vpaid_height'	=> '',
									'vpaid_icons'	=> '',
									'vpaid_remainingTime'	=> '',
									'vpaid_volume'	=> '',
									
									'adbreak_tag1'	=> '',
									'adbreak_tag2'	=> '',
									'adbreak_tag3'	=> '',
									'vmap_midroll_skipoffset'	=> '',
									'vast_wrapper_url'	=> ''
								);
						
			$parameters 	= serialize($aVastVariables);
			//~ $this->response($parameters,200);
			$contenttype = $this->post('tmp_video_inline_creative_content_type');
			
			$creative_data 	= array(												
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"contenttype"		=>	clean_data($contenttype),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_inline_creative_name')),
									"filename"			=>	clean_data($video_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('inline_url')),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id)
								);
			//Call to add a creative
			
			$creative_id	=	$this->Do_video_creative->add_video($creative_data,$agency_id,$is_house_ad);
	
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$outgoing_filename,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('inline_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_video_skip_duration"		=>  '',
										"vast_video_skip_progress_duration"=>  '',
										"vast_thirdparty_clicktracking"		=>	'',
									    "vast_thirdparty_clickcustom"    =>	'',	
										"vast_thirdparty_companion_clicktracking"=>	'',
										"vast_thirdparty_companion_expandedwidth"=>	'',
										"vast_thirdparty_companion_expandedheight"=>	'',
										"vast_wrapper_url"	=> '',
										"is_vpaid"	=> '',
										"vpaid_url"	=> '',
										"vpaid_type"	=> '',
										"vpaid_expanded"=> '',
										"vpaid_width"	=> '',
										"vpaid_height"	=> '',
										"vpaid_icons"	=> '',
										"vpaid_remainingTime"	=> '',
										"vpaid_volume"	=> '',
										"adbreak_tag1"	=> '',
										"adbreak_tag2"	=> '',
										"adbreak_tag3"	=> '',
										"vmap_midroll_skipoffset"	=> '',
										"vast_version" => clean_data($vast_version)		
									);
							
				$vast_add	=	$this->Do_video_creative->add_video_vast($vast_data);
				//~ $this->response($vast_add,200);		
				//~ if($vast_add)
				//~ {
					//~ $success = array(
									//~ 'response' 		=> 	'ok',
									//~ 'msg'	 		=> 	'Creative successfully added',
									//~ 'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									//~ );
					//~ $this->response( $success, 200);
					//~ 
				//~ }
				//~ else
				//~ {
					//~ $error = array(
									//~ 'response' 		=> 	'error',
									//~ 'msg'	 		=> 	'Error. Please try again',
									//~ 'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									//~ );	
					//~ $this->response( $error, 200);
				//~ }
			}
			if($creative_id)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);
					$this->response( $success, 200);
					
				}
			
			
			else
			
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}
	
//end
// Native In App Video
public function add_video_native_creative_post()
	{	
			
		//print_r($this->post());exit; 
		$this->form_validation->set_rules('video_native_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('inline_url', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('video_url', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('video_duration', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('video_title', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('video_desc', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('cta_text', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('native_img_url', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('nat_main_img_url', 'lang:Destination_URL', 'required|trim|url');
		
		
		$campaign = $this->post('_vinative_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:Campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_vinative_campaign_id');
		}
		
	
		if($this->form_validation->run() === FALSE)
		{
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'1';
			$bannertype		=	($this->post('_type') == 'mobile') ? 'M_NAT_VID' : 'W_NAT_VID';				
			$storagetype	=	'html';
			$width			=	'-4';
			$height			=	'-4';
			$ext_bannertype = 	"bannerTypeHtml:vastNativeBannerTypeHtml:vastNativeHtml";

		
			//Get account/agency_id from library file
		    //$dj_account_id=$this->user_authentication->account_id;
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
		      $dj_account_id=$this->user_authentication->account_id;
			}
			else
			{
			  $dj_account_id=$this->user_authentication->default_advertiser_account_id;
			}
			
			$agency_id=$this->user_authentication->agency_id;
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
		      $delivery='progressive';
		      $video_duration= $this->post("video_duration");
		      $video_title = $this->post("video_title");
		      $video_desc = $this->post("video_desc");
		      $video_cta_text = $this->post("cta_text");
		      $video_url = $this->post("video_url");
		      $nat_main_img_url =$this->post("nat_main_img_url"); 
		      $native_img_url = $this->post("native_img_url");
		      $video_type= "video/x-mp4";
		  
			//~ if($delivery=='progressive')
			//~ {	
				//~ 
				//~ 
				//~ if($this->post('tmp_video_inline_creative')!='')
				//~ {
					//~ 
					//~ $is_video_creative_moved_ffmpeg	=	$this->image_lib->move_creative_to_ffmpeg_location($this->post('tmp_video_inline_creative'));
					//~ 
					//~ $is_video_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_video_inline_creative'));
					//~ 
					//~ if($this->commandExists("ffmpeg")>0) 
					//~ {
					//~ 
						//~ ##INITIALIZE FFMPEG AND FOR S3 UPLOAD VARIABLES
							//~ 
						//~ $input  			= 	$this->post('tmp_video_inline_creative');
						//~ $output 			= 	$this->post('tmp_video_inline_creative_raw_name').'.flv';
						//~ 
						//~ $upload_path		=	$this->config->item('creative_path');
						//~ $raw_name			=	$this->post('tmp_video_inline_creative_raw_name');
//~ 
						//~ $ext				=	$this->post('tmp_video_inline_creative_file_ext');
//~ 
						//~ $input_with_path  	= 	$upload_path.$this->post('tmp_video_inline_creative');
						//~ $output_with_path 	= 	$upload_path.$output;
						//~ 
						//~ $hlsStreaming = $this->HlsStreaming($this->post());
							//~ 
						//~ $video_duration		=	$this->convertToFlv( $input_with_path, $output_with_path ,$raw_name,$upload_path,$ext);
						//~ //$this->response( $video_duration, 200);
						//~ 
						//~ $video_duration		=	!empty($video_duration) ? $video_duration : 30;	
					//~ }
					//~ else 
					//~ {
						//~ $video_duration		=	'30';	
					//~ }
							//~ 
					//~ $video_name			=	$this->post('tmp_video_inline_creative');
					//~ if($this->post('tmp_video_inline_creative_content_type')=='video/mp4')
					//~ {
						//~ $video_type		=	'video/x-mp4';
					//~ }
					//~ else
					//~ {
						//~ $video_type		=	$this->post('tmp_video_inline_creative_content_type');
					//~ }
					//~ 
					//~ $toCheckExist = $this->config->item('creative_path').$this->post('tmp_video_inline_creative_raw_name')."/playlist.m3u8";
					//~ $headers=get_headers($toCheckExist);
					//~ if(stripos($headers[0],"200 OK"))
					//~ {
						//~ $outgoing_filename_m3u8 = $this->config->item('creative_path').$this->post('tmp_video_inline_creative_raw_name')."/playlist.m3u8";
						//~ $outType = "m3u8";
					//~ }
					//~ else
					//~ {
						//~ $outgoing_filename_m3u8	=	"nope";
						//~ $outType = "nope";
					//~ }
					//~ 
					//~ $outgoing_filename	=	$this->config->item('creative_path').$this->post('tmp_video_inline_creative');					
					//~ 
				//~ }
			//~ }
	//~ 
			//~ 
				//~ $companion_width 	= 	$this->post('inline_companion_width');
				//~ $companion_height 	= 	$this->post('inline_companion_height');
				//~ $companionclicktrackurl 	= 	$this->post('companionclicktrackurl');
				//~ $expanded_width 	= 	$this->post('expanded_width');
				//~ $expanded_height 	= 	$this->post('expanded_height');
				//~ 
			//~ 
			//~ if($this->post('inline_companion_size')!='')
			//~ {
				//~ $size 				= 	explode("x",$this->post('inline_companion_size'));
				//~ $companion_width 	= 	$size[0];
				//~ $companion_height 	= 	$size[1];
				//~ 
			//~ 
				//~ if($this->post('tmp_inline_companion_creative')!='')
				//~ {
					//~ $storage_type	=	'web';
					//~ $description	=	$this->post('video_inline_creative_name').' Companion';
					//~ 
					//~ if(isset($companion_width) AND isset($companion_height) )
					//~ {
						//~ $comp_creative_data = array(
												//~ "contenttype"		=>	clean_data($this->post('tmp_inline_companion_creative_content_type')),
												//~ "campaignid"		=>	clean_data($campaign_id),
												//~ "storagetype"		=>	clean_data($storage_type),
												//~ "description"		=>	clean_data($description),
												//~ "filename"			=>	clean_data($this->post('tmp_inline_companion_creative')),
												//~ "width"				=>	clean_data($companion_width),
												//~ "height"			=>	clean_data($companion_height),
												//~ "url"				=>	clean_data($this->post('inline_url')),
												//~ "dj_master_banner"	=>	clean_data($master_banner),
												//~ "status"			=>	clean_data($status),
												//~ "dj_admin_approve"	=>	clean_data($dj_admin_approve),
												//~ "dj_approved_date"	=>	clean_data($dj_approved_date),
												//~ "dj_banner_type" 	=> 	($this->post('_type') == 'mobile') ? MOBILE_COMPANION_IMAGE_CREATIVE : WEB_CREATIVE_WEB,
												//~ "dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												//~ "dj_account_id" 	=> 	clean_data($dj_account_id)
											//~ );
										//~ 
						//~ $companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,$is_house_ad);
						//~ //On sucess move the web creative from tmp location to original location
						//~ $is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_inline_companion_creative'));
						//~ 
						//~ $insert_data = array(
										//~ 'zone_id'			=>	0,
										//~ 'ad_id'				=>	$companion_id,
										//~ 'priority_factor' 	=> 	1,
										//~ 'to_be_delivered'	=>	1
										//~ );
						//~ $this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					//~ }
				//~ }
				//~ else
				//~ {
					//~ $companion_id	=	$this->post('vast_companion_id');
					//~ if($companion_id !='')
					//~ {
						//~ $insert_data = array(
										//~ 'zone_id'			=>	0,
										//~ 'ad_id'				=>	$companion_id,
										//~ 'priority_factor' 	=> 	1,
										//~ 'to_be_delivered'	=>	1
										//~ );
						//~ $this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					//~ 
					//~ }else
					//~ {$companion_id	=	$this->post('vast_companion_id');
						//~ 
					//~ }
				//~ }
			//~ }
			//~ else
			//~ {
				//~ $companion_id	=	0;
			//~ }				
			//vpaid jayashree			
			//$vpaid_enable=$this->post('vapid_enable');
			$companion_id = 0;
			$aVastVariables = array(
									'banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=> $video_url,
										//'vast_video_outgoing_filename_m3u8' 	=>	$outgoing_filename_m3u8,
									//'vast_video_outgoing_streaming_type' =>	$outType, 
									'vast_video_clickthrough_url' 	=> 	$this->post('inline_url'),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	'',
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	'',
									'vast_video_skip_duration'		=>  '',
									'vast_video_skip_progress_duration'				=>  '',
									'vast_thirdparty_companion_clicktracking'=>	'',
									'vast_thirdparty_companion_expandedwidth'		=>	'',
									'vast_thirdparty_companion_expandedheight'		=>	'',
									'is_vpaid'	=> '',
									'vpaid_url'	=> '',
									'vpaid_type'	=> '',
									'vpaid_expanded'=> '',
									'vpaid_width'	=> '',
									'vpaid_height'	=> '',
									'vpaid_icons'	=> '',
									'vpaid_remainingTime'	=> '',
									'vpaid_volume'	=> '',
									
									'adbreak_tag1'	=> '',
									'adbreak_tag2'	=> '',
									'adbreak_tag3'	=> '',
									'vmap_midroll_skipoffset'	=> '',
									'vast_wrapper_url'	=> '',
									'vast_video_title' => $video_title,
									'vast_video_desc' => $video_desc,
									'vast_video_cta' => $video_cta_text,
									'vast_video_icon'=> $native_img_url,
									'vast_video_mainimg' => $nat_main_img_url
								);
						
			$parameters 	= serialize($aVastVariables);
			//~ $this->response($parameters,200);
			//$contenttype = $this->post('tmp_video_inline_creative_content_type');
			
			$creative_data 	= array(												
									"storagetype"		=>	clean_data($storagetype),
									"campaignid"		=>	clean_data($campaign_id),
									"contenttype"		=>	clean_data('mp4'),
									"dj_banner_type"	=>	clean_data($bannertype),
									"description"		=>	clean_data($this->post('video_native_creative_name')),
									//"filename"			=>	clean_data($video_name),
									"width"				=>	clean_data($width),
									"height"			=>	clean_data($height),
									"url"				=>	clean_data($this->post('inline_url')),
									"ext_bannertype"	=>	clean_data($ext_bannertype),
									"parameters"		=>	$parameters,
									"dj_master_banner"	=>	clean_data($master_banner),
									"status"			=>	clean_data($status),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id)
								);
			//Call to add a creative
			
			$creative_id	=	$this->Do_video_creative->add_video($creative_data,$agency_id,$is_house_ad);
	
			if($creative_id)
			{					
				$vast_data		=	array(
										"banner_id" 					=> 	$creative_id,
										"vast_element_type"				=>	"singlerow",
										"vast_video_id"					=>	NULL,
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_bitrate"			=>	"400",
										"vast_video_height"				=>	"480",
										"vast_video_width"				=>	"640",
										"vast_video_outgoing_filename"	=>	$video_url,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('inline_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_video_skip_duration"		=>  '',
										"vast_video_skip_progress_duration"=>  '',
										"vast_thirdparty_clicktracking"		=>	'',
									    "vast_thirdparty_clickcustom"    =>	'',	
										"vast_thirdparty_companion_clicktracking"=>	'',
										"vast_thirdparty_companion_expandedwidth"=>	'',
										"vast_thirdparty_companion_expandedheight"=>	'',
										"vast_wrapper_url"	=> '',
										"is_vpaid"	=> '',
										"vpaid_url"	=> '',
										"vpaid_type"	=> '',
										"vpaid_expanded"=> '',
										"vpaid_width"	=> '',
										"vpaid_height"	=> '',
										"vpaid_icons"	=> '',
										"vpaid_remainingTime"	=> '',
										"vpaid_volume"	=> '',
										"adbreak_tag1"	=> '',
										"adbreak_tag2"	=> '',
										"adbreak_tag3"	=> '',
										"vmap_midroll_skipoffset"	=> '',
										"vast_version" => clean_data($vast_version)	,
										'vast_video_title' => $video_title,
										'vast_video_desc' => $video_desc,
										'vast_video_cta' => $video_cta_text,
										'vast_video_icon'=> $native_img_url,
										'vast_video_mainimg' => $nat_main_img_url	
									);
							
				$vast_add	=	$this->Do_video_creative->add_video_vast($vast_data);
				//~ $this->response($vast_add,200);		
				//~ if($vast_add)
				//~ {
					//~ $success = array(
									//~ 'response' 		=> 	'ok',
									//~ 'msg'	 		=> 	'Creative successfully added',
									//~ 'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									//~ );
					//~ $this->response( $success, 200);
					//~ 
				//~ }
				//~ else
				//~ {
					//~ $error = array(
									//~ 'response' 		=> 	'error',
									//~ 'msg'	 		=> 	'Error. Please try again',
									//~ 'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									//~ );	
					//~ $this->response( $error, 200);
				//~ }
			}
			if($creative_id)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('mobile_creative_added'),
									'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
									);
					$this->response( $success, 200);
					
				}
			
			
			else
			
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/add_web_creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
	}
	
	// edit native video creative
	
	public function edit_video_native_creative_post()
	{
		$creative_id	=	$this->post('creative_id');
		
		$url	=	$this->post('inline_url');
		
		$this->form_validation->set_rules('video_native_creative_name','lang:creative_name', 'required|trim');		
		$this->form_validation->set_rules('inline_url', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('video_url', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('video_duration', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('video_title', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('video_desc', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('cta_text', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('native_img_url', 'lang:Destination_URL', 'required|trim|url');
		$this->form_validation->set_rules('nat_main_img_url', 'lang:Destination_URL', 'required|trim|url');
		
		$campaign = $this->post('_vinative_campaign_id');
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','lang:campaign', 'required|trim');
			$campaign_id= $this->post('campaign');
		}
		else
		{
			$campaign_id= $this->post('_vinative_campaign_id');
		}
		$delivery='progressive';
		
		
		if($this->form_validation->run() === FALSE)
		{

			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							  );
			$this->response( $error, 200);
		}
		else
		{
			$master_banner	=	'-1';
			$admin_status	=	'0';
			$status			=	'1';
			
			$video_data			=	$this->Do_video_creative->fetch_video($creative_id);
			$video_vast_data	=	$this->Do_video_creative->fetch_video_vast($creative_id);
			
			$video				=	$video_data[0];
			$vast				=	$video_vast_data[0];
			
			$is_house_ad= $this->post('_is_house_ad');
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				$approval_type=$this->Do_creative->fetch_creative_approval_type();

				if($approval_type=="Approve by Admin")
					$dj_admin_approve='0';$dj_approved_date='';
				if($approval_type=="Auto Approval")
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			else
			{
				$dj_admin_approve='0';$dj_approved_date='';
			}
			
			$video_duration= $this->post("video_duration");
		      $video_title = $this->post("video_title");
		      $video_desc = $this->post("vast_video_desc");
		      $video_cta_text = $this->post("cta_text");
		      $video_url = $this->post("video_url");
		      $nat_main_img_url =$this->post("nat_main_img_url"); 
		      $native_img_url = $this->post("native_img_url");
		      $video_type= "video/x-mp4";
			
			//~ if($this->post('inline_companion_size')!='')
			//~ {
//~ 
				//~ $size 				= 	explode("x",$this->post('inline_companion_size'));
				//~ $companion_width 	= 	$size[0];
				//~ $companion_height 	= 	$size[1];
				//~ if($this->post('tmp_inline_companion_creative')!='')
				//~ {
					//~ $storage_type	=	'web';
					//~ $description	=	$this->post('video_inline_creative_name').' Companion';
					//~ 
					//~ if($this->user_authentication->account_type=='ADVERTISER')
					//~ {
					  //~ $dj_account_id=$this->user_authentication->account_id;
					//~ }
					//~ else
					//~ {
					  //~ $dj_account_id=$this->user_authentication->default_advertiser_account_id;
					//~ }
					//~ 
					//~ if(isset($companion_width) AND isset($companion_height) )
					//~ {
						//~ $comp_creative_data = array(
												//~ "contenttype"		=>	clean_data($this->post('tmp_inline_companion_creative_content_type')),
												//~ "campaignid"		=>	clean_data($this->post('campaign')),
												//~ "storagetype"		=>	clean_data($storage_type),
												//~ "description"		=>	clean_data($description),
												//~ "filename"			=>	clean_data($this->post('tmp_inline_companion_creative')),
												//~ "width"				=>	clean_data($companion_width),
												//~ "height"			=>	clean_data($companion_height),
												//~ "url"				=>	clean_data($this->post('inline_url')),
												//~ "dj_master_banner"	=>	clean_data($master_banner),
												//~ "dj_banner_type" 	=> 	WEB_CREATIVE_WEB,
												//~ "status"			=>	clean_data($status),
												//~ "dj_admin_approve"	=>	clean_data($dj_admin_approve),
												//~ "dj_approved_date"	=>	clean_data($dj_approved_date),
												//~ "dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
												//~ "dj_account_id"		=>  clean_data($dj_account_id)
											//~ );
											//~ 
						//~ $companion_id		=	$this->Do_video_creative->add_video($comp_creative_data,FALSE,$is_house_ad);
					//~ //On sucess move the web creative from tmp location to original location
						//~ $is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_inline_companion_creative'));
						//~ 
						//~ $insert_data = array(
										//~ 'zone_id'			=>	0,
										//~ 'ad_id'				=>	$companion_id,
										//~ 'priority_factor' 	=> 	1,
										//~ 'to_be_delivered'	=>	1
										//~ );
						//~ $this->db->insert(TAB_AD_ZONE_ASSOC, $insert_data);
					//~ }
				//~ }
				//~ else
				//~ {
					//~ $companion_id	=	$this->post('vast_companion_id');
//~ 
//~ 
				//~ }
			//~ }
			//~ else
			//~ {
				//~ $companion_id	=	0;
//~ 
			//~ }
			$companion_id	=	0;
			$aVastVariables = array('banner_vast_element_id'		=>	'banner_vast_element_id',
									'vast_element_type'				=>	'singlerow',
									'vast_video_id'					=>	'',
									'vast_video_duration'			=>	$video_duration,
									'vast_video_delivery'			=> 	$delivery,
									'vast_video_type' 				=> 	$video_type,
									'vast_video_bitrate' 			=> 	400,
									'vast_video_height' 			=> 	480,
									'vast_video_width' 				=> 	640,
									'vast_video_outgoing_filename' 	=>	$video_url,
									//'vast_video_outgoing_filename_m3u8' =>	$outgoing_filename_m3u8,
									//'vast_video_outgoing_streaming_type' =>	$outType, 
									'vast_video_clickthrough_url' 	=> 	$this->post('inline_url'),
									'vast_overlay_height' 			=> 	'',
									'vast_overlay_width' 			=> 	'',
									'vast_overlay_text_title' 		=> 	'',
									'vast_overlay_text_description' => 	'',
									'vast_overlay_text_call' 		=> 	'',
									'vast_overlay_format' 			=>	'',
									'vast_overlay_action' 			=> 	'',
									'vast_companion_banner_id' 		=> 	'',
									'vast_creative_type' 			=> 	'',
									'vast_thirdparty_impression' 	=> 	'',
									'vast_video_skip_duration'					=>  '',
									'vast_video_skip_progress_duration'				=>  '',
									'vast_thirdparty_companion_clicktracking'=>	'',
									'vast_thirdparty_companion_expandedwidth'		=>	'',
									'vast_thirdparty_companion_expandedheight'		=>	'',
									'is_vpaid'	=> '',
									'vpaid_url'	=> '',
									'vpaid_type'	=> '',
									'vpaid_expanded'=> '',
									'vpaid_width'	=> '',
									'vpaid_height'	=> '',
									'vpaid_icons'	=> '',
									'vpaid_remainingTime'	=> '',
									'vpaid_volume'	=> '',
									'adbreak_tag1'	=> '',
									'adbreak_tag2'	=> '',
									'adbreak_tag3'	=> '',
									'vmap_midroll_skipoffset'	=> '',
									'vast_wrapper_url'	=> '',
									'vast_video_title' => $video_title,
									'vast_video_desc' => $video_desc,
									'vast_video_cta' => $video_cta_text,
									'vast_video_icon'=> $native_img_url,
									'vast_video_mainimg' => $nat_main_img_url
								);


			$parameters 	= serialize($aVastVariables);

			/* modified by karthika on dec-2 */
			if($dj_admin_approve == -1)
			{
			
			$creative_data 	= array(
									"description"		=>	clean_data($this->post('video_native_creative_name')),
									 "campaignid" => clean_data($campaign_id),
									//"filename"			=>	clean_data($video_name),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),	
									"dj_admin_approve"			=>	clean_data(0),	
									"url"=>$url,
								);
			} else
			{
			$creative_data 	= array(
									"description"		=>	clean_data($this->post('video_native_creative_name')),
									 "campaignid" => clean_data($campaign_id),
									//"filename"			=>	clean_data($video_name),
									"parameters"		=>	$parameters,
									"updated"			=>	clean_data(date('Y:m:d :H:i:s')),	
									"url"=>$url,
								);				
				
			}
			/* //end */
			//Get agencyid from library file
			$agency_id=$this->user_authentication->agency_id;

			
			//Call to update a creative
			$updated		=	$this->Do_video_creative->update_video($creative_data,$creative_id,$agency_id,$is_house_ad);
			
		    // added for edited creative status update
			//29-06-2017
			//$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			
			//~ if($is_house_ad != 1)
			//~ {
				//~ // added for edited creative status update
				//~ $approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			//~ }						
				$approval_type=$this->Do_creative->fetch_creative_approval_type();
			if($is_house_ad != 1 && $approval_type != "Auto Approval")
			{
				// added for edited creative status update
				$approve_list = $this->Do_creative->edit_approve_creative($creative_id);
			}
			$link_type=$this->default_configurations->get('linking_type');
				
				if($link_type !='manual linking')
				{
					//$this->Do_auto_link->link_adblocks($creative_id,$agency_id,$campaign_id);
				}
				//echo $is_house_ad;exit;
				if($is_house_ad == 1)
				{
					
					//$this->Do_auto_link->link_adblocks($creative_id,$agency_id,$campaign_id);
				}
			
			
			
			if($updated)
			{					
				$vast_data		=	array(
										"vast_video_duration"			=>	$video_duration,
										"vast_video_delivery"			=>	$delivery,
										"vast_video_type"				=>	$video_type,
										"vast_video_outgoing_filename"	=>	$video_url,
										"vast_companion_banner_id"		=>	$companion_id,
										"vast_overlay_height"			=>	NULL,
										"vast_overlay_width"			=>	NULL,
										"vast_video_clickthrough_url"	=>	clean_data($this->post('inline_url')),
										"vast_overlay_action"			=>	NULL,
										"vast_overlay_format"			=>	NULL,
										"vast_overlay_text_title"		=>	NULL,
										"vast_overlay_text_description"	=>	NULL,
										"vast_overlay_text_call"		=>	NULL,
										"vast_creative_type"			=>	NULL,
										"vast_thirdparty_impression"	=> 	NULL,
										"vast_video_skip_duration"		=>  '',
										"vast_video_skip_progress_duration"=>  '',
										"vast_thirdparty_clicktracking"		=>	'',
									    "vast_thirdparty_clickcustom"    =>	'',	
										"vast_thirdparty_companion_clicktracking"=>	'',
										"vast_thirdparty_companion_expandedwidth"=>	'',
										"vast_thirdparty_companion_expandedheight"=>'',
										"vast_wrapper_url"	=> '',
										"is_vpaid"	=> '',
										"vpaid_url"	=> '',
										"vpaid_type"	=> '',
										"vpaid_expanded"=> '',
										"vpaid_width"	=> '',
										"vpaid_height"	=> '',
										"vpaid_icons"	=> '',
										"vpaid_remainingTime"	=> '',
										"vpaid_volume"	=> '',
										"adbreak_tag1"	=> '',
										"adbreak_tag2"	=> '',
										"adbreak_tag3"	=> '',
										"vmap_midroll_skipoffset"	=> '',
										"vast_version" => '',
										'vast_video_title' => $video_title,
									'vast_video_desc' => $video_desc,
									'vast_video_cta' => $video_cta_text,
									'vast_video_icon'=> $native_img_url,
									'vast_video_mainimg' => $nat_main_img_url	
									);
									
				$vast_update	=	$this->Do_video_creative->update_video_vast($vast_data,$creative_id);
				
				if($vast_update)
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('ctv_succ_updated'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);
					$this->response( $success, 200);
				}
				else
				{
					$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('error_try_again'),
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	$this->lang->line('error_try_again'),
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);	
				$this->response( $error, 200);
			}
			
		}
		
	}

	/* CHECKING URL CONTENT VALIDATION OF XML VAST*/
	public function url_xml_validation_post() 
	{
		$url1	=	$this->post('url');
		if($url1 != ''){
			$opts = array(
            'http'=>array(
                        'method'=>"GET",
                        'header'=>array("Accept-language: en", "Content-Type: text/xml\r\n"),
                        'user_agent'=>    $_SERVER['HTTP_USER_AGENT']
                        )
            );

		$context = stream_context_create($opts); 

			$xmls = file_get_contents($url1, true, $context);
		//print_r($xml);
			$xml = simplexml_load_string($xmls);
			if($xml != ''){
				$tags = $xml->getName();
				if($tags == 'VAST' || $tags == 'VideoAdServingTemplate' ){
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('URL_content_vast_format'),
									
									);
					
				}
				else{
					$success = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('no_vast_xml_content'),
									
									);
			}
		}
		else{
			$success = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	$this->lang->line('no_vast_xml_content'),
									
									);
		}
		//echo $xml->getName();
		$this->response( $success, 200);
	}
		else{
			$error = array(
										'response' 		=> 	'error',
										'msg'	 		=> 	$this->lang->line('plz_prvd_valid'),
										
										);
			$this->response( $error, 200);
		}							
		
	}
		
	




	
}
