<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for publisher related activities
 * 
 * @package		Video
 * @subpackage	Vast Mediation
 * @category	Controller
 * @author		Hari
 * @link		http://www.djaxadserver.com
*/
// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Vast_mediation extends REST_Controller
{
	function __construct(){
		parent::__construct();
		$this->load->model('Do_vast_mediation');
		$this->load->library('user_authentication');
		$key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}

	/**
       * 
       * name : add_dsp_post()
       * 
       * Add new DSP/Video adnetwork.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function add_dsp_post()
	{	
		//print_r($_POST);exit;
		
		$this->form_validation->set_rules('dsp_name','DSP/Video Adnetwork Name', 'required|trim');
		$this->form_validation->set_rules('dsp_ping_url','Vast ping URL', 'required|trim|valid_url');
		//$this->form_validation->set_rules('dsp_zone_id','Placement/Zone Id', 'required|trim');
		$this->form_validation->set_rules('dsp_macro','Macro for ZoneId', 'required|trim');
		//$this->form_validation->set_rules('dsp_video_length','Video content length', 'required|trim|numeric|xss_clean');
	
		if($this->form_validation->run() === FALSE)
		{	
			
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}else
		{
			//print_r($this->post());exit;
			$dsp_data = array();
			$dsp_data['agency_id'] = get_session('agencyid');
			$dsp_data['adnetwork_name'] = $this->post('dsp_name');
			$dsp_data['vast_mediation_url'] = $this->post('dsp_ping_url');
			$dsp_data['zone_id'] = $this->post('dsp_zone_id');
			$dsp_data['macro'] = $this->post('dsp_macro');
			$dsp_data['video_length'] = $this->post('dsp_video_length');
			$dsp_data['vast_version'] = $this->post('vast_version');
			$dsp_data['publisher'] = $this->post('dsp_publisher');
			$dsp_data['country'] = $this->post('dsp_country');
			
			$ecpm = $this->post('auto_ecpm');
			$dsp_data['auto_ecpm'] = (isset($ecpm) && $ecpm != '') ? 1 : 0;
				
			$dsp_data['ecpm_duration'] = $this->post('ecpm_duration');

			$country_weight = $this->post('weight');
			$dsp_data['country_weight'] = $country_weight;

		//	$dsp_data['date_created'] = mdate('%Y-%m-%d %H:%i:%s',local_to_gmt());
			//$dsp_data['date_updated'] = mdate('%Y-%m-%d %H:%i:%s',local_to_gmt());
			
			$dsp_data['date_created'] = date('Y-m-d H:i:s');
			$dsp_data['date_updated'] = date('Y-m-d H:i:s');
			if($this->post('ecpm_value') != '')
			{
				$dsp_data['ecpm'] = $this->post('ecpm_value');
			}
			else
			{
				$dsp_data['ecpm'] = '';
			}
			//echo "true21date";exit;
			//print_r($dsp_data);exit;
		
			$insertId = $this->Do_vast_mediation->add_dsp($dsp_data);
			
			//$this->response( $insertId, 200);
			
			if ($insertId != '' && $insertId != 0 ) {
				if($dsp_data['publisher'] == 1 || $dsp_data['publisher'] == 2){
					$this->Do_vast_mediation->target_publishers($insertId, $this->post('dsp_publishers'));
				}
				if($dsp_data['country'] == 1 || $dsp_data['country'] == 2){
					$this->Do_vast_mediation->target_countries($insertId, $this->post('dsp_countries'));
				}

				if($dsp_data['country_weight'] == 1){
					$country_weight_array = array_filter($this->post('cw'));
					$this->Do_vast_mediation->country_weight($insertId, $country_weight_array);
				}

				$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('dsp_add_succ'),
								'dsp_id'	 => $insertId
								);
				$this->response( $success, 200);
			}else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again')
								);	
				$this->response( $error, 200);
			}
		}
	}
	
	/**
       * 
       * name : edit_dsp_post()
       * 
       * Edit DSP/Video adnetwork.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function edit_dsp_post()
	{	
		$this->form_validation->set_rules('dsp_name','DSP/Video Adnetwork Name', 'required|trim');
		$this->form_validation->set_rules('dsp_ping_url','Vast ping URL', 'required|trim|valid_url');
		//$this->form_validation->set_rules('dsp_zone_id','Placement/Zone Id', 'required|trim');
		$this->form_validation->set_rules('dsp_macro','Macro for ZoneId', 'required|trim');
		//$this->form_validation->set_rules('dsp_video_length','Video content length', 'required|trim|numeric|xss_clean');

		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}else
		{
			$dsp_id = $this->post('dsp_id');
			$agency_id = get_session('agencyid');

			$dsp_data = array();
			$dsp_data['adnetwork_name'] = $this->post('dsp_name');
			$dsp_data['vast_mediation_url'] = $this->post('dsp_ping_url');
			$dsp_data['zone_id'] = $this->post('dsp_zone_id');
			$dsp_data['macro'] = $this->post('dsp_macro');
			$dsp_data['video_length'] = $this->post('dsp_video_length');
			$dsp_data['vast_version'] = $this->post('vast_version');
			$dsp_data['publisher'] = $this->post('dsp_publisher');
			$dsp_data['country'] = $this->post('dsp_country');

			$ecpm = $this->post('auto_ecpm');
			$dsp_data['auto_ecpm'] = (isset($ecpm) && $ecpm != '') ? 1 : 0;

			$dsp_data['ecpm_duration'] = $this->post('ecpm_duration');

			$country_weight = $this->post('weight');
			$dsp_data['country_weight'] = $country_weight;

			//$dsp_data['date_updated'] = mdate('%Y-%m-%d %H:%i:%s',local_to_gmt());
			$dsp_data['date_updated'] = date('Y-m-d H:i:s');

			if( $country_weight == 0)
			{
				
						$dsp_data['ecpm'] = $this->post('ecpm_value');
					
			}
			else
			{
				$dsp_data['ecpm'] = 0;
				
			}
				
			//print_r($dsp_data);exit;
			$updated = $this->Do_vast_mediation->edit_dsp($dsp_data,$dsp_id,$agency_id);
			if($updated == 1){
				if($dsp_data['publisher'] == 1 || $dsp_data['publisher'] == 2){
					$this->Do_vast_mediation->target_publishers($dsp_id, $this->post('dsp_publishers'));
				}else{
					$this->Do_vast_mediation->remove_target_publishers($dsp_id);
				}
				if($dsp_data['country'] == 1 || $dsp_data['country'] == 2){
					$this->Do_vast_mediation->target_countries($dsp_id, $this->post('dsp_countries'));
				}else{
					$this->Do_vast_mediation->remove_target_countries($dsp_id);
				}

				if($dsp_data['country_weight'] == 1){
					$country_weight_array = array_filter($this->post('cw'));
					$this->Do_vast_mediation->country_weight($dsp_id, $country_weight_array);
				}else{
					$this->Do_vast_mediation->remove_country_weight($dsp_id);
				}

				$success = array(
								'response' => 'ok',
								'msg'	 => $this->lang->line('dsp_up_succ'),
								'dsp_id'	 => $dsp_id
								);
				$this->response( $success, 200);
			}else{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again')
								);	
				$this->response( $error, 200);
			}
		}
	}

	/**
       * 
       * name : fetch_get()
       * 
       * Fetches all DSP/Video adnetwork information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_get()
	{	
		$dsp_id = $this->get('dsp_id');
		$dsp = 	$this->Do_vast_mediation->fetch($dsp_id);
		if($dsp)
		{
			$this->response($dsp,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}

	/**
       * 
       * name : fetch_active_get()
       * 
       * Fetches all Active DSP/Video adnetwork information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_active_get()
	{	
		$account_id  	= 	$this->user_authentication->account_id;
		
		$dsp = 	$this->Do_vast_mediation->fetch_active($account_id);
		if($dsp)
		{
			$this->response($dsp,200);
		}
		else
		{
			$this->response( array(), 200);
		}
	}

	/**
       * 
       * name : block_get()
       * 
       * block the DSP
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function block_get()
	{	
		$account_id = $this->get('block_account_id');	
		if($account_id)
		{
			$dsp 	= 	$this->Do_vast_mediation->block($account_id);
			if($dsp)
			{
				$success = 	array(
							'response' 	=> 	'ok',
							'msg'	 	=> 	$this->lang->line('dsp_blk_succ')
							);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
									);
				$this->response( $error, 200);
			}
		}
		else
		{
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('dsp_does_not_fnd')
								);
			$this->response( $error, 200);
		}
	}	

	/**
       * 
       * name : unblock_get()
       * 
       * unblock the DSP
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function unblock_get()
	{	
		$account_id = $this->get('unblock_account_id');	
		if($account_id)
		{
			$dsp 	= 	$this->Do_vast_mediation->unblock($account_id);
			if($dsp)
			{
				$success = 	array(
							'response' 	=> 	'ok',
							'msg'	 	=> 	$this->lang->line('dsp_unblk_succ')
							);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
									);
				$this->response( $error, 200);
			}
		}
		else
		{
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('dsp_does_not_fnd')
								);
			$this->response( $error, 200);
		}
	}

	/**
       * 
       * name : delete_get()
       * 
       * deletes the dsp information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{	
		$account_id = $this->get('del_account_id');
		
		if($account_id)
		{
			$dsp = 	$this->Do_vast_mediation->remove($account_id);
			if($dsp)
			{
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('dsp_delete_succ')
										);
					$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('error_try_again')
								);
				$this->response( $error, 200);
			}
		}
		else
		{
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('dsp_does_not_fnd')
								);
			$this->response( $error, 200);
		}
	}


	/**
       * 
       * name : dsp_assoc_get()
       * 
       * List dsp association
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function dsp_assoc_get()
	{	
		$account_id  	= 	$this->user_authentication->account_id;

		if($account_id){
			$result = $this->Do_vast_mediation->dsp_assoc($account_id);
			$this->response( $result, 200);
		}else
		{
			$result 	= 	array(
								'response' 	=>	'error',
								'msg'	 	=>	$this->lang->line('accn_id_not_fnd')
							);
		}
		$this->response( $result, 200);
	}
	
	/**
       * 
       * name : link_dsp_post()
       * 
       * List dsp to publisher
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function link_dsp_post()
	{	
		$api_key = $this->post('api_key');

		$account_id  	= 	$this->user_authentication->account_id;
		$dsps = is_array($this->post('dsps')) ? $this->post('dsps') : array();
		
		$result = $this->Do_vast_mediation->link_dsp($account_id, $dsps);
		if($result){
			$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$result
										);
			$this->response( $success, 200);
		}
	}

	/**
       * 
       * name : fetch_publisher_get()
       * 
       * Fetches all publisher information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_publisher_get()
	{	
		$api_key = $this->get('api_key');

		$account_id  	= 	$this->user_authentication->account_id;
		
		$result = $this->Do_vast_mediation->fetch_publisher($account_id);
		if($result){
			$this->response( $result, 200);
		}
	}

	/**
       * 
       * name : fetch_dsp_publisher_get()
       * 
       * Fetches all publisher information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_dsp_publisher_get()
	{	
		
		$dsp_id = $this->get('dsp_id');
		
		$result = $this->Do_vast_mediation->fetch_dsp_publisher($dsp_id);
		//$this->response($result, 200);
		if($result){
			$this->response($result, 200);
		}
	}

	/**
       * 
       * name : fetch_dsp_country_get()
       * 
       * Fetches all publisher information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_dsp_country_get()
	{	
		$dsp_id = $this->get('dsp_id');

		$result = $this->Do_vast_mediation->fetch_dsp_country($dsp_id);
		
		if($result){
			$this->response($result, 200);
		}
	}
	
	/**
       * 
       * name : update_ecpm_post()
       * 
       * Update ECPM for DSP
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function update_ecpm_post()
	{	
		$dsp_id = $this->post('dsp_id');
		$dsp_ecpm = $this->post('dsp_ecpm');

		$result = $this->Do_vast_mediation->update_ecpm($dsp_id, $dsp_ecpm);

		if($result){
			$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$dsp_ecpm
										);
			$this->response( $success, 200);
		}
	}

	/**
       * 
       * name : fetch_country_weight_get()
       * 
       * Fetch country weight for DSP
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_country_weight_get()
	{	
		$dsp_id = $this->get('dsp_id');

		$result = $this->Do_vast_mediation->fetch_country_weight($dsp_id);

		if($result){
			$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$result
										);
			$this->response( $success, 200);
		}
	}
	
	/**
       * 
       * name : csv_upload()
       * 
       * update country weight/cpm through csv
    */
    
	function csv_upload_post()
	{
		$dsp_id = $this->post('dsp_id');
		$csv_value = $this->post('tmp_csv');
		$temp_csv = explode(",,",$csv_value);
		$temp_csv = array_filter($temp_csv);
		
		
		
		foreach($temp_csv as $val)
		{
			$split_country = explode(",",$val);
			$c = str_replace('"', '', $split_country[0]);
			$e = str_replace('"', '', $split_country[1]);
			  
			
			if(!empty($c) && !empty($e))
			{
				$ecpm_val = (float) $e;
				
				$check_countrys = "";
				
				$check_countrys = $this->Do_vast_mediation->check_country($c);
							
				if($check_countrys == "FALSE")
				{
					$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=> $this->lang->line('err_invalid_cnt_data')
							);
							$this->response($error, 200);
				}
				if($ecpm_val < 0)
				{
					
					$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $this->lang->line('err_invalid_ecpm')
							);
							$this->response($error, 200);
				}
				if($ecpm_val > 10)
				{
					
					$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $this->lang->line('err_invalid_ecpm')
							);
							$this->response($error, 200);
				}
			
			
			
						
				$country_and_ecpm[$c] = $e;
	
			}
			else
			{
							$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=> $this->lang->line('err_invalid_empty')
							);
							$this->response($error, 200);
			}	
				
		}
		
		if(!empty($country_and_ecpm))
		{
			$result = $this->Do_vast_mediation->country_weight_csv($dsp_id,$country_and_ecpm);
			
			if($result)
			{
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('count_ecpm_up_succ')
										);
			$this->response($success, 200);
			}	
		}		
		
		
	}
}
