<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Utilities (Generalize Things)
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Utilities extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_category');
		$this->load->model('Do_country');
		$this->load->model('Do_currency');
		$this->load->model('Do_campaign');
		$this->load->model('Do_targeting');
		$this->load->model('Do_app_config');
		$this->load->model('Do_rtb');
        $this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	  /*
	 * name: currency_type_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will get all the currency type
	 * 
	 */
	 public function currency_type_get()
	{
	
 


$type = $this->Do_currency->list_currency();
		if($type)
		{
			$this->response($type, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('currency_not_found')),200);
		}
		
	}
	
	
	/*
	 * 
	 * name: unknown
	 * @param
	 * @return
	 */
	 function categorylist_get()
	 {	
		
		
		 $parent = $this->get('parent'); 
		
		 $category=$this->Do_category->list_category($parent);

		 $this->response($category, 200); // 200 being the HTTP response code

	 }

	/************* domain list******/

	/*
    *
    * name: unknown
    * @param
    * @return
    */
	function domainlist_get()
	{
		
		
		// $parent = $this->get('parent');

		$campaign_id = $this->get('camp_id');

		$domain = $this->Do_campaign->list_domain($campaign_id);

		$this->response($domain, 200); // 200 being the HTTP response code

	}

	/*************End of domain list******/
	 
	 	

	/*
	 * 
	 * name: countrylist_get
	 * @param
	 * @return
	 */
	 function countrylist_get()
	 {
		 
		 $country=$this->Do_country->list_country();	
		 
		  if($country)
		 {
			 
			 $this->response($country, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			$this->response(array('error'=>$this->lang->line('country_not_found')),404);
		 }
		 
	 }
	 
	
	/*
	 * 
	 * name: unknown
	 * @param
	 * @return
	 */
	 function currencylist_get()
	 {
		 
		 $currency=$this->Do_currency->list_currency();	
		 
		  if($currency)
		 {
			 $this->response($currency, 200); // 200 being the HTTP response code
		 }
		 else
		 {
				$this->response(array('error'=>$this->lang->line('currency_not_found')),404);
		 }
		 
	 }
	 
	 /*
	 * name: fetch_type_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will get all the campaign type
	 * 
	 */
	 
	public function fetch_type_get()
	{
	    $type_value = $this->input->get_post('camp_type'); 
	    $advertiser_geo=$this->get('advertiser_geo');

		$type = $this->Do_campaign->fetch_type($type_value,$advertiser_geo);

		if($type)
		{
			$this->response($type, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('campaign_type_not_found')),200);
		}
	}
	 
	 /*
	 * name: fetch_target_browsers_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target browsers available
	 * 
	 */
	public function fetch_target_browsers_get()
	{
		$browser_options = $this->Do_targeting->fetch_targ_options('browser');

		if($browser_options)
		{
			$this->response($browser_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_browsers_available')),200);
		}
	}
	 /*
	 * name: fetch_target_os_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target os available
	 * 
	 */
	public function fetch_target_os_get()
	{
		$os_options = $this->Do_targeting->fetch_targ_options('os');

		if($os_options)
		{
			$this->response($os_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_os_available')),200);
		}
	}
	 /*
	 * name: fetch_target_countries_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target countries available
	 * 
	 */
	public function fetch_target_countries_get()
	{
		$geo_options = $this->Do_targeting->fetch_targ_options('geo');

		if($geo_options)
		{
			$this->response($geo_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targeting_countries_available')),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_os_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target os available
	 * 
	 */
	public function fetch_target_mobile_os_get()
	{
		$mobile_os_options = $this->Do_targeting->fetch_targ_options('mobile_os');

		if($mobile_os_options)
		{
			$this->response($mobile_os_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targeting_countries_available')),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_manu_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target manufacturers available
	 * 
	 */
	public function fetch_target_mobile_manu_get()
	{
		$mobile_manu_options = $this->Do_targeting->fetch_targ_options('mobile_manu');

		if($mobile_manu_options)
		{
			$this->response($mobile_manu_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targeting_countries_available')),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_telcom_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target telecom operators available available
	 * 
	 */
	public function fetch_target_mobile_telcom_get()
	{
		$mobile_manu_options = $this->Do_targeting->fetch_targ_options('mobile_telecom');

		if($mobile_manu_options)
		{
			$this->response($mobile_manu_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targeting_countries_available')),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_carrier_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target telecom operators available available in respective country
	 * 
	 */
	 
	 
	 
	public function fetch_target_mobile_carrier_get()
	{
		$mobile_manu_options = $this->Do_targeting->fetch_targ_options('mobile_carrier');

		if($mobile_manu_options)
		{
			$this->response($mobile_manu_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targeting_countries_available')),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_capability_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target cabality available
	 * 
	 */
	public function fetch_target_mobile_capability_get()
	{
		$mobile_manu_options = $this->Do_targeting->fetch_targ_options('mobile_capability');
        
			foreach($mobile_manu_options as $key=>$value)
              {
			
                if($value['name'] != $old_country){
					$j++;
					$new_cap[$j]['text'] = $value['name'];
					
					
				}
				
				$new_cap[$j]['children'][$i]['id'] = $value['id'];
					$new_cap[$j]['children'][$i]['text'] = $value['text'];
					$new_cap[$j]['children'][$i]['id'] = $value['name'].'|'.$value['id'];
                $old_cap = $value['name'];
               $i++; 
              }
             
              foreach($new_cap as $key => $sub_array) {
				  
					if($sub_array['children'] != null) {
						
					$cap_array[ucwords($sub_array['text'])]['text'] = $sub_array['text'];
					 foreach($sub_array['children'] as $keys => $sub_arrays) {
						 
						 $cap_array[ucwords($sub_array['text'])]['children'][] =$sub_arrays;
						
					 }
					}
				}
             
         //~ $this->response($cap_array,200);
        $result = array_values( $new_cap );
        $result_capability = array_values( $cap_array );	
		if($mobile_manu_options)
		{
			$this->response($result_capability, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error' => $this->lang->line('no_mob_cap_ava')), 200);
		}
	}
	 /*
	 * name: ssplist_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will get all the ssp type
	 * 
	 */
	public function ssplist_get()
	{
		 $agency_id     = $this->user_authentication->agency_id;
		$type = $this->Do_campaign->fetch_ssp_type($agency_id);

		if($type)
		{
			$this->response($type, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('campaign_type_not_found')),200);
		}
	}

	/*
    * name: currency_type_get
    * @param
    * @return:response array
    *
    * In this method will get all the currency type
    *
    */
	public function currency_type_smaato_get()
	{

		$type = $this->Do_currency->list_currency_smaato();
		if ($type) {
			$this->response($type, 200); // 200 being the HTTP response code
		} else {
			$this->response(array('error' => $this->lang->line('currency_not_found')), 200);
		}
		
	}
			public function fetch_target_tele_country_get()
	{
		$camp_id 	= $this->get('cid');	
		
		$val = $this->get('val');
		$exp = explode(',',$val);
		$mobile_manu_options = $this->Do_targeting->fetch_country_by_val($exp);
	

        foreach($mobile_manu_options as $key=>$value)
              {
			
                if($value['name'] != $old_country){
					$j++;
					$new_city[$j]['text'] = $value['name'];
					
					
				}
				
				$new_city[$j]['children'][$i]['id'] = $value['id'];
					$new_city[$j]['children'][$i]['text'] = $value['text'];
				 $newcity[$j]['children'][$i]['id'] = $value['carriername'].'|'.$value['id'];
                $old_country = $value['name'];
               $i++; 
              }
              
              foreach($new_city as $key => $sub_array) {
					if($sub_array['children'] != null) {
						
					$city_array[$key]['text'] = $sub_array['text'];
					 foreach($sub_array['children'] as $keys => $sub_arrays) {
						 
						 $city_array[$key]['children'][] =$sub_arrays;
						
					 }
					}
				}
             
        
        $result = array_values( $new_city );
        $result_city = array_values( $city_array );	
 	
		if($mobile_manu_options)
		{
			$this->response($result_city, 200); // 200 being the HTTP response code
			//$this->response($result_capability, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error' => $this->lang->line('no_tele_ava')), 200);
		}
		
		
	}
	/*
	* name: fetch_target_option_get
	* @param
	* @return:response array
	* 
	* In this method will fetch all the target available
	* 
	*/
	 
	public function fetch_target_option_get()
	{
		$targ_type	=	$this->get('type');
	
		$targ_options = $this->Do_targeting->fetch_targ_options($targ_type);

		if($targ_options)
		{
			$this->response($targ_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_data')),200);
		}
	}
	/*
	* name: fetch_target_time_option_get
	* @param
	* @return:response array
	* 
	* In this method will fetch all the target available
	* 
	*/
	public function fetch_target_time_option_get()
	{
		$targ_type	=	$this->get('type');
	
		$targ_options = $this->Do_targeting->fetch_targ_time_options($targ_type);

		if($targ_options)
		{
			$this->response($targ_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_data')),200);
		}
	}
		public function fetch_target_city_get()
	{	
		$val = $this->get('val');
		$query = $this->get('query');   
		//$this->response($val, 200); 
		$exp = explode(',',$val);
		//$this->response($exp, 200);	
		$geo_options = $this->Do_targeting->fetch_city_by_val($exp,$query);
	//	$this->response($geo_options, 200);
		foreach($geo_options as $key=>$value)
              {
			
                if($value['country'] != $old_country){
					$j++;
					$new_city[$j]['text'] = $value['country'];
					
					
				}
				
				$new_city[$j]['children'][$i]['id'] = $value['id'];
				$new_city[$j]['children'][$i]['text'] = $value['text'];
				$newcity[$j]['children'][$i]['id'] = $value['country'].'|'.$value['id'];	
                $old_country = $value['country'];
               $i++; 
              }
              
              foreach($new_city as $key => $sub_array) {
					if($sub_array['children'] != null) {
						
					$city_array[$key]['text'] = $sub_array['text'];
					 foreach($sub_array['children'] as $keys => $sub_arrays) {
						 
						 $city_array[$key]['children'][] =$sub_arrays;
						
					 }
					}
				}
             
        
        $result = array_values( $new_city );
        $result_city = array_values( $city_array );		
		if($geo_options)
		{
			$this->response($result_city, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targ_city_ava')),200);
		}
	}
	
	
	
	function dspdetails_get()
	{	
		
		//$this->response('vivek',200);
		 
		$agency=$this->get('agency');

		$dsp_details=$this->Do_rtb->list_dsp($agency);

		//$this->response($this->db->last_query(), 200); 
		$this->response($dsp_details, 200); 
	}
	//Intergrated by jayashree
	public function fetch_publisherslist_get()
	{
		$agency_id = $this->get('agency_id'); 
		$publishers_list = $this->Do_campaign->fetch_publisherslist($agency_id);

		if($publishers_list)
		{
			$this->response($publishers_list, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targeting_ip_available')),200);
		}
	}
	//Intergrated by jayashree
	public function fetch_publishersid_get()
	{
		$agency_id = $this->get('agency_id'); 
		$publisher_id = $this->Do_campaign->fetch_publishersid($agency_id);

		if($publisher_id)
		{
			$this->response($publisher_id, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targeting_ip_available')),200);
		}
	}
	//Intergrated by jayashree
	public function dsplist_get()
	{
		$agency_id     = $this->get('agency_id'); 
		$dsp = $this->Do_campaign->fetch_dsp_type($agency_id);

		if($dsp)
		{
			$this->response($dsp, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_trd_ad_fund')),200);
		}
	}
	//Intergrated by jayashree
	public function dspids_get()
	{
		$agency_id     = $this->get('agency_id'); 
		$dspids = $this->Do_campaign->fetch_dspid($agency_id);

		if($dsp)
		{
			$this->response($dspids, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_trd_ad_fund')),200);
		}
	}
	 /*
	 * name: fetch_target_keyword_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target keyword available
	 *  
	 */
	public function fetch_target_keyword_get()
	{
		
		$keyword_options = $this->Do_targeting->fetch_targ_options('keyword');

		if($keyword_options)
		{
			$this->response($keyword_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No Keyword available'),200);
		}
	}


    /*
	 * name: fetch_target_segment_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the available segment
	 *  
	 */
	 public function fetch_target_segment_get()
	{
		$segment_options = $this->Do_targeting->fetch_targ_options('segment');

		if($segment_options)
		{
			$this->response($segment_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No os available'),200);
		}
	}
	 
	/*
	 * name: fetch_currency_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will get all the currency type
	 * 
	 */
	public function fetch_currency_get()
	{

		$currency = $this->Do_currency->fetch_currencies();
		if($currency)
		{
			$this->response($currency, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('currency_not_found')),200);
		}
		
	}	
	
	
	 /*
	 * name: fetch_target_mobile_os_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target os available
	 * 
	 */
	public function fetch_target_site_get()
	{
		$site_options = $this->Do_targeting->fetch_targ_options('site');

		if($site_options)
		{
			$this->response($site_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_site_targ_available')),200);
		}
	}
	
	 /*
	 * name: fetch_target_sentiment_source_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target os available
	 * 
	 */
	public function fetch_target_sentiment_get()
	{
		$sentiment_options = $this->Do_targeting->fetch_targ_options('sentiment');

		if($sentiment_options)
		{
			$this->response($sentiment_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_senti_targ_available')),200);
		}
	}
	
	public function fetch_target_customtarg_get()
	{
		$targ_val     = $this->input->get('targval');
		$customtarg_options = $this->Do_targeting->fetch_targ_options($targ_val);

		if($customtarg_options)
		{
			$this->response($customtarg_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_custom_targ_available')),200);
		}
	}
}
