<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * User
 *
 * Here We have developed services for user related activities
 * based on their roles
 *
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class User extends REST_Controller
{ 
	function __construct(){

		parent::__construct();
		$this->load->model('Do_networks');
		$this->load->model('Do_network_managers');
		$this->load->model('Do_advertiser');
		$this->load->model('Do_publisher');
		$this->load->model('Do_site');
		$this->load->model('Do_email_check');
		$this->load->library('user_agent');
		
	}


	public function validate_post()
	{
		
		$role = array('ADVERTISER','TRAFFICKER','ADMIN','MANAGER');

		if($this->post('acc_type') !='' and in_array($this->post('acc_type'),$role))
		{
			//$this->response($this->post('acc_type')); exit;
			switch(strtoupper($this->post('acc_type')))
			{
				case "ADMIN":
					
					$adminObj 	= 	$this->Do_networks->validate_user($this->post('uemail'),$this->post('upw'),$this->post('acc_type'));
					
					if ($adminObj != FALSE)
					{
						
						if($adminObj['denied']==0)
						{
							// CREATE SESSIONS for ADMIN
							if($adminObj['default_manager']==1){
								
								//UPDATE LOGIN COUNT INFORMATION
								if(($_SERVER['REMOTE_ADDR']!='182.72.161.90')){
								//$this->update_login_count($adminObj);
								
								}

								set_session($adminObj['account_type'], $adminObj);
								set_session($adminObj['manager_account_id'], $adminObj);
								set_session($adminObj['network_account_id'], $adminObj);
								
								$response = array(
												'response' 	=> 	'ok',
												'redirect'	=>	site_url('admin/dashboard'),
												'msg'	 	=> 	$this->lang->line('login_suc')
											);
							
							}
						
							/*Sets the cookies for remember password */
							$sitename=$adminObj['site_name'];
							$prod_name 	= 	$this->config->item('prod_name');
							if($sitename != ''){$prod_name 	=$sitename;}else{$prod_name 	=$prod_name;}
							
							$prod_name = str_replace(' ', '', $prod_name);
							if($this->post('remember')==1)
							{
								$expire	=	time()+60*60*24*30;
								setcookie($prod_name.'_admin_cookie_user_name',$this->post('uemail'),$expire,'/');
								setcookie($prod_name.'_admin_cookie_user_pwd',base64_encode($this->post('upw')),$expire,'/');
							}
							else
							{
								$expire	=	time()-60*60*24*30;
								setcookie($prod_name.'_admin_cookie_user_name','',$expire,'/');
								setcookie($prod_name.'_admin_cookie_user_pwd','',$expire,'/');	
							}
						}
						else
						{
							$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  $this->lang->line('admin_acc_blkd_temp')
										 );
						}
					}
					else
					{
						
						     // CREATE SESSIONS for MANAGER and their user roles
							 $acc_type='manager';
							 $managerObj=$this->Do_network_managers->validate_user($this->post('uemail'),$this->post('upw'),$acc_type);
						
							//$this->response($managerObj, 200);
							if($managerObj['agencyid']==1 || $managerObj['agencyid']==2)
							{
								$admin="admin";
						    }	
						    else
						    {
								$admin="manager";
								
						    }	
							 //print_r($managerObj);exit;
							 if($managerObj!=FALSE && $managerObj['user_role_block']!=1 && $managerObj['user_status']!=0 && $managerObj['is_active']!=0)
							 {
							   set_session($managerObj['account_type'],$managerObj);
							   set_session($managerObj['network_account_id'],$managerObj);
							  
								//UPDATE LOGIN COUNT INFORMATION
							  if($_SERVER['REMOTE_ADDR']!='182.72.161.90'){
							 //  $this->update_login_count($managerObj);
							   }
							   $response 	= 	array(
												'response' 	=> 	'ok',
												'redirect'	=>	site_url('admin/dashboard'),
												'msg'	 	=> 	$this->lang->line('login_suc')
											);
							$sitename=$adminObj['site_name'];
							$prod_name 	= 	$this->config->item('prod_name');
							if($sitename != ''){$prod_name 	=$sitename;}else{$prod_name 	=$prod_name;}
							   //$prod_name 	= 	$this->config->item('prod_name');
							   $prod_name = str_replace(' ', '', $prod_name);
							    /*Sets the cookies for remember password */
								if($this->post('remember')==1)
								{
									$expire	=	time()+60*60*24*30;
									setcookie($prod_name.'_admin_cookie_user_name',$this->post('uemail'),$expire,'/');
									setcookie($prod_name.'_admin_cookie_user_pwd',base64_encode($this->post('upw')),$expire,'/');
								}
								else
								{
									$expire	=	time()-60*60*24*30;
									setcookie($prod_name.'_admin_cookie_user_name','',$expire,'/');
									setcookie($prod_name.'_admin_cookie_user_pwd','',$expire,'/');	
								}
							   
							  }
							  elseif($managerObj=='')
							  {
							    $response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  $this->lang->line('uname_pwd_incrct')
										 );
							  }
							  //IF USER A/c IS BLOCKED
							  elseif($managerObj['user_status']==0 || $managerObj['is_active']==0)
							  { 
							    $response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  $this->lang->line('your_account_currently_blocked')
										 );
							  }
							  //IF USER ROLE IS BLOCKED
							  elseif($managerObj['user_role_block']==1)
							  { 
							    $response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  $this->lang->line('yr_role_crtly_blkd_admin')
										 );
							  }
							  
					   }
					
					$this->response($response, 200);
				break;
				
				case "MANAGER":
					
					$managerObj 	= 	$this->Do_network_managers->validate_user($this->post('uemail'),$this->post('upw'),$this->post('acc_type'));

					if($managerObj != FALSE)
					{
						if($managerObj['status']==1)
						{
							// CREATE SESSIONS for Advertiser
							set_session($managerObj['account_type'],$managerObj);
							set_session($managerObj['network_account_id'],$managerObj);
                             //UPDATE LOGIN COUNT INFORMATION
							 if($_SERVER['REMOTE_ADDR']!='182.72.161.90'){
								//$this->update_login_count($managerObj);
							  }
							  
							$response 	= 	array(
												'response' 	=> 	'ok',
												'redirect'	=>	site_url('admin/dashboard'),
												'msg'	 	=> 	$this->lang->line('login_suc')
											);
							$sitename=$adminObj['site_name'];
							$prod_name 	= 	$this->config->item('prod_name');
							if($sitename != ''){$prod_name 	=$sitename;}else{$prod_name 	=$prod_name;}
							//$prod_name 	= 	$this->config->item('prod_name');
							$prod_name = str_replace(' ', '', $prod_name);
							/*Sets the cookies for remember password */
							if($this->post('remember')==1)
							{
								$expire	=	time()+60*60*24*30;
								setcookie($prod_name.'_manager_cookie_user_name',$this->post('uemail'),$expire,'/');
								setcookie($prod_name.'_manager_cookie_user_pwd',base64_encode($this->post('upw')),$expire,'/');
							}
							else
							{
								$expire	=	time()-60*60*24*30;
								setcookie($prod_name.'_manager_cookie_user_name','',$expire,'/');
								setcookie($prod_name.'_manager_cookie_user_pwd','',$expire,'/');	
							}
						}
						else
						{
							$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  $this->lang->line('mang_blckd_temp_admin'),
										 );
						}
					}
					else
					{
						$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  $this->lang->line('uname_pwd_ent_inct')
										 );
					}
					
					$this->response($response, 200);
				break;
				
				case "ADVERTISER":
					
					$advObj 	=	$this->Do_advertiser->validate_user($this->post('uemail'),$this->post('upw'),$this->post('acc_type'));
               
					$adv_Temp_Obj = $this->Do_advertiser->validate_temp_user($this->post('uemail'), $this->post('upw'), $this->post('acc_type'));
									
					//$admin_details =$this->Do_advertiser->fetch_admin_details();
										
					$admin_details =$this->Do_advertiser->fetch_admin_details_new($this->post('uemail'), $this->post('upw'), $this->post('acc_type'));
					
					$admin_email = $admin_details[0]['email']; 
					
					$agencyid = $admin_details[0]['agencyid']; 
					
					$admin="administrator";
			       
					if($advObj != FALSE )
					{
						
						if($advObj['denied']==0 && $advObj['is_active']==1 && $advObj['dj_is_default']==0)
						{
							// CREATE SESSIONS for Advertiser
							set_session($advObj['account_type'],$advObj);
							
							//UPDATE LOGIN COUNT INFORMATION
							if($_SERVER['REMOTE_ADDR']!='182.72.161.90'){
								//$this->update_login_count($advObj);
							}
							
							if($advObj['onetime_wizard']!='1')
							{
								$response  	= 	array(
												'response' 	=> 	'ok',
												'redirect'	=>	site_url('advertiser/onetime_wizard'),
												'msg'	 	=> 	$this->lang->line('login_suc')
											);						
							}	
							else
							{
								$response  	= 	array(
												'response' 	=> 	'ok',
												'redirect'	=>	site_url('advertiser/dashboard'),
												'msg'	 	=> 	$this->lang->line('login_suc')
											);
							}						
							$sitename=$advObj['site_name'];
							$prod_name 	= 	$this->config->item('prod_name');
							if($sitename != ''){$prod_name 	=$sitename;}else{$prod_name 	=$prod_name;}
							//$prod_name 	= 	$this->config->item('prod_name');
							$prod_name = str_replace(' ', '', $prod_name);
							/*Sets the cookies for remember password */
							if($this->post('remember')==1)
							{
								$expire	=	time()+60*60*24*30;
								setcookie($prod_name.'_adv_cookie_user_name',$this->post('uemail'),$expire,'/');
								setcookie($prod_name.'_adv_cookie_user_pwd',base64_encode($this->post('upw')),$expire,'/');
							}
							else
							{
								$expire	=	time()-60*60*24*30;
								setcookie($prod_name.'_adv_cookie_user_name','',$expire,'/');
								setcookie($prod_name.'_adv_cookie_user_pwd','',$expire,'/');	
							}
						}
						else if($advObj['dj_is_default']==1)
						{
							$response = array(
							'response' => 'error',
							'msg' => $this->lang->line('cnt_def_adv_acctn')
						);
						}
						else
						{
							$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  $this->lang->line('yr_acctn_temp_blkd').' '.$admin.','.$this->lang->line('please_contact_the').' '.$admin.' at '.$admin_email 
										 );
						}

					} else if ($adv_Temp_Obj != FALSE) {
						$response = array(
							'response' => 'error',
							'msg' => $this->lang->line('yr_accnt_appr')
						);

					}
					else
					{
						$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  $this->lang->line('ur_pwd_entered_incrt')
										 );
					}
					$this->response($response, 200);
				break;
				
				case "TRAFFICKER":
					
					$pubObj 	= 	$this->Do_publisher->validate_user($this->post('uemail'),$this->post('upw'),$this->post('acc_type'));

					$adv_Temp_Obj = $this->Do_publisher->validate_temp_user($this->post('uemail'), $this->post('upw'), $this->post('acc_type'));
					
					//$admin_details =$this->Do_advertiser->fetch_admin_details();
					
					$admin_details =$this->Do_advertiser->fetch_admin_details_new($this->post('uemail'), $this->post('upw'), $this->post('acc_type'));
					
					$admin_email = $admin_details[0]['email']; 
					
					$admin = $admin_details[0]['agencyid']; 
					
					$admin="administrator";

					if($pubObj != FALSE)
					{
						if($pubObj['denied']==0 && $pubObj['is_active']==1)
						{
							// CREATE SESSIONS for Publisher
							set_session($pubObj['account_type'],$pubObj);
							
							//UPDATE LOGIN COUNT INFORMATION
							if($_SERVER['REMOTE_ADDR']!='182.72.161.90'){
								//$this->update_login_count($pubObj);
							}
							
							if($pubObj['onetime_wizard']!='1')
							{
								$response  	= 	array(
												'response' 	=> 	'ok',
												'redirect'	=>	site_url('publisher/onetime_wizard'),
												'msg'	 	=> 	$this->lang->line('login_suc')
											);						
							}	
							else
							{
							
								$response 	= 	array(
													'response' 	=> 	'ok',
													'redirect'	=>	site_url('publisher/dashboard'),
													'msg'	 	=> 	$this->lang->line('login_suc')
												);											
							}
							$sitename=$pubObj['site_name'];
							$prod_name 	= 	$this->config->item('prod_name');
							if($sitename != ''){$prod_name 	=$sitename;}else{$prod_name 	=$prod_name;}
							//$prod_name 	= 	$this->config->item('prod_name');
							$prod_name = str_replace(' ', '', $prod_name);
							/*Sets the cookies for remember password */
							if($this->post('remember')==1)
							{
								$expire	=	time()+60*60*24*30;
								setcookie($prod_name.'_pub_cookie_user_name',$this->post('uemail'),$expire,'/');
								setcookie($prod_name.'_pub_cookie_user_pwd',base64_encode($this->post('upw')),$expire,'/');
							}
							else
							{
								$expire	=	time()-60*60*24*30;
								setcookie($prod_name.'_pub_cookie_user_name','',$expire,'/');
								setcookie($prod_name.'_pub_cookie_user_pwd','',$expire,'/');	
							}
						} else if ($adv_Temp_Obj != FALSE) {
							$response = array(
								'response' => 'error',
								'msg' => $this->lang->line('yr_accnt_appr')
							);

						}
						else
						{
							$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  $this->lang->line('ur_actn_temp_blckd_by').''.$admin.','. $this->lang->line('please_contact_the').' '.$admin.' at '.$admin_email 
										 );
						}
					} else if ($adv_Temp_Obj != FALSE) {
						$response = array(
							'response' => 'error',
							'msg' => $this->lang->line('yr_accnt_appr')
						);
							
					}
					else
					{
						$response 	= 	array(
											'response' 	=> 	'error',
											'msg' 		=>  $this->lang->line('ur_pwd_entd_incrct')
										 );
					}
					$this->response($response, 200);
				break;
			}

		}
		else
		{
			$this->response(array('error' => $this->lang->line('inv_user_type')), 200);
		}

	}


   	/*
	* 
	* name: create
	* @param :
	* @return : adv / pub details
	* 
    */
	public function create($advObj){

		if($advObj != FALSE){
			
			$account_ids		=	1;
			$type				=	'admin';
			$advObj['usr_signup'] ="temp_user";
			if($advObj['account_type'] == "ADVERTISER"){
				$advObj = $this->Do_advertiser->add($advObj);
			}else if($advObj['account_type'] === "TRAFFICKER"){
				$advObj = $this->Do_publisher->add($advObj);
			}

			// Send Mail to Advertiser & Manager

			if($advObj != FALSE){
				return $advObj;
			}
			else
			{
				return FALSE;
			}

		}
	}
		
	public function email_approve_get(){

		$temp_user_id = $this->get('user_id');
		$verification_code = $this->get('email_verification_code');
		$tempObj = $this->Do_advertiser->get_temp_user($temp_user_id,$verification_code);
        //~ $this->response($result,200);
		if($tempObj != FALSE){

			$advObj = $this->create($tempObj);
			$account_type=$advObj['account_type'];
			$user_email=$advObj['email'];
			$password=$advObj['password'];
			$user_name=$advObj['first_name']." ".$advObj['last_name'];
			
		    $success=$this->Do_advertiser->remove_temp_user($temp_user_id);

			// SEND APPROVAL EMAIL to USER
			$agency_id	=	$this->user_authentication->agency_id;
			$result=$this->Do_networks->agency_owner_details($agency_id);
			//$this->response($result,200);
			if($agency_id ==1)
			{			
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];
				if($account_type=="ADVERTISER")
				{
					$type="ADV_LOGIN_CREDENTIAL";
				}
				if($account_type=="PUBLISHER" || $account_type == "TRAFFICKER")
				{
					$type="PUB_LOGIN_CREDENTIAL";
				}
				
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				$mail_content=array(
					"subject" 		=> $this->lang->line('login_credentials'),
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,
					"password"		=> $password								
					);			
				send_mail($type,$from,$to,$mail_content);	
				if($success)
				{
					$this->response( $success, 200);
				}
				else
				{
					$error = array(
									'response' => 'error',
									'msg' =>  $this->lang->line('ur_acctn_ext_our_pack')
									);

					$this->response( $error, 200);
				}			
			}
			else
			{
				
				// IF NOT NETWORK ADMIN SEND BCC
				$network_admin=$this->Do_networks->get_network_details();
				$bcc		   = $network_admin['email'];
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];
					
				if($account_type=="ADVERTISER")
				{
					$type="ADV_LOGIN_CREDENTIAL";
				}
				if($account_type=="PUBLISHER" || $account_type == "TRAFFICKER")
				{
					$type="PUB_LOGIN_CREDENTIAL";
				}
				
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				$mail_content=array(
					"subject" 		=> $this->lang->line('login_credentials'),
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,
					"password"		=> $password								
					);
				$attachement = "";				
				send_mail($type,$from,$to,$mail_content,$attachement,$bcc);	
				if($success)
				{
					$this->response( $success, 200);
				}
				else
				{
					$error = array(
									'response' => 'error',
									'msg' =>  $this->lang->line('ur_acctn_ext_our_pack')
									);

					$this->response( $error, 200);
				}
			}		
			
	}
	else
	{
		$error = array(
						'response' => 'error',
						'msg' =>  $this->lang->line('ur_acctn_ext_our_pack')
						);

		$this->response( $error, 200);
	}
}
	
	

    public function signup_post(){
		
		$this->form_validation->set_rules('ufirstname','lang:first_name', 'trim|required');
		$this->form_validation->set_rules('ulastname', 'lang:last_name','trim|required');
		$this->form_validation->set_rules('logusername', 'lang:login_name','trim|required|callback_reg_login_username_check');
		$this->form_validation->set_rules('uemail', 'lang:email','trim|required|valid_email|callback_reg_email_check|is_unique[djax_temp_user.email]');
		$this->form_validation->set_rules('upw', 'lang:user_pass','trim|required');
		$this->form_validation->set_rules('uconfirm_password', 'lang:confirm_password','trim|required|matches[upw]');
		$this->form_validation->set_rules('account_type', 'lang:user_type','trim|required');          
                                  
 		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();

			 //$error_msg 	= transform_errors_to_array($this->form_validation->error_array());

			 $error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{
			
			$agencyid=$this->post('agencyid');
			// SENT EMAIL To Administrator and Users			
			
			$result=$this->Do_networks->get_network_details($agencyid);
			$encrypted_pwd = password_encryptor($this->post('upw'));
			$passwod = $this->post('upw');	
			$admin_name    = $result['firstname']." ".$result['lastname'];
			
			$admin_email   = $result['email'];
			 $approval_type = $result['approval_type'];
			
			if($approval_type=="Email Verification")
			{
				
				$activation_code = md5(time());
				$verify=1;
			
			}
			else
			{
				
				$activation_code = '';
				$verify=0;
			}
			
			$userObj = array(
							"first_name"	=>	clean_data($this->post('ufirstname')),
							"last_name"		=>	clean_data($this->post('ulastname')),
							"email"			=>	clean_data($this->post('uemail')),
							"login_username"=>	clean_data($this->post('logusername')),
							"agency_id"		=>	clean_data($this->post('agencyid')),
							"password"		=>	$encrypted_pwd,
							"account_type"	=>	clean_data($this->post('account_type')),
							"created_date"	=>	mdate('%Y-%m-%d %H:%i:%s',local_to_gmt()),
							"email_verification_code"=>	clean_data($activation_code),
							"email_verified" =>$verify,
							"site_url"		=>	clean_data($this->post('site_url')),
							"unenc_p"		=>	$passwod,
						);

			$temp_user_id=$this->Do_advertiser->create_temp_user($userObj);

			
			$user_name	   = $userObj['first_name']. " ". $userObj['last_name'] ;
			
			$user_email    = $userObj['email'];
			
			$user_account_type=$userObj['account_type'];
			
					
			if($approval_type=="Email Verification")
			{
				/* Send mail to advertiser/Publisher for activete their account */	
				
				if($user_account_type == "ADVERTISER")
				{
					$type 	= "ADV_APPROVE_EMAIL";
				}
				else
				{
					$type 	= "PUB_APPROVE_EMAIL";
				}
							
				
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				$mail_content=array(
				"subject" 		=> $this->lang->line('activate_your_account'),
				"to_name" 		=> $user_name,				
				"from_name"		=> $admin_name,
				"temp_user_id"  => $temp_user_id,
				"activation_code" =>$activation_code													
				);		
				
				send_mail($type,$from,$to,$mail_content);			
				
			}
			else
			{ 
				/* Send mail to Advertiser/Publisher for registration success  -Start  */
				/*Hided Advertiser and Publisher Sucess Emails */				
				if($user_account_type == "ADVERTISER")
				{
					$type 	= "ADV_REG_SUCCESS";
				}
				else
				{
					$type 	= "PUB_REG_SUCCESS";
				}
								
					$from 	=  $admin_email;
					$to  	=  $user_email;			
					$mail_content=array(
					"subject" 		=> $this->lang->line('registration_success'),
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name										
					);			
					send_mail($type,$from,$to,$mail_content);
				
				/* Send mail to Advertiser/Publisher -End  */	
					
					
				/* Send mail to Admin for Activate User Account  - Start*/	
				$user_first_name    = $userObj['first_name'];
				$user_last_name    	= $userObj['last_name'];
				$user_email    		= $userObj['email'];
			
					$type   ="ADMIN_APPROVE_EMAIL";
					$from 	=  $user_email;
					$to  	=  $admin_email;			
					$mail_content=array(
					"subject" 		=> $this->lang->line('apprv_user_acctn'),
					"to_name" 		=> $admin_name,				
					"from_name"		=> $user_name,
					"first_name" 		=> $user_first_name,				
					"last_name"		=> $user_last_name,
					"user_email" 		=> $user_email				
														
					);			
					send_mail($type,$from,$to,$mail_content);
					
					/* Send mail to Admin  - End  */
						
			}
			
            if($user_account_type=='TRAFFICKER')
			{
			   $user_account_type='PUBLISHER';
			}
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('user_registration/success/'.strtolower($user_account_type).'/'.$approval_type),
							'msg'	 => $this->lang->line('registration_success')
			);

			$this->response($success, 200);
		}

	}
	
	/*Email Check
	 * 
	 * 
	 * */ 
	
	function reg_email_check()
	{
		$email		=	strtolower($this->post('uemail'));
		$count 		= 	$this->Do_email_check->reg_email_check($email);
		
		if($count>0)
		{
			$this->form_validation->set_message('reg_email_check', $this->lang->line('email_cont_unique_value'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	/*Login User name duplication validation
	 * 05-09-2018
	 * Pradeep.M
	 * */
	function reg_login_username_check()
	{
		$username		=	strtolower($this->post('logusername'));
		$count 		    = 	$this->Do_email_check->login_username_check($username);
		
		if($count>0)
		{
			$this->form_validation->set_message('reg_login_username_check', $this->lang->line('username_cont_unique_value'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	/**
       * 
       * Mails the new password for users, who have forgotten their password.
       
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	

	public function forgot_password_post(){

		if($this->form_validation->run('user_forgot_password') === FALSE)
		{
		
			$error_msg = $this->form_validation->error_array();

			 //$error_msg 	= transform_errors_to_array($this->form_validation->error_array());

			 $error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}else{
		
			$role = array('ADVERTISER','PUBLISHER','ADMIN','MANAGER');
			
			// SENT EMAIL To User 	
			$advObj = $this->Do_advertiser->validate_email($this->post('uemail'),$this->post('acc_type'));
		
			$result=$this->Do_networks->get_network_details($advObj->agencyid);	
						
				
			$admin_name    = $result['firstname']." ".$result['lastname'];
			
			$admin_email   = $result['email'];	
			

			if($this->post('acc_type') !='' and in_array($this->post('acc_type'),$role)){

				switch(strtoupper($this->post('acc_type'))){
					case "ADVERTISER":
						
						$advObj = $this->Do_advertiser->validate_email($this->post('uemail'),$this->post('acc_type'));
						
						if($advObj != FALSE){

							//Generated the random password and updates in the ox_users table
							
							
							//$advObj = new StdClass();
							
							$advObj->new_password =  $this->update_new_password($advObj->accountid);
							
							
							// SENDS THE EMAIL TO CORRESPONDING ADVERTISER
							
							$user_name	   =  $advObj->name;
			
							//alter email usage for forgot pwd
							
							$post_email = $this->post('uemail');
							
							if($post_email==$advObj->alter_email){
							
							$user_email    =  $advObj->alter_email;	
							
							} else {
								
							$user_email    =  $advObj->email;
								
							}
							
							$type   ="ADV_FORGET_PASSWORD";
							$from 	=  $admin_email;
							$to  	=  $user_email;			
							$mail_content=array(
							"subject" 		=> $this->lang->line('advertiser_forget_password'),
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,
							"user_email"	=> $user_email,	
							"password"		=> $advObj->new_password 								
							);			
						     
							send_mail($type,$from,$to,$mail_content);
							
							
							
							
							if($advObj->new_password !='')
							{
								$response = array(
								'response' => 'ok',
								'redirect'=>site_url('user_login/'.strtolower($this->post('acc_type'))),
								'msg'	 => $this->lang->line('pwd_suc_email')
								);
								
							}else{
								
								$response = array(
								'response' => 'pass_error',
								'redirect'=>site_url('user_login/'.strtolower($this->post('acc_type'))),
								'msg'	 => $this->lang->line('unbl_send_mail')
							);	
							}	
						
						

						}
						else
						{
								$response = array(
										'response' => 'error',
										'msg' =>  $this->lang->line('entered_reg_adv_email')
									 );
						}
						$this->response($response, 200);
					break;
					
					case "PUBLISHER":
						

							$pubObj = $this->Do_advertiser->validate_email($this->post('uemail'),$this->post('acc_type'));

						if($pubObj != FALSE){

							//Generated the random password and updates in the ox_users table
							
							
							//$advObj = new StdClass();
							
							$pubObj->new_password =  $this->update_new_password($pubObj->accountid);
							
														
							// SENDS THE EMAIL TO CORRESPONDING PUBLISHER
							
							$post_email = $this->post('uemail');
							
							$user_name	   =  $pubObj->name;
			
							if($post_email==$pubObj->alter_email){
							
							$user_email    =  $pubObj->alter_email;	
							
							} else {
								
							$user_email    =  $pubObj->email;
								
							}		
							
							$type   ="PUB_FORGET_PASSWORD";
							$from 	=  $admin_email;
							$to  	=  $user_email;			
							$mail_content=array(
							"subject" 		=> $this->lang->line('pub_for_pass'),
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,
							"user_email"	=> $user_email,	
							"password"		=> $pubObj->new_password 								
							);			
							send_mail($type,$from,$to,$mail_content);
							
							
							if($pubObj->new_password !='')
							{
								$response = array(
								'response' => 'ok',
								#'redirect'=>site_url('user_login/'.strtolower($this->post('acc_type'))),
								'msg'	 => $this->lang->line('pwd_suc_email')
								);
								
							}else{
								
								$response = array(
								'response' => 'pass_error',
								'redirect'=>site_url('user_login/'.strtolower($this->post('acc_type'))),
								'msg'	 => $this->lang->line('unbl_send_mail')
							);	
							}	

                    	}
						else
						{
								$response = array(
										'response' => 'error',
										'msg' =>  $this->lang->line('ent_email_reg_pub_email')
									 );
						}
						$this->response($response, 200);
					break;
				case "ADMIN":
						
							$adminObj = $this->Do_advertiser->validate_email($this->post('uemail'),$this->post('acc_type'));

						if($adminObj != FALSE){

							//Generated the random password and updates in the ox_users table
							
							
							//$advObj = new StdClass();
							
							$adminObj->new_password =  $this->update_new_password_networks($adminObj->userid);
						
							// SENDS THE EMAIL TO CORRESPONDING ADMIN
							
							$first_name	   =  $adminObj->fname;
							
							#$last_name	   =  $adminObj->lname;
			
							$post_email = $this->post('uemail');
							
							if($post_email==$adminObj->alter_email){
							
							$user_email    =  $adminObj->alter_email;	
							
							} else {
								
							$user_email    =  $adminObj->email;
								
							}	
							
							$type   ="ADMIN_FORGET_PASSWORD";
							$from 	=  $admin_email;
							$to  	=  $user_email;			
							$mail_content=array(
							"subject" 		=> $this->lang->line('forget_password'),
							"to_name" 		=> $first_name,				
							"from_name"		=> $admin_name,
							"user_email"	=> $user_email,	
							"password"		=> $adminObj->new_password 								
							);			
							send_mail($type,$from,$to,$mail_content);
							
							
							if($adminObj->new_password !='')
							{
								$response = array(
								'response' => 'ok',
								#'redirect'=>site_url('user_login/'.strtolower($this->post('acc_type'))),
								'msg'	 => $this->lang->line('pwd_suc_email')
								);
								
							}else{
								
								$response = array(
								'response' => 'pass_error',
								'redirect'=>site_url('user_login/'.strtolower($this->post('acc_type'))),
								'msg'	 => $this->lang->line('unbl_send_mail')
							);	
							}	

                    	}
						else
						{
								$response = array(
										'response' => 'error',

										'msg' =>  $this->lang->line('ent_email_reg_admin')
									 );
						}
						$this->response($response, 200);
					break;
					
					case "MANAGER":
						
							$adminObj = $this->Do_advertiser->validate_email($this->post('uemail'),$this->post('acc_type'));
                           
						if($adminObj != FALSE){

							//Generated the random password and updates in the ox_users table
							
							
							//$advObj = new StdClass();
							
							$adminObj->new_password =  $this->update_new_password($adminObj->user_id,$this->post('acc_type'));
							
							
							// SENDS THE EMAIL TO CORRESPONDING ADMIN
							
							$first_name	   =  $adminObj->fname;
							
							#$last_name	   =  $adminObj->lname;
			
							$user_email    =  $adminObj->email;	
							
							$type   ="MANAGER_FORGET_PASSWORD";
							$from 	=  $admin_email;
							$to  	=  $user_email;			
							$mail_content=array(
							"subject" 		=> $this->lang->line('manager_forget_password'),
							"to_name" 		=> $first_name,				
							"from_name"		=> $admin_name,
							"user_email"	=> $user_email,	
							"password"		=> $adminObj->new_password 								
							);			
							send_mail($type,$from,$to,$mail_content);
														
							if($adminObj->new_password !='')
							{
								$response = array(
								'response' => 'ok',
								#'redirect'=>site_url('user_login/'.strtolower($this->post('acc_type'))),
								'msg'	 => $this->lang->line('pwd_suc_email')
								);
								
							}else{
								
								$response = array(
								'response' => 'pass_error',
								'redirect'=>site_url('user_login/'.strtolower($this->post('acc_type'))),
								$this->lang->line('unbl_send_mail')
							);	
							}	

                    	}
						else
						{
								$response = array(
										'response' => 'error',
										$this->lang->line('ent_reg_admin')
									 );
						}
						$this->response($response, 200);
					break;
				}

			}
			else
			{
				$this->response(array('error' => $this->lang->line('inv_user_type')), 200);
			}
		}	
	}
	
	
	/** ONLY FOR ADV AND PUB
       * Generates the new password and update the new password
       * 
       * @param $account_id Account id of the publisher (or) advertiser
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	public function update_new_password($account_id ='',$acc_type=FALSE)
	{
		if(!empty($account_id))
		{
		
			$this->load->helper('string');
		
			$new_pass = random_string('alnum',8);
			if($acc_type==FALSE){
			$result = $this->Do_advertiser->update_new_password($account_id,$new_pass);
			}
			if($result)
			{
				return $new_pass;
			}else{
				return FALSE;	
			}
		}else{
			return FALSE;	
		}		
	}
	
	
	/** ONLY FOR ADMIN / MANAGERS
       * Generates the new password and update the new password
       * @param $account_id Account id of the publisher (or) advertiser
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	public function update_new_password_networks($user_id)
	{
		if(!empty($user_id))
		{
			$this->load->helper('string');
		    $new_pass = random_string('alnum',8);
			$result = $this->Do_advertiser->update_new_password_networks($user_id,$new_pass);
			if($result)
			{
				return $new_pass;
			}else{
				return FALSE;	
			}
		}else{
			return FALSE;	
		}		
	}
	

	public function profile_info_post(){
		
		if($this->post('account_id') && $this->post('account_type')){
		
				switch(strtoupper($this->post('account_type'))){
					case "ADVERTISER":
						$user_info = $this->Do_advertiser->get_profile($this->post('account_id'));
						$response = array(
								'response' => 'ok',
								'user'	 => $user_info
								);
						$this->response($response);
						break;	
					case "TRAFFICKER":
						$user_info = $this->Do_publisher->get_profile($this->post('account_id'));
						$response = array(
								'response' => 'ok',
								'user'	 => $user_info
								);
						$this->response($response);
						break;			
					case "ADMIN":
						$user_info = $this->Do_networks->get_profile($this->post('account_id'));
						$response = array(
								'response' => 'ok',
								'user'	 => $user_info
								);
						$this->response($response);
						break;
					case "MANAGER":
						$user_info = $this->Do_network_managers->get_manager_profile($this->post('account_id'));
						$response = array(
								'response' => 'ok',
								'user'	 => $user_info
								);
						$this->response($response);
						break;		
				}
		}
		else
		{
			$this->response(array('error' => $this->lang->line('inv_para')), 200);
		}
	}
	
	public function get_agency_id_get()
	{
	   $agency_id=$this->Do_networks->get_agency();
	   if($agency_id)
	     $this->response($agency_id,200);
	}
	
	/*UPDATE LOGIN DETAILS*/
	public function update_login_count($login_details)
	{	
		if($login_details['account_type']=='TRAFFICKER')
		{
			$agency_id=$login_details['agency_id'];
		}
		else{
			$agency_id=$login_details['agencyid']; 
		} 
	   
		$manager_name=$this->Do_networks->agency_owner_details($agency_id);

		if(isset($login_details['last_name']))
		{
			$name=$login_details['last_name'];
		}
		else
		{
			$name='';
		}
	   $demo_mail = $this->default_configurations->get('demo_mail');
	   //Get City,Country 
		if($_SERVER['REMOTE_ADDR']!='::1')
		{
			$ip=$_SERVER['REMOTE_ADDR'];
			/*
			$details = json_decode(file_get_contents("http://ipinfo.io/{$ip}/json"));
			$city=$details->city;
			if(empty($city)){
			$city='unknown';
			}
			$state=$details->region;
			if(empty($state)){
			$city='unknown';
			}
			$country=$details->country;
			if(empty($country)){
			$city='unknown';
			}*/
			$user_details=array( 'account_id'=>$login_details['account_id'],
								'net_name'=>$manager_name['name'],
								'f_name'=>$login_details['first_name'],
								'l_name'=>$name,
								'email_id'=>$this->post('uemail'),
								'login_time'=>date("Y-m-d H:i:s"),
								'ip_address'=>$_SERVER['REMOTE_ADDR']
							  );
			$this->Do_networks->update_login_details($user_details);

			// SENDS THE EMAIL TO CORRESPONDING ADVERTISER
	    
			$result=$this->Do_networks->get_network_details($agency_id);			
			$admin_name    = $result['firstname']." ".$result['lastname'];
			$admin_email   = $result['email'];	
			
			$type   ="DEMO_VIEWERS";
			$from 	=  $admin_email;
			$to  	=  $demo_mail;			
		
			$mail_content=array(
			"subject" 		=> $this->lang->line('demo_viewer'),
			"to_name" 		=> "",				
			"from_name"		=> $admin_name,
			"viewer_name"	=> $login_details['first_name'].''.$name,	
			"Login_email_id"=> $this->post('uemail'),
			"ip_address" =>  $_SERVER['REMOTE_ADDR']
			/*"city"      =>  $city,
			"state"     =>  $state,
			"country"     => $country
			*/
			);			
			send_mail($type,$from,$to,$mail_content);
		}
	}
	
	/*UPDATE LOGIN-OUT DETAILS*/
	public function logout_info_post()
    {
		$acc_id=$this->post('account_id');
		if($acc_id)
		{	
			date_default_timezone_set("Asia/Kolkata");
			$data=array('logout_time'=>date("Y-m-d H:i:s"),'account_id'=>$acc_id);
			$res=$this->Do_networks->update_logout_details($data);
			// SENDS THE EMAIL TO CORRESPONDING ADVERTISER
			$result=$this->Do_networks->get_network_details();			
			$admin_name    = $result['firstname']." ".$result['lastname'];
			$admin_email   = $result['email'];	
			$demo_mail = $this->default_configurations->get('demo_mail');
			$type   ="DEMO_VIEWERS";
			$from 	=  $admin_email;
			$to  	=  $demo_mail;			

			$mail_content=array(
				"subject" 		=> $this->lang->line('demo_viewer'),
				"to_name" 		=> "",				
				"from_name"		=> $admin_name,
				"viewer_name"	=> $res['f_name'].''.$res['l_name'],	
				"Login_email_id"=> $res['email_id'],
				"ip_address" =>  $_SERVER['REMOTE_ADDR'],
				"time_interval"=> $res['interval']
				);			
			send_mail($type,$from,$to,$mail_content);
		}
	}
	
	
	
	public function get_admin_invoice_get()
	{	
         
        if($this->get('startdate')==FALSE) {
			echo $this->lang->line('plz_provd_start_date');exit;
		}
		else if($this->get('enddate')==FALSE) {
			echo $this->lang->line('plz_provd_end_date');exit;
		}
		else if($this->get('period')==FALSE) {
			echo $this->lang->line('plz_provd_per');exit;
		}
        
        $start_date 		= $this->get('startdate');
		$end_date 			= $this->get('enddate');
		$period_days 		= $this->get('period');
		
		$this->load->model('api.v_1/Do_invoices','Do_invoices');
		$t=$this->Do_invoices->generate_network_invoices($start_date,$end_date,$period_days);
		print_r($t);
	}
	public function get_invoice_get()
	{	

        if($this->get('startdate')==FALSE) {
			echo $this->lang->line('plz_provd_start_date');exit;
		}
		else if($this->get('enddate')==FALSE) {
			echo $this->lang->line('plz_provd_end_date');exit;
		}
		else if($this->get('period')==FALSE) {
			echo $this->lang->line('plz_provd_per');exit;
		}
        
        $start_date 		= $this->get('startdate');
		$end_date 			= $this->get('enddate');
		$period_days 		= $this->get('period');
		
		$this->load->model('api.v_1/Do_invoices','Do_invoices');
		$t=$this->Do_invoices->generate_invoices($start_date,$end_date,$period_days);
		print_r($t);
	}
}
