<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Targeting extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->library('csvreader');
		$this->load->model('Do_targeting');
		$this->load->model('Do_email_check');
		$this->load->model('Do_campaign');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key');
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }

	}
	/*
	 * name: browser_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set browser targeting for a campaign
	 * 
	 */
	public function browser_targeting_post()
	{
			//Prepare the target data
			$campaign_id='';
			$prepared_data='';
			$compiledlimitation_prefix='';
			$compiledlimitation_suffix='';
			$compiledlimitation='';
			$acl_plugins='';
			
			$targ_value = $this->post('value');


			if(!empty($targ_value))
			{
				foreach($targ_value as $data)
				{
					$prepared_data .= $data.',';
				}
				$prepared_data=substr($prepared_data, 0, -1);
			}
			else
			{
				$prepared_data =FALSE;
			}

				$campaign_id = $this->post('pk');
				$logical="or";
				$type="deliveryLimitations:Client:Browser";
				$comparison= "==";
				$executionorder="0";

				$ox_acls_data=	array(

								"campaignid"=> $campaign_id,
								"logical"=> $logical,
								"type"=> $type,
								"comparison"=> $comparison,
								"data"=> $prepared_data,
								"executionorder"=> $executionorder,
								);
						
			if($prepared_data!=FALSE)
			{
						
				$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
			}
			else
			{
				
				$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
					
			}

			if($ox_acls !== FALSE)
			{
				$success = array(
					'response' 	=> 'ok',
					'msg'	 	=> $this->lang->line('camp_target_suc')
					
				);
				$this->response($success,200); 
			}
			else
			{
				$error = array(
					'response' 	=> 'error',
					'msg'	 	=> $this->lang->line('error_try_again')
					);
				$this->response($error,200); 
			}
	}
	/*
	 * name: os_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set os targeting for a campaign
	 * 
	 */
	public function os_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="deliveryLimitations:Client:Os";
			$comparison= "==";
			$executionorder="1";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> $this->lang->line('camp_target_suc')
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('error_try_again')
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: time_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set os targeting for a campaign
	 * 
	 */
	public function time_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="deliveryLimitations:Time:Hour";
			$comparison= "==";
			$executionorder="2";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> $this->lang->line('camp_target_suc'),
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('error_try_again')
				
				);
			$this->response($error,200); 
		}
	}
	
	

	/*
	 * name: geo_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set geo targeting for a campaign
	 * 
	 */
	public function geo_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="deliveryLimitations:Geo:Country";
			$comparison= "==";
			$executionorder="3";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> $this->lang->line('camp_target_suc')
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('error_try_again')
				
				);
			$this->response($error,200); 
		}
	}
	
	
	
	/*
	 * name: profile_targeting_domain_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set keyword targeting for a campaign
	 * 
	 */
	public function profile_targeting_domain_post()
	{
		//Prepare the target data
		$campaign_id				=	'';
		$prepared_data				=	'';
		$compiledlimitation_prefix	=	'';
		$compiledlimitation_suffix	=	'';
		$compiledlimitation			=	'';
		$acl_plugins				=	'';
		
		$targ_value = $this->post('domain_link');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

		$campaign_id 	= 	$this->post('camp_id');
		$logical		=	"or";
		$type			=	"domain";
		$comparison		= 	"==";
		$executionorder	=	"10";

		$ox_acls_data=	array(
								"campaignid"	=> 	$campaign_id,
								"logical"		=> 	$logical,
								"type"			=> 	$type,
								"comparison"	=> 	$comparison,
								"data"			=> 	$prepared_data,
								"executionorder"=> 	$executionorder,
							);
			if($prepared_data=="as"){
			$prepared_data=false;
			}					
		if($prepared_data!=FALSE)
		{
			$ox_acls	=	$this->Do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls	=	$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
							'response' 	=> 'ok',
							'msg'	 	=> $this->lang->line('camp_target_suc')							
						);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
							'response' 	=> 'error',
							'msg'	 	=> $this->lang->line('error_try_again')				
						);
			$this->response($error,200); 
		}
	}
	
	
	
	public function fetch_domain_data_get()
	{
		$id = $this->get('campaign_id');
		$type			=	"domain";
		if($id){
		$domain_list = $this->Do_targeting->fetch_domain_select_data($id , $type);
		$this->response($domain_list);
	   }
	} 
	
	
	
	
	
	/*
	 * name: frequency_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method frequency for the campaign is set
	 * 
	 */
	public function frequency_targeting_post()
	{
		
		$targ_value = $this->post('value');

		if($targ_value['targ_capping']!=''){
			$capping=$targ_value['targ_capping'];}
		else{
			$capping='0';}
			
		if($capping!=' ')
		{
			$campaign_id = $this->post('pk');

			$block=$targ_value['targ_capping_block']*3600;
		
			$ox_campaigns_frquency_data=	array("block"=> $block,"session_capping"=> $capping);

			$ox_campaigns_frquency=$this->Do_targeting->update_capping($ox_campaigns_frquency_data,$campaign_id);

			if($ox_campaigns_frquency !== FALSE)
			{
				$success = array(
					'response' 	=> 'ok',
					'msg'	 	=> $this->lang->line('camp_target_suc')
					
				);
				$this->response($success,200); 
			}
			else
			{
				$error = array(
					'response' 	=> 'error',
					'msg'	 	=> $this->lang->line('error_try_again')
					
					);
				$this->response($error,200); 
			}
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('error_try_again')
				
				);
			$this->response($error,200); 
		}
	}

	/*
	 * name: mobile_os_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set mobile os targeting for a campaign
	 * 
	 */
	public function mobile_os_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="os";
			$comparison= "==";
			$executionorder="0";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> $this->lang->line('camp_target_suc')
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('error_try_again')
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: mobile_manu_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set mobile manufractures targeting for a campaign
	 * 
	 */
	public function mobile_manu_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="handset";
			$comparison= "==";
			$executionorder="1";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> $this->lang->line('camp_target_suc')
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('error_try_again')
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: mobile_capability_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set mobile capability targeting for a campaign
	 * 
	 */
	public function mobile_capability_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="capability";
			$comparison= "==";
			$executionorder="2";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> $this->lang->line('camp_target_suc')
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('error_try_again')
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: mobile_telecom_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set mobile capability targeting for a campaign
	 * 
	 */
	public function mobile_telecom_targeting_post()
	{
	
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="teleco";
			$comparison= "==";
			$executionorder="3";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> $this->lang->line('camp_target_suc'),
				'tele' => $prepared_data,
                'sorted' => $check
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('error_try_again')
				
				);
			$this->response($error,200); 
		}
	}
	/*
	 * name: mobile_geo_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will set mobile geo targeting for a campaign
	 * 
	 */
	
	public function mobile_geo_targeting_post()
	{
	
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="country";
			$comparison= "==";
			$executionorder="4";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
								
		if($prepared_data!=FALSE)
		{
			//~ $this->response($prepared_data,200);
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
			$where_city=array('campaignid'=>$campaign_id,'type'=>'city');
			$ox_acls_city = $this->Do_campaign->fetch_camapign_targeting_acls($where_city);
			if($ox_acls_city != ''){
			$city_details = $ox_acls_city[0]['data'];
			//$country_data = explode(",", $prepared_data);
			$city_data = explode(",", $city_details);
			$city_prepared_data=FALSE;
			foreach($city_data as $key=>$citydata){
				$city_datas = explode("|", $citydata);
				if (strpos($prepared_data,$city_datas[0]) !== false) 
				{
					$city_prepared_data .= $citydata.',';
				}else{
						 // echo 'no data: ';
				 }
			}
			$city_prepared_data=substr($city_prepared_data, 0, -1);
			//print_r($region_prepared_data);exit;$campaign_id    = $this->post('pk');
				$city_logical        = "or";
				$city_type           = "city";
				$city_comparison     = "==";
				$city_executionorder = "4";
				$city_acls_data   = array(
					"campaignid" => $campaign_id,
					"logical" => $city_logical,
					"type" => $city_type,
					"comparison" => $city_comparison,
					"data" => $city_prepared_data,
					"executionorder" => $city_executionorder
				);
		
			$city_ox_acls=$this->Do_targeting->add($city_acls_data,$campaign_id);
			}
			
			$where_teleco=array('campaignid'=>$campaign_id,'type'=>'teleco');
			$ox_acls_teleco = $this->Do_campaign->fetch_camapign_targeting_acls($where_teleco);
			if($ox_acls_teleco != ''){
			$teleco_details = $ox_acls_teleco[0]['data'];
			//$country_data = explode(",", $prepared_data);
			$teleco_data = explode(",", $teleco_details);
			$teleco_prepared_data=FALSE;
			foreach($teleco_data as $key=>$telecodata){
				$teleco_datas = explode("|", $telecodata);
				if (strpos($prepared_data,$teleco_datas[0]) !== false) 
				{
					$teleco_prepared_data .= $telecodata.',';
				}else{
						 // echo 'no data: ';
				 }
			}
			$teleco_prepared_data=substr($teleco_prepared_data, 0, -1);
			//print_r($region_prepared_data);exit;$campaign_id    = $this->post('pk');
				$teleco_logical        = "or";
				$teleco_type           = "teleco";
				$teleco_comparison     = "==";
				$teleco_executionorder = "4";
				$teleco_acls_data   = array(
					"campaignid" => $campaign_id,
					"logical" => $teleco_logical,
					"type" => $teleco_type,
					"comparison" => $teleco_comparison,
					"data" => $teleco_prepared_data,
					"executionorder" => $teleco_executionorder
				);
		
			$teleco_ox_acls=$this->Do_targeting->add($teleco_acls_data,$campaign_id);
			}
		
			
		}
		else
		{
			
			//~ $this->response('$ox_acls_isp',200);
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
			$isp_logical        = "or";
			$isp_type           = "city";
			$isp_comparison     = "==";
			$isp_executionorder = "4";
			$city_acls_data   = array(
				"campaignid" => $campaign_id,
				"logical" => $isp_logical,
				"type" => $isp_type,
				"comparison" => $isp_comparison,
				"data" => FALSE,
				"executionorder" => $isp_executionorder
			);
			$ox_acls=$this->Do_targeting->delete($city_acls_data,$campaign_id);
			$isp_logical        = "or";
			$isp_type           = "teleco";
			$isp_comparison     = "==";
			$isp_executionorder = "4";
			$isp_acls_data   = array(
				"campaignid" => $campaign_id,
				"logical" => $isp_logical,
				"type" => $isp_type,
				"comparison" => $isp_comparison,
				"data" => FALSE,
				"executionorder" => $isp_executionorder
			);
			//$this->response($ox_acls_data,200);
			$ox_acls=$this->Do_targeting->delete($isp_acls_data,$campaign_id);
	//~ $this->response($ox_acls,200);
			//~ $ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id); 		
		}

		if($ox_acls !== FALSE)
		{
			
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> $this->lang->line('camp_target_suc'),
				'cty'		=> $prepared_data,
				
				
			);
			$this->response($success,200); 
		}
		else
		{
			
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('error_try_again')
				
				);
			$this->response($error,200); 
		}
	}
	/*  Start domain targeting operations  */
	
	
	 /*
   * 
   * name: add_browser_post
   * @param : none
   * @return :lastinsertid
   * 
   */
	function add_domain_post(){
		
		$this->form_validation->set_rules('domain_name', 'Domain name', 'required|trim|is_unique['.TAB_TARG_DOMAIN.'.name]');
		$this->form_validation->set_message('is_unique', 'Already this Domain name is being registered. please enter the unique one');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->Do_targeting->add_domain($this->post());
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Domain has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding domain!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
	
	
	
	
	/*
   * 
   * name: fetch_domain_get
   * @param : none
   * @return :all the domain details.
   * 
   */
	public function fetch_domain_get()
	{
       $domain_list=$this->Do_targeting->fetch_domain();

	   $this->response($domain_list); 
	}
	
	/*
   * 
   * name: domain_list_get
   * @param : none
   * @return :slected  domain details.
   * 
   */
	public function domain_list_get(){
	   $id = $this->get('id');
	   if($id){
	   $domain_list = $this->Do_targeting->fetch_domain_select($id);
	   $this->response($domain_list);
       }
	}
	
	
	
	
	  /*
   * 
   * name: update_browser_post
   * @param : none
   * @return : browser id
   * 
   */ 
	public function update_domain_post()
	{
	 //if($_POST['domain_name_old'] != $_POST['domain_name'])
	 $domain_name_old = $this->input->post('domain_name_old');
	 $domain_name = $this->input->post('domain_name');
	 if($domain_name_old  != $domain_name )
	  {
	  
	   // $this->form_validation->set_rules('domain_name', 'Domain name', 'required|trim');
	    $this->form_validation->set_rules('domain_name', 'Domain name', 'required|trim|is_unique['.TAB_TARG_DOMAIN.'.name]');	
		$this->form_validation->set_message('is_unique', 'Already this Domain name is being registered. please enter the unique one');		// Checking - unique or not.
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->Do_targeting->update_domain($this->post());
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Domain has been updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding domain!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	else
	{
		$success = array(
									'response' => 'ok',
									'msg'	 => 'Domain has been updated successfully!..'
					);
				
				$this->response( $success, 200);
	}
}
	

	
	
	/*
   * 
   * name: delete_domain_get
   * @param : none
   * @return : status true or false
   * 
   */

	public function delete_domain_get()
   {
      $id = $this->get('del_domain_id');
      
    ///  print_r($id); exit;
	  
	   if($id)
		{
			$browser_list = $this->Do_targeting->delete_domain($id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Domain has been deleted'
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Domain id is not found'
					);
			
			$this->response( $error, 200);
		}

   }
	
	
	
	
	
	
	/*  End  domain targeting operations  */
	
	
	
	
	
	
	
  /*
   * 
   * name: add
   * @param : categoryname,categoryvalue
   * @return :lastinsertid
   * 
   * Fetch list of n/w users (pub or adv)
   */
	public function add_post(){
		
		$this->form_validation->set_rules('category_name', 'lang:category_name', 'required|trim');
		#$this->form_validation->set_message('is_unique', 'Already this category name is being registered. please enter the unique one');
		#$this->form_validation->set_rules('category_value', 'Category Value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$category_name	= $this->post('category_name');
			$parent_value 	= $this->post('parent_value');
		
			
			
			$ins_data = array('category_name'		=>$category_name,
							  'value'				=>$parent_value,
						      'parent_category_id'	=>$parent_value
						      );
				
			$category = $this->Do_targeting->add_category($ins_data);
			$final_cat_val 	= $parent_value.'-'.$category;
			
			$update_main 	= $this->Do_targeting->update_category_value($category,$final_cat_val);
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('category_successfully_added')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_category')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
   /*
   * 
   * name: fetch
   * @param : 
   * @return :all the creatives details need to be approve
   * 
   */
	public function fetch_get()
	{
		 $cat_list = $this->Do_targeting->fetch();
		 $this->response($cat_list);
	}
	
   /*
   * 
   * name: fetch_select
   * @param : category_id
   * @return :categoryname,categoryvalue
   * 
   */
	public function category_get()
	{
	    $cat_id = $this->get('category_id');
	   if($cat_id){
	   $cat_list = $this->Do_targeting->fetch_select($cat_id);
	   $this->response($cat_list);
	 }
	   
   }
   
   /*
   * 
   * name: update_category
   * @param : categoryname,categoryvalue,categoryid
   * @return : category id
   * 
   */
   public function update_category_post()
   {
		$this->form_validation->set_rules('category_name', 'lang:category_name', 'required|trim');
		#$this->form_validation->set_message('is_unique', 'Already this category name is being registered. please enter the unique one');
		#$this->form_validation->set_rules('category_value', 'Category Value', 'required|trim');
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category_update = $this->Do_targeting->update_category($this->post());
			
			if($category_update !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('category_success_updated')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_category')
					);
				
				$this->response( $success, 200);
			}
	   }		
   }
   
  /*
   * 
   * name: delete_category
   * @param : categoryid
   * @return : status true or false
   * 
   */
   
   public function delete_category_get()
   {
      $cat_id = $this->get('category_id');
       

	   if($cat_id)
		{
			$chk_cat_parent = $this->Do_targeting->check_category($cat_id);
			if($chk_cat_parent[0]['parent_category_id']==0)
			{
				$cat_list 		= $this->Do_targeting->delete_assoc_category($cat_id,$chk_cat_parent[0]['value']);
			}
			else
			{
				
				$cat_list 		= $this->Do_targeting->delete_category($cat_id);
			}
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('cat_delet')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('cat_not_found')
					);
			
			$this->response( $error, 200);
		}

   }
   
   
   /*
   * 
   * name: add_os_post
   * @param : none
   * @return :lastinsertid
   * 
   */
   
	function add_os_post(){
		
		$this->form_validation->set_rules('device_os', 'lang:device_name', 'required|trim|is_unique['.TAB_TARG_OS.'.name]');
		$this->form_validation->set_message('is_unique', $this->lang->line('alrdy_os_reg_plz_unique'));
		$this->form_validation->set_rules('os_value', 'lang:OS_value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->Do_targeting->add_os($this->post('device_os'),$this->post('os_value'));
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('os_added_suc')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('os_adding_problem')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}

   /*
   * 
   * name: fetch_os_get
   * @param : none
   * @return :all the os details.
   * 
   */
   
	public function fetch_os_get()
	{
		 $os_list = $this->Do_targeting->fetch_os();
		 $this->response($os_list);
	}
	
   /*
   * 
   * name: os_list_get
   * @param : none
   * @return :selected os details.
   * 
   */
	public function os_list_get()
	{
	   $id = $this->get('id');
	   if($id){
	   $os_list = $this->Do_targeting->fetch_os_select($id);
	   $this->response($os_list);
       }
	}
	
   /*
   * 
   * name: update_os_post
   * @param : none
   * @return : os id
   * 
   */ 
	public function update_os_post()
	{
	    $this->form_validation->set_rules('device_os', 'lang:device_name', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Device name is being registered. please enter the unique one');
		$this->form_validation->set_rules('os_value', 'lang:OS_value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$operating_sys = $this->Do_targeting->update_os($this->post());
			
			if($operating_sys !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('os_updated_suc')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_updating_os')
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	
	}
	
   /*
   * 
   * name: delete_os_get
   * @param : none
   * @return : status true or false
   * 
  */
   public function delete_os_get()
   {
      $id = $this->get('del_os_id');
	  
	   if($id)
		{
			 $cat_list = $this->Do_targeting->delete_os($id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('os_deleted')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('os_not_found')
					);
			
			$this->response( $error, 200);
		}

   }
   
    /*
   * 
   * name: add_browser_post
   * @param : none
   * @return :lastinsertid
   * 
   */
	function add_browser_post(){
		
		$this->form_validation->set_rules('browser_name', 'lang:browser_name', 'required|trim|is_unique['.TAB_TARG_BROWSERS.'.name]');
		$this->form_validation->set_message('is_unique', $this->lang->line('browser_registered_message'));
		$this->form_validation->set_rules('browser_code', 'lang:browser_code', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->Do_targeting->add_browser($this->post());
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('brwsr_added_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_brwsr')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}

   /*
   * 
   * name: fetch_browsers_get
   * @param : none
   * @return :all the browser details.
   * 
   */
	public function fetch_browsers_get()
	{
       $browser_list=$this->Do_targeting->fetch_browser();

	   $this->response($browser_list); 
	}
	
	/*
   * 
   * name: browser_list_get
   * @param : none
   * @return :slected  browser details.
   * 
   */
	public function browser_list_get(){
	   $id = $this->get('id');
	   if($id){
	   $browser_list = $this->Do_targeting->fetch_browser_select($id);
	   $this->response($browser_list);
       }
	}
  
    /*
   * 
   * name: update_browser_post
   * @param : none
   * @return : browser id
   * 
   */ 
	public function update_browser_post()
	{
	   
		$this->form_validation->set_rules('browser_name', 'lang:browser_name', 'required|trim|edit_unique['.TAB_TARG_BROWSERS.'~name~id~'.$this->post('browser_id').']');
		$this->form_validation->set_rules('browser_code', 'lang:browser_code', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->Do_targeting->update_browser($this->post());
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('brwsr_update_suc')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_adding_brwsr')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
	/*
   * 
   * name: delete_browser_get
   * @param : none
   * @return : status true or false
   * 
   */

	public function delete_browser_get()
   {
      $id = $this->get('del_browser_id');
	  
	   if($id)
		{
			$browser_list = $this->Do_targeting->delete_browser($id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('brwsr_deleted')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('brwsr_id_ntfound')
					);
			
			$this->response( $error, 200);
		}

   }

  /*
   * 
   * name: add_manu_post
   * @param : manuname,manuvalue
   * @return :lastinsertid
   * 
   */
   function add_manu_post(){
		
		$this->form_validation->set_rules('manu_name', 'lang:manufacturers_name', 'required|trim|is_unique['.TAB_MOB_MANUFACT.'.name]');
		$this->form_validation->set_message('is_unique', $this->lang->line('manufactures_registered_message'));
		$this->form_validation->set_rules('manu_value', 'lang:manufacturers_value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$manu_id = $this->Do_targeting->add_manu($this->post());
			
			if($manu_id !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('manu_added_suc')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_manu')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
  /*
   * 
   * name: fetch_manu_get
   * @param : none
   * @return :all the manufacturers details.
   * 
   */
	public function fetch_manu_get()
	{
       $manu_list=$this->Do_targeting->fetch_manu();
	   $this->response($manu_list); 
	}
	
  /*
   * 
   * name: manu_list_get
   * @param : none
   * @return :all the selected manufacturers details.
   * 
   */
	public function manu_list_get(){
	   $id = $this->get('id');
	   if($id){
	   $manu_list = $this->Do_targeting->fetch_manu_select($id);
	   $this->response($manu_list);
       }
	}
	
   /*
   * 
   * name: update_manu_post
   * @param : none
   * @return : category id
   * 
   */
	public function update_manu_post(){
	    
		$this->form_validation->set_rules('manu_name', 'lang:manufacturers_name', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Manufacturers name is being registered. please enter the unique one');
		$this->form_validation->set_rules('manu_value', 'lang:manufacturers_value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$manu_id = $this->Do_targeting->update_manu($this->post());
			
			if($manu_id !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('manu_added_suc')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_manu')
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	}
	
   /*
   * 
   * name: delete_manu_get
   * @param : manufacturers id
   * @return : status true or false
   * 
   */
   
	public function delete_manu_get(){
	  
	  $id = $this->get('manu_id');
	  
	   if($id)
		{
			$manu_list = $this->Do_targeting->delete_manu($id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('manu_deleted')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('manu_not_found')
					);
			
			$this->response( $error, 200);
		}
	
	}
	
	
   /*
   * 
   * name: add_mobile_os_post
   * @param : none
   * @return :lastinsertid
   * 
   */
   
	function add_mobile_os_post(){
		
		$this->form_validation->set_rules('device_os', 'lang:mobile_os_name', 'required|trim');
		$this->form_validation->set_rules('os_value', 'lang:mobile_os_value', 'required|trim|is_unique['.TAB_TARG_MOB_OS.'.value]');
		$this->form_validation->set_message('is_unique', $this->lang->line('mobileos_value_exists_message'));
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$mobile_os = $this->Do_targeting->add_mobile_os($this->post('device_os'),$this->post('os_value'));
			
			if($mobile_os !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('mob_os_added_suc')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_mob_os')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}

   /*
   * 
   * name: fetch_mobile_os_get
   * @param : none
   * @return :all the os details.
   * 
   */
   
	public function fetch_mobile_os_get()
	{
		 $os_list = $this->Do_targeting->fetch_mobile_os();
		 $this->response($os_list);
	}
	
   /*
   * 
   * name: mobile_os_list_get
   * @param : none
   * @return :selected os details.
   * 
   */
	public function mobile_os_list_get()
	{
	   $id = $this->get('id');
	   if($id){
	   $os_list = $this->Do_targeting->fetch_mobile_os_select($id);
	   $this->response($os_list);
       }
	}
	
   /*
   * 
   * name: update_mobile_os_post
   * @param : none
   * @return : os id
   * 
   */ 
	public function update_mobile_os_post()
	{
	    $this->form_validation->set_rules('device_os', 'lang:mobile_os_name', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Device name is being registered. please enter the unique one');
		$this->form_validation->set_rules('os_value', 'lang:mobile_os_value', 'required|trim|callback_mobile_os_check');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$operating_sys = $this->Do_targeting->update_mobile_os($this->post());
			
			if($operating_sys !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('mob_os_updated_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prbm_mob_os')
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	
	}
	
	
	function mobile_os_check()
	{
		$os_id		=   $this->post('os_id');
		$os_value	=	strtolower($this->post('os_value'));
		$table_name =   TAB_TARG_MOB_OS;
		$count 		= 	$this->Do_email_check->mobile_targeting_check($table_name,$os_value,$os_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('mobile_os_check', $this->lang->line('mobileos_value_exists_message'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}	
	}
	
   /*
   * 
   * name: delete_mobile_os_get
   * @param : none
   * @return : status true or false
   * 
  */
  public function delete_mobile_os_get()
   {
      $id = $this->get('id');
	  
	   if($id)
		{
			 $cat_list = $this->Do_targeting->delete_mobile_os($id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('mob_os_deleted')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('mob_os_id_ntfound')
					);
			
			$this->response( $error, 200);
		}

   }
	
	
	
	/*
   * 
   * name: add_mobile_manufacturers_post
   * @param : none
   * @return :lastinsertid
   * 
   */
   
	function add_mobile_manufacturers_post(){
		
		$this->form_validation->set_rules('manu_name', 'lang:mobile_manufacturers_name', 'required|trim');		
		$this->form_validation->set_rules('manu_value', 'lang:mobile_manufacturers_value', 'required|trim|is_unique['.TAB_TARG_MOB_MANU.'.value]');
		$this->form_validation->set_message('is_unique', $this->lang->line('mobile_manufactures_value_exists'));
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$mobile_manufacturer = $this->Do_targeting->add_mobile_manufacturers($this->post('manu_name'),$this->post('manu_value'));
			
			
			if($mobile_manufacturer !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('mob_manu_added_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_mob_manu')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}

   /*
   * 
   * name: fetch_mobile_manufacturers_get
   * @param : none
   * @return :all the manufacturer details.
   * 
   */
   
	public function fetch_mobile_manufacturers_get()
	{
		 $manufacturer_list = $this->Do_targeting->fetch_mobile_manufacturers();
		 $this->response($manufacturer_list);
	}
	
   /*
   * 
   * name: mobile_manufacturers_list_get
   * @param : none
   * @return :selected manufacturer details.
   * 
   */
	public function mobile_manufacturers_list_get()
	{
	   $id = $this->get('id');
	   if($id){
	   $manufacturer_list = $this->Do_targeting->fetch_mobile_manufacturers_select($id);
	   $this->response($manufacturer_list);
       }
	}
	
   /*
   * 
   * name: update_mobile_manufacturers_post
   * @param : none
   * @return : manufacturer id
   * 
   */ 
	public function update_mobile_manufacturers_post()
	{
	   	$this->form_validation->set_rules('manu_name', 'lang:mobile_manufacturers_name', 'required|trim');		
		$this->form_validation->set_rules('manu_value', 'lang:mobile_manufacturers_value', 'required|trim|callback_mobile_manufacturer_check');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$manufacturers = $this->Do_targeting->update_mobile_manufacturers($this->post());
			
			if($manufacturers !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('mob_os_updated_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prbm_mob_os')
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	
	}
	
	/*
	 * name: mobile_manufacturer_check
	 * @param : none
     * @return : status true or false
	 * 
	 * */
	 
	 
	function mobile_manufacturer_check()
	{
		$manu_id	= $this->post('manu_id');
		$manu_value	=	strtolower($this->post('manu_value'));
		$table_name =   TAB_TARG_MOB_MANU;
		$count 		= 	$this->Do_email_check->mobile_targeting_check($table_name,$manu_value,$manu_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('mobile_manufacturer_check', $this->lang->line('mobile_manufactures_value_exists'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}	
	}
	
	
	
   /*
   * 
   * name: delete_mobile_manufacturers_get
   * @param : none
   * @return : status true or false
   * 
  */
  public function delete_mobile_manufacturers_get()
   {
	  $id = $this->get('del_manu_id');
	   if($id)
		{
			$manufacturer_list = $this->Do_targeting->delete_mobile_manufacturers($id);
	
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('mob_manu_delete')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('mob_manu_not_found')
					);
			
			$this->response( $error, 200);
		}

   }
   
   
   
   /*
   * 
   * name: add_mobile_capability_post
   * @param : none
   * @return :lastinsertid
   * 
   */
   
	function add_mobile_capability_post(){
		
		$this->form_validation->set_rules('capability_name', 'lang:mobile_capability_name', 'required|trim');		
		//~ $this->form_validation->set_rules('capability_value', 'lang:mobile_capability_value', 'required|trim|is_unique['.TAB_TARG_MOB_CAPA.'.value]');
		//~ $this->form_validation->set_message('is_unique', $this->lang->line('mobile_capability_value_exists'));
		$this->form_validation->set_rules('capability_value', 'lang:mobile_capability_value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$name = preg_replace('/\s+/', ' ', $this->post('capability_name'));
			$value = preg_replace('/\s+/', ' ', $this->post('capability_value'));
			$check_capability = $this->Do_targeting->check_mobile_capability($name,$value);
			if($check_capability && $check_capability > 0)
			{
				$success = array(
									'response' => 'exist',
									'msg'	 => strtoupper($value)." Value Already Exist For ".strtoupper($name)
					);
				$this->response($success,200);
			}
			
			
			$mobile_capability = $this->Do_targeting->add_mobile_capability($name,$value);
			
			
			
			if($mobile_capability !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('mobile_cap_added_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_mob_cap')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}

   /*
   * 
   * name: fetch_mobile_capability_get
   * @param : none
   * @return :all the Capability details.
   * 
   */
   
	public function fetch_mobile_capability_get()
	{
		 $capability_list = $this->Do_targeting->fetch_mobile_capability();
		 $this->response($capability_list);
	}
	
   /*
   * 
   * name: mobile_capability_list_get
   * @param : none
   * @return :selected Capability details.
   * 
   */
	public function mobile_capability_list_get()
	{
	   $id = $this->get('id');
	   if($id){
	   $capability_list = $this->Do_targeting->fetch_mobile_capability_select($id);
	   $this->response($capability_list);
       }
	}
	
   /*
   * 
   * name: update_mobile_capability_post
   * @param : none
   * @return : capability id
   * 
   */ 
	public function update_mobile_capability_post()
	{
	  $this->form_validation->set_rules('capability_name', 'lang:mobile_capability_name', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Device name is being registered. please enter the unique one');
		//~ $this->form_validation->set_rules('capability_value', 'lang:mobile_capability_value', 'required|trim|callback_mobile_capability_check');
		$this->form_validation->set_rules('capability_value', 'lang:mobile_capability_value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$cap_id	= $this->post('capability_id');
			$cap_value	=	preg_replace('/\s+/', ' ', $this->post('capability_value'));
			$cap_name	=	preg_replace('/\s+/', ' ', $this->post('capability_name'));
			$table_name =   TAB_TARG_MOB_CAPA;
			$count 		= 	$this->Do_targeting->capability_targeting_check($table_name,$cap_value,$cap_name,$cap_id);
			//~ $this->response($count,200);
			if($count && $count > 0)
			{
				$success = array(
									'response' => 'exist',
									'msg'	 => strtoupper($cap_value)." Value Already Exist For ".strtoupper($cap_name)
					);
				$this->response($success,200);
			}
			$capability = $this->Do_targeting->update_mobile_capability($this->post());
			
			if($capability !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('mob_cap_updtd_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_updating_mob_cap')
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	
	}
	
	
	/*
	 * name: mobile_capability_check
	 * @param : none
     * @return : status true or false
	 * 
	 * */
	 
	 
	function mobile_capability_check()
	{
		$cap_id	= $this->post('capability_id');
		$cap_value	=	strtolower($this->post('capability_value'));
		$table_name =   TAB_TARG_MOB_CAPA;
		$count 		= 	$this->Do_email_check->mobile_targeting_check($table_name,$cap_value,$cap_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('mobile_capability_check', $this->lang->line('mobile_capability_value_exists'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}	
	}
	
   /*
   * 
   * name: delete_mobile_capability_get
   * @param : none
   * @return : status true or false
   * 
  */
  public function delete_mobile_capability_get()
   {
      $id = $this->get('del_capability_id');
	  
	   if($id)
		{
			
			$manufacturer_list = $this->Do_targeting->delete_mobile_capability($id);
	
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('mob_cap_deleted')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('mob_cap_nt_fnd')
					);
			
			$this->response( $error, 200);
		}

   }   
      
	/*
   * 
   * name: block_category
   * @param : categoryid
   * @return : sucess msg
   * 
   */
	public function block_category_get()
	{
		                   //to get category block id
	    $cat_id=$this->get('cat_id');
		if($cat_id)
		{
			$block_category = $this->Do_targeting->block_category($cat_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('cat_blkd_succ'),
							 );
			
			$this->response( $success, 200);
		}
	}
	
	   /*
   * 
   * name: unblock_category
   * @param : categoryid
   * @return :sucess msg
   * 
   */
	public function unblock_category_get()
	{
		                  // //to get unblock category id
	    $cat_id=$this->get('un_cat_id');
		if($cat_id)
		{
			$block_category = $this->Do_targeting->unblock_category($cat_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('cat_unblk_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	      
	/*
   * 
   * name: block_category
   * @param : categoryid
   * @return : sucess msg
   * 
   */
	public function block_os_get()
	{                     //to get  block os id
	    $os_id=$this->get('id');
		if($os_id)
		{
			$block_category = $this->Do_targeting->block_os($os_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('os_blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	   /*
   * 
   * name: unblock_category
   * @param : categoryid
   * @return :sucess msg
   * 
   */
	public function unblock_os_get()
	{
		                  //to get unblock os id
	    $os_id=$this->get('unblock_id');
		if($os_id)
		{
			$block_category = $this->Do_targeting->unblock_os($os_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('os_un-blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
  
  
  
  
  /*  domain block unblock*/
  
  
  /*
   * 
   * name: block_domain
   * @param : browserid
   * @return : sucess msg
   * 
   */
	public function block_domain_get()
	{ 
	    $domain_id=$this->get('id');
		if($domain_id)
		{
			$block_domain = $this->Do_targeting->block_domain($domain_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Domain is blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	   /*
   * 
   * name: unblock_domain
   * @param : browserid
   * @return :sucess msg
   * 
   */
	public function unblock_domain_get()
	{
	    $domain_id=$this->get('id');
		if($domain_id)
		{
			$block_domain = $this->Do_targeting->unblock_domain($domain_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Domain is Un-blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
  
  /*  domain block unblock*/
  
  
  
  
  
  	/*
   * 
   * name: block_browser
   * @param : browserid
   * @return : sucess msg
   * 
   */
	public function block_browser_get()
	{
		                    //to get browser block id
	    $brow_id=$this->get('browserblock_id');
		if($brow_id)
		{
			$block_category = $this->Do_targeting->block_browser($brow_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('brwsr_blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	   /*
   * 
   * name: unblock_browser
   * @param : browserid
   * @return :sucess msg
   * 
   */
	public function unblock_browser_get()
	{
		                     //to get unblock Browser id
	    $brow_id=$this->get('unblockbrowser_id');
		if($brow_id)
		{
			$block_category = $this->Do_targeting->unblock_browser($brow_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('brwsr_un-blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
   
   /*
   * 
   * name: block_manu
   * @param : browserid
   * @return : sucess msg
   * 
   */
	public function block_manu_get()
	{
		                     
	    $manu_id=$this->get('id');
		if($manu_id)
		{
			$block_category = $this->Do_targeting->block_manu($manu_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('manu-blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	   /*
   * 
   * name: unblock_browser
   * @param : browserid
   * @return :sucess msg
   * 
   */
	public function unblock_manu_get()
	{
	    $manu_id=$this->get('id');
		if($manu_id)
		{
			$block_category = $this->Do_targeting->unblock_manu($manu_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('manu-un-blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
   * 
   * name: mobile_block_category
   * @param : categoryid
   * @return : sucess msg
   * 
   */
	public function mobile_block_os_get()
	{  
		                   //to get  mobile os block id
	    $os_id=$this->get('blkmobileos_id');
		if($os_id)
		{
			$block_category = $this->Do_targeting->mobile_block_os($os_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('mob_os_blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	   /*
   * 
   * name: unblock_category
   * @param : categoryid
   * @return :sucess msg
   * 
   */
	public function mobile_unblock_os_get()
	{
		                // //to get unblock Os id
	    $os_id=$this->get('mobileosunblk_id');
		if($os_id)
		{
			$block_category = $this->Do_targeting->mobile_unblock_os($os_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('mob_os_un-blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
    
	  /*
   * 
   * name: mobile_block_manu
   * @param : manu id
   * @return : sucess msg
   * 
   */
	public function mobile_block_manu_get()
	{    
		                     //to get mobile manufacture block id
	    $manu_id=$this->get('manumobile_id');
		if($manu_id)
		{
			$block_category = $this->Do_targeting->mobile_block_manu($manu_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('mob_manu_blkd_suc')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	   /*
   * 
   * name: mobile_unblock_browser
   * @param : manu id
   * @return :sucess msg
   * 
   */
	public function mobile_unblock_manu_get()
	{  
		                    //to get unblock manufacture id
	    $manu_id=$this->get('unblockmanufmobile_id');
		if($manu_id)
		{
			$block_category = $this->Do_targeting->mobile_unblock_manu($manu_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('mob_manu_unblkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
   
   	  /*
   * 
   * name: mobile_block_capability
   * @param : manu id
   * @return : sucess msg
   * 
   */
	public function mobile_block_capability_get()
	{  
		                  //to get capability block id
	    $cap_id=$this->get('capabilityblock_id');
		if($cap_id)
		{
			$block_category = $this->Do_targeting->mobile_block_capability($cap_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('mob_cap_blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	   /*
   * 
   * name: mobile_unblock_capability
   * @param : manu id
   * @return :sucess msg
   * 
   */
	public function mobile_unblock_capability_get()
	{
		                  //to get unblock capability id
	    $cap_id=$this->get('capb_unblck_id');
		if($cap_id)
		{
			$block_category = $this->Do_targeting->mobile_unblock_capability($cap_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('mob_cap_un-blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}

	/*
   * 
   * name: fetch_tele_operators
   * @param : none
   * @return :all the telecom operators details.
   * 
   */
	public function fetch_tele_operators_get()
	{
		
	   $tele_list=$this->Do_targeting->fetch_telecom_values();
	   $this->response($tele_list); 
	}
	
	/*
   * 
   * name: block_tele_operator
   * @param : none
   * @return :block selected telecom operator.
   * 
   */
	public function block_tele_operator_get()
	{
		$tele_id=$this->get('tele_id');
		if($tele_id)
		{
			$block_tele = $this->Do_targeting->block_telecom($tele_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('select_tele_blk_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
   * 
   * name: unblock_telecom_operator_get
   * @param : none
   * @return :unblock selected telecom operator.
   * 
   */
	public function unblock_telecom_operator_get()
	{
		$tele_id=$this->get('teleco_id');
		if($tele_id)
		{
			$block_tele = $this->Do_targeting->unblock_telecom($tele_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('select_tele_un-blk_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	function getLatestFile($directoryPath) {
    $directoryPath = rtrim($directoryPath, '/');

	$max = array('path' => null, 'timestamp' => 0);
    foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file) {
        $path = $directoryPath . '/' . $file;

        if (!is_file($path)) {
            continue;
        }

        $timestamp = filemtime($path);		
        if ($timestamp > $max['timestamp']) {
            $max['path'] = $path;
            $max['timestamp'] = $timestamp;
        }
    }

    return $max['path'];
}

	/*
   * 
   * name: add_telecom_process
   * @param : none
   * @return :add telecom operators through csv file.
   * 
   */
    public function add_telecom_process_post()
    {
		
		$file_id=$this->post('filname');
		
		if($file_id!='')
		{
				$upload_extension = explode(".", $file_id);		
				if($upload_extension[1]!='csv')
				{
					$error = array(
							'response' => 'error',
							'msg'	 => 'gfffhg'
								);
		  
					$this->response($error, 200);	
				}
				else if($upload_extension[1]=='zip' || $upload_extension[1]=='tar')
				{
					$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('valid_csv_upload')
								);
		  
					$this->response($error, 200);	
				}
				else if($upload_extension[1]=='csv')
				{
					$ff=md5($file_id);
					//$file_info 		= $this->upload->data();
					$csvfilepath 	= $this->config->item('read_csv_telecom');	
					$file_name=$this->getLatestFile($csvfilepath);
			
					$data	 		= $this->csvreader->parse_file($file_name);					
					$counter		= '1';
					$error_head_field_details = array();
					$error_ip			= array();
					$insert_rec	= array();				
					if(count($data) > 0)
					{	
						foreach($data as $row)
						{						
							if($row['start_ip'] !='' AND $row['end_ip'] !='' AND $row['country'] !='' AND $row['carriername'] !='')
							{	
								$start_ip		=$row['start_ip'];
								$end_ip = $row['end_ip'];
								$country = trim($row['country']);
								$carriername = trim($row['carriername']);
								$insert_data		=array("start_ip"  =>$start_ip, "end_ip" =>$end_ip, "country" =>$country, "carriername"=> $carriername, "status"=>1);								
								$start_ip_exist = $this->Do_targeting->check_ip_exist($start_ip,$end_ip,$country,$carriername);
								 if($start_ip !='' && $end_ip !=''): 
								 $pattern= preg_match("!^([0-9]{1,3}\.){3}([0-9]{1,3}){1}$!", $start_ip) && preg_match("!^([0-9]{1,3}\.){3}([0-9]{1,3}){1}$!", $end_ip);
								 $chk=1;if(ip2long($start_ip) < ip2long($end_ip)):$ip_long=1;else:$ip_long=0;endif;
								 else:$pattern=preg_match("!^([0-9]{1,3}\.){3}(([0-9]{1,3}|\*|(([0-9]{1,3})\/([0-9]{1,3})))){1}$!",$start_ip); $chk=0; $end_ip_exist=0;$ip_long=1;endif;
								 $start=filter_var($start_ip, FILTER_VALIDATE_IP);
								 $end=filter_var($end_ip, FILTER_VALIDATE_IP);
								//echo $this->db->last_query();
								//echo 'this is condtion'.' '.$start_ip_exist;
								 if(preg_match("/^[a-zA-Z]+$/",$country) && preg_match("/^[a-zA-Z]+$/",$carriername))
								{
								if($start_ip_exist==0)
								{
								  if($pattern && $start && $end)
									 {
										  if($ip_long==1){									
											$this->Do_targeting->insert_tele_data($insert_data);
											$insert_rec[] =$counter;									
											}
											else
											{
											$error_lessval_endip[]	=$counter;
											}
									}
									else
									{
												if($chk==1):
												$error_ip[]	=$counter;
												else:
												$error_ip[]	=$counter;
												endif;
									}
								}
								
								else if($start_ip_exist==1)
								{
									$up_data = array("country"=>$country,"carriername"=>$carriername,"status" =>1);
									$this->Do_targeting->update_tele_data($start_ip,$end_ip,$up_data);								
									$rec[] =$counter;
								}
								else if($start_ip_exist==2)
								{
									$error_ip[]	= $counter;
								}
								else  
								{
									$error_ip[]	=$counter;
								}
							 }
								else  
								{
									$error_carrier_country[]	=$counter;
								}
							}
							else
							{
								$error_head_field_details[] = $counter;
							}
							$counter++;
							
						}
						
						
						if(count($insert_rec)>0 && (count($error_head_field_details) >0 || count($error_carrier_country) >0 || count($error_lessval_endip) >0 ||count($error_ip) >0))
						{
							$ins_count = count($insert_rec);
							$notify = array('response'	=> 'notify',
											 'redirect' =>site_url('admin/targeting/telecom_operators/'),	
											 	 'msg'		=> $ins_count.$this->lang->line('rec_insts').'<br>'.$rec_count.$this->lang->line('updat_suc')
											 ); 
							$this->response($notify,200);
						}
						
						if(count($error_ip) >0)
						{
							$ids= count($error_ip);
							$error = array(
										   'response' => 'error',
										   'msg' =>  $ids.$this->lang->line('rec_ipformat')
										  );
							$this->response($error, 200);
						}
						if(count($insert_rec)>0 || (count($rec)>0))
						{
							$ins_count = count($insert_rec);
							$rec_count = count($rec);
							$success = array('response'	=> 'ok',
											 'redirect' =>site_url('admin/targeting/telecom_operators/'),	
											 'msg'		=> $ins_count.$this->lang->line('rec_insts').'<br>'.$rec_count.$this->lang->line('updat_suc')
											 ); 
									$this->response($success,200);
						}
						//~ if(count($rec)>0)
						//~ {
							//~ $ins_count = count($insert_rec);
							//~ $success = array('response'	=> 'ok',
											 //~ 'redirect' =>site_url('admin/targeting/telecom_operators/'),	
											 //~ 'msg'		=> $this->lang->line('updat_suc')
											 //~ ); 
									//~ $this->response($success,200);
						//~ }
						if(count($error_carrier_country) >0)
						{
						
							$error = array(
										'response' => 'error',
										'msg' =>  $this->lang->line('entr_alpha_only')
										
										  );
							$this->response( $error, 200);
						}
							if(count($error_lessval_endip) >0)
						{
						
							$error = array(
										'response' => 'error',
										'msg' =>  $this->lang->line('startip_endip')
										  );
							$this->response( $error, 200);
						}
						
						if(count($error_head_field_details) >0)
						{
						
							$error = array(
										'response' => 'error',
										'msg' =>  $this->lang->line('miss_upload')
										  );
							$this->response( $error, 200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect'=>site_url('admin/targeting/telecom_operators'),
									'msg'	 => $this->lang->line('thr_nodata_file')
										);
				  
						$this->response($error, 200);	
					} 	
				}
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('valid_csv_upload')
								);
		  
				$this->response($error, 200);	
			}	
	 
	}
	
	/*
   * 
   * name: fetch_category_main
   * @param : 
   * @return :all the creatives details need to be approve
   * 
   */
	public function fetch_category_main_get()
	{
		 $cat_list = $this->Do_targeting->fetch_main_category();
		 $this->response($cat_list);
	}
	
	/*
   * 
   * name: add_main_category_post
   * @param : categoryname,categoryvalue
   * @return :lastinsertid
   * 
   * Fetch list of n/w users (pub or adv)
   */
	public function add_main_category_post(){
		
		$this->form_validation->set_rules('category_name', 'lang:category_name', 'required|trim|is_unique['.TAB_SITE_CATEGORIES.'.category_name]');
		$this->form_validation->set_message('is_unique', $this->lang->line('category_registered_message'));
		#$this->form_validation->set_rules('category_value', 'Category Value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$category_value = "IAB";
			$category 		= $this->Do_targeting->add_main_category($this->post('category_name'),$category_value);
			$final_cat_val 	= "IAB".$category;
			
			$update_main 	= $this->Do_targeting->update_category_value($category,$final_cat_val); 
			 
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('cat_added_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_category')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
	/*
   * 
   * name: update_main_category
   * @param : categoryname,categoryvalue,categoryid
   * @return : category id
   * 
   */
	public function update_main_category_post()
	{
		$this->form_validation->set_rules('category_name', 'lang:category_name', 'required|trim|callback_category_name_check');
		#$this->form_validation->set_message('category_name_check', 'Already this category name is being registered. please enter the unique one');
		#$this->form_validation->set_rules('category_value', 'Category Value', 'required|trim');
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category_update = $this->Do_targeting->update_main_category($this->post());
			
			if($category_update !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('cat_added_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_category')
					);
				
				$this->response( $success, 200);
			}
		}		
	}
	
	function category_name_check()
	{
		
		$cat_id 	= $this->post('cat_id');
		$cat_name	= $this->post('category_name');	
		
		$count 		= $this->Do_targeting->dup_category_name_chk($cat_id,$cat_name);
		
		if($count>0)
		{
			$this->form_validation->set_message('category_name_check', $this->lang->line('cat_alrdy_exits'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	/*
	 * category_root_get
	 * GET CATEGORY ROOT
	 * 
	 */
	function category_root_get() 
	{
		$par_value			= $this->get('par_id');
		$get_parent_cat	= $this->Do_targeting->check_category_root($par_value);
		$this->response($get_parent_cat); 

	}
	
	/*
   * 
   * name: delete_category
   * @param : categoryid
   * @return : status true or false
   * 
   */
   
   public function delete_main_category_get()
   {
      $cat_id = $this->get('del_category_id');

	   if($cat_id)
		{
			$chk_cat_parent = $this->Do_targeting->check_category($cat_id);
			if($chk_cat_parent[0]['parent_category_id']==0)
			{
				$cat_list 		= $this->Do_targeting->delete_assoc_category($cat_id,$chk_cat_parent[0]['value']);
			}
			else
			{
				
				$cat_list 		= $this->Do_targeting->delete_category($cat_id);
			}
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('cat_delet')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('cat_not_found')
					);
			
			$this->response( $error, 200);
		}

   }
	public function city_targeting_post()
	{
        //Prepare the target data
        $campaign_id               = '';
        $prepared_data             = '';
        $compiledlimitation_prefix = '';
        $compiledlimitation_suffix = '';
        $compiledlimitation        = '';
        $acl_plugins               = '';
        $targ_value                = $this->post('value');
    
        if ($targ_value)
        {
            foreach ($targ_value as $data)
            {
                $prepared_data .= $data . ',';
            }
            $prepared_data = substr($prepared_data, 0, -1);
        }
        else
        {
            $prepared_data = FALSE;
        }
         
        $campaign_id    = $this->post('pk');
        $logical        = "or";
        $type           = "city";
        $comparison     = "==";
        $executionorder = "4";
        $ox_acls_data   = array(
            "campaignid" => $campaign_id,
            "logical" => $logical,
            "type" => $type,
            "comparison" => $comparison,
            "data" => $prepared_data,
            "executionorder" => $executionorder
        );
        if ($prepared_data != FALSE)
        {
            $ox_acls = $this->Do_targeting->add($ox_acls_data, $campaign_id);
            // $this->response($ox_acls, 200);
        }
        else
        {
            $ox_acls = $this->Do_targeting->delete($ox_acls_data, $campaign_id);
        }
       // $check = $this->geo_ordering($campaign_id);
        if ($ox_acls !== FALSE)
        { //$this->response("ok",200);
            $success = array(
                'response' => 'ok',
                'msg' => $this->lang->line('camp_tar_suc'),
                'city' => $prepared_data,
                'sorted' => $check
            );
            $this->response($success, 200);
        }
        else
        {
            $error = array(
                'response' => 'error',
                'msg' => $this->lang->line('error_try_again')
            );
            $this->response($error, 200);
        }
    }
      /*
     * 
     * name: add_keyword_post
     * @param : none
     * @return :all the keyword details.
     * 
     */
    public function add_keyword_post()
    {
        $this->form_validation->set_rules('keyword', 'Keyword Name', 'required|trim|is_unique[' . TAB_TARG_KEYWORD . '.keyword]');
        $this->form_validation->set_message('is_unique', 'The keyword is already exist. Please enter the unique one');
        if ($this->form_validation->run() === FALSE) {
            //  print_r("hdfgdg");
            //exit;
            $error_msg = $this->form_validation->error_array();
            $error     = array(
                'response' => 'error',
                'msg' => $error_msg
            );
            $this->response($error, 200);
        } else {
            $keydata = array(
                'keyword' => clean_data($this->post('keyword'))
            );
            $add     = $this->Do_targeting->add_keyword($keydata);
            if ($add) {
                $success = array(
                    'response' => 'ok',
                    'msg' => 'Keyword has been created successfully.'
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'msg' => 'Error! Please Try Again..'
                );
                $this->response($error, 200);
            }
        }
    }
     /*
     * 
     * name: update_keyword_post
     * @param : none
     * @return :all the keyword details.
     * 
     */
    public function update_keyword_post()
    {
        $this->form_validation->set_rules('keyword', 'Keyword Name', 'required|trim|callback_keyword_check');
        if ($this->form_validation->run() === FALSE) {
            $error_msg = $this->form_validation->error_array();
            $error     = array(
                'response' => 'error',
                'msg' => $error_msg
            );
            $this->response($error, 200);
        } else {
            $keyword_id = $this->post('keyword_id');
            $keydata    = array(
                'keyword' => clean_data($this->post('keyword'))
            );
            $update     = $this->Do_targeting->update_keyword($keyword_id, $keydata);
            if ($update) {
                $success = array(
                    'response' => 'ok',
                    'msg' => 'Keyword has been updated successfully.'
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'msg' => 'Error! Please Try Again..'
                );
                $this->response($error, 200);
            }
        }
    }
    /*
     * 
     * name: fetch_keyword_get
     * @param : none
     * @return :all the keyword details.
     * 
     */
    public function fetch_keyword_get()
    {
        $keyword_id = $this->get('keyword_id');
        if ($keyword_id) {
            $keyword_list = $this->Do_targeting->fetch_keyword($keyword_id);
        } else {
            $keyword_list = $this->Do_targeting->fetch_keyword();
        }
        $this->response($keyword_list);
    }
    /*
     * 
     * name: delete_keyword
     * @param : keywordid
     * @return : status true or false
     * 
     */
    public function delete_keyword_get()
    {
        $keyword_id = $this->get('id');
        if ($keyword_id) {
            $key_list = $this->Do_targeting->delete_keyword($keyword_id);
            if ($key_list) {
                $success = array(
                    'response' => 'ok',
                    'msg' => 'keyword has been deleted'
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'msg' => 'Unable to delete the keyword..'
                );
                $this->response($error, 200);
            }
        } else {
            $error = array(
                'response' => 'error',
                'msg' => 'keyword is not found'
            );
            $this->response($error, 200);
        }
    }
    /*
     * 
     * name: block_keyword_get
     * @param : keywordid
     * @return : success msg
     * 
     */
    public function block_keyword_get()
    {
        $keyword_id = $this->get('keyword_id');
        if ($keyword_id) {
            $keyword = $this->Do_targeting->block_keyword($keyword_id);
            $success = array(
                'response' => 'ok',
                'msg' => 'Keyword is blocked successfully'
            );
            $this->response($success, 200);
        }
    }
     /*
     * 
     * name: unblock_keyword_get
     * @param : keywordid
     * @return : success msg
     * 
     */
    public function unblock_keyword_get()
    {
        $keyword_id = $this->get('keyword_id');
        if ($keyword_id) {
            $keyword = $this->Do_targeting->unblock_keyword($keyword_id);
            $success = array(
                'response' => 'ok',
                'msg' => 'Keyword is unblocked successfully'
            );
            $this->response($success, 200);
        }
    }
    /*
     * name: profile_targeting_keyword_post
     * @param
     * @return:response array
     * 
     * In this method set keyword targeting for a campaign
     * 
     */
    public function profile_targeting_keyword_post()
    {
        $campaign_id               = '';
        $prepared_data             = '';
        $compiledlimitation_prefix = '';
        $compiledlimitation_suffix = '';
        $compiledlimitation        = '';
        $acl_plugins               = '';
        
        $targ_value = $this->post('value');
        
        if ($targ_value) {
            foreach ($targ_value as $data) {
                $prepared_data .= $data . ',';
            }
            $prepared_data = substr($prepared_data, 0, -1);
        } else { 
            $prepared_data = FALSE;
        }
       
        $campaign_id    = $this->post('pk');
        $logical        = "or";
        $type           = "keyword";
        $comparison     = "==";
        $executionorder = "6";
        
        $ox_acls_data = array(
            "campaignid" => $campaign_id,
            "logical" => $logical,
            "type" => $type,
            "comparison" => $comparison,
            "data" => $prepared_data,
            "executionorder" => $executionorder
        );
       
        if ($prepared_data != FALSE) {
            $ox_acls = $this->Do_targeting->add($ox_acls_data, $campaign_id);
        } else { 
            $ox_acls = $this->Do_targeting->delete($ox_acls_data, $campaign_id);   
            //$ox_bid  = $this->Do_campaign->delete_bidding($campaign_id, 'KEYWORD');
            
        }
       // $this->response($ox_acls, 200);
        if ($ox_acls != FALSE) {  
            $success = array(
                'response' => 'ok',
                'keyword' => $prepared_data,
                'keyword_name' => $prepared_data,
                'msg' => 'Camapign targeting has been set sucessfully'
            );
            $this->response($success, 200);
        } else { 
            $error = array(
                'response' => 'error',
                'msg' => 'Please try again'
            );
            $this->response($error, 200);
        }
    }
	
	/*
   * 
   * name: add_segment_post
   * @param : none
   * @return :lastinsertid
   * 
   */
	function add_segment_post(){
		
		$this->form_validation->set_rules('seg_name', 'Segment Name', 'required|trim|is_unique['.TAB_TARG_SEGMENT.'.name]');
		$this->form_validation->set_message('is_unique', 'Already this Segment name is being registered. please enter the unique one');
		$this->form_validation->set_rules('seg_desc', 'Segment Description', 'required|trim');
		if($_POST['filname']==''){
		$this->form_validation->set_rules('filname', 'Upload Segment', 'required|trim');
		}
		if($this->form_validation->run() === FALSE){			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		//$this->form_validation->set_rules('filname', 'Upload Segment', 'required|trim');
		 // $this->load->helper('file');
        //print_r($this->post('filname'));exit;
        //~ if(empty($this->post('filname'))){
          //~ $this->form_validation->set_rules('files[]', 'Upload Segment', 'required|trim');
	     //~ }
		  	$file_id=$this->post('filname');
		  	//print_r($_FILES);exit;
		  	//~ if (empty($file_id))
			//~ {
			//~ $this->form_validation->set_rules('fileupload', 'Upload Segment', 'required|trim');
			//~ }
		  	if($file_id!='')
		    {
				$upload_extension = explode(".", $file_id);		
				if($upload_extension[1]!='csv')
				{
					$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('ple_sel_valid_csv')
								);
		  
					$this->response($error, 200);	
				}
				else if($upload_extension[1]=='zip' || $upload_extension[1]=='tar')
				{
					$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('ple_sel_valid_csv')
								);
		  
					$this->response($error, 200);	
				}
				else if($upload_extension[1]=='csv')
				{
					$ff=md5($file_id);
					$csvfilepath 	= $this->config->item('read_csv_telecom');	
					$file_name=$this->getLatestFile($csvfilepath);
					$data	 		= $this->csvreader->parse_file($file_name);	
					$category = $this->Do_targeting->add_segment($this->post('seg_name'),$this->post('seg_desc'),$this->post('filname'),$file_name);	
					if($category>0)
						{
							$success = array('response'	=> 'ok',
											 'redirect' =>site_url('admin/targeting/segmentation/'),	
											 'msg'		=> 'Segment inserted successfully.'
											 ); 
									$this->response($success,200);
						}				
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('ple_sel_valid_csv')
								);
		  
				$this->response($error, 200);	
			}
	}
    }
    /*
   * 
   * name: fetch_segment_get
   * @param : none
   * @return :all the segment details.
   * 
   */
   
	public function fetch_segment_get()
	{
		 $seg_list = $this->Do_targeting->fetch_segment();
		 $this->response($seg_list);
	}
		/*
   * 
   * name: block_segment
   * @param : block segment id
   * @return : sucess msg
   * 
   */
	public function block_segment_get()
	{                     //to get  block segment id
	    $seg_id=$this->get('id');
		if($seg_id)
		{
			$block_category = $this->Do_targeting->block_segment($seg_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('seg_block')
							 );
			
			$this->response( $success, 200);
		}
	}
	/*
   * 
   * name: unblock_segment
   * @param : categoryid
   * @return :sucess msg
   * 
   */
	 public function unblock_segment_get()
	 {
		                  //to get unblock segment id
	    $os_id=$this->get('unblock_id');
		if($os_id)
		{
			$block_category = $this->Do_targeting->unblock_segment($os_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('seg_unblock')
							 );
			
			$this->response( $success, 200);
		}
	}
	 /*
   * 
   * name: delete_segment_get
   * @param : none
   * @return : status true or false
   * 
  */
   public function delete_segment_get()
   {
      $id = $this->get('del_os_id');
	  
	   if($id)
		{
			 $cat_list = $this->Do_targeting->delete_segment($id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('seg_del')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('seg_id_not_found')
					);
			
			$this->response( $error, 200);
		}

   }
   /*
   * 
   * name: segment_list_get
   * @param : none
   * @return :selected os details.
   * 
   */
	public function segment_list_get()
	{
	   $id = $this->get('id');
	   if($id){
	   $seg_list = $this->Do_targeting->fetch_segment_select($id);
	   $this->response($seg_list);
       }
	}

	 /*
   * 
   * name: update_segment_post
   * @param : none
   * @return : segment id
   * 
   */ 
	public function update_segment_post()
	{
	    $this->form_validation->set_rules('seg_name', 'Segment Name', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Device name is being registered. please enter the unique one');
		$this->form_validation->set_rules('seg_desc', 'Segment Description', 'required|trim');
		if($_POST['filname']==''){
		$this->form_validation->set_rules('filname', 'Upload Segment', 'required|trim');
		}
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$file_id=$this->post('filname');			
			$csvfilepath = $this->config->item('read_csv_telecom');	
			$file_path=$this->getLatestFile($csvfilepath);
		    //$this->response($file_path, 200);exit;
			$up_segment = $this->Do_targeting->update_segment($this->post(),$file_id,$file_path);
			//$this->response($up_segment, 200);exit;
			if($up_segment !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('segment_success_updated')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('pbm_seg_up')
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	
	}
	
	public function segment_targeting_post()
	
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="segment";
			$comparison= "==";
			$executionorder="1";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
							
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> $this->lang->line('cam_seg_tar')
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('ple_try_again')
				
			);
				
				
			$this->response($error,200); 
		}
	}
	
	
	function add_site_post(){
		
		$this->form_validation->set_rules('site_name', 'lang:site_name', 'required|trim');
		//$this->form_validation->set_message('is_unique', $this->lang->line('browser_registered_message'));
		$this->form_validation->set_rules('site_value', 'lang:site_value', 'required|trim|is_unique['.TAB_TARG_SITES.'.value]');
		$this->form_validation->set_message('is_unique', $this->lang->line('site_targeting_registered_message'));
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$site = $this->Do_targeting->add_site($this->post());
			
			if($site !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('brwsr_added_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_brwsr')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
    public function fetch_site_get()
	{
       $site_list=$this->Do_targeting->fetch_site();

	   $this->response($site_list); 
	}
	
	public function site_list_get(){
	   $id = $this->get('id');
	   if($id){
	   $site_list = $this->Do_targeting->fetch_site_select($id);
	   $this->response($site_list);
       }
	}
	public function update_site_post()
	{
	   
		$this->form_validation->set_rules('site_name', 'lang:site_name', 'required|trim|edit_unique['.TAB_TARG_SITES.'~name~id~'.$this->post('site_id').']');
		$this->form_validation->set_rules('site_value', 'lang:site_value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->Do_targeting->update_site($this->post());
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('site_success_updated')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_adding_brwsr')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	public function delete_site_get()
   {
      $id = $this->get('del_site_id');
	  
	   if($id)
		{
			$browser_list = $this->Do_targeting->delete_site($id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('site_deleted')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('brwsr_id_ntfound')
					);
			
			$this->response( $error, 200);
		}

   }
   public function block_site_get()
	{
		                    //to get browser block id
	    $site_id=$this->get('siteblock_id');
		if($site_id)
		{
			$block_category = $this->Do_targeting->block_site($site_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('site_blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	public function unblock_site_get()
	{
		                     //to get unblock Browser id
	    $site_id=$this->get('unblocksite_id');
		if($site_id)
		{
			$block_category = $this->Do_targeting->unblock_site($site_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('site_un-blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	
	function add_sentiment_post()
	{		
		$this->form_validation->set_rules('sentiment_name', 'lang:sentiment_name', 'required|trim');
		$this->form_validation->set_rules('sentiment_value', 'lang:sentiment_value', 'required|trim|is_unique['.TAB_TARG_SENTIMENTS.'.value]');
		$this->form_validation->set_message('is_unique', $this->lang->line('sentiment_targeting_registered_message'));
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$sentiment = $this->Do_targeting->add_sentiment($this->post());
			
			if($sentiment !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('brwsr_added_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_brwsr')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
    public function fetch_sentiment_get()
	{
       $sentiment_list=$this->Do_targeting->fetch_sentiment();

	   $this->response($sentiment_list); 
	}
	
	public function sentiment_list_get(){
	   $id = $this->get('id');
	   if($id){
	   $sentiment_list = $this->Do_targeting->fetch_sentiment_select($id);
	   $this->response($sentiment_list);
       }
	}
	public function update_sentiment_post()
	{
	   
		$this->form_validation->set_rules('sentiment_name', 'lang:sentiment_name', 'required|trim|edit_unique['.TAB_TARG_SENTIMENTS.'~name~id~'.$this->post('sentiment_id').']');
		$this->form_validation->set_rules('sentiment_value', 'lang:sentiment_value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->Do_targeting->update_sentiment($this->post());
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('sentiment_success_updated')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_adding_brwsr')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
   public function delete_sentiment_get()
   {
      $id = $this->get('del_sentiment_id');
	  
	   if($id)
		{
			$browser_list = $this->Do_targeting->delete_sentiment($id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('sentiment_deleted')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('brwsr_id_ntfound')
					);
			
			$this->response( $error, 200);
		}

   }
   public function block_sentiment_get()
	{
		                    //to get browser block id
	    $sentiment_id=$this->get('sentimentblock_id');
		if($sentiment_id)
		{
			$block_category = $this->Do_targeting->block_sentiment($sentiment_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('sentiment_blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	public function unblock_sentiment_get()
	{
		                     //to get unblock Browser id
	    $sentiment_id=$this->get('unblocksentiment_id');
		if($sentiment_id)
		{
			$block_category = $this->Do_targeting->unblock_sentiment($sentiment_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('sentiment_un-blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
	 * name: mobile_os_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set mobile os targeting for a campaign
	 * 
	 */
	public function site_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="site";
			$comparison= "==";
			$executionorder="0";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> $this->lang->line('camp_target_suc')
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('error_try_again')
				
				);
			$this->response($error,200); 
		}
	}
	public function sentiment_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="sentiment";
			$comparison= "==";
			$executionorder="0";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> $this->lang->line('camp_target_suc')
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('error_try_again')
				
				);
			$this->response($error,200); 
		}
	}
	
	public function customtargeting_post()
	{
		$targ_val     = $this->input->get('targval');		
		//~ $this->response($targ_val,200);

		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			foreach($targ_value as $data)
			{
				$prepared_data .= $data.',';
			}
			$prepared_data=substr($prepared_data, 0, -1);
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			//~ $type="custom_targ1";
			$comparison= "==";
			$executionorder="0";

			$ox_acls_data=	array(

							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							//~ "type"=> $type,
							"type"=> $targ_val,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> $this->lang->line('camp_target_suc')
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> $this->lang->line('error_try_again')
				
				);
			$this->response($error,200); 
		}
	}
	
	public function profile_targeting_gender_post()
    {
        //Prepare the target data
        $campaign_id               = '';
        $prepared_data             = '';
        $compiledlimitation_prefix = '';
        $compiledlimitation_suffix = '';
        $compiledlimitation        = '';
        $acl_plugins               = '';
        
        $targ_value = $this->post('value');
       
        if ($targ_value) {
            foreach ($targ_value as $data) {
                $prepared_data .= $data . ',';
            }
            $prepared_data = substr($prepared_data, 0, -1);
        } else {
            $prepared_data = FALSE;
        }
        
        $campaign_id    = $this->post('pk');
        $logical        = "or";
        $type           = "gender";
        $comparison     = "==";
        $executionorder = "5";
        
        $ox_acls_data = array(
            
            "campaignid" => $campaign_id,
            "logical" => $logical,
            "type" => $type,
            "comparison" => $comparison,
            "data" => $prepared_data,
            "executionorder" => $executionorder
        );
        if ($prepared_data != FALSE) {
            $ox_acls = $this->Do_targeting->add($ox_acls_data, $campaign_id);
        } else {
            $ox_acls = $this->Do_targeting->delete($ox_acls_data, $campaign_id);
        }
        // exit;
        if ($ox_acls !== FALSE) {
            $success = array(
                'response' => 'ok',
                'msg' => 'Camapign targeting has been set sucessfully'
                
            );
            $this->response($success, 200);
        } else {
            $error = array(
                'response' => 'error',
                'msg' => 'Please try again'
                
            );
            $this->response($error, 200);
        }
    }
    
    public function gender_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			
			$prepared_data=$targ_value;
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="gender";
			$comparison= "==";
			$executionorder="3";

			$ox_acls_data=	array(
							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
						
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
			//~ $this->response($ox_acls,200); 	
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	public function age_targeting_post()
	{
		//Prepare the target data
		$campaign_id='';
		$prepared_data='';
		$compiledlimitation_prefix='';
		$compiledlimitation_suffix='';
		$compiledlimitation='';
		$acl_plugins='';
		
		$targ_value = $this->post('value');

		if($targ_value)
		{
			
			$prepared_data=$targ_value;
		}
		else
		{
			$prepared_data =FALSE;
		}

			$campaign_id = $this->post('pk');
			$logical="or";
			$type="age";
			$comparison= "==";
			$executionorder="3";

			$ox_acls_data=	array(
							"campaignid"=> $campaign_id,
							"logical"=> $logical,
							"type"=> $type,
							"comparison"=> $comparison,
							"data"=> $prepared_data,
							"executionorder"=> $executionorder,
							);
						
		if($prepared_data!=FALSE)
		{
			$ox_acls=$this->Do_targeting->add($ox_acls_data,$campaign_id);
			//~ $this->response($ox_acls,200); 	
		}
		else
		{
			$ox_acls=$this->Do_targeting->delete($ox_acls_data,$campaign_id);
		}

		if($ox_acls !== FALSE)
		{
			$success = array(
				'response' 	=> 'ok',
				'msg'	 	=> 'Camapign targeting has been set sucessfully',
				
			);
			$this->response($success,200); 
		}
		else
		{
			$error = array(
				'response' 	=> 'error',
				'msg'	 	=> 'Please try again'
				
				);
			$this->response($error,200); 
		}
	}
	
	function add_custom_targeting1_post()
	{		
		$this->form_validation->set_rules('custom_name', 'lang:custom1_name', 'required|trim');
		$this->form_validation->set_rules('custom_value', 'lang:custom1_value', 'required|trim|is_unique['.TAB_CUSTOM_TARGETING1.'.value]');
		$this->form_validation->set_message('is_unique', $this->lang->line('custom_targeting_registered_message'));
		if($this->form_validation->run() === FALSE){  
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$custom = $this->Do_targeting->add_custom_targeting1($this->post());  
			
			if($custom !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('custom_added_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_custom')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
	public function fetch_custom_targeting1_get()
	{
       $custom_targeting_list=$this->Do_targeting->fetch_custom_targeting1();

	   $this->response($custom_targeting_list); 
	}
    
	
	public function custom_targeting1_list_get()
	{
	   $id = $this->get('id');
		   if($id)
		   {
			$target_list = $this->Do_targeting->fetch_custom_targeting1_select($id);
			$this->response($target_list);
		   }
	}
	
	public function update_custom_targeting1_post()
	{	   
		$this->form_validation->set_rules('custom_name', 'lang:custom1_name', 'required|trim|edit_unique['.TAB_CUSTOM_TARGETING1.'~name~id~'.$this->post('target_id').']');
		$this->form_validation->set_rules('custom_value', 'lang:custom1_value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->Do_targeting->update_custom_targeting1($this->post());
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('custom_success_updated')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_edit_custom')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}


	function add_custom_targeting2_post()
	{	
		$this->form_validation->set_rules('custom_name', 'lang:custom_name', 'required|trim');		
		$this->form_validation->set_rules('custom_value', 'lang:custom_value', 'required|trim|is_unique['.TAB_CUSTOM_TARGETING2.'.value]');
		$this->form_validation->set_message('is_unique', $this->lang->line('custom_targeting_registered_message'));
		if($this->form_validation->run() === FALSE){  
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	 
			$custom = $this->Do_targeting->add_custom_targeting2($this->post());  
			
			if($custom !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('custom_added_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_custom')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
	public function fetch_custom_targeting2_get()
	{
       $custom_targeting_list=$this->Do_targeting->fetch_custom_targeting2();

	   $this->response($custom_targeting_list); 
	}
    
	
	public function custom_targeting2_list_get()
	{
	   $id = $this->get('id');
		   if($id)
		   {
			$target_list = $this->Do_targeting->fetch_custom_targeting2_select($id);
			$this->response($target_list);
		   }
	}
	
	public function update_custom_targeting2_post()
	{	   
		$this->form_validation->set_rules('custom_name', 'lang:custom_name', 'required|trim|edit_unique['.TAB_CUSTOM_TARGETING2.'~name~id~'.$this->post('target_id').']');
		$this->form_validation->set_rules('custom_value', 'lang:custom_value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->Do_targeting->update_custom_targeting2($this->post());
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('custom_success_updated')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_edit_custom')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
	function add_custom_targeting3_post()
	{	
		$this->form_validation->set_rules('custom_name', 'lang:custom_name', 'required|trim');		
		$this->form_validation->set_rules('custom_value', 'lang:custom_value', 'required|trim|is_unique['.TAB_CUSTOM_TARGETING3.'.value]');
		$this->form_validation->set_message('is_unique', $this->lang->line('custom_targeting_registered_message'));
		if($this->form_validation->run() === FALSE){  
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	 
			$custom = $this->Do_targeting->add_custom_targeting3($this->post());  
			
			if($custom !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('custom_added_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_custom')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
	public function fetch_custom_targeting3_get()
	{
       $custom_targeting_list=$this->Do_targeting->fetch_custom_targeting3();

	   $this->response($custom_targeting_list); 
	}
    
	
	public function custom_targeting3_list_get()
	{
	   $id = $this->get('id');
		   if($id)
		   {
			$target_list = $this->Do_targeting->fetch_custom_targeting3_select($id);
			$this->response($target_list);
		   }
	}
	
	public function update_custom_targeting3_post()
	{	   
		$this->form_validation->set_rules('custom_name', 'lang:custom_name', 'required|trim|edit_unique['.TAB_CUSTOM_TARGETING3.'~name~id~'.$this->post('target_id').']');
		$this->form_validation->set_rules('custom_value', 'lang:custom_value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->Do_targeting->update_custom_targeting3($this->post());
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('custom_success_updated')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_edit_custom')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}

	function add_custom_targeting4_post()
	{	
		$this->form_validation->set_rules('custom_name', 'lang:custom_name', 'required|trim');		
		$this->form_validation->set_rules('custom_value', 'lang:custom_value', 'required|trim|is_unique['.TAB_CUSTOM_TARGETING4.'.value]');
		$this->form_validation->set_message('is_unique', $this->lang->line('custom_targeting_registered_message'));
		if($this->form_validation->run() === FALSE){  
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	 
			$custom = $this->Do_targeting->add_custom_targeting4($this->post());  
			
			if($custom !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('custom_added_succ')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_add_custom')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}
	
	public function fetch_custom_targeting4_get()
	{
       $custom_targeting_list=$this->Do_targeting->fetch_custom_targeting4();

	   $this->response($custom_targeting_list); 
	}
    
	
	public function custom_targeting4_list_get()
	{
	   $id = $this->get('id');
		   if($id)
		   {
			$target_list = $this->Do_targeting->fetch_custom_targeting4_select($id);
			$this->response($target_list);
		   }
	}
	
	public function update_custom_targeting4_post()
	{	   
		$this->form_validation->set_rules('custom_name', 'lang:custom_name', 'required|trim|edit_unique['.TAB_CUSTOM_TARGETING4.'~name~id~'.$this->post('target_id').']');
		$this->form_validation->set_rules('custom_value', 'lang:custom_value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$category = $this->Do_targeting->update_custom_targeting4($this->post());
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('custom_success_updated')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_edit_custom')
					);
				
				$this->response( $success, 200);
			}
			
						
		}
	}

   public function delete_custom_targeting_get()
   {
      $id = $this->get('del_target_id');
	  $table=$this->get('del_target_table');
	  
	   if($id)
		{  
			$targeting_list = $this->Do_targeting->delete_custom_targeting($id,$table);
			
			if($table=="TAB_CUSTOM_TARGETING1")
			{  
				$msg=$this->lang->line('delete_custom_targeting1');
			}
			else if($table=="TAB_CUSTOM_TARGETING2")
			{  
				$msg=$this->lang->line('delete_custom_targeting2');
			}
			else if($table=="TAB_CUSTOM_TARGETING3")
			{  
				$msg=$this->lang->line('delete_custom_targeting3');
			}	
			else if($table=="TAB_CUSTOM_TARGETING4")
			{  
				$msg=$this->lang->line('delete_custom_targeting4');
			}	
			
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $msg
							 );
			
			$this->response( $success, 200);
			
		}
		else
		{  			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('target_id_ntfound')
					);
			
			$this->response( $error, 200);
		}

   }
   
    public function block_custom_targeting_get()
	{
		$target_id=$this->get('targetblock_id');
		$table=$this->get('target_table');
		if($target_id)
		{
			$block_list = $this->Do_targeting->block_custom_targeting($target_id,$table);
			
			if($table=="TAB_CUSTOM_TARGETING1")
			{  
				$msg=$this->lang->line('custom_target_blkd_succ1');
			}
			else if($table=="TAB_CUSTOM_TARGETING2")
			{  
				$msg=$this->lang->line('custom_target_blkd_succ2');
			}
			else if($table=="TAB_CUSTOM_TARGETING3")
			{  
				$msg=$this->lang->line('custom_target_blkd_succ3');
			}	
			else if($table=="TAB_CUSTOM_TARGETING4")
			{  
				$msg=$this->lang->line('custom_target_blkd_succ4');
			}	
						
			$success = array('response'	=> 'ok',
							 'msg'		=> $msg
							 );
			
			$this->response( $success, 200);
		}
	}
	public function unblock_custom_targeting_get()
	{
		$target_id=$this->get('targetunblock_id');
		$table=$this->get('target_unblock_table');	
		if($target_id)
		{
			$unblock_list = $this->Do_targeting->unblock_custom_targeting($target_id,$table);
			
			if($table=="TAB_CUSTOM_TARGETING1")
			{  
				$msg=$this->lang->line('custom_target_un-blkd_succ1');
			}
			else if($table=="TAB_CUSTOM_TARGETING2")
			{  
				$msg=$this->lang->line('custom_target_un-blkd_succ2');
			}
			else if($table=="TAB_CUSTOM_TARGETING3")
			{  
				$msg=$this->lang->line('custom_target_un-blkd_succ3');
			}	
			else if($table=="TAB_CUSTOM_TARGETING4")
			{  
				$msg=$this->lang->line('custom_target_un-blkd_succ4');
			}	
			
			
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $msg
							 );
			
			$this->response( $success, 200);
		}
	}	
}
