<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Site extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_site');
		$this->load->model('Do_rtb');
        $this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }		   
	}
	
	
	//api/v1/site/add
	function add_post(){
		//$this->response($this->post(),200);
		//$this->form_validation->set_rules('site_name','lang:site_name', 'required|trim|alpha_numeric_dash_space');
		$this->form_validation->set_rules('site_name','lang:site_name', 'required|trim');
		$this->form_validation->set_rules('site_url', 'lang:website_url', 'required|trim|valid_url|is_unique['.TAB_PUB_SITES.'.site_url]'); 

		//~ $this->form_validation->set_rules('site_url', 'lang:website_url', 'required|trim|valid_url|callback_site_check'); //|url_exists
		$this->form_validation->set_message('is_unique', 'Already this website url is being registered. please enter the unique one');
		//$this->form_validation->set_rules('category', 'Category', 'required');
		//added by selvaraj .k
		$type_bidding=$this->post('type_bidding');
		if($type_bidding==1)
		{
		$this->form_validation->set_rules('category', 'lang:category', 'required');
		}
	
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			#$account_id = $this->post('account_id');
			$user_auth  = $this->user_authentication;
			$account_id = $user_auth->account_id;

			 $approval_type=$this->Do_site->fetch_site_approval_type();
			 //print_r($approval_type);exit;
				if($approval_type=="Approve by Admin")
				{
					$dj_admin_approve='0';$dj_approved_date='';
				}
				if($approval_type=="Auto Approval")
				{
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				
     
			 $site_id = $this->Do_site->add($account_id,$dj_admin_approve,$this->post());
			
			if($site_id != FALSE){
       /***********************************/
         if($type_bidding == 1)
        {
			 $dsp_id = implode(",",$this->post('select_dsp'));
			 
			 if($dsp_id)
			 {
				 
		//print_r($dsp_id);exit;
				$this->Do_rtb->add_aff_dsp_assoc($site_id, $dsp_id);
				//print_r($this->db->last_query());exit; 
			 }
		 }
			 /***********************************/

			
				if(is_array($this->post('category')) AND count($this->post('category')) > 0){
					$this->Do_site->set_assoc_category($site_id,$this->post('category'));
			
					
				}

				if (is_array($this->post('blocked_category')) AND count($this->post('blocked_category')) > 0) {
					$this->Do_site->set_assoc_blocked_category($site_id, $this->post('blocked_category'));
				
				}
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('site_added_successfully')
					);
					$this->response( $success, 200);
			}
						
		}
	}
	

	 /*
	 * 
	 *added by karthika on dec-12
	 */
	
	function fetch_pub_get()
	{
		$site_id = $this->get('site_id');

		if($site_id)
		{
			$site_data = $this->Do_site->fetch_publisher($site_id);

			if($site_data)
			{
			  $this->response($site_data[0]['account_id'], 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}		
	}
	/* end */
	
	function fetch_get()
	{
		//Get from library file
		$account_id = $this->user_authentication->account_id;
		if($account_id){
			//fetch approved sites only
			$where = array('account_id'=>$account_id);
			$site_list = $this->Do_site->fetch($where);
			$this->response($site_list);
		}
	}
	
	/**
       * 
       * name : fetch_approveSite_get()
       * 
       * Fetches the approved website information while adding adblocks
       * 
       * @return website details
    **/
	function fetchapproveSite_get()
	{
		//Get from library file
		$account_id = $this->user_authentication->account_id;
		if($account_id){
			//fetch approved sites only
			$where = array('account_id'=>$account_id);
			$site_list = $this->Do_site->fetchsite($where);
			$this->response($site_list);
		}
	}
		
	function fetch1_get()
	{
		//Get from library file
		$account_id = $this->user_authentication->account_id;
		if($account_id){
			$where = array('account_id'=>$account_id);
			$site_list = $this->Do_site->fetch1($where);
			$this->response($site_list);
		}
	}
	
	function fetch2_get()
	{
		
		$account_id = $this->user_authentication->account_id;
		
		if($account_id){
			$where = array('dps.account_id'=>$account_id);
			
			$site_list = $this->Do_site->fetch2($where);
			if($site_list)
			{
				$this->response($site_list,200);
			}
			else
			{
				$this->response("1",200);
			}
			
		}
	}
	
	/**
       * 
       * name : fetch_site_get()
       * 
       * Fetches the individual website information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_site_get(){
		
		 $site_id = $this->get('site_id');
		
		if($site_id){
			
			$site_list = $this->Do_site->get_info($site_id);
			$this->response($site_list);
			
		}else{
			$error = array(
								'response' => 'error',
								'msg' =>  $this->lang->line('not_crct_site_id')
							);

			 $this->response( $error, 200);	
		}
	}
	
	/**
       * 
       * name : fetch_site_cat_get()
       * 
       * Fetches the Site category association
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_site_cat_get(){
		
		 $site_id = $this->get('site_id');
		
		if($site_id){
			
			$site_cat_assoc = $this->Do_site->get_site_category_assoc($site_id);
			$this->response($site_cat_assoc);
			
		}else{
			$error = array(
								'response' => 'error',
								'msg' =>  $this->lang->line('not_crct_site_id')
							);

			 $this->response( $error, 200);	
		}
	}


	/**
	 *
	 * name : fetch_site_block_cat_get()
	 *
	 * Fetches the Site category association
	 *
	 * @return boolean (or) string Returns the object on TRUE (or) FALSE
	 */
	function fetch_site_block_cat_get()
	{

		$site_id = $this->get('site_id');


		if ($site_id) {
			
			$site_cat_assoc = $this->Do_site->get_site_blocked_category_assoc($site_id);
			$this->response($site_cat_assoc);

		} else {
			$error = array(
				'response' => 'error',
				'msg' => $this->lang->line('not_crct_site_id')
			);

			$this->response($error, 200);
		}
	}


	/**
	 *
       * name : update_post()
       * 
       * Updates the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		 //$this->response($this->post(),200);
		$this->form_validation->set_rules('site_name','lang:site_name', 'required|trim');
		$this->form_validation->set_rules('site_url', 'lang:website_url', 'required|trim|url|edit_unique['.TAB_PUB_SITES.'~site_url~site_id~'.$this->post('site_id').']');
		
		if($this->post('category') == null){
			$this->form_validation->set_rules('site_url', 'lang:website_url', 'required|trim|url');
		}else if($this->post('category') != null && $this->post('site_url') != null){
			$this->form_validation->set_rules('site_url', 'lang:website_url', 'required|trim|url');
		}else{
			$this->form_validation->set_rules('site_url', 'lang:website_url', 'required|trim|url|edit_unique['.TAB_PUB_SITES.'~site_url~site_id~'.$this->post('site_id').']');
		}
		//added by selvaraj k
		$type_bidding=$this->post('type_bidding');
		
		//~ if($type_bidding==1)
		//~ {
			$this->form_validation->set_rules('category','lang:dsp_site_cat', 'required');
		//~ }
		//~ $this->response($this->form_validation->run());
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
		 $approval_type=$this->Do_site->fetch_site_approval_type();
			
			
				if($approval_type=="Approve by Admin")
				{
				
					$dj_admin_approve='0';$dj_approved_date='';
						
					
				}
				if($approval_type=="Auto Approval")
				{
					$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
						
					
				}
               //echo $dj_admin_approve; exit;
			$site_id = $this->Do_site->update($this->post(),$dj_admin_approve);
			//echo $site_id; exit;
						if($site_id){
			
			 if($type_bidding == 1)
			{					
				if($this->post('dsp')[0]!='all'){		
					$dsp_id = implode(",",$this->post('dsp'));
				}else
				 {			
					 $dsp_id =  $this->post('dsp')[0];
				 }
		
			 if($dsp_id)
			 {
		 $siteid= $this->Do_rtb->update_aff_dsp_assoc($site_id, $dsp_id);
				//print_r($this->db->last_query());exit; 
			 }
		 }else{
			  $siteid = $this->Do_rtb->delete_dsp_assoc($site_id);
			 
		 }
	 }
		if( $siteid){	
			$this->Do_site->set_assoc_category($site_id,$this->post('category'));

			$this->Do_site->set_assoc_blocked_category($site_id, $this->post('blocked_category'));
			
			//2-17-2017  dsp to aff assoc table update - start	
			//$this->response($this->post(),200);
		//	$site_id = $this->Do_rtb->dsp_update($this->post());
			//2-17-2017  dsp to aff assoc table update - end
			
			/* dsb virtual banners linkin concept funtcion start */
			$site_id = $this->Do_rtb->dsp_zone_linking($this->post());
			/* dsb virtual banners linkin concept funtcion end */
			//$this->response($this->post(),200);
			
				
			$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('site_updated_successfully')
					);
					$this->response( $success, 200);
		}
		else{
		
		$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('site_not_found')
					);
			
			$this->response( $error, 200);
	}
			
		}	
		
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{
		
		$site_id = $this->get('site_id');	
		
		if($site_id)
		{
			$site_id = $this->Do_site->remove($site_id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('site_deleted')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('site_not_found')
					);
			
			$this->response( $error, 200);
		}
	}
	
}
