<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Analytics (Generalize Things)
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Rtb extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_web_adblock');
		$this->load->model('Do_email_check');
		$this->load->model('Do_rtb');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }	
	}
	
	/* 
	* name: fetch_post
	* @param : null
	* @return : return all data from rtb
    */
	public function fetch_get()
	{
	   $agency_id=$this->user_authentication->agency_id;
	   $rtb_type=$this->get('rtb_type');
	   
	   $rtb_list=$this->Do_rtb->fetch_rtb_list($agency_id,$rtb_type);
	   //$this->response( $this->db->last_query(), 200);
	   if($rtb_list)
	     {
		   $this->response( $rtb_list, 200);
		 } 
	}
	
	/* 
	* name: fetch_post
	* @param : null
	* @return : return all data from rtb
    */
    //Added by Kavin by add rtb 26.7.17
	public function add_post()
	{
		
		if(trim($this->post('type'))=='DSP')
		{
			$this->form_validation->set_rules('adx_name_dsp','ad_exchange_name', 'required');
			$this->form_validation->set_rules('email', 'lang:email_address', 'required|trim|is_email|callback_dsp_email_check');
			$this->form_validation->set_rules('ping_url_dsp', 'lang:ping_url', 'required|trim|callback_ping_url');
		}
		else
		{
			$this->form_validation->set_rules('adx_name_dsp','ad_exchange_name', 'required');
			$this->form_validation->set_rules('email', 'lang:email_address', 'required|trim|is_email|callback_dsp_email_check');
		}
		$rtb_check=($this->post('is_strict_rtb')!='on')?'0':'1';
		if($this->form_validation->run() === FALSE)
		{	
			
			
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response1' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
//$this->response($this->post('type'));
			
				
			if(trim($this->post('type'))=='SSP')
			{
				$ping_url='requests.php?ex=';
				
				$add_data=array( 
					'exchange_name'=>clean_data($this->post('adx_name_dsp')),
                    'name'=>clean_data($this->post('adx_name_dsp')),
                    'added_on' => date('Y-m-d H:i:s'),
                    'is_stirct_open_rtb_standard' => $rtb_check,
                    'status' => 1,
                    'ping_url' => $ping_url,
                    'email'=> clean_data($this->post('email')),
                    'username' => clean_data($this->post('user_name')),
                    'password' => clean_data($this->post('user_pass')),
                    'seller_id' => clean_data($this->post('sell_id')),
                    'authentiction_key' => clean_data($this->post('auth_key')),
                    'auction_currency' => clean_data($this->post('auction_currency')),
                    'auction_type' => clean_data($this->post('bid_type')),
                    'type' => clean_data($this->post('type')),
                    'agency_id' => $this->user_authentication->agency_id,
                    'rtb_mode' => clean_data($this->post('rtb_mode')),
                    'rtb_version' => clean_data($this->post('rtb_version')),
						  );
						 // $this->response( $add_data, 200);
			}
			else
			{
				 $add_data = array(
                    'exchange_name'=>clean_data($this->post('adx_name_dsp')),
                    'name'=>clean_data($this->post('adx_name_dsp')),
                    'added_on' => date('Y-m-d H:i:s'),
                    'is_stirct_open_rtb_standard' => $rtb_check,
                    'status' => 1,
                    'ping_url' => clean_data($this->post('ping_url_dsp')),
                    'email'=> clean_data($this->post('email')),
                    'username' => clean_data($this->post('user_name')),
                    'password' => clean_data($this->post('user_pass')),
                    'seller_id' => clean_data($this->post('sell_id')),
                    'authentiction_key' => clean_data($this->post('auth_key')),
                    'auction_currency' => clean_data($this->post('auction_currency')),
                    'auction_type' => clean_data($this->post('bid_type')),
                    'type' => clean_data($this->post('type')),
                    'agency_id' => $this->user_authentication->agency_id,
                    'rtb_mode' => clean_data($this->post('rtb_mode')),
                    'rtb_version' => clean_data($this->post('rtb_version')),
                );
					
			}	  
			
			
			$add_res=$this->Do_rtb->add_rtb_details($add_data);
		//print_r($add_res);exit;
			
			if($add_res && $this->post('type')=='DSP'){
				$pingurl_id = $this->post('ping_url_dsp');
			}else{
				$pingurl_id = 'requests.php?ex='.$add_res;
				$ping_url=$this->Do_rtb->update_ping_url($add_res,$pingurl_id);
			}

		    //

//$this->response($this->db->last_query());


			if($add_res)
			{		
				if (trim($this->post('type')) == 'SSP') {
					
					$ping_url=clean_data($this->post('ping_url_dsp'));
					
					$tmp = strstr($ping_url, '=');
					$account_name = strtok(substr($tmp, 1),'.');
					$cur_date=date('Y-m-d H:i:s'); 
					$obj['exc_id']=$add_res;
					$obj['first_name']=clean_data($this->post('adx_name_dsp'));
					$obj['cur_date']=$cur_date;
					$obj['email']= clean_data($this->post('email'));
					$obj['account_type']="TRAFFICKER";
					$obj['dj_is_dsp']=$add_res;
					$obj['agency_id']=$this->user_authentication->agency_id;
					$obj['password']="123456";
					$obj['site_url']="www.".$account_name.rand().".com";
					
					$rtb_pub=$this->Do_rtb->add_publisher($obj);

					// copy('request.php',$file);

				}

				 if (trim($this->post('type')) == 'DSP') {
					$dsp_exchange_name = $this->post('adx_name_dsp');
				 $account_details = array(
				 'account_type'=>'ADVERTISER',
				 'account_name'=>$dsp_exchange_name,
				 'exchange_id'=>$add_res
				 );
				 $account_id = $this->Do_rtb->add_dsp_accounts($account_details);
				 
				/// $email = $this->post('adx_name_dsp').'@dsp.com';
				 $email = clean_data($this->post('email'));
				  $dsp_exchange_name = clean_data($this->post('email'));
				 $date_time = date('Y-m-d H:i:s');
				 $exchange_id = $add_res;
				 //$this->response($exchange_id);
				  $client_details = array(
				 'agencyid'=>'1',
				 'clientname'=>$dsp_exchange_name,
				 'contact'=>'Dsp user',
				 'email'=>$email,
				 'report'=>'f',
				 'reportinterval'=>'7',
				 'updated'=>$date_time,
				 'account_id'=>$account_id,
				 'dj_approval_status'  	=> 	1,
				 'advertiser_limitation'=>'0',
				 'type'=>'0',
				 'exchange_id'=>$exchange_id
				 );
				// $this->response($client_details);
				 $client_id = $this->Do_rtb->add_dsp_client($client_details);
				 
				for($i=1;$i<=2;$i++){
				 	if($i==1)
					{
				$campaign_details = array(
				'campaignname'=>$dsp_exchange_name." - WEB",
				'clientid'=>$client_id,
				'views'=>'-1',
				'clicks'=>'-1',
				'conversions'=>'-1',
				'priority'=>'-5',
				'weight'=>'1',
				'target_impression'=>'0',
				'target_click'=>'0',
				'target_conversion'=>'0',
				'anonymous'=>'f',
				'companion'=>'0',
				'comments'=>'',
				'revenue'=>'',
				'revenue_type'=>'1',
				'updated'=>$date_time,
				'block'=>'0',
				'capping'=>'0',
				'session_capping'=>'0',
				'status'=>'1', 
				'hosted_views'=>'0',
				'hosted_clicks'=>'0',
				'viewwindow'=>'0',
				'clickwindow'=>'0',
				'ecpm'=>'',
				'min_impressions'=>'100',
				'ecpm_enabled'=>'0',
				'activate_time'=>$date_time,
				'type'=>'0',
				'show_capped_no_cookie'=>'0',
				'adomain'=>'http://maxxrtb.com',
				'dj_category_id' => 'IAB1',
				'dj_targetting_type'=>'WEB',
				'exchange_id'=>$exchange_id
				); 
				$Web_campaign_id = $this->Do_rtb->add_dsp_campaign($campaign_details);
				}
				if($i==2)
					{
				$campaign_details = array(
				'campaignname'=>$dsp_exchange_name.' - MOBILE',
				'clientid'=>$client_id,
				'views'=>'-1',
				'clicks'=>'-1',
				'conversions'=>'-1',
				'priority'=>'-5',
				'weight'=>'1',
				'target_impression'=>'0',
				'target_click'=>'0',
				'target_conversion'=>'0',
				'anonymous'=>'f',
				'companion'=>'0',
				'comments'=>'',
				'revenue'=>'',
				'revenue_type'=>'1',
				'updated'=>$date_time,
				'block'=>'0',
				'capping'=>'0',
				'session_capping'=>'0',
				'status'=>'1', 
				'hosted_views'=>'0',
				'hosted_clicks'=>'0',
				'viewwindow'=>'0',
				'clickwindow'=>'0',
				'ecpm'=>'',
				'min_impressions'=>'100',
				'ecpm_enabled'=>'0',
				'activate_time'=>$date_time,
				'type'=>'0',
				'show_capped_no_cookie'=>'0',
				'adomain'=>'http://maxxrtb.com',
				'dj_category_id' => 'IAB1',
				'dj_targetting_type'=>'MOBILE',
				'exchange_id'=>$exchange_id
				); 
				$mobile_campaign_id = $this->Do_rtb->add_dsp_campaign($campaign_details);
				}
			}
				$width='';$height='';
				for($i=1;$i<=9;$i++){
					if($i==1)
					{
					$storagetype = 'html';
					$contenttype = 'jpeg';
					$desc=$dsp_exchange_name." buyer Image ads served to opted in campaigns";
					$bannertype="bannerTypeHtml:oxHtml:genericHtml";
					$dj_bannertype=WEB_CREATIVE_WEB;
					$dj_master_banner=0;
					$campaign_id=$Web_campaign_id;
					}
					if($i==2)
					{
					$storagetype = 'html';
					$contenttype = 'txt';
					$desc=$dsp_exchange_name." buyer Text ads served to opted in campaigns";
					$bannertype="bannerTypeText:oxText:genericText";
					$dj_bannertype=WEB_CREATIVE_TEXT;
					$dj_master_banner=0;
					$campaign_id=$Web_campaign_id;
					}
					if($i==3)
					{
					$storagetype = 'html';
					$contenttype = 'gif';
					$desc=$dsp_exchange_name." buyer Video ads served to opted in campaigns";
					$width='-3';
					$height='-3';
					$bannertype="bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml";
					$dj_bannertype=VIDEO_CREATIVE_INLINE;
					$dj_master_banner=0;
					$campaign_id=$Web_campaign_id;
					}
					if($i==4)
					{
					$storagetype = 'web';
					$contenttype = 'png';
					$width='0';
					$height='0';
					$dj_master_banner=-2;
					$desc=$dsp_exchange_name." buyer Mobile Image ads served to opted in campaigns";
					$bannertype="NULL";
					$dj_bannertype=MOBILE_IMAGE_CREATIVE;
					$campaign_id=$mobile_campaign_id;
					}
					if($i==5)
					{
					$storagetype = 'txt';
					$contenttype = 'txt';
					$dj_master_banner=0;
					$desc=$dsp_exchange_name." buyer Mobile Text ads served to opted in campaigns";
					$bannertype="NULL";
					$dj_bannertype=MOBILE_TEXT_CREATIVE;
					$campaign_id=$mobile_campaign_id;
					}
					if($i==6)
					{
					$storagetype = 'html';
					$contenttype = 'gif';
					$desc=$dsp_exchange_name." buyer Mobile Video inline ads served to opted in campaigns";
					$width='-3';
					$height='-3';
					$bannertype="bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml";
					$dj_bannertype=MOBILE_VIDEO_CREATIVE_INLINE;
					$dj_master_banner=-1;
					$campaign_id=$mobile_campaign_id;
					
					}
					if($i==7)
					{
					$storagetype = 'html';
					$contenttype = 'gif';
					$desc=$dsp_exchange_name." buyer Mobile Video overlay ads served to opted in campaigns";
					$width='-2';
					$height='-2';
					$bannertype="bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml";
					$dj_bannertype=MOBILE_VIDEO_CREATIVE_OVERLAY;
					$dj_master_banner=-1;
					$campaign_id=$mobile_campaign_id;
					}
					if($i==8)
					{
					$storagetype = 'html';
					$contenttype = 'mp4';
					$desc=$dsp_exchange_name." buyer Mobile app Video ads served to opted in campaigns";
					$width='-6';
					$height='-6';
					$bannertype="bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml";
					$dj_bannertype=MOBILE_VIDEO_CREATIVE_INTERSTITAL;
					$dj_master_banner=-1;
					$campaign_id=$mobile_campaign_id;
					}
					if($i==9)
					{
					$storagetype = 'html';
					$contenttype = 'gif';
					$desc=$dsp_exchange_name." buyer Web Video overlay ads served to opted in campaigns";
					$width='-2';
					$height='-2';
					$bannertype="bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml";
					$dj_bannertype=VIDEO_CREATIVE_OVERLAY;
					$dj_master_banner=0;
					$campaign_id=$Web_campaign_id;
					}
					
					$banner_details = array(
					'campaignid'=>$campaign_id,
					'contenttype'=>$contenttype,
					'pluginversion'=>'0',
					'storagetype'=>$storagetype,
					'filename'=>'',
					'imageurl'=>'',
					'htmltemplate'=>'',
					'htmlcache'=>'',
					'width'=>$width,
					'height'=>$height,
					'weight'=>'1',
					'seq'=>'0',
					'target'=>'',
					'url'=>'',
					'alt'=>'',
					'statustext'=>'',
					'bannertext'=>'',
					'description'=>$desc,
					'adserver'=>'',
					'block'=>'0',
					'capping'=>'0',
					'session_capping'=>'0',
					'compiledlimitation'=>'',
					'acl_plugins'=>'',
					'append'=>'',
					'bannertype'=>'',
					'alt_filename'=>'',
					'alt_imageurl'=>'',
					'alt_contenttype'=>'gif',
					'comments'=>'',
					'updated'=>$date_time,
					'acls_updated'=>'',
					'keyword'=>'',
					'transparent'=>'0',
					'parameters'=>'',
					'status'=>'1',
					'dj_master_banner'=>$dj_master_banner,
					'ext_bannertype'=>$bannertype,
					'prepend'=>'',
					'dj_banner_type'=>$dj_bannertype,
					'dj_added_date'=>$date_time,
					'dj_admin_approve'=>'1',
					'dj_approved_date'=>$date_time,
					'dj_account_id'=>$account_id,
					'dj_approve_mode'=>'1',
            		'exchange_id'=>$exchange_id
					);
				    $this->Do_rtb->add_dsp_banner($banner_details);

				}
			}
			
			if(trim($this->post('type'))=='SSP'){
				$success = array( 'response' => 'ok',
						'msg'	 =>$this->lang->line('add_ssp_success')//'RTB sucessfully added',
								);
				$this->response( $success, 200);
				
			}else{	
				
				
				$success = array( 'response' => 'ok',
						'msg'	 =>$this->lang->line('add_dsp_success')//'RTB sucessfully added',
								);
				$this->response( $success, 200);
			}
			}
			else
			{
				
				
			   $success = array(
					'response' => 'error',
					'msg'	 => $this->lang->line('error_try_again'),
				);
				
				$this->response( $success, 200);
			 } 
		}
	}
	//Added by Kavin by add rtb 26.7.17
	
	public function get_rtb_edit_get()
	{ 
         $exchange_id=$this->get('exchange_id');
         $type=$this->get('type');
		
		 $api_key=$this->Do_rtb->get_rtb_details($exchange_id,$type);
		 
	     $this->response($api_key, 200);
	}
	
	public function edit_post()
	{
		
	   if(trim($this->post('type'))=='DSP')
		{
			$this->form_validation->set_rules('adx_name_dsp','ad_exchange_name', 'required');
			$this->form_validation->set_rules('email', 'lang:email_address', 'required|trim|is_email|callback_edit_dsp_email_check');
			$this->form_validation->set_rules('ping_url_dsp', 'lang:ping_url', 'required');
		}
		else
		{
			$this->form_validation->set_rules('adx_name_dsp','ad_exchange_name', 'required');
			$this->form_validation->set_rules('email', 'lang:email_address', 'required|trim|is_email|callback_edit_dsp_email_check');
		}
		
		
	    $rtb_check=($this->post('is_strict_rtb')!='on')?'0':'1';
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			
	  $type=$this->post('type');
		if($type=='SSP')
	   {
		   //'ping_url'=>clean_data($this->post('ping_url_ssp')),
	   $add_data=array( 
						'exchange_id'=>clean_data($this->post('exchange_id')),
	                    'exchange_name'=>clean_data($this->post('adx_name_dsp')),
						'is_stirct_open_rtb_standard'=>$rtb_check,
						
						'username'=>clean_data($this->post('user_name')),
						'password'=>clean_data($this->post('user_pass')),
						'seller_id'=>clean_data($this->post('sell_id')),
						'authentiction_key'=>clean_data($this->post('auth_key')),
						'auction_currency'=>clean_data($this->post('auction_currency')),
						'auction_type'=>clean_data($this->post('bid_type')),
						'type'=> $type,
						'name'   =>clean_data($this->post('name')),
						'email'   =>clean_data($this->post('email')),
						'rtb_version'   =>clean_data($this->post('rtb_version')),
						'rtb_mode' => clean_data($this->post('rtb_mode'))
					  );
	  }
	  else
	  {
		  $add_data=array( 
						'exchange_id'=>clean_data($this->post('exchange_id')),
	                    'exchange_name'=>clean_data($this->post('adx_name_dsp')),
						'is_stirct_open_rtb_standard'=>$rtb_check,
						'ping_url'=>clean_data($this->post('ping_url_dsp')),
						'username'=>clean_data($this->post('user_name')),
						'password'=>clean_data($this->post('user_pass')),
						'seller_id'=>clean_data($this->post('sell_id')),
						'authentiction_key'=>clean_data($this->post('auth_key')),
						'auction_currency'=>clean_data($this->post('auction_currency')),
						'auction_type'=>clean_data($this->post('bid_type')),
						'type'=>$type,
						'name'   =>clean_data($this->post('name')),
						'email'   =>clean_data($this->post('email')),
						'rtb_version'   =>clean_data($this->post('rtb_version')),
						'rtb_mode' => clean_data($this->post('rtb_mode'))
					  );
	  }
	  
	  
	   $edit_res=$this->Do_rtb->edit_rtb_details($add_data);	   
	   	 
	   if($edit_res)
	     {
		//$this->response($this->post('type')); 
			 
			if(trim($this->post('type'))=='DSP')
			{   
				
				$cur_date=date('Y-m-d H:i:s'); 
				$obj['cur_date']=$cur_date;
				$obj['dj_is_dsp']=clean_data($this->post('exchange_id'));
				$obj['first_name']=clean_data($this->post('name'));
				$obj['email']= clean_data($this->post('email'));			
				$rtb_pub=$this->Do_rtb->edit_publisher($obj);			
				 
			} else{
				$obj['exchange_id']=clean_data($this->post('exchange_id'));
				$obj['email_address']= clean_data($this->post('email'));			
				$rtb_pub=$this->Do_rtb->edit_email($obj);			
				
				
			}
			// $this->response($this->db->last_query()); 
		   $success = array(
				'response' => 'ok',
				'msg'	 => $this->lang->line('edit_rtb_success'),
									);
					$this->response( $success, 200);
		 }
		 else
		 {
		   $success = array(
				'response' => 'error',
				'msg'	 => $this->lang->line('error_try_again'),
									);
					$this->response( $success, 200);
		 } 
	}
}
	
	/**
       * 
       * name : block_get()
       * 
       * block the RTB information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function block_rtb_get()
	{	
		$exchange_id = $this->get('id');	
		
		$type = $this->get('type');
		
		if($exchange_id)
		{
			$rtb 	= 	$this->Do_rtb->block($exchange_id);
			
			
			if($type == 'DSP')
			{
				$msg=array( 'response' => 'ok',
				'msg' => $this->lang->line('DSP_blocked_successfully')
			        );				
				
			}
			else
			{
				$msg=array( 'response' => 'ok',
				'msg' => $this->lang->line('SSP_blocked_successfully')
			        );				
			}
		    $this->response($msg,200);			
		}
	}
	
	/**
       * 
       * name : unblock_rtb_get()
       * 
       * Unblock the RTB information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function unblock_rtb_get()
	{	
		$exchange_id = $this->get('id');	
		$type = $this->get('type');
		if($exchange_id)
		{
			$rtb 	= 	$this->Do_rtb->unblock($exchange_id);
			
			if($type == 'DSP')
			{
				$msg=array( 'response' => 'ok',
				'msg' => $this->lang->line('DSP_unblocked_successfully')
			        );				
				
			}
			else
			{
				$msg=array( 'response' => 'ok',
				'msg' => $this->lang->line('SSP_unblocked_successfully')
			        );				
			}

		    $this->response($msg,200);			
		}
	}

	/*ping_url_check Check
	 * 
	 * 
	 * */ 
	
	function ping_url()
	{
		
		if($this->post('ping_url_ssp')!='')
		{
			$sspdsp_url		=	strtolower($this->post('ping_url_ssp'));
		}
		if($this->post('ping_url_dsp')!='')
		{
			$sspdsp_url		=	strtolower($this->post('ping_url_dsp'));
		}
		 
		
		$count 		= 	$this->Do_email_check->ping_url_check($sspdsp_url);
		 
		if($count>0)
		{
			$this->form_validation->set_message('ping_url', $this->lang->line('unique_ping_url'));
			return FALSE;
		}
		else
		{

			return TRUE;
		}
	}
	
	
	
	
	
	
		function fetch_dspdetails_get(){

		$zone_id = $this->get('zone_id');
		

		if($zone_id){

		$dsp_assoc = $this->Do_rtb->get_dsp_assoc($zone_id);

		$this->response($dsp_assoc,200);

		}else{
		$error = array(
		'response' => 'error',
		'msg' =>  'Not a correct site id'
		);

		$this->response( $error, 200);	
		}
		}




	/*
	 * 
	 * name: email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 * added by vivek
	 */
	
	public function email_check()
	{
		$email		=	$this->post('email');
		
		$count		=	$this->Do_email_check->dup_email_check($email);	
		
		
		if($count>0 )
		{
			$this->form_validation->set_message('email_check', $this->lang->line('email_address_exists'));
			return FALSE;	
		}
		else
		{
			return true;
		}
	}
	
	public function dsp_email_check()
	{
		$email		=	$this->post('email');
		
		$others_count		=	$this->Do_email_check->dup_email_check($email);	
		
		$dsp_count		=	$this->Do_email_check->dsp_dup_email_check($email);	
		 
		$count = $others_count + $dsp_count;	

		   
		if($count>0 )
		{
				
			$this->form_validation->set_message('dsp_email_check', $this->lang->line('email_address_exists'));
			return FALSE;	
		}
		else
		{
			
			return true;
		}
	}
	
		
	/*
	 * 
	 * name: edit_email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 * added by vivek
	 */

	function edit_email_check()
	{
		$account_id	=	$this->post('account_id');
		$email		=	$this->post('email');
		$exchange_id		=	$this->post('exchange_id');
		$count 		= 	$this->Do_email_check->dup_email_check($email,$account_id,$exchange_id);
		
		if($count>0 )
		{
			$this->form_validation->set_message('edit_email_check', $this->lang->line('email_address_exists'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function edit_dsp_email_check()
	{
		$account_id	=	$this->post('account_id');
		$email		=	$this->post('email');
		$exchange_id		=	$this->post('exchange_id');
		$others_count 		= 	$this->Do_email_check->dup_email_check($email,$account_id,$exchange_id);
		
		$dsp_count		=	$this->Do_email_check->dsp_dup_email_check($email,$exchange_id);	
		 
		$count = $others_count + $dsp_count;
		
		if($count>0 )
		{
			$this->form_validation->set_message('edit_dsp_email_check', $this->lang->line('email_address_exists'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
		
}
