<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Analytics (Generalize Things)
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Roles extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_roles');
		$this->load->model('Do_networks');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }	
	}
	
	/* 
	* name: add_roles_post
	* @param : null
	* @return : insert added roles into djax_rols and djax_role_assoc
    */
	public function add_role_post()
	{
		//$this->response($this->post(),200);
	   if($this->post('process')!='UPDATE')
	    {
	   		//IF INSERT 
			$role_list=$this->Do_roles->add_role($this->post());
	    }
	   else
	    { 
		    //IF UPDATE
			$role_list=$this->Do_roles->update_role($this->post());
		}
	   if($role_list && $this->post('process')!='UPDATE')
	     {
		   $success = array( 'response' => 'ok',
							 'msg'	 => $this->lang->line('roles_added_succ')
					       );	 			 
		   $this->response( $success, 200);
		 }
	   else 
	     {
		    $success = array( 'response' => 'ok',
						    'msg'	 => $this->lang->line('roles_updated_succ')
					      );
			$this->response( $success, 200);
		 }
	}

	// added on 12-06-2017
	public function add_user_post()
	{
	  
	   	
	$role_list=$this->Do_roles->add_user($this->post());
	  
	  
	   if($role_list)
	     {
		  $success = array(
							'response' => 'ok',
							'msg'	 => $this->lang->line('roles_added_succ')
			);
			 $this->response($success, 200);
		 }
	}
	// end


	// added on 13-06-2017
	public function check_permission_post()
	{
		$check = $this->Do_roles->check_user($this->post());

		if($check)
	     {
			$this->response('null', 200);
		 }else{
		  $success = array(
							'response' => 'ok',
							'msg'	 => $this->lang->line('please_set_permission')
			);
			 $this->response($success, 200);
		 }
	}
	// end
	
	/* 
	* name: edit_role_post
	* @param : null
	* @return : update added role permission into djax_rols and djax_role_assoc
    */
	public function fetch_role_get()
	{
        $role_id = $this->get('id');
		$role_list=$this->Do_roles->fetch_role($role_id);
		$this->response($role_list,200); 
	}
	
	public function fetch_role_permission_get()
	{
	    $role_id = $this->get('id');
		$role_list=$this->Do_roles->fetch_role_permission($role_id);
		$this->response($role_list,200); 
	}
	
	/* 
	* name: fetch_user_role_list_get
	* @param : null
	* @return : fetch all user_role list from djax_roles
   */
	public function fetch_user_role_list_get()
	{
	    $user_role_list=$this->Do_roles->fetch_user_role_list();
	    
	    if($user_role_list){
			$this->response($user_role_list,200); 
			}
	}
	
	/* 
	* name: block_role_get
	* @param : null
	* @func : block particular roles
   */
	public function block_role_get()
	{  
	    $role_id=$this->get('id');
	    $block_role=$this->Do_roles->block_role($role_id);
		if($block_role)
		{
			// SEND EMAIL TO MANAGERS
			$result=$this->Do_networks->get_network_details();			
			$admin_name    = $result['firstname']." ".$result['lastname'];			
			$admin_email   = $result['email'];
			
			// GET USERS DETAILS FOR MAIL
			$get_managers = $this->Do_networks->get_managers_by_role_id($role_id);
			if(!empty($get_managers)){
			foreach($get_managers as $row)
			{
				$user_email    = $row['email'];
				$user_name     = $row['name'];
				
				// GET MANAGER DETAILS FOR BCC
				$manager_email = $this->Do_networks->manager_email_for_BCC($row['u_id']);
				$bcc = $manager_email;
				$type     	   = "MANAGER_ROLE_BLOCK";
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content=array(
					"subject" 		=> $this->lang->line('ACCOUNT_BLOCKED'),
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email						
					);
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
			   }
			}
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('role_blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/* 
	* name: block_role_get
	* @param : null
	* @func : block particular roles
   */
	public function unblock_role_get()
	{  
	    $role_id=$this->get('id');
	    $block_role=$this->Do_roles->unblock_role($role_id);
		if($block_role)
		{
			// SEND EMAIL TO MANAGERS
			$result=$this->Do_networks->get_network_details();			
			$admin_name    = $result['firstname']." ".$result['lastname'];			
			$admin_email   = $result['email'];
			
			// GET USERS DETAILS FOR MAIL
			$get_managers = $this->Do_networks->get_managers_by_role_id($role_id);
			if(!empty($get_managers)){
			foreach($get_managers as $row)
			{
				$user_email    = $row['email'];
				$user_name     = $row['name'];
				
				// GET MANAGER DETAILS FOR BCC
				$manager_email = $this->Do_networks->manager_email_for_BCC($row['u_id']);
				$bcc = $manager_email;
				$type     	   = "MANAGER_ROLE_UN_BLOCK";
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content=array(
					"subject" 		=> $this->lang->line('ACCOUNT_UN_BLOCKED'),
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email						
					);
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
			  }
			}
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('role_unblkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	} 

}
