<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Utilities (Generalize Things)
 * 
 * @package        ADX
 * @subpackage    GETTING REPORTS/ STATISTICS
 * @category    Controller
 * @author        Nalliappan
 * @link        http://www.djaxadserver.com 
 */

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Report extends REST_Controller
{
    
    function __construct()
    {
        parent::__construct();
        $this->load->model('Do_report');
        $this->load->model('Do_notification');
        $this->load->config('report_configurations');
        $this->load->library('user_authentication');
        $key = $this->input->get_post('api_key');
        $this->user_authentication->is_valid_apikey($key);
        $user_auth = $this->user_authentication;
        if (isset($user_auth->error['response'])) {
            $this->response($user_auth->error, 200);
        }
    }
    
    
    function convert_chart_data($res, $settings)
    {
	   $this->lang->load(array('keywords', 'helpblocks', 'form_label', 'label_invocation', 'menu'), $this->config->item('language'), true);       
        
        // Declaration
        
        $chart_data   = array();
        $chart_x_axis = array();
        $i            = 0;
        $col_settings = '';
        $total_values = array();
        
        if (!empty($res['fields'])) {
            foreach ($res['fields'] as $column) {
                
                if (array_key_exists($column, $settings['FIELDS'])) {
                    $col_settings = $settings['FIELDS'][$column];
                    if (is_array($col_settings) AND count($col_settings) > 0) {
                        if (isset($col_settings['name']) AND $col_settings['name'] != '') {
                           $chart_data[$i]['name']   = $this->lang->line($col_settings['name']);
                            //$chart_data[$i]['name']   = $col_settings['name'] ;
                            $total_values[$i]['name'] = $col_settings['name'];
                            $total_values[$i]['key']  = $column;
                        }
                        
                        if (isset($col_settings['data_type']) AND $col_settings['data_type'] != '') {
                            $array_column              = array_map($col_settings['data_type'], array_column($res['records'], $column));
                            $chart_data[$i]['data']    = $array_column;
                            $total_values[$i]['value'] = array_sum($array_column);
                        } else {
                            $array_column              = array_column($res['records'], $column);
                            $chart_data[$i]['data']    = $array_column;
                            $total_values[$i]['value'] = array_sum($array_column);
                        }
                        
                        if (isset($col_settings['chart_type']) AND $col_settings['chart_type'] != '') {
                            $chart_data[$i]['type'] = $col_settings['chart_type'];
                        }
                        
                        if (isset($col_settings['chart_marker']) AND $col_settings['chart_marker'] != '') {
                            $chart_data[$i]['marker'] = $col_settings['chart_marker'];
                        }
                        $i++;
                    }
                }
                
                if (isset($settings['X_AXIS_FIELD']) AND $settings['X_AXIS_FIELD'] !== '' AND $settings['X_AXIS_FIELD'] === $column) {
                    	if($settings['X_AXIS_FIELD']=='DATE')
                    	{
							//dateformat for charts
						$chart_x_axis = array_column($res['records'], $column);
                    foreach ($chart_x_axis as $key => $value) 
                    {							
                        $chart_x_axis[$key] = dateformat(strtotime($value));
                    }
				}
				else
				{	
					$chart_x_axis = array_column($res['records'], $column);
					/*DAC020 changes on Feb 15,2020*/
                    foreach ($chart_x_axis as $key => $value) 
                    {		
						if($value == null || $value=="{site}" || $value=="{gender}" || $value=="{sentiment}" || $value=="{age}" || $value=="{customtarg1}" || $value=="{customtarg2}" || $value=="{customtarg3}" || $value=="{customtarg4}")
						{
						$value="Unknown";
						}	
                        $chart_x_axis[$key] = $value;
                    }  			
					
				}
                   
                }
              
            }
            
        }
       
		
				
				
				
				
		
    
      
     //added function admin reports charts currrency 4 digits
     if(isset($total_values[5]['key'])&& $total_values[5]['key']=='SPEND')
     {
        //~ $total_values[5]['value']=currencyformat($total_values[5]['value']);
        $total_values[5]['value']=currencyformat(convert_to_shortform($total_values[5]['value'], 2));
	 }
	
    if(isset($total_values[5]['key'])&& $total_values[5]['key']=='win_price')
     {
        $total_values[5]['value']=currencyformat($total_values[5]['value']);
	 }
	 
     if(isset($total_values[6]['key'])&& $total_values[6]['key']=='bid_price')
     {
        $total_values[6]['value']=currencyformat($total_values[6]['value']);
	 }
	 
     if(isset($total_values[7]['key'])&& $total_values[7]['key']=='admin_earnings')
     {
        $total_values[7]['value']=currencyformat($total_values[7]['value']);
	 }	 	 
		
	
	 if(isset($total_values[2]['key'])&& $total_values[2]['key']=='PUB_EARN')
     {
		$total_values[2]['value']=currencyformat($total_values[2]['value']);
	}
  

  
        $success = array(
            'response' => 'ok',
            'chart_data' => $chart_data,
            'chart_x_axis' => $chart_x_axis,
            'total' => $total_values
        );
        
        return $success;
        
    }
    
    
    
    function fetch_post($client_id = FALSE)
    { 
		//currency_rate();                 
        $page         = $this->post('page');
        $site         = $this->post('site');       
        $display      = $this->post('display_type');
        $account_id   = $this->user_authentication->account_id;
        $account_type = $this->user_authentication->account_type;
        
        $agency_id = FALSE;

        switch (strtoupper($account_type)) {
            case 'ADMIN';
                $agency_id = $this->Do_notification->getAdminAgencyId($account_id);
                break;
            case 'MANAGER';
                $agency_id = $this->Do_notification->getManagerAgencyId($account_id);
                break;
            case 'ADVERTISER';
                $agency_id = $this->Do_notification->getAdvertiserAgencyId($account_id);
                break;
        }
        
        if ($account_type === 'MANAGER') {
            $account_type = 'ADMIN';
        } else {
            $account_type = $account_type;
        }
        $manager_role_id = $this->user_authentication->manager_role_id;
        
        $stat_type = ($this->post('stat_type') !== '') ? $this->post('stat_type') : '';
        
        // GET DATA BASED ON PREDEFINED CONFIG VALUES
        
        //GET the datatable object or request
        $datatable_obj = $this->post('datatable_obj');
        
       // $this->response($datatable_obj);
        $lang=$this->post('language');
		$this->config->set_item('language',$lang);
        $search['site']         = $site;
        $search['page']         = $page;
        $search['account_id']   = $account_id;
        $search['account_type'] = $account_type;
        $search['search_term']  = $datatable_obj['sSearch'];
      
        $columns                = array();
        $group                  = array();
        $order                  = array();
        $limit                  = array();
          
       
        $rep_config = $this->config->item('report_config');
     
if (isset($rep_config[strtoupper($account_type)][strtoupper($page)])) {
	

            $settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper($display)];
            
            if (is_array($settings) AND count($settings) > 0) {
                
                
                
                foreach ($settings['FIELDS'] as $key => $value) {
                    
                    
                    if (isset($rep_config['MANAGER_PERMISSION'][strtoupper($key)]) && strtoupper($account_type) == 'ADMIN') {
                        
                        
                        if (check_permission_layout($rep_config['MANAGER_PERMISSION'][strtoupper($key)], $manager_role_id)) {
                            
                            array_push($columns, $key);
                        }
                    } else {
                        array_push($columns, $key);
                    }
                }
                
                $group = $settings['GROUP'];
                
                $columns = array_unique(array_merge($group, $columns));
                
                //returns the sorting data or false
                            
                // GET SEARCH FIELDS 
                if (isset($settings['SEARCH_FIELDS'])) {
                    $search['search_fields'] = $settings['SEARCH_FIELDS'];
                } else {
                    $search['search_fields'] = FALSE;
                }
               // $this->response($settings['SEARCH_FIELDS']);                 

                if ($this->convert_sorting_data($datatable_obj)) {
                    $order = $this->convert_sorting_data($datatable_obj);
                } else {
                    $order = $settings['ORDER'];
                }
                               // $this->response($settings['SEARCH_FIELDS']);                 
                
                if ($this->post('start') != '') {
                    $limit = array(
                        'start' => $this->post('start'),
                        'end' => $this->post('end')
                    );
                } else {
                    $limit = $settings['LIMIT'];
                }
                
                
                
                if ($settings['DEFAULT_INTERVAL'] != '') {
                    $date                = get_search_date($settings['DEFAULT_INTERVAL']);
                    $search['date_from'] = $date['from_date'];
                    $search['date_to']   = $date['to_date'];
                }
                
                // ADD SEARCH FIELDS
                
                if ($this->post('exchangeval') != '') {
                    $search['exchangeval'] = $this->post('exchangeval');
                }
                
                if ($this->post('date_from') != '') {
                    $search['date_from'] = $this->post('date_from');
                }
                
                if ($this->post('date_to') != '') {
                    $search['date_to'] = $this->post('date_to');
                }
                
                if ($this->post('environment') != '' AND $this->post('environment') != 'all') {
                    $search['environment'] = $this->post('environment');
                }
                
                if ($this->post('campaign_id') != '' AND $this->post('campaign_id') != 'all') {
                    $search['campaign_id'] = $this->post('campaign_id');
                }
                
                if ($this->post('creative_id') != '' AND $this->post('creative_id') != 'all') {
                    $search['creative_id'] = $this->post('creative_id');
                }
                
                if ($this->post('site_id') != '' AND $this->post('site_id') != 'all') {
                    $search['site_id'] = $this->post('site_id');
                }
                
                if ($this->post('adv_account_id') != '' AND $this->post('adv_account_id') != 'all') {
                    $search['adv_account_id'] = $this->post('adv_account_id');
                }
                
                if ($this->post('pub_account_id') != '' AND $this->post('pub_account_id') != 'all') {
                    $search['pub_account_id'] = $this->post('pub_account_id');
                }
                
                if ($agency_id != FALSE) {
                    $search['agency_id'] = $agency_id;
                }
                
                $dataTable = FALSE;
                
                if ($display === 'TABLE') {
                    
                    $dataTable = TRUE;
                    
                }
								
              // $this->response($agency_id);
                switch ($stat_type) {
                    case 'COUNTRY';
                        $res = $this->Do_report->fetch_country($columns, $search, $group, $order, $limit, $dataTable);
                        break;
                        
                    case 'CITY';
                        $res = $this->Do_report->fetch_city($columns, $search, $group, $order, $limit, $dataTable);
                        break;

							case 'VIDEO';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}
                             $res = $this->Do_report->fetch_video($columns, $search, $group, $order, $limit, $dataTable);
                            log_message("error",$res);
                            break;     
                            case 'AGE';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  

                           $res = $this->Do_report->fetch_age_stats($columns, $search, $group, $order, $limit, $dataTable, $client_id);
							//$this->response($res);  exit;
								
                            break;                          
                         case 'GENDER';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}    
                           $res = $this->Do_report->fetch_gender_stats($columns, $search, $group, $order, $limit, $dataTable, $client_id);								
                            break;                          
                         case 'SENTIMENT';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
                           $res = $this->Do_report->fetch_sentiment_stats($columns, $search, $group, $order, $limit, $dataTable, $client_id);
                            break;                          
                         case 'SITES';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
                           $res = $this->Do_report->fetch_site_stats($columns, $search, $group, $order, $limit, $dataTable, $client_id);
                          							
                            break; 
                          case 'CUSTOMTARG1';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
                           $res = $this->Do_report->fetch_customtarg1_stats($columns, $search, $group, $order, $limit, $dataTable, $client_id);
                                      //~ $this->response($res);                     

                            break;
                          case 'CUSTOMTARG2';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
                           $res = $this->Do_report->fetch_customtarg2_stats($columns, $search, $group, $order, $limit, $dataTable, $client_id);
                            break;
                          case 'CUSTOMTARG3';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
                           $res = $this->Do_report->fetch_customtarg3_stats($columns, $search, $group, $order, $limit, $dataTable, $client_id);
                            break;
                            
                          case 'CUSTOMTARG4';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
                           $res = $this->Do_report->fetch_customtarg4_stats($columns, $search, $group, $order, $limit, $dataTable, $client_id);
                            break;                     
                    default:
                        $res = $this->Do_report->fetch($columns, $search, $group, $order, $limit, $dataTable, $client_id);
                        
                        break;
                        
                }
                
                // DB Data 
                if ($display === 'TABLE') {
                    
                    
                    // GET CHART SETTINGS AND DATA
                    
                    $chart_settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper('chart')];
                    
                    if ($this->post('start') != '') {
                        if ($this->post('end') <= $chart_settings['LIMIT']['end']) {
                            $chart_limit = array(
                                'start' => $this->post('start'),
                                'end' => $this->post('end')
                            );
                        } else {
                            $chart_limit = $chart_settings['LIMIT'];
                        }
                    } else {
                        $chart_limit = $chart_settings['LIMIT'];
                    }
                    

                    switch ($stat_type) {
                        case 'COUNTRY';
                            $chart_data_res = $this->Do_report->fetch_country($columns, $search, $group, $order, $chart_limit);
                            break;
                        case 'CITY';
                            $chart_data_res = $this->Do_report->fetch_city($columns, $search, $group, $order, $chart_limit);
                            break;
                        case 'VIDEO';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}                        
                            $chart_data_res = $this->Do_report->fetch_video($columns, $search, $group, $order, $chart_limit);
								
								//$this->response($chart_data_res);
								
                            break;
                            case 'AGE';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
							 //$this->response('hi'); exit;                    
                            $chart_data_res = $this->Do_report->fetch_age_stats($columns, $search, $group, $order, $chart_limit);
							break;
                          case 'GENDER';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
							            
                            $chart_data_res = $this->Do_report->fetch_gender_stats($columns, $search, $group, $order, $chart_limit);
							break;
                          case 'SENTIMENT';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							} 							            
                            $chart_data_res = $this->Do_report->fetch_sentiment_stats($columns, $search, $group, $order, $chart_limit);
							break;
                          case 'SITES';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
							            
                            $chart_data_res = $this->Do_report->fetch_site_stats($columns, $search, $group, $order, $chart_limit);
							break;
						case 'CUSTOMTARG1';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							} 							            
                            $chart_data_res = $this->Do_report->fetch_customtarg1_stats($columns, $search, $group, $order, $chart_limit);
							break;
						case 'CUSTOMTARG2';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							} 							            
                            $chart_data_res = $this->Do_report->fetch_customtarg2_stats($columns, $search, $group, $order, $chart_limit);
							break;
						case 'CUSTOMTARG3';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							} 							            
                            $chart_data_res = $this->Do_report->fetch_customtarg3_stats($columns, $search, $group, $order, $chart_limit);
							break;
						case 'CUSTOMTARG4';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							} 							            
                            $chart_data_res = $this->Do_report->fetch_customtarg4_stats($columns, $search, $group, $order, $chart_limit);
							break;
                        default:
                            $chart_data_res = $this->Do_report->fetch($columns, $search, $group, $order, $chart_limit, $client_id);
                            break;
                    }
                    
                    
                    
                    $chart_data = $this->convert_chart_data($chart_data_res, $chart_settings);
                    
                    //Load Map Settings...if Map is found
                    if (isset($rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper('map')])) {
                        $map_settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper('map')];
                        
                        if ($this->post('start') != '') {
                            $map_limit = array(
                                'start' => $this->post('start'),
                                'end' => $this->post('end')
                            );
                        } else {
                            $map_limit = $map_settings['LIMIT'];
                        }
                        $map_columns = array();
                        foreach ($map_settings['FIELDS'] as $key => $value) {
                            array_push($map_columns, $key);
                        }
                        
                        $map_group = $map_settings['GROUP'];
                        
                        $map_columns = array_unique(array_merge($map_group, $map_columns));
                        
                        if ($this->convert_sorting_data($datatable_obj)) {
                            $map_order = $this->convert_sorting_data($datatable_obj);
                        } else {
                            $map_order = $map_settings['ORDER'];
                        }
                        
                        switch ($stat_type) {
                            case 'COUNTRY';
                                $map_data_res = $this->Do_report->fetch_country($map_columns, $search, $map_group, $map_order, $map_limit);
                                break;
                            case 'CITY';
                                $map_data_res = $this->Do_report->fetch_city($map_columns, $search, $map_group, $map_order, $map_limit);
                                break;
                            case 'VIDEO';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}                            
                                $map_data_res = $this->Do_report->fetch_video($map_columns, $search, $map_group, $map_order, $map_limit);
                                break;
                                
                             case 'AGE';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
							 //$this->response('hi'); exit;                    
                            $map_data_res = $this->Do_report->fetch_age_stats($columns, $search, $group, $order, $chart_limit);
							break;
                            case 'GENDER';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
							 //$this->response('hi'); exit;                    
                            $map_data_res = $this->Do_report->fetch_gender_stats($columns, $search, $group, $order, $chart_limit);
							break;
                            case 'SENTIMENT';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
							 //$this->response('hi'); exit;                    
                            $map_data_res = $this->Do_report->fetch_sentiment_stats($columns, $search, $group, $order, $chart_limit);
							break;
                            case 'SITES';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
							                 
                            $map_data_res = $this->Do_report->fetch_site_stats($columns, $search, $group, $order, $chart_limit);
							break;
							case 'CUSTOMTARG1';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
                            $map_data_res = $this->Do_report->fetch_customtarg1_stats($columns, $search, $group, $order, $chart_limit);
							break;
							case 'CUSTOMTARG2';
							$account_types = $his->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
                            $map_data_res = $this->Do_report->fetch_customtarg2_stats($columns, $search, $group, $order, $chart_limit);
							break;
							case 'CUSTOMTARG3';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
                            $map_data_res = $this->Do_report->fetch_customtarg3_stats($columns, $search, $group, $order, $chart_limit);
							break;
							case 'CUSTOMTARG4';
							$account_types = $this->user_authentication->account_type;
							if($account_types == 'MANAGER'){
							 $search['account_type'] = $account_types;
							}  
                            $map_data_res = $this->Do_report->fetch_customtarg4_stats($columns, $search, $group, $order, $chart_limit);
							break;
                            default:
                                $map_data_res = $this->Do_report->fetch($map_columns, $search, $map_group, $map_order, $map_limit);
                                
                                break;
                        }
                        
                        
                        
                        $map_data = $this->convert_map_data($map_data_res, $map_settings);
                    }
                      
                 // $this->response($page);  exit;  
                    switch ($account_type) {  
                        case 'ADMIN':
                    
                            switch ($page) {
								//Added By Murugeswari on 18-05-2017
								case 'REPORT_VIDEOADNETWORK':   
								
                                $total      = $this->Do_report->fetch_video($columns, $search, $group, $order, $settings['LIMIT'], $dataTable, $client_id);
                              
                                     $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break; 
                                    
                                    case 'REPORT_VIDEOADBLOCK':
                               
                                 $total      = $this->Do_report->fetch_video($columns, $search, $group, $order, $settings['LIMIT'], $dataTable, $client_id);
                                
                                 
                                     $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break; 
                                case 'REPORT_CREATIVE':
                                case 'REPORT_CAMPAIGN':
                                case 'REPORT_ADVERTISER':
                                case 'REPORT_PUBLISHER':
                                case 'REPORT_SITE':
                                case 'REPORT_ADBLOCK':
                                    
								
                                    
                                    $total      = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable, $client_id);
                                    // $this->response($total);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                    // start
                                    ///added by rubini for admin video report//
									case 'REPORT_VIDEO';
                                    switch ($stat_type) {
                                    case 'VIDEO';
									$account_types = $this->user_authentication->account_type;
									if($account_types == 'MANAGER'){
									 $search['account_type'] = $account_types;
									}                                        
                                            $total = $this->Do_report->fetch_video($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
									// end
                                case 'REPORT_GEO_GRAPHICAL':
                                    $total      = $this->Do_report->fetch_country($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        $result_data['overall_map_data']     = $map_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        $result_data['overall_map_data']     = $map_data;
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                      case 'REPORT_SITES':
                                    switch ($stat_type) {
                                        case 'SITES';
                                          
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}         
											                         
                                            $total = $this->Do_report->fetch_site_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);  
                                                                              
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;                                     
                                    case 'REPORT_SENTIMENT':
                                    switch ($stat_type) {
                                        case 'SENTIMENT';
                                            //~ $total = $this->Do_report->fetch_video($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_sentiment_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);   
                                            //$this->response($this->db->last_query(),200);                                           
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    
                                    
                                    //~ $this->response($total,200);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                    case 'REPORT_AGE':
                                    switch ($stat_type) {
                                        case 'AGE';
                                            //~ $total = $this->Do_report->fetch_video($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_age_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);   

                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    
                                    
                                    //~ $this->response($total,200);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                        case 'REPORT_GENDER':
                                    switch ($stat_type) {
                                        case 'GENDER';
                                            //~ $total = $this->Do_report->fetch_video($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_gender_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);   
                                                                                   
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    
                                    
                                    //~ $this->response($total,200);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                    
                                    case 'REPORT_CUSTOMTARG1':
                                    switch ($stat_type) {
                                        case 'CUSTOMTARG1';
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_customtarg1_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);   
                                            //$this->response($this->db->last_query(),200);                                           
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                    
                                    case 'REPORT_CUSTOMTARG2':
                                    switch ($stat_type) {
                                        case 'CUSTOMTARG2';
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_customtarg2_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);   
                                            //$this->response($this->db->last_query(),200);                                           
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                    
                                    case 'REPORT_CUSTOMTARG3':
                                    switch ($stat_type) {
                                        case 'CUSTOMTARG3';
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_customtarg3_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);   
                                            //$this->response($this->db->last_query(),200);                                           
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                    
                                    case 'REPORT_CUSTOMTARG4':
                                    switch ($stat_type) {
                                        case 'CUSTOMTARG4';
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_customtarg4_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);   
                                            //$this->response($this->db->last_query(),200);                                           
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                    
                                      case 'REPORT_CITY_GRAPHICAL':
                                    $total      = $this->Do_report->fetch_city($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        $result_data['overall_map_data']     = $map_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        $result_data['overall_map_data']     = $map_data;
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                    
                                default:
                                    $this->response($res, 200);
                                    break;
                            }
                            break;
                        case 'ADVERTISER':
                            switch ($page) {
                                case 'REPORT_OVERVIEW':
                                case 'REPORT_CAMPAIGN':
                                case 'REPORT_CREATIVE':
                                case 'REPORT_VIDEO':
                                    switch ($stat_type) {
                                        case 'VIDEO';
                                            //~ $total = $this->Do_report->fetch_video($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_video($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);                                            
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                            
                                    }
                                    
                                    
                                    
                                    //~ $this->response($total,200);
                                    //~ $this->response($res,200);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                    
                                case 'REPORT_GENDER':
                                    switch ($stat_type) {
                                        case 'GENDER';
                                            //~ $total = $this->Do_report->fetch_video($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_gender_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);  
                                                                                 
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    
                                    
                                    //~ $this->response($total,200);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                 case 'REPORT_SENTIMENT':
                                    switch ($stat_type) {
                                        case 'SENTIMENT';
                                            //~ $total = $this->Do_report->fetch_video($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_sentiment_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);   
                                                                                   
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    
                                    
                                    //~ $this->response($total,200);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                case 'REPORT_SITES':
                                    switch ($stat_type) {
                                        case 'SITES';
                                          
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}         
											                         
                                            $total = $this->Do_report->fetch_site_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);  
                                  //   $this->response($this->db->last_query(),200);       
                                                                              
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                case 'REPORT_GEO_GRAPHICAL':
                                    
                                    $total      = $this->Do_report->fetch_country($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        $result_data['overall_map_data']     = $map_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        $result_data['overall_map_data']     = $map_data;
                                        
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                        case 'REPORT_AGE':
                                    switch ($stat_type) {
                                        case 'AGE';
                                            //~ $total = $this->Do_report->fetch_video($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_age_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);                                            
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                     $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                    case 'REPORT_CITY_GRAPHICAL':
                                    
                                    $total      = $this->Do_report->fetch_city($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        $result_data['overall_map_data']     = $map_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        $result_data['overall_map_data']     = $map_data;
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                    
                                    case 'REPORT_CUSTOMTARG1':
                                    switch ($stat_type) {
                                        case 'CUSTOMTARG1';
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_customtarg1_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);   
                                                                                   
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    
                                    
                                    //~ $this->response($total,200);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                     case 'REPORT_CUSTOMTARG2':
                                    switch ($stat_type) {
                                        case 'CUSTOMTARG2';
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_customtarg2_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);   
                                                                                   
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    
                                    
                                    //~ $this->response($total,200);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                     case 'REPORT_CUSTOMTARG3':
                                    switch ($stat_type) {
                                        case 'CUSTOMTARG3';
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_customtarg3_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);   
                                                                                   
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    
                                    
                                    //~ $this->response($total,200);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                     case 'REPORT_CUSTOMTARG4':
                                    switch ($stat_type) {
                                        case 'CUSTOMTARG4';
											$account_types = $this->user_authentication->account_type;
											if($account_types == 'MANAGER'){
											 $search['account_type'] = $account_types;
											}                                        
                                            $total = $this->Do_report->fetch_customtarg4_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);   
                                                                                   
                                            break;
                                        default:
                                            $total = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                            break;
                                            
                                    }
                                    
                                    
                                    
                                    //~ $this->response($total,200);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                default:
                                    $this->response($res, 200);
                            }
                            break;
                        case 'TRAFFICKER':
                            switch ($page) {
									case 'REPORT_VIDEOADBLOCK':
                               
                                 $total      = $this->Do_report->fetch_video($columns, $search, $group, $order, $settings['LIMIT'], $dataTable, $client_id);
                                 
                                     $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                case 'REPORT_OVERVIEW':
                                case 'REPORT_ADBLOCK':
                                case 'REPORT_SITE':
                                    $total      = $this->Do_report->fetch($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                case 'REPORT_GEO_GRAPHICAL':
                                    
                                    $total      = $this->Do_report->fetch_country($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        $result_data['overall_map_data']     = $map_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        $result_data['overall_map_data']     = $map_data;
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                    
                                     case 'REPORT_CITY_GRAPHICAL':
                                    
                                    $total      = $this->Do_report->fetch_city($columns, $search, $group, $order, $settings['LIMIT'], $dataTable);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        $result_data['overall_map_data']     = $map_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        $result_data['overall_map_data']     = $map_data;
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
                                    $this->response($result_data, 200);
                                    break;
                                default:
                                    $this->response($res, 200);
                            }
                            break;
                    }
                    
                } else if ($display === 'CHART' AND $res != FALSE) {
                    $success = $this->convert_chart_data($res, $settings);
                    $this->response($success, 200);
                } else if ($display === 'MAP' AND $res != FALSE) {
                    $success = $this->convert_map_data($res, $settings);
                    $this->response($success, 200);
                } else {
                    
                    if ($display === 'TILES' AND $account_type === 'ADVERTISER') {
                        
                        $spark_chart_config = $rep_config['ADVERTISER']['DASHBOARD']['SPARKLINE'];
                        
                        $columns2 = array();
                        
                        foreach ($spark_chart_config['FIELDS'] as $key => $value) {
                            array_push($columns2, $key);
                        }
                        
                        
                        $group2   = $spark_chart_config['GROUP'];
                        $columns2 = array_unique(array_merge($group, $columns2));
                        $order2   = $spark_chart_config['ORDER'];
                        $limit2   = $spark_chart_config['LIMIT'];
                        
                        $date2 = get_search_date($spark_chart_config['DEFAULT_INTERVAL']);
                        
                        $search2['date_from'] = $date2['from_date'];
                        $search2['date_to']   = $date2['to_date'];
                        
                        $search2['account_id']   = $this->post('adv_account_id');
                        $search2['account_type'] = 'ADVERTISER';
                        
                        $search2['adv_account_id'] = $this->post('adv_account_id');
                        
                        $tmp_imp_flow = $this->Do_report->fetch($columns2, $search2, $group2, $order2, $limit2);
                        
                        if (count($tmp_imp_flow['records']) > 0) {
                            foreach ($tmp_imp_flow['records'] as $imp_data) {
                                $tmp_impression[] = $imp_data['IMP'];
                                
                            }
                            $imp_flow = implode(',', $tmp_impression);
                            
                            $impression_flow = array(
                                'impression_flow' => $imp_flow
                            );
                        } else {
                            $impression_flow = array(
                                'impression_flow' => array()
                            );
                        }
                        
                        if (is_array($impression_flow) AND count($impression_flow) > 0 AND (is_array($res) AND count($res['records']) > 0)) {
                            $temp              = array_merge($res['records'][0], $impression_flow);
                            $res['records'][0] = $temp;
                        } else {
                            $res['records'][0] = $impression_flow;
                        }
                    }
                    if ($display === 'TILES' AND $account_type === 'TRAFFICKER') {
                        
                        $spark_chart_config = $rep_config['TRAFFICKER']['DASHBOARD']['SPARKLINE'];
                        
                        $columns2 = array();
                        
                        foreach ($spark_chart_config['FIELDS'] as $key => $value) {
                            array_push($columns2, $key);
                        }
                        
                        
                        $group2   = $spark_chart_config['GROUP'];
                        $columns2 = array_unique(array_merge($group, $columns2));
                        $order2   = $spark_chart_config['ORDER'];
                        $limit2   = $spark_chart_config['LIMIT'];
                        
                        $date2 = get_search_date($spark_chart_config['DEFAULT_INTERVAL']);
                        
                        $search2['date_from'] = $date2['from_date'];
                        $search2['date_to']   = $date2['to_date'];
                        
                        $search2['account_id']   = $this->post('pub_account_id');
                        $search2['account_type'] = 'TRAFFICKER';
                        
                        $search2['pub_account_id'] = $this->post('pub_account_id');
                        
                        if ($agency_id != FALSE) {
                            $search2['agency_id'] = $agency_id;
                        }
                        
                        
                        $tmp_earnings_flow = $this->Do_report->fetch($columns2, $search2, $group2, $order2, $limit2);
                        
                        if (count($tmp_earnings_flow['records']) > 0) {
                            foreach ($tmp_earnings_flow['records'] as $earnings_data) {
                                $tmp_earnings[] = number_format($earnings_data['PUB_EARN'],2);
                                
                            }
                            $earnings_flow = implode(',', $tmp_earnings);
                            
                            $earnings_flow = array(
                                'earnings_flow' => $earnings_flow
                            );
                            
                        } else {
                            $earnings_flow = array(
                                'impression_flow' => array()
                            );
                        }

                        if (is_array($earnings_flow) AND count($earnings_flow) > 0 AND (is_array($res) AND count($res['records']) > 0)) {
                            $temp              = array_merge($res['records'][0], $earnings_flow);
                            $res['records'][0] = $temp;
                        } else {
                            $res['records'][0] = $earnings_flow;
                        }
                    }
                    if ($display === 'TILES' AND $account_type === 'ADMIN') {
                        
                        $spark_chart_config = $rep_config['ADMIN']['DASHBOARD']['SPARKLINE'];
                        
                        $columns2 = array();
                        
                        foreach ($spark_chart_config['FIELDS'] as $key => $value) {
                            array_push($columns2, $key);
                        }
                        
                        
                        $group2   = $spark_chart_config['GROUP'];
                        $columns2 = array_unique(array_merge($group, $columns2));
                        $order2   = $spark_chart_config['ORDER'];
                        $limit2   = $spark_chart_config['LIMIT'];
                        
                        $date2 = get_search_date($spark_chart_config['DEFAULT_INTERVAL']);
                        
                        $search2['date_from'] = $date2['from_date'];
                        $search2['date_to']   = $date2['to_date'];
                        
                        $search2['account_id']   = $this->post('account_id');
                        $search2['account_type'] = 'ADMIN';
                        
                        if ($agency_id != FALSE) {
                            $search2['agency_id'] = $agency_id;
                        }
                        
                        $tmp_earnings_flow = $this->Do_report->fetch($columns2, $search2, $group2, $order2, $limit2);
                        
                       
                        
                        if (count($tmp_earnings_flow['records']) > 0) {
							
                            foreach ($tmp_earnings_flow['records'] as $earnings_data) {
                                $tmp_earnings[] = $earnings_data['ADM_EARN'];
                                
                               
                                
                                
                            }
                            $earnings_flow = implode(',', $tmp_earnings);
                            
                            $earnings_flow = array(
                                'earnings_flow' => $earnings_flow
                            );
                        } else {
                            $earnings_flow = array(
                                'earnings_flow' => array()
                            );
                        }
                        
                        $inventory = $this->Do_report->get_inventory_count($account_type, $search['date_from'], $agency_id);
                        
                        if (is_array($earnings_flow) AND count($earnings_flow) > 0 AND (is_array($res) AND count($res['records']) > 0)) {
                            $temp              = array_merge($res['records'][0], $earnings_flow);
                            $res['records'][0] = $temp;
                            if (is_array($inventory) AND count($inventory) > 0) {
                                $temp              = array_merge($res['records'][0], $inventory);
                                $res['records'][0] = $temp;
                            }
                        } else {
                            $res['records'][0] = $earnings_flow;
                            
                            if (is_array($inventory) AND count($inventory) > 0) {
                                $temp              = array_merge($res['records'][0], $inventory);
                                $res['records'][0] = $temp;
                            }
                        }
                        
                    }
                    
                    
                    if ($display === 'TILES') {
                        
                        // CONVERT NUMERIC VALUES TO SHORT FORM
                        
                        if (isset($res['records'][0]['IMP'])) {
                            $res['records'][0]['IMP'] = convert_to_shortform($res['records'][0]['IMP']);
                        }
                        
                        if (isset($res['records'][0]['CLK'])) {
                            $res['records'][0]['CLK'] = convert_to_shortform($res['records'][0]['CLK']);
                        }
                        
                        if (isset($res['records'][0]['CON'])) {
                            $res['records'][0]['CON'] = convert_to_shortform($res['records'][0]['CON']);
                        }
                        
                        if (isset($res['records'][0]['UIMP'])) {
                            $res['records'][0]['UIMP'] = convert_to_shortform($res['records'][0]['UIMP']);
                        }
                        
                        if (isset($res['records'][0]['UCLK'])) {
                            $res['records'][0]['UCLK'] = convert_to_shortform($res['records'][0]['UCLK']);
                        }
                        
                        if (isset($res['records'][0]['SPEND'])) {
                            $res['records'][0]['SPEND'] = currencyformat(convert_to_shortform($res['records'][0]['SPEND'], 2));
                        }
                        
                        if (isset($res['records'][0]['CTR'])) {
                            $res['records'][0]['CTR'] = convert_to_shortform($res['records'][0]['CTR'], 2);
                            //~ $res['records'][0]['CTR'] = number_format($res['records'][0]['CTR'], 2,'.',',');
                        
                        }
                        
                        if (isset($res['records'][0]['ECPM'])) {
                            $res['records'][0]['ECPM'] = currencyformat(convert_to_shortform($res['records'][0]['ECPM'], 2));
                        }
                    
                        if (isset($res['records'][0]['PUB_EARN'])) {
                            $res['records'][0]['PUB_EARN'] = currencyformat(convert_to_shortform($res['records'][0]['PUB_EARN'], 2));
                        }
                        
                        if (isset($res['records'][0]['PUB_ECPM'])) {
                            $res['records'][0]['PUB_ECPM'] = currencyformat(convert_to_shortform($res['records'][0]['PUB_ECPM'], 2));
                        }
                        
                        // END OF CONVERT PROCESS
                        
                    }
                    
                    
                    
                    $success = array(
                        'response' => 'ok',
                        'data' => $res
                    );
                    
                    $this->response($success, 200);
                }
            }
        }
    }
    
    /*
     * 
     * name: fetch_advertiser_get
     * @param :
     * @return : $campaign_list
     * 
     * Lists advertiser for reports
     */
    
    function fetch_advertiser_get()
    {
        
        //Get from library file
        $network_account_id = $this->user_authentication->network_account_id;
        $network_id         = $this->user_authentication->account_id;
        $account_id         = $this->get('account_id');
        //~ $this->response($account_id);
        if ($account_id) {
            if ($network_account_id) {
                $advertiser = $this->Do_report->fetch_advertiser($network_id, $network_account_id, $account_id);
            } else {
                $advertiser = $this->Do_report->fetch_advertiser($network_id, '', $account_id);
            }
        } else {
            if ($network_account_id) {
                $advertiser = $this->Do_report->fetch_advertiser($network_id, $network_account_id);
            } else {
                $advertiser = $this->Do_report->fetch_advertiser($network_id);
            }
        }
        
        
        $this->response($advertiser, 200);
        
    }
  
    /*
     * 
     * name: fetch_publisher_get
     * @param :
     * @return : $campaign_list
     * 
     * Lists publisher for reports
     */
    
    function fetch_publisher_get()
    {
        //Get from library file
        $network_account_id = $this->user_authentication->network_account_id;
        $network_id         = $this->user_authentication->account_id;
        $account_id         = $this->get('account_id');
        
        if ($account_id) {
            if ($network_account_id) {
                $publisher = $this->Do_report->fetch_publisher($network_id, $network_account_id, $account_id);
            } else {
                $publisher = $this->Do_report->fetch_publisher($network_id, '', $account_id);
            }
        } else {
            if ($network_account_id) {
                $publisher = $this->Do_report->fetch_publisher($network_id, $network_account_id);
            } else {
                $publisher = $this->Do_report->fetch_publisher($network_id);
            }
        }
        
        $this->response($publisher, 200);
    }
    
    /*
     * 
     * name: fetch_campaigns_get
     * @param :
     * @return : $campaign_list
     * 
     * Lists a campaigns of an advertiser
     */
    
    function fetch_campaigns_get($camp_id = 'all', $adv_id = FALSE)
    {
        //Get from library file
        if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id = $this->user_authentication->account_id;
        } elseif ($adv_id != FALSE) {
            $account_id = $adv_id;
        } else {
            $account_id = '';
        }
        
        $agency_id = $this->user_authentication->agency_id;
        
        $campaign_type = $this->get('campaign_type');
        if ($camp_id == 'all') {
            $camp_id = FALSE;
        }
        //to fetch report of particular campaign
        $campaign_details = $this->Do_report->fetch_campaign($account_id, $campaign_type, $agency_id, $camp_id);
        
        if ($campaign_details) {
            $campaign_details = array_map('callbackformat', $campaign_details); //callback from helper file for date
            $this->response($campaign_details, 200); // 200 being the HTTP response code
        } else {
            $this->response(array(
                'error' => $this->lang->line('no_details_found')
            ), 404);
        }
    }
    
    
    /*
     * 
     * name: fetch_creative_get
     * @param :
     * @return : $creative_list
     * 
     * Lists a web creative of an advertiser
     */
    
    function fetch_video_creative_get()
    {
        //Get from library file
        $account_id = $this->user_authentication->account_id;
        
        if ($account_id) {
            $creative_details = $this->Do_report->fetch_video_creatives($account_id);
            
            if ($creative_details) {
                $this->response($creative_details, 200); // 200 being the HTTP response code
            } else {
                $this->response(array(
                    'error' => $this->lang->line('no_details_found')
                ), 404);
            }
        }
    }
    
    /*
     * 
     * name: convert_map_data
     * @param : $res,$settings
     * @return : map_data
     * 
     * Converts the data into map format
     */
    
    function convert_map_data($res, $settings)
    {
        
        
        // Declaration
        $map_data = '';
        
        $map_inner_data = array();
        
        
        if (!empty($res['records'])) {
            foreach ($res['records'] as $values) {
                if (isset($values['CON'])) {
                    $conversions = '<br/><b>Conversions</b> - ' . $values['CON'] . '';
                } else {
                    $conversions = '';
                }
                
                $map_value = array(
                    'latLng' => array(
                        floatval($values['LATITUDE']),
                        floatval($values['LONGITUDE'])
                    ),
                    'data' => '<b>Impression</b> - ' . $values['IMP'] . ',<br/><b>Click</b> - ' . $values['CLK'] . ',' . $conversions . '',
                    'options' => array(
                        'icon' => 'http://maps.google.com/mapfiles/marker_green.png'
                    )
                );
                
                
                array_push($map_inner_data, $map_value);
            }
            
            $map_data = json_encode($map_inner_data);
        } else {
            $map_data = '[]';
        }
        
        
        
        $success = array(
            'response' => 'ok',
            'map_data' => $map_data
        );
        
        return $success;
        
    }
    
    /*
     * 
     * name: fetch_sites_get
     * @param :
     * @return : $site_list
     * 
     * Lists all sites
     */
    
    
    function fetch_sites_get($site_id = FALSE, $pub_id = FALSE)
    {        
        if ($this->user_authentication->account_type == 'TRAFFICKER') {
            $account_id         = $this->user_authentication->account_id;
            $data['account_id'] = $account_id;
        } else {
            $agency_id         = $this->user_authentication->agency_id;
            $data['agency_id'] = $agency_id;
        }
        if ($pub_id != FALSE && $pub_id != 'all') {
            $data['account_id'] = $pub_id;
        }
        $site_list = $this->Do_report->fetch_sites($data, $site_id);
        $this->response($site_list, 200);
        
    }
	
	
	function fetch_targeting_sites_get($adv_id=FALSE)
	{ 
		 if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id         = $this->user_authentication->account_id;
            $data['account_id'] = $account_id;
        } else {
            $agency_id         = $this->user_authentication->agency_id;
            $data['agency_id'] = $agency_id;
        }
        if ($adv_id != FALSE && $adv_id != 'all') {
            $data['account_id'] = $adv_id;
        }
		$site_list = $this->Do_report->fetch_targeting_sites($data);      
        $this->response($site_list, 200);       
	}
	
	
	function fetch_targeting_gender_get($adv_id=FALSE)
	{ 
		 if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id         = $this->user_authentication->account_id;
            $data['account_id'] = $account_id;
        } else {
            $agency_id         = $this->user_authentication->agency_id;
            $data['agency_id'] = $agency_id;
        }
        if ($adv_id != FALSE && $adv_id != 'all') {
            $data['account_id'] = $adv_id;
        }
		$site_list = $this->Do_report->fetch_targeting_gender($data);    
        $this->response($site_list, 200);       
	}
	
	function fetch_targeting_sentiment_get($adv_id=FALSE)
	{ 
		 if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id         = $this->user_authentication->account_id;
            $data['account_id'] = $account_id;
        } else {
            $agency_id         = $this->user_authentication->agency_id;
            $data['agency_id'] = $agency_id;
        }
        if ($adv_id != FALSE && $adv_id != 'all') {
            $data['account_id'] = $adv_id;
        }
		$site_list = $this->Do_report->fetch_targeting_sentiment($data);    
        $this->response($site_list, 200);       
	}
	
	function fetch_targeting_age_get($adv_id=FALSE)
	{
		if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id         = $this->user_authentication->account_id;
            $data['account_id'] = $account_id;
        } else {
            $agency_id         = $this->user_authentication->agency_id;
            $data['agency_id'] = $agency_id;
        }
        if ($adv_id != FALSE && $adv_id != 'all') {
            $data['account_id'] = $adv_id;
        }
		$age_list = $this->Do_report->fetch_targeting_age($data);    
        $this->response($age_list, 200);            
	}

	
	    
    /*
     * 
     * name: fetch_dsp_stats_post
     * @param :
     * @return : $dsp_list
     * 
     * Lists dsp for reports
     */
    
    /*function fetch_dsp_stats_post()
    {
    $page             =     $this->post('page');
    $display         =     $this->post('display_type');
    $account_id     =     $this->user_authentication->account_id;
    $account_type   =     $this->user_authentication->account_type;
    
    $agency_id         = FALSE;
    
    switch(strtoupper($account_type)){
    case 'ADMIN';
    $agency_id    = $this->Do_notification->getAdminAgencyId($account_id);
    break;
    case 'MANAGER';
    $agency_id    = $this->Do_notification->getManagerAgencyId($account_id);
    break;
    case 'ADVERTISER';
    $agency_id    = $this->Do_notification->getAdvertiserAgencyId($account_id);
    break;
    }
    
    if($account_type ==='MANAGER')
    {
    $account_type     = 'ADMIN';
    }else{
    $account_type     = $account_type;
    }
    $manager_role_id     = $this->user_authentication->manager_role_id;
    
    if($this->post('date_from') != ''){
    $search['date_from'] = $this->post('date_from'); 
    }
    
    if($this->post('pub_account_id') != '' AND $this->post('pub_account_id') != 'all'){
    $search['pub_account_id'] = $this->post('pub_account_id'); 
    }
    
    if($this->post('environment') != '' AND $this->post('environment') != 'all'){
    $search['environment'] = $this->post('environment'); 
    }
    
    if($this->post('date_to') != ''){
    $search['date_to'] = $this->post('date_to'); 
    }
    
    if($this->post('start') != ''){
    $search['start'] = $this->post('start'); 
    }
    
    if($this->post('end') != ''){
    $search['end'] = $this->post('end'); 
    }
    
    if($network_account_id)
    {
    if(isset($search))
    {
    $domain     =     $this->Do_analytics->fetch_domain($network_id,$network_account_id,$search,0);
    $domain_chart     =     $this->Do_analytics->fetch_domain($network_id,$network_account_id,$search,1);
    }
    else
    {
    $domain     =     $this->Do_analytics->fetch_domain($network_id,$network_account_id,0);
    $domain_chart     =     $this->Do_analytics->fetch_domain($network_id,$network_account_id,1);
    }
    }
    else
    {
    if(isset($search))
    {
    $domain     =     $this->Do_analytics->fetch_domain($network_id,'',$search,0);
    $domain_chart     =     $this->Do_analytics->fetch_domain($network_id,'',$search,1);
    }
    else
    {
    $domain     =     $this->Do_analytics->fetch_domain($network_id,0);
    $domain_chart     =     $this->Do_analytics->fetch_domain($network_id,1);
    }            
    }        
    
    
    $chart_data    =    $this->convert_domain_chart_data($domain_chart,$search);                        
    //GET the datatable object or request
    $datatable_obj = $this->post('datatable_obj');
    
    $no_records = ($domain !== FALSE)?count($domain):0;
    if($no_records)
    {    
    //$result_data['sEcho']                 = $datatable_obj['sEcho'];
    $result_data['iTotalRecords']         = $no_records;
    $result_data['iTotalDisplayRecords']= $no_records;
    $result_data['aaData']                 = $domain;
    $result_data['overview_chart_data'] = $chart_data;
    
    }else{
    //$result_data['sEcho']                 = $datatable_obj['sEcho'];
    $result_data['iTotalRecords']         = $no_records;
    $result_data['iTotalDisplayRecords']= 0;
    $result_data['aaData']                 = array();
    $result_data['overview_chart_data'] = '';        
    }
    // RETURN DATATABLE AND CHART DATA
    $this->response($result_data,200);
    
    //$this->response($browser,200);
    }*/
    
    /*
     * name: convert_sorting_data
     * @param :
     * @return : $output or false
     * 
     * convert data into order by array
     */
    function convert_sorting_data($request_data = FALSE)
    {
        if ($request_data) {
            if (isset($request_data['iSortCol_0'])) {
                //Initialize order by array
                $sorting_order = array();
                
                for ($i = 0; $i < intval($request_data['iSortingCols']); $i++) {
                    if ($request_data['bSortable_' . intval($request_data['iSortCol_' . $i])] == "true") {
                        $sorting_order[$request_data['mDataProp_' . intval($request_data['iSortCol_' . $i])]] = $request_data['sSortDir_' . $i];
                    }
                }
                return $sorting_order;
            } else {
                return FALSE;
            }
        } else {
            return FALSE;
        }
        
        
    }
    
    function fetch_dsp_post()
    {
        
        //Get from library file
        $datatable_obj = $this->post('datatable_obj');
        $account_id    = $this->user_authentication->account_id;
        $account_type  = $this->user_authentication->account_type;
        
        $search['account_id']    = $account_id;
        $search['account_type']  = $account_type;
        $search['search_term']   = $datatable_obj['sSearch'];
        $search['search_fields'] = array(
            "exchange_name"
        );
        
        if ($this->post('exchangeval') != '') {
			$search['exchangeval'] = $this->post('exchangeval');
		}
        
        if ($this->post('date_from') != '') {
            $search['date_from'] = $this->post('date_from');
        }
        if ($this->post('date_to') != '') {
            $search['date_to'] = $this->post('date_to');
        }
        
        
        $order = $this->post('order');
        $limit = array(
            "start" => $this->post('start'),
            "end" => $this->post('end')
        );
       // 
        $res        = $this->Do_report->fetch_dsp_stats($search, $order, $limit);
        //$this->response($this->db->last_query());
        $total      = $this->Do_report->fetch_dsp_stats($search, $order);
        $no_records = ($total !== FALSE) ? count($total) : 0;
        if ($no_records) {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = $no_records;
            $result_data['aaData']               = $res;
            //$result_data['overview_chart_data']  = $chart_data;
            
        } else {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = 0;
            $result_data['aaData']               = array();
            //$result_data['overview_chart_data']  = '';
            
        }
        
        $this->response($result_data, 200);
    }
    
    function fetch_dsp_date_post()
    {
        //Get from library file
        $exchange_id   = $this->post('exchange_id');
        $datatable_obj = $this->post('datatable_obj');
        $account_id    = $this->user_authentication->account_id;
        $account_type  = $this->user_authentication->account_type;
        
        $search['account_id']    = $account_id;
        $search['account_type']  = $account_type;
        $search['search_term']   = $datatable_obj['sSearch'];
        $search['search_fields'] = array(
            "dbdate"
        );
        
        if ($this->post('exchangeval') != '') {
			$search['exchangeval'] = $this->post('exchangeval');
		}
        
        if ($this->post('date_from') != '') {
            $search['date_from'] = $this->post('date_from');
        }
        if ($this->post('date_to') != '') {
            $search['date_to'] = $this->post('date_to');
        }
      
        
        $order = $this->post('order');
        $limit = array(
            "start" => $this->post('start'),
            "end" => $this->post('end')
        );
        
        $res        = $this->Do_report->fetch_dsp_date_stats($exchange_id, $search, $order, $limit);
        $total      = $this->Do_report->fetch_dsp_date_stats($exchange_id, $search, $order);
        $no_records = ($total !== FALSE) ? count($total) : 0;
        if ($no_records) {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = $no_records;
            $result_data['aaData']               = $res;
            //$result_data['overview_chart_data']     =     $chart_data;
            
        } else {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = 0;
            $result_data['aaData']               = array();
            //$result_data['overview_chart_data']     = '';            
            
        }
        
        $this->response($result_data, 200);
    }
    
    function fetch_dsp_detail_post()
    {
        //Get from library file
        $exchange_id   = $this->post('exchange_id');
        $date          = $this->post('date');
        $datatable_obj = $this->post('datatable_obj');
        $account_id    = $this->user_authentication->account_id;
        $account_type  = $this->user_authentication->account_type;
        
        $search['account_id']    = $account_id;
        $search['account_type']  = $account_type;
        $search['search_term']   = $datatable_obj['sSearch'];
        $search['search_fields'] = array(
            "client_name",
            "camp_name",
            "ban_name"
        );
        
        $order = $this->post('order');
        $limit = array(
            "start" => $this->post('start'),
            "end" => $this->post('end')
        );
        
        $res        = $this->Do_report->fetch_dsp_detail_stats($exchange_id, $date, $search, $order, $limit);
        $total      = $this->Do_report->fetch_dsp_detail_stats($exchange_id, $date, $search, $order);
        $no_records = ($total !== FALSE) ? count($total) : 0;
        if ($no_records) {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = $no_records;
            $result_data['aaData']               = $total;
            //$result_data['overview_chart_data']     =     $chart_data;
            
        } else {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = 0;
            $result_data['aaData']               = array();
            //$result_data['overview_chart_data']     =     '';            
            
        }
        
        $this->response($result_data, 200);
    }
    
    //~ function fetch_ssp_post()
    //~ {
        //~ //Get from library file
        //~ $datatable_obj = $this->post('datatable_obj');
        //~ $account_id    = $this->user_authentication->account_id;
        //~ $account_type  = $this->user_authentication->account_type;
        //~ 
        //~ $search['account_id']    = $account_id;
        //~ $search['account_type']  = $account_type;
        //~ $search['search_term']   = $datatable_obj['sSearch'];
        //~ $search['search_fields'] = array(
            //~ "exchange_name"
        //~ );
        //~ 
        //~ if ($this->post('date_from') != '') {
            //~ $search['date_from'] = $this->post('date_from');
        //~ }
        //~ if ($this->post('date_to') != '') {
            //~ $search['date_to'] = $this->post('date_to');
        //~ }
        //~ 
        //~ $order = $this->post('order');
        //~ $limit = array(
            //~ "start" => $this->post('start'),
            //~ "end" => $this->post('end')
        //~ );
        //~ 
        //~ $res        = $this->Do_report->fetch_ssp_stats($search, $order, $limit);
        //~ $total      = $this->Do_report->fetch_ssp_stats($search, $order);
        //~ $no_records = ($total !== FALSE) ? count($total) : 0;
        //~ if ($no_records) {
            //~ $result_data['sEcho']                = $datatable_obj['sEcho'];
            //~ $result_data['iTotalRecords']        = $no_records;
            //~ $result_data['iTotalDisplayRecords'] = $no_records;
            //~ $result_data['aaData']               = $res;
            //~ //$result_data['overview_chart_data']     =     $chart_data;
            //~ 
        //~ } else {
            //~ $result_data['sEcho']                = $datatable_obj['sEcho'];
            //~ $result_data['iTotalRecords']        = $no_records;
            //~ $result_data['iTotalDisplayRecords'] = 0;
            //~ $result_data['aaData']               = array();
            //~ //$result_data['overview_chart_data']     =     '';            
            //~ 
        //~ }
        //~ 
        //~ $this->response($result_data, 200);
    //~ }
    //~ 
    function fetch_ssp_detail_post()
    {
        //Get from library file
        $exchange_id   = $this->post('exchange_id');
        $date          = $this->post('date');
        $datatable_obj = $this->post('datatable_obj');
        $account_id    = $this->user_authentication->account_id;
        $account_type  = $this->user_authentication->account_type;
        
        $search['account_id']    = $account_id;
        $search['account_type']  = $account_type;
        $search['search_term']   = $datatable_obj['sSearch'];
        $search['search_fields'] = array(
            "client_name",
            "camp_name",
            "ban_name"
        );
        
        $order = $this->post('order');
        $limit = array(
            "start" => $this->post('start'),
            "end" => $this->post('end')
        );
        
        $res        = $this->Do_report->fetch_ssp_detail_stats($exchange_id, $date, $search, $order, $limit);

        $total      = $this->Do_report->fetch_ssp_detail_stats($exchange_id, $date, $search, $order);
        $no_records = ($total !== FALSE) ? count($total) : 0;
        if ($no_records) {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = $no_records;
            $result_data['aaData']               = $total;
            //$result_data['overview_chart_data']     =     $chart_data;
            
        } else {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = 0;
            $result_data['aaData']               = array();
            //$result_data['overview_chart_data']     =     '';            
            
        }
        
        $this->response($result_data, 200);
    }
    
   function fetch_ssp_date_post()
    {
        //Get from library file
        $exchange_id   = $this->post('exchange_id');
        $datatable_obj = $this->post('datatable_obj');
        $account_id    = $this->user_authentication->account_id;
        $account_type  = $this->user_authentication->account_type;
        
        $search['account_id']    = $account_id;
        $search['account_type']  = $account_type;
        $search['search_term']   = $datatable_obj['sSearch'];
        $search['search_fields'] = array(
            "dbdate"
        );
        
        if ($this->post('date_from') != '') {
            $search['date_from'] = $this->post('date_from');
        }
        if ($this->post('date_to') != '') {
            $search['date_to'] = $this->post('date_to');
        }
        
        
        $order = $this->post('order');
        $limit = array(
            "start" => $this->post('start'),
            "end" => $this->post('end')
        );
        
        $res        = $this->Do_report->fetch_ssp_date_stats($exchange_id, $search, $order, $limit);
       
        $total      = $this->Do_report->fetch_ssp_date_stats($exchange_id, $search, $order);
        $no_records = ($total !== FALSE) ? count($total) : 0;
        if ($no_records) {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = $no_records;
            $result_data['aaData']               = $res;
            //$result_data['overview_chart_data']     =     $chart_data;
            
        } else {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = 0;
            $result_data['aaData']               = array();
            //$result_data['overview_chart_data']     = '';            
            
        }
        
        $this->response($result_data, 200);
    }    
    
  //ssp report fetch
   
    function fetch_ssp_post()
    {
		
       
		 $page         = $this->post('page');
		 $display      = $this->post('display_type');
         $account_id   = $this->user_authentication->account_id;
         $account_type = $this->user_authentication->account_type;
         //$currency		= $this->post('currency');
         //$dj_date=apifixerdate();
         $agency_id = FALSE;
		                          
        switch (strtoupper($account_type)) {
            case 'ADMIN';
                $agency_id = $this->Do_notification->getAdminAgencyId($account_id);
                break;
            case 'MANAGER';
                $agency_id = $this->Do_notification->getManagerAgencyId($account_id);
                break;
            
        }
       
        if ($account_type === 'MANAGER') {
            $account_type = 'ADMIN';
        } else {
            $account_type = $account_type;
        }

        $manager_role_id = $this->user_authentication->manager_role_id;
       
               
        $stat_type = ($this->post('stat_type') !== '') ? $this->post('stat_type') : '';
        
        // GET DATA BASED ON PREDEFINED CONFIG VALUES
        
        //GET the datatable object or request
        $datatable_obj = $this->post('datatable_obj');

        $search['page']         = $page;
        $search['account_id']   = $account_id;
        $search['account_type'] = $account_type;
         
        $search['search_term']  = $datatable_obj['sSearch'];
        $columns                = array();
        $group                  = array();
        $order                  = array();
        $limit                  = array();

        $rep_config = $this->config->item('report_config');

        if (isset($rep_config[strtoupper($account_type)][strtoupper($page)])) {
            
            $settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper($display)];
            
            if (is_array($settings) AND count($settings) > 0) {
                
                foreach ($settings['FIELDS'] as $key => $value) {
                    
                    
                    if (isset($rep_config['MANAGER_PERMISSION'][strtoupper($key)]) && strtoupper($account_type) == 'ADMIN') {
                        
                        
                        if (check_permission_layout($rep_config['MANAGER_PERMISSION'][strtoupper($key)], $manager_role_id)) {
                            
                            array_push($columns, $key);
                        }
                    } else {
                        array_push($columns, $key);
                    }
                }
                
                $group = $settings['GROUP'];

                $columns = array_unique(array_merge($group, $columns));
               // $this->response($group,200);
                
                 //returns the sorting data or false
                //$this->response($settings['SEARCH_FIELDS']);
                // GET SEARCH FIELDS 
                if (isset($settings['SEARCH_FIELDS'])) {
                    $search['search_fields'] = $settings['SEARCH_FIELDS'];
                } else {
                    $search['search_fields'] = FALSE;
                }

                if ($this->convert_sorting_data($datatable_obj)) {
                    $order = $this->convert_sorting_data($datatable_obj);
						//$this->response($order,200);                    
                } else {
                    $order = $settings['ORDER'];
                }
                 
                if ($this->post('start') != '') {
                    $limit = array(
                        'start' => $this->post('start'),
                        'end' => $this->post('end')
                    );
                } else {
                    $limit = $settings['LIMIT'];
                }

                if ($settings['DEFAULT_INTERVAL'] != '') {
                    $date                = get_search_date($settings['DEFAULT_INTERVAL']);
                    $search['date_from'] = $date['from_date'];
                    $search['date_to']   = $date['to_date'];
                }

                // ADD SEARCH FIELDS
                
                 if ($this->post('exchangeval') != '') {
                    $search['exchangeval'] = $this->post('exchangeval');
                }
                
                if ($this->post('date_from') != '') {
                    $search['date_from'] = $this->post('date_from');
                }
                
                if ($this->post('date_to') != '') {
                    $search['date_to'] = $this->post('date_to');
                }
                
                if ($this->post('environment') != '' AND $this->post('environment') != 'all') {
                    $search['environment'] = $this->post('environment');
                }

                if ($agency_id != FALSE) {
                    $search['agency_id'] = $agency_id;
                }

                $dataTable = FALSE;
                $search['realtime_report'] =$this->default_configurations->get('real_time_report_view');

               // $search['realtime_report'] ='Yes';
                if ($display === 'TABLE') {
                    $dataTable = TRUE;

                }


                $res = $this->Do_report->fetch_ssp_stats($columns, $search, $group, $order, $limit, $dataTable, $client_id);
                 
               // $this->response($res,200);   
                                                                            
				//~ // DB Data 
                if ($display === 'TABLE') {
				
                    // GET CHART SETTINGS AND DATA
                    
                    $chart_settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper('chart')];
                    
                    if ($this->post('start') != '') {

                        if ($this->post('end') <= $chart_settings['LIMIT']['end']) {
                            $chart_limit = array(
                                'start' => $this->post('start'),
                                'end' => $this->post('end')
                            );
                         } else {
                            $chart_limit = $chart_settings['LIMIT'];
                        }
                     }
                     else {

                        $chart_limit = $chart_settings['LIMIT'];
                    }
                
                    $chart_data_res = $this->Do_report->fetch_ssp_stats($columns, $search, $group, $order, $chart_limit, $client_id);

                    $chart_data = $this->convert_chart_data($chart_data_res, $chart_settings);
                    
                    //~ // $this->response($chart_settings, 200);
                    //~ 
                    switch ($account_type) {
                        case 'ADMIN':
                            switch ($page) {
                                case 'REPORT_SSP':
                                    $total      = $this->Do_report->fetch_ssp_stats($columns, $search, $group, $order, $settings['LIMIT'], $dataTable, $client_id);
                                    // $this->response($total);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
									//$result = array_map('callbackformat', $result_data); //callback from helper file for date
									$this->response($result_data, 200); // 200 being the HTTP response code

                                    break;
                                
                                   
                                default:
                                    $this->response($res, 200);
                                    break;
                            }
                            break;
                       
                    }
                    
                 } 
                 else if ($display === 'CHART' AND $res != FALSE) {
					
					
					if($display === 'CHART'  AND $account_type === 'ADMIN')
					{
						
						//$res['records'] = $this->convert_currency_data($res['records'],$currency,'N');
							
					}
					
                    $success = $this->convert_chart_data($res, $settings);
                    $this->response($success, 200);
                }  else {
                    
                  
                    
                    $success = array(
                        'response' => 'ok',
                        'data' => $res
                    );
                    
                    $this->response($success, 200);
                }
            }
          }
        }    
    
    // ssp fetch march-29-2017 end        
    
    function fetch_advertiser_dsp_post()
    {
        
        //Get from library file
        $datatable_obj  = $this->post('datatable_obj');
        $adv_account_id = $this->post('adv_account_id');
        $account_id     = $this->user_authentication->account_id;
        $account_type   = $this->user_authentication->account_type;
        
        $search['account_id']    = $account_id;
        $search['account_type']  = $account_type;
        $search['search_term']   = $datatable_obj['sSearch'];
        $search['search_fields'] = array(
            "exchange_name"
        );
        
        if ($this->post('date_from') != '') {
            $search['date_from'] = $this->post('date_from');
        }
        if ($this->post('date_to') != '') {
            $search['date_to'] = $this->post('date_to');
        }
       
        
        $order = $this->post('order');
        $limit = array(
            "start" => $this->post('start'),
            "end" => $this->post('end')
        );
        
        $res        = $this->Do_report->fetch_advertiser_dsp_stats($search, $order, $limit, $adv_account_id);
        $total      = $this->Do_report->fetch_advertiser_dsp_stats($search, $order, '', $adv_account_id);
        $no_records = ($total !== FALSE) ? count($total) : 0;
        if ($no_records) {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = $no_records;
            $result_data['aaData']               = $res;
            
        } else {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = 0;
            $result_data['aaData']               = array();
           
        }
        
        $this->response($result_data, 200);
    }
    
    function fetch_advertiser_dsp_date_post()
    {
        //Get from library file
        $exchange_id    = $this->post('exchange_id');
        $datatable_obj  = $this->post('datatable_obj');
        $adv_account_id = $this->post('adv_account_id');
        $account_id     = $this->user_authentication->account_id;
        $account_type   = $this->user_authentication->account_type;
        
        $search['account_id']    = $account_id;
        $search['account_type']  = $account_type;
        $search['search_term']   = $datatable_obj['sSearch'];
        $search['search_fields'] = array(
            "dbdate"
        );
        
        if ($this->post('date_from') != '') {
            $search['date_from'] = $this->post('date_from');
        }
        if ($this->post('date_to') != '') {
            $search['date_to'] = $this->post('date_to');
        }
        
        
        $order = $this->post('order');
        $limit = array(
            "start" => $this->post('start'),
            "end" => $this->post('end')
        );
        
        $res        = $this->Do_report->fetch_advertiser_dsp_date_stats($exchange_id, $search, $order, $limit, $adv_account_id);
        $total      = $this->Do_report->fetch_advertiser_dsp_date_stats($exchange_id, $search, $order, "", $adv_account_id);
        $no_records = ($total !== FALSE) ? count($total) : 0;
        if ($no_records) {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = $no_records;
            $result_data['aaData']               = $res;
            
            
        } else {
            $result_data['sEcho']                = $datatable_obj['sEcho'];
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = 0;
            $result_data['aaData']               = array();
            
        }
        
        $this->response($result_data, 200);
    }
    
    function fetch_advertiser_dsp_detail_post()
    {
        //Get from library file
        $exchange_id    = $this->post('exchange_id');
        $date           = $this->post('date');
        $adv_account_id = $this->post('adv_account_id');
        $date           = $this->post('date');
        $account_id     = $this->user_authentication->account_id;
        $account_type   = $this->user_authentication->account_type;
        
        $search['account_id']    = $account_id;
        $search['account_type']  = $account_type;
        $search['search_term']   = $datatable_obj['sSearch'];
        $search['search_fields'] = array(
            "client_name",
            "camp_name",
            "ban_name"
        );
        
        $order = $this->post('order');
        $limit = array(
            "start" => $this->post('start'),
            "end" => $this->post('end')
        );
        
        $res = $this->Do_report->fetch_advertiser_dsp_detail_stats($exchange_id, $date, $search, $order, $limit, $adv_account_id);
        
        $total = $this->Do_report->fetch_advertiser_dsp_detail_stats($exchange_id, $date, $search, $order, "", $adv_account_id);
        
        $no_records = ($total !== FALSE) ? count($total) : 0;
        if ($no_records) {
            
            $result_data['sEcho']                = 1;
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = $no_records;
            $result_data['aaData']               = $total;
            
            
        } else {
            
            $result_data['sEcho']                = 1;
            $result_data['iTotalRecords']        = $no_records;
            $result_data['iTotalDisplayRecords'] = 0;
            $result_data['aaData']               = array();
            
            
        }
        
        $this->response($result_data, 200);
    }
    
     //added by Murugeswari on 18-05-17
    
    function fetch_video_adnetwork_get()
    {
		$dsp = 	$this->Do_report->fetch_all_dsp();
		if($dsp)
		{
			$this->response($dsp,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
   
       function fetch_video_adblock_get()
    {
		
        //Get from library file
        $network_account_id = $this->user_authentication->network_account_id;
        $network_id         = $this->user_authentication->account_id;
        $account_id         = $this->get('account_id');
        
        if ($account_id) {
            if ($network_account_id) {
                $publisher = $this->Do_report->fetch_video_adblock($network_id, $network_account_id, $account_id);
            } else {
                $publisher = $this->Do_report->fetch_video_adblock($network_id, '', $account_id);
            }
        } else {
            if ($network_account_id) {
                $publisher = $this->Do_report->fetch_video_adblock($network_id, $network_account_id);
            } else {
                $publisher = $this->Do_report->fetch_video_adblock($network_id);
            }
        }
        
        $this->response($publisher, 200);
    }
     function fetch_affiliate_post()
    {
		
		 $page         = $this->post('page');
		
		 $display      = $this->post('display_type');
         $account_id   = $this->user_authentication->account_id;
         $account_type = $this->user_authentication->account_type;
         //$currency		= $this->post('currency');
         //$dj_date=apifixerdate();
         $agency_id = FALSE;
		                            
        switch (strtoupper($account_type)) {
            case 'ADMIN';
                $agency_id = $this->Do_notification->getAdminAgencyId($account_id);
                break;
            case 'MANAGER';
                $agency_id = $this->Do_notification->getManagerAgencyId($account_id);
                break;
            
        }
       
        if ($account_type === 'MANAGER') {
            $account_type = 'ADMIN';
        } else {
            $account_type = $account_type;
        }

        $manager_role_id = $this->user_authentication->manager_role_id;
       
               
        $stat_type = ($this->post('stat_type') !== '') ? $this->post('stat_type') : '';
        
        // GET DATA BASED ON PREDEFINED CONFIG VALUES
        
        //GET the datatable object or request
        $datatable_obj = $this->post('datatable_obj');

        $search['page']         = $page;
        $search['account_id']   = $account_id;
        $search['account_type'] = $account_type;
         
        $search['search_term']  = $datatable_obj['sSearch'];
        $columns                = array();
        $group                  = array();
        $order                  = array();
        $limit                  = array();
 		
        $rep_config = $this->config->item('report_config');

        if (isset($rep_config[strtoupper($account_type)][strtoupper($page)])) {
            
            $settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper($display)];
            
            if (is_array($settings) AND count($settings) > 0) {
                
                foreach ($settings['FIELDS'] as $key => $value) {
                    
                    
                    if (isset($rep_config['MANAGER_PERMISSION'][strtoupper($key)]) && strtoupper($account_type) == 'ADMIN') {
                        
                        
                        if (check_permission_layout($rep_config['MANAGER_PERMISSION'][strtoupper($key)], $manager_role_id)) {
                            
                            array_push($columns, $key);
                        }
                    } else {
                        array_push($columns, $key);
                    }
                }
                
                $group = $settings['GROUP'];

                $columns = array_unique(array_merge($group, $columns));
               // $this->response($group,200);
                
                 //returns the sorting data or false
                 
                // GET SEARCH FIELDS 
                if (isset($settings['SEARCH_FIELDS'])) {
                    $search['search_fields'] = $settings['SEARCH_FIELDS'];
                } else {
                    $search['search_fields'] = FALSE;
                }

                if ($this->convert_sorting_data($datatable_obj)) {
                    $order = $this->convert_sorting_data($datatable_obj);
                } else {
                    $order = $settings['ORDER'];
                }
                 
                if ($this->post('start') != '') {
                    $limit = array(
                        'start' => $this->post('start'),
                        'end' => $this->post('end')
                    );
                } else {
                    $limit = $settings['LIMIT'];
                }

                if ($settings['DEFAULT_INTERVAL'] != '') {
                    $date                = get_search_date($settings['DEFAULT_INTERVAL']);
                    $search['date_from'] = $date['from_date'];
                    $search['date_to']   = $date['to_date'];
                }

                // ADD SEARCH FIELDS
                
                if ($this->post('date_from') != '') {
                    $search['date_from'] = $this->post('date_from');
                }
                
                if ($this->post('date_to') != '') {
                    $search['date_to'] = $this->post('date_to');
                }
                
                if ($this->post('environment') != '' AND $this->post('environment') != 'all') {
                    $search['environment'] = $this->post('environment');
                }

                if ($agency_id != FALSE) {
                    $search['agency_id'] = $agency_id;
                }
                //~ if ($currency != FALSE) {
                    //~ $search['currency'] = $currency;
                //~ }

                $dataTable = FALSE;
                $search['realtime_report'] =$this->default_configurations->get('real_time_report_view');

               // $search['realtime_report'] ='Yes';
                if ($display === 'TABLE') {
                    $dataTable = TRUE;

                }

                $res = $this->Do_report->fetch_affiliates($columns, $search, $group, $order, $limit, $dataTable, $client_id);
                 
               // $this->response($res,200);   
                                                                            //~ 
                //~ if($display === 'TABLE')
				//~ {
					//~ $res = $this->convert_currency_data($res,$currency,'Y');
				//~ }
				//~ // DB Data 
                if ($display === 'TABLE') {
				
                    // GET CHART SETTINGS AND DATA
                    
                    $chart_settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper('chart')];
                    
                    if ($this->post('start') != '') {

                        if ($this->post('end') <= $chart_settings['LIMIT']['end']) {
                            $chart_limit = array(
                                'start' => $this->post('start'),
                                'end' => $this->post('end')
                            );
                         } else {
                            $chart_limit = $chart_settings['LIMIT'];
                        }
                     }
                     else {

                        $chart_limit = $chart_settings['LIMIT'];
                    }
                    
                    $chart_data_res = $this->Do_report->fetch_affiliates($columns, $search, $group, $order, $chart_limit, $client_id);

                    $chart_data = $this->convert_chart_data($chart_data_res, $chart_settings);
                    
                    
                    //~ // $this->response($chart_settings, 200);
                    //~ 
                    switch ($account_type) {
                        case 'ADMIN':
                            switch ($page) {
                                case 'REPORT_AFFILIATE':
                               
                                    
                                    $total      = $this->Do_report->fetch_affiliates($columns, $search, $group, $order, $settings['LIMIT'], $dataTable, $client_id);
                                    // $this->response($total);
                                    $no_records = ($total !== FALSE) ? count($total) : 0;
                                    if ($no_records) {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = $no_records;
                                        $result_data['aaData']               = $res;
                                        $result_data['overview_chart_data']  = $chart_data;
                                        
                                    } else {
                                        $result_data['sEcho']                = $datatable_obj['sEcho'];
                                        $result_data['iTotalRecords']        = $no_records;
                                        $result_data['iTotalDisplayRecords'] = 0;
                                        $result_data['aaData']               = array();
                                        $result_data['overview_chart_data']  = '';
                                        
                                    }
                                    
                                    // RETURN DATATABLE AND CHART DATA
									//$result = array_map('callbackformat', $result_data); //callback from helper file for date
									$this->response($result_data, 200); // 200 being the HTTP response code

                                    break;
                                
                                   
                                default:
                                    $this->response($res, 200);
                                    break;
                            }
                            break;
                       
                    }
                    
                 } 
                 else if ($display === 'CHART' AND $res != FALSE) {
					
					
					if($display === 'CHART'  AND $account_type === 'ADMIN')
					{
						
						//$res['records'] = $this->convert_currency_data($res['records'],$currency,'N');
							
					}
					
                    $success = $this->convert_chart_data($res, $settings);
                    $this->response($success, 200);
                }  else {
                    
                  
                    
                    $success = array(
                        'response' => 'ok',
                        'data' => $res
                    );
                    
                    $this->response($success, 200);
                }
            }
          }
        }    
    //
    
    
	function fetch_custom_targeting1_get($adv_id=FALSE)
	{
		 if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id         = $this->user_authentication->account_id;
            $data['account_id'] = $account_id;
        } else {
            $agency_id         = $this->user_authentication->agency_id;
            $data['agency_id'] = $agency_id;
        }
        if ($adv_id != FALSE && $adv_id != 'all') {
            $data['account_id'] = $adv_id;
        }
		$customtarg_list = $this->Do_report->fetch_targeting_customtarg1($data);    
        $this->response($customtarg_list, 200);       
	}
	
	function fetch_custom_targeting2_get($adv_id=FALSE)
	{
		 if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id         = $this->user_authentication->account_id;
            $data['account_id'] = $account_id;
        } else {
            $agency_id         = $this->user_authentication->agency_id;
            $data['agency_id'] = $agency_id;
        }
        if ($adv_id != FALSE && $adv_id != 'all') {
            $data['account_id'] = $adv_id;
        }
		$customtarg_list = $this->Do_report->fetch_targeting_customtarg2($data);    
        $this->response($customtarg_list, 200);       
	}
	
	function fetch_custom_targeting3_get($adv_id=FALSE)
	{
		 if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id         = $this->user_authentication->account_id;
            $data['account_id'] = $account_id;
        } else {
            $agency_id         = $this->user_authentication->agency_id;
            $data['agency_id'] = $agency_id;
        }
        if ($adv_id != FALSE && $adv_id != 'all') {
            $data['account_id'] = $adv_id;
        }
		$customtarg_list = $this->Do_report->fetch_targeting_customtarg3($data);    
        $this->response($customtarg_list, 200);       
	}
	
	function fetch_custom_targeting4_get($adv_id=FALSE)
	{
		 if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id         = $this->user_authentication->account_id;
            $data['account_id'] = $account_id;
        } else {
            $agency_id         = $this->user_authentication->agency_id;
            $data['agency_id'] = $agency_id;
        }
        if ($adv_id != FALSE && $adv_id != 'all') {
            $data['account_id'] = $adv_id;
        }
		$customtarg_list = $this->Do_report->fetch_targeting_customtarg4($data);    
        $this->response($customtarg_list, 200);       
	}
}
