<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for publisher related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Suganthi
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Publisher extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_publisher');
		$this->load->model('Do_site');
		$this->load->model('Do_invoices');
		$this->load->model('Do_networks');
		$this->load->model('Do_email_check');
		$this->load->helper('email');
		$this->load->library('user_authentication');
		$key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
	/**
       * 
       * name : fetch_get()
       * 
       * Fetches all publisher information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_get()
	{	
		#$network_account_id	=	$this->get('network_account_id');
		#$network_id			=	$this->get('network_id');
		#$account_id			=	$this->get('account_id');
		
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->account_id;
		$account_id			=	$this->get('account_id');
		$man_account_id		=	$this->get('man_account_id');
		$exchangeval		=	$this->get('exchangeval');
	
		if($account_id)
		{
			if($network_account_id)
			{
				$publisher = 	$this->Do_publisher->fetch($network_id,$network_account_id,$account_id,'',$exchangeval);
			}
			else
			{
				$publisher = 	$this->Do_publisher->fetch($network_id,'',$account_id,'',$exchangeval);
			}
		}
		else if($man_account_id)
		{
				$publisher = 	$this->Do_publisher->fetch($network_id,'','',$man_account_id,$exchangeval);
		}
		else
		{
			if($network_account_id)
			{
				$publisher = 	$this->Do_publisher->fetch($network_id,$network_account_id,'','',$exchangeval);
			}
			else
			{
				$publisher = 	$this->Do_publisher->fetch($network_id,'','','',$exchangeval);
			}
		}
		
		if($publisher)
		{
			$this->response($publisher,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}	
	
	
	function fetch_aff_publisher_get()
	{	
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->account_id;
		$account_id			=	$this->get('account_id');
		$man_account_id		=	$this->get('man_account_id');
	
		if($account_id)
		{
			if($network_account_id)
			{
				$publisher = 	$this->Do_publisher->fetch_aff_publisher($network_id,$network_account_id,$account_id);
			}
			else
			{
				$publisher = 	$this->Do_publisher->fetch_aff_publisher($network_id,'',$account_id);
			}
		}
		else if($man_account_id)
		{
				$publisher = 	$this->Do_publisher->fetch_aff_publisher($network_id,'','',$man_account_id);
		}
		else
		{
			if($network_account_id)
			{
				$publisher = 	$this->Do_publisher->fetch_aff_publisher($network_id,$network_account_id);
			}
			else
			{
				$publisher = 	$this->Do_publisher->fetch_aff_publisher($network_id);
			}
		}
		
		if($publisher)
		{
			$this->response($publisher,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}	
	
	/**
       * 
       * name : site_count_get()
       * 
       * Fetches all site count.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function site_count_get()
	{	
		#$network_account_id	=	$this->get('network_account_id');
		#$network_id			=	$this->get('network_id');
		#$account_id			=	$this->get('account_id');
		
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->account_id;
		$account_id			=	$this->get('account_id');
		
		if($account_id)
		{
			if($network_account_id)
			{
				$count = 	$this->Do_publisher->site_count($network_id,$network_account_id,$account_id);
			}
			else
			{
				$count = 	$this->Do_publisher->site_count($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{   
				$count = 	$this->Do_publisher->site_count($network_id,$network_account_id);
			}
			else
			{
				$count = 	$this->Do_publisher->site_count($network_id);
			}
		}
		
		if($count)
		{		
			$this->response($count,200);
		}
		else
		{
			$this->response('0', 200);
		}
	}
	
	/**
       * 
       * name : ad_block_count_get()
       * 
       * Fetches all ad block count.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function ad_block_count_get()
	{	
		#$network_id		=	$this->get('network_id');
		#$affiliate_id		=	$this->get('affiliate_id');
		
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->network_id;
		$affiliate_id	    =	$this->user_authentication->affiliate_id;
		$agency_id			=	$this->user_authentication->agency_id;
		$account_id		    =	$this->get('account_id');
		
		if($account_id)
		{
			if($affiliate_id)
			{
				$count = 	$this->Do_publisher->ad_block_count($network_id,$account_id,$affiliate_id);
			}
			else
			{
				$count = 	$this->Do_publisher->ad_block_count($network_id,$account_id);
			}
		}
		else
		{
			$count = 	$this->Do_publisher->ad_block_count($network_id,'','','',$agency_id);
		}
		
		if($count)
		{		
			$this->response($count,200);
		}
		else
		{
			$this->response('0', 200);
		}
	}

	/*07-08-2015
	 Publisher Count
	 */
	function pub_count_get()
	{	
		
		$network_account_id = $this->user_authentication->network_account_id;
		$network_id = $this->user_authentication->network_id;
		$affiliate_id = $this->user_authentication->affiliate_id;
		$agency_id = $this->user_authentication->agency_id;
		$account_id = $this->get('account_id');

		if ($account_id) {
			if ($affiliate_id) {
				$count = $this->Do_publisher->ad_pub_count($network_id, $account_id, $affiliate_id);
			} else {
				$count = $this->Do_publisher->ad_pub_count($network_id, $account_id);
			}
		} else {
			$count = $this->Do_publisher->ad_pub_count($network_id, '', '', '', $agency_id);
		}

		if ($count) {
			$this->response($count, 200);
		} else {
			$this->response('0', 200);
		}
	}
	
	//api/v1/publisher/add
	function add_post()
	{	
		
		$this->form_validation->set_rules('first_name','lang:first_name', 'required|trim');
		$this->form_validation->set_rules('last_name', 'lang:last_name','required|trim');
		$this->form_validation->set_rules('email_id', 'lang:email_add', 'required|trim|is_email|callback_email_check');
		$this->form_validation->set_rules('logusername', 'lang:login_name','trim|required|callback_username_check');
		$this->form_validation->set_rules('website', 'lang:website', 'required|trim|is_unique[ox_affiliates.website]');
		$this->form_validation->set_rules('password', 'lang:user_pass','required|trim');
		$this->form_validation->set_rules('confirm_password', 'lang:confirm_password','required|trim|matches[password]');

		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			
			
			$user_auth  	= 	$this->user_authentication;
			$network_id		=	$user_auth->network_account_id;
			$account_id		=	$user_auth->account_id;
			
			$pwd 			= 	$this->post('password');
			$encrypted_pwd 	= 	$this->encrypt->encode($pwd);
			$user_currency  =   $this->config->item('user_currency');
			
			$add_data		=	array(
									'first_name'	=>	$this->post('first_name'),
									'last_name'		=>	$this->post('last_name'),
									'email'			=>	$this->post('email_id'),
									'login_username'=>	$this->post('logusername'),
									'password'		=>	$this->post('password'),
									'user_currency'=>	$user_currency,
									'site_url'		=>	$this->post('website'),
									'account_type'	=>	'TRAFFICKER',
									'created_date'	=>	mdate('%Y-%m-%d %H:%i:%s',local_to_gmt())
									);

			if ($network_id) {
						
				$publisher_add = 	$this->Do_publisher->add($add_data,$account_id,$network_id);

			}
			else
			{

				$publisher_add = 	$this->Do_publisher->add($add_data,$account_id);

			}
			
			if($publisher_add != FALSE)
			{	
				// SEND  LOGIN DETAILS TO USER
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->Do_networks->agency_owner_details($agency_id);
				if($agency_id == 1)
				{
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$account_type  = $publisher_add['account_type'];
					$account_id    = $publisher_add['account_id'];
					$account_type  = $add_data['account_type'];
					$user_email    = $add_data['email'];
					$login_name    = $add_data['login_username'];
					$password      = $pwd;
					$user_name     = $add_data['first_name']." ".$add_data['last_name'];
					$type          = 'PUB_LOGIN_CREDENTIAL';		
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> $this->lang->line('login_credentials'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						"login_name"  	=> $login_name,
						"password"		=> $password								
						);			
						send_mail($type,$from,$to,$mail_content);
				
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	$this->lang->line('publisher_added_success')
									);
					$this->response( $success, 200);
				}
				else
				{
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->Do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$account_type  = $publisher_add['account_type'];
					$account_id    = $publisher_add['account_id'];
					$account_type  = $add_data['account_type'];
					$user_email    = $add_data['email'];
					$login_name    = $add_data['login_username'];
					$password      = $pwd;
					$user_name     = $add_data['first_name']." ".$add_data['last_name'];
					$type          = 'PUB_LOGIN_CREDENTIAL';		
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> $this->lang->line('login_credentials'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						"login_name"  	=> $login_name,
						"password"		=> $password								
						);			
					$attachement = "";	
					send_mail($type,$from,$to,$mail_content,$attachement.$bcc);
				
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	$this->lang->line('publisher_added_success')
									);
					$this->response( $success, 200);
				}
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
								);
				$this->response( $error, 200);
			}
						
		}
	}
	
	
	/**
       * 
       * name : update_post()
       * 
       * Updates the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		$account_id	=	$this->post('account_id');
		
		
		
		$this->form_validation->set_rules('first_name','lang:first_name', 'required|trim');
		$this->form_validation->set_rules('last_name', 'lang:last_name','required|trim');
		
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			$this->response( $error, 200);
		}
		else
		{
			$update_data	=	array(
									'first_name'	=>	$this->post('first_name'),
									'last_name'		=>	$this->post('last_name'),
									'email'			=>	$this->post('email_id'),
									'login_username'=>	$this->post('logusername'),
									'site_url'		=>	$this->post('website'),
									'account_type'	=>	'TRAFFICKER',
									);
									
			$pub_update 	= 	$this->Do_publisher->update($account_id,$update_data);
			
			if($pub_update != FALSE)
			{	
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('publisher_updated_success')
									);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
									);
				$this->response( $error, 200);
			}			
		}
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the publisher information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{	
		$account_id = $this->get('del_account_id');
		
		if($account_id)
		{
			$publisher_details = 	$this->Do_publisher->get_profile($account_id);
			$publisher = 	$this->Do_publisher->remove($account_id);
			if($publisher)
			{
				 // SEND DELETION MESSAGE TO USER
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->Do_networks->agency_owner_details($agency_id);
				if($agency_id==1)
				{			
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $publisher_details['email'];
					$user_name     = $publisher_details['first_name']." ".$publisher_details['last_name'];
					$type          = 'PUB_DELETION';		
					$from 	       = $admin_email;
					$to  	       = $user_email;			
					$mail_content  = array(
						"subject" 		=> $this->lang->line('publisher_deletion'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email
						);			
					send_mail($type,$from,$to,$mail_content);
					$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('publisher_deleted_success')
										);
					
					$this->response( $success, 200);
				}
				else
				{
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->Do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $publisher_details['email'];
					$user_name     = $publisher_details['first_name']." ".$publisher_details['last_name'];
					$type          = 'PUB_DELETION';		
					$from 	       = $admin_email;
					$to  	       = $user_email;			
					$mail_content  = array(
						"subject" 		=> $this->lang->line('publisher_deletion'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email
						);
						$attachement = "";			
					send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
					$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('publisher_deleted_success')
										);
					
					$this->response( $success, 200);
				}
			}
			else
			{
				$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('error_try_again')
								);
			
				$this->response( $error, 200);
			}
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('publisher_not_found')
								);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : block_get()
       * 
       * block the publisher information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function block_get()
	{	
		$account_id = $this->get('block_account_id');	
		
		if($account_id)
		{
			$publisher 	= 	$this->Do_publisher->block($account_id);
			
			if($publisher)
			{
				$publisher_details 	= 	$this->Do_publisher->get_profile($account_id);
				//SEND MAIL TO THE BLOCKED ADVERTISER
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->Do_networks->agency_owner_details($agency_id);
				if($agency_id == 1)
				{			
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $publisher_details['email'];
					$user_name     = $publisher_details['first_name'].' '.$publisher_details['last_name'];
					$type     	   = "BLOCK_PUBLISHER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> $this->lang->line('publisher_blcked'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					send_mail($type,$from,$to,$mail_content,$attachement,$from);
					$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('publisher_blocked_success')
										);
					
					$this->response( $success, 200);
				}
				else
				{
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->Do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];
					$admin_email   = $result['email'];
					$user_email    = $publisher_details['email'];
					$user_name     = $publisher_details['first_name'].' '.$publisher_details['last_name'];
					$type     	   = "BLOCK_PUBLISHER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> $this->lang->line('publisher_blcked'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					send_mail($type,$from,$to,$mail_content,$attachement,$from,$bcc);
					$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('publisher_blocked_success')
										);
					
					$this->response( $success, 200);
				}
			}
			else
			{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
									);
				
				$this->response( $error, 200);
			}
			
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('publisher_not_found')
								);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : unblock_get()
       * 
       * block the publisher information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function unblock_get()
	{	
		$account_id = $this->get('unblock_account_id');	
		 
		if($account_id)
		{
			$publisher 	= 	$this->Do_publisher->unblock($account_id);
			
			if($publisher)
			{
				$publisher_details 	= 	$this->Do_publisher->get_profile($account_id);
				//SEND MAIL TO THE UNBLOCKED PUBLISHER
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->Do_networks->agency_owner_details($agency_id);
				if($agency_id ==1)
				{			
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $publisher_details['email'];
					$user_name     = $publisher_details['first_name'].' '.$publisher_details['last_name'];
					$type     	   = "UNBLOCK_PUBLISHER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> $this->lang->line('publisher_unblcked'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					send_mail($type,$from,$to,$mail_content,$attachement,$from);
					$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('publisher_unblocked_success')
										);
					
					$this->response( $success, 200);
				}
				else
				{
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->Do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $publisher_details['email'];
					$user_name     = $publisher_details['first_name'].' '.$publisher_details['last_name'];
					$type     	   = "UNBLOCK_PUBLISHER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> $this->lang->line('publisher_unblcked'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					send_mail($type,$from,$to,$mail_content,$attachement,$from,$bcc);
					$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('publisher_unblocked_success')
										);
					
					$this->response( $success, 200);
				}	
			}
			else
			{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
									);
				
				$this->response( $error, 200);
			}
			
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('publisher_not_found')
								);
			
			$this->response( $error, 200);
		}
	}
	
	/*
	 * 
	 * name: user_information
	 * @param :null
	 * @return : response Array
	 * 
	 * get the user information for particular Publisher
	 */	
	 
	 public function user_information_get()
	 {	
		 
		 $user_auth  	= 	$this->user_authentication;
		 $account_id	= 	$user_auth->account_id;
		 
		 $user_info=$this->Do_publisher->get_user_information($account_id);	
		
		 if($user_info!='')
		 {
			$this->response($user_info, 200); // 200 being the HTTP response code
		 }		
		
	 }
	
	
	/*
	 * 
	 * name: company_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the company Information for Particular Publisher
	 */
	
    public function company_information_add_post(){		
		
		$this->form_validation->set_rules('company_name', 'lang:company_name', 'trim|required');
		$this->form_validation->set_rules('company_address', 'lang:company_address', 'trim|required');
		$this->form_validation->set_rules('company_block_no', 'lang:company_block_no', 'trim|required');
		$this->form_validation->set_rules('company_address', 'lang:company_address', 'trim|required');
		$this->form_validation->set_rules('company_state', 'lang:company_state', 'trim|required');
		$this->form_validation->set_rules('company_country', 'lang:company_country', 'trim|required');
		
		if($this->form_validation->run() === FALSE || $this->post('company_country') == '0')
		{
			$error_msg = $this->form_validation->error_array();			
			
			if($this->post('company_country') == '0')
			{
				$error = array(
								'response' => 'error',
								'msg' =>  $this->lang->line('chs_yr_cmpy_info')								
							);
				
			}
			else{
			
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);
			}

			 $this->response( $error, 200);
		}
		else{	
			
			
			$user_auth	= 	$this->user_authentication;
			$account_id	= 	$user_auth->account_id;
			
			$update_company_infoObj=array(							
										"company_name"  =>	$this->post('company_name'),
										"company_address"	=>	$this->post('company_address'),
										"company_block_no" 	=>	$this->post('company_block_no'),
										"company_city"	=>  $this->post('company_city'),
										"company_state" =>$this->post('company_state'),
										"company_country"=>$this->post('company_country'),
										"updated"=>mdate('%Y-%m-%d %H:%i:%s',local_to_gmt())
								);	
							
			
		    $this->Do_publisher->update_companyinfo($account_id,$update_company_infoObj);
		    
		   //SEND EMAIL TO PUBLISHERS
		    
		    /* GET AGENCY ID FROM LIBRARY */
		    $agency_id	=	$this->user_authentication->agency_id;
			
			/* TO GET DEFAULT MANAGER EMAIL ID */
			$result=$this->Do_networks->agency_owner_details($agency_id);
			$admin_name    = $result['name'];			
			$admin_email   = $result['email'];		
			
			/* TO GET ADMIN EMAIL ID FOR bcc */
			$network_admin=$this->Do_networks->get_network_details();
			$bcc		   = $network_admin['email'];
			
			/* PUBLISHER DETAILS */
			$pub_result_array  =  $this->Do_publisher->get_user_information($account_id);
			$pub_result		   =  $pub_result_array[0];
			$user_name  	   =  $pub_result['name'];
			$user_email		   =  $pub_result['email'];
			
			$type   ="COMPANY_INFORMATION";
			$from 	=  $admin_email;
			$to  	=  $user_email;	
			
			/* Gender values */
			$company_country=$this->Do_networks->country($this->post('company_country'));
				
			$mail_content=array(
							"subject" 		=> $this->lang->line('publisher_company_information'),
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,							
							"company_name"  =>	$this->post('company_name'),
							"company_address"	=>	$this->post('company_address'),
							"company_block_no" 	=>	$this->post('company_block_no'),
							"company_city"		=>  $this->post('company_city'),
							"company_state"		=>  $this->post('company_state'),
							"company_country" 	=> $company_country['name']	,
							"account_type"	    => "publisher"			
							);			
			
			/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
			$bcc=($bcc!=$admin_email)?$bcc:'';
			
			$attachement = "";		
					
			/* CALL HELPHER FILE */
			send_mail($type,$from,$to,$mail_content,$attachement,$bcc);			
			
					
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/company_information'),
							'msg'	 => $this->lang->line('company_infn_upd')
			);
		
						
			$this->response($success, 200);
		}

	}
	
	/*
	 * 
	 * name: personal_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the Personal Account Information for Particular Publisher
	 */
	
    public function personal_information_add_post(){
			
		$this->form_validation->set_rules('first_name', 'lang:first_name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'lang:last_name', 'trim|required');
		$this->form_validation->set_rules('gender', 'lang:gender', 'trim|required');
		$this->form_validation->set_rules('date_of_birth', 'lang:dob', 'trim|required');
		$this->form_validation->set_rules('mobile_no', 'lang:mobile_no', 'trim|required');
		$this->form_validation->set_rules('city', 'lang:city', 'trim|required');
		$this->form_validation->set_rules('state', 'lang:state', 'trim|required');
		$this->form_validation->set_rules('country', 'lang:Country', 'trim|required');
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{				
			
			
			$user_auth  = 	$this->user_authentication;
			$account_id	= 	$user_auth->account_id;
			
			$org_date = $this->post('date_of_birth');
			$date = new DateTime($org_date);
			$date_format=$date->format('Y-m-d'); // 2012-09-13
			
			$update_personal_infoObj=array(							
										"first_name"  =>	$this->post('first_name'),
										"last_name"	=>	$this->post('last_name'),
										"gender" 	=>	$this->post('gender'),
										"dob"	=> $date_format ,
										"mobile_number" =>$this->post('mobile_no'),
										"city" =>$this->post('city'),
										"state" =>$this->post('state'),
										"country" =>$this->post('country'),
										"updated"=>mdate('%Y-%m-%d %H:%i:%s',local_to_gmt())
										
								);
									
			$account_setting_type="personal";				
		
		    $this->Do_publisher->update($account_id,$update_personal_infoObj,$account_setting_type);
		    
		    
		     //SEND EMAIL TO PUBLISHERS
		    
			   /* GET AGENCY ID FROM LIBRARY */
				$agency_id	=	$this->user_authentication->agency_id;
				
				/* TO GET DEFAULT MANAGER EMAIL ID */
				$result=$this->Do_networks->agency_owner_details($agency_id);
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];		
				
				/* GET ADMIN EMAIL ID FOR bcc */
				$network_admin=$this->Do_networks->get_network_details();
				$bcc		   = $network_admin['email'];
				
				/* PUBLISHER DETAILS */
				$pub_result_array  =  $this->Do_publisher->get_user_information($account_id);
				$pub_result		   =  $pub_result_array[0];
				$user_name  	   =  $pub_result['name'];
				$user_email		   =  $pub_result['email'];
				
				$type   ="PERSONAL_INFORMATION";
				$from 	=  $admin_email;
				$to  	=  $user_email;	
				/* Gender values */
				$gender=($this->post('gender')=='1')?'Male':'Female';
				$country=$this->Do_networks->country($this->post('country'));
					
				$mail_content=array(
								"subject" 		=> $this->lang->line('publisher_personal_information'),
								"to_name" 		=> $user_name,				
								"from_name"		=> $admin_name,							
								"first_name"    => $this->post('first_name'),
								"last_name" 	=> $this->post('last_name'),
								"gender"    	=> $gender,
								"dob"	        => $date_format ,
								"mobile_number" => $this->post('mobile_no'),
								"city"          => $this->post('city'),
								"state"         => $this->post('state'),
								"country" 		=> $country['name'],
								"account_type"	=> "publisher"		
								);			
				/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
				 $bcc=($bcc!=$admin_email)?$bcc:'';
			    
				 $attachement = "";		
					
				/* CALL HELPHER FILE */
				send_mail($type,$from,$to,$mail_content,$attachement,$bcc);			
					
						
				$success = array(
								'response' => 'ok',
								'redirect'=>site_url('publisher/settings/personal_information'),
								'msg'	 => $this->lang->line('your_personal_updsucc')
				);
			
							
				$this->response($success, 200);
			}

	}
	
	
	 
	/*
	 * 
	 * name: account_settings_add
	 * @param :null
	 * @return : response Array
	 * 
	 * Add/update the Account Setting Information for Particular Publisher
	 */
	
    public function account_settings_add_post(){		
		
		$this->form_validation->set_rules('email', 'lang:email', 'trim|required|callback_acc_email_check');
		$this->form_validation->set_rules('logusername', 'lang:logusername', 'trim|required|callback_acc_username_check');
		$this->form_validation->set_rules('password', 'lang:new_password', 'trim|matches[conf_password]');
		$this->form_validation->set_rules('conf_password', 'lang:repeat_password', 'trim|matches[password]');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			
			$user_auth  = 	$this->user_authentication;
			$account_id	= 	$user_auth->account_id;
			$account_setting_type="account";								
			
			//GET PUBLISHER CURRENT PASSWORD
			$db_old_pass=$this->Do_publisher->get_current_pass($account_id);	
			
			$current_password=trim($this->post('current_password'));
			$encrypted_curr_pwd = password_encryptor($current_password);
			
			if($encrypted_curr_pwd == $db_old_pass || $current_password=='')
			{			
			$update_setting_infoObj=array(
										
										"email"  =>	$this->post('email'),
										"alternate_email"	=>	$this->post('another_email'),
										"currency" 	=>	$this->post('currency_to_view'),
										"password"=>$this->post('password'),
										"login_username"=>	$this->post('logusername'),
										"email_updated"=>mdate('%Y-%m-%d %H:%i:%s',local_to_gmt())
																	
								);						
								
			$this->Do_publisher->update($account_id,$update_setting_infoObj,$account_setting_type);	
			
			
			//SEND EMAIL TO PUBLISHERS -ACCOUNT SETTINGS
		    
		    /* GET AGENCY ID FROM LIBRARY */
		    $agency_id	=	$this->user_authentication->agency_id;
			
			/* TO GET DEFAULT MANAGER EMAIL ID */
			$result=$this->Do_networks->agency_owner_details($agency_id);
			$admin_name    = $result['name'];			
			$admin_email   = $result['email'];		
			
			/* TO GET ADMIN EMAIL ID FOR bcc */
			$network_admin=$this->Do_networks->get_network_details();
			$bcc		   = $network_admin['email'];
			
			/* PUBLISHER DETAILS */
			$pub_result_array  =  $this->Do_publisher->get_user_information($account_id);
			$pub_result		   =  $pub_result_array[0];
			$user_name  	   =  $pub_result['name'];
			$user_email		   =  $this->post('email');
			$login_name		   =  $this->post('logusername');
			//CHECK WHETHER ACCOUNT SETTINGS / PASS UPDATED
			if($this->post('password')!='')
			{
				$type   ="PUB_CHANGE_PASSWORD";
			}
			else
			{
			    $type   ="SETTING_INFORMATION";
			}
			$from 	=  $admin_email;
			$to  	=  $user_email;	
			if($this->post('password')=='')
			{
				$mail_content=array(
								"subject" 		  => $this->lang->line('pub_acc_set_info'),
								"to_name" 		  => $user_name,				
								"from_name"		  => $admin_name,							
								"email"   		  => $this->post('email'),
								"login_name"  	  => $login_name,
								"alternate_email" => $this->post('another_email'),
								"currency"    	  => $this->post('currency_to_view'),							
								"account_type"	  => "publisher"		
								);			
			}
			else
			{
			     $mail_content=array(
							"subject" 		=> $this->lang->line('pub_chng_pwd'),
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,							
							"email"   		=> $this->post('email'),
							"login_name"  	=> $login_name,
							"password"		=> $this->post('password')							
							);			
			
			}					
							
			/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
			 $bcc=($bcc!=$admin_email)?$bcc:'';
			    
			 $attachement = "";		
					
			/* CALL HELPHER FILE */
			send_mail($type,$from,$to,$mail_content,$attachement,$bcc);			
			
			$success = array(
								'response' => 'ok',
								'redirect'=>site_url('publisher/settings/account_settings'),
								'msg'	 => $this->lang->line('account_settings_updated')
				);
			  
			    $this->response($success, 200);
		  }
		  else
		  { 
		       $success = array(
								'response' => 'error',
								'redirect'=>site_url('publisher/settings/account_settings'),
								'msg'	 => $this->lang->line('old_password_mismatch')
				);
			  
			    $this->response($success, 200);
		  }
		}

	}
	
	/*
	 * 
	 * name: upload_profile_image
	 * @param :null
	 * @return:response array
	 * 
	 * Upload the selected image
	 * 
	 */
	
	public function upload_profile_image_post()
	{	
		
		$user_auth	= 	$this->user_authentication;
		$account_id	= 	$user_auth->account_id;
		
		if($_FILES['profile_image'])
		{
			$profile_image=array(
					'file_name'   => $_FILES['profile_image']['name'],
					'source_name' => $_FILES['profile_image']['tmp_name'] 				 				
					);
		}
		
		
		$data=$this->image_lib->update_profile_image($profile_image);
		$session_name = $this->config->item('prod_name').'_profile_image';

						$encrypted_value = $this->encrypt->encode($data['upload_data']['file_name']);


						$this->session->set_userdata($session_name, $encrypted_value);
		$this->Do_publisher->update_image_information($account_id,$data['upload_data']['file_name']);
		 
		 $success = array(
							'response' => 'ok',
							'msg'	 => $this->lang->line('profile_image_updated')
			);
			
			$this->response($success, 200);
		
	}
	
	/*
	 * 
	 * name: delete_profile_image
	 * @param : null
	 * @return :response array
	 * 
	 * Delete the image in user profile
	 */
	
	public function delete_profile_image_post()
	{
		 			
		 $user_auth  	= 	$this->user_authentication;
		 $account_id 	= 	$user_auth->account_id;
		 $profile_name	=	$this->Do_publisher->get_user_information($account_id);
		 $delete_profile_name=$profile_name[0]['dj_profile_image'];	
		 
				
		if($delete_profile_name)
		{
			$is_delete_profile=$this->image_lib->delete_profile_image($delete_profile_name);
			
			/* Delete Profile name in Database */
			$this->Do_publisher->delete_profile_name($account_id);
			

			if($is_delete_profile)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => $this->lang->line('profile_image_deleted')
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_profile_image')
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_profile_image')
							);
			$this->response($error, 200);
		}
	}	
	
	/*
	 * 
	 * name: email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	
	public function email_check()
	{
		$email		=	$this->post('email_id');
		
		$count		=	$this->Do_email_check->dup_email_check($email);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('email_check', $this->lang->line('email_address_exists') );
			return FALSE;	
		}
		else
		{
			return true;
		}
	}
	function username_check()
	{
		$from           =   'Publisher';
		$username		=	strtolower($this->post('logusername'));
		$count 		    = 	$this->Do_email_check->login_username_check($username,$from);
		
		if($count>0)
		{
			$this->form_validation->set_message('username_check', $this->lang->line('username_cont_unique_value'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}	
	
	/*
	 * 
	 * name: edit_email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	function edit_email_check()
	{
		
		$user_auth  = 	$this->user_authentication;
		$account_id	= 	$user_auth->account_id;
		$email		=	$this->post('email_id');
		$count 		= 	$this->Do_email_check->dup_email_check($email,$account_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('edit_email_check', $this->lang->line('email_address_exists') );
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	
		/*
	 * 
	 * name: edit_website_check
	 * @param : null
	 * @return : website Count 
	 * 
	 * checked the email count
	 */
	
	function edit_website_check()
	{
		$website	=	$this->post('website');
		
		$user_auth  = 	$this->user_authentication;
		$account_id	= 	$user_auth->account_id;
		$count 		= 	$this->Do_publisher->dup_website_check($account_id,$website);
		
		if($count>0)
		{
			$this->form_validation->set_message('edit_website_check', $this->lang->line('web_alrdy_exit'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	
	/**
       * 
       * name : site_count_get()
       * 
       * Fetches all site count.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_site_get()
	{					
		$site_list = $this->Do_publisher->fetch_site();
			
		$this->response($site_list);
	}
	
	
	/*
	 * 
	 * name: account_email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	function acc_email_check()
	{
		$user_auth  = 	$this->user_authentication;
		$account_id	= 	$user_auth->account_id;
		$email		=	$this->post('email');
		$count 		= 	$this->Do_email_check->dup_email_check($email,$account_id);	
		
		if($count>0)
		{
			$this->form_validation->set_message('acc_email_check', $this->lang->line('email_address_exists'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	function acc_username_check()
	{
		$user_auth  	= 	$this->user_authentication;
		$account_id		= 	$user_auth->account_id;
		$username		=	strtolower($this->post('logusername'));
		$count 		    = 	$this->Do_email_check->dup_username_check($username,$account_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('username_check', $this->lang->line('username_cont_unique_value'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	/*
	* 
	* name: publisher_earning_post
	* @param : account_id,account_type values
	* @return : true or false.
	* 
	*/
	public function publisher_earning_post()
	{	
		$user_auth  	= 	$this->user_authentication;
		$account_id		= 	$user_auth->account_id;
		$account_type	= 	$user_auth->account_type;
		$res['earning'] 		= 	$this->Do_publisher->publisher_earning($account_id);
		//currency conversion 4 digits in Widgets
		$res['earning']	=	currencyformat($res['earning']['earnings']);
		

		//
		if($res)
		{
			$success 	= 	array('response'	=> 	'ok',
								  'msg'			=> 	$res
								);
			
			$this->response( $success, 200);
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	''
								);
			
			$this->response( $error, 200);
		}			
		
	}
	
		public function publisher_paid_post()
	{	
		$user_auth  	= 	$this->user_authentication;
		$account_id		= 	$user_auth->account_id;
		$account_type	= 	$user_auth->account_type;
		$res['paid'] 			= 	$this->Do_publisher->publisher_paid($account_id);
		//currency conversion 4 digits in Widgets
		$res['paid']	=	currencyformat($res['paid']['paid']);

		if($res)
		{
			$success 	= 	array('response'	=> 	'ok',
								  'msg'			=> 	$res
								);
			
			$this->response( $success, 200);
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	''
								);
			
			$this->response( $error, 200);
		}			
		
	}
	
	
}
