<?php

/**

 * PayPal_Lib Controller Class (Paypal IPN Class)

 *

 * Paypal controller that provides functionality to the creation for PayPal forms, 

 * submissions, success and cancel requests, as well as IPN responses.

 *

 * The class requires the use of the PayPal_Lib library and config files.

 *

 * @package     CodeIgniter

 * @subpackage  Libraries

 * @category    Commerce

 * @author      Ran Aroussi <ran@aroussi.com>

 * @copyright   Copyright (c) 2006, http://aroussi.com/ci/

 *

 */



class Paypal extends REST_Controller {



	public function __construct()

	{

		parent::__construct();

		//installCheck();

		$this->load->library('Paypal_Lib');

		$this->load->model('Do_payments');

		$this->load->model('Do_advertiser');

		$this->load->model('Do_networks');

		/* Libraries */

		$this->load->library('email');

	}



	function index()

	{

		$this->form();

	}

	

	

	function ipn_post()

	{

		
					

		$ipn_data = $this->post('ipn_data');

		$transaction_type = $this->post('transaction_type');

		

		// Payment has been received and IPN is verified.  This is where you

		// update your database to activate or process the order, or setup

		// the database with the user's order details, email an administrator,

		// etc. You can access a slew of information via the ipn_data() array.

 

		// Check the paypal documentation for specifics on what information

		// is available in the IPN POST variables.  Basically, all the POST vars

		// which paypal sends, which we send back for validation, are now stored

		// in the ipn_data() array.

 

		// For this example, we'll just email ourselves ALL the data.

		$to = 'umair@pyxel.co.in';

        log_message('info', 'We are in IPN...');

	    //log_message('info',$this->session->userdata('session_advertiser_name'));

		log_message('info','advertiser name');
		

		
		

		if (!empty($ipn_data)) 

		{         log($ipn_data);

            /*---------------------------------------------------------------------------------------

				GET TRANSACTION TYPE AND DO OPERATION to it Credit - Add Fund ,Debit - Make Payment

			---------------------------------------------------------------------------------------*/

			if($transaction_type ==='credit')

			{

			 

                //Payment status should be completed

              

				/* Store Paypal IPN data into Database */

				$account_id     = $ipn_data['custom'];

				$payer_email    = $ipn_data['payer_email'];

				$receiver_email = $ipn_data['receiver_email'];

				$txn_id         = $ipn_data['txn_id'];

				$ipn_track_id   = $ipn_data['ipn_track_id'];

				$payment_gross  = $ipn_data['payment_gross'];

				$mc_currency    = $ipn_data['mc_currency'];

				$item_name      = $ipn_data['item_name'];

				$item_number    = $ipn_data['item_number'];

				$quantity       = $ipn_data['quantity'];

				$payer_status   = $ipn_data['payer_status'];

				$payment_status = $ipn_data['payment_status'];

				$payment_date   = $ipn_data['payment_date'];

				$country_code   = $ipn_data['address_country_code'];



				//$this->session->set_userdata('paid_amount',$payment_gross);



				$update_order = array(

					'account_id'    =>  $account_id,

					'payment_type'  =>  '2',

					'payer_email'   =>  $payer_email,

					'receiver_email'=>  $receiver_email,

					'txn_id'        =>  $txn_id,

					'ipn_track_id'  =>  $ipn_track_id,

					'payment_gross' =>  $payment_gross,

					'mc_currency'   =>  $mc_currency,

					'item_name'     =>  $item_name,

					'item_number'   =>  $item_number,

					'quantity'      =>  $quantity,

					'payer_status'  =>  $payer_status,

					'payment_status'=>  $payment_status,

					'payment_date'  =>  $payment_date,

					'address_country_code'=> $country_code

				);

			 

			$last_order_id = $this->Do_payments->insert_paypal_order($update_order);
			
		

		

				

			   /*------------------------------------------------------------------------

					GET PREVIOUS FUND VALUE FOR ADDING NEW FUND

				--------------------------------------------------------------------------*/

			

				

				//Check whether the payment status is completed or not 

				

				if($payment_status =='Completed')

				{

					$fund_details = array('account_id'=>$account_id,

										  'paypal_id' =>$receiver_email, 	

										  'payment_type'=>'paypal',

										  'amount'=>$payment_gross,

										  'currency'=>$this->config->item('currency')//$mc_currency

									);


					$payment_id = $this->Do_payments->add_fund($fund_details,$account_id);

					

					//Updates the Admin apporval and also adds the balance for advertiser

					$this->Do_payments->payment_approve($payment_id,$payment_gross,$account_id);

					

				

				}

							

				//$this->mod_payments->insert_paypal_fund($advertiser,$payment_gross);

							

				if(!empty($last_order_id))

				{

				  

				  //SENDS THE EMAIL FOR ADVERTISER AND ADMIN

				  

					$payer_name  = $ipn_data['first_name'];

			  

					$payer_email= $ipn_data['payer_email'] . ' on '.date('m/d/Y') . ' at ' . date('g:i A') . "\n\n";                     

					$data['payment_gross'] = $payment_gross;

					$data['payment_status']= $payment_status;

					$data['payment_date'] = $payment_date;

					$data['txn_id']= $txn_id;

					$data['ipn_track_id'] = $ipn_track_id;

					$data['payer_name']= $payer_name;

					$data['payer_email']= $payer_email;

				  

				  //Sending mail to advertiser for adding fund

					//Get advertiser details

					$advertiser_details=$this->Do_advertiser->get_user_information($account_id); 

					$advertiser_info=$advertiser_details[0];

					//Get admin details

					$result=$this->Do_networks->get_network_details();			

					$admin_name    = $result['firstname']." ".$result['lastname'];			

					$admin_email   = $result['email'];

					$user_email    = $advertiser_info['email'];

					$amount        = $added_amount;

					$user_name     = $advertiser_info['dj_first_name']." ".$advertiser_info['dj_last_name'];

					$type     ="ADV_PAYPAL_ADD_FUND_EMAIL";

					$from 	=  $admin_email;

					$to  	=  $user_email;			

					$mail_content=array(

						"subject" 		=> $this->lang->line('add_paypal_fund_information'),

						"to_name" 		=> $user_name,				

						"from_name"		=> $admin_name,

						"email"  		=> $user_email,

						"added_amount"  => $payment_gross,

						"currency"      => $this->config->item('currency')								

						);

					$attachement='';	

				    send_mail($type,$from,$to,$mail_content,$attachement,$from);

				}

            

           }else if($transaction_type==='debit')

           {

			    //Payment status should be completed

              

				/* Store Paypal IPN data into Database */

				list($account_id,$invoice_id)     = explode(':',$ipn_data['custom']);

				

				$payer_email    = $ipn_data['payer_email'];

				$receiver_email = $ipn_data['receiver_email'];

				$txn_id         = $ipn_data['txn_id'];

				$ipn_track_id   = $ipn_data['ipn_track_id'];

				$payment_gross  = $ipn_data['payment_gross'];

				$mc_currency    = $ipn_data['mc_currency'];

				$item_name      = $ipn_data['item_name'];

				$item_number    = $ipn_data['item_number'];

				$quantity       = $ipn_data['quantity'];

				$payer_status   = $ipn_data['payer_status'];

				$payment_status = $ipn_data['payment_status'];

				$payment_date   = $ipn_data['payment_date'];

				$country_code   = $ipn_data['address_country_code'];



				//$this->session->set_userdata('paid_amount',$payment_gross);



				$update_order = array(

					'account_id'    =>  $account_id,

					'payment_request_id'=>$invoice_id,

					'payment_type'  =>  '2',

					'payer_email'   =>  $payer_email,

					'receiver_email'=>  $receiver_email,

					'txn_id'        =>  $txn_id,

					'ipn_track_id'  =>  $ipn_track_id,

					'payment_gross' =>  $payment_gross,

					'mc_currency'   =>  $mc_currency,

					'item_name'     =>  $item_name,

					'item_number'   =>  $item_number,

					'quantity'      =>  $quantity,

					'payer_status'  =>  $payer_status,

					'payment_status'=>  $payment_status,

					'payment_date'  =>  $payment_date,

					'address_country_code'=> $country_code

				);

			 

			$last_order_id = $this->Do_payments->insert_paypal_order($update_order);

		

			if($payment_status =='Completed')

			{

				$details = array('invoice_id'=>$invoice_id);

				

				$result_data = $this->Do_payments->make_payment($details);

				

				if(!empty($result_data))

				{

					//SEND EMAIL TO PUBLISHER AND ADMIN

					//Sending mail to publisher for approve payment

					//Get advertiser details

					$publisher_info=$this->Do_publisher->get_profile($account_id); 

					//Get admin details

					$result=$this->Do_networks->get_network_details();			

					$admin_name    = $result['firstname']." ".$result['lastname'];			

					$admin_email   = $result['email'];

					$user_email    = $publisher_info['email'];

					$amount        = $added_amount;

					$user_name     = $publisher_info['first_name']." ".$publisher_info['last_name'];

					$type     ="PUB_MAKE_PAY_EMAIL";

					$from 	=  $admin_email;

					$to  	=  $user_email;			

					$mail_content=array(

						"subject" 		=> $this->lang->line('added_payment'),

						"to_name" 		=> $user_name,				

						"from_name"		=> $admin_name,

						"email"  		=> $user_email,

						"added_amount"  => $payment_gross,

						"currency"      => $this->config->item('currency')						

						);

					$attachement='';	

				    send_mail($type,$from,$to,$mail_content,$attachement,$from);

						

				}

			}   

		   } 

		}

	}

	

	function test_get(){
	 $test=array(
	 				'name'=>'test',
					'loc'=>'delhi'
				);
	 //$d=json_encode($test);
	 $this->response($test,200);
					
	}

	

}

?>

