<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Dinesh A
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Payments extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_payments');
		$this->load->model('Do_advertiser');
		$this->load->model('Do_networks');
		$this->load->model('Do_publisher');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }	

	}
	
	
	
	/**
       * 
       * name : add_fund_post()
       * 
       * Adds the advertiser fund to admin
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function add_fund_post(){
		
		$this->form_validation->set_rules('amount','lang:amount', 'required|trim');
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
		   
		   //Get from library file
	        $account_id = $this->user_authentication->account_id;
			//$this->response($this->post()); exit;
			$payment_id = $this->Do_payments->add_fund($this->post(),$account_id);
			//$this->response($payment_id); exit;
		    //Sending mail to advertiser for adding fund
			//Get advertiser details
			$advertiser_details=$this->Do_advertiser->get_user_information($this->post('account_id')); 
			$advertiser_info=$advertiser_details[0];
			$added_amount=$this->post('amount');
			$currency=$this->post('currency');
			
			/* GET AGENCY ID FROM LIBRARY */
		    $agency_id	=	$this->user_authentication->agency_id;
			
			/* GET DEFAULT MANAGER EMAIL ID */
			$result=$this->Do_networks->agency_owner_details($agency_id);
			$admin_name    = $result['name'];			
			$admin_email   = $result['email'];		
			
			/* GET ADMIN EMAIL ID FOR bcc */
			$network_admin=$this->Do_networks->get_network_details();
			$bcc		   = $network_admin['email'];
			
			$user_email    = $advertiser_info['email'];
			$amount        = $added_amount;
			$user_name     = $advertiser_info['dj_first_name']." ".$advertiser_info['dj_last_name'];
			$type     ="ADV_ADD_FUND_EMAIL";
			$from 	=  $admin_email;
			$to  	=  $user_email;			
			$mail_content=array(
				"subject" 		=> $this->lang->line('add_fund_information'),
				"to_name" 		=> $user_name,				
				"from_name"		=> $admin_name,
				"email"  		=> $user_email,
				"added_amount"  => $amount,
				"currency"      => $currency								
				);
				
			/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
			$bcc=($bcc!=$admin_email)?$bcc:'';	
			$attachement='';	
		   send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
			
    	   $success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('amount_funded_success')
					);
					$this->response( $success, 200);
		}
	}
	
		/**
       * 
       * name : make_payment_post()
       * 
       * Makes the payment for publisher and update the invoice table
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function make_payment_post(){
		
		$invoice_id = $this->post('invoice_id');
		
		if($invoice_id)
		{
			$payment_details = $this->Do_payments->make_payment($this->post());
			
			if(!empty($payment_details))
			{
				$invoice_details = $payment_details['invoice'];
				$account_details = $payment_details['account'];
				
				//SEND AN EMAIL DETAILS REGARDING PAYMENT
				
				$success = array(
									'response' => 'ok',
									'amount'=>$invoice_details['amount'],
									'name'=>ucfirst($invoice_details['name']),
									'msg'	 => 'Amount <b>'.$this->config->item("currency").''.$invoice_details['amount'].'</b> has been successfully paid to <b>'.ucfirst($invoice_details['name']).'</b>'
					);
				$this->response( $success, 200);
			}else{
				$error = array('response'=>'error',
								'msg'=>$this->lang->line('problem_with_payment')
						);
			}
		}else{
			
			$error = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('not_valid_invoice')
					);
				$this->response( $error, 200);
		}
	}
	
		/*
     * 
     * name : fetch_publisher_invoice_list_get()
     * 
     * param: none
     * 
     * @return get the details history for all publisher invoices
    */
	public function fetch_publisher_invoice_list_get()
	{
	   //Get from library file
	   $exchangeval = $this->get('exchangeval');
	   $network_id			=	$this->user_authentication->account_id;
	   if($this->user_authentication->account_type=='TRAFFICKER'){
	   $account_id = $this->user_authentication->account_id;
	  }
	   if($account_id!='')
	   {
	   //to fetch and list all publisher invoice details in publisher panel
	    $pub_invoice_list=$this->Do_payments->fetch_publisher_invoice_list($account_id,'',$exchangeval);
	    $this->response($pub_invoice_list); 
	   }
	   else
	   {
	     //to fetch and list all publisher invoice details in admin panel
		$pub_invoice_list=$this->Do_payments->fetch_publisher_invoice_list(FALSE,$network_id,$exchangeval);
	    $this->response($pub_invoice_list); 
	   }
	}
	
	/*
     * 
     * name : publisher_invoice_item_get()
     * 
     * param: none
     * 
     * @return get the details of publisher invoice item
    */
	public function publisher_invoice_item_get()
    {
	   $invoice_id=$this->get('id'); 
	   $pub_invoice_item=$this->Do_payments->fetch_publisher_invoice_item($invoice_id);
	   $this->response($pub_invoice_item); 
	}
	
	/*
     * 
     * name : fetch_advertiser_payment_get()
     * 
     * param: none
     * 
     * @return get the details of advertiser detailed payments
    */
	 
	public function fetch_advertiser_payment_get()
	{
	   //Get from library file
	   $account_id = $this->user_authentication->account_id;
	   $exchangeval = $this->get('exchangeval');
	   //~ $this->response($exchangeval,200); 
	   $adv_pay_item=$this->Do_payments->fetch_advertiser_payment1($account_id,$exchangeval);
	   $this->response($adv_pay_item); 
	}
	
	/*
     * 
     * name : fetch_advertiser_date_wise_payment_post()
     * 
     * param: month,year,accounid
     * 
     * @return get the details of advertiser detailed payments
    */
	 public function fetch_advertiser_date_wise_payment_post()
	{
	   //Get from library file
	   $account_id = $this->user_authentication->account_id;
	   $month=$this->post('month');
	   $year=$this->post('year');
	   $exchangeval = $this->post('exchangeval');
	   $adv_pay_item=$this->Do_payments->fetch_advertiser_date_wise_payment($month,$year,$account_id,$exchangeval);
	   $this->response($adv_pay_item); 
	   
	}
	
	 /*
     * 
     * name : fetch_publisher_payment_history_get()
     * 
     * param: accounid
     * 
     * @return get the details of publisher detailed payments
    */
	 public function fetch_publisher_payment_history_get()
	{ 
	    //Get from library file
	   $account_id = $this->user_authentication->account_id;
	   $exchangeval = $this->get('exchangeval');
	   $pub_pay_item=$this->Do_payments->fetch_publisher_invoice_payment_list($account_id,$exchangeval);
	   $this->response($pub_pay_item); 
	}
	
   /*
     * 
     * name : fetch_pub_date_wise_payment()
     * 
     * param: month,year,accounid
     * 
     * @return get the details of publisher detailed payments history
    */
	public function fetch_pub_date_wise_payment_post()
	{
	   //Get from library file
	   $account_id = $this->user_authentication->account_id;
	   $month=$this->post('month');
	   $year=$this->post('year');
	   $exchangeval=$this->post('exchangeval');
	   $pub_pay_history=$this->Do_payments->fetch_pub_date_wise_payment($month,$year,$account_id,$exchangeval);
	   $this->response($pub_pay_history); 
	}
	
	 /*
     * ADMIN PANEL
     * name : list_publisher_payment_details()
     * 
     * param: month,year,accounid
     * 
     * @return get the details of advertiser detailed payments history
    */
	public function list_advertiser_payment_details_get()
	{
		$exchangeval = $this->get('exchangeval');
	   //Get from library file
	   $agencyid = $this->user_authentication->agency_id;
	   $advertiser_history=$this->Do_payments->advertiser_payment_history($agencyid,$exchangeval);
	   $this->response($advertiser_history);
	}
    
     /*
     * ADMIN PANEL
     * name : list_publisher_payment_details()
     * 
     * param: month,year,accounid
     * 
     * @return get the details of advertiser detailed payments history
    */
	public function list_advertiser_payment_date_wise_post()
	{
	   $month=$this->post('month');
	   $year=$this->post('year');
	   $account_id=$this->post('account_id');
	   $adv_datewise_history=$this->Do_payments->fetch_advertiser_date_wise_payment_history($month,$year,$account_id);
	   $this->response($adv_datewise_history); 
	}
	
	 /*
     * ADMIN PANEL
     * name : list_publisher_payment_history_get()
     * 
     * param:none
     * 
     * @return get the details of advertiser detailed payments history
    */
	public function list_publisher_payment_history_get()
	{
		$exchangeval = $this->get('exchangeval');
	   //Get from library file
	   $agencyid = $this->user_authentication->agency_id;
	   $publisher_history=$this->Do_payments->publisher_payment_history($agencyid,$exchangeval);
	   $this->response($publisher_history);
	}
	
	 /*
     * ADMIN PANEL
     * name : list_publisher_payment_date_wise()
     * 
     * param:month,year,accountid
     * 
     * @return get the details of publisher detailed payments history
    */
	public function list_publisher_payment_date_wise_post()
	{
	   $month=$this->post('month');
	   $year=$this->post('year');
	   $account_id=$this->post('account_id');
	   $pub_datewise_history=$this->Do_payments->fetch_publisher_date_wise_payment_history($month,$year,$account_id);
	   $this->response($pub_datewise_history); 
	}
	
	/*
     * ADMIN PANEL
     * name : fetch_admin_payment_history_get()
     * 
     * param:none
     * 
     * @return: credit & debit payment details
    */
	public function fetch_admin_payment_history_get()
	{
	    //Get from library file
	   $agencyid = $this->user_authentication->agency_id;
   	   $exchangeval = $this->get('exchangeval');

	   $admin_pay_history=$this->Do_payments->fetch_admin_payment_history($agencyid,$exchangeval);
	   $this->response($admin_pay_history); 
	}
	
	/*
     * ADMIN PANEL
     * name : reject_publisher_invoice_amount_get()
     * 
     * param:invoice_id
     * 
     * @return: send mail to the pub and return reject success msg
    */
	public function reject_publisher_invoice_amount_get()
	{
	    $invoice_id=$this->get('invoice_id');
	    $rejected_acc_id=$this->Do_payments->reject_invoice_payment($invoice_id);
		if($rejected_acc_id)
		    $publisher_details=$this->Do_publisher->get_profile($rejected_acc_id);
		    //Get admin details
			$result=$this->Do_networks->get_network_details();			
			$admin_name    = $result['firstname']." ".$result['lastname'];			
			$admin_email   = $result['email'];
			$user_email    = $publisher_details['email'];
			$user_name     = $publisher_details['first_name']." ".$publisher_details['last_name'];
			$type     	   = "PUB_PAY_REJECTED";
			$from 		   = $admin_email;
			$to  		   =  $user_email;			
			$mail_content=array(
				"subject" 		=> $this->lang->line('your_invoice_payment'),
				"to_name" 		=> $user_name,				
				"from_name"		=> $admin_name,
				"email"  		=> $user_email,
			 );
		   $attachement='';	
		   send_mail($type,$from,$to,$mail_content,$attachement,$from); 
		   $success = array(
							'response' => 'ok',
							'msg'	 => $this->lang->line('invoice_payment_rejected') );
		   $this->response($success, 200);

	}
	
	/*
     * ADVERTISER PANEL
     * name : fetch_deposit_amount_list_get()
     * 
     * param:none
     * 
     * @return: credit advertiser payment details
    */
    public function fetch_deposit_amount_list_get()
    {
		//Get from library file
		$account_id = $this->user_authentication->account_id;
		$exchangeval = $this->get('exchangeval');
		$payment_list =$this->Do_payments->fetch_deposit_list($account_id,$exchangeval); 
		$this->response($payment_list,200);
	}
	
	/*
     * ADMIN PANEL
     * name : fetch_advertiser_deposit_amount_list_get()
     * 
     * param:none
     * 
     * @return: credit advertiser payment details
    */
	public function fetch_advertiser_deposit_amount_list_get()
	{  
		//Get from library file
		$agency_id = $this->user_authentication->agency_id;
		$exchangeval = $this->get('exchangeval');

		$payment_list =$this->Do_payments->fetch_adv_deposit_list($agency_id,$exchangeval); 
		$this->response($payment_list,200);
	}
        
    /*
     * ADMIN PANEL
     * name : advertiser_billing_details_get()
     * 
     * param:none
     * 
     * @return: credit advertiser payment details
    */
    public function advertiser_billing_details_get()
    {
		$b_id=$this->get('billing_id'); 
		$bill_details = $this->Do_payments->fetch_billing_details($b_id);
		$this->response($bill_details,200);	
	}
	
	/*
     * ADMIN PANEL
     * name : admin_revenue_list_get()
     * 
     * param:none
     * 
     * @return: return month wise revenue details
    */
	public function admin_revenue_list_get()
	{
	   //Get from library file
	    $agency_id = $this->user_authentication->agency_id;
	    $exchangeval = $this->get('exchangeval');
		$revenue_details = $this->Do_payments->fetch_admin_revenue_details($agency_id,$exchangeval);
		
		$this->response($revenue_details,200);	
	}
	
	/*
     * ADMIN PANEL
     * name : admin_revenue_list_date_wise_get()
     * 
     * param:none
     * 
     * @return: return date wise revenue details
    */
	public function admin_revenue_list_date_wise_get()    
	{
	    $month=$this->get('month'); 
		$year=$this->get('year'); 
	    $agency_id=$this->get('agency_id'); 
		$revenue_details = $this->Do_payments->fetch_admin_revenue_details_date_wise($month,$year,$agency_id);
		$this->response($revenue_details,200);	
	}
	
	/*
     * 
     * name : fetch_affiliate_invoice_list_get()
     * 
     * param: none
     * 
     * @return get the details history for all affiliate invoices
    */
	public function fetch_affiliate_invoice_list_get()
	{
		 $agency_id = $this->user_authentication->agency_id;
	     //to fetch and list all publisher invoice details in admin panel
		$aff_invoice_list=$this->Do_payments->fetch_affiliate_invoice_list($agency_id);
		
	    $this->response($aff_invoice_list); 
	  
	}
	//14-08-2015
	public function fetch_paypal_admin_get()
	{
		$agency_id			=	$this->user_authentication->agency_id; 
	     //to fetch and list all publisher invoice details in admin panel
		$admin_paypal=$this->Do_payments->get_admin_payment_info($agency_id);
		
	    $this->response($admin_paypal,200); 
	  
	}
	public function third_party_get()
	{

		$thirdparty	=	$this->Do_payments->get_third_party();
		$this->response($thirdparty,200); 
	}
}
