<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 *
 * Onetime wizard will be managed here 
 *
 * @package		ADX
 * @subpackage	one time wizard
 * @category	Controller
 * @author		renuka
 * @link		http://www.djaxadexchange.com
*/


class Onetime_wizard extends REST_Controller
{	
		
	function __construct()
	{
		parent::__construct();	
		$this->load->model('Do_onetime_wizard');
		$this->load->model('Do_advertiser');
		$this->load->model('Do_publisher');
		
	
	}
 	
		
	 /*
	 * 
	 * name: personal_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add the Personal Account Information for Particular Publisher/Advertiser
	 */
	
    public function personal_information_add_post(){
		
			
		$this->form_validation->set_rules('first_name', 'lang:first_name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'lang:last_name', 'trim|required');
		$this->form_validation->set_rules('currency_to_view', 'lang:currency', 'trim|required');
		//$this->form_validation->set_rules('profile_image', 'Profile Image', 'trim|required');
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			$account_id=$this->post('account_id');	
			$acc_type=$this->post('acc_type');
							
			$update_personal_infoObj=array(							
										"first_name"  =>	$this->post('first_name'),
										"last_name"	=>	$this->post('last_name'),
										"currency" 	=>	$this->post('currency_to_view'),
										"updated" => date('Y-m-d H:i:s')
										
								);										
			
			$this->Do_onetime_wizard->update($account_id,$update_personal_infoObj,$acc_type);						
		
			$success = array(
							'response' => 'ok',							
							'msg'	 => $this->lang->line('personal_information_updated')
						  );				
						
			$this->response($success, 200);
		}

	}	 
		
	/*
	 * 
	 * name: upload_profile_image
	 * @param :null
	 * @return:response array
	 * 
	 * Upload the selected image
	 * 
	 */
	
	public function upload_profile_image_post()
	{
		if($_FILES['profile_image'])
		{
			$profile_image=array(
					'file_name'   => $_FILES['profile_image']['name'],
					'source_name' => $_FILES['profile_image']['tmp_name'] 				 				
					);
		}
	
		$data=$this->image_lib->update_profile_image($profile_image);
		
		$account_id=$this->post('account_id');	
		
		$acctype = $this->post('acc_type');
		
		$this->Do_onetime_wizard->update_image_information($account_id,$data['upload_data']['file_name'],$acctype);
		 
		 $success = array(
							'response' => 'ok',
							'msg'	 => $this->lang->line('profile_image_updated')
			);
			
			$this->response($success, 200);		
	}
	
	/*
	 * 
	 * name: delete_profile_image
	 * @param : null
	 * @return :response array
	 * 
	 * Delete the image in user profile
	 */
	
	public function delete_profile_image_post()
	{
		 $account_id=$this->post('account_id');	
		 $acc_type=$this->post('acc_type');		
		 $profile_name=$this->Do_onetime_wizard->get_user_information($account_id,$acc_type);
	 
		 $delete_profile_name=$profile_name[0]['dj_profile_image'];		 
				
		if($delete_profile_name)
		{
			$is_delete_profile=$this->image_lib->delete_profile_image($delete_profile_name);
			
			/* Delete Profile name in Database */	
			
			if($acc_type=="PUBLISHER")
			{			
			$this->Do_publisher->delete_profile_name($account_id);
			}
			if($acc_type=="ADVERTISER")
			{				
			$this->Do_advertiser->delete_profile_name($account_id);	
			}
		
			if($is_delete_profile)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => $this->lang->line('profile_image_deleted')
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_profile_image')
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_profile_image')
							);
			$this->response($error, 200);
		}
	}
	
	
	/*
	 * 
	 * name: company_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the company Information for Particular Publisher/Advertiser
	 */
	
    public function company_information_add_post(){		
				
		$this->form_validation->set_rules('company_name', 'lang:company_name', 'trim|required');
		$this->form_validation->set_rules('company_address', 'lang:company_address', 'trim|required');
		$this->form_validation->set_rules('company_block_no', 'lang:company_block_no', 'trim|required');
		$this->form_validation->set_rules('company_address', 'lang:company_address', 'trim|required');
		$this->form_validation->set_rules('company_state', 'lang:company_state', 'trim|required');
		$this->form_validation->set_rules('company_country', 'lang:company_country', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			$account_id=$this->post('account_id');	
			$acc_type=$this->post('acc_type');	
			
			$update_company_infoObj=array(							
										"company_name"  =>	$this->post('company_name'),
										"company_address"	=>	$this->post('company_address'),
										"company_block_no" 	=>	$this->post('company_block_no'),
										"company_city"	=>  $this->post('company_city'),
										"company_state" =>$this->post('company_state'),
										"company_country"=>$this->post('company_country'),
										"updated"=>date("Y-m-d H:i:s")
								);	
							
						
			  $this->Do_onetime_wizard->update_companyinfo($account_id,$update_company_infoObj,$acc_type);			
			  
			 if($acc_type=="ADVERTISER")
			 {	
				 
				$up=array("dj_onetime_wizard"=>'1');
		        $where_acc=array("account_id"=>$account_id);
		        $this->db->update(TAB_CLIENTS,$up,$where_acc); 
				 	  
			    $success = array(
								'response' => 'ok',
								'redirect'=>site_url('advertiser/dashboard'),
								'msg'	 => $this->lang->line('company_added_success') );	
			    $this->response($success, 200);							   
			 }	
			 else
			 {
				  $success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('company_added_success')
								);
			
				  $this->response($success, 200);	
			 }
			 		
		
		}

	}

		 /*
	 * 
	 * name: payment_info_add_post
	 * @param : null
	 * @return :Last insert id
	 * 
	 */
	
   /* public function payment_information_add_post(){		
		
		$this->form_validation->set_rules('billing_wire_bank_name', 'Bank Name', 'trim|required');
		$this->form_validation->set_rules('billing_wire_acc_no', 'Account Number', 'trim|required');
		$this->form_validation->set_rules('billing_wire_bank_address', 'Bank Address', 'trim|required');
		$this->form_validation->set_rules('billing_wire_swift_bic', 'Swift/Bic', 'trim|required');
		
		$this->form_validation->set_rules('paypal_id', 'Paypal Id', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$account_id=$this->post('account_id');	
			$acc_type=$this->post('acc_type');	
			
			$payment_info=array(							
										"account_id"  => $account_id,
										"bank_name"	=>	$this->post('billing_wire_bank_name'),
										"bank_account_no" 	=>	$this->post('billing_wire_acc_no'),
										"bank_address"	=>  $this->post('billing_wire_bank_address'),
										"swift_bic" =>$this->post('billing_wire_swift_bic'),
										"created_date"=> date('Y-m-d H:i:s'),
										"paypal_id"=> $this->post('paypal_id')
								);	
			
			
		 $this->db->insert(TAB_PUB_PAYD,$payment_info);		
	     
	     if($acc_type=="PUBLISHER")
	     {			 
		 $up=array("dj_onetime_wizard"=>'1');
		 $where_acc=array("account_id"=>$account_id);
		 $this->db->update(TAB_AFFILIATE,$up,$where_acc);
			 
		  $success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/dashboard'),
							'msg'	 => 'Information added successfully!..' );
		   $this->response($success, 200);
		   
		 }
		
		 
        }
	}*/	
		 /*
	 * 
	 * name: payment_info_add_post
	 * @param : null
	 * @return :Last insert id
	 * 
	 */
	
    public function payment_information_add_post(){		
		
		$this->form_validation->set_rules('billing_wire_bank_name', 'lang:bank_name', 'trim|required');
		$this->form_validation->set_rules('billing_wire_acc_no', 'lang:account_number', 'trim|required');
		$this->form_validation->set_rules('billing_wire_bank_address', 'lang:bank_address', 'trim|required');
		$this->form_validation->set_rules('billing_wire_swift_bic', 'Swift/Bic', 'trim|required');
		
		//$this->form_validation->set_rules('paypal_id', 'Paypal Id', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$account_id=$this->post('account_id');	
			$acc_type=$this->post('acc_type');	
			
			$status_check=$this->Do_onetime_wizard->add_payment_info($this->post());

			
		
	     if($status_check=="updated" ||$status_check=="inserted" )
	     {			 
		
		  $success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/dashboard'),
							'msg'	 => $this->lang->line('info_added_success') );
		   $this->response($success, 200);
		   
		 }
		
		 
        }
	}	
	

	public function user_info_get()
	{
	   $account_id=$this->get('account_id');
	   $account_type=$this->get('type');
	   $result=$this->Do_onetime_wizard->get_onetime_info($account_id,$account_type);
	   if($result)
	   {
	  	 $this->response($result, 200);
	   }
	}
	
	 public function add_save_exit_post(){
		
	//$this->response( $_POST, 200);
		$this->form_validation->set_rules('first_name', 'lang:first_name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'lang:last_name', 'trim|required');
		$this->form_validation->set_rules('currency_to_view', 'lang:currency', 'trim|required');
		//$this->form_validation->set_rules('profile_image', 'Profile Image', 'trim|required');
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			$account_id=$this->post('account_id');	
			$acc_type=$this->post('acc_type');
							
			$update_personal_infoObj=array(							
										"first_name"  =>	$this->post('first_name'),
										"last_name"	=>	$this->post('last_name'),
										"currency" 	=>	$this->post('currency_to_view'),
										"updated" => date('Y-m-d H:i:s')
										
								);										
			
			$status=$this->Do_onetime_wizard->update($account_id,$update_personal_infoObj,$acc_type);
				//$this->response($status, 200);					
		if($status)
		
		{
			$success = array(
							'response' => 'ok',	
							'redirect'=>site_url('publisher/dashboard'),						
							'msg'	 => $this->lang->line('personal_information_updated')
						  );				
						
			$this->response($success, 200);
		}
		
	
			 		
		}

	}
	
	 /*
	 * 
	 * name: personal_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add the Personal Account Information for Particular Publisher/Advertiser
	 */
	
    public function add_save_exit_adv_post(){
		
		//$this->response($_POST, 200);	
		$this->form_validation->set_rules('first_name', 'lang:first_name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'lang:last_name', 'trim|required');
		$this->form_validation->set_rules('currency_to_view', 'lang:currency', 'trim|required');
		//$this->form_validation->set_rules('profile_image', 'Profile Image', 'trim|required');
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			$account_id=$this->post('account_id');	
			$acc_type=$this->post('acc_type');
							
			$update_personal_infoObj=array(							
										"first_name"  =>	$this->post('first_name'),
										"last_name"	=>	$this->post('last_name'),
										"currency" 	=>	$this->post('currency_to_view'),
										"updated" => date('Y-m-d H:i:s')
										
								);										
			
			$this->Do_onetime_wizard->update($account_id,$update_personal_infoObj,$acc_type);						
		
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('advertiser/dashboard'),						
							'msg'	 => $this->lang->line('personal_information_updated')
						  );				
						
			$this->response($success, 200);
		}

	}	
	public function wire_paypal_info_get()
	{
		
	   $account_id=$this->get('account_id');
	   $mode=$this->get('mode');
	  // $this->response($account_id, 200);
	   $result=$this->Do_onetime_wizard->get_payment_info($account_id,$mode);
	   if($result)
	   {
	  	 $this->response($result, 200);
	   }
	}
	
}

