<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Utilities (Generalize Things)
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Notification extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_notification');
		$this->load->model('Do_approval');
		$this->load->model('Do_creative');
		$this->load->model('Do_payments');
		$this->load->model('Do_site');
		$this->load->library('user_authentication');
        $key=$this->input->get_post('api_key');
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
	}
	/*
	 * 
	 * name: unknown
	 * @param
	 * @return
	 */
	 public function approval_post()
	 {	 
		
	    #$account_id     	= $this->post('account_id');
	    $account_id     	= $this->user_authentication->account_id;
		$account_type    	= $this->post('account_type');
		$manager_role_id    = FALSE;
		$agency_id			= FALSE;
		
		switch(strtoupper($account_type)){
			case 'ADMIN';
				$agency_id	= $this->Do_notification->getAdminAgencyId($account_id);
				$manager_role_id    	= $this->post('manager_role_id');
				break;
			case 'MANAGER';
				$agency_id	= $this->Do_notification->getManagerAgencyId($account_id);
				$manager_role_id    	= $this->post('manager_role_id');
				break;
			case 'ADVERTISER';
				$agency_id	= $this->Do_notification->getAdvertiserAgencyId($account_id);
				break;
			case 'TRAFFICKER';
				$agency_id	= $this->Do_notification->getPublisherAgencyId($account_id);
				break;	
			
		}
		
		if($agency_id != FALSE){
			
			$notification_obj	=	$this->Do_notification->approval_notification($account_id,$account_type,$agency_id,$manager_role_id);
			$this->response($notification_obj, 200); // 200 being the HTTP response code
		}
	 }	

}

