<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 *
 * Admin Account settings will be managed here 
 *
 * @package		ADX
 * @subpackage	network
 * @category	Controller
 * @author		renuka
 * @link		http://www.djaxadexchange.com
*/


class Network extends REST_Controller
{	
		
	function __construct()
	{
		parent::__construct();	
		$this->load->model('Do_publisher');
		$this->load->model('Do_networks');	
		$this->load->model('Do_notification');
		$this->load->model('Do_email_check');
		$this->load->helper('email');
		$this->load->library('user_authentication');
		$key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
 	
		
	 /*
	 * 
	 * name: company_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the company Information for Admin
	 */
	
    public function company_information_add_post(){		
		
		$this->form_validation->set_rules('company_name', 'lang:company_name', 'trim|required');
		$this->form_validation->set_rules('company_address', 'lang:company_address', 'trim|required');
		$this->form_validation->set_rules('company_block_no', 'lang:company_block_no', 'trim|required');
		$this->form_validation->set_rules('company_address', 'lang:company_address', 'trim|required');
		$this->form_validation->set_rules('company_state', 'lang:company_state', 'trim|required');
		$this->form_validation->set_rules('company_country', 'lang:company_country', 'trim|required');
		
		if($this->form_validation->run() === FALSE || $this->post('company_country') == '0')
		{
			$error_msg = $this->form_validation->error_array();			

			if($this->post('company_country') == '0')
			{
				$error = array(
								'response' => 'error',
								'msg' =>  $this->lang->line('chs_cont_info')								
							);
				
			}
			else{
				$error = array(
								'response' => 'error',
								'msg' =>  $error_msg								
							);
										
			}


			 $this->response( $error, 200);
		}
		else{	
			
			 //Get from library file
		     $user_id	= 	$this->user_authentication->user_id;	
		     // added by karthika on dec-28
		     $account_id =  $this->user_authentication->account_id;	
			 //$this->response("acc=>".$account_id." "."userid=>".$user_id , 200);
			 // end
			 $update_company_infoObj=array(							
										"company_name"  	=>	$this->post('company_name'),
										"company_address"	=>	$this->post('company_address'),
										"company_block_no" 	=>	$this->post('company_block_no'),
										"company_city"		=>  $this->post('company_city'),
										"company_state" 	=>	$this->post('company_state'),
										"company_country"	=>	$this->post('company_country'),
										"updated"			=>	mdate('%Y-%m-%d %H:%i:%s',local_to_gmt())
								);								
						
			
		    $this->Do_networks->update_companyinfo($user_id,$account_id,$update_company_infoObj);
					
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/company_information'),
							'msg'	 => $this->lang->line('company_infn_upd')
			);
		
						
			$this->response($success, 200);
		}

	}
	
	 /*
	 * 
	 * name: personal_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the Personal Account Information for Admin
	 * 	 */
	
    public function personal_information_add_post(){
		
		$this->form_validation->set_rules('first_name', 'lang:first_name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'lang:last_name', 'trim|required');
		$this->form_validation->set_rules('gender', 'lang:gender', 'trim|required');
		$this->form_validation->set_rules('date_of_birth', 'lang:dob', 'trim|required');
		$this->form_validation->set_rules('mobile_no', 'lang:mobile_no', 'trim|required');
		$this->form_validation->set_rules('city', 'lang:city', 'trim|required');
		$this->form_validation->set_rules('state', 'lang:state', 'trim|required');
		$this->form_validation->set_rules('country', 'lang:Country', 'trim|required');
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			 //Get from library file
		     $account_id	= 	$this->user_authentication->account_id;		

			$org_date = $this->post('date_of_birth');
			$date = new DateTime($org_date);
			$date_format=$date->format('Y-m-d'); // 2012-09-13
			
			$update_personal_infoObj=array(							
										"first_name"  	=>	$this->post('first_name'),
										"last_name"		=>	$this->post('last_name'),
										"gender" 		=>	$this->post('gender'),
										"dob"			=>  $date_format ,
										"mobile_number" =>	$this->post('mobile_no'),
										"city" 			=>	$this->post('city'),
										"state" 		=>	$this->post('state'),
										"country" 		=>	$this->post('country'),
										"updated"		=>	mdate('%Y-%m-%d %H:%i:%s',local_to_gmt())
										
								);								
			$account_setting_type="personal";												
		
		    $this->Do_networks->update($account_id,$update_personal_infoObj,$account_setting_type);
			
					
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/personal_information'),
							'msg'	 => $this->lang->line('your_personal_updsucc')
			);
		
						
			$this->response($success, 200);
		}

	}
	
	/*
	 * 
	 * name: user_information
	 * @param :null
	 * @return : response Array
	 * 
	 * get the user information for particular Advertiser
	 */	
		 
	public function user_information_get()
	{	
         //Get from library file
		 $account_id	= 	$this->user_authentication->account_id;	
		 $agency_id	= 	$this->user_authentication->agency_id;	
				
		 $user_info=$this->Do_networks->get_user_information($account_id,$agency_id);	  
		  
		 if($user_info)
		 {
			 $this->response($user_info, 200); // 200 being the HTTP response code
		 }
		
	}
	
	/*
	 * 
	 * name: user_role_info
	 * @param :null
	 * @return : response Array
	 * 
	 * get the user information for particular Advertiser
	 */	
		 
	public function user_role_info_get()
	{	
        
		//Get from library file
		$user_id=$this->user_authentication->manager_user_id;	
		$account_id	= 	$this->user_authentication->account_id;			
		$user_info=$this->Do_networks->get_user_role_info($user_id,$account_id);	  
		 
		 if($user_info)
		 {
			 $this->response($user_info, 200); // 200 being the HTTP response code
		 }
	 
		
	}
		 
	/*
	 * 
	 * name: account_settings_add
	 * @param :null
	 * @return : response Array
	 * 
	 * Add/update the Account Setting Information for Admin
	 */
	
    public function account_settings_add_post(){		
		
		$this->form_validation->set_rules('email', 'lang:email', 'trim|required|callback_email_check');
		$this->form_validation->set_rules('password', 'lang:new_password', 'trim|matches[conf_password]');
		$this->form_validation->set_rules('conf_password', 'lang:repeat_password', 'trim|matches[password]');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			//Get from library file
		    $account_id	= 	$this->user_authentication->account_id;	
		    $default_user_id = $this->user_authentication->user_id;	
		    				
			$account_setting_type="account";
			
			//Get old password from DB 
			$db_old_pass=$this->Do_publisher->get_current_pass($account_id);
						
			//Get new password from user and encrypt it
			//$current_password=trim($this->post('current_password'));
			$current_password = trim($this->post('current_password'));
			$new_password = trim($this->post('password'));
			
			if(md5($current_password) == $db_old_pass || $current_password=='')
			{   
			     $update_setting_infoObj=array(
										
										"email"  			=>	$this->post('email'),
										"alternate_email"	=>	$this->post('another_email'),
										"currency" 			=>	$this->post('currency_to_view'),
										"password"			=>	$new_password,
										"email_updated"		=>	mdate('%Y-%m-%d %H:%i:%s',local_to_gmt())
							    	);	
							    
		    $this->Do_networks->update($account_id,$update_setting_infoObj,$account_setting_type,$default_user_id);		
		    
		   			
			//UPDATE EMAIL ID INTO THEIR OX_CLIENTS/OX_USERS FOR DEFAULT ADVERTISER
			$this->Do_networks->update_email_def_advertiser($this->post('email'),$default_user_id);
			 
			//SEND MAIL TO ADMIN
			$result=$this->Do_networks->get_network_details();			
			$admin_name    = $result['firstname']." ".$result['lastname'];			
			$admin_email   = $result['email'];
			$user_email    = $this->post('email');
			$user_name     = $admin_name;
			$type     	   = ($this->post('password')!='')?"ADMIN_CHANGE_PASSWORD":"ADMIN_SETTING_INFORMATION";
			$from 		   = $admin_email;
			$to  		   = $user_email;
			if($this->post('password')!='')
			{			
				//If Admin change his password then it will works
				$mail_content=array(
						"subject" 		=> $this->lang->line('adm_chng_pwd'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,							
						"email"   		=> $this->post('email'),
						"password"		=> $this->post('password'),
						"account_type"	=> "admin"							
					);		
			}
			else
			{
			    //Send only email,alternate email to their email
				$mail_content=array(
								"subject" 		=> $this->lang->line('adm_actn_set_info'),
								"to_name" 		=> $user_name,				
								"from_name"		=> $admin_name,							
								"email"   		=> $this->post('email'),
								"alternate_email" => $this->post('another_email'),
								"currency"		=> $this->post('currency_to_view'),
								"account_type"	=> "admin"		
								);
			
			}
		   $attachement='';	
		 send_mail($type,$from,$to,$mail_content,$attachement,$from); 
		   
			 $success = array(
								'response' => 'ok',
								'redirect'=>site_url('admin/settings/account_settings'),
								'msg'	 => $this->lang->line('account_settings_updated')
				);
			  
			    $this->response($success, 200); 
			  }
			   else
			   {
			       $error = array(
							'response' => 'error',
							'redirect'=>site_url('admin/settings/account_settings'),
							'msg'	 => $this->lang->line('enter_current_password')
							);
			       $this->response($error, 200);
			   
			   }
		
		}

	}
	
	/*
	 * 
	 * name: upload_profile_image
	 * @param : null
	 * @return:response array
	 * 
	 * Upload the selected image
	 * 
	 */
	
	public function upload_profile_image_post()
	{
		 //Get from library file
		 $account_id	= 	$this->user_authentication->account_id;	
		if($_FILES['profile_image'])
		{
			$profile_image=array(
					'file_name'   => $_FILES['profile_image']['name'],
					'source_name' => $_FILES['profile_image']['tmp_name'] 				 				
					);
		}
	
		$data=$this->image_lib->update_profile_image($profile_image);	
		
		
		$this->Do_networks->update_image_information($account_id,$data['upload_data']['file_name']);
		//~ $_SESSION['profile_image'] = $data['upload_data']['file_name'];
		unset_logo_admin('profile_image',$data['upload_data']['file_name']);
		 
		 $success = array(
							'response' => 'ok',
							'msg'	 => $this->lang->line('profile_image_updated')
			);
			
			$this->response($success, 200);
		
	}
	
	/*
	 * 
	 * name: delete_profile_image
	 * @param : null
	 * @return :response array
	 * 
	 * Delete the image in user profile
	 */
	
	public function delete_profile_image_post()
	{
		 //Get from library file
		 $account_id	= 	$this->user_authentication->account_id;	
		 $profile_name=$this->Do_networks->get_user_information($account_id);
		 $delete_profile_name=$profile_name[0]['profile_image'];
		 
				
		if($delete_profile_name)
		{
			$is_delete_profile=$this->image_lib->delete_profile_image($delete_profile_name);

			/* Delete Profile name in Database */
			$this->Do_networks->delete_profile_name($account_id);
			
			if($is_delete_profile)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => $this->lang->line('thumb_image_deleted')
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_profile_image')
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_profile_image')
							);
			$this->response($error, 200);
		}
	}

	/*
	 * 
	 * name: email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	public function email_check()
	{
		 //Get from library file
		$account_id	= 	$this->user_authentication->account_id;	
		$account_type   =   $this->user_authentication->account_type;	
		$email=$this->input->post('email');
						
        $count=$this->Do_email_check->dup_email_check($email,$account_id,$account_type);
		if($count>0)
		{
			$this->form_validation->set_message('email_check', $this->lang->line('email_address_exists'));
			return FALSE;	
		}
		else
		{
			return true;
		}
	}
	
	
		/*
	 * 
	 * name: email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	public function user_role_email_check()
	{
		$user_id=$this->user_authentication->manager_user_id;
		$email=$this->input->post('email');
						
        $count=$this->Do_email_check->email_check($user_id,$email);
		if($count>0)
		{
			$this->form_validation->set_message('user_role_email_check', $this->lang->line('email_address_exists'));
			return FALSE;	
		}
		else
		{
			return true;
		}
	}
	 
	 
	 /*
	 * 
	 * name: payment_info_add_post
	 * @param : null
	 * @return :Last insert id
	 * 
	 */
	
    public function payment_info_add_post(){		
		
		$this->form_validation->set_rules('billing_wire_bank_name', 'lang:bank_name', 'trim|required');
		$this->form_validation->set_rules('billing_wire_acc_no', 'lang:account_number', 'trim|required');
		$this->form_validation->set_rules('billing_wire_bank_address', 'lang:bank_address', 'trim|required');
		$this->form_validation->set_rules('billing_wire_swift_bic', 'lang:swift_bic', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
		     $account_id	= 	$this->user_authentication->account_id;
	 
		   $status_check=$this->Do_networks->add_payment_info($this->post(),$account_id);
		   if($status_check!="updated")
		   {
			   $success = array(
								'response' => 'ok',
								'redirect'=>site_url('admin/settings/payment_settings'),
								'msg'	 => $this->lang->line('payment_information_added') );
			   $this->response($success, 200);
		  }
		  else
		  {
		   	//Sending mail to publisher for updating their payment settings
			//Get publisher details
			
			$publisher_details=$this->Do_publisher->get_profile($account_id); 
			//Get admin details
			$result=$this->Do_networks->get_network_details();			
			$admin_name    = $result['firstname']." ".$result['lastname'];			
			$admin_email   = $result['email'];
			$user_email    = $publisher_details['email'];
			$user_name     = $publisher_details['first_name']." ".$publisher_details['last_name'];
			$type     	   = "PUB_PAY_WIRE_UPDATED";
			$from 		   = $admin_email;
			$to  		   =  $user_email;			
			$mail_content=array(
				"subject" 		=> $this->lang->line('yr_wire_payment_det_updtd'),
				"to_name" 		=> $user_name,				
				"from_name"		=> $admin_name,
				"email"  		=> $user_email,
			    'bank_name'		=> $this->post('billing_wire_bank_name'),      
				'bank_account_no'=> $this->post('billing_wire_acc_no'),
				'bank_address'	 => $this->post('billing_wire_bank_address'),
				'currency_code'	 => $this->post('billing_wire_currency'),
				'swift_bic'		 => $this->post('billing_wire_swift_bic'),
				'account_holder_name' =>$this->post('account_holder_name')								
			 );
			$attachement='';	
		   send_mail($type,$from,$to,$mail_content,$attachement,$from); 
		   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => $this->lang->line('payment_information_updated') );
		   $this->response($success, 200);
		  
		  }
        }
	}
	
	
	
     /* for admin account
	 * 
	 * name: admin_payment_info_add
	 * @param : null
	 * @return :Last insert id
	 * 
	 */
	
    public function admin_payment_info_add_post(){		
		
		$this->form_validation->set_rules('account_holder_name', 'lang:pu_acc_hold_name', 'trim|required');
		$this->form_validation->set_rules('billing_wire_bank_name', 'lang:bank_name', 'trim|required');
		$this->form_validation->set_rules('billing_wire_acc_no', 'lang:account_number', 'trim|required');
		$this->form_validation->set_rules('billing_wire_bank_address', 'lang:bank_address', 'trim|required');
		$this->form_validation->set_rules('billing_wire_currency', 'lang:currency', 'trim|required');
		$this->form_validation->set_rules('billing_wire_swift_bic', 'lang:swift_bic', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
		   $account_id	= 	$this->user_authentication->account_id;	
		   $status_check=$this->Do_networks->admin_add_payment_info($this->post(),$account_id);
		   if($status_check!="updated")
		   {
		   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => $this->lang->line('payment_information_added') );
		   $this->response($success, 200);
		  }
		  else
		  {
		   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => $this->lang->line('payment_information_updated'));
		   $this->response($success, 200);
		  
		  }
        }
	}
	
   /*
	* 
	* name: fetch_payment_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_payment_info_get()
	{  
	  //Get from library file
	  $account_id	= 	$this->user_authentication->account_id;
	  $payment_info =	$this->Do_networks->get_payment_info($account_id);
	  $this->response($payment_info, 200);	
	}
	
	/* FOR ADMIN
	* 
	* name: fetch_payment_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_admin_payment_info_get()
	{ 
	  //Get from library file 
	  $account_id	= 	$this->user_authentication->account_id;
	 
	  $payment_info=$this->Do_networks->get_admin_payment_info($account_id);
	  $this->response($payment_info, 200);	
	}
   
    /*
	* 
	* name: fetch_paypal_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_paypal_info_get()
	{
	   //Get from library file
	  $account_id	= 	$this->user_authentication->account_id;
	  $paypal_info=$this->Do_networks->get_paypal_info($account_id);
	  $this->response($paypal_info, 200);	
	}
	
   /*
	* 
	* name: fetch_admin_paypal_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_admin_paypal_info_get()
	{
	  //Get from library file
	  $account_id	= 	$this->user_authentication->account_id;
	  $paypal_info=$this->Do_networks->get_admin_paypal_info($account_id);
	  $this->response($paypal_info, 200);	
	}
	
    public function add_paypal_post()
	{ 		
	   //Get from library file
	  $account_id	= 	$this->user_authentication->account_id;
	  $status_check=$this->Do_networks->add_paypal_info($this->post(), $account_id);
	  if($status_check!="updated")
	  {
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => $this->lang->line('paypal_id_added') );
		$this->response($success, 200);
	  }
	  else
	  {
	   //Sending mail to publisher for updating their payment settings
		//Get publisher details
		$publisher_details=$this->Do_publisher->get_profile($this->post('pk')); 
		//Get admin details
		$result=$this->Do_networks->get_network_details();			
		$admin_name    = $result['firstname']." ".$result['lastname'];			
		$admin_email   = $result['email'];
		$user_email    = $publisher_details['email'];
		$user_name     = $publisher_details['first_name']." ".$publisher_details['last_name'];
		$type     	   = "PUB_PAY_PAL_UPDATED";
		$from 		   = $admin_email;
		$to  		   =  $user_email;			
		$mail_content=array(
			"subject" 		=> $this->lang->line('pay_det_updtd_paypal'),
			"to_name" 		=> $user_name,				
			"from_name"		=> $admin_name,
			"email"  		=> $user_email,
			'pay_pal_id'    => $this->post('value')      
		 );
		$attachement='';	
	    send_mail($type,$from,$to,$mail_content,$attachement,$from); 
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => $this->lang->line('paypal_id_updated') );
		$this->response($success, 200);
	  }
	  
	}
	
	/*
	* 
	* name: admin_add_paypal
	* @param : none
	* @return : true or false.
	* 
	*/
	 public function admin_add_paypal_post()
	{
	   //Get from library file
	  $account_id	= 	$this->user_authentication->account_id;
	  $status_check=$this->Do_networks->admin_add_paypal_info($this->post(),$account_id);
	  if($status_check!="updated")
	  {
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => $this->lang->line('paypal_id_added') );
		$this->response($success, 200);
	  }
	  else
	  {
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => $this->lang->line('paypal_id_updated') );
		$this->response($success, 200);
	  }
	  
	}
	
	/*
	* 
	* name: publisher_payment_mode
	* @param : account_id,payment_mode values
	* @return : true or false.
	* 
	*/
	public function publisher_payment_mode_post()
	{  
	    //Get from library file
	   $account_id	= 	$this->user_authentication->account_id;
	   $payment_mode=$this->Do_networks->update_payment_mode($this->post(), $account_id);
	   if($payment_mode)
	   {
	      $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => $this->lang->line('payment_mode_updated') );
		  $this->response($success, 200);
	   }
	   else
	   {
	       $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => $this->lang->line('unable_update_payment_mode') );
		  $this->response($success, 200);
	   
	   }
	}
	
	/*
	* 
	* name: admin_earning_post
	* @param : account_id,account_type values
	* @return : true or false.
	* 
	*/
	public function admin_earning_post()
	{	
		
		
		 //Get from library file
 		$account_id	= 	$this->user_authentication->account_id;
		$account_type 	= 	$this->user_authentication->account_type;
		
		$earning 		= 	$this->Do_networks->admin_earning($account_id,$account_type);

		//
			if($earning)
		{
			//currency conversion 4 digits in widgets
			$earning        = 	currencyformat($earning['tot_revenue']);
			$success 	= 	array('response'	=> 	'ok',
								  'msg'			=> 	$earning
								);
			
			$this->response( $success, 200);
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	''
								);
			
			$this->response($error, 200);
		}			
		
	}
	
	/*
	* 
	* name: get_network_account_details
	* @param : none
	* @return : admin wire-account details
	* 
	*/
	public function get_network_account_details_get()
	{
	  $agency_id 	= $this->user_authentication->agency_id;
	  $get_account_details=$this->Do_networks->get_network_admin_account_details($agency_id);
	  $this->response($get_account_details);
	  
	}
	
	
	/*
	 * 
	 * name: account_settings_add
	 * @param :null
	 * @return : response Array
	 * 
	 * Add/update the Account Setting Information for Admin
	 */
	
    public function account_settings_update_role_post(){		
		
		$this->form_validation->set_rules('email', 'lang:email', 'trim|required|valid_email');
		//$this->form_validation->set_rules('another_email','Another Email','trim|required|valid_email');
		#$this->form_validation->set_rules('currency_to_view', 'Currency', 'trim|required');
		$this->form_validation->set_rules('password', 'lang:new_pwd', 'trim|matches[conf_password]');
		$this->form_validation->set_rules('conf_password', 'lang:repeat_pwd', 'trim|matches[password]');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error1',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			$user_id=$this->user_authentication->manager_user_id;	
			
			$account_id=$this->user_authentication->account_id;	
			//GET CURRENT PASSWORD FROM djax_users
			$db_old_pass=$this->Do_publisher->get_current_user_role_pass($user_id);
			
			$account_setting_type="account";
			$cur_date = mdate('%Y-%m-%d %H:%i:%s',local_to_gmt());
			//$current_password=trim($this->post('current_password'));
			$current_password = trim($this->post('current_password'));
			if(md5($current_password)==$db_old_pass || $current_password=='')
			{   
			     $update_setting_infoObj=array(
										
										"email"  =>	$this->post('email'),
										#"alternate_email"	=>	$this->post('another_email'),
										#"currency" 	=>	$this->post('currency_to_view'),
										"password"=>$current_password,
										"email_updated"=>$cur_date,
										"acc_id"   =>$account_id
							    	);	
							    	
						
		    $this->Do_networks->update_user_role($user_id,$update_setting_infoObj);					
			//SEND MAIL TO ADMIN / MANAGERS
			$result=$this->Do_networks->get_network_details();
			//Get user name from ox_users
			$user_name=$this->Do_networks->get_user_role_info($user_id);
			$admin_name    = $result['firstname']." ".$result['lastname'];			
			$admin_email   = $result['email'];
			$user_email    = $this->post('email');
			$user_name     =  $user_name[0]['contact_name'];
			$type     	   = ($this->post('password')!='')?"ADMIN_CHANGE_PASSWORD":"ADMIN_SETTING_INFORMATION";
			$from 		   = $admin_email;
			$to  		   =  $user_email;
			if($this->post('password')!='')
			{			
				//If Admin change his password then it will works
				$mail_content=array(
						"subject" 		=> $this->lang->line('adm_chng_pwd'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,							
						"email"   		=> $this->post('email'),
						"password"		=> $this->post('password'),
						"account_type"	=> "admin"							
					);		
			}
			else
			{
			    //Send only email,alternate email to their email
				$mail_content=array(
								"subject" 		=> $this->lang->line('adm_actn_set_info'),
								"to_name" 		=> $user_name,				
								"from_name"		=> $admin_name,							
								"email"   		=> $this->post('email'),
								"alternate_email" => $this->post('another_email'),
								"currency"		=> $this->post('currency_to_view'),
								"account_type"	=> "admin"		
								);
			
			}
		   $attachement='';	
		   send_mail($type,$from,$to,$mail_content,$attachement,$from); 
		   
			 $success = array(
								'response' => 'ok',
								'redirect'=>site_url('admin/settings/account_settings'),
								'msg'	 => $this->lang->line('account_settings_updated')
				);
			  
			    $this->response($success, 200); 
			  }
			   else
			   {
			       $error = array(
							'response' => 'error',
							'redirect'=>site_url('admin/settings/account_settings'),
							'msg'	 => $this->lang->line('enter_current_password')
							);
			       $this->response($error, 200);
			   
			   }
		
		}

	}
	
	/*
	 * name: fetch_mobile_screen_get
	 * @param :null
	 * @return : mobile screen details
	 * 
	*/
	function fetch_mobile_screen_get()
	{
		$screen_config = $this->Do_networks->get_screen_sizes();
		$this->response($screen_config,200); 
	}
	
	/*
	 * name: edit_screen_size_get
	 * @param :null
	 * @return : edit mobile screen details
	 * 
	*/
	function edit_screen_size_get()
	{
		$screen_id = $this->get('screen_id');
		$mobile_data = $this->Do_networks->get_screen_data($screen_id);
		$this->response($mobile_data,200); 
	}
	
	/*
	 * name: block_screen_get
	 * @param :null
	 * @return : block mobile screen details
	 * 
	*/
	public function block_screen_get()
	{
		$screen_id=$this->get('id');
		if($screen_id)
		{
			$block_screen = $this->Do_networks->block_screen_data($screen_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('sel_scrn_blkd_suc')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
	 * name: unblock_screen_get
	 * @param :null
	 * @return : Unblock mobile screen details
	 * 
	*/
	public function unblock_screen_get()
	{
		$screen_id=$this->get('id');
		if($screen_id)
		{
			$block_screen = $this->Do_networks->unblock_screen_data($screen_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('sel_scrn_unblkd_suc')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
	 * name: update_screen_post
	 * @param :null
	 * @return : update mobile screen details
	 * 
	*/
	public function update_screen_post()
	{
		$screen_id = $this->post('screen_id');
		$this->form_validation->set_rules('screen_name','lang:screen_name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('screen_width', 'lang:screen_width', 'required|trim|is_numeric');
		$this->form_validation->set_rules('screen_height', 'lang:screen_height', 'required|trim|is_numeric|callback_edit_screen_resolution_check');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$update_data		=	array(
										 'name'		=>	$this->post('screen_name'),
										 'value'		=>	$this->post('screen_value'),
										 'width'		=>	$this->post('screen_width'),
										 'height'	=> $this->post('screen_height'),
										 'status'	=> 0
										 ); 
			
			$set_update = $this->Do_networks->update_mobile_screens($update_data,$screen_id);
			
			if($set_update)
			{
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('screen_size_updtd_suc')
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
								);
				$this->response( $error, 200);
			}
										 
		}
	}
	
	/*
	 * name: edit_screen_resolution_check
	 * @param :null
	 * @return : check for already exist mobile screen details
	 * 
	*/
	public function edit_screen_resolution_check()
	{
		$id		    =	$this->post('screen_id');
		$width 		=	$this->post('screen_width');
		$height		=	$this->post('screen_height');
		
		$count		=	$this->Do_networks->dup_resolution_check($id,$width,$height);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('edit_screen_resolution_check', "This width & height already Exists");
			return FALSE;	
		}
		else
		{
			return true;
		}
	}
	
	/*
	 * name: add_screen_post
	 * @param :null
	 * @return : add new mobile screen details
	 * 
	*/
	public function add_screen_post()
	{
		$this->form_validation->set_rules('screen_name','lang:screen_name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('screen_value','lang:screen_value', 'required|trim|callback_check_screen_value');
		$this->form_validation->set_rules('screen_width', 'lang:screen_width', 'required|trim|is_numeric');
		$this->form_validation->set_rules('screen_height', 'lang:screen_height', 'required|trim|is_numeric|callback_screen_resolution_check');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$ins_data		=	array(
										 'name'		=>	$this->post('screen_name'),
										 'value'		=>	$this->post('screen_value'),
										 'width'		=>	$this->post('screen_width'),
										 'height'	=> $this->post('screen_height'),
										 'status'	=> 0
										 ); 
			$insert = $this->Do_networks->insert_new_screen($ins_data);
			if($insert)
			{
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('screen_size_added')
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
								);
				$this->response( $error, 200);
			}							 
		}
	}
	
	public function check_screen_value()
	{
		$scr_val		=	$this->post('screen_value');
		$count		=	$this->Do_networks->dup_screen_value($scr_val);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('check_screen_value', $this->lang->line('value_already_exist') );
			return FALSE;	
		}
		else
		{
			return true;
		}
	} 
	
	public function screen_resolution_check()
	{
		$width 		=	$this->post('screen_width');
		$height		=	$this->post('screen_height');
		
		$count		=	$this->Do_networks->dup_resolution_screen_check($width,$height);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('screen_resolution_check', $this->lang->line('width_height_exists'));
			return FALSE;	
		}
		else
		{
			return true;
		}
	}

	/*
     * 
     * name: last_update_date_timezone
     * @param : 
     * @return : package timezone & statistics last updated date
     * 
     */
	public function last_update_date_post()
	{
				
		$lastupdate		= 	$this->Do_networks->last_update_date_time();
		$success 		= 	array('response'	=> 	'ok',
							  'msg'			=> 	$lastupdate
								);
		$this->response($success, 200);
			
	}
	/* Last update detail*/
	public function admin_affiliate_earning_post()
	{
		 //Get from library file
 		$account_id	= 	$this->user_authentication->account_id;
		$account_type 	= 	$this->user_authentication->account_type;
		
		$earning 		= 	$this->Do_networks->admin_affiliate_earning($account_id,$account_type);
		//currency conversion 4 digits in widgets
		$earning        = 	currencyformat($earning['tot_revenue'],$this->config->item('currency'),4);
		//
			if($earning)
		{
			$success 	= 	array('response'	=> 	'ok',
								  'msg'			=> 	$earning
								);
			
			$this->response( $success, 200);
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	''
								);
			
			$this->response($error, 200);
		}			
	}
		/*
	 * 
	 * name: site_settings_add
	 * @param :null
	 * @return : response Array
	 * 
	 * Add/update the Site Setting Information for Admin and affiliates
	 */
	
    public function site_settings_update_post(){		
		
		$this->form_validation->set_rules('site_name', 'lang:site_name', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			 //Get from library file
		     $account_id	= 	$this->user_authentication->account_id;	
		     
		     $default_user_id = $this->user_authentication->user_id;	
			
			$account_setting_type="site";
			
			$data=array(
										
										"site_name"  =>	$this->post('site_name')
							    	);	
							    	
		    $this->Do_networks->site_settings_update($account_id,$data);		
		    
		   			
			 $success = array(
								'response' => 'ok',
								'redirect'=>site_url('admin/settings/site_settings'),
								'msg'	 => $this->lang->line('site_set_info_updtd_suc')
				);
			  
			$this->response($success, 200); 
		}

	}
	
	/*
	 * 
	 * name: upload_logo_image
	 * @param : null
	 * @return:response array
	 * 
	 * Upload the selected image
	 * Developer Ramya P on 4 May 2016
	 */
	
	public function upload_logo_image_post()
	{
		 
		 //Get from library file
		
		 $account_id	= 	$this->user_authentication->account_id;	
		  $logo_sett=	$this->post('logo_settings');
		if($_FILES['logo_image'])
		{
			$logo_image=array(
					'file_name'   => $_FILES['logo_image']['name'],
					'source_name' => $_FILES['logo_image']['tmp_name'] 				 				
					);
		}
	
			$data=$this->image_lib->update_logo_image($logo_image,$logo_sett);
		$res = $this->Do_networks->update_logo_image_information($account_id,$data['upload_data']['file_name']);
		 /*Reset session*/
			unset_logo_admin('logo_image',$data['upload_data']['file_name']);
		
		/*Reset session*/

		if($res){
		 
		 $success = array(
							'response' => 'ok',
							'msg'	 => $this->lang->line('logo_image_updated_suc')
			);
			
			$this->response($success, 200);
		}
		else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('please_try_again')
			);
			
			$this->response($error, 200);
		}
		
	}
	
	
	/*
	 * 
	 * name: delete_logo_image
	 * @param : null
	 * @return :response array
	 * 
	* Developer Ramya P on 4 May 2016
	 */
	
	public function delete_logo_image_post()
	{
		 //Get from library file
		 $account_id	= 	$this->user_authentication->account_id;	
		 $logo_name=$this->Do_networks->get_user_information($account_id);
		 $delete_logo_name=$logo_name[0]['logo_image'];
		 
				
		if($delete_logo_name)
		{
			$is_delete_logo=$this->image_lib->delete_logo_image($delete_logo_name);
			 /*Reset session*/
			unset_logo_admin('logo_image','');
		
			/*Reset session*/
			/* Delete Profile name in Database */
			$this->Do_networks->delete_logo_name($account_id);
			
			if($is_delete_logo)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => $this->lang->line('thumb_image_deleted')
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_to_dlt_logo_image')
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_to_dlt_logo_image')
							);
			$this->response($error, 200);
		}
	}
	
		
}
