<?php defined('BASEPATH') OR exit('No direct script access allowed');
//~ ini_set('display_errors', 1);
//~ ini_set('display_startup_errors', 1);
//~ error_reporting(E_ALL);
/**
 *
 * All web Adblocks will be managed here 
 *
 * @package		ADX
 * @subpackage	Web Adblocks
 * @category	Controller
 * @link		http://www.djaxadexchange.com
*/


class Mobile_adblock extends REST_Controller
{
	protected $zone_type=3;
	public $min_floor_price;
	
	function __construct()
	{
		parent::__construct();	
		
		$this->load->model('Do_mobile_adblock');
		$this->load->model('Do_mobile_auto_link');
		$this->load->model('Do_rtb');
		$this->load->model('Do_zone_link');	
		$this->min_floor_price =  $this->default_configurations->get('pub_min_floor_price');
		
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }			
	}
 	

		
	// api.v_1/web_adblock/add/format/json
	
    public function add_post(){

		 
		$this->form_validation->set_rules('site_name','lang:site_name', 'required|trim');
		$this->form_validation->set_rules('block_name','lang:ad_block_name', 'required|trim');
		
		if($this->post('zone_type')!='M_A_TXT' && $this->post('zone_type')!='M_A_OL' && $this->post('zone_type')!='M_A_IN' && $this->post('zone_type')!='M_A_IR' && $this->post('zone_type')!='M_A_NATIVE' && $this->post('zone_type')!='M_A_RW' && $this->post('zone_type')!='M_A_PV' && $this->post('zone_type')!='M_A_DHTML' && $this->post('zone_type')!='M_A_IMG_NAT' && $this->post('zone_type')!='M_A_DHTML5')
		{
			
			$this->form_validation->set_rules('width','lang:width', 'required|trim');
			$this->form_validation->set_rules('height','lang:height', 'required|trim');
			
		}
		$this->form_validation->set_rules('floor_price','lang:cpm_floor_price', 'required|trim||greater_than_equal_to['.$this->min_floor_price.']');
		
		if($this->form_validation->run() === FALSE)
		{
			 $error_msg = $this->form_validation->error_array();			

			 $error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{			
			/* Fetch Affiliateid */	
			#$account_id=$this->post('account_id');
			$account_id	= 	$this->user_authentication->account_id;
			$agency_id	= 	$this->user_authentication->agency_id;
			$affiliate_id=$this->Do_mobile_adblock->fetch_affiliateid($account_id);
		
		     
							
			$this->db->trans_start();
				$adposition = '';
				$adinterval = '';
			//delivery number
				$width = $this->post('width');
				$height = $this->post('height');
			if($this->post('zone_type') == 'M_A_IM')
			{
				$type_ = $this->post('cross_zone_type');
				$delivery = delivery_value($this->post('cross_zone_type'));
				//~ if($type_ == 'C_A_BAN')
				//~ {
					//~ $width = $this->post('width_cross');
					//~ $height = $this->post('height_cross');
					//~ //$mob_ad_type = "";
				//~ }
				//~ else
				//~ {
					//~ $width = $this->post('width');
					//~ $height = $this->post('height');
					//$mob_ad_type = $this->post('mobile_ad_type');
				//}
				
			}
			else if($this->post('zone_type') == 'M_A_TXT')
			{
				$type_ = $this->post('cross_zone_type_txt');
				$delivery = delivery_value($this->post('cross_zone_type_txt'));
				//~ $width = $this->post('width');
				//~ $height = $this->post('height');
				//~ if($type_ == 'C_A_TEXT')
				//~ {
					//~ $mob_ad_type = "";
				//~ }
				//~ else
				//~ {
					//~ $mob_ad_type = $this->post('mobile_ad_type');
				//~ }
			}
			else if($this->post('zone_type') == 'M_A_IN')
			{
				$type_ = $this->post('cross_zone_type_vin');
				//~ $delivery = delivery_value($this->post('cross_zone_type_vin'));
				$delivery = 6;
				//~ $width = $this->post('width');
					//~ $height = $this->post('height');
					//~ if($type_ == 'C_A_IN')
				//~ {
					//~ 
					//~ $mob_ad_type = "";
				//~ }
				//~ else
				//~ {
					//~ 
					//~ $mob_ad_type = $this->post('mobile_ad_type');
				//~ }
			}
			else if($this->post('zone_type') == 'M_A_OL')
			{
				$type_ = $this->post('cross_zone_type_vol');
				//~ $delivery = delivery_value($this->post('cross_zone_type_vol'));
				$delivery = 7;
				//~ $width = $this->post('width');
					//~ $height = $this->post('height');
					//~ if($type_ == 'C_A_OL')
				//~ {
					//~ 
					//~ $mob_ad_type = "";
				//~ }
				//~ else
				//~ {
					//~ $mob_ad_type = $this->post('mobile_ad_type');
				//~ }
			}
			else if($this->post('zone_type') == 'M_A_NATIVE')
			{
				$type_ = "M_A_NATIVE";
				$delivery = 9;
				$width = '-4';
				$height = '-4';
				$adposition = $this->post('adposition');
				$adinterval = $this->post('ads_interval');
					
			}
			else if($this->post('zone_type') == 'M_A_RW')
			{
				$type_ = "M_A_RW";
				$delivery = 14;
				/*$width = '-3';
				$height = '-3s';
				$adposition = $this->post('adposition');
				$adinterval = $this->post('ads_interval');*/
					
			}
			else if($this->post('zone_type') == 'M_A_PV') {
				$type_ = "M_A_PV";
				$delivery = 15;
				/*$width = '-3';
				$height = '-3s';
				$adposition = $this->post('adposition');
				$adinterval = $this->post('ads_interval');*/
			}
			else if($this->post('zone_type') == 'M_A_DHTML') {
				$type_ = "M_A_DHTML";
				$delivery = 16;
				$width = $this->post('width_cross');
				$height = $this->post('height_cross');
			}
			else if($this->post('zone_type') == 'M_A_IMG_NAT')
			{
				$type_ = "M_A_IMG_NAT";
				$delivery = 17;
				$width = $this->post("width_cross");
				$height = $this->post("height_cross");
				$adposition = $this->post('adposition');
				$adinterval = $this->post('ads_interval');
					
			}
			else if($this->post('zone_type') == 'M_A_DHTML5') {
				$type_ = "M_A_DHTML5";
				$delivery = 18;
				$width = $this->post('width_cross');
				$height = $this->post('height_cross');
			}
			else
			{
				$type_ = $this->post('zone_type');
				$delivery = delivery_value($this->post('zone_type'));
				//~ $width = $this->post('width');
				//~ 
					//~ $height = $this->post('height');
					//$mob_ad_type = $this->post('mobile_ad_type');
				$adposition = "";
				$adinterval = "";
				
	    	}
	    	$mob_ad_type = $this->post('mobile_ad_type');
	    	
	    	
			if($this->post('zone_type')=="M_A_SLI" || $this->post('zone_type')=="M_A_PULL")
			{
				$ad_position = $this->post('ad_position');
			}
			else
			{
				$ad_position = '';
			}
			$delivery_priority='';
			
			if($this->post('delivery_type')=="housead" )
			{
				$delivery_priority='housead';
			}
			else
			{
				$delivery_priority='passback';
			}
			
			if($this->post('rewards')){
				$rewards = implode("|",$this->post('rewards'));
			}
			else {
				$rewards = '';
			}

			if($this->post('amount')){
				$amount = implode("|",$this->post('amount'));
			}
			else {
				$amount = '';
			}
	
			$add_mobile_adblockObj=array("deliver_type"  	=>	$delivery_priority,
										"zonename"  		=>	clean_data($this->post('block_name')),
										"affiliateid"		=>	$affiliate_id,
										"zonetype"			=>	$this->zone_type,
										"delivery"			=>	$delivery,
										"dj_zone_type"		=>	$this->post('zone_type'),
										"width" 			=>	$width,
										"height"			=>  $height,
										"dj_floor_price"	=>	clean_data($this->post('floor_price')),
										"dj_passback_tag" 	=>	stripslashes($this->post('passback_tag')),
										"dj_added_date"		=>	date("Y-m-d H:i:s"),
										"dj_mobile_ad_type"	=>	$mob_ad_type,
										"dj_ad_position"	=>	$ad_position,
										// "rtb_type"	 => $this->input->post('rtb_site'),
										"rtb_type"	 => clean_data($this->post('type_bidding')),
										"adposition"=> 	$adposition,
										"adinterval" => $adinterval,
										"layout"  => clean_data($this->post('layout')),
										'reward' => $rewards,
										'amount' => $amount
								);			
			//cho "<pre>"; print_r($add_mobile_adblockObj); exit();						
							
			$zone_id=$this->Do_mobile_adblock->add($add_mobile_adblockObj);	
			//~ $this->response($zone_id, 200);			
			//$zone_id = 217;					
			$add_mobile_adblockAssoc = array("site_id"=> clean_data($this->post('site_name')),
											"zone_id"=> $zone_id,	
									);
			
			$this->Do_mobile_adblock->addAssoc($add_mobile_adblockAssoc);
			$link_type=$this->default_configurations->get('linking_type');
			$dsp_id = implode(",",$this->post('select_dsp'));
				$bidding_type = $this->input->post('type_bidding');  
			if($this->post('zone_type')=='M_A_PV'){

				$rv_player_settings = array("zoneid"=>$zone_id,
					"vid_autoplay"=>clean_data($this->post('autoplay_pause')),
					"vid_mute"=>clean_data($this->post('mute_pause')),
					"vid_height"=>clean_data($this->post('height_pause')),
					"vid_width"=>clean_data($this->post('width_pause')),
					"vid_content_url"=>clean_data($this->post('pause_video_content_url')),
					"vid_ad_position"=>clean_data($this->post('pause_video_position')),
					"vid_overlay_position"=>clean_data($this->post('pause_video_overlay_position')));

				$this->Do_mobile_adblock->add_rv_player_settings($rv_player_settings);

			}
			if($link_type !='manual linking')
			{
				if($bidding_type==0)
				{
					$res= $this->Do_mobile_auto_link->mobile_link_ads($zone_id,$agency_id);
				}
				
					
					else if(!empty($dsp_id) && $bidding_type==1)
					{
						if($dsp_id=='all'){
							$dsp_details=$this->Do_rtb->list_dsp();
						
						foreach($dsp_details as $key=>$value){
							$dspid[] = $value['exchange_id'];
						}
			
						 $dsp_ids = implode(",",$dspid);
							
						}
						else{
							$dsp_ids =$dsp_id;
						}
				//$this->Do_zone_link->link_ads($zone_id, $housead = 1,$dsp_ids);
				if($zone_id != FALSE){
            
					$dsp_id = implode(",",$this->post('select_dsp'));
			 
					if($dsp_id)
					{
		
					//$this->Do_rtb->add_aff_dsp_assoc($zone_id, $dsp_id); 
					
					}
				}
			}
				
			}
			else{
				$house_ad=1;
				$res= $this->Do_mobile_auto_link->mobile_link_ads($zone_id,$agency_id,$house_ad);
				$dsp_id = implode(",",$this->post('select_dsp'));
				$bidding_type = $this->input->post('type_bidding');
					
					if(!empty($dsp_id) && $bidding_type==1)
					{
						if($dsp_id=='all'){
							$dsp_details=$this->Do_rtb->list_dsp();
						
						foreach($dsp_details as $key=>$value){
							$dspid[] = $value['exchange_id'];
						}
			
						 $dsp_ids = implode(",",$dspid);
							
						}
						else{
							$dsp_ids =$dsp_id;
						}
				$this->Do_zone_link->link_ads($zone_id, $housead = 1,$dsp_ids);
				if($zone_id != FALSE){
            
					$dsp_id = implode(",",$this->post('select_dsp'));
			
					if($dsp_id)
					{
		
					//$this->Do_rtb->add_aff_dsp_assoc($zone_id, $dsp_id); 
					}
				}
			}
			}
			
			$bidding_type = $this->input->post('type_bidding');		
			 
			if($bidding_type == 1){
				
			 $dsp_id = implode(",",$this->post('select_dsp')); 
			
            if($dsp_id)
            {
              //$this->response($add_web_adblockAssoc);
            $zone_type = $this->post('zone_type');  		
            
            if($zone_type == 'W_BAN')
            {
				$zone_type =$this->post('zone_type');
			}
			else
			{
				$zone_type='W_DHTML';
			}
			
            $site_details = $this->Do_rtb->fetch_site_details($this->post('site_name')); 
              
			if( $this->post('zone_type')=='W_TEXT' || $this->post('zone_type')=='M_A_TXT'){
							$ban_attr = '1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17';
						}else{
							$ban_attr = '1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,17';
						}
						 
            $rtb_zone_update_details = array(
                "zoneid" => $zone_id,
                "req_tmax" => clean_data($this->post('max_time')),
                 "ban_btype" => '1,3,4',
                "ban_battr" => $ban_attr,
                "vid_playervideo" => clean_data($this->post('pvideo')),
                "vid_width" => clean_data($this->post('pwidth')),
                "vid_height" => clean_data($this->post('pheight')),
                "vid_min" => clean_data($this->post('video_min')),
                "vid_max" => clean_data($this->post('video_max')),
                "vid_sd" => clean_data($this->post('v_s_delay')),
                "vid_play" => clean_data($this->post('v_playbalck')),
                "vid_skip" => clean_data($this->post('v_skip')),
                "vid_roll_sec" => clean_data($this->post('seconds')),
                "vid_skipafter" => clean_data($this->post('skip_seconds')),
                "vid_comptype" => clean_data($this->post('v_compan_type')),               
                "vid_lin" => clean_data($linear),
                "vid_minbit" => clean_data($this->post('v_min_bit_rate')),
                "vid_maxbit" => clean_data($this->post('v_max_bit_rate')),
                "vid_del" => clean_data($this->post('delvy_methods')),
                "vid_compad" => clean_data($this->post('compad')),
                "vid_comp_width" => clean_data($this->post('c_width')),
                "vid_comp_height" => clean_data($this->post('c_height')),
                "imp_bidfloor" => clean_data($this->post('floor_price')),
                "imp_bidfloorcur" => "USD",
                "user_gender" => 'all',
				//~ "app_id" => clean_data($this->post('app_id')),
                //~ "app_name" => clean_data($this->post('app_name')),
                //~ "app_bundle" => clean_data($this->post('app_bundle')),
                "app_url" => clean_data($this->post('app_url')),
                "app_cat" => $site_details[0]['category_id'],
                "app_section" => $site_details[0]['category_id'],               
                "app_page" => $site_details[0]['category_id'],               
                "app_privacy" => 1,
                //~ "app_ver" => clean_data($this->post('app_ver')),
                "app_paid" => clean_data($this->post('app_paid')),
                "imagertb" => clean_data($this->post('imagertb')),
                "videortb" => clean_data($this->post('videortb')),
                "apprtb" => clean_data($this->post('apprtb')),
                "rtb_id" => $dsp_id,
                "site_cat" => $site_details[0]['category_id']
            );
        
            $rtb_zone_update = $this->Do_rtb->rtb_zone_update($rtb_zone_update_details);
            
          
		}
	}
			//$this->response($res, 200);
			$this->db->trans_complete();
			
			$success = array(
							'response' => 'ok',
							'msg'	 => $this->lang->line('mobile_adblock_added')
			);
		
						
			$this->response($success, 200);
		}

	}
	
	function zonesizelist_get()
	 {
					
		    $zone_sizes=$this->Do_web_adblock->list_zonesizes();		  
		   
		   if($zone_sizes)
			{
				$this->response($zone_sizes, 200); // 200 being the HTTP response code
			}

			else
			{
				$this->response(array('error' => $this->lang->line('zone_not_found')), 404);
			}
		   
	 }

	 function rv_pause_settings_get(){

	 	$zone_id	   = $this->get('zone_id');	

	 	if($zone_id)
		{
			$rv_pause_settings_list = $this->Do_mobile_adblock->rv_pause_settings_fetch($zone_id);
			
			  $this->response($rv_pause_settings_list);  
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => "Failed to fetch rv_pause_video_settings"
					);
			
			$this->response($error, 200);
		}
	 }
	 
	/**
       * 
       * name : fetch_get()
       * 
       * @params : account_id and zone_id
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	 function fetch_get($site_id=FALSE)
	 {
		 
		
		   $account_id	= 	$this->user_authentication->account_id;		
		   #$account_id = $this->get('account_id');
		   $zone_id	   = $this->get('zone_id');	
		   
		   $siteid=$this->input->get_post('siteid');
		  
			if($account_id){
			
				$site_list = $this->Do_mobile_adblock->fetch($account_id,$zone_id,$siteid);
                 $this->response($site_list);  
				
			}
	}
	
	/**
       * 
       * name : update_post()
       * 
       * @params : zone_id
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		$zoneid 	= $this->post('zone_id');
		$agency_id	= 	$this->user_authentication->agency_id;	
		
		if($zoneid)
		{
			$this->form_validation->set_rules('block_name','lang:ad_block_name', 'required|trim');
		
			if($this->post('zone_type')!='M_A_TXT' && $this->post('zone_type')!='M_A_OL' && $this->post('zone_type')!='M_A_IN' && $this->post('zone_type')!='M_A_IR' && $this->post('zone_type')!= 'M_A_NATIVE' && $this->post('zone_type')!='M_A_RW' && $this->post('zone_type')!='M_A_PV' && $this->post('zone_type')!='M_A_IMG_NAT' && $this->post('zone_type')!='M_A_DHTML' && $this->post('zone_type')!='M_A_DHTML5')
			{
				$this->form_validation->set_rules('width','lang:width', 'required|trim');
				$this->form_validation->set_rules('height','lang:height', 'required|trim');
			}
			$this->form_validation->set_rules('floor_price','lang:cpm_floor_price', 'required|trim');
			
			if($this->form_validation->run() ===FALSE){
			
				$error_msg = $this->form_validation->error_array();
				$error = array(
									'response' => 'error',
									'msg' =>  $error_msg
								);

				 $this->response( $error, 200);
			}else{
			
				$site = $this->Do_mobile_adblock->update($this->post(),$agency_id);
				if($this->post('zone_type')=='M_A_PV'){

				$rv_player_settings = array(
					"vid_autoplay"=>clean_data($this->post('autoplay_pause')),
					"vid_mute"=>clean_data($this->post('mute_pause')),
					"vid_height"=>clean_data($this->post('height_pause')),
					"vid_width"=>clean_data($this->post('width_pause')),
					"vid_content_url"=>clean_data($this->post('pause_video_content_url')),
					"vid_ad_position"=>clean_data($this->post('pause_video_position')),
					"vid_overlay_position"=>clean_data($this->post('pause_video_overlay_position')));

				$this->Do_mobile_adblock->add_rv_player_settings_update($zoneid,$rv_player_settings);

			}
			//$this->response($site, 200);
			$bidding_type = $this->input->post('type_bidding');		
			 
			if($bidding_type == 1){
				   $site_details = $this->Do_rtb->fetch_site_details($this->post('site'));
				
				 //~ if($site_details)
                 	//~ {
			/* static pARAM */

						if( $this->post('zone_type')=='W_TEXT' || $this->post('zone_type')=='M_A_TXT'){
							$ban_attr = '1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17';
						}else{
							$ban_attr = '1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,17';
						}
			 
               
			
			$dsp_id = implode(",",$this->post('select_dsp'));
			if($dsp_id)
			{

			$test = $this->Do_rtb->add_aff_dsp_assoc($zoneid, $dsp_id); 
			
			}
			
			/*STATIC PARAM */
          
          
           
            $rtb_zone_update_details = array(
                "zoneid" => $zoneid,
                "req_tmax" => '200',
                "ban_btype" => '1,3,4',
                "ban_battr" => $ban_attr,
                "vid_playervideo" => clean_data($this->post('pvideo')),
                "vid_width" => clean_data($this->post('pwidth')),
                "vid_height" => clean_data($this->post('pheight')),
                "vid_min" => clean_data($this->post('video_min')),
                "vid_max" => clean_data($this->post('video_max')),
                "vid_sd" => clean_data($this->post('v_s_delay')),
                "vid_play" => clean_data($this->post('v_playbalck')),
                "vid_skip" => clean_data($this->post('v_skip')),
                "vid_roll_sec" => clean_data($this->post('seconds')),
                "vid_skipafter" => clean_data($this->post('skip_seconds')),
                "vid_comptype" => clean_data($this->post('v_compan_type')),               
                "vid_lin" => clean_data($linear),
                "vid_minbit" => clean_data($this->post('v_min_bit_rate')),
                "vid_maxbit" => clean_data($this->post('v_max_bit_rate')),
                "vid_del" => clean_data($this->post('delvy_methods')),
                "vid_compad" => clean_data($this->post('compad')),
                "vid_comp_width" => clean_data($this->post('c_width')),
                "vid_comp_height" => clean_data($this->post('c_height')),
                "imp_bidfloor" => clean_data($this->post('floor_price')),
                "imp_bidfloorcur" => "USD",
                "user_gender" => 'all',
				//~ "app_id" => clean_data($this->post('app_id')),
                //~ "app_name" => clean_data($this->post('app_name')),
                //~ "app_bundle" => clean_data($this->post('app_bundle')),
                "app_url" => clean_data($this->post('app_url')),
                //"app_cat" => $site_details[0]['category_id'],
               // "app_section" => $site_details[0]['category_id'],               
                //"app_page" => $site_details[0]['category_id'],               
                "app_privacy" => 1,
                //~ "app_ver" => clean_data($this->post('app_ver')),
                "app_paid" => clean_data($this->post('app_paid')),
                "imagertb" => clean_data($this->post('imagertb')),
                "videortb" => clean_data($this->post('videortb')),
                "apprtb" => clean_data($this->post('apprtb')),
                "rtb_id" => $dsp_id,
               // "site_cat" => $site_details[0]['category_id']
            );
            
              
				$this->db->select('*');
                $this->db->where(array('zoneid'=>$zoneid));
                $param_query = $this->db->get('ox_exchange_zone_assoc');
              



                if($param_query->num_rows()>0){
					 
                    $rtb_zone_update = $this->Do_rtb->rtb_zone_edit_update($rtb_zone_update_details);
                    // $this->response($rtb_zone_update, 200);
                }else{
					
                    $this->db->insert('ox_exchange_zone_assoc',$rtb_zone_update_details);
                }
               
              //~ }else{
				  
                  //~ $this->rtb_zone_edit_params_remove($rtb_zone_update_details);
                  //~ }
             
            
           //  $rtb_zone_update = $this->Do_rtb->rtb_zone_edit_update($rtb_zone_update_details);
               
           }
				
				$success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/web_ad_blocks'),
							'msg'	 => $this->lang->line('web_ad_updt_suc')
				);
			
			$this->response($success, 200);
			}	
			
		}else{
			$this->response(array('error' => $this->lang->line('zone_not_available_id')), 404);	
		}
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{
		
		$zone_id = $this->get('zone_id');	
		
		if($zone_id)
		{
			$zone_id = $this->Do_web_adblock->delete($zone_id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('mobile_adblock_deleted')
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('zoneid_not_found')
					);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : generate_adtags_post()
       * 
       * Generates the Ad tags with custom settings
       * 
       * @return the generated response
    */
	
	
	function generate_adtags_post()
	{
		
		$zone_id = $this->post('zone_id');	
		
		if($zone_id)
		{
			
			$webadblock_tag = $this->generate_webadblock_tag($this->post());
			
			$this->response($webadblock_tag);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('zoneid_not_found')
					);
			
			$this->response( $error, 200);
		}
	}
	
	
	private function generate_webadblock_tag($values =FALSE)
	{
		if($values !='')
		{
			$zone_id = $values['zone_id'];
			$source  = $values['source'];
			
			return '<script type=\'text/javascript\'>document.write ("?zoneid='.$zone_id.'&source='.$source.'");</script>';	
		}else{
			return FALSE;	
		}	
	}
	function fetch_rtb_params_get()
		{
			
			$zone_id    = $this->input->get('zone_id');  
			$rtb_params = $this->Do_rtb->fetch_rtb_params($zone_id);
		 // $this->response($rtb_params, 200);
			if ($rtb_params) {
				$this->response($rtb_params, 200); // 200 being the HTTP response code
			} else {
				$this->response(array(
					'error' => 'Zone Sizes could not be found'
				), 404);
			}
			
		}
	
}
