<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Message related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Gowthaman
 * @link		http://www.djaxadserver.com
 */

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Message extends REST_Controller
{
    
    function __construct()
    {
        
        parent::__construct();
        $this->load->model('Do_message');
        $this->load->library('user_authentication');
        $key = $this->input->get_post('api_key');
        $this->user_authentication->is_valid_apikey($key);
        $user_auth = $this->user_authentication;
        if (isset($user_auth->error['response'])) {
            $this->response($user_auth->error, 200);
        }
        
    }
    
    /**
     * 
     * name : fetch_user_get()
     * 
     * Fetches all users for admin.
     * 
     * @return boolean (or) string Returns the object on TRUE (or) FALSE
     */
    function fetch_user_get()
    {
        $network_id = $this->user_authentication->network_account_id;
        
        $account_id = $this->user_authentication->account_id;
        
        $account_type = $this->user_authentication->account_type;
        
        if ($account_id) {
            if ($network_id) {
                $user = $this->Do_message->fetch_user($account_id, $network_id, $account_type);
            } else {
                $user = $this->Do_message->fetch_user($account_id, '', $account_type);
            }
            
            if ($user) {
                $this->response($user, 200);
            } else {
                $this->response(array(), 200);
            }
        } else {
            $this->response(array(), 200);
        }
    }
    
    /**
     * 
     * name : fetch_message_get()
     * 
     * Fetches all messages for admin.
     * 
     * @return boolean (or) string Returns the object on TRUE (or) FALSE
     */
    function fetch_message_get()
    {
        $network_id = $this->user_authentication->network_account_id;
        
        $account_id = $this->user_authentication->account_id;
        
        $user_type = $this->user_authentication->account_type;
        
        if ($user_type == 'MANAGER' || $user_type == 'ADMIN') {
            $account_type = 'ADMIN';
        } else {
            $account_type = $user_type;
        }
        
        $type = $this->get('message_type');
        
        $id = $this->get('message_id');
        
        if ($type) {
            if ($network_id) {
                if ($id) {
                    $user = $this->Do_message->fetch_message($account_id, $network_id, $account_type, $type, $id);
                } else {
                    $user = $this->Do_message->fetch_message($account_id, $network_id, $account_type, $type);
                }
            } else {
                if ($id) {
                    $user = $this->Do_message->fetch_message($account_id, '', $account_type, $type, $id);
                } else {
                    $user = $this->Do_message->fetch_message($account_id, '', $account_type, $type);
                }
            }
            
            if ($user) {
				
				$user=array_map('callbackformat',$user);//date format from helper for message center
                $this->response($user, 200);
            } else {
                $this->response(array(), 200);
            }
        } else {
            $this->response(array(), 200);
        }
    }
    
    /*
     * 
     * name: attach_image_to_tmp_location_post
     * @param
     * @return:response array
     * 
     * Upload the selected web creative to a temporary location
     * 
     */
    
    public function update_message_status_get()
    {
        $account_id = $this->user_authentication->account_id;
        
        $id = $this->get('message_id');
        
        if ($id) {
            $update = $this->Do_message->update_message_status($account_id, $id);
            
            $this->response($update, 200);
        }
        
    }
    
    /*
     * 
     * name: unread_message_count_post
     * @param
     * @return:response array
     * 
     * Get Messages for user
     * 
     */
    
    public function unread_message_count_post()
    {
        //$account_id		=	$this->post('account_id');
        
        $user_type = $this->post('account_type');
        if ($user_type == "MANAGER" || $user_type == "ADMIN") {
            $account_type = "ADMIN";
        } else {
            $account_type = $this->post('account_type');
        }
        if ($account_type == "ADMIN" || $account_type == "MANAGER") {
            $agency_id  = $this->user_authentication->agency_id;
            $account_id = $this->Do_message->fetch_receiever($agency_id);
        } else {
            $account_id = $this->post('account_id');
        }
        
        if ($account_id && $account_type) {
            $count = $this->Do_message->fetch_unread_message_count($account_id, $account_type);
            
            if ($count) {
                $success = array(
                    'response' => 'ok',
                    'msg' => $count
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'msg' => '0'
                );
                $this->response($error, 200);
            }
        } else {
            $error = array(
                'response' => 'error',
                'msg' => '0'
            );
            $this->response($error, 200);
        }
        
    }
    
    
    /*
     * 
     * name: message_notify_post
     * @param
     * @return:response array
     * 
     * Get Messages for user
     * 
     */
    
    public function message_notify_post()
    {
        //$account_id		=	$this->post('account_id');
        
        $user_type = $this->post('account_type');
        if ($user_type == "MANAGER" || $user_type == "ADMIN") {
            $account_type = "ADMIN";
        } else {
            $account_type = $this->post('account_type');
        }
        if ($account_type == "ADMIN" || $account_type == "MANAGER") {
            $agency_id  = $this->user_authentication->agency_id;
            $account_id = $this->Do_message->fetch_receiever($agency_id);
        } else {
            $account_id = $this->post('account_id');
        }
        
        if ($account_id && $account_type) {
            $message = $this->Do_message->fetch_message_notify($account_id, $account_type);
            
            if ($message) {
                $success = array(
                    'response' => 'ok',
                    'msg' => $message
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'msg' => ''
                );
                $this->response($error, 200);
            }
        } else {
            $error = array(
                'response' => 'error',
                'msg' => ''
            );
            $this->response($error, 200);
        }
        
    }
    
    
    /*
     * 
     * name: attach_image_to_tmp_location_post
     * @param
     * @return:response array
     * 
     * Upload the selected web creative to a temporary location
     * 
     */
    
    public function delete_post()
    {
        $del_msg_id = $this->post('del_msg_id');
        
        $account_type = $this->user_authentication->account_type;
        
        if ($account_type == 'ADMIN' || $account_type == 'MANAGER') {
            $account_type == 'ADMIN';
        }
        
        if ($del_msg_id) {
            $msg_id = explode(',', $del_msg_id);
            
            
            
            if (is_array($msg_id)) {
                foreach ($msg_id as $id) {
                    $delete = $this->Do_message->delete($id, $account_type);
                }
            } else {
                $delete = $this->Do_message->delete($msg_id, $account_type);
            }
            
            if ($delete) {
                $success = array(
                    'response' => 'ok',
                    'msg' => 'Message has been deleted successfully!..'
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'msg' => 'Error..Please Try again.'
                );
                $this->response($error, 200);
            }
        }
    }
    
    /*
     * 
     * name: attach_image_to_tmp_location_post
     * @param
     * @return:response array
     * 
     * Upload the selected web creative to a temporary location
     * 
     */
    public function attach_image_to_tmp_location_post()
    {
        if ($_FILES['attachment']) {
            $attachment = array(
                'file_name' => $_FILES['attachment']['name'],
                'tmp_name' => $_FILES['attachment']['tmp_name']
            );
            
            $tmp_attach = $this->image_lib->move_attach_image_to_tmp_location($attachment);
            
            if ($tmp_attach) {
                $success = array(
                    'response' => $tmp_attach['upload_data'],
                    'msg' => 'Moved to temporary location'
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'redirect' => site_url('admin/messages/messages'),
                    'msg' => 'Unable to move to temporary location '
                );
                $this->response($error, 200);
            }
        }
    }
    
    /*
     * 
     * name: attach_image_to_tmp_location_post
     * @param
     * @return:response array
     * 
     * Upload the selected web creative to a temporary location
     * 
     */
    public function attach_file_to_tmp_location_post()
    {
        if ($_FILES['attachment']) {
            $attachment = array(
                'file_name' => $_FILES['attachment']['name'],
                'tmp_name' => $_FILES['attachment']['tmp_name']
            );
            
            $tmp_attach = $this->image_lib->move_attach_file_to_tmp_location($attachment);
            
            if ($tmp_attach) {
                $success = array(
                    'response' => $tmp_attach['upload_data'],
                    'msg' => 'Moved to temporary location'
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'redirect' => site_url('admin/messages/messages'),
                    'msg' => 'Unable to move to temporary location '
                );
                $this->response($error, 200);
            }
        }
    }
    
    /*
     * 
     * name: delete_a_creative
     * @param :
     * @return :response array
     * 
     * Delete the creative in its original location
     */
    
    public function delete_a_attach_post()
    {
        $tmp_attach_name = $this->post('attach_name');
        
        if ($tmp_attach_name) {
            $is_tmp_attach = $this->image_lib->delete_attach_in_original_location($tmp_attach_name);
            
            if ($is_tmp_attach) {
                $success = array(
                    'response' => 'success',
                    'msg' => 'Temporary attachment deleted'
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'msg' => 'Unable to delete the temporary attachment file'
                );
                $this->response($error, 200);
            }
        } else {
            $error = array(
                'response' => 'error',
                'msg' => 'Unable to delete the temporary location file'
            );
            $this->response($error, 200);
        }
    }
    /*
     * 
     * name: delete_a_tmp_creative
     * @param :
     * @return :response array
     * 
     * Delete the creative in temporary location
     */
    
    public function delete_a_tmp_attach_post()
    {
        $tmp_attach_name = $this->post('attach_name');
        
        if ($tmp_attach_name) {
            $is_tmp_attach = $this->image_lib->delete_attach_in_tmp_location($tmp_attach_name);
            
            if ($is_tmp_attach) {
                $success = array(
                    'response' => 'success',
                    'msg' => 'Temporary attachment deleted'
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'msg' => 'Unable to delete the temporary attachment file'
                );
                $this->response($error, 200);
            }
        } else {
            $error = array(
                'response' => 'error',
                'msg' => 'Unable to delete the temporary location file'
            );
            $this->response($error, 200);
        }
    }
    
    /*
     * 
     * name: send_post
     * @param :
     * @return :response array
     * 
     * send message to selected user
     */
    
    public function send_post()
    {
        $account_type = $this->user_authentication->account_type;
        if ($account_type == 'ADMIN' || $account_type == 'MANAGER') {
            $this->form_validation->set_rules('account_id[]', 'User', 'required');
        }
        $this->form_validation->set_rules('subject', 'Subject', 'required|trim');
        $this->form_validation->set_rules('msg_content', 'Content', 'required|trim');
        
        if ($this->form_validation->run() === FALSE) {
            $error_msg = $this->form_validation->error_array();
            $error     = array(
                'response' => 'error',
                'msg' => $error_msg
            );
            
            $this->response($error, 200);
        } else {
            $upload = $this->post('attach_type');
            if ($upload == 'image') {
                if ($this->post('tmp_image_upload') != '') {
                    $is_attach_moved = $this->image_lib->move_attach_to_original_location($this->post('tmp_image_upload'));
                    
                    $image_name = $this->post('tmp_image_upload');
                    
                    $file_name = NULL;
                } else {
                    $image_name = NULL;
                    $file_name  = NULL;
                }
            } else if ($upload == 'file') {
                if ($this->post('tmp_file_upload') != '') {
                    $is_attach_moved = $this->image_lib->move_attach_to_original_location($this->post('tmp_file_upload'));
                    
                    $file_name = $this->post('tmp_file_upload');
                    
                    $image_name = NULL;
                } else {
                    $image_name = NULL;
                    $file_name  = NULL;
                }
            } else {
                $image_name = NULL;
                $file_name  = NULL;
            }
            
            $agency_id  = $this->user_authentication->agency_id;
            #$account_id 				=	$this->Do_message->fetch_receiever($agency_id);
            $account_id = $this->user_authentication->account_id;
            
            //$network_id				=	get_session('network_account_id');	
            $network_id = $this->Do_message->fetch_admin_network_id();
            
            if ($account_type == 'ADMIN' || $account_type == 'MANAGER') {
                // GET A/c Type & A/c Id
                $account = $this->post('account_id');
                
                foreach ($account as $key => $value) {
                    $user          = explode('-', $value);
                    $receiver_type = $user[0];
                    $receiver_id   = $user[1];
                    
                    $message_data = array(
                        'sender_id' => $account_id,
                        'receiver_id' => $receiver_id,
                        'subject' => $this->post('subject'),
                        'content' => $this->post('msg_content'),
                        'image_name' => $image_name,
                        'file_name' => $file_name,
                        'account_type' => $receiver_type,
                        'status' => '1',
                        'network_id' => $network_id,
                        'date' => date('Y-m-d H:i:s')
                    );
                    
                    $message_add = $this->Do_message->add($message_data);
                }
            } else {
                $message_data = array(
                    'sender_id' => $this->user_authentication->account_id,
                    'receiver_id' => $this->post('receiver_id'),
                    'subject' => $this->post('subject'),
                    'content' => $this->post('msg_content'),
                    'image_name' => $image_name,
                    'file_name' => $file_name,
                    'account_type' => 'ADMIN',
                    'status' => '1',
                    'network_id' => $network_id,
                    'date' => date('Y-m-d H:i:s')
                );
                
                $message_add = $this->Do_message->add($message_data);
            }
            
            if ($network_id) {
                $sent = $this->Do_message->fetch_message($account_id, $network_id, $account_type, 'sent');
            } else {
                $sent = $this->Do_message->fetch_message($account_id, '', $account_type, 'sent');
            }
            
            $sent_count = ($sent != FALSE) ? count($sent) : '';
            
            if ($message_add != FALSE) {
                $success = array(
                    'response' => 'ok',
                    'msg' => 'Message has been sent successfully!..',
                    'count' => $sent_count
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'msg' => 'Error..Please Try again.'
                );
                $this->response($error, 200);
            }
            
        }
    }
    
    /*
     * 
     * name: reply_post
     * @param :
     * @return :response array
     * 
     * reply message to selected user
     */
    
    public function reply_post()
    {
        $this->form_validation->set_rules('subject', 'Subject', 'required|trim');
        $this->form_validation->set_rules('reply_msg_content', 'Content', 'required|trim');
        
        if ($this->form_validation->run() === FALSE) {
            $error_msg = $this->form_validation->error_array();
            $error     = array(
                'response' => 'error',
                'msg' => $error_msg
            );
            
            $this->response($error, 200);
        } else {
            $upload = $this->post('attach_type');
            if ($upload == 'image') {
                if ($this->post('tmp_image_upload') != '') {
                    $is_attach_moved = $this->image_lib->move_attach_to_original_location($this->post('tmp_image_upload'));
                    
                    $image_name = $this->post('tmp_image_upload');
                    
                    $file_name = NULL;
                } else {
                    $image_name = NULL;
                    $file_name  = NULL;
                }
            } else if ($upload == 'file') {
                if ($this->post('tmp_file_upload') != '') {
                    $is_attach_moved = $this->image_lib->move_attach_to_original_location($this->post('tmp_file_upload'));
                    
                    $file_name = $this->post('tmp_file_upload');
                    
                    $image_name = NULL;
                } else {
                    $image_name = NULL;
                    $file_name  = NULL;
                }
            } else {
                $image_name = NULL;
                $file_name  = NULL;
            }
            
            //$account_id				=	get_session('account_id');
            //$network_id				=	get_session('network_account_id');
            //$account_type				=	get_session('account_type');
            
            //$agency_id					=	$this->post('agency_id');
            //$account_id 				=	$this->Do_message->fetch_receiever($agency_id);
            
            //$network_id				=	get_session('network_account_id');	
            if ($this->user_authentication->account_type == 'ADMIN' || $this->user_authentication->account_type == 'MANAGER') {
                $agency_id  = $this->user_authentication->agency_id;
                $account_id = $this->Do_message->fetch_receiever($agency_id);
            } else {
                $account_id = $this->user_authentication->account_id;
            }
            $network_id = $this->Do_message->fetch_admin_network_id();
            
            $type = (($this->post('receiver_type') == 'MANAGER') ? 'ADMIN' : $this->post('receiver_type'));
            
            $message_data = array(
                'sender_id' => $account_id,
                'receiver_id' => $this->post('receiver_id'),
                'subject' => $this->post('subject'),
                'content' => $this->post('reply_msg_content'),
                'image_name' => $image_name,
                'file_name' => $file_name,
                'account_type' => $type,
                'status' => '1',
                'network_id' => $network_id,
                'date' => date('Y-m-d H:i:s')
            );
            
            $message_reply = $this->Do_message->add($message_data);
            
            if ($network_id) {
                $sent = $this->Do_message->fetch_message($account_id, $network_id, $type, 'sent');
            } else {
                $sent = $this->Do_message->fetch_message($account_id, '', $type, 'sent');
            }
            
            $sent_count = ($sent != FALSE) ? count($sent) : '';
            
            if ($message_reply != FALSE) {
                $success = array(
                    'response' => 'ok',
                    'msg' => 'Reply Message has been sent successfully!..',
                    'count' => $sent_count
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'msg' => 'Error..Please Try again.'
                );
                $this->response($error, 200);
            }
            
        }
    }
    
    
    /*
     * 
     * name: delete_trash_post
     * @param :
     * @return success
     * 
     * Delete the message permanent from djax_message
     */
    public function delete_trash_post()
    {
        $del_msg_id = $this->post('del_msg_trash_id');
        
        if ($del_msg_id) {
            $msg_id = explode(',', $del_msg_id);
            
            if (is_array($msg_id)) {
                foreach ($msg_id as $id) {
                    $delete = $this->Do_message->delete_trash($id);
                }
            } else {
                $delete = $this->Do_message->delete_trash($msg_id);
            }
            
            if ($delete) {
                $success = array(
                    'response' => 'ok',
                    'msg' => 'Message has been deleted from trash successfully!..'
                );
                $this->response($success, 200);
            } else {
                $error = array(
                    'response' => 'error',
                    'msg' => 'Error..Please Try again.'
                );
                $this->response($error, 200);
            }
        }
    }
    
    /*
     * 
     * name: fetch_receiever_id
     * @param :
     * @return success
     * 
     * Delete the message permanent from djax_message
     */
    public function fetch_receiever_id_get()
    {
        $agency_id = $this->user_authentication->agency_id;
        if ($agency_id) {
            $receiver = $this->Do_message->fetch_receiever($agency_id);
            if ($receiver) {
                $this->response($receiver, 200);
            } else {
                $this->response(array(
                    'error' => 'No Agency Id'
                ), 404);
            }
        } else {
            $this->response(array(
                'error' => 'No Agency Id'
            ), 404);
        }
    }
    
    public function fetch_network_id_get()
    {
        $network_id = $this->Do_message->fetch_admin_network_id();
        $this->response($network_id, 200);
    }
}
