<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Manager related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Suganthi
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Manager extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_manager');
		$this->load->model('Do_app_config');
		$this->load->model('Do_email_check');
		$this->load->model('Do_networks');
		$this->load->model('Do_network_managers');
		$this->load->model('Do_roles');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	} 
	
	/**
       * 
       * name : fetch_get()
       * 
       * Fetches all manager information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_get()
	{	
		$account_id		=	$this->user_authentication->account_id;
		
		if($account_id!='')
		{
			$manager 	= 	$this->Do_manager->fetch($account_id);
		}
		 
		if($manager)
		{
			$this->response($manager,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	
	function fetch_all_manager_get()
	{
		
	  $manager 	= 	$this->Do_manager->fetch();
	
	  if($manager)
		{
			$this->response($manager,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	/**
   * 
   * name : fetch_manager_details()
   * 
   * Fetches all manager information.
   * 
   * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	public function fetch_manager_details_get()
	{
	   $account_id	= $this->user_authentication->account_id;
       $manager_name=$this->Do_manager->fetch_manager_details($account_id);
	   if($manager_name){ 
	     $this->response($manager_name,200);
		 }
	}
	
	//api/v1/manager/add
	function add_post()
	{	
		
		$this->form_validation->set_rules('manager_name','lang:managers_name', 'required|trim');
		$this->form_validation->set_rules('email', 'lang:email_add', 'required|trim|is_email|callback_email_check');
		#$this->form_validation->set_rules('manager_role', 'Manager Role','required|trim');
		$this->form_validation->set_rules('password', 'lang:user_pass','required|trim');
		$this->form_validation->set_rules('confirm_password', 'lang:confirm_password','required|trim|matches[password]');
		
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$account_id			=	get_session('account_id');
			$type='admin';
			$user_auth  		= 	$this->user_authentication;
			//$network_id		=	$user_auth->network_account_id;
			//$account_id		=	$user_auth->account_id;
			
			
			$encrypted_pwd = password_encryptor(clean_data($this->post('password')));
			$add_data		=	array(
									'name'		=>	$this->post('manager_name'),
									'email'		=>	$this->post('email'),
									#'role'		=>	$this->post('manager_role'),
									'password'	=> $encrypted_pwd,
									'manager_share'=> $this->post('manager_share'),
									'is_network'	=> 1,
									);
			$manager_add 	= 	$this->Do_manager->add_manager($add_data);
			
			if($manager_add != FALSE)
			{	
		
				/*Modified for Affiliate app configuration*/
                $agency_id      = $manager_add['agency_id'];
				$ins_app_config = $this->Do_app_config->insert_app_config($agency_id);
                /*Modified for Affiliate app configuration*/
             
				//SEND MAIL TO THE ADDED MANAGER
				$result=$this->Do_networks->get_network_details();	

						
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				$user_email    = $this->post('email');
				$password      = $this->post('password');
				$user_name     = $this->post('manager_name');
				$type     	   = "ADD_MANAGER_EMAIL";
				$from 	       =  $admin_email;
				$to  	       =  $user_email;
				
				$mail_content=array(
					"subject" 		=> $this->lang->line('mang_info'),
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,
					"password"      => $password,
					"demo_adv_username"  	=> 'Default'.''.$user_email,
					"demo_adv_password"     => $password,
					//"demo_pub_username"  	=> 'pub_'.$user_email,
					//"demo_pub_password"     => $password,
					"manager_share"   => $this->post('manager_share'),
					"agency" => $agency_id 						
					);
			
				$attachement='';	
				$bcc = '';
    			
    			$sdsf=send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
    			//print_r($sdsf);exit;
    			//$this->response( $sdsf, 200);
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('manager_added_success')
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
								);
				$this->response( $error, 200);
			}
						
		}
	}
	
	
	/**
       * 
       * name : update_post()
       * 
       * Updates the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		$account_id	=	$this->post('account_id');
		
		$this->form_validation->set_rules('manager_name','lang:managers_name', 'required|trim');
		$this->form_validation->set_rules('email', 'lang:email_add', 'required|trim|is_email|callback_edit_email_check');
		#$this->form_validation->set_rules('manager_role', 'Manager Role','required|trim');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			$this->response( $error, 200);
		}
		else
		{
			$update_data	=	array(
									'name'		=>	$this->post('manager_name'),
									'email'		=>	$this->post('email'),
									#'role'		=>	$this->post('manager_role'),
									'manager_share'=>$this->post('manager_share'),
									'hid_email_id'=>$hid_email_id
									);
									
			$manager_update = $this->Do_manager->update($account_id,$update_data);
			
			if($manager_update != FALSE)
			{	
			    //SEND MAIL TO THE UPDATED MANAGER
				$result=$this->Do_networks->get_network_details();			
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				$user_email    = $this->post('email');
				$user_name     = $this->post('manager_name');
				#$role				=	$this->post('manager_role');
				$type     	   = "UPDATE_MANAGER_EMAIL";
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content=array(
					"subject" 		 => $this->lang->line('man_updt_info'),
					"to_name" 	=> $user_name,				
					"from_name"	 => $admin_name,
					"email"  		=> $user_email,
					"manager_share"   => $this->post('manager_share')						
					);
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement,$from);
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('manager_updated_success')
									);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
									);
				$this->response( $error, 200);
			}			
		}
	}
	
	/*
	 * 
	 * name: email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	
	public function email_check()
	{
		$email		=	$this->post('email');
		
		$count		=	$this->Do_email_check->dup_email_check($email);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('email_check', $this->lang->line('email_address_exists') );
			return FALSE;	
		}
		else
		{
			return true;
		}
	}	
	
	/*
	 * 
	 * name: edit_email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	function edit_email_check()
	{
		$account_id	=	$this->post('account_id');
		$email		=	$this->post('email');
		$count 		= 	$this->Do_email_check->dup_email_check($email,$account_id);
		
		if($count>0 )
		{
			$this->form_validation->set_message('edit_email_check', $this->lang->line('email_address_exists') );
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the manager information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{	
		$account_id = $this->get('del_account_id');	
		
		if($account_id)
		{
	         //GET MANAGER DETAILS	
			$manager_details=$this->Do_manager->fetch($account_id);
			$manager 	= 	$this->Do_manager->remove($account_id);
			if($manager)
			{
			     //SEND MAIL TO THE DELETED MANAGER
				$result=$this->Do_networks->get_network_details();			
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				$user_email    = $manager_details[0]['email'];
				$user_name     =$manager_details[0]['name'];
				$type     	   = "DELETE_MANAGER_ACCOUNT";
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content=array(
					"subject" 		 => $this->lang->line('yr_acc_de-act'),
					"to_name" 	=> $user_name,				
					"from_name"	 => $admin_name,
					"email"  		=> $user_email,
					);
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement,$from);
				$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	$this->lang->line('manager_deleted_success')
									);
				
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('error_try_again')
								);
			
				$this->response( $error, 200);
			}
			
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('manager_doesnot_found')
								);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : block_get()
       * 
       * block the manager information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function block_get()
	{	
		$account_id = $this->get('block_account_id');	
		
		if($account_id)
		{
			$manager 	= 	$this->Do_manager->block($account_id);
		
			if($manager)
			{
			   
			    $manager_details 	= 	$this->Do_manager->fetch($account_id);
				//SEND MAIL TO THE BLOCKED MANAGER
				$result=$this->Do_networks->get_network_details();			
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				
				//GET MANAGER DETAILS FOR BCC
				$no_of_managers_id = $this->Do_networks->get_managers_list($account_id);
				foreach($no_of_managers_id as $agency)
				{
					$user_email    = $agency['email'];
					$user_name     = $agency['name'];
					$type     	   = "BLOCK_MANAGER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> $this->lang->line('manager_blckd'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					send_mail($type,$from,$to,$mail_content,$attachement,$from);
					$success 	= 	array('response'	=> 	'ok',
										'msg'			=> 	$this->lang->line('manager_blocked_success')
										);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
									);
				
				$this->response( $error, 200);
			}
			
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('manager_doesnot_found')
								);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : unblock_get()
       * 
       * block the manager information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function unblock_get()
	{	
		$account_id = $this->get('unblock_account_id');	
		
		if($account_id)
		{
			$manager 	= 	$this->Do_manager->unblock($account_id);
			
			if($manager)
			{
				
				$manager_details 	= 	$this->Do_manager->fetch($account_id);
				//SEND MAIL TO THE UN-BLOCKED MANAGER
				$result=$this->Do_networks->get_network_details();			
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				
				//GET MANAGER DETAILS FOR BCC
				$no_of_managers_id = $this->Do_networks->get_managers_list($account_id);
				foreach($no_of_managers_id as $agency)
				{
					$user_email    = $agency['email'];
					$user_name     = $agency['name'];
					$type     	   = "UNBLOCK_MANAGER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> $this->lang->line('mang_unblk'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					send_mail($type,$from,$to,$mail_content,$attachement,$from);
				}
				$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	$this->lang->line('manager_unblocked_success')
									);
				
				$this->response( $success, 200);
			}
			else
			{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
									);
				
				$this->response( $error, 200);
			}
			
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('manager_not_found')
								);
			
			$this->response( $error, 200);
		}
	}
	
	
	/**
       * 
       * name : fetch_users_get()
       * 
       * Fetches all manager users information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_users_get()
	{
		
		
	
		$account_id		=	$this->user_authentication->account_id;
		
		if($account_id!='')
		{
			$manager 	= 	$this->Do_manager->fetch_users($account_id);
		}
		 
		$this->response($manager,200);
		
	}
	
	/****
	 * 
	 * method : fetch_roles
	 * 
	 * Fetch the roles for the administrator
	 * 
	 * 
	 */
	function fetch_roles_get()
	{
		$roles = $this->Do_manager->fetch_roles();
		
		$this->response($roles,200);
			
	}
	
	
	/****
	 * 
	 * method : edit_fetch_roles
	 * 
	 * Fetch the roles for the administrator
	 * 
	 * get all roles even it blocked
	 */
	function edit_fetch_roles_get()
	{
		$roles = $this->Do_manager->edit_fetch_roles();
		
		$this->response($roles,200);
			
	}
	
	
	/****
	 * 
	 * method : add_user
	 * 
	 * Adds the manager user
	 * 
	 * 
	 */
	function add_user_post()
	{	
		$this->form_validation->set_rules('manager_name','lang:managers_name', 'required|trim');
		$this->form_validation->set_rules('email', 'lang:email_add', 'required|trim|is_email|callback_email_check');
		$this->form_validation->set_rules('manager_role', 'lang:managers_role','required|trim');
		$this->form_validation->set_rules('password', 'lang:user_pass','required|trim');
		$this->form_validation->set_rules('confirm_password', 'lang:confirm_password','required|trim|matches[password]');
		
		$pwd 			= $this->post('password');
		$encrypted_pwd 	= $this->encrypt->encode($pwd);
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$encrypted_pwd = password_encryptor(clean_data($this->post('password')));
			$add_data		=	array(
									'name'		=>	$this->post('manager_name'),
									'email'		=>	$this->post('email'),
									'role_id'	=>	$this->post('manager_role'),
									'password'	=>	$encrypted_pwd,
									'manager_account_id'=> $this->post('man_account_id')
									);
			
			$manager_add 	= 	$this->Do_manager->add_manager_user($add_data); // RETURN USER_ID
			//FETCH MANAGER ROLE NAME
			$manager_role 	= 	$this->Do_roles->fetch_role($this->post('manager_role'));
			if($manager_add != FALSE)
			{	
				//SEND MAIL TO THE ADDED MANAGER
				if($this->user_authentication->account_type == "ADMIN" )
				{
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->Do_networks->agency_owner_details($agency_id);	
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					// Get MANAGER EMAIL FOR BCC
					$manager_email = $this->Do_networks->get_manager_emailID($manager_add);
					$bcc =$manager_email;
				}
				else
				{
					$manager_user_id = $this->user_authentication->manager_user_id;
					$is_manager = $this->Do_networks->get_manager_role($manager_user_id);
					if($is_manager == 1)
					{
						// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->Do_networks->agency_owner_details($agency_id);
						$admin_name    = $result['name'];			
						$admin_email   = $result['email'];
						// IF NOT NETWORK ADMIN ADMIN SEND BCC
						$network_admin=$this->Do_networks->get_network_details();
						$bcc		   = $network_admin['email'];
					}
					else
					{	
						// MANAGER USERS
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->Do_networks->agency_owner_details($agency_id);
						$admin_name    = $result['name'];			
						$admin_email   = $result['email'];
						
						// Get MANAGER EMAIL FOR BCC
						$manager_email = $this->Do_networks->get_manager_emailID($manager_add);
						$bcc =$manager_email;
					}
				}
				
				$user_email    = $this->post('email');
				$password      = $this->post('password');
				$role          = $manager_role[0]['role_name'];
				$user_name     = $this->post('manager_name');
				$type     	   = "ADD_USER_MANAGER_EMAIL";
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content=array(
					"subject" 		=> $this->lang->line('Login Information'),
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"role"   		=> $role,
					"email"  		=> $user_email,
					"password"      => $pwd						
					);
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('manager_added_success')
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
								);
				$this->response( $error, 200);
			}
						
		}
	}
	
    /****
	 * 
	 * method : fetch_manager_users_get
	 * 
	 * get the manager user
	 * 
	 * 
	 */
	public function fetch_manager_users_get()
	{ 
	
	  $user_id=$this->get('user_id');
	  $account_id=$this->get('account_id');
	  $manager_users 	= 	$this->Do_manager->fetch_manager_users($user_id,$account_id);
	  if($manager_users)
	  {
	  	$this->response( $manager_users, 200); 
	  }
	}
	
	
	/****
	 * 
	 * method : update_user_post
	 * 
	 * update the manager user
	 * 
	 * 
	 */
	function update_user_post()
	{	
		$this->form_validation->set_rules('manager_name','lang:managers_name', 'required|trim');
		$this->form_validation->set_rules('manager_role', 'lang:managers_role','required|trim');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$update_data		=	array(
									'name'				=>	$this->post('manager_name'),
									'email'				=>	$this->post('email'),
									'role_id'			=>	$this->post('manager_role'),
									'manager_account_id'=>  $this->post('account_id'),
									'user_id'			=>  $this->post('user_id')
									); 
									#print_r($update_data);exit;
			$update_add 	= 	$this->Do_manager->update_manager_user($update_data);
			//$this->response($update_add,200);
			//FETCH MANAGER ROLE NAME
			$manager_role 	= 	$this->Do_roles->fetch_role($this->post('manager_role'));
			if($update_add != FALSE)
			{	
				//SEND MAIL TO THE UPDATE USER
				$result=$this->Do_networks->get_network_details();			
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				$user_email    = $this->post('email');
				$user_name     = $this->post('manager_name');
				$type     	   = "UPDATE_USER_MANAGER_EMAIL";
				$role          = $manager_role[0]['role_name'];
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content=array(
					"subject" 		=> $this->lang->line('manager_information'),
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,
					"role"   		=> $role		
					);
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement,$from);
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('mang_update_suc')
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
								);
				$this->response( $error, 200);
			}
						
		}
	}
	
		
	/****
	 * 
	 * method : block_manager_users
	 * 
	 * block the manager user
	 * 
	 * 
	 */
	public function block_manager_users_get()
	{
	   $user_id=$this->get('id');
	   $block_user=$this->Do_manager->block_manager_users($user_id);
		if($block_user)
		{
			//SEND MAIL TO THE ADDED MANAGER
			if($this->user_authentication->account_type == "ADMIN" )
			{
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->Do_networks->agency_owner_details($agency_id);	
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];
				// Get MANAGER EMAIL FOR BCC
				$manager_email = $this->Do_networks->get_manager_emailID($user_id);
				$bcc =$manager_email;
			}	
			else
			{
				$manager_user_id = $this->user_authentication->manager_user_id;
				$is_manager = $this->Do_networks->get_manager_role($manager_user_id);
				if($is_manager == 1)
				{
					// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->Do_networks->agency_owner_details($agency_id);
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->Do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
				}
				else
				{	
					// MANAGER USERS
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->Do_networks->agency_owner_details($agency_id);
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					
					// Get MANAGER EMAIL FOR BCC
					$manager_email = $this->Do_networks->get_manager_emailID($user_id);
					$bcc =$manager_email;
				}
			}
				
			//GET USER ROLE EMAIL AND THEIR NAME DETAILS
			$user_details  = $this->Do_network_managers->get_user_profile($user_id);	
			$user_role     = $user_details[0];
			
			$user_email    = $user_role['email_address'];
			$user_name     = $user_role['contact_name'];
			$type     	   = "BLOCK_USER_ROLE";
			$from 	       = $admin_email;
			$to  	       = $user_email;			
			$mail_content=array(
					"subject" 		=> $this->lang->line('yr_are_blckd'),
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,					
					);
			$attachement='';	
    		send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
				
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('sel_exe_blkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/****
	 * 
	 * method : unblock_manager_users_get
	 * 
	 * unblock the manager user
	 * 
	 * 
	 */
	public function unblock_manager_users_get()
	{
	   $user_id=$this->get('id');
	   $block_user=$this->Do_manager->unblock_manager_users($user_id);
		if($block_user)
		{
			//SEND MAIL TO THE ADDED MANAGER
			if($this->user_authentication->account_type == "ADMIN" )
			{
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->Do_networks->agency_owner_details($agency_id);	
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];
				// Get MANAGER EMAIL FOR BCC
				$manager_email = $this->Do_networks->get_manager_emailID($user_id);
				$bcc =$manager_email;
			}	
			else
			{
				$manager_user_id = $this->user_authentication->manager_user_id;
				$is_manager = $this->Do_networks->get_manager_role($manager_user_id);
				if($is_manager == 1)
				{
					// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->Do_networks->agency_owner_details($agency_id);
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->Do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
				}
				else
				{	
					// MANAGER USERS
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->Do_networks->agency_owner_details($agency_id);
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					
					// Get MANAGER EMAIL FOR BCC
					$manager_email = $this->Do_networks->get_manager_emailID($user_id);
					$bcc =$manager_email;
				}
			}
		
			//GET USER ROLE EMAIL AND THEIR NAME DETAILS
			$user_details  = $this->Do_network_managers->get_user_profile($user_id);			
			$user_role     = $user_details[0];
			$user_email    = $user_role['email_address'];
			$user_name     = $user_role['contact_name'];
			$type     	   = "UNBLOCK_USER_ROLE";
			$from 	       = $admin_email;
			$to  	       = $user_email;			
			$mail_content=array(
					"subject" 		=> $this->lang->line('yr_are_unblckd'),
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,					
					);
			$attachement='';	
    		send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('sel_exe_unblkd_succ')
							 );
			
			$this->response( $success, 200);
		}
	
	}
	
	public function get_manager_api_key_get()
	{ 
         $account_id=$this->get('account_id');
		 
		 $api_key=$this->Do_manager->get_manager_api_key($account_id);
		 
	     $this->response($api_key, 200);
	}
	
	/* Fetch the affiliate names corresponding to advertisers, publishers
	 * listed in Admin panel other than super admin advertisers & publishers
	 * 
	 * Function : fetch_agency_name_get()
	 * Parameter : account_id
	 * this is the agency id of the affiliates
	 */
	
	public function fetch_agency_name_get($account_id)
	{
		$account_id 	= 	$this->get('account_id');	
		
		if($account_id)
		{
			$agency_datas 		= 	$this->Do_manager->fetch_agency_name($account_id);
			$this->response($agency_datas,200);
		
		}
	}
	
}
