<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Manager related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Dinesh A
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Invoice extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_invoices');
		$this->load->library('default_configurations');
	}
	
	/**
       * 
       * name : generate_invoice_get()
       * 
       * Generate invoices based on start date and end date
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function generate_invoice_get()
	{	
		$start_date		=	$this->get('start_date');
		$end_date		=	$this->get('end_date');
		$period_days	=	$this->get('period_days');
		
		
		if(!empty($start_date) && !empty($end_date) && !empty($period_days))
		{
			$invoices = 	$this->Do_invoices->generate_invoices($start_date,$end_date,$period_days);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}	
	
	
	
}
