<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Inventory extends REST_Controller
{
	function __construct()
	{

		parent::__construct();
		$this->load->model('Do_inventory');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}    
	
	/**
       * 
       * name : fetch_camp_get()
       * 
       * Fetches all campaign from particular advertiser.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
    function fetch_camp_get()
	{
	
		$account_id = ($this->get('acc_id'))?$this->get('acc_id'):'';
		
			$creative_list = $this->Do_inventory->fetch($account_id);
			
			if($creative_list)
			{
			  $this->response($creative_list, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_cre')),404);
			}
		
	}
	
	/**
       * 
       * name : fetch_creatives_get()
       * 
       * Fetches all campaign from particular advertiser.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
    function fetch_creatives_get()
    {
		$campaign_id = ($this->get('camp_id'))?$this->get('camp_id'):'';
		$account_id = ($this->get('acc_id'))?$this->get('acc_id'):'';
		
			$creative_list = $this->Do_inventory->fetch_events($campaign_id,$account_id);
			
			if($creative_list)
			{
			  $this->response($creative_list, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_cre')),404);
			}
	}
	
	/*
	 * 
	 * name: run_banner_get
	 * @param :
	 * @return : $creative_id
	 * 
	 * Run the given campaign_id id
	 */
	
	function run_banner_get()
	{
		$creative_id = $this->get('run_creative_id');
		$update_data = array('status'=>0);
		if($creative_id)
		{
			$creative_status = $this->Do_inventory->admin_creative_status($creative_id,$update_data);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('creative_activate_succ')
							 );
			
			$this->response( $success, 200);
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('error_try_again')
					);
			
			$this->response( $error, 200);
		}
	}
	
	/*
	 * 
	 * name: pause_banner_get
	 * @param :
	 * @return : $creative_id
	 * 
	 * Run the given campaign_id id
	 */
	
	function pause_banner_get()
	{
		$creative_id = $this->get('pause_creative_id');
		$update_data = array('status'=>1);
		if($creative_id)
		{
			$creative_status = $this->Do_inventory->admin_creative_status($creative_id,$update_data);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('creative_paus_succ')
							 );
			
			$this->response( $success, 200);
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('error_try_again')
					);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : fetch_site_get()
       * 
       * Fetches all site from particular publisher.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
    function fetch_site_get()
    {
		$account_id = ($this->get('acc_id'))?$this->get('acc_id'):FALSE;
		
			$site_list = $this->Do_inventory->fetch_sites($account_id);
			
			if($site_list)
			{
			  $this->response($site_list, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No Sites'),404);
			}
	}
	
	/*
	 * 
	 * name: run_site_get
	 * @param :
	 * @return : $site_id
	 * 
	 * Run the given site_id
	 */
	
	function run_site_get()
	{
		$site_id = $this->get('run_site_id');
		$update_data = array('status'=>0);
		if($site_id)
		{
			$site_status = $this->Do_inventory->admin_site_status($site_id,$update_data);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('site_activate_succ')
							 );
			
			$this->response( $success, 200);
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('error_try_again')
					);
			
			$this->response( $error, 200);
		}
	}
	
	/*
	 * 
	 * name: pause_site_get
	 * @param :
	 * @return : $site_id
	 * 
	 * Run the given site_id
	 */
	
	function pause_site_get()
	{
		$site_id = $this->get('pause_site_id');
		$update_data = array('status'=>1);
		if($site_id)
		{
			$site_status = $this->Do_inventory->admin_site_status($site_id,$update_data);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('site_pas_succ')
							 );
			
			$this->response( $success, 200);
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('error_try_again')
					);
			
			$this->response( $error, 200);
		}
	}
	
	/*
	 * 
	 * name: fetch_webadblocks
	 * @param :
	 * @return : $zone_id
	 * 
	 * Run the given zone_id
	 */
	function fetch_adblocks_get()
	{
		$account_id = $this->get('account_id');
		$site_id = $this->get('site_id');	
	
		if($account_id)
		{	
			$adblock_list = $this->Do_inventory->fetch_web($site_id,$account_id);
			
			$this->response($adblock_list);	
		}
	} 
	
	/*
	 * 
	 * name: run_adblock_get
	 * @param :
	 * @return : $zone_id
	 * 
	 * Run the given zone_id
	 */
	
	function run_adblock_get()
	{
		$zone_id = $this->get('run_adblock_id');
		$update_data = array('status'=>0);
		if($zone_id)
		{
			$zone_status = $this->Do_inventory->admin_zone_status($zone_id,$update_data);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('adblock_activate_succ')
							 );
			
			$this->response( $success, 200);
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('error_try_again')
					);
			
			$this->response( $error, 200);
		}
	}
	
	/*
	 * 
	 * name: pause_adblock_get
	 * @param :
	 * @return : $site_id
	 * 
	 * Run the given site_id
	 */
	
	function pause_adblock_get()
	{
		$zone_id = $this->get('pause_adblock_id');
		$update_data = array('status'=>1);
		if($zone_id)
		{
			$zone_status = $this->Do_inventory->admin_zone_status($zone_id,$update_data);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('adblock_paus_succ')
							 );
			
			$this->response( $success, 200);
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('error_try_again')
					);
			
			$this->response( $error, 200);
		}
	}
	
	/*
	 * 
	 * name: fetch_adblocks_mobile_get
	 * @param :
	 * @return : $zone_id
	 * 
	 * Run the given zone_id
	 */
	function fetch_adblocks_mobile_get()
	{
		$account_id = $this->get('account_id');
		$site_id = $this->get('site_id');	
	
		if($account_id)
		{	
			$adblock_list = $this->Do_inventory->fetch_mobile($site_id,$account_id);
			
			$this->response($adblock_list);	
		}
	} 
    
}
