<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Geo_settings extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_geo');
		#$this->load->library('csvreader');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key');
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }

	}
	/*
	 * name: browser_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set browser targeting for a campaign
	 * 
	 */
	function fetch_get()
	{
		$geo_list = $this->Do_geo->fetch();
		$this->response($geo_list);
	}
	
	/*
   * 
   * name: block_geo_get
   * @param : categoryid
   * @return : sucess msg
   * 
   */
	public function block_geo_get()
	{
	    $geo_id=$this->get('geo_id');
		if($geo_id)
		{
			$block_geo = $this->Do_geo->block_geo_data($geo_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('geo_set_blkd_suc')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
   * 
   * name: unblock_geo_get
   * @param : categoryid
   * @return : sucess msg
   * 
   */
	public function unblock_geo_get()
	{
	    $geo_id=$this->get('geo_id');
		if($geo_id)
		{
			$unblock_geo = $this->Do_geo->unblock_geo_data($geo_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('geo_set_unblkd_suc')
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
   * 
   * name: add
   * @param : CPM value,country name
   * @return :lastinsertid
   * 
   * Fetch list of geo list
   */
   public function add_post()
   {
		$this->form_validation->set_rules('cpm_val', 'lang:cpm_value', 'required|trim');
		$this->form_validation->set_rules('cty_value', 'Country Name', 'required|trim|is_unique['.TAB_GEO_SETTING.'.value]');
		$this->form_validation->set_message('is_unique', 'Already this country name is being registered. please enter the unique one');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$geo_set = $this->Do_geo->add_geo($this->post('cpm_val'),$this->post('cty_value'));
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('os_added_suc')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('os_adding_problem')
					);
				
				$this->response( $success, 200);
			}
		}
	}
	
	/*
   * 
   * name: geo_data
   * @param : category_id
   * @return :categoryname,categoryvalue
   * 
   */
	public function geo_data_get()
	{
		$geo_id = $this->get('geo_id');
		if($geo_id)
		{
			$geo_list = $this->Do_geo->fetch_select($geo_id);
			$this->response($geo_list);
		}
	}
	
	/*
	* 
	* name: update_browser_post
	* @param : none
	* @return : browser id
	* 
	*/ 
	public function update_geo_settings_post()
	{
	    $this->form_validation->set_rules('cpm_val', 'lang:cpm_value', 'required|trim');
		$this->form_validation->set_rules('cty_value', 'lang:country_name', 'required|trim|callback_geo_list_check');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$geo_id		=   $this->post('geo_id');
			$up_val	=	array('cpm_value' =>$this->post('cpm_val'),'value' =>$this->post('cty_value'));
			$up_data = $this->Do_geo->update_geo_list($up_val,$geo_id);
			
			if($operating_sys !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('geo_set_uptd_suc')
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('prblm_updtg_geo_list')
					);
				
				$this->response( $success, 200);
			}		
		}
	}
	
	function geo_list_check()
	{
		$geo_id		=   $this->post('geo_id');
		$geo_value	=	$this->post('cty_value');
		$table_name =   TAB_GEO_SETTING;
		$count 		= 	$this->Do_geo->geo_list_sett($table_name,$geo_value,$geo_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('geo_list_check', $this->lang->line('geo_list_alrdy_exist'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}	
	}
	
	/*
   * 
   * name: delete_mobile_capability_get
   * @param : none
   * @return : status true or false
   * 
  */
	public function delete_geo_get()
	{
		$id = $this->get('geo_id');
	  
		if($id)
		{
			$manufacturer_list = $this->Do_geo->delete_geo_list($id);
	
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('geo_set_has_del')
							 );
			
			$this->response( $success, 200);
			
		}else
		{
			
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('geo_list_id_nt_fnd')
					);
			
			$this->response( $error, 200);
		}
   }
   
   
}
