<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Creatives
 *
 * Managing all type of creatives will be handelled here.
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Vigneswaran A
 * @link		http://www.djaxadserver.com
*/

class Creative extends REST_Controller
{
	
	function __construct()
	{
		parent::__construct();
		$this->load->model('Do_creative');
		$this->load->model('Do_linking');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key');
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}


	 /*
	 * 
	 * name: fetch
	 * @param :
	 * @return : $creative_list
	 * 
	 *added  on dec-12
	 */
	
	function fetch_adv_get()
	{
		$banner_id = $this->get('banner_id');

		if($banner_id)
		{
			$banner_data = $this->Do_creative->fetch_advertiser($banner_id);

			if($banner_data)
			{
			  $this->response($banner_data[0]['account_id'], 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}		
	}


	
	 /*
	 * 
	 * name: fetch
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists all the web creative of an advertiser
	 */
	
	function fetch_get($camp=FALSE)
	{
		//Get account id from library file
		if($this->user_authentication->account_type=='ADVERTISER')
		{
		 $account_id=$this->user_authentication->account_id;
		}
		else
		{
		 $account_id=$this->user_authentication->default_advertiser_account_id;
		}
		
		if($account_id)
		{
			
			if($camp)
			{
			//to fetch creative of respective campaign	
			
			$linked_creative = $this->Do_creative->fetch($account_id,$camp);
			
			if($linked_creative)
			{
				$this->response( $linked_creative, 200);
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_creatives')),404);
			}
			}
			else{
			$creative_list = $this->Do_creative->fetch($account_id);
			
			if($creative_list)
			{
				 //~ $creative_list=array_map('callbackformat',$creative_list);
				
			  $this->response($creative_list, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_creatives')),404);
			}
			}
		}
		else
		{
		  $this->response(array('error'=>$this->lang->line('no_details_found')),404);
		}
	}
	 /*
	 * 
	 * name: fetch_creative_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a web creative of an advertiser
	 */
	
	function fetch_creative_get()
	{
		//Get account id from library file
		$account_id=$this->user_authentication->account_id;
		$creative_id = $this->get('creative_id');
		
		if($account_id && $creative_id)
		{
			$creative_details = $this->Do_creative->fetch_creative($creative_id);
			if($creative_details)
			{
			  $this->response($creative_details, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details_found')),404);
			}
		}
	}
	
	/*
	 * 
	 * name: fetch_creative_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a web creative of an advertiser
	 */
	
	function fetch_video_creative_get()
	{
		//Get account id from library file
		$account_id=$this->user_authentication->account_id;
				
		if($account_id)
		{
			$creative_details = $this->Do_creative->fetch_video_creatives($account_id);
			
			if($creative_details)
			{
			  $this->response($creative_details, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details_found')),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_campaigns_get
	 * @param :
	 * @return : $campaign_list
	 * 
	 * Lists a campaigns of an advertiser
	 */
	
	function fetch_campaigns_get()
	{
		if($this->user_authentication->account_type=='ADVERTISER')
		{
		  $account_id = $this->user_authentication->account_id;
		}
		else
		{
		  $account_id = $this->user_authentication->default_advertiser_account_id;
		}
    	$campaign_type = $this->get('campaign_type');
		
		$campaign_details = $this->Do_creative->fetch_campaign($account_id,$campaign_type);
		//$this->response($this->db->last_query(),200);
		if($campaign_details)
		{
		  $this->response($campaign_details, 200); // 200 being the HTTP response code
		}
		else
		{
		  //$this->response(array('error'=>$this->lang->line('no_details_found')),404);
		  $this->response(array('error'=>'no details found'),404);
		}
	}
	function fetch_campaigns_bidding_get()
	
	
	{
		if($this->user_authentication->account_type=='ADVERTISER')
		{
		  $account_id = $this->user_authentication->account_id;
		}
		else
		{
		  $account_id = $this->user_authentication->default_advertiser_account_id;
		}
    	$campaign_type = $this->get('campaign_type');
		
		$campaign_details = $this->Do_creative->fetch_campaign_creative($account_id,$campaign_type);
		//$this->response($this->db->last_query(),200);
		if($campaign_details)
		{
		  $this->response($campaign_details, 200); // 200 being the HTTP response code
		}
		else
		{
		  //$this->response(array('error'=>$this->lang->line('no_details_found')),404);
		  $this->response(array('error'=>'no details found'),404);
		}
	}
	 /*
	 * 
	 * name: fetch_creative_dependiences_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a web creative of an advertiser
	 */
	
	function fetch_creative_dependiences_get()
	{
		//Get account id from library file
		$account_id=$this->user_authentication->account_id;
		$creative_id = $this->get('creative_id');
		
		if($account_id && $creative_id)
		{
			$creative_dependiency_data = $this->Do_creative->fetch_creative_dependiences($creative_id);
			
			if($creative_dependiency_data)
			{
			  $this->response($creative_dependiency_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details_found')),404);
			}
			
		}
	}
	
	 /*
	 * 
	 * name: delete_get
	 * @param :
	 * @return : $creative_id
	 * 
	 * Delete the given creative id
	 */
	
	function delete_get()
	{
		$creative_id = $this->get('creative_id');
		
			$this->db->select('filename');		
			$this->db->where('bannerid',$creative_id);
			$query = $this->db->get(TAB_BANNERS);		
			$result = $query->result_array();  
			
			$filename=$result[0]['filename']; 
			if($filename)
			{
				$this->image_lib->delete_creative_in_original_location($filename);
			}

			if($creative_id)
			{			
				$creative_details = $this->Do_creative->delete_creative($creative_id);
				$success = array('response'	=> 'ok',
								 'msg'		=> $this->lang->line('creative_deleted_success')
								 );
				
				$this->response( $success, 200);
				
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('site_not_found')
						);
				
				$this->response( $error, 200);
			}
	}
	
	/*
	 * 
	 * name: fetch_adblocks_get
	 * @param :
	 * @return : Array
	 * 
	 * Returns a sets off matched zones
	 */
	
	function fetch_adblocks_post()
	{
		$this->load->model('Do_linking');		
		$creative_id 	=	$this->post('creative_id');
		
		if($creative_id)
		{
			$result		=	array(	
								'response' 	=> 	'ok',
								'msg'		=> 	$this->Do_linking->fetch_adblocks($creative_id)
							);
		}
		else
		{
			$result 	= array(
							'response' 	=>	'error',
							'msg'	 	=>	$this->lang->line('creative_id_not_found')
						);
		}
		$this->response( $result, 200);
	}
	
	/*
	 * 
	 * name: linked_process_post
	 * @param :
	 * @return : Update status
	 * 
	 * Insert/Update ad-zone assoc
	 */
	function linked_process_post()
	{
		$this->load->model('Do_linking');
		
		$creative_id 	=	$this->post('creative_id');
		$zone_ids 		=	$this->post('zone_ids');
		
		if($creative_id)
		{
			$result		=	array(	
								'response' 	=> 'ok',
								'msg'		=> $this->Do_linking->linked_process($creative_id, $zone_ids)
							);
		}
		else
		{
			$result 	= 	array(
								'response' 	=>	'error',
								'msg'	 	=>	$this->lang->line('creative_id_not_found')
							);
		}		
		$this->response( $result, 200);
	}

	public function geofencing_fetch_get()
	{
		
		$campaign_id=$this->get('campaignid');
		
		$geofencing= $this->Do_creative->geofencing_fetch($campaign_id);
		$this->response( $geofencing, 200);

	}

	public function geofencing_add_post()
	{
		
		$campaign_id=$this->post('campaignid');
		$circles=$this->post('circles');

		$geofencing= $this->Do_creative->geofencing_add($campaign_id, $circles);


	}


	
}
