<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Campaign 
 * 
 * @package		ADX
 * @subpackage	Campaign API
 * @category	Controller
 * @author		Vigneswaran A
 * @link		http://www.djaxadserver.com
*/

class Campaign extends REST_Controller
{
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('Do_campaign');
		$this->load->model('Do_advertiser');
	    $this->load->model('Do_linking');
	     $this->load->model('Do_auto_link');
	    $this->load->model('Do_targeting');
        $this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
	 /*
	 * 
	 * name: fetch
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists all the campaign of an advertiser
	 */
	
	function fetch_get()
	{
		if($this->user_authentication->account_type=='ADVERTISER')
		{
		  $account_id = $this->user_authentication->account_id;
		}
		else
		{
		  $account_id = $this->user_authentication->default_advertiser_account_id;
		}
		//~ $this->response($account_id);exit;
		if($account_id)
		{
			$creative_list = $this->Do_campaign->fetch($account_id);
			
			if($creative_list)
			{
			$creative_list=array_map('callbackformat',$creative_list);//getting from formatting_ helper
			  $this->response($creative_list, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_creatives')),404);
			}
		}
	}
	
	
	 /*
	 * 
	 * name: fetch_campaign_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a particular campaign of an advertiser
	 */
	
	function fetch_campaign_get()
	{	
		$campaign_id = $this->get('campaign_id');
	
		if($campaign_id)
		{
			$campaign_data = $this->Do_campaign->fetch_campaign($campaign_id);
			
			if($campaign_data)
			{
				
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	
	
	 /*
	 * 
	 * name: fetch_houseads_campaign_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a particular campaign of an admin
	 */
	
	function fetch_houseads_campaign_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$campaign_data = $this->Do_campaign->fetch_houseads_campaign($campaign_id);
			
			if($campaign_data)
			{
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	
	
	
	/*
	 * 
	 * name: check_houseads_campaign_get
	 * @param :
	 * @return : $campaign_id
	 * 
	 * Lists a particular campaign of an admin
	 */
	
	function check_houseads_campaign_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$campaign_data = $this->Do_campaign->check_houseads_campaign($campaign_id);
			
			if($campaign_data)
			{
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	
	/*
	 * 
	 * name: get_advertiser_account
	 * @param :
	 * @return : $campaign_id
	 * added : 
	 * on : dec-10-2016
	 */
	
	function get_advertiser_account_get()
	{
		$campaign_id = $this->get('campaign_id');

		if($campaign_id)
		{
			$campaign_data = $this->Do_campaign->check_advertiser_campaign($campaign_id);
			
			if($campaign_data)
			{
			  $this->response($campaign_data[0]['account_id'], 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}	
	
	 /*
	 * 
	 * name: fetch_browser_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists browser targeting details
	 */
	
	function fetch_browser_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Client:Browser');
			$campaign_browser_data = $this->Do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_browser_data)
			{
			  $this->response($campaign_browser_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	 
	/*
	 * 
	 * name: fetch_os_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists browser targeting details
	 */
	
	function fetch_os_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Client:Os');
			$campaign_os_data = $this->Do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_os_data)
			{
			  $this->response($campaign_os_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_time_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists  time targeting details
	 */
	
	function fetch_time_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Time:Hour');
			$campaign_time_data = $this->Do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_time_data)
			{
			  $this->response($campaign_time_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_geo_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists a particular campaign of a time targeting details
	 */
	
	function fetch_geo_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Geo:Country');
			$campaign_geo_data = $this->Do_campaign->fetch_camapign_targeting($where);

			if($campaign_geo_data)
			{
			  $this->response($campaign_geo_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_profile_targeting_age_get
	 * @param :
	 * @return : $campaign_profile_age_data
	 * 
	 * Lists a particular campaign of a age targeting details
	 */
	
	function fetch_profile_targeting_age_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'profile:age');
			$campaign_profile_age_data = $this->Do_campaign->fetch_camapign_targeting($where);

			if($campaign_profile_age_data)
			{
			  $this->response($campaign_profile_age_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_profile_targeting_gender_get
	 * @param :
	 * @return : $campaign_profile_gender_data
	 * 
	 * Lists a particular campaign of a gender targeting details
	 */
	
	function fetch_profile_targeting_gender_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'gender');
			$campaign_profile_gender_data = $this->Do_campaign->fetch_camapign_targeting($where);

			if($campaign_profile_gender_data)
			{
			  $this->response($campaign_profile_gender_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_profile_targeting_color_get
	 * @param :
	 * @return : $campaign_profile_gender_data
	 * 
	 * Lists a particular campaign of a color targeting details
	 */
	
	function fetch_profile_targeting_color_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'profile:color');
			$campaign_profile_color_data = $this->Do_campaign->fetch_camapign_targeting($where);

			if($campaign_profile_color_data)
			{
			  $this->response($campaign_profile_color_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_profile_targeting_height_get
	 * @param :
	 * @return : $campaign_profile_gender_data
	 * 
	 * Lists a particular campaign of a height targeting details
	 */
	
	function fetch_profile_targeting_height_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'profile:height');
			$campaign_profile_height_data = $this->Do_campaign->fetch_camapign_targeting($where);

			if($campaign_profile_height_data)
			{
			  $this->response($campaign_profile_height_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_profile_targeting_weight_get
	 * @param :
	 * @return : $campaign_profile_gender_data
	 * 
	 * Lists a particular campaign of a weight targeting details
	 */
	
	function fetch_profile_targeting_weight_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'profile:weight');
			$campaign_profile_weight_data = $this->Do_campaign->fetch_camapign_targeting($where);

			if($campaign_profile_weight_data)
			{
			  $this->response($campaign_profile_weight_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details') ),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_mobile_os_targeting_height_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists a mobile tagetting targeting details
	 */
	
	function fetch_mobile_os_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'os');
			$campaign_mob_os_data = $this->Do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_mob_os_data)
			{
			  $this->response($campaign_mob_os_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_mobile_manu_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists manufacturer targeting details
	 */
	
	function fetch_mobile_manu_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'handset');
			$campaign_manu_data = $this->Do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_manu_data)
			{
			  $this->response($campaign_manu_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_mobile_capa_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists mobile capability targeting details
	 */
	
	function fetch_mobile_capa_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'capability');
			$campaign_capability_data = $this->Do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_capability_data)
			{
			  $this->response($campaign_capability_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_mobile_telecom_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists service providers targeting details
	 */
	
	function fetch_mobile_telecom_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'teleco');
			$campaign_telecom_data = $this->Do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_telecom_data)
			{
			  $this->response($campaign_telecom_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_mobile_geo_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists geo targeting details of a camapign
	 */
	
	function fetch_mobile_geo_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'country');
			$campaign_geo_data = $this->Do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_geo_data)
			{
			  $this->response($campaign_geo_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	
	
	/*
	 * name: add_campaign_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will create a campain
	 * 
	 */
	public function add_campaign_post()
	{ 
		//echo "<pre>"; print_r($this->post()); exit();
		$this->form_validation->set_rules('campaign_name','lang:campaign_name', 'required|trim');
		$this->form_validation->set_rules('campaign_type', 'lang:campaign_type', 'required|trim');
		//$this->form_validation->set_rules('retarget', 'Campaign type', 'required|trim');
		$this->form_validation->set_rules('campaign_schedule', 'lang:campaign_schedule', 'required|trim');
		$campaign_schedule=$this->input->post('campaign_schedule');
		
		$campaign_category=$this->input->post('campaign_category');
		
		$retarget= $this->input->post('retarget');
		$retargetting_max_time=$this->input->post('retargetting_max_time');
		if($retarget=="1")
		{
			//$this->form_validation->set_rules('retargetting_max_time', 'No of retargetting', 'required|trim');
		}		
				
				
		if($campaign_schedule=="specific")
		{
			$this->form_validation->set_rules('start_end_range', 'lang:campaign_schedule', 'required|trim');
		}
	    
		//$this->form_validation->set_rules('campaign_targeting_type', 'Targeting type', 'required|trim');
		
		$campaign_from=trim($this->post('campaign_from'));
		
		if($campaign_from!=='HOUSE_ADS_CAMPAIGN')
		{
		//	$this->form_validation->set_rules('dsp_category', 'Campaign category', 'required|trim');
			$this->form_validation->set_rules('campaign_bid_rate', 'lang:bid_rate', 'required|trim');
			$this->form_validation->set_rules('campaign_daily_budget', 'lang:daily_budget', 'required|trim');
			$this->form_validation->set_rules('campaign_budget', 'lang:campaign_budget', 'required|trim');
			$this->form_validation->set_rules('campaign_weight', 'lang:weight', 'required|trim'); 
		}
		
		if($this->form_validation->run() === FALSE)
		{
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
		
			if($this->user_authentication->account_type=='ADVERTISER')
			{
			  $client_id = $this->user_authentication->client_id;
			}
			else
			{
			  $client_id = $this->user_authentication->default_advertiser_client_id;
			}

			if($campaign_schedule=="specific")
			{
				$start_end_range = $this->input->post('start_end_range');
                $activate_expire_time = explode('-', $start_end_range);                 
				$s_date = str_replace('/', '-', $activate_expire_time[0]);
                $e_date = str_replace('/', '-', $activate_expire_time[1]);
				if(strtotime($s_date)==strtotime($e_date) && (strtotime($e_date)==null) && (strtotime($s_date)==null)){
			
						 $sep = explode(" ",$e_date );
						 $end_date=$sep[0]." "."23:59:59";
						 $start_date=$sep[0]." "."00:00:00";
						 $activate_time        = date('Y-m-d H:i:s', strtotime($start_date));
						 $expire_time          = date('Y-m-d H:i:s', strtotime($end_date)); 
				//$this->response($s_date .'1,'.$e_date);
				}
				else
				{

					$end_date= $e_date." "."23:59:59";  
					$activate_time        = date('Y-m-d H:i:s', strtotime($s_date));
					$expire_time          = date('Y-m-d H:i:s', strtotime($end_date)); 
					//$this->response($activate_time .'2,'.$expire_time);
				}
			}
			else
			{
				//$activate_time=date('Y-m-d H:i:s');
				$activate_time = mdate('%Y-%m-%d %H:%i:%s',local_to_gmt());
				$expire_time=NULL;
				//$this->response($activate_time .'3,'.$expire_time);
			}
			
			 /* Implemented for private/public bidding by jayashree.S*/
            $type_bidding = $this->input->post('type_bidding');
            if($type_bidding==0)
            {
                 $publisher_list     = $this->input->post('select_publishers');
                
                 if($publisher_list[0]!='all')
                {
                    foreach($publisher_list as $data)
                    {
                        $pub_list .= $data.',';
                    }
                    $pub_list=substr($pub_list, 0, -1);
                }
                else
                {
                    //$pub_list=$this->Do_campaign->fetch_publishersid($agency_id);
                    $pub_list='all';
                    
                }
                 $dsp_list     ='';
            }
             if($type_bidding==1)
            {
                 $pub_list     = '';
                 $dsplist     = $this->input->post('select_dsp');
                  if($dsplist!='all')
                {
                    foreach($dsplist as $data)
                    {
                        $dsp_list .= $data.',';
                    }
                    $dsp_list=substr($dsp_list, 0, -1);
                }
                else
                {
                    $dsp_list=$this->Do_campaign->fetch_dspid($agency_id);
                }
            }
             /* Implemented for private/public bidding by jayashree.S*/
			$campaign_budget=$this->input->post('campaign_budget');
			
			$status=$this->validate_campaign_status($client_id,$activate_time,$expire_time,$campaign_budget);

			if($status!='')
			{

				//CALCULATE ECPM
				
				switch ($this->input->post('campaign_type'))
				{
					case 1:
						$ecpm=$this->input->post('campaign_bid_rate');
					break;

					case 2:
						$default_click_ratio=$this->default_configurations->get('default_click_ratio');
						$ecpm=$default_click_ratio*$this->input->post('campaign_bid_rate')*1000;
					break;

					case 3:
						$default_conversion_ratio=$this->default_configurations->get('default_conversion_ratio');
						$ecpm=$default_conversion_ratio*$this->input->post('campaign_bid_rate')*1000;
					break;
				}

				//FETCH MINIMUM IMPRESSION FOR ECPM CALCULATION
				$min_impressions=$this->default_configurations->get('min_impressions_day_banner');
				$retarget_flag=$this->input->post('retargetting_max_time');
				if(isset($retarget_flag) AND !empty($retarget_flag) )
					$retargetting_max_time=$this->input->post('retargetting_max_time');
				else
					$retargetting_max_time=0;

				if($campaign_schedule=="specific")
				{
				
					$campaign_data	=	array(
											 'campaignname'			=>	stripslashes(clean_data($this->input->post('campaign_name'))),
											 'clientid'				=>	clean_data($client_id),
											 'revenue_type'			=>	clean_data($this->input->post('campaign_type')),
											 'activate_time'		=>  clean_data($activate_time),
											 'expire_time'			=>  clean_data($expire_time),
											 'dj_targetting_type'	=>  clean_data($this->input->post('campaign_targeting_type')),
											 'priority'				=>  clean_data('-2'),
											 'revenue'				=>	clean_data($this->input->post('campaign_bid_rate')),
											
											 'dj_campaign_budget'	=>	clean_data($this->input->post('campaign_budget')),
											 'dj_daily_budget'		=>	clean_data($this->input->post('campaign_daily_budget')),
											 'dj_category_id'		=>	clean_data($campaign_category),
											 'weight'				=>	clean_data($this->input->post('campaign_weight')),
											 'viewwindow'			=>	clean_data('8388607'),
											 'clickwindow'			=>	clean_data('8388607'),
											 'ecpm'					=>	clean_data($ecpm),
											 'status'				=>	clean_data($status),
											 'min_impressions'		=>	clean_data($min_impressions),
											 'dj_is_retargeted'		=>	clean_data($this->input->post('retarget')),
											 'dj_max_retargetting'	=>	clean_data($retargetting_max_time),	
											  'bidding_type' => $type_bidding,
												'affiliate_id' => $pub_list,
												'dsplist' => $dsp_list, 
												'dj_is_rtb_campaign' => $type_bidding,  										 
											 'dj_added_date'  		=> 	date('Y-m-d H:i:s'),
											
										);
				}
				else
				{
					$campaign_data	=	array(
											 'campaignname'			=>	stripslashes(clean_data($this->input->post('campaign_name'))),
											 'clientid'				=>	clean_data($client_id),
											 'revenue_type'			=>	clean_data($this->input->post('campaign_type')),
											 'activate_time'		=>  clean_data($activate_time),
											 'expire_time'			=>  $expire_time,
											 'dj_targetting_type'	=>  clean_data($this->input->post('campaign_targeting_type')),
											 'priority'				=>  clean_data('-2'),
											 'revenue'				=>	clean_data($this->input->post('campaign_bid_rate')),
											
											 'dj_campaign_budget'	=>	clean_data($this->input->post('campaign_budget')),
											 'dj_daily_budget'		=>	clean_data($this->input->post('campaign_daily_budget')),
											 'dj_category_id'		=>	clean_data($campaign_category),
											 'weight'				=>	clean_data($this->input->post('campaign_weight')),
											 'viewwindow'			=>	clean_data('8388607'),
											 'clickwindow'			=>	clean_data('8388607'),
											 'ecpm'					=>	clean_data($ecpm),
											 'status'				=>	clean_data($status),
											 'min_impressions'		=>	clean_data($min_impressions),
											 'dj_is_retargeted'		=>	clean_data($this->input->post('retarget')),
											 'dj_max_retargetting'	=>	clean_data($retargetting_max_time),
											  'bidding_type' => $type_bidding,
											'affiliate_id' => $pub_list,
											'dsplist' => $dsp_list,  
											'dj_is_rtb_campaign' => $type_bidding,   
											 'dj_added_date'  		=> 	date('Y-m-d H:i:s'),
											
										);

				}
				
				
				if($this->post('_campaign_id')=='')
				{
					$campaign_id= $this->Do_campaign->add_new_campaign($campaign_data,$client_id);
				}
				else
				{
					$campaign_id=$this->post('_campaign_id');
								
					unset($campaign_data['dj_targetting_type']);
				
					$campaign_edit= $this->Do_campaign->edit_campaign($campaign_data,$client_id,$campaign_id);
				}
					
				if($campaign_id)
				{
					$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('camp_suc_added'),
									'redirect'	 => site_url('advertiser/campaigns'),
									'campaign_id'	 => $campaign_id,
									'status'=>$status,
									'activation_time' =>clean_data($activate_time),
									'expiration_time'	=>  clean_data($expire_time)
									);
					$this->response( $success, 200);
				}
				else
				{
					$error = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('error_try_again'),
									'redirect'	 => site_url('advertiser/campaigns'),
									);	
					$this->response( $error, 200);
				}
			}
			else
				{
					$error = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('error_try_again'),
									//'redirect'	 => site_url('advertiser/campaigns'),
									);	
					$this->response( $error, 200);
				}
		}
		
	}

	/*
	 * name: edit_campaign_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will edit a campain
	 * 
	 */
	 
	public function edit_campaign_post()
	{
		//echo $this->input->post('campaign_type'); exit();
		$this->form_validation->set_rules('campaign_name','lang:campaign_name', 'required|trim');
		$this->form_validation->set_rules('campaign_type', 'lang:campaign_type', 'required|trim');
		//$this->form_validation->set_rules('campaign_schedule', 'Campaign schedule', 'required|trim');
		$campaign_schedule=$this->input->post('campaign_schedule');
		$campaign_category=$this->input->post('campaign_category');
		
		
		$retarget= $this->input->post('retarget');
		//$retargetting_max_time=$this->input->post('retargetting_max_time');
		if($retarget=="1")
		{
			//$this->form_validation->set_rules('retargetting_max_time', 'No of retargetting', 'required|trim');
		}		
		if($campaign_schedule=="specific")
		{
		$this->form_validation->set_rules('start_end_range', 'lang:campaign_schedule', 'required|trim');
		}
	    
	//	$this->form_validation->set_rules('campaign_targeting_type', 'Targeting type', 'required|trim');
		
		$campaign_from=trim($this->post('campaign_from'));

		if($campaign_from!=='HOUSE_ADS_CAMPAIGN')
		{
			
		//	$this->form_validation->set_rules('dsp_category', 'Campaign category', 'required|trim');
			$this->form_validation->set_rules('campaign_bid_rate', 'lang:bid_rate', 'required|trim');
			$this->form_validation->set_rules('campaign_daily_budget', 'lang:daily_budget', 'required|trim');
			$this->form_validation->set_rules('campaign_budget', 'lang:campaign_budget', 'required|trim');
			$this->form_validation->set_rules('campaign_weight', 'lang:weight', 'required|trim'); 
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			//Get client id from library 
			if($this->user_authentication->account_type=='ADVERTISER')
			{
			  $client_id = $this->user_authentication->client_id;
			}
			else
			{
			  $client_id = $this->user_authentication->default_advertiser_client_id;
			}
			
			if($campaign_schedule=="specific")
			{
				$start_end_range = $this->input->post('start_end_range');
				//$this->response($start_end_range); exit;
                $activate_expire_time = explode('-', $start_end_range);       
                $s_date = str_replace('/', '-', $activate_expire_time[0]);
                $e_date = str_replace('/', '-', $activate_expire_time[1]);
                //$this->response($s_date);

				if (strtotime($s_date)==strtotime($e_date) && strtotime($e_date)==null && strtotime($s_date)==null)
				{
					
						$sep = explode(" ",$e_date );
						 
						 $end_date=$sep[0]." "."23:59:59";
						 $start_date=$sep[0]." "."00:00:00";
						 $activate_time        = date('Y-m-d H:i:s', strtotime($start_date));
						
						 $expire_time          = date('Y-m-d H:i:s', strtotime($end_date)); 
						
				}
				else
				{
						
					$end_date= $e_date." "."23:59:59";  
					$activate_time        = date('Y-m-d H:i:s', strtotime($s_date));
					$expire_time          = date('Y-m-d H:i:s', strtotime($end_date)); 
					
				}
				
                
			}
			elseif($campaign_schedule=="start_immediately")
			{
				$activate_time=$this->input->post('camp_act');
				$expire_time=NULL;
			}
			else{
				
				$datepicker = $this->input->post('date_end');
				$activate	=$this->input->post('camp_act');
				
				$hid_expire_time	=$this->input->post('hid_expire_time');
				if($datepicker)
				{
				$date_end =$datepicker." "."23:59:59";
				}
				else
				{
				$date_end =$hid_expire_time." "."23:59:59";	
				}
				
				$expire_time          = date('Y-m-d H:i:s', strtotime($date_end)); 
				$activate_time		  =date('Y-m-d H:i:s', strtotime($activate));
				//$this->response($expire_time );
			}
			
			
			#$status='0';
			$campaign_budget=$this->input->post('campaign_budget');	
			
			  /* Implemented for private/public bidding by jayashree*/
            $type_bidding = $this->input->post('type_bidding');
            if($type_bidding==0)
            {
                 $publisher_list     = $this->input->post('select_publishers');
                
                 if($publisher_list[0]!='all')
                {
                    foreach($publisher_list as $data)
                    {
                        $pub_list .= $data.',';
                    }
                    $pub_list=substr($pub_list, 0, -1);
                }
                else
                {
                    //$pub_list=$this->Do_campaign->fetch_publishersid($agency_id);
                    
                    $pub_list='all';
                    
                }
                 $dsp_list     ='';
            }
             if($type_bidding==1)
            {
                 $pub_list     = '';
                 $dsplist     = $this->input->post('select_dsp');
                  if($dsplist!='all')
                {
                    foreach($dsplist as $data)
                    {
                        $dsp_list .= $data.',';
                    }
                    $dsp_list=substr($dsp_list, 0, -1);
                }
                else
                {
                    $dsp_list=$this->Do_campaign->fetch_dspid($agency_id);
                }
            }
             /* Implemented for private/public bidding by jayashree*/
            
			/*
			 * Check Campaign Status and Update
			 */
			if($this->post('_camp_status')==0)
			{
				$status = $this->post('_camp_status');
			}else{
				$status=$this->validate_campaign_status($client_id,$activate_time,$expire_time,$campaign_budget);
				
			}
			
			//CALCULATE ECPM
				
				switch ($this->input->post('campaign_type'))
				{
					case 1:
						$ecpm=$this->input->post('campaign_bid_rate');
					break;

					case 2:
						$default_click_ratio=$this->default_configurations->get('default_click_ratio');
						$ecpm=$default_click_ratio*$this->input->post('campaign_bid_rate')*1000;
					break;

					case 3:
						$default_conversion_ratio=$this->default_configurations->get('default_conversion_ratio');
						$ecpm=$default_conversion_ratio*$this->input->post('campaign_bid_rate')*1000;
					break;
				}
			
			//FETCH MINIMUM IMPRESSION FOR ECPM CALCULATION
			$min_impressions=$this->default_configurations->get('min_impressions_day_banner');
			$retarget_flag=$this->input->post('retargetting_max_time');
				if(isset($retarget_flag) AND !empty($retarget_flag) )
					$retargetting_max_time=$this->input->post('retargetting_max_time');
				else
					$retargetting_max_time=0;

		
			if($status!='')
			{
					
				if($campaign_schedule=="specific")
				{
					//~ $activate_time=gmdate("Y-m-d h:i:s");
					$campaign_data	=	array(
											 'campaignname'			=>	stripslashes(clean_data($this->input->post('campaign_name'))),
											 'revenue_type'			=>	clean_data($this->input->post('campaign_type')),
											 'activate_time'		=>  clean_data($activate_time),
											 'expire_time'			=>  clean_data($expire_time),
											 'dj_targetting_type'	=>  clean_data($this->input->post('campaign_targeting_type')),
											 'revenue'				=>	clean_data($this->input->post('campaign_bid_rate')),
											 'dj_campaign_budget'	=>	clean_data($this->input->post('campaign_budget')),
											 
											 'dj_daily_budget'		=>	clean_data($this->input->post('campaign_daily_budget')),
											 'weight'				=>	clean_data($this->input->post('campaign_weight')),
											 'dj_category_id'		=>	clean_data($campaign_category),
											 'status'				=>	clean_data($status),
											 'ecpm'					=>	clean_data($ecpm),
											 'min_impressions'		=>	clean_data($min_impressions),
											  'dj_is_retargeted'		=>	clean_data($this->input->post('retarget')),
'bidding_type' => $type_bidding,
                        'affiliate_id' => $pub_list,
                     
                        'dsplist' => $dsp_list											 
											);
				}
				elseif($campaign_schedule=="start_immediately")
				{
				//~ $activate_time=gmdate("Y-m-d h:i:s");
				$campaign_data	=	array(
											 'campaignname'			=>	stripslashes(clean_data($this->input->post('campaign_name'))),
											 'revenue_type'			=>	clean_data($this->input->post('campaign_type')),
											 'activate_time'		=>  clean_data($activate_time),
											 'expire_time'			=>  $expire_time,
											 'dj_targetting_type'	=>  clean_data($this->input->post('campaign_targeting_type')),
											 'revenue'				=>	clean_data($this->input->post('campaign_bid_rate')),
											 'dj_campaign_budget'	=>	clean_data($this->input->post('campaign_budget')),
											 
											 'dj_daily_budget'		=>	clean_data($this->input->post('campaign_daily_budget')),
											 'weight'				=>	clean_data($this->input->post('campaign_weight')),
											 'dj_category_id'		=>	clean_data($campaign_category),
											 'status'				=>	clean_data($status),
											 'ecpm'					=>	clean_data($ecpm),
											 'min_impressions'		=>	clean_data($min_impressions),
											  'dj_is_retargeted'		=>	clean_data($this->input->post('retarget')),
											 'dj_max_retargetting'	=>	clean_data($retargetting_max_time),
											 'bidding_type' => $type_bidding,
                        'affiliate_id' => $pub_list,
                        'dj_is_rtb_campaign' => $type_bidding, 
                         
                        'dsplist' => $dsp_list			
											);	
				}
				else
				{
					$campaign_data	=	array(
											 'campaignname'			=>	stripslashes(clean_data($this->input->post('campaign_name'))),
											 'revenue_type'			=>	clean_data($this->input->post('campaign_type')),
											// 'activate_time'		=>  clean_data($activate_time),
											 'expire_time'			=>  $expire_time,
											 'dj_targetting_type'	=>  clean_data($this->input->post('campaign_targeting_type')),
											 'revenue'				=>	clean_data($this->input->post('campaign_bid_rate')),
											 'dj_campaign_budget'	=>	clean_data($this->input->post('campaign_budget')),
											 
											 'dj_daily_budget'		=>	clean_data($this->input->post('campaign_daily_budget')),
											 'weight'				=>	clean_data($this->input->post('campaign_weight')),
											 'dj_category_id'		=>	clean_data($campaign_category),
											 'status'				=>	clean_data($status),
											 'ecpm'					=>	clean_data($ecpm),
											 'min_impressions'		=>	clean_data($min_impressions),
											  'dj_is_retargeted'		=>	clean_data($this->input->post('retarget')),
											 'dj_max_retargetting'	=>	clean_data($retargetting_max_time),	
											  'bidding_type' => $type_bidding,
                        'affiliate_id' => $pub_list,
                        'dj_is_rtb_campaign' => $type_bidding,
                        
                        'dsplist' => $dsp_list		
											);
				}
				
				$campaign_id=$this->post('_campaign_id');
				$campaign_edit= $this->Do_campaign->edit_campaign($campaign_data,$client_id,$campaign_id);
				// Unlink internal publishers zone when creating ssp campaign
				if($type_bidding==1)
				{
					$this->Do_auto_link->unlink_blocks_placement($campaign_id);
					$banners = $this->Do_campaign->fetch_creative($campaign_id);
					if($banners!=FALSE)
					{
						foreach($banners as $b)
						{
							$this->Do_auto_link->unlink_blocks($b['bannerid']);
						}
					}
					
				}
					
				if($campaign_edit)
				{
					$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('camp_suc_updated'),
									'redirect'	 => site_url('advertiser/campaigns'),
									'campaign_id'	 => $campaign_id,
									'status'	=> $status
									);
					$this->response( $success, 200);
				}
				else
				{
					$error = array(
									'response' => 'error',
									'msg'	 => $this->lang->line('error_try_again'),
									'redirect'	 => site_url('advertiser/campaigns'),
									);	
					$this->response( $error, 200);
				}
			}
		}
		
	}
	 /*
	 * 
	 * name: delete_get
	 * @param :
	 * @return : $creative_id
	 * 
	 * Delete the given campaign_id id
	 */
	 
	 
	
	function delete_get()
	{
		$campaign_id = $this->get('campaign_id');

		if($campaign_id)
		{
			$campaign_details = $this->Do_campaign->delete_campaign($campaign_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('campaign_deleted_success')
							 );
			
			$this->response( $success, 200);
			
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('error_try_again')
					);
			
			$this->response( $error, 200);
		}
	}
	 /*
	 * 
	 * name: run_get
	 * @param :
	 * @return : $campaign_id
	 * 
	 * Run the given campaign_id id
	 */
	
	function run_get()
	{
		$campaign_id = $this->get('run_campaign_id');
		//check house ad campaign
		if($this->get('hs') ==1)
		{
			$campaign_data = $this->Do_campaign->fetch_houseads_campaign($campaign_id);
		}else
		{
			$campaign_data = $this->Do_campaign->fetch_campaign($campaign_id);
		}	
		
		$client_id=$campaign_data[0]['clientid'];
		$activate_time= $campaign_data[0]['activate_time'];
		$expire_time=$campaign_data[0]['expire_time'];
		$campaign_budget=$campaign_data[0]['dj_campaign_budget'];
//~ $this->response($campaign_data); exit;
		$status=$this->validate_campaign_status($client_id,$activate_time,$expire_time,$campaign_budget);
		
		//~ z$this->response($status,200); 

		$update_data=array("status"=>$status);

		if($campaign_id)
		{
			$campaign_details = $this->Do_campaign->camapign_status($campaign_id,$update_data);
			
			if($status ==0)
			{
				$success = array('response'	=> 'info',
								 'msg'		=> $this->lang->line('account_balance_run_campaign')
								 );
			}else if($status ==2){
				$success = array('response'	=> 'info',
								 'msg'		=> $this->lang->line('awaiting_status_run').' '.date('dS M, Y',strtotime(str_replace('/','-',($activate_time)))).''
								 );	
			}else{	
				$success = array('response'	=> 'ok',
								 'msg'		=> $this->lang->line('campaign_activated_success')
								 );
			}
			
			$this->response( $success, 200);
			
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('error_try_again')
					);
			
			$this->response( $error, 200);
		}
	}
	 /*
	 * 
	 * name: pause_get
	 * @param :
	 * @return : $campaign_id
	 * 
	 * Delete the given campaign_id 
	 */
	
	function pause_get()
	{
		$campaign_id = $this->get('pause_campaign_id');

		/*$campaign_data = $this->Do_campaign->fetch_campaign($campaign_id);

		$client_id=$campaign_data[0]['clientid'];
		$activate_time=$campaign_data[0]['activate_time'];
		$expire_time=$campaign_data[0]['expire_time'];
		$campaign_budget=$campaign_data[0]['dj_campaign_budget'];

		$status=$this->validate_campaign_status($client_id,$activate_time,$expire_time,$campaign_budget);*/
		
		$update_data=array("status"=>'0');

		if($campaign_id)
		{
			$campaign_details = $this->Do_campaign->camapign_status($campaign_id,$update_data);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> $this->lang->line('campaign_paused_success')
							 );
			
			$this->response( $success, 200);
			
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('error_try_again')
					);
			
			$this->response( $error, 200);
		}
	}
	
	
		
	/*
	 * name: complete_campaign_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will update the campaign wizard status when all the campaign is set up is completed
	 * 
	 */
	public function complete_campaign_post()
	{
		$campaign_id = $this->post('_campaign_id');
		
		if(!empty($campaign_id))
		{
			$campaign_status_data	=	array('dj_wizard_status'=>clean_data('1'));
			
			$campaign_completed = $this->Do_campaign->complete_campaign($campaign_id,$campaign_status_data);
			if($campaign_completed)
			{
				$success = array(
									'response' => 'ok',
									'msg'	 => $this->lang->line('camp_suc_added'),
									'redirect'	 => site_url('advertiser/campaigns'),
									);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/campaigns'),
								);	
				$this->response( $error, 200);
			}
		}
		else
		{
			$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/campaigns'),
								);	
			$this->response( $error, 200);
			
		}
	}
	
	/*
	 * name: fetch_linked_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the creatives linked to given campaign id
	 * 
	 */
	public function fetch_linked_creative_get()
	{
		$campaign_id = $this->get('campaign_id');
		
		if(!empty($campaign_id))
		{
			$existing_creative = $this->Do_campaign->fetch_linked_creative($campaign_id);
			//$this->response($existing_creative,200);
			if($existing_creative)
			{
				$this->response( $existing_creative, 200);
			}
		}
		else
		{
			$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/campaigns'),
								);	
			$this->response( $error, 200);
			
		}
	}
		
	
	/*
	 * name: validate_campaign_status
	 * @param
	 * @return:response array
	 * 
	 * In this method will link a creative to campaign
	 * 
	 */
	public function validate_campaign_status($client_id=false, $activate_time=false,$expire_time=false,$campaign_budget=false)
	{
		
		if(!empty($client_id) AND !empty($activate_time) ) //  AND !empty($campaign_budget)
		{
			//Check list for default advertiser
			
			$is_default_advertiser  	= 	$this->Do_advertiser->is_default_advertiser($client_id);
			$current_date=date('Y-m-d H:i:s');

			if($is_default_advertiser==FALSE AND !empty($campaign_budget))
			{
				$payment_type  	= 	$this->Do_advertiser->payment_type($client_id);

				if($payment_type['dj_payment_type']=='1')
					$payment_type="PREPAID";
				else
					$payment_type="POSTPAID";
				switch($payment_type)
				{
					case "PREPAID":
					
						$advertiser_balance  	= 	$this->Do_advertiser->current_balance($client_id);
						$account_balance=$advertiser_balance['dj_cur_balance'];
						

						//$this->response($campaign_budget); exit;
						if($account_balance<$campaign_budget)
							$status='0';//Low balance =>Campaign paused
						else 
						{
							//Has enough balance , go through.
							if($expire_time==NULL)//Don't expire
							{
								$flag_1=strtotime($activate_time);
								$flag_2=strtotime($current_date);
								//~ $this->response($activate_time ."--". $current_date); exit;
								if($flag_1 <= $flag_2)
								
									//Date is in the past =>Campaign running
									 $status='1';
								else
								
									 //Date is in the future =>Campaign awaiting
									 $status='2';
							}
							else
							{
								
								//If end date available
								$flag_1=strtotime($activate_time);
								$flag_2=strtotime($current_date);
								if($flag_1 <= $flag_2)
								{
									$flag_3=strtotime($expire_time);
									$flag_4=strtotime($current_date);

									if($flag_3 <= $flag_4)
										//Date is in the past =>Campaign completed
										$status='3';
									else
										//Date is in the future =>Campaign running
										$status='1';
								}
								else
									//Date is in the future =>Campaign awaiting
									$status='2';
							}
						}
					break;
					
					case "POSTPAID":

						//He is apost paid user
						if($expire_time==NULL)//Don't expire
						{
							$flag_1=strtotime($activate_time);
							$flag_2=strtotime($current_date);
							if($flag_1 <= $flag_2)
								 //Date is in the past =>Campaign running
								 $status='1';
							else
								  //Date is in the future =>Campaign awaiting
								 $status='2';
						}
						else
						{
							//If end date available
							$flag_1=strtotime($activate_time);
							$flag_2=strtotime($current_date);
							if($flag_1 <= $flag_2)
							{
								$flag_3=strtotime($expire_time);
								$flag_4=strtotime($current_date);

								if($flag_3 <= $flag_4)
									//Date is in the past =>Campaign completed
									$status='3';
								else
									//Date is in the future =>Campaign running
									$status='1';
							}
							else
								//Date is in the future =>Campaign awaiting
								$status='2';
						}
					
					break;
				}
				return $status;
			}
			else if($is_default_advertiser)
			{
				//He is default advertiser
				if($expire_time==NULL)//Don't expire
				{
					$flag_1=strtotime($activate_time);
					$flag_2=strtotime($current_date);
					if($flag_1 <= $flag_2)
						 //Date is in the past =>Campaign running
						 $status='1';
					else
						  //Date is in the future =>Campaign awaiting
						 $status='2';
				}
				else
				{
					//If end date available
					$flag_1=strtotime($activate_time);
					$flag_2=strtotime($current_date);
					if($flag_1 <= $flag_2)
					{
						$flag_3=strtotime($expire_time);
						$flag_4=strtotime($current_date);

						if($flag_3 <= $flag_4)
							//Date is in the past =>Campaign completed
							$status='3';
						else
							//Date is in the future =>Campaign running
							$status='1';
					}
					else
						//Date is in the future =>Campaign awaiting
						$status='2';
				}
				
				return $status;
			}
		}
		else
			return false;
	}
	/*
	 * name: link_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will link a creative to campaign
	 * 
	 */
	public function link_creative_post()
	{
		$campaign_id=$this->post('_campaign_id');
		$creative_id=$this->post('creative_id');

		if(!empty($campaign_id)  AND !empty($creative_id))
		{
			$campaign_crative_link= $this->Do_campaign->add_campaign_creative_assoc($campaign_id,$creative_id);

			if($campaign_crative_link)
			{
				$success = array(
							'response' => 'ok',
							'msg'	 => $this->lang->line('crtv_linked_suc'),
							'redirect'	 => site_url('advertiser/campaigns'),
							'campaign_id'	 => $campaign_id,
							);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/campaigns'),
								);	
				$this->response( $error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('error_try_again'),
							'redirect'	 => site_url('advertiser/campaigns'),
							);	
			$this->response( $error, 200);
		}
	}
	/*
	 * name: fetch_tracker_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch campaign trackers
	 * 
	 */
	public function fetch_tracker_get()
	{
		$campaign_id=$this->get('campaign_id');

		if(!empty($campaign_id))
		{
			$tracker= $this->Do_campaign->fetch_campaign_tracker($campaign_id);

			if($tracker)
			{
				$tracker=$tracker[0]['trackerid'];
				$this->response( $tracker, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => $this->lang->line('error_try_again'),
								'redirect'	 => site_url('advertiser/campaigns'),
								);	
				$this->response( $error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('error_try_again'),
							'redirect'	 => site_url('advertiser/campaigns'),
							);	
			$this->response( $error, 200);
		}
	}
	
	/*
	 * name: fetch_sel_camp_targeting_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the associated targeting with this campaign
	 * 
	 */
	
	public function fetch_sel_camp_targeting_get()
	{
			
		
	}
	
	
	
	
	
	/*
     *
     * name: fetch
     * @param :
     * @return : $creative_list
     *
     * Lists all the campaign of an advertiser
    */
    function fetch_inventory_campaign_get() 
    {
        if ($this->user_authentication->account_type == 'ADVERTISER') 
        {
            $account_id = $this->user_authentication->account_id;
        }
        else
        {
            $acntid = $this->get('acc_id');
            $account_id = isset($acntid) ? $acntid : '';
        }
        $creative_list = $this->Do_campaign->fetch_inventory_campaign($account_id);
        if ($creative_list) 
        {
            $this->response($creative_list, 200); // 200 being the HTTP response code
            
        }
        else
        {
            $this->response(array(
                'error' => 'No creatives'
            ) , 404);
        }
    }
    
  function fetch_adblocks_post()//Manual LInking
{

		$campaign_id = $this->post('campaign_id');
        $agency_id     = $this->user_authentication->agency_id; 
        if ($campaign_id)
        {
            $result = array(
                'response' => 'ok',
                'msg' => $this->Do_linking->fetch_adblocks_campaign($campaign_id,$agency_id)
            ); 

        }
        else
        {
            $result = array(
                'response' => 'error',
                'msg' => $this->lang->line('camp_not_found')
            );
        }
        $this->response($result, 200);



}
    
	function linked_process_post() //Manual LInking
    {
       
        $campaign_id = $this->post('campaign_id');
      	$zone_ids    = $this->post('zone_ids');
      
        if ($campaign_id)
        {
			
			$res = $this->Do_linking->linked_campaign_process($campaign_id, $zone_ids);
			
			$result = array(
                'response' => 'ok',
                'msg' => $res
            );
        }
        else
        {
            $result = array(
                'response' => 'error',
                'msg' => $this->lang->line('camp_not_found')
            );
        }
        $this->response($result, 200);
    }
	/*
	 * name: add_campaign_favourite_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will create a campain
	 * 
	 */
	public function add_campaign_favourite_post()
	{
	
		$campaign_id=$this->post('campaign_id');
		//$creative_id=$this->post('creative_id');

		if(!empty($campaign_id)  )
		{
	
		//Hour targeting
					$hour_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Time:Hour",
											"comparison"	=> 	"=~",
											"data"			=> 	$this->post('targ_time'),
											"executionorder"=> 	11,
										);
					
					//Daypart Targeting
					$daypart_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"deliveryLimitations:Time:Day",
												"comparison"	=> 	"=~",
												"data"			=> 	FALSE,
												"executionorder"=> 	11,
											);
					//$hour = 	implode(',',($this->post('targ_time')));
					$days=array();$hours=array();		
					if(($this->post('day_targ'))=='Y')
					{
							
					$daypart_time = 	implode(',',($this->post('daypart_time')));
					$daypart_times = 	explode(',',$daypart_time);	
					foreach($daypart_times as $key=>$value){
						$day_hour = 	explode('_',$value);
						 if(!in_array($day_hour[0], $days)){
								$days[]=$day_hour[0];
							}
							if(!in_array($day_hour[1], $hours)){
								$hours[]=$day_hour[1];
							}	
						$daysdsd .= $day_hour[0].",";
						$hourssd .= $day_hour[1].",";
					}
					$imp_days = 	implode(',',$days);
					$imp_hours = 	implode(',',$hours);
					//$this->response($imp_hours, 200); 
					
						if(!empty($daypart_time))
						{						
							$hour = 	$daypart_time;
							if($hour)
							{
								$hour_data['data']	=	$daypart_time;
								//$this->response($hour_data, 200); 
								$res=$this->Do_targeting->add($hour_data,$campaign_id);
							}
							else
							{
								$res=$this->Do_targeting->delete($hour_data,$campaign_id);
							}
						}
						else
						{
							$res=$this->Do_targeting->delete($hour_data,$campaign_id);
						}		
						if(!empty($this->post('daypart_time')))
						{						
							$daypart_time = 	implode(',',($this->post('daypart_time')));
							
							if($daypart_time)
							{
								$daypart_time_data	=	array('dj_weekly_distribute'=>$daypart_time);
								
								$this->Do_campaign->add_campaign_favourite($campaign_id,$daypart_time_data);
							}
							else
							{
								$daypart_time_data	=	array('dj_weekly_distribute'=>'');
								
								$this->Do_campaign->add_campaign_favourite($campaign_id,$daypart_time_data);
							}
						}
						else
						{
							$daypart_time_data	=	array('dj_weekly_distribute'=>'');
							
							$this->Do_campaign->add_campaign_favourite($campaign_id,$daypart_time_data);
						}
					}	
					else
					{
						
						$this->Do_targeting->delete($hour_data,$campaign_id);
						$this->Do_targeting->delete($daypart_data,$campaign_id);
						$daypart_time_data	=	array('dj_weekly_distribute'=>'');
							
						$this->Do_campaign->add_campaign_favourite($campaign_id,$daypart_time_data);
					}	
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	$this->lang->line('camp_targ_suc'),
									
									'campaign_id'	=> 	$campaign_id,
								
									);
					$this->response( $success, 200);
				}
				
				
			}	
			/*function:fetch city values for overview page
	 
	 * Name:Murugeswari
	 * Date:22-06-2017
	 * 
	 */
	function fetch_city_targeting_get()
    {
        $campaign_id = $this->get('campaign_id');
        if ($campaign_id) {
            $type              = 'city';
            $where             = array(
                'campaignid' => $campaign_id,
                'type' => $type
            );
            $campaign_geo_data = $this->Do_campaign->fetch_camapign_targeting($where);
            if ($campaign_geo_data) {
                $this->response($campaign_geo_data, 200); // 200 being the HTTP response code
            } else {
                $this->response(array(
                    'error' => $this->lang->line('no_details')
                ), 404);
            }
        }
    }
     /*
     * 
     * name: fetch_profile_targeting_keyword_get
     * @param :
     * @return : $campaign_profile_keyword_data
     * 
     * Lists a particular campaign of a keyword targeting details
     */
    function fetch_profile_targeting_keyword_get()
    {
        $campaign_id = $this->get('campaign_id');
        if ($campaign_id) {
            $where                         = array(
                'campaignid' => $campaign_id,
                'type' => 'keyword'
            );
            $campaign_profile_keyword_data = $this->Do_campaign->fetch_camapign_targeting($where);
            if ($campaign_profile_keyword_data) {
                $this->response($campaign_profile_keyword_data, 200); // 200 being the HTTP response code
            } else {
                $this->response(array(
                    'error' => 'No details'
                ), 200);
            }
        }
    }

	/*
     * 
     * name: fetch_segment_targeting_get
     * @param :
     * 
     * Fetch Segment Targeting
     */
    function fetch_segment_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		
		if($campaign_id)
		{
			
			$where=array('campaignid'=>$campaign_id,'type'=>'segment');
			
			$campaign_segment_data = $this->Do_campaign->fetch_camapign_targeting($where);
			
		
			if($campaign_segment_data)
			{
			  $this->response($campaign_segment_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}		
	
	/*
	 * 
	 * name: fetch_mobile_telecom_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists service providers targeting details
	 */
	
	function fetch_site_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'site');
			$site_details = $this->Do_campaign->fetch_camapign_targeting($where);
			
			if($site_details)
			{
			  $this->response($site_details, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	
	
	function fetch_sentiment_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'sentiment');
			$sentiment_details = $this->Do_campaign->fetch_camapign_targeting($where);
			
			if($sentiment_details)
			{
			  $this->response($sentiment_details, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}
	
	/*function fetch_gender_target_targeting_get() 
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'gender');
			$campaign_battery_target_data = 
			$this->Do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_battery_target_data)
			{
			  $this->response($campaign_battery_target_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	* Repetion of function fetch_profile_targeting_gender_get
	* */
	function fetch_age_target_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'age');
			$campaign_battery_target_data = 
			$this->Do_campaign->fetch_battery_target_targeting($where);
			
			if($campaign_battery_target_data)
			{
			  $this->response($campaign_battery_target_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	
	function fetch_age_targeting_get()
    {
        $campaign_id = $this->get('campaign_id');
        if ($campaign_id) {
            $type              = 'age';
            $where             = array(
                'campaignid' => $campaign_id,
                'type' => $type
            ); 
             
            $campaign_battery_data = $this->Do_campaign->fetch_camapign_targeting($where);
            if ($campaign_battery_data) {
                $this->response($campaign_battery_data, 200); // 200 being the HTTP response code
            } else {
                $this->response(array(
                    'error' => 'No details'
                ), 404);
            }
        }
    }
     function fetch_gender_targeting_get()
    {
        $campaign_id = $this->get('campaign_id');
        if ($campaign_id) {
            $type              = 'gender';
            $where             = array(
                'campaignid' => $campaign_id,
                'type' => $type
            ); 
             
            $campaign_battery_data = $this->Do_campaign->fetch_camapign_targeting($where);
            if ($campaign_battery_data) {
                $this->response($campaign_battery_data, 200); // 200 being the HTTP response code
            } else {
                $this->response(array(
                    'error' => 'No details'
                ), 404);
            }
        }
    }
    
    
    function fetch_custom_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$targ1=array('campaignid'=>$campaign_id,'type'=>'custom_targ1');
			$targ2=array('campaignid'=>$campaign_id,'type'=>'custom_targ2');
			$targ3=array('campaignid'=>$campaign_id,'type'=>'custom_targ3');
			$targ4=array('campaignid'=>$campaign_id,'type'=>'custom_targ4');


			$campaign_custom_targ_data = $this->Do_campaign->fetch_campaign_custom_targeting($targ1,$targ2,$targ3,$targ4);

			if($campaign_custom_targ_data)
			{
			  $this->response($campaign_custom_targ_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>$this->lang->line('no_details')),404);
			}
		}
	}

	function fetch_campaign_geo_get()
	{
		
		$campaign_id = $this->get('campaign_id');
	
		if($campaign_id)
		{
			$campaign_data = $this->Do_campaign->fetch_campaign_geo($campaign_id);
			
			if($campaign_data)
			{
				
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	
	
}
