<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Auto_link
 *
 * Auto linking between creative and ad blocks will be handelled here.
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Ramya P
 * @link		http://www.djaxadserver.com
*/

class Auto_link extends REST_Controller
{
	
	function __construct()
	{
		parent::__construct();
		$this->load->model('Do_auto_link');
	}
	
	/*
	 * 
	 * name:link_ads_get
	 * @param : zone_id
	 * @return : NULL
	 * 
	 * Link zone to creative
	 */
	 function link_ads_get()
	{
		$zone_id = $this->get('zone_id');
		$this->Do_auto_link->link_ads($zone_id);
	}
	
	
	
	/*
	 * 
	 * name:unlink_ads_get
	 * @param : zone_id
	 * @return : NULL
	 * 
	 * UnLink zone to creative
	 */
	 
	 function unlink_ads()
	 {
	 	$zone_id = $this->get('zone_id');
		if($zone_id)
		{
			$this->Do_auto_link->unlink_ads($zone_id);
		}
	 }
	 
	 /*
	 * 
	 * name:link_adblocks_get
	 * @param : campaign_id, banner_id
	 * @return : NULL
	 * 
	 * Link creative to adblocks
	 */
	 function link_adblocks_get()
	{
		$creative_id = $this->get('creative_id');
		//$campaign_id = $this->get('campaign_id');
		$this->Do_auto_link->link_adblocks($creative_id);
	}
	/*
	 * 
	 * name:unlink_blocks_get
	 * @param : creative_id
	 * @return : NULL
	 * 
	 * UnLink creative to blocks
	 */
	 
	 function unlink_blocks()
	 {
	 	$creative_id = $this->get('creative_id');
		if($creative_id)
		{
			$this->Do_auto_link->unlink_blocks($creative_id);
		}
	 }
}
