<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Admin to approve their network users activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
 */

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Approval extends REST_Controller {
    
    function __construct() {
        
        parent::__construct();
        $this->load->model('Do_approval');
        $this->load->model('Do_creative');
        $this->load->model('Do_payments');
        $this->load->model('Do_advertiser');
        $this->load->model('Do_publisher');
        $this->load->model('Do_site');
        $this->load->model('Do_networks');
        $this->load->model('Do_notification');
        $this->load->library('user_authentication');
        $key = $this->input->get_post('api_key');
        $this->user_authentication->is_valid_apikey($key);
        $user_auth = $this->user_authentication;
        if (isset($user_auth->error['response'])) {
            $this->response($user_auth->error, 200);
        }
    }
    
        
    /*
     * 
     * name: fetch_get
     * @param :
     * @return : $adv_list
     * 
     * fetch all network( pub or adv )users
     */
    public function fetch_user_get() {
        $account_type = $this->get('account_type');
        $agency_id    = $this->user_authentication->agency_id;
        $where        = array(
            'account_type' => $account_type,
            'agency_id' => $agency_id
        );
        $adv_list     = $this->Do_approval->fetch_user($where);
        $this->response($adv_list);
    }
    
    
    /*
     * Approval
     * name: approve_get
     * @param :
     * @return : $adv_list
     * fetch all network( pub or adv )users
     */
    public function approve_get() {
        
        $temp_user_id = $this->get('user_id');
        $tempObj      = $this->Do_advertiser->get_temp_user($temp_user_id);
        #print_r($tempObj);exit;
        if ($tempObj != FALSE) {
            
            $advObj = $this->create($tempObj);
            
            $this->Do_advertiser->remove_temp_user($temp_user_id);
            
            // SEND APPROVAL EMAIL to USER
            if ($this->user_authentication->account_type == "ADMIN") {
                $agency_id = $this->user_authentication->agency_id;
                $result    = $this->Do_networks->agency_owner_details($agency_id);
                
                $admin_name  = $result['name'];
                $admin_email = $result['email'];
                
                $account_type = $advObj['account_type'];
                $user_email   = $advObj['email'];
               // $password     = $advObj['password'];
                 $password     = $advObj['unenc_p'];
                $user_name    = $advObj['first_name'] . " " . $advObj['last_name'];
                $login_name = $advObj['login_username'];
                $type         = '';
                if ($account_type == "ADVERTISER") {
                    $type = "ADV_LOGIN_CREDENTIAL";
                }
                if ($account_type == "TRAFFICKER") {
                    $type = "PUB_LOGIN_CREDENTIAL";
                }
                
                
                $from         = $admin_email;
                $to           = $user_email;
                $mail_content = array(
                    "subject" => $this->lang->line('login_credentials'),
                    "to_name" => $user_name,
                    "from_name" => $admin_name,
                    "email" => $user_email,
                    "password" => $password,
                    "login_name" => $login_name
                );
                $tot_count    = $this->approval($this->get('account_type'));
                send_mail($type, $from, $to, $mail_content);
                $success = array(
                    'response' => 'ok',
                    'redirect' => site_url('admin/approval'),
                    'msg' => $this->lang->line('approval_success')
                    //'tot_count'=>$tot_count
                );
                
                $this->response($success, 200);
            } else {
                // IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
                $manager_user_id = $this->user_authentication->manager_user_id;
                $is_manager      = $this->Do_networks->get_manager_role($manager_user_id);
                if ($is_manager == 1) {
                    // GET MANAGER MAILING DETAILS FOR FROM ADDRESS
                    $agency_id = $this->user_authentication->agency_id;
                    $result    = $this->Do_networks->agency_owner_details($agency_id);
                    
                    $network_admin = $this->Do_networks->get_network_details();
                    $bcc           = $network_admin['email'];
                    $admin_name    = $result['name'];
                    $admin_email   = $result['email'];
                    
                    $account_type = $advObj['account_type'];
                    $user_email   = $advObj['email'];
                   // $password     = $advObj['password'];
                     $password     = $advObj['unenc_p'];
                    $user_name    = $advObj['first_name'] . " " . $advObj['last_name'];
                    $type         = '';
                    if ($account_type == "ADVERTISER") {
                        $type = "ADV_LOGIN_CREDENTIAL";
                    }
                    if ($account_type == "TRAFFICKER") {
                        $type = "PUB_LOGIN_CREDENTIAL";
                    }
                    
                    
                    $from         = $admin_email;
                    $to           = $user_email;
                    $mail_content = array(
                        "subject" => $this->lang->line('login_credentials'),
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email,
                        "password" => $password
                    );
                    $attachement  = "";
                    //$tot_count=$this->approval($this->get('account_type'));				
                    send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                    $success = array(
                        'response' => 'ok',
                        'redirect' => site_url('admin/approval'),
                        'msg' => $this->lang->line('approval_success')
                    );
                    
                    $this->response($success, 200);
                } else {
                    // GET NETWORK USERS MAILING DETAILS
                    $user_mailing_details = $this->Do_networks->get_network_users_detail($manager_user_id);
                    $admin_email          = $user_mailing_details['email_address'];
                    $admin_name           = $user_mailing_details['contact_name'];
                    
                    // GET NETWORK MANAGER MAILING DETAIL FOR BCC
                    $agency_id = $this->user_authentication->agency_id;
                    $result    = $this->Do_networks->agency_owner_details($agency_id);
                    $bcc       = $result['email'];
                    
                    $account_type = $advObj['account_type'];
                    $user_email   = $advObj['email'];
                    //$password     = $advObj['password'];
                     $password     = $advObj['unenc_p'];
                    $user_name    = $advObj['first_name'] . " " . $advObj['last_name'];
                    $type         = '';
                    if ($account_type == "ADVERTISER") {
                        $type = "ADV_LOGIN_CREDENTIAL";
                    }
                    if ($account_type == "TRAFFICKER") {
                        $type = "PUB_LOGIN_CREDENTIAL";
                    }
                    
                    
                    $from         = $admin_email;
                    $to           = $user_email;
                    $mail_content = array(
                        "subject" => $this->lang->line('login_credentials'),
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email,
                        "password" => $password
                    );
                    $attachement  = "";
                    //$tot_count=$this->approval($this->get('account_type'));				
                    send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                    $success = array(
                        'response' => 'ok',
                        'redirect' => site_url('admin/approval'),
                        'msg' => $this->lang->line('approval_success')
                    );
                    
                    $this->response($success, 200);
                }
            }
        } else {
            $success = array(
                'response' => 'ok',
                'redirect' => site_url('admin/approval'),
                'msg' => $this->lang->line('user_rejected_message')
            );
            $this->response($success, 200);
        }
    }
    public function approval($type) {
        
        #$account_id     	= $this->post('account_id');
        $account_id      = $this->user_authentication->account_id;
        $account_type    = $type;
        $manager_role_id = FALSE;
        $agency_id       = FALSE;
        
        switch (strtoupper($account_type)) {
            case 'ADMIN';
                $agency_id       = $this->Do_notification->getAdminAgencyId($account_id);
                $manager_role_id = $this->post('manager_role_id');
                break;
            case 'MANAGER';
                $agency_id       = $this->Do_notification->getManagerAgencyId($account_id);
                $manager_role_id = $this->post('manager_role_id');
                break;
            case 'ADVERTISER';
                $agency_id = $this->Do_notification->getAdvertiserAgencyId($account_id);
                break;
            case 'TRAFFICKER';
                $agency_id = $this->Do_notification->getPublisherAgencyId($account_id);
                break;
                
        }
        
        if ($agency_id != FALSE) {
            $notification_obj = $this->Do_notification->approval_notification($account_id, $account_type, $agency_id, $manager_role_id);
            //$this->response($notification_obj, 200); // 200 being the HTTP response code
            return $notification_obj;
        }
    }
    
    /*
     * 
     * name: reject_get
     * @param :
     * @return : true or false
     * 
     */
    public function reject_get() {
        $temp_user_id      = $this->get('rej_user_id');
        //CHECK THIS USER ID IS EXIT OR NOT
        $temp_user_details = $this->Do_advertiser->get_temp_user($temp_user_id);
        //$user_info=$temp_user_details[0];
        
        if ($temp_user_details != FALSE) {
            $this->Do_advertiser->remove_temp_user($temp_user_id);
            
            //SEND EMAIL TO REJECTED USER
            $result      = $this->Do_networks->get_network_details();
            $admin_name  = $result['firstname'] . " " . $result['lastname'];
            $admin_email = $result['email'];
            
            $user_email    = $temp_user_details['email'];
            $user_name     = $temp_user_details['first_name'] . " " . $temp_user_details['last_name'];
            $user_acc_type = $temp_user_details['account_type'];
            
            $type = "ACCOUNT_REJECT_NOTIFY";
            $from = $admin_email;
            $to   = $user_email;
            
            $mail_content = array(
                "subject" => $this->lang->line('account_rejected'),
                "to_name" => $user_name,
                "from_name" => $admin_name,
                "email" => $user_email,
                "account_type" => $user_acc_type
            );
            $attachement  = '';
            send_mail($type, $from, $to, $mail_content, $attachement);
            
            $success = array(
                'response' => 'ok',
                'redirect' => site_url('admin/approval'),
                'msg' => $this->lang->line('rejected_success')
            );
            $this->response($success, 200);
        } else {
            $success = array(
                'response' => 'ok',
                'redirect' => site_url('admin/approval'),
                'msg' => $this->lang->line('user_rejected_message')
            );
            $this->response($success, 200);
        }
        
    }
    
    /*
     * 
     * name: create
     * @param :
     * @return : adv / pub details
     * 
     */
    public function create($advObj) {
        
        if ($advObj != FALSE) {
            $advObj['usr_signup'] ="temp_user";
            if ($advObj['account_type'] == "ADVERTISER") {
                $advObj = $this->Do_advertiser->add($advObj);
            } else if ($advObj['account_type'] === "TRAFFICKER") {
                $advObj = $this->Do_publisher->add($advObj);
            }
            
            // Send Mail to Advertiser & Manager
            
            if ($advObj != FALSE) {
                return $advObj;
            } else {
                return FALSE;
            }
            
        }
    }
    /*
     * 
     * name: fetch_creative_get
     * @param :
     * @return : $creative_list
     * 
     * fetch all creatives
     */
    public function fetch_creative_get() {
        $agency_id     = $this->user_authentication->agency_id;
        $creative_list = $this->Do_creative->fetch_all_creative($agency_id);
        $this->response($creative_list);
    }
    
  
    
    /*
     * 
     * name: approve_creative_get
     * @param :
     * @return : $success
     */
    public function approve_creative_get() {
        $banner_id   = $this->get('banner_id');
        //CHECK THE CREATIVE IS APPROVED / REJECTED PREVIOUSLY
        $creative_id = $this->Do_creative->is_creative_id($banner_id);
        if ($creative_id != '') {
            $approve_list = $this->Do_creative->approve_creative($banner_id);
            
            if ($approve_list) {
                //Get advertiser details
                $advertiser_details = $this->Do_advertiser->get_profile($approve_list['dj_account_id']);
                //Get admin details
                if ($this->user_authentication->account_type == "ADMIN") {
                    $agency_id = $this->user_authentication->agency_id;
                    $result    = $this->Do_networks->agency_owner_details($agency_id);
                    
                    $admin_name   = $result['name'];
                    $admin_email  = $result['email'];
                    $user_email   = $advertiser_details['email'];
                    $user_name    = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                    $type         = "ADVERTISER_CREATIVE_APPROVAL";
                    $from         = $admin_email;
                    $to           = $user_email;
                    $mail_content = array(
                        "subject" => $this->lang->line('creative_approved'),
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email,
                        'banner_name' => $approve_list['description'],
                        'contenttype' => $approve_list['dj_banner_type']
                    );
                    $attachement  = '';
                    $tot_count    = $this->approval($this->get('account_type'));
                    send_mail($type, $from, $to, $mail_content, $attachement);
                    $success = array(
                        'response' => 'ok',
                        'msg' => $this->lang->line('creative_approved_success'),
                        'tot_count' => $tot_count
                    );
                    $this->response($success);
                } else {
                    // IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
                    $manager_user_id = $this->user_authentication->manager_user_id;
                    $is_manager      = $this->Do_networks->get_manager_role($manager_user_id);
                    if ($is_manager == 1) {
                        // GET MANAGER MAILING DETAILS FOR FROM ADDRESS
                        $agency_id     = $this->user_authentication->agency_id;
                        $result        = $this->Do_networks->agency_owner_details($agency_id);
                        // GET NETWORK ADMIN DETAILS FOR BCC
                        $network_admin = $this->Do_networks->get_network_details();
                        
                        $bcc          = $network_admin['email'];
                        $admin_name   = $result['name'];
                        $admin_email  = $result['email'];
                        $user_email   = $advertiser_details['email'];
                        $user_name    = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                        $type         = "ADVERTISER_CREATIVE_APPROVAL";
                        $from         = $admin_email;
                        $to           = $user_email;
                        $mail_content = array(
                            "subject" => $this->lang->line('creative_approved'),
                            "to_name" => $user_name,
                            "from_name" => $admin_name,
                            "email" => $user_email,
                            'banner_name' => $approve_list['description'],
                            'contenttype' => $approve_list['dj_banner_type']
                        );
                        $attachement  = '';
                        $tot_count    = $this->approval($this->get('account_type'));
                        send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                        $success = array(
                            'response' => 'ok',
                            'msg' => $this->lang->line('creative_approved_success')
                        );
                        $this->response($success);
                    } else {
                        // GET NETWORK USERS MAILING DETAILS
                        $user_mailing_details = $this->Do_networks->get_network_users_detail($manager_user_id);
                        $admin_email          = $user_mailing_details['email_address'];
                        $admin_name           = $user_mailing_details['contact_name'];
                        
                        // GET NETWORK MANAGER MAILING DETAIL FOR BCC
                        $agency_id = $this->user_authentication->agency_id;
                        $result    = $this->Do_networks->agency_owner_details($agency_id);
                        $bcc       = $result['email'];
                        
                        $user_email   = $advertiser_details['email'];
                        $user_name    = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                        $type         = "ADVERTISER_CREATIVE_APPROVAL";
                        $from         = $admin_email;
                        $to           = $user_email;
                        $mail_content = array(
                            "subject" => $this->lang->line('creative_approved'),
                            "to_name" => $user_name,
                            "from_name" => $admin_name,
                            "email" => $user_email,
                            'banner_name' => $approve_list['description'],
                            'contenttype' => $approve_list['dj_banner_type']
                        );
                        $attachement  = '';
                        send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                        $success = array(
                            'response' => 'ok',
                            'msg' => $this->lang->line('creative_approved_success')
                        );
                        $this->response($success);
                    }
                }
            }
        } else {
            $success = array(
                'response' => 'ok',
                'msg' => $this->lang->line('creative_approved_previously_msg')
            );
            $this->response($success);
        }
    }
    
    /*
     * 
     * name: reject_creative_get
     * @param :
     * @return : $success
     */
    public function reject_creative_get() {
        $banner_id   = $this->get('reject_banner_id');
        //CHECK THE CREATIVE IS APPROVED / REJECTED PREVIOUSLY
        $creative_id = $this->Do_creative->is_creative_id($banner_id);
        if ($creative_id != '') {
            $reject_list = $this->Do_creative->reject_creative($banner_id);
            if ($reject_list) {
                //Get advertiser details
                $advertiser_details = $this->Do_advertiser->get_profile($reject_list['dj_account_id']);
                //Get admin details
                if ($this->user_authentication->account_type == "ADMIN") {
                    $agency_id    = $this->user_authentication->agency_id;
                    $result       = $this->Do_networks->agency_owner_details($agency_id);
                    $admin_name   = $result['name'];
                    $admin_email  = $result['email'];
                    $user_email   = $advertiser_details['email'];
                    $user_name    = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                    $type         = "ADVERTISER_CREATIVE_REJECTED";
                    $from         = $admin_email;
                    $to           = $user_email;
                    $mail_content = array(
                        "subject" => $this->lang->line('creative_rejected'),
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email,
                        'banner_name' => $reject_list['description'],
                        'contenttype' => $reject_list['dj_banner_type']
                    );
                    $attachement  = '';
                    send_mail($type, $from, $to, $mail_content, $attachement);
                    $success = array(
                        'response' => 'ok',
                        'msg' => $this->lang->line('creative_rejected_success')
                    );
                    $this->response($success);
                } else {
                    // IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
                    $manager_user_id = $this->user_authentication->manager_user_id;
                    $is_manager      = $this->Do_networks->get_manager_role($manager_user_id);
                    if ($is_manager == 1) {
                        // GET MANAGER MAILING DETAILS FOR FROM ADDRESS
                        $agency_id = $this->user_authentication->agency_id;
                        $result    = $this->Do_networks->agency_owner_details($agency_id);
                        
                        // IF NOT NETWORK ADMIN ADMIN SEND BCC
                        $network_admin = $this->Do_networks->get_network_details();
                        $bcc           = $network_admin['email'];
                        $admin_name    = $result['name'];
                        $admin_email   = $result['email'];
                        $user_email    = $advertiser_details['email'];
                        $user_name     = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                        $type          = "ADVERTISER_CREATIVE_REJECTED";
                        $from          = $admin_email;
                        $to            = $user_email;
                        $mail_content  = array(
                            "subject" => $this->lang->line('creative_rejected'),
                            "to_name" => $user_name,
                            "from_name" => $admin_name,
                            "email" => $user_email,
                            'banner_name' => $reject_list['description'],
                            'contenttype' => $reject_list['dj_banner_type']
                        );
                        $attachement   = '';
                        send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                        $success = array(
                            'response' => 'ok',
                            'msg' => $this->lang->line('creative_rejected_success')
                        );
                        $this->response($success);
                    } else {
                        // GET NETWORK USERS MAILING DETAILS
                        $user_mailing_details = $this->Do_networks->get_network_users_detail($manager_user_id);
                        $admin_email          = $user_mailing_details['email_address'];
                        $admin_name           = $user_mailing_details['contact_name'];
                        
                        // GET NETWORK MANAGER MAILING DETAIL FOR BCC
                        $agency_id = $this->user_authentication->agency_id;
                        $result    = $this->Do_networks->agency_owner_details($agency_id);
                        $bcc       = $result['email'];
                        
                        $user_email   = $advertiser_details['email'];
                        $user_name    = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                        $type         = "ADVERTISER_CREATIVE_REJECTED";
                        $from         = $admin_email;
                        $to           = $user_email;
                        $mail_content = array(
                            "subject" => $this->lang->line('creative_rejected'),
                            "to_name" => $user_name,
                            "from_name" => $admin_name,
                            "email" => $user_email,
                            'banner_name' => $reject_list['description'],
                            'contenttype' => $reject_list['dj_banner_type']
                        );
                        $attachement  = '';
                        send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                        $success = array(
                            'response' => 'ok',
                            'msg' => $this->lang->line('creative_rejected_success')
                        );
                        $this->response($success);
                    }
                }
            }
        } else {
            $success = array(
                'response' => 'ok',
                'msg' => $this->lang->line('creative_approved_previously_msg')
            );
            $this->response($success);
        }
    }
    
    /*
     * 
     * name: preview_creative_get
     * @param :
     * @return : $preview_creative
     */
    public function preview_creative_get() {
        $banner_id        = $this->get('banner_id');
        $preview_creative = $this->Do_creative->preview_creative($banner_id);
        $this->response($preview_creative);
    }
    
    /*
     * 
     * name: fetch_payment_list_get
     * @param :
     * @return :Fetch list of payments need to be approve
     */
    public function fetch_payment_list_get() {
        
        $agencyid     = $this->user_authentication->agency_id;
        $exchangeval		=	$this->get('exchangeval');
        $payment_list = $this->Do_payments->fetch_payment_list($agencyid,$exchangeval);
        $this->response($payment_list);
        
        
    }
    
    
    /*
     * 
     * name: payment_approve_get
     * @param :
     * @return : $success
     */
    public function payment_approve_post() {
        $id              = $this->post('pay_id');
        $amount          = $this->post('amount');
        $account_id      = $this->post('account_id');
        //CHECK WHETHER PAYMENT IS WAITING FOR APPROVE
        $payment_id      = $this->Do_payments->check_payment_process($id);
        $payment_approve = $this->Do_payments->payment_approve($id, $amount, $account_id);
        if ($payment_approve && $payment_id) {
            //Sending mail to advertiser for approve their added fund
            //Get advertiser details
            $advertiser_details       = $this->Do_advertiser->get_profile($account_id);
            $advertiser_email         = $advertiser_details['email'];
            $advertiser_total_balance = $advertiser_details['dj_cur_balance'];
            //Get admin details
            if ($this->user_authentication->account_type == "ADMIN") {
                $agency_id    = $this->user_authentication->agency_id;
                $result       = $this->Do_networks->agency_owner_details($agency_id);
                $admin_name   = $result['name'];
                $admin_email  = $result['email'];
                $user_email   = $advertiser_email;
                $amount       = $amount;
                $currency     = $this->config->item('currency');
                $total_amount = $advertiser_total_balance;
                $user_name    = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                $type         = "ADV_APPROVE_ADD_FUND_EMAIL";
                $from         = $admin_email;
                $to           = $user_email;
                $mail_content = array(
                    "subject" => $this->lang->line('approve_added_fund'),
                    "to_name" => $user_name,
                    "from_name" => $admin_name,
                    "email" => $user_email,
                    "added_amount" => $amount,
                    "total_amount" => $total_amount,
                    "currency" => $currency
                );
                $attachement  = '';
                $tot_count    = $this->approval($this->get('account_type'));
                send_mail($type, $from, $to, $mail_content, $attachement);
                $success = array(
                    'response' => 'ok',
                    'msg' => $this->lang->line('payment_approved_success')
                );
                $this->response($success, 200);
            } else {
                // IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
                $manager_user_id = $this->user_authentication->manager_user_id;
                $is_manager      = $this->Do_networks->get_manager_role($manager_user_id);
                if ($is_manager == 1) {
                    // GET MANAGER MAILING DETAILS FOR FROM ADDRESS
                    $agency_id = $this->user_authentication->agency_id;
                    $result    = $this->Do_networks->agency_owner_details($agency_id);
                    
                    $network_admin = $this->Do_networks->get_network_details();
                    $bcc           = $network_admin['email'];
                    $admin_name    = $result['name'];
                    $admin_email   = $result['email'];
                    $user_email    = $advertiser_email;
                    $amount        = $amount;
                    $currency      = $this->config->item('currency');
                    $total_amount  = $advertiser_total_balance;
                    $user_name     = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                    $type          = "ADV_APPROVE_ADD_FUND_EMAIL";
                    $from          = $admin_email;
                    $to            = $user_email;
                    $mail_content  = array(
                        "subject" => $this->lang->line('approve_added_fund'),
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email,
                        "added_amount" => $amount,
                        "total_amount" => $total_amount,
                        "currency" => $currency
                    );
                    $attachement   = '';
                    $tot_count     = $this->approval($this->get('account_type'));
                    send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                    $success = array(
                        'response' => 'ok',
                        'msg' => $this->lang->line('payment_approved_success')
                    );
                    $this->response($success, 200);
                } else {
                    // GET NETWORK USERS MAILING DETAILS
                    $user_mailing_details = $this->Do_networks->get_network_users_detail($manager_user_id);
                    $admin_email          = $user_mailing_details['email_address'];
                    $admin_name           = $user_mailing_details['contact_name'];
                    
                    // GET NETWORK MANAGER MAILING DETAIL FOR BCC
                    $agency_id = $this->user_authentication->agency_id;
                    $result    = $this->Do_networks->agency_owner_details($agency_id);
                    $bcc       = $result['email'];
                    
                    $user_email   = $advertiser_email;
                    $amount       = $amount;
                    $currency     = $this->config->item('currency');
                    $total_amount = $advertiser_total_balance;
                    $user_name    = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                    $type         = "ADV_APPROVE_ADD_FUND_EMAIL";
                    $from         = $admin_email;
                    $to           = $user_email;
                    $mail_content = array(
                        "subject" => $this->lang->line('approve_added_fund'),
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email,
                        "added_amount" => $amount,
                        "total_amount" => $total_amount,
                        "currency" => $currency
                    );
                    $attachement  = '';
                    send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                    $success = array(
                        'response' => 'ok',
                        'msg' => $this->lang->line('payment_approved_success')
                    );
                    $this->response($success, 200);
                }
            }
        } else {
            $error = array(
                'response' => 'ok',
                'msg' => $this->lang->line('payment_approved_previously')
            );
            $this->response($error, 200);
        }
    }
    
    /*
     * 
     * name: payment_reject_get
     * @param :
     * @return : $success
     */
    public function payment_reject_post() {
        $id         = $this->post('rej_pay_id');
        //CHECK WHETHER PAYMENT IS WAITING FOR APPROVE
        $payment_id = $this->Do_payments->check_payment_process($id);
        $account_id = $this->Do_payments->payment_reject($id);
        if ($account_id && $payment_id) {
            //Sending mail to advertiser for approve their added fund
            //Get advertiser details
            $advertiser_details = $this->Do_advertiser->get_user_information($account_id);
            $advertiser_info    = $advertiser_details[0];
            //Get admin details
            if ($this->user_authentication->account_type == "ADMIN") {
                $agency_id    = $this->user_authentication->agency_id;
                $result       = $this->Do_networks->agency_owner_details($agency_id);
                $admin_name   = $result['name'];
                $admin_email  = $result['email'];
                $user_email   = $advertiser_info['email'];
                #$amount        = $added_amount;
                $user_name    = $advertiser_info['dj_first_name'] . " " . $advertiser_info['dj_last_name'];
                $type         = "ADV_REJECT_ADD_FUND_EMAIL";
                $from         = $admin_email;
                $to           = $user_email;
                $mail_content = array(
                    "subject" => $this->lang->line('rejected_added_fund'),
                    "to_name" => $user_name,
                    "from_name" => $admin_name,
                    "email" => $user_email
                    #"added_amount"  => $amount,
                    #"currency"      => $currency								
                );
                $attachement  = '';
                send_mail($type, $from, $to, $mail_content, $attachement);
                $success = array(
                    'response' => 'ok',
                    'msg' => $this->lang->line('payment_rejected_success')
                );
                $this->response($success);
            } else {
                // IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
                $manager_user_id = $this->user_authentication->manager_user_id;
                $is_manager      = $this->Do_networks->get_manager_role($manager_user_id);
                if ($is_manager == 1) {
                    // GET MANAGER MAILING DETAILS FOR FROM ADDRESS
                    $agency_id = $this->user_authentication->agency_id;
                    $result    = $this->Do_networks->agency_owner_details($agency_id);
                    
                    $network_admin = $this->Do_networks->get_network_details();
                    $bcc           = $network_admin['email'];
                    $admin_name    = $result['name'];
                    $admin_email   = $result['email'];
                    $user_email    = $advertiser_info['email'];
                    #$amount        = $added_amount;
                    $user_name     = $advertiser_info['dj_first_name'] . " " . $advertiser_info['dj_last_name'];
                    $type          = "ADV_REJECT_ADD_FUND_EMAIL";
                    $from          = $admin_email;
                    $to            = $user_email;
                    $mail_content  = array(
                        "subject" => $this->lang->line('rejected_added_fund'),
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email
                        #"added_amount"  => $amount,
                        #"currency"      => $currency								
                    );
                    $attachement   = '';
                    send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                    $success = array(
                        'response' => 'ok',
                        'msg' => $this->lang->line('payment_rejected_success')
                    );
                    $this->response($success);
                } else {
                    // GET NETWORK USERS MAILING DETAILS
                    $user_mailing_details = $this->Do_networks->get_network_users_detail($manager_user_id);
                    $admin_email          = $user_mailing_details['email_address'];
                    $admin_name           = $user_mailing_details['contact_name'];
                    
                    // GET NETWORK MANAGER MAILING DETAIL FOR BCC
                    $agency_id = $this->user_authentication->agency_id;
                    $result    = $this->Do_networks->agency_owner_details($agency_id);
                    $bcc       = $result['email'];
                    
                    $user_email   = $advertiser_info['email'];
                    #$amount        = $added_amount;
                    $user_name    = $advertiser_info['dj_first_name'] . " " . $advertiser_info['dj_last_name'];
                    $type         = "ADV_REJECT_ADD_FUND_EMAIL";
                    $from         = $admin_email;
                    $to           = $user_email;
                    $mail_content = array(
                        "subject" => $this->lang->line('rejected_added_fund'),
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email
                        #"added_amount"  => $amount,
                        #"currency"      => $currency								
                    );
                    $attachement  = '';
                    send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                    $success = array(
                        'response' => 'ok',
                        'msg' => $this->lang->line('payment_rejected_success')
                    );
                    $this->response($success);
                }
            }
        } else {
            $error = array(
                'response' => 'ok',
                'msg' => $this->lang->line('payment_approved_previously')
            );
            $this->response($error, 200);
        }
    }
    
    /*
     * 
     * name: payment_viewmore_get
     * @param :
     * @return : $success
     */
    public function payment_viewmore_get() {
        $id              = $this->get('id');
        $exchangeval     = $this->get('exchangeval');
        $payment_details = $this->Do_payments->payment_viewmore($id,$exchangeval);
        $this->response($payment_details);
    }
    
    /*
     * 
     * name: fetch_pub_payment_list
     * @param :
     * @return : $success
     */
    public function fetch_pub_payment_list_get() {
        //~ $agencyid     = $this->get('agency_id');
        $agencyid     = $this->user_authentication->agency_id;
        $exchangeval     = $this->get('exchangeval');
        $invoice      = '';
        $payment_list = $this->Do_payments->fetch_pub_payment_list($invoice, $agencyid,$exchangeval);
        $this->response($payment_list);
    }
    
    /*
     * 
     * name: publisher_invoice_viewmore
     * @param : invoice_id
     * @return : Selected invoice info list
     */
    public function publisher_invoice_viewmore_get() {
        $id                  = $this->get('id');   
        $exchangeval     = $this->get('exchangeval');     
        
        if($this->get('payment_type')){
			$payment_type        = $this->get('payment_type');			
			$pub_invoice_details = $this->Do_payments->fetch_individual_invoice($id,$payment_type,$exchangeval);
		}else{
			$pub_invoice_details = $this->Do_payments->fetch_individual_invoice($id,'',$exchangeval);
		}
						
        if($pub_invoice_details){			
			$pub_invoice_details[0]['total_earn'] = round($pub_invoice_details[0]['total_earn'],2);
			$pub_invoice_details[0]['start_date'] = dateformat(strtotime($pub_invoice_details[0]['start_date']));
			$pub_invoice_details[0]['end_date'] = dateformat(strtotime($pub_invoice_details[0]['end_date']));
			$this->response($pub_invoice_details);
		}else{
			$error = array(
                'response' => 'error',
                'msg' => $this->lang->line('publisher_payment_approved_previously')
            );
            $this->response($error, 200);
		}
    }
 
    /*
     * 
     * name: publisher_invoice_get_admin
     * @param : agency_id
     * @return : Selected invoice admin details
     * added by karthika dec -27
     */
    public function publisher_invoice_get_admin_get() {
			$id                  = $this->get('id');        
    		$admin_details = $this->Do_payments->fetch_admin_detail($id);
    		$this->response($admin_details,200);
    } 
    
    public function check_invoice_payment_get() {
        $invoice_id          = $this->get('id');
        $pub_invoice_details = $this->Do_payments->check_invoice_payment_process($invoice_id);
        if ($pub_invoice_details != FALSE) {
            $success = array(
                'response' => 'ok',
                'msg' => $this->lang->line('payment_approved_after_only')
            );
            $this->response($success, 200);
        } else {
            $error = array(
                'response' => 'error',
                'msg' => $this->lang->line('publisher_payment_approved_previously')
            );
            $this->response($error, 200);
        }
        
    }
    /*
     * 
     * name: affiliate_invoice_viewmore
     * @param : invoice_id
     * @return : Selected invoice info list
     */
    public function affiliate_invoice_viewmore_get() {
        $id                  = $this->get('id');
        $aff_invoice_details = $this->Do_payments->fetch_aff_individual_invoice($id);
        $this->response($aff_invoice_details);
    }
    
    public function approve_all_creative_post() {
        $banner_ids = $this->post('banner_id');
        
        //CHECK THE CREATIVE IS APPROVED / REJECTED PREVIOUSLY
        
        $approve_list = $this->Do_creative->approve_all_creative($banner_ids);
        
        for ($i = 0; $i < count($approve_list); $i++) {
            //Get advertiser details
            $advertiser_details = $this->Do_advertiser->get_profile($approve_list[$i]['dj_account_id']);
            
            //Get admin details
            if ($this->user_authentication->account_type == "ADMIN") {
                $agency_id = $this->user_authentication->agency_id;
                $result    = $this->Do_networks->agency_owner_details($agency_id);
                
                $admin_name   = $result['name'];
                $admin_email  = $result['email'];
                $user_email   = $advertiser_details['email'];
                $user_name    = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                $type         = "ADVERTISER_CREATIVE_APPROVAL";
                $from         = $admin_email;
                $to           = $user_email;
                $mail_content = array(
                    "subject" => $this->lang->line('creative_approved'),
                    "to_name" => $user_name,
                    "from_name" => $admin_name,
                    "email" => $user_email,
                    'banner_name' => $approve_list[$i]['description'],
                    'contenttype' => $approve_list[$i]['dj_banner_type']
                );
                $attachement  = '';
                
                send_mail($type, $from, $to, $mail_content, $attachement);
                $success = array(
                    'response' => 'ok',
                    'msg' => $this->lang->line('crtv_aprv_suc')
                );
                $this->response($success);
            } else {
                // IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
                $manager_user_id = $this->user_authentication->manager_user_id;
                $is_manager      = $this->Do_networks->get_manager_role($manager_user_id);
                if ($is_manager == 1) {
                    // GET MANAGER MAILING DETAILS FOR FROM ADDRESS
                    $agency_id     = $this->user_authentication->agency_id;
                    $result        = $this->Do_networks->agency_owner_details($agency_id);
                    // GET NETWORK ADMIN DETAILS FOR BCC
                    $network_admin = $this->Do_networks->get_network_details();
                    
                    $bcc          = $network_admin['email'];
                    $admin_name   = $result['name'];
                    $admin_email  = $result['email'];
                    $user_email   = $advertiser_details['email'];
                    $user_name    = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                    $type         = "ADVERTISER_CREATIVE_APPROVAL";
                    $from         = $admin_email;
                    $to           = $user_email;
                    $mail_content = array(
                        "subject" => $this->lang->line('creative_approved'),
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email,
                        'banner_name' => $approve_list[$i]['description'],
                        'contenttype' => $approve_list[$i]['dj_banner_type']
                    );
                    $attachement  = '';
                    
                    send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                    $success = array(
                        'response' => 'ok',
                        'msg' => $this->lang->line('crtv_aprv_suc')
                    );
                    $this->response($success);
                } else {
                    // GET NETWORK USERS MAILING DETAILS
                    $user_mailing_details = $this->Do_networks->get_network_users_detail($manager_user_id);
                    $admin_email          = $user_mailing_details['email_address'];
                    $admin_name           = $user_mailing_details['contact_name'];
                    
                    // GET NETWORK MANAGER MAILING DETAIL FOR BCC
                    $agency_id = $this->user_authentication->agency_id;
                    $result    = $this->Do_networks->agency_owner_details($agency_id);
                    $bcc       = $result['email'];
                    
                    $user_email   = $advertiser_details['email'];
                    $user_name    = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                    $type         = "ADVERTISER_CREATIVE_APPROVAL";
                    $from         = $admin_email;
                    $to           = $user_email;
                    $mail_content = array(
                        "subject" => $this->lang->line('creative_approved'),
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email,
                        'banner_name' => $approve_list[$i]['description'],
                        'contenttype' => $approve_list[$i]['dj_banner_type']
                    );
                    $attachement  = '';
                    
                    send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                    $success = array(
                        'response' => 'ok',
                        'msg' => $this->lang->line('crtv_aprv_suc')
                    );
                    $this->response($success);
                }
            }
        }
    }
    
    /*
     * 
     * name: reject_creative_get
     * @param :
     * @return : $success
     */
    public function reject_all_creative_post() {
        $banner_ids = $this->post('reject_banner_id');
        
        $reject_list = $this->Do_creative->reject_all_creative($banner_ids);
        
        for ($i = 0; $i < count($reject_list); $i++) {
            //Get advertiser details
            $advertiser_details = $this->Do_advertiser->get_profile($reject_list[$i]['dj_account_id']);
            
            
            //Get admin details
            if ($this->user_authentication->account_type == "ADMIN") {
                $agency_id    = $this->user_authentication->agency_id;
                $result       = $this->Do_networks->agency_owner_details($agency_id);
                $admin_name   = $result['name'];
                $admin_email  = $result['email'];
                $user_email   = $advertiser_details['email'];
                $user_name    = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                $type         = "ADVERTISER_CREATIVE_REJECTED";
                $from         = $admin_email;
                $to           = $user_email;
                $mail_content = array(
                    "subject" => $this->lang->line('creative_rejected'),
                    "to_name" => $user_name,
                    "from_name" => $admin_name,
                    "email" => $user_email,
                    'banner_name' => $reject_list[$i]['description'],
                    'contenttype' => $reject_list[$i]['dj_banner_type']
                );
                $attachement  = '';
                
                send_mail($type, $from, $to, $mail_content, $attachement);
                $success = array(
                    'response' => 'ok',
                    'msg' => $this->lang->line('creative_rejected_success')
                );
                $this->response($success);
            } else {
                // IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
                $manager_user_id = $this->user_authentication->manager_user_id;
                $is_manager      = $this->Do_networks->get_manager_role($manager_user_id);
                if ($is_manager == 1) {
                    // GET MANAGER MAILING DETAILS FOR FROM ADDRESS
                    $agency_id = $this->user_authentication->agency_id;
                    $result    = $this->Do_networks->agency_owner_details($agency_id);
                    
                    // IF NOT NETWORK ADMIN ADMIN SEND BCC
                    $network_admin = $this->Do_networks->get_network_details();
                    $bcc           = $network_admin['email'];
                    $admin_name    = $result['name'];
                    $admin_email   = $result['email'];
                    $user_email    = $advertiser_details['email'];
                    $user_name     = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                    $type          = "ADVERTISER_CREATIVE_REJECTED";
                    $from          = $admin_email;
                    $to            = $user_email;
                    $mail_content  = array(
                        "subject" => $this->lang->line('creative_rejected'),
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email,
                        'banner_name' => $reject_list[$i]['description'],
                        'contenttype' => $reject_list[$i]['dj_banner_type']
                    );
                    $attachement   = '';
                    
                    send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                    $success = array(
                        'response' => 'ok',
                        'msg' => $this->lang->line('creative_rejected')
                    );
                    $this->response($success);
                } else {
                    // GET NETWORK USERS MAILING DETAILS
                    $user_mailing_details = $this->Do_networks->get_network_users_detail($manager_user_id);
                    $admin_email          = $user_mailing_details['email_address'];
                    $admin_name           = $user_mailing_details['contact_name'];
                    
                    // GET NETWORK MANAGER MAILING DETAIL FOR BCC
                    $agency_id = $this->user_authentication->agency_id;
                    $result    = $this->Do_networks->agency_owner_details($agency_id);
                    $bcc       = $result['email'];
                    
                    $user_email   = $advertiser_details['email'];
                    $user_name    = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                    $type         = "ADVERTISER_CREATIVE_REJECTED";
                    $from         = $admin_email;
                    $to           = $user_email;
                    $mail_content = array(
                        "subject" => $this->lang->line('creative_rejected'),
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email,
                        'banner_name' => $reject_list[$i]['description'],
                        'contenttype' => $reject_list[$i]['dj_banner_type']
                    );
                    $attachement  = '';
                    send_mail($type, $from, $to, $mail_content, $attachement, $bcc);
                    $success = array(
                        'response' => 'ok',
                        $this->lang->line('creative_rejected_success')
                    );
                    $this->response($success);
                }
            }
        }
    }
    
      public function fetch_aff_payment_list_get()
	 {
		
	   $agencyid = $this->user_authentication->agency_id;
	   $currency	  = $this->get('dj_currency');
	   $invoice='';

	   $payment_list =$this->Do_payments->fetch_aff_payment_list($invoice,$agencyid,$currency);

	   if($payment_list!='')
	   {
		//$result=$this->Do_networks->get_network_details();	
		//$payment_list[0]['admin_email']= $result['email'];  
		//$payment_list[0]['admin_name']= $result['firstname']." ".$result['lastname'];  
		$admin_paypal=$this->Do_networks->get_admin_paypal_info(2);
		$payment_list[0]['admin_paypal']= $admin_paypal[0]['paypal_id'];  
		// $this->response($payment_list[0]['admin_paypal']);
		$this->response($payment_list); 
		}
	 }      
    /*added by murugeswari on 15-nov-17
	* 
	* name: fetch site 
	* @param :
	* @return : $site list
	* 
	* fetch all sites
    */
	
    
    public function fetch_site1_get() {
        $agency_id     = $this->user_authentication->agency_id;
        $site_list = $this->Do_site->fetch_all_site($agency_id);
        $this->response($site_list);
    }
	 /*added by murugeswari on 15-nov-17
	* 
	* name: Approve site 
	* @param :
	* @return : approved site 
	* 
	* 
    */
    public function approve_site_get()
	{
	   $site_id = $this->get('site_id');
	 		$siteid =$this->Do_site->is_site_id($site_id);//CHECK THE CREATIVE IS APPROVED / REJECTED PREVIOUSLY
	 
	   if($siteid!='')
	   {
						 $approve_list =$this->Do_site->approve_site($site_id);
						 $success = array('response'	=> 'ok',
													'msg'		=> 'Site has been Approved successfully'
													); 
							$this->response($success);
	   }  
	   else
	   {
		   		$success = array('response'	=> 'ok',
									'msg'		=> 'Site has been Approved / Rejected Previously by admin'
									); 
				 	 $this->response($success);

	   }  
	}
	/*added by murugeswari on 15-nov-17
	* 
	* name: Preview site 
	* @param :
	* @return : site name,site url,category and bidding type
	* 
	* 
    */
	  public function preview_site_get() {
        $site_id        = $this->get('site_id');  
        $preview_site = $this->Do_approval->preview_site($site_id);
        $this->response($preview_site, 200);
    }
    
    /*added by murugeswari on 15-nov-17
	* 
	* name: reject_site_get
	* @param :
	* @return : $success
    */
	public function reject_site_get()
	{
	   $site_id = $this->get('reject_site_id');
	   //CHECK THE CREATIVE IS APPROVED / REJECTED PREVIOUSLY
	   $siteid =$this->Do_site->is_site_id($site_id);
	   if($siteid!='')
	   {
		   $approve_list =$this->Do_site->reject_site($site_id);
		    $success = array('response'	=> 'ok',
										 'msg'		=> 'Site has been Rejected successfully'
										 ); 
					   $this->response($success);
	   }  
	   else
	   {
		   $success = array('response'	=> 'ok',
							 'msg'		=> 'Site has been Approved / Rejected Previously by admin'
							 ); 
		   $this->response($success);

	   } 
   } 
}
