<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class App_Settings extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_app_config');
         $this->load->library('user_authentication');
         $this->load->model('Do_networks');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }	
	}
	
			
	public function set_value_post()
	{
	   $network_id = $this->post('pk');
	   $config_name = $this->post('name');
	   $config_value = $this->post('value');
	   $agency_id = get_session('agencyid');
	     if($config_name=='Logo_site_setting')
	   {
		  $account_id	= 	$this->user_authentication->account_id;	
		 $logo_name=$this->Do_networks->get_user_information($account_id);
		 $delete_logo_name=$logo_name[0]['logo_image'];
		 if($delete_logo_name)
		{
			$is_delete_logo=$this->image_lib->delete_logo_image($delete_logo_name);
			 /*Reset session*/
			unset_logo_admin('logo_image','');
		
			/*Reset session*/
			/* Delete Profile name in Database */
			$this->Do_networks->delete_logo_name($account_id);
					
		}
		
		   
	   }
	   if($config_name=="zone")
	   {
		  $res = $this->Do_app_config->set_time($config_value);  
		  
	   }
	   if(!empty($network_id) AND !empty($config_name) AND !empty($config_value)){

		  if($this->Do_app_config->is_field_exists(TAB_APP_CONFIG,$config_name)){
		  
		  	 $res = $this->Do_app_config->set_value($network_id,$config_name,$config_value,$agency_id);
		 
			 if($res !== FALSE){
				 
				  if($config_name == 'ssp_default_value')
				 {
				$this->Do_app_config->ssp_set_value_action($config_value,$config_name,$agency_id); 
		          
				 }
				 if($config_name == 'ssp_response_time'){
					 $this->Do_app_config->ssp_set_value_time($config_value,$config_name,$agency_id); 
				 }
					
					$success = array(
						'response' 	=> 'ok',
						'id'		=> $res,
						'msg'	 	=> $this->lang->line('config_value_updated')
						);
					$this->response($success,200); 
			 }
		  
		  }
		  else
		  {
			 
		  		$error = array(
					'response' => 'error',
					//'msg'	 => 'Config {$config_name} item does not exists.'
					'msg'	 => $this->lang->line('config_doesnot_exists')
					);
  	 			$this->response($error,200); 
		  }

	   }
	   else
	   {
	   		$error = array(
					'response' => 'error',
					'msg'	 => $this->lang->line('invalid_request')
					);
  	 		$this->response($error,200); 
	   }
	   
	}
	
	public function get_values_get(){
		 $network_id = $this->get('network_id');
		 $agency_id = $this->get('agency_id');
		 if($network_id){
		 	 $res = $this->Do_app_config->fetch($network_id,$agency_id);
			 $this->response($res,200); 
			 
		 }
	}

	public function geo_fencing_get()
	{
		$geo_fencing=$this->Do_app_config->geo_fencing();
		
		if($geo_fencing)
		{
			$this->response($geo_fencing[0]['config_value'],200);
		}

	}
}
