<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Analytics (Generalize Things)
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Antifraud_click_stats extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_antifraud');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
	/* 
	* name: fetch_anti_fraud_stats_list
	* @param : null
	* @return : list of anti fraud statistics.
    */
	public function fetch_anti_fraud_stats_list_get()
	{
	   $agencyid=$this->user_authentication->agency_id;
	   $stats_list=$this->Do_antifraud->antifraud_list($agencyid);
		 if($stats_list)
		   $this->response($stats_list,200);
		 else 
		  $this->response( array('response'=>'error'), 200);
	}
	
		/* 
	* name: fetch_anti_valid_stats_list_get
	* @param : null
	* @return : list of valid statistics.
    */
	public function fetch_anti_valid_stats_list_get()
	{
	   $agencyid=$this->user_authentication->agency_id;
	   $stats_list=$this->Do_antifraud->antifraud_statistics_list($agencyid);
		 if($stats_list)
		   $this->response($stats_list,200);
		 else 
		  $this->response( array('response'=>'error'), 200);
	}
	
	/*
	* 
	* name: fetch_anti_penality_list
	* @param : null
	* @return : list of anti penality
    */	
	public function fetch_anti_penality_list_get()
	{ 
	  $agencyid=$this->user_authentication->agency_id;
		 $penality=$this->Do_antifraud->penality_list($agencyid);
		 if($penality)
		   $this->response($penality,200);
		 else 
		  $this->response( array('response'=>'error'), 200);
	}
	
	/*
	* 
	* name: fetch_anti_fraud_stats_filter
	* @param : null
	* @return : network created date
    */	
	public function fetch_anti_fraud_stats_filter_get()
	{
	  $agencyid=$this->user_authentication->agency_id;
	   $from_dt =$this->get('f_date');
	   $to_dt	=$this->get('t_date');
	   $stats_list=$this->Do_antifraud->antifraud_statistics_filter($agencyid,$from_dt,$to_dt);
		 if($stats_list)
		   $this->response($stats_list,200);
		 else 
		  $this->response( array('response'=>'error'), 200);
	}
	
	/*
	* 
	* name: fetch_anti_penality_stats_filter
	* @param : null
	* @return : network created date
    */	
	public function fetch_anti_penality_stats_filter_get()
	{
	  $agencyid=$this->user_authentication->agency_id;
	   $from_dt =$this->get('f_date');
	   $to_dt	=$this->get('t_date');
	   $stats_list=$this->Do_antifraud->penality_statistics_filter($agencyid,$from_dt,$to_dt);
		 if($stats_list)
		   $this->response($stats_list,200);
		 else 
		  $this->response( array('response'=>'error'), 200);
	}	 

}
