<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Analytics (Generalize Things)
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Analytics extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_analytics');
	}
	/*
	 * 
	 * name: 
	 * @param
	 * @return
	 */
	 function fraudclicks_get()
	 {	 
		
		 $category=$this->Do_category->list_category($parent);

		 $this->response($category, 200); // 200 being the HTTP response code
		 
	 }	

	/*
	 * 
	 * name: countrylist_get
	 * @param
	 * @return
	 */
	 function countrylist_get()
	 {
		 
		 $country=$this->Do_country->list_country();	
		 
		  if($country)
		 {
			 $this->response($country, 200); // 200 being the HTTP response code
		 }
		 else
		 {
				$this->response(array('error'=>$this->lang->line('country_not_found')),404);
		 }
		 
	 }
	 
	
	/*
	 * 
	 * name: unknown
	 * @param
	 * @return
	 */
	 function currencylist_get()
	 {
		 
		 $currency=$this->Do_currency->list_currency();	
		 
		  if($currency)
		 {
			 $this->response($currency, 200); // 200 being the HTTP response code
		 }
		 else
		 {
				$this->response(array('error'=>$this->lang->line('curr_not_fnd')),404);
		 }
		 
	 }
	 
	 /*
	 * name: fetch_type_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will get all the campaign type
	 * 
	 */
	public function fetch_type_get()
	{
		$type = $this->Do_campaign->fetch_type();

		if($type)
		{
			$this->response($type, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('campaign_type_not_found')),200);
		}
	}
	 
	 /*
	 * name: fetch_target_browsers_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target browsers available
	 * 
	 */
	public function fetch_target_browsers_get()
	{
		$browser_options = $this->Do_targeting->fetch_targ_options('browser');

		if($browser_options)
		{
			$this->response($browser_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_browsers_available')),200);
		}
	}
	 /*
	 * name: fetch_target_os_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target os available
	 * 
	 */
	public function fetch_target_os_get()
	{
		$os_options = $this->Do_targeting->fetch_targ_options('os');

		if($os_options)
		{
			$this->response($os_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_os_available')),200);
		}
	}
	 /*
	 * name: fetch_target_countries_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target countries available
	 * 
	 */
	public function fetch_target_countries_get()
	{
		$geo_options = $this->Do_targeting->fetch_targ_options('geo');

		if($geo_options)
		{
			$this->response($geo_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targeting_countries_available')),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_os_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target os available
	 * 
	 */
	public function fetch_target_mobile_os_get()
	{
		$mobile_os_options = $this->Do_targeting->fetch_targ_options('mobile_os');

		if($mobile_os_options)
		{
			$this->response($mobile_os_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targeting_countries_available')),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_manu_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target manufacturers available
	 * 
	 */
	public function fetch_target_mobile_manu_get()
	{
		$mobile_manu_options = $this->Do_targeting->fetch_targ_options('mobile_manu');

		if($mobile_manu_options)
		{
			$this->response($mobile_manu_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targeting_countries_available')),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_telcom_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target telecom operators available available
	 * 
	 */
	public function fetch_target_mobile_telcom_get()
	{
		$mobile_manu_options = $this->Do_targeting->fetch_targ_options('mobile_telecom');

		if($mobile_manu_options)
		{
			$this->response($mobile_manu_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targeting_countries_available')),200);
		}
	}
	 /*
	 * name: fetch_target_mobile_capability_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the target cabality available
	 * 
	 */
	public function fetch_target_mobile_capability_get()
	{
		$mobile_manu_options = $this->Do_targeting->fetch_targ_options('mobile_capability');

		if($mobile_manu_options)
		{
			$this->response($mobile_manu_options, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>$this->lang->line('no_targeting_countries_available')),200);
		}
	}
	
	/*
	 * 
	 * name: fetch_browser_get
	 * @param :
	 * @return : $browser_list
	 * 
	 * Lists browser for reports
	 */
	
	function fetch_browser_get()
	{
		$network_account_id	=	$this->get('network_account_id');
		$network_id			=	$this->get('network_id');		
		
		if($network_account_id)
		{
			$browser = 	$this->Do_analytics->fetch_browser($network_id,$network_account_id);
		}
		else
		{
			$browser = 	$this->Do_analytics->fetch_browser($network_id);
		}
		
		$chart	=	$this->convert_chart_data($browser);						
		echo "<pre>"; print_r($browser);exit;		
		
		/*$user= parse_user_agent($_SERVER['HTTP_USER_AGENT']);
		print_r($user);exit;*/
		
		$this->response($browser,200);
	}
	
	/*
	 * 
	 * name: fetch_ver_get
	 * @param :
	 * @return : $browser_list
	 * 
	 * Lists browser for reports
	 */
	
	function fetch_ver_get()
	{
		$network_account_id	=	$this->get('network_account_id');
		$network_id			=	$this->get('network_id');	
		
		$browser='Firefox';	
		
		if($network_account_id)
		{
			$version = 	$this->Do_analytics->fetch_version($browser,$network_id,$network_account_id);
		}
		else
		{
			$version = 	$this->Do_analytics->fetch_version($browser,$network_id);
		}
		
		//echo "<pre>"; print_r($chart);exit;		
		//echo "<pre>"; print_r($version);exit;		
		/*$user= parse_user_agent($_SERVER['HTTP_USER_AGENT']);
		print_r($user);exit;*/
		
		$this->response($version,200);
	}
	
	/*
	 * 
	 * name: fetch_version_get
	 * @param :
	 * @return : $browser_version_list
	 * 
	 * Lists browser for reports
	 */
	
	function fetch_version_post()
	{
		$network_account_id	=	$this->post('network_account_id');
		$network_id			=	$this->post('account_id');
		$account_type		=	$this->post('account_type');
		$browser			=	$this->post('browser');						
		
		if($this->post('date_from') != ''){
			$search['date_from'] = $this->post('date_from'); 
		}
		
		if($this->post('date_to') != ''){
			$search['date_to'] = $this->post('date_to'); 
		}
		
		if($this->post('environment') != '' AND $this->post('environment') != 'all'){
			$search['environment'] = $this->post('environment'); 
		}
		
		if($this->post('pub_account_id') != '' AND $this->post('pub_account_id') != 'all'){
			$search['pub_account_id'] = $this->post('pub_account_id'); 
		}
		
		if($network_account_id)
		{
			if(isset($search))
			{
				$version 	= 	$this->Do_analytics->fetch_version($browser,$network_id,$network_account_id,$search);
			}
			else
			{
				$version 	= 	$this->Do_analytics->fetch_version($browser,$network_id,$network_account_id);
			}
		}
		else
		{
			if(isset($search))
			{
				$version 	= 	$this->Do_analytics->fetch_version($browser,$network_id,'',$search);
			}
			else
			{
				$version 	= 	$this->Do_analytics->fetch_version($browser,$network_id);	
			}			
		}		
		
		//echo "<pre>"; print_r($version);exit;		
		
		/*$user= parse_user_agent($_SERVER['HTTP_USER_AGENT']);
		print_r($user);exit;*/
		
		$this->response($version,200);
	}
	
	/*
	 * 
	 * name: fetch_browser_stats_post
	 * @param :
	 * @return : $browser_list
	 * 
	 * Lists browser for reports
	 */
	
	function fetch_browser_stats_post()
	{
		$network_account_id	=	$this->post('network_account_id');
		$network_id			=	$this->post('account_id');
		$account_type		=	$this->post('account_type');			
		
		if($this->post('date_from') != ''){
			$search['date_from'] = $this->post('date_from'); 
		}
		
		if($this->post('date_to') != ''){
			$search['date_to'] = $this->post('date_to'); 
		}
		
		if($this->post('environment') != '' AND $this->post('environment') != 'all'){
			$search['environment'] = $this->post('environment'); 
		}
		
		if($this->post('pub_account_id') != '' AND $this->post('pub_account_id') != 'all'){
			$search['pub_account_id'] = $this->post('pub_account_id'); 
		}
		
		if($network_account_id)
		{
			if(isset($search))
			{
				$browser 	= 	$this->Do_analytics->fetch_browser($network_id,$network_account_id,$search);
			}
			else
			{
				$browser 	= 	$this->Do_analytics->fetch_browser($network_id,$network_account_id);
			}
		}
		else
		{
			if(isset($search))
			{
				$browser 	= 	$this->Do_analytics->fetch_browser($network_id,'',$search);
			}
			else
			{
				$browser 	= 	$this->Do_analytics->fetch_browser($network_id);	
			}			
		}		
		
		$chart_data	=	$this->convert_chart_data($browser);						
		//GET the datatable object or request
		$datatable_obj = $this->post('datatable_obj');
		
		$no_records = ($browser !== FALSE)?count($browser):0;
		if($no_records)
		{	
			//$result_data['sEcho'] 				= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 		= $no_records;
			$result_data['iTotalDisplayRecords']= $no_records;
			$result_data['aaData'] 				= $browser;
			$result_data['overview_chart_data'] = $chart_data;
			
		}else{
			//$result_data['sEcho'] 				= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 		= $no_records;
			$result_data['iTotalDisplayRecords']= 0;
			$result_data['aaData'] 				= array();
			$result_data['overview_chart_data'] = '';		
		}
		// RETURN DATATABLE AND CHART DATA
		$this->response($result_data,200);
		
		//$this->response($browser,200);
	}
	
	function convert_chart_data($res)
	{	
		// Declaration
		$chart_data = 	array();
		$category 	= 	array();
		
		$ctr 		= 	array();
		
		$tot['IMP']	=	0;
		$tot['CLK']	=	0;
		$tot['CON']	=	0;
		$tot['UIMP']=	0;
		$tot['UCLK']=	0;
		
		if(!empty($res)):	
			foreach($res as $d):
				$tot['IMP']		+=	$d['IMP'];
				$tot['CLK']		+=	$d['CLK'];
				$tot['CON']		+=	$d['CON'];
				$tot['UIMP']	+=	$d['UIMP'];
				$tot['UCLK']	+=	$d['UCLK'];
			endforeach;
		endif;
		
		$i 			= 	0;
		$colors	=	array('#2f7ed8', '#0d233a','#8bbc21', '#910000','#1aadce', '#492970','#f28f43','#77a1e5','#c42525','#a6c96a');
		
		if(!empty($res))
		{
			foreach($res as $data)
			{
				$y[$i]	=	ROUND(($data['IMP']/$tot['IMP'])*100,2);
				foreach($data['data'] as $val)
				{
					$v_data[$i][]	=	ROUND(($val/$data['IMP'])*$y[$i],2);
				}
						
				//$colors		= 	array('#4572A7','#AA4643','#89A54E','#80699B','#3D96AE','#DB843D','#92A8CD','#A47D7C','#B5CA92');
				if($i<10)
				{
					$j=$i;
				}
				else
				{
					$j=$i%10;
				}
				
				$chart_data[$i]	= 	array(
										'y'			=>	$y[$i],
										'color'		=>	$colors[$j],
										'drilldown'	=>	array(
															'name'		=>	$data['browser'],
															'categories'=>	$data['version'],
															'data'		=>	array_map('floatval',$v_data[$i]),
															'color'		=>	$colors[$j]
															)
										);	
				
				$i++;	
			}
			$category = array_column($res,'browser');															
		}
			
		$success 	= 	array(
							'response' 		=> 	'ok',
							'chart_data'	=> 	$chart_data,
							'category'  	=>  $category,
							'total'			=> 	$tot
						);
		
		return 	$success;				
	
	}
	
	/*
	 * 
	 * name: fetch_client_get
	 * @param :
	 * @return : $client_list
	 * 
	 * Lists browser for reports
	 */
	
	function fetch_client_get()
	{
		$network_account_id	=	$this->get('network_account_id');
		$network_id			=	$this->get('network_id');		
		
		if($network_account_id)
		{
			$client_os = 	$this->Do_analytics->fetch_client_os($network_id,$network_account_id);
		}
		else
		{
			$client_os = 	$this->Do_analytics->fetch_client_os($network_id);
		}
		
		$chart	=	$this->convert_client_chart_data($client_os);						
		//echo "<pre>"; print_r($chart);exit;		
		//echo "<pre>"; print_r($client_os);exit;		
		
		/*$user= parse_user_agent($_SERVER['HTTP_USER_AGENT']);
		print_r($user);exit;*/
		
		$this->response($client_os,200);
	}
	
	/*
	 * 
	 * name: fetch_client_filter_get
	 * @param :
	 * @return : $fetch_client_filter_list
	 * 
	 * Lists browser for reports
	 */
	
	function fetch_client_filter_get()
	{
		$filter	=	$this->get('client_filter');
		
		if($filter)
		{
			$client_filter = 	$this->Do_analytics->fetch_client_filter($filter);
		}
		
		//echo "<pre>"; print_r($client_filter);exit;		
		//echo "<pre>"; print_r($client_os);exit;		
		
		/*$user= parse_user_agent($_SERVER['HTTP_USER_AGENT']);
		print_r($user);exit;*/
		
		$this->response($client_filter,200);
	}
	
	/*
	 * 
	 * name: fetch_client_stats_post
	 * @param :
	 * @return : $client_list
	 * 
	 * Lists domain for reports
	 */
	
	function fetch_client_stats_post()
	{
		$network_account_id	=	$this->post('network_account_id');
		$network_id			=	$this->post('account_id');
		$account_type		=	$this->post('account_type');			
		
		if($this->post('date_from') != ''){
			$search['date_from'] = $this->post('date_from'); 
		}
		
		if($this->post('date_to') != ''){
			$search['date_to'] = $this->post('date_to'); 
		}
		
		if($this->post('start') != ''){
			$search['start'] = $this->post('start'); 
		}
		
		if($this->post('end') != ''){
			$search['end'] = $this->post('end'); 
		}
		
		if($this->post('environment') != '' AND $this->post('environment') != 'all'){
			$search['environment'] = $this->post('environment'); 
		}
		
		if($this->post('pub_account_id') != '' AND $this->post('pub_account_id') != 'all'){
			$search['pub_account_id'] = $this->post('pub_account_id'); 
		}
		
		if($this->post('flash') != '' AND $this->post('flash') != 'all'){
			$search['flash'] = $this->post('flash'); 
		}
		
		if($this->post('screen') != '' AND $this->post('screen') != 'all'){
			$search['screen'] = $this->post('screen'); 
		}
		
		if($network_account_id)
		{
			if(isset($search))
			{
				$client_os 	= 	$this->Do_analytics->fetch_client_os($network_id,$network_account_id,$search);
			}
			else
			{
				$client_os 	= 	$this->Do_analytics->fetch_client_os($network_id,$network_account_id);
			}
		}
		else
		{
			if(isset($search))
			{
				$client_os 	= 	$this->Do_analytics->fetch_client_os($network_id,'',$search);
			}
			else
			{
				$client_os 	= 	$this->Do_analytics->fetch_client_os($network_id);	
			}			
		}		

						
		$chart_data	=	$this->convert_client_chart_data($client_os);						
		//GET the datatable object or request
		$datatable_obj = $this->post('datatable_obj');
		
		$no_records = ($client_os !== FALSE)?count($client_os):0;
		if($no_records)
		{	
			//$result_data['sEcho'] 				= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 		= $no_records;
			$result_data['iTotalDisplayRecords']= $no_records;
			$result_data['aaData'] 				= $client_os;
			$result_data['overview_chart_data'] = $chart_data;
			
		}else{
			//$result_data['sEcho'] 				= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 		= $no_records;
			$result_data['iTotalDisplayRecords']= 0;
			$result_data['aaData'] 				= array();
			$result_data['overview_chart_data'] = '';		
		}
		// RETURN DATATABLE AND CHART DATA
		$this->response($result_data,200);
		
		//$this->response($browser,200);
	}
	
	function convert_client_chart_data($res)
	{	
		// Declaration
		$chart_data = 	array();
		$category 	= 	array();
		
		$ctr 		= 	array();
		
		$tot['IMP']	=	0;
		$tot['CLK']	=	0;
		$tot['CON']	=	0;
		$tot['UIMP']=	0;
		$tot['UCLK']=	0;
		
		if(!empty($res)):	
			foreach($res as $d):
				$tot['IMP']		+=	$d['IMP'];
				$tot['CLK']		+=	$d['CLK'];
				$tot['CON']		+=	$d['CON'];
				$tot['UIMP']	+=	$d['UIMP'];
				$tot['UCLK']	+=	$d['UCLK'];
			endforeach;
		endif;
		
		$i 			= 	0;
		
		if(!empty($res))
		{
			foreach($res as $data)
			{	
				if($data['os']!='')
				{
					$chart_data['data'][$i]	=	array($data['os'],ROUND($data['IMP'],2));
				}
				else
				{
					$chart_data['data'][$i]	=	array('Others',ROUND($data['IMP'],2));
				}
				$i++;	
			}
			$category = array_column($res,'os');															
		}
		
			
		$success 	= 	array(
							'response' 		=> 	'ok',
							'chart_data'	=> 	$chart_data,
							'category'  	=>  $category,
							'total'			=> 	$tot
						);
		
		return 	$success;				
	
	}
	
	/*
	 * 
	 * name: fetch_mobile_device_get
	 * @param :
	 * @return : $mobile_device_list
	 * 
	 * Lists browser for reports
	 */
	
	function fetch_mobile_device_get()
	{
		$network_account_id	=	$this->get('network_account_id');
		$network_id			=	$this->get('network_id');		
		
		if($network_account_id)
		{
			$mobile_device = 	$this->Do_analytics->fetch_mobile_device($network_id,$network_account_id);
		}
		else
		{
			$mobile_device = 	$this->Do_analytics->fetch_mobile_device($network_id);
		}
		
		//$chart	=	$this->convert_mobile_device_chart_data($mobile_device);						
		//echo "<pre>"; print_r($chart);exit;		
		//echo "<pre>"; print_r($client_os);exit;		
		
		/*$user= parse_user_agent($_SERVER['HTTP_USER_AGENT']);
		print_r($user);exit;*/
		
		$this->response($mobile_device,200);
	}
	
	/*
	 * 
	 * name: fetch_mobile_device_stats_post
	 * @param :
	 * @return : $mobile_list
	 * 
	 * Lists domain for reports
	 */
	
	function fetch_mobile_device_stats_post()
	{
		$network_account_id	=	$this->post('network_account_id');
		$network_id			=	$this->post('account_id');
		$account_type		=	$this->post('account_type');			
		
		if($this->post('date_from') != ''){
			$search['date_from'] = $this->post('date_from'); 
		}
		
		if($this->post('date_to') != ''){
			$search['date_to'] = $this->post('date_to'); 
		}
		
		if($this->post('start') != ''){
			$search['start'] = $this->post('start'); 
		}
		
		if($this->post('end') != ''){
			$search['end'] = $this->post('end'); 
		}
		
		if($this->post('environment') != '' AND $this->post('environment') != 'all'){
			$search['environment'] = $this->post('environment'); 
		}
		
		if($this->post('pub_account_id') != '' AND $this->post('pub_account_id') != 'all'){
			$search['pub_account_id'] = $this->post('pub_account_id'); 
		}
				
		if($network_account_id)
		{
			if(isset($search))
			{
				$mobile_device 	= 	$this->Do_analytics->fetch_mobile_device($network_id,$network_account_id,$search);
			}
			else
			{
				$mobile_device 	= 	$this->Do_analytics->fetch_mobile_device($network_id,$network_account_id);
			}
		}
		else
		{
			if(isset($search))
			{
				$mobile_device 	= 	$this->Do_analytics->fetch_mobile_device($network_id,'',$search);
			}
			else
			{
				$mobile_device 	= 	$this->Do_analytics->fetch_mobile_device($network_id);	
			}			
		}		

						
		$chart_data	=	$this->convert_mobile_device_chart_data($mobile_device);						
		//GET the datatable object or request
		$datatable_obj = $this->post('datatable_obj');
		
		$no_records = ($mobile_device !== FALSE)?count($mobile_device):0;
		if($no_records)
		{	
			//$result_data['sEcho'] 				= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 		= $no_records;
			$result_data['iTotalDisplayRecords']= $no_records;
			$result_data['aaData'] 				= $mobile_device;
			$result_data['overview_chart_data'] = $chart_data;
			
		}else{
			//$result_data['sEcho'] 				= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 		= $no_records;
			$result_data['iTotalDisplayRecords']= 0;
			$result_data['aaData'] 				= array();
			$result_data['overview_chart_data'] = '';		
		}
		// RETURN DATATABLE AND CHART DATA
		$this->response($result_data,200);
		
		//$this->response($browser,200);
	}
	
	function convert_mobile_device_chart_data($res)
	{	
		// Declaration
		$chart_data = 	array();
		$category 	= 	array();
		
		$ctr 		= 	array();
		
		$tot['IMP']	=	0;
		$tot['CLK']	=	0;
		$tot['CON']	=	0;
		$tot['UIMP']=	0;
		$tot['UCLK']=	0;
		
		if(!empty($res)):	
			foreach($res as $d):
				$tot['IMP']		+=	$d['IMP'];
				$tot['CLK']		+=	$d['CLK'];
				$tot['CON']		+=	$d['CON'];
				$tot['UIMP']	+=	$d['UIMP'];
				$tot['UCLK']	+=	$d['UCLK'];
			endforeach;
		endif;
		
		$i 			= 	0;
		
		if(!empty($res))
		{
			foreach($res as $data)
			{	
				if($data['model_name']!='' && $data['model_name']!='0')
				{
					$chart_data['data'][$i]	=	array($data['model_name'],ROUND($data['IMP'],2));
					$i++;	
				}
				/*else
				{
					$chart_data['data'][$i]	=	array('Others',ROUND($data['IMP'],2));
				}*/
				//$i++;	
			}
			$category = array_column($res,'model_name');															
		}
		
			
		$success 	= 	array(
							'response' 		=> 	'ok',
							'chart_data'	=> 	$chart_data,
							'category'  	=>  $category,
							'total'			=> 	$tot
						);
		
		return 	$success;				
	
	}
	
	function convert_domain_chart_data($res,$search=FALSE)
	{	
		// Declaration
		$chart_data = 	array();
		$chart = 	array();
		
			
		$ctr 		= 	array();
		
		$tot['IMP']	=	0;
		$tot['CLK']	=	0;
		$tot['CON']	=	0;
		$tot['UIMP']=	0;
		$tot['UCLK']=	0;
		
		if(!empty($res)):	
			foreach($res as $d):
				$tot['IMP']		+=	$d['IMP'];
				$tot['CLK']		+=	$d['CLK'];
				$tot['CON']		+=	$d['CON'];
				$tot['UIMP']	+=	$d['UIMP'];
				$tot['UCLK']	+=	$d['UCLK'];
			endforeach;
		endif;
		
				
		if(!empty($res))
		{
			foreach($res as $data)
			{
				$chart[$data['date']]	=	ROUND($data['IMP'],2);
			}
		}
		
		$s = strtotime($search['date_from']);
		$e = strtotime($search['date_to']);
		$d = $e-$s;
		$diff = floor($d/(3600*24));
		
		for($i=0;$i<=$diff;$i++)
		{
		
			$start = date('Y-m-d',mktime(0,0,0,date('m',strtotime($search['date_from'])),date('d',strtotime($search['date_from']))+$i,date('Y',strtotime($search['date_from']))));
			
			if(isset($chart[$start]))
			{
				$chart_data[] = $chart[$start];
			}
			else
			{
				$chart_data[] = 0;
			}
		}
		
					
		$success 	= 	array(
							'response' 		=> 	'ok',
							'chart_data'	=> 	$chart_data,
							'total'			=> 	$tot,
							'date' => date('d', $s),
							'month' => date('m', $s),
							'year' => date('Y', $s)
						);
		
		return 	$success;				
	
	}
	
	
	 function convert_referral_chart_data($res)
	{	
		// Declaration
		$chart_data = 	array();
		$category 	= 	array();
		
		$ctr 		= 	array();
		
		$tot['IMP']	=	0;
		$tot['CLK']	=	0;
		$tot['CON']	=	0;
		$tot['UIMP']=	0;
		$tot['UCLK']=	0;
		
		if(!empty($res)):	
			foreach($res as $d):
				$tot['IMP']		+=	$d['IMP'];
				$tot['CLK']		+=	$d['CLK'];
				$tot['CON']		+=	$d['CON'];
				$tot['UIMP']	+=	$d['UIMP'];
				$tot['UCLK']	+=	$d['UCLK'];
			endforeach;
		endif;
		
		$i 			= 	0;
		
		if(!empty($res))
		{
			foreach($res as $data)
			{	
				$url[$i] = parse_url($data['site_url']);
				
				$page_name = substr($url[$i]['path'],strrpos($url[$i]['path'],"/")+1);
				
				if($data['site_url']!='')
				{
					$chart_data['data'][$i]	=	array($page_name,ROUND($data['IMP'],2));
				}
				else
				{
					$chart_data['data'][$i]	=	array('Others',ROUND($data['IMP'],2));
				}
				$i++;	
			}
			$category = array_column($res,'os');															
		}
		
			
		$success 	= 	array(
							'response' 		=> 	'ok',
							'chart_data'	=> 	$chart_data,
							'category'  	=>  $category,
							'total'			=> 	$tot
						);
		
		return 	$success;				
	
	}
	
	/*
	 * 
	 * name: fetch_browser_get
	 * @param :
	 * @return : $browser_list
	 * 
	 * Lists browser for reports
	 */
	
	function fetch_dom_get()
	{
		$network_account_id	=	$this->get('network_account_id');
		$network_id			=	$this->get('network_id');		
		$domain = $this->get('domain');
		$start=$this->get('start');
		$end = $this->get('end');
		$limit = array('start'=>$start,'end'=>$end);
		if($network_account_id)
		{
			$browser = 	$this->Do_analytics->fetch_domain($network_id,$network_account_id);
		}
		else
		{
			$browser = 	$this->Do_analytics->fetch_domain($network_id,'','',1);
			$sites = 	$this->Do_analytics->fetch_domain_sites($domain,$network_id);
			$search = array('date_from'=>'2013-10-07','date_to'=>'2013-11-27');
			$chart_data	=	$this->convert_referral_chart_data($sites);
		}
		
		//$date = $this->Do_analytics->get_start_date();
		//echo $date; exit;
		
		//$chart	=	$this->convert_chart_data($browser);						
		echo "<pre>"; print_r($chart_data);exit;		
		
		/*$user= parse_user_agent($_SERVER['HTTP_USER_AGENT']);
		print_r($user);exit;*/
		
		$this->response($browser,200);
	}
	
	
	/*
	 * 
	 * name: fetch_domain_stats_post
	 * @param :
	 * @return : $domain_list
	 * 
	 * Lists domain for reports
	 */
	
	function fetch_domain_stats_post()
	{
		$network_account_id	=	$this->post('network_account_id');
		$network_id			=	$this->post('account_id');
		$account_type		=	$this->post('account_type');			

		
		if($this->post('date_from') != ''){
			$search['date_from'] = $this->post('date_from'); 
		}
		
		if($this->post('pub_account_id') != '' AND $this->post('pub_account_id') != 'all'){
			$search['pub_account_id'] = $this->post('pub_account_id'); 
		}
		
		if($this->post('date_to') != ''){
			$search['date_to'] = $this->post('date_to'); 
		}
		
		if($this->post('start') != ''){
			$search['start'] = $this->post('start'); 
		}
		
		if($this->post('end') != ''){
			$search['end'] = $this->post('end'); 
		}
		
		if($this->post('environment') != '' AND $this->post('environment') != 'all'){
			$search['environment'] = $this->post('environment'); 
		}
		
		if($network_account_id)
		{
			if(isset($search))
			{
				$domain 	= 	$this->Do_analytics->fetch_domain($network_id,$network_account_id,$search,0);
				$domain_chart 	= 	$this->Do_analytics->fetch_domain($network_id,$network_account_id,$search,1);
			}
			else
			{
				$domain 	= 	$this->Do_analytics->fetch_domain($network_id,$network_account_id,0);
				$domain_chart 	= 	$this->Do_analytics->fetch_domain($network_id,$network_account_id,1);
			}
		}
		else
		{
			if(isset($search))
			{
				$domain 	= 	$this->Do_analytics->fetch_domain($network_id,'',$search,0);
				$domain_chart 	= 	$this->Do_analytics->fetch_domain($network_id,'',$search,1);
			}
			else
			{
				$domain 	= 	$this->Do_analytics->fetch_domain($network_id,0);
				$domain_chart 	= 	$this->Do_analytics->fetch_domain($network_id,1);
			}			
		}		

						
		$chart_data	=	$this->convert_domain_chart_data($domain_chart,$search);						
		//GET the datatable object or request
		$datatable_obj = $this->post('datatable_obj');
		
		$no_records = ($domain !== FALSE)?count($domain):0;
		if($no_records)
		{	
			//$result_data['sEcho'] 				= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 		= $no_records;
			$result_data['iTotalDisplayRecords']= $no_records;
			$result_data['aaData'] 				= $domain;
			$result_data['overview_chart_data'] = $chart_data;
			
		}else{
			//$result_data['sEcho'] 				= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 		= $no_records;
			$result_data['iTotalDisplayRecords']= 0;
			$result_data['aaData'] 				= array();
			$result_data['overview_chart_data'] = '';		
		}
		// RETURN DATATABLE AND CHART DATA
		$this->response($result_data,200);
		
		//$this->response($browser,200);
	}
	
	/*
	 * 
	 * name: fetch_version_get
	 * @param :
	 * @return : $browser_version_list
	 * 
	 * Lists browser for reports
	 */
	
	function fetch_referral_stats_post()
	{
		$network_account_id	=	$this->post('network_account_id');
		$network_id			=	$this->post('account_id');
		$account_type		=	$this->post('account_type');
		$dom			=	$this->post('domain');						
		
		if($dom!='')
		{
			$domain = $dom;
		}
		else
		{
			$domain = '';
		}
		
		
		if($this->post('pub_account_id') != '' AND $this->post('pub_account_id') != 'all'){
			$search['pub_account_id'] = $this->post('pub_account_id'); 
		}
		
		if($this->post('date_from') != ''){
			$search['date_from'] = $this->post('date_from'); 
		}
		
		if($this->post('date_to') != ''){
			$search['date_to'] = $this->post('date_to'); 
		}
		
		if($this->post('environment') != '' AND $this->post('environment') != 'all'){
			$search['environment'] = $this->post('environment'); 
		}
		
		if($network_account_id)
		{
			if(isset($search))
			{
				$referral_sites 	= 	$this->Do_analytics->fetch_domain_sites($domain,$network_id,$network_account_id,$search);
			}
			else
			{
				$referral_sites 	= 	$this->Do_analytics->fetch_domain_sites($domain,$network_id,$network_account_id);
			}
		}
		else
		{
			if(isset($search))
			{
				$referral_sites 	= 	$this->Do_analytics->fetch_domain_sites($domain,$network_id,'',$search);
			}
			else
			{
				$referral_sites 	= 	$this->Do_analytics->fetch_domain_sites($domain,$network_id);	
			}			
		}		
		
		
		$chart_data	=	$this->convert_referral_chart_data($referral_sites);						
		//GET the datatable object or request
		$datatable_obj = $this->post('datatable_obj');
		
		$no_records = ($referral_sites !== FALSE)?count($referral_sites):0;
		if($no_records)
		{	
			//$result_data['sEcho'] 				= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 		= $no_records;
			$result_data['iTotalDisplayRecords']= $no_records;
			$result_data['aaData'] 				= $referral_sites;
			$result_data['overview_chart_data'] = $chart_data;
			
		}else{
			//$result_data['sEcho'] 				= $datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 		= $no_records;
			$result_data['iTotalDisplayRecords']= 0;
			$result_data['aaData'] 				= array();
			$result_data['overview_chart_data'] = '';		
		}
		// RETURN DATATABLE AND CHART DATA
		$this->response($result_data,200);
				
		//$this->response($domain_sites,200);
	}
	
}
