<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for advertiser related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Suganthi
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Advertiser extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('Do_advertiser');
		$this->load->model('Do_email_check');
		$this->load->model('Do_publisher');
		$this->load->helper('email');
		$this->load->model('Do_networks');
		$this->load->model('Do_payments');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }

	}
	
	/**
       * 
       * name : fetch_get()
       * 
       * Fetches all advertiser information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_get()
	{	
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->account_id;
		$agency_id			=	$this->user_authentication->agency_id;
		$account_id			=	$this->get('account_id');
		$man_account_id		=	$this->get('man_account_id');
		$exchangeval		=	$this->get('exchangeval');
		
		if($account_id)
		{ 
			if($network_account_id)
			{
				$advertiser = 	$this->Do_advertiser->fetch($network_id,$network_account_id,$account_id,'',$exchangeval);
			}
			else
			{
				$advertiser = 	$this->Do_advertiser->fetch($network_id,'',$account_id,'',$exchangeval);
			}
		}
		else if($man_account_id)
		{
			$advertiser = 	$this->Do_advertiser->fetch($network_id,'','',$man_account_id,$exchangeval);
		}
		else
		{
			if($network_account_id)
			{
				$advertiser = 	$this->Do_advertiser->fetch($network_id,$network_account_id,'','',$exchangeval);
			}
			else
			{
				$advertiser = 	$this->Do_advertiser->fetch($network_id,'','','',$exchangeval);
			}
		}
		
		if($advertiser)
		{
			
			$this->response($advertiser,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	//Fetch the affiliate advertisers for Admin
	
	function fetch_aff_advertiser_get()
	{	
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->account_id;
		$agency_id			=	$this->user_authentication->agency_id;
		$account_id			=	$this->get('account_id');
		$man_account_id		=	$this->get('man_account_id');
		
		if($account_id)
		{ 
			if($network_account_id)
			{
				$advertiser = 	$this->Do_advertiser->fetch_aff_advertiser($network_id,$network_account_id,$account_id);
			}
			else
			{
				$advertiser = 	$this->Do_advertiser->fetch_aff_advertiser($network_id,'',$account_id);
			}
		}
		else if($man_account_id)
		{
			$advertiser = 	$this->Do_advertiser->fetch_aff_advertiser($network_id,'','',$man_account_id);
		}
		else
		{
			if($network_account_id)
			{
				$advertiser = 	$this->Do_advertiser->fetch_aff_advertiser($network_id,$network_account_id);
			}
			else
			{
				$advertiser = 	$this->Do_advertiser->fetch_aff_advertiser($network_id);
			}
		}
		
		if($advertiser)
		{
			
			$this->response($advertiser,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	
	/**
       * 
       * name : fetch_get()
       * 
       * Fetches all advertiser information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_advertiser_get()
	{	
		$account_id			=	$this->get('account_id');
		
		if($account_id)
		{
			if($network_account_id)
			{
				$advertiser = 	$this->Do_advertiser->fetch($network_id,$network_account_id,$account_id);
			}
			else
			{
				$advertiser = 	$this->Do_advertiser->fetch($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{
				$advertiser = 	$this->Do_advertiser->fetch($network_id,$network_account_id);
			}
			else
			{
				$advertiser = 	$this->Do_advertiser->fetch($network_id);
			}
		}
		
		if($advertiser)
		{
			
			$this->response($advertiser,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	/**
       * 
       * name : campaign_count_get()
       * 
       * Fetches all campaign count.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function campaign_count_get()
	{	
		$network_account_id		=	$this->user_authentication->network_account_id;
		$network_id				=	$this->user_authentication->account_id;
		$account_id				=	$this->get('account_id');
		
		if($account_id)
		{
			if($network_account_id)
			{
				$count = 	$this->Do_advertiser->campaign_count($network_id,$network_account_id,$account_id);
			}
			else
			{
				$count = 	$this->Do_advertiser->campaign_count($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{
				$count = 	$this->Do_advertiser->campaign_count($network_id,$network_account_id);
			}
			else
			{
				$count = 	$this->Do_advertiser->campaign_count($network_id);
			}
		}
		if($count)
		{		
			$this->response($count,200);
		}
		else
		{
			$this->response('0', 200);
		}
	}

	/*07-08-2015
		Advertiser Count
		
	*/

	function adv_count_get()
	{
		$network_account_id = $this->user_authentication->network_account_id;
		$network_id = $this->user_authentication->account_id;
		$account_id = $this->get('account_id');

		if ($account_id) {
			if ($network_account_id) {
				$count = $this->Do_advertiser->adv_count($network_id, $network_account_id, $account_id);
			} else {
				$count = $this->Do_advertiser->adv_count($network_id, '', $account_id);
			}
		} else {
			if ($network_account_id) {
				$count = $this->Do_advertiser->adv_count($network_id, $network_account_id);
			} else {
				$count = $this->Do_advertiser->adv_count($network_id);
			}
		}
		if ($count) {
			$this->response($count, 200);
		} else {
			$this->response('0', 200);
		}
	}
	/**
       * 
       * name : creative_count_get()
       * 
       * Fetches all campaign count.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function creative_count_get()
	{	
		$network_account_id		=	$this->user_authentication->network_account_id;
		$network_id				=	$this->user_authentication->account_id;
		$account_id				=	$this->get('account_id');
		$campaign_id			=	$this->get('campaign_id');
		
		if($account_id)
		{
			if($network_account_id)
			{
				if($campaign_id)
				{
					$count = 	$this->Do_advertiser->creative_count($network_id,$network_account_id,$account_id,$campaign_id);
				}
				else
				{
					$count = 	$this->Do_advertiser->creative_count($network_id,$network_account_id,$account_id);
				}
			}
			else
			{
				if($campaign_id)
				{
					$count = 	$this->Do_advertiser->creative_count($network_id,'',$account_id,$campaign_id);
				}
				else
				{
					$count = 	$this->Do_advertiser->creative_count($network_id,'',$account_id);
				}
			}
		}
		else
		{
			if($network_account_id)
			{
				$count = 	$this->Do_advertiser->creative_count($network_id,$network_account_id);
			}
			else
			{
				$count = 	$this->Do_advertiser->creative_count($network_id);
			}
		}
		
		if($count)
		{		
			$this->response($count,200);
		}
		else
		{
			$this->response('0', 200);
		}
	}
	
	//api/v1/advertiser/add
	function add_post()
	{	
		$this->form_validation->set_rules('first_name','lang:first_name', 'required|trim');
		$this->form_validation->set_rules('last_name', 'lang:last_name','required|trim');
		$this->form_validation->set_rules('email_id', 'lang:email_add', 'required|trim|is_email|callback_email_check');
		$this->form_validation->set_rules('logusername', 'lang:login_name','trim|required|callback_username_check');
		$this->form_validation->set_rules('password', 'lang:user_pass','required|trim');
		$this->form_validation->set_rules('confirm_password', 'lang:confirm_password','required|trim|matches[password]');

		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$network_id		=	get_session('network_account_id');
			$acc_type 		= get_session('account_type');
			
			if($acc_type == 'ADMIN')
			{
				$account_id	= 2;
			}
			else
			{
				$account_id		=	get_session('account_id');
			}
			
			$pwd 			= $this->post('password');
			$encrypted_pwd 	= $this->encrypt->encode($pwd);
			
			$user_currency = $this->config->item('user_currency');

			if($this->post('geo_fencing'))
			{
				$geo_fencing=1;
			}else{
				$geo_fencing=0;
			}

			$add_data		=	array(
									'first_name'	=>	$this->post('first_name'),
									'last_name'		=>	$this->post('last_name'),
									'email'			=>	$this->post('email_id'),
									'login_username'=>	$this->post('logusername'),
									'password'		=>	$this->post('password'),
									'user_currency'	=>	$user_currency,
									'account_type'	=>	'ADVERTISER',
									'geo_fencing'	=>  $geo_fencing,
									'created_date'	=>	mdate('%Y-%m-%d %H:%i:%s',local_to_gmt())
									);

			if($network_id)
			{						
				$advertiser_add = 	$this->Do_advertiser->add($add_data,$account_id,$network_id);
			}
			else
			{
				$advertiser_add = 	$this->Do_advertiser->add($add_data,$account_id);
			}
			
			if($advertiser_add != FALSE)
			{	
				// SEND LOGIN DETAILS to USER
				if($this->user_authentication->account_type == "ADMIN" )
				{
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->Do_networks->agency_owner_details($agency_id);	
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$account_type=$advertiser_add['account_type'];
					$account_id=$advertiser_add['account_id'];
					$account_type  = $add_data['account_type'];
					$user_email    = $add_data['email'];
					$login_name    = $add_data['login_username'];
					$password      = $pwd;
					$user_name     = $add_data['first_name']." ".$add_data['last_name'];
					$type          = 'ADV_LOGIN_CREDENTIAL';		
					$from 	       = $admin_email;
					$to  	       = $user_email;		
					$mail_content=array(
						"subject" 		=> $this->lang->line('login_credentials'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						"login_name"  	=> $login_name,
						"password"		=> $password								
						);			
						send_mail($type,$from,$to,$mail_content);
					

					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	$this->lang->line('advertiser_added_success')
									);
					$this->response( $success, 200);
				}
				else
				{
					// IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
					$manager_user_id = $this->user_authentication->manager_user_id;
					$is_manager = $this->Do_networks->get_manager_role($manager_user_id);
					if($is_manager == 1)
					{
						// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->Do_networks->agency_owner_details($agency_id);
						// IF NOT NETWORK ADMIN ADMIN SEND BCC
						$network_admin=$this->Do_networks->get_network_details();
						$bcc		   = $network_admin['email'];
						$admin_name    = $result['name'];			
						$admin_email   = $result['email'];
						$account_type=$advertiser_add['account_type'];
						$account_id=$advertiser_add['account_id'];
						$account_type  = $add_data['account_type'];
						$user_email    = $add_data['email'];
						$login_name    = $add_data['login_username'];
						$password      = $pwd;
						$user_name     = $add_data['first_name']." ".$add_data['last_name'];
						$type          = 'ADV_LOGIN_CREDENTIAL';		
						$from 	       = $admin_email;
						$to  	       = $user_email;			
						$mail_content=array(
							"subject" 		=> $this->lang->line('login_credentials'),
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,
							"email"  		=> $user_email,
							"login_name"  	=> $login_name,
							"password"		=> $password								
							);			
						$attachement = "";	
						send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
						

						$success 	= 	array(
											'response' 	=> 	'ok',
											'msg'	 	=> 	$this->lang->line('advertiser_added_success')
										);
						$this->response( $success, 200);
					}
					else
					{
						// GET NETWORK USERS MAILING DETAILS
						$user_mailing_details = $this->Do_networks->get_network_users_detail($manager_user_id);
						$admin_email = $user_mailing_details['email_address'];
						$admin_name = $user_mailing_details['contact_name'];
						
						// GET NETWORK MANAGER MAILING DETAIL FOR BCC
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->Do_networks->agency_owner_details($agency_id);
						$bcc = $result['email'];
						
						$account_type=$advertiser_add['account_type'];
						$account_id=$advertiser_add['account_id'];
						$account_type  = $add_data['account_type'];
						$user_email    = $add_data['email'];
						$login_name    = $add_data['login_username'];
						$password      = $pwd;
						$user_name     = $add_data['first_name']." ".$add_data['last_name'];
						$type          = 'ADV_LOGIN_CREDENTIAL';		
						$from 	       = $admin_email;
						$to  	       = $user_email;			
						$mail_content=array(
							"subject" 		=> $this->lang->line('login_credentials'),
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,
							"email"  		=> $user_email,
							"login_name"  	=> $login_name,
							"password"		=> $password								
							);			
						$attachement = "";	
						send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
						

						$success 	= 	array(
											'response' 	=> 	'ok',
											'msg'	 	=> 	$this->lang->line('advertiser_added_success')
										);
						$this->response( $success, 200);
					}	
				}
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
								);
				$this->response( $error, 200);
			}
						
		}
	}
	
	
	/**
       * 
       * name : update_post()
       * 
       * Updates the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{

		$account_id	=	$this->post('account_id');
		
		$this->form_validation->set_rules('first_name','lang:first_name', 'required|trim');
		$this->form_validation->set_rules('last_name', 'lang:last_name','required|trim');
		#$this->form_validation->set_rules('email_id', 'Email Address', 'required|trim|is_email|callback_edit_email_check');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			$this->response( $error, 200);
		}
		else
		{
			if($this->post('geo_fencing'))
			{
				$geo_fencing=1;
			}else{
				$geo_fencing=0;
			}
			$update_data	=	array(
									'first_name'	=>	$this->post('first_name'),
									'last_name'		=>	$this->post('last_name'),
									'email'			=>	$this->post('email_id'),
									'login_username'=>	$this->post('logusername'),
									'account_type'	=>	'ADVERTISER',
									'geo_fencing'   =>  $geo_fencing,
									);
									
			$adv_update 	= 	$this->Do_advertiser->update($account_id,$update_data);
			
			if($adv_update != FALSE)
			{	
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	$this->lang->line('advertiser_updated_success')
									);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
									);
				$this->response( $error, 200);
			}			
		}
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the advertiser information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{	
		$account_id = $this->get('del_account_id');	
		
		if($account_id)
		{
			$advertiser_details = 	$this->Do_advertiser->get_profile($account_id);
			$advertiser = 	$this->Do_advertiser->remove($account_id);
			
			if($advertiser)
			{   
			    // SEND DELETION MESSAGE TO USER
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->Do_networks->agency_owner_details($agency_id);
				if($agency_id == 1)
				{
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $advertiser_details['email'];
					$user_name     = $advertiser_details['first_name']." ".$advertiser_details['last_name'];
					$type          = 'ADV_DELETION';		
					$from 	       = $admin_email;
					$to  	       = $user_email;			
					$mail_content  = array(
						"subject" 		=> $this->lang->line('adv_del'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email
						);			
					send_mail($type,$from,$to,$mail_content);
					$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('advertiser_deleted_success')
										);
					
					$this->response( $success, 200);
				}
				else
				{
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->Do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $advertiser_details['email'];
					$user_name     = $advertiser_details['first_name']." ".$advertiser_details['last_name'];
					$type          = 'ADV_DELETION';		
					$from 	       = $admin_email;
					$to  	       = $user_email;			
					$mail_content  = array(
						"subject" 		=> $this->lang->line('adv_del'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email
						);			
					send_mail($type,$from,$to,$mail_content);
					$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('advertiser_deleted_success')
										);
					
					$this->response( $success, 200);						
				}	
			}
			else
			{
				$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('error_try_again')
								);
			
				$this->response( $error, 200);
			}
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('advertiser_not_found')
								);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : block_get()
       * 
       * block the advertiser information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function block_get()
	{	
		$account_id = $this->get('block_account_id');	
		
		if($account_id)
		{
			$advertiser 	= 	$this->Do_advertiser->block($account_id);
			
			if($advertiser)
			{
				
				$advertiser_details 	= 	$this->Do_advertiser->get_profile($account_id);
				//SEND MAIL TO THE BLOCKED ADVERTISER
				if($this->user_authentication->account_type == "ADMIN" )
				{
					$agency_id	  =	$this->user_authentication->agency_id;
					$result       =$this->Do_networks->agency_owner_details($agency_id);		
					$admin_name    = $result['name'];		
					$admin_email   = $result['email'];
					$user_email    = $advertiser_details['email'];
					$user_name     = $advertiser_details['first_name'].' '.$advertiser_details['last_name'];
					$type     	   = "BLOCK_ADVERTISER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> $this->lang->line('advertiser_blocked'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					send_mail($type,$from,$to,$mail_content,$attachement);
					$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	$this->lang->line('advertiser_blocked_success')
									);
				
					$this->response( $success, 200);
				}
				else
				{
					// IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
					$manager_user_id = $this->user_authentication->manager_user_id;
					$is_manager = $this->Do_networks->get_manager_role($manager_user_id);
					if($is_manager == 1)
					{
						// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->Do_networks->agency_owner_details($agency_id);
						// IF NOT NETWORK ADMIN ADMIN SEND BCC
						$network_admin=$this->Do_networks->get_network_details();
						$bcc		   = $network_admin['email'];	
						$admin_name    = $result['name'];		
						$admin_email   = $result['email'];
						$user_email    = $advertiser_details['email'];
						$user_name     = $advertiser_details['first_name'].' '.$advertiser_details['last_name'];
						$type     	   = "BLOCK_ADVERTISER_ACCOUNT";
						$from 	       =  $admin_email;
						$to  	       =  $user_email;			
						$mail_content=array(
							"subject" 		=> $this->lang->line('advertiser_blocked'),
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,
							"email"  		=> $user_email,
							);
						$attachement='';	
						send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
						$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('advertiser_blocked_success')
										);
					
						$this->response( $success, 200);
					}
					else
					{
						// GET NETWORK USERS MAILING DETAILS
						$user_mailing_details = $this->Do_networks->get_network_users_detail($manager_user_id);
						$admin_email = $user_mailing_details['email_address'];
						$admin_name = $user_mailing_details['contact_name'];
						
						// GET NETWORK MANAGER MAILING DETAIL FOR BCC
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->Do_networks->agency_owner_details($agency_id);
						$bcc = $result['email'];
						
						$user_email    = $advertiser_details['email'];
						$user_name     = $advertiser_details['first_name'].' '.$advertiser_details['last_name'];
						$type     	   = "BLOCK_ADVERTISER_ACCOUNT";
						$from 	       =  $admin_email;
						$to  	       =  $user_email;			
						$mail_content=array(
							"subject" 		=> $this->lang->line('advertiser_blocked'),
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,
							"email"  		=> $user_email,
							);
						$attachement='';	
						send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
						$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('advertiser_blocked_success')
										);
					
						$this->response( $success, 200);
					}	
				}
			}
			else
			{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
									);
				
				$this->response( $error, 200);
			}
			
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('advertiser_not_found')
								);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : unblock_get()
       * 
       * block the advertiser information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function unblock_get()
	{	
		$account_id = $this->get('unblock_account_id');	
		
		if($account_id)
		{
			$advertiser 	= 	$this->Do_advertiser->unblock($account_id);
			
			if($advertiser)
			{
				$advertiser_details 	= 	$this->Do_advertiser->get_profile($account_id);
				//SEND MAIL TO THE BLOCKED ADVERTISER
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->Do_networks->agency_owner_details($agency_id);	
				if($agency_id==1)
				{		
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $advertiser_details['email'];
					$user_name     = $advertiser_details['first_name'].' '.$advertiser_details['last_name'];
					$type     	   = "UNBLOCK_ADVERTISER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> $this->lang->line('advertiser_blocked'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					send_mail($type,$from,$to,$mail_content,$attachement,$from);
					$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('advertiser_unblocked_success')
										);
					
					$this->response( $success, 200);
				}
				else
				{
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->Do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $advertiser_details['email'];
					$user_name     = $advertiser_details['first_name'].' '.$advertiser_details['last_name'];
					$type     	   = "UNBLOCK_ADVERTISER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> $this->lang->line('advertiser_blocked'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					send_mail($type,$from,$to,$mail_content,$attachement,$from,$bcc);
					$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	$this->lang->line('advertiser_unblocked_success')
										);
					
					$this->response( $success, 200);
				}
			}
			else
			{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	$this->lang->line('error_try_again')
									);
				
				$this->response( $error, 200);
			}
			
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	$this->lang->line('advertiser_not_found')
								);
			
			$this->response( $error, 200);
		}
	}
	
	
	/*
	 * 
	 * name: user_information
	 * @param :null
	 * @return : response Array
	 * 
	 * get the user information for particular Advertiser
	 */	
		 
	 public function user_information_get()
	 {	
		$account_id = $this->user_authentication->account_id;

		$user_info=$this->Do_advertiser->get_user_information($account_id);	  
		 
		 if($user_info)
		 {
			 $this->response($user_info, 200); // 200 being the HTTP response code
		 }
		
	 }
	
		
 /*
	 * 
	 * name: company_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the company Information for Particular Advertiser
	 */
	
    public function company_information_add_post()
    {		
		
		$this->form_validation->set_rules('company_name', 'lang:company_name', 'trim|required');
		$this->form_validation->set_rules('company_address', 'lang:company_address', 'trim|required');
		$this->form_validation->set_rules('company_block_no', 'lang:company_block_no', 'trim|required');
		$this->form_validation->set_rules('company_address', 'lang:company_address', 'trim|required');
		$this->form_validation->set_rules('company_state', 'lang:company_state', 'trim|required');
		$this->form_validation->set_rules('company_country', 'lang:company_country', 'trim|required');
		
		if($this->form_validation->run() === FALSE || $this->post('company_country') == '0')
		{
			$error_msg = $this->form_validation->error_array();			
					
			if($this->post('company_country') == '0')
			{
				$error = array(
								'response' => 'error',
								'msg' =>  $this->lang->line('chs_yr_cmpy_info')								
							);
				
			}
			else{
				$error = array(
								'response' => 'error',
								'msg' =>  $error_msg								
							);
										
			}

			 $this->response( $error, 200);
		}
		else
		{	
			
			$account_id = $this->user_authentication->account_id;
			
			$update_company_infoObj=array(							
										"company_name"  =>	$this->post('company_name'),
										"company_address"	=>	$this->post('company_address'),
										"company_block_no" 	=>	$this->post('company_block_no'),
										"company_city"	=>  $this->post('company_city'),
										"company_state" =>$this->post('company_state'),
										"company_country"=>$this->post('company_country'),
										"updated"=>mdate('%Y-%m-%d %H:%i:%s',local_to_gmt())
								);	
							
			
		    $this->Do_advertiser->update_companyinfo($account_id,$update_company_infoObj);
		    
		    
		    /* GET AGENCY ID FROM LIBRARY */
		    $agency_id	=	$this->user_authentication->agency_id;
			
			/* GET DEFAULT MANAGER EMAIL ID */
			$result=$this->Do_networks->agency_owner_details($agency_id);
			$admin_name    = $result['name'];			
			$admin_email   = $result['email'];		
			
			/* GET ADMIN EMAIL ID FOR bcc */
			$network_admin=$this->Do_networks->get_network_details();
			$bcc		   = $network_admin['email'];
			
			/* ADVERTISER DETAILS */
			$adv_result_array  =  $this->Do_advertiser->get_user_information($account_id);
			$adv_result		   =  $adv_result_array[0];
			$user_name  	   =  $adv_result['clientname'];
			$user_email		   =  $adv_result['email'];
			
			$type   ="COMPANY_INFORMATION";
			$from 	=  $admin_email;
			$to  	=  $user_email;	
			
			/* Gender values */
			$company_country=$this->Do_networks->country($this->post('company_country'));
				
			//SEND EMAIL TO ADVERTISERS
			$mail_content=array(
							"subject" 		=> $this->lang->line('advertiser_company_information'),
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,							
							"company_name"  =>	$this->post('company_name'),
							"company_address"	=>	$this->post('company_address'),
							"company_block_no" 	=>	$this->post('company_block_no'),
							"company_city"		=>  $this->post('company_city'),
							"company_state"		=>  $this->post('company_state'),
							"company_country" 	=> $company_country['name']	,
							"account_type"	    => "advertiser"			
							);
			/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
			$bcc=($bcc!=$admin_email)?$bcc:'';
			$attachement = "";		
					
			/* CALL HELPHER FILE */
			send_mail($type,$from,$to,$mail_content,$attachement,$bcc);			
			
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('advertiser/settings/company_information'),
							'msg'	 => $this->lang->line('company_updated_success')
			);
		
						
			$this->response($success, 200);
		}
		

	}
	
	 /*
	 * 
	 * name: personal_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the Personal Account Information for Particular Advertiser
	 */
	
    public function personal_information_add_post()
    {
		
		$this->form_validation->set_rules('first_name', 'lang:first_name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'lang:last_name', 'trim|required');
		$this->form_validation->set_rules('gender', 'lang:gender', 'trim|required');
		$this->form_validation->set_rules('date_of_birth', 'lang:dob', 'trim|required');
		$this->form_validation->set_rules('mobile_no', 'Mobile Number', 'trim|required');
		$this->form_validation->set_rules('city', 'lang:city', 'trim|required');
		$this->form_validation->set_rules('state', 'lang:state', 'trim|required');
		//~ $this->form_validation->set_rules('country', 'lang:Country', 'trim|required|callback_check_default');
		//~ $this->form_validation->set_message('check_default', 'You need to select your country');
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			
			$account_id = $this->user_authentication->account_id;
			$org_date = $this->post('date_of_birth');
			$date = new DateTime($org_date);
			$date_format=$date->format('Y-m-d'); // 2012-09-13
			
			$update_personal_infoObj=array(											
										"first_name"  =>	$this->post('first_name'),
										"last_name"	=>	$this->post('last_name'),
										"gender" 	=>	$this->post('gender'),
										"dob"	=> $date_format ,
										"mobile_number" =>$this->post('mobile_no'),
										"city" =>$this->post('city'),
										"state" =>$this->post('state'),
										"country" =>$this->post('country'),
										"updated"=>mdate('%Y-%m-%d %H:%i:%s',local_to_gmt())										
								);	
									
			$account_setting_type="personal";											
		
		    $this->Do_advertiser->update($account_id,$update_personal_infoObj,$account_setting_type);
		    
		    
		    //SEND EMAIL TO ADVERTISERS
		    
		    /* GET AGENCY ID FROM LIBRARY */
		    $agency_id	=	$this->user_authentication->agency_id;
			
			/* GET DEFAULT MANAGER EMAIL ID */
			$result=$this->Do_networks->agency_owner_details($agency_id);
			$admin_name    = $result['name'];			
			$admin_email   = $result['email'];		
			
			/* GET ADMIN EMAIL ID FOR bcc */
			$network_admin=$this->Do_networks->get_network_details();
			$bcc		   = $network_admin['email'];
			
			/* ADVERTISER DETAILS */
			$adv_result_array  =  $this->Do_advertiser->get_user_information($account_id);
			$adv_result		   =  $adv_result_array[0];
			$user_name  	   =  $adv_result['clientname'];
			$user_email		   =  $adv_result['email'];
			
			$type   ="PERSONAL_INFORMATION";
			$from 	=  $admin_email;
			$to  	=  $user_email;	
			/* Gender values */
			$gender=($this->post('gender')=='1')?'Male':'Female';
			$country=$this->Do_networks->country($this->post('country'));
				
			$mail_content=array(
							"subject" 		=> "Advertiser - Personal Information",
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,							
							"first_name"    => $this->post('first_name'),
							"last_name" 	=> $this->post('last_name'),
							"gender"    	=> $gender,
							"dob"	        => $date_format ,
							"mobile_number" => $this->post('mobile_no'),
							"city"          => $this->post('city'),
							"state"         => $this->post('state'),
							"country" 		=> $country['name'],
							"account_type"	=> "advertiser"		
							);			
			/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
			$bcc=($bcc!=$admin_email)?$bcc:'';
			$attachement = "";		
					
			/* CALL HELPHER FILE */
			send_mail($type,$from,$to,$mail_content,$attachement,$bcc);	
			
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('advertiser/settings/personal_information'),
							'msg'	 => $this->lang->line('personal_information_updated')
							);
		
						
			$this->response($success, 200);
		}

	}
	
	
/*
 * 
 * function to validate country
 * 
 */
 
function check_default($post_string)
{
  return $post_string == '0' ? FALSE : TRUE;
}
	 
	
		 
	/*
	 * 
	 * name: account_settings_add
	 * @param :null
	 * @return : response Array
	 * 
	 * Add/update the Account Setting Information for Particular Advertiser
	 */
	
    public function account_settings_add_post(){
		$this->form_validation->set_rules('email', 'lang:email', 'trim|required|valid_email|callback_acc_email_check');
		$this->form_validation->set_rules('logusername', 'lang:logusername', 'trim|required|callback_acc_username_check');
		//$this->form_validation->set_rules('another_email','Another Email','trim|required|valid_email');
		//$this->form_validation->set_rules('currency_to_view', 'Currency', 'trim|required');
		$this->form_validation->set_rules('password', 'New password', 'trim|matches[conf_password]');
		$this->form_validation->set_rules('conf_password', 'lang:confirm_password', 'trim|matches[password]');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();		
			$error = array(
								'response' => 'error',
								'msg' =>  $this->lang->line('email_address_exists')
							);

			 $this->response($error,200);
		}
		else{	
			
			$account_id = $this->user_authentication->account_id;
			$account_setting_type="account";		
				
			 //GET ADVERTISER CURRENT PASSWORD
			$db_old_pass=$this->Do_publisher->get_current_pass($account_id);
			
			$current_password=trim($this->post('current_password'));
			$encrypted_curr_pwd = password_encryptor($current_password);
			
			if($encrypted_curr_pwd == $db_old_pass || $current_password=='')
			{				
			$update_setting_infoObj=array(
										
										"email"  =>	$this->post('email'),
										"alternate_email"	=>	$this->post('another_email'),
										"currency" 	=>	$this->post('currency_to_view'),
										"password"=>$this->post('password'),
										"login_username"=>	$this->post('logusername'),
										"email_updated"=>mdate('%Y-%m-%d %H:%i:%s',local_to_gmt())
																	
								);	
								
		    $this->Do_advertiser->update($account_id,$update_setting_infoObj,$account_setting_type);
			
		    //SEND EMAIL TO ADVERTISERS -ACCOUNT SETTINGS
		   
		    /* GET AGENCY ID FROM LIBRARY */
		    $agency_id	=	$this->user_authentication->agency_id;
			
			/* GET DEFAULT MANAGER EMAIL ID */
			$result=$this->Do_networks->agency_owner_details($agency_id);
			$admin_name    = $result['name'];			
			$admin_email   = $result['email'];		
			
			/* GET ADMIN EMAIL ID FOR bcc */
			$network_admin=$this->Do_networks->get_network_details();
			$bcc		   = $network_admin['email'];

			/* ADVERTISER DETAILS */
			$adv_result_array  =  $this->Do_advertiser->get_user_information($account_id);
			$adv_result		   =  $adv_result_array[0];
			$user_name  	   =  $adv_result['clientname'];
			$user_email		   =  $this->post('email');
			$login_name		   =  $this->post('logusername');
			if($this->post('password')!=''){
			    //IF password changed
				$type   ="ADV_CHANGE_PASSWORD";
			}
			else
			{   
			    $type   ="SETTING_INFORMATION";
			}
			$from 	=  $admin_email;
			$to  	=  $user_email;
			if($this->post('password')=='')
			{
				//Send only email,alternate email to their email
				$mail_content=array(
								"subject" 		=> $this->lang->line('advertiser_account_information'),
								"to_name" 		=> $user_name,				
								"from_name"		=> $admin_name,							
								"email"   		=> $this->post('email'),
								"alternate_email" => $this->post('another_email'),
								"login_name"  	 => $login_name,
								"account_type"	=> "advertiser"		
								);
			 }
			else
			 {
				//Send all account setting informations if password is changed
				$mail_content=array(
						"subject" 		=> $this->lang->line('advertiser_change_password'),
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,	
						"login_name"  	=> $login_name,						
						"email"   		=> $this->post('email'),
						"password"		=> $this->post('password')							
						);			
			 }			
				
			/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
			 $bcc=($bcc!=$admin_email)?$bcc:'';
			    
			 $attachement = "";		
					
			/* CALL HELPHER FILE */
			send_mail($type,$from,$to,$mail_content,$attachement,$bcc);		
			 
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('advertiser/settings/account_settings'),
							'msg'	 => $this->lang->line('account_settings_updated')
			);
		
						
			$this->response($success, 200);
		}
		else
		  { 
		       $success = array(
								'response' => 'error',
								'redirect'=>site_url('advertiser/settings/account_settings'),
								'msg'	 => $this->lang->line('old_password_mismatch')
				);
			  
			    $this->response($success, 200);
		  }
	 }
 }
	
	/*
	 * 
	 * name: upload_profile_image
	 * @param : null
	 * @return:response array
	 * 
	 * Upload the selected image
	 * 
	 */
	
	public function upload_profile_image_post()
	{
		$account_id=$this->post('account_id');
		
		if($_FILES['profile_image'])
		{
			$profile_image=array(
					'file_name'   => $_FILES['profile_image']['name'],
					'source_name' => $_FILES['profile_image']['tmp_name'] 				 				
					);
		}
	
		$data=$this->image_lib->update_profile_image($profile_image);			
		
		$this->Do_advertiser->update_image_information($account_id,$data['upload_data']['file_name']);
		 
		 $success = array(
							'response' => 'ok',
							'msg'	 => $this->lang->line('profile_image_updated')
			);
			
			$this->response($success, 200);
		
	}
	
	/*
	 * 
	 * name: delete_profile_image
	 * @param : null
	 * @return :response array
	 * 
	 * Delete the image in user profile
	 */
	
	public function delete_profile_image_post()
	{
		#$account_id=$this->post('account_id');			
		 $user_auth  	= 	$this->user_authentication;
		 $account_id 	= 	$user_auth->account_id;		
		 $profile_name=$this->Do_advertiser->get_user_information($account_id);
		 $delete_profile_name=$profile_name[0]['dj_profile_image'];
		 
				
		if($delete_profile_name)
		{
			$is_delete_profile=$this->image_lib->delete_profile_image($delete_profile_name);
			
			/* Delete Profile name in Database */			
			$this->Do_advertiser->delete_profile_name($account_id);

			if($is_delete_profile)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => $this->lang->line('profile_image_deleted')
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_profile_image')
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => $this->lang->line('unable_delete_profile_image') 
							);
			$this->response($error, 200);
		}
	}
	
	/*
	 * 
	 * name: email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	
	public function email_check()
	{
		$email		=	$this->post('email_id');
		
		$account_id		=	$this->post('account_id');
		
		$count		=	$this->Do_email_check->dup_email_check($email,$account_id);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('email_check', $this->lang->line('email_address_exists'));
			return FALSE;	
		}
		else
		{
			return true;
		}
	}
	function username_check()
	{
		$username		=	strtolower($this->post('logusername'));
		$count 		    = 	$this->Do_email_check->dup_username_check($username);
		
		if($count>0)
		{
			$this->form_validation->set_message('username_check', $this->lang->line('username_cont_unique_value'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}	
	function acc_username_check()
	{
		$user_auth  	= 	$this->user_authentication;
		$account_id		= 	$user_auth->account_id;
		$username		=	strtolower($this->post('logusername'));
		$count 		    = 	$this->Do_email_check->dup_username_check($username,$account_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('username_check', $this->lang->line('username_cont_unique_value'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}	
	/*
	 * 
	 * name: edit_email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	public function edit_email_check()
	{
		$account_id	=	$this->post('account_id');
		$email		=	$this->post('email_id');
		$count 		= 	$this->Do_email_check->dup_email_check($email,$account_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('edit_email_check', $this->lang->line('email_address_exists'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	
	/*
	 * 
	 * name: account_email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	public function acc_email_check()
	{
		$user_auth  = 	$this->user_authentication;
		$account_id	= 	$user_auth->account_id;
		$email		=	$this->post('email');
		$count 		= 	$this->Do_email_check->dup_email_check($email,$account_id);	
		
	
		if($count>0)
		{
			$this->form_validation->set_message('acc_email_check', $this->lang->line('email_address_exists'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	/**
       * 
       * name : current_balance_post()
       * 
       * block the advertiser information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	public function current_balance_post()
	{	
		$account_id 	= 	$this->post('account_id');	
		
		$account_type 	= 	$this->post('account_type');	
		
		
		$balance 		= 	$this->Do_advertiser->fetch_current_balance($account_id);
		$spend 		  = 	$this->Do_payments->fetch_advertiser_payment1($account_id);
		$totalspend=array(0.0000);
		
		foreach($spend as $sp)
		{
			$sP = 0.0000;
			if($sp['tot_spend'])
			{
				$sP = (float)trim(str_replace(array("$",","),"",$sp['tot_spend']));
			}
			array_push($totalspend,$sP);
		//~ $totalspend += $sP;
		}
					//~ $this->response(array_sum($totalspend),200);

		//currency conversion 4 digits in widgets
		$balance['dj_cur_balance'] = str_replace(array("&#36; ",","),"",$balance['dj_cur_balance']);
		
		$balance['convert']       = currencyformat($balance['dj_cur_balance']);
		
		
			
		$spend 	['tot_spend']    = "$".round(array_sum($totalspend),4);
		
		$spend 	['convert']      = currencyformat(array_sum($totalspend));
		
		
		if($balance)     
		{
			$success 	= 	array('response'	=> 	'ok',
								  'balance'			=> 	$balance,
								  'spend'			=> 	$spend
								  
								);
			
			$this->response( $success, 200);
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	''
								);
			
			$this->response( $error, 200);
		}			
		
		
	}
	
	public function current_balanceview_post()
	{	
		$account_id 	= 	$this->post('account_id');			
		$account_type 	= 	$this->post('account_type');		
		
		$balance 		= 	$this->Do_advertiser->fetch_current_balance($account_id);
		$spend 		  	= 	$this->Do_payments->fetch_advertiser_paymentnew($account_id);
		$totalspend		=	'';
		$tmpArray = [];
		foreach($spend as $sp)
		{
			array_push($tmpArray, $sp['tot_spend']);
		}
		$totalspend = array_sum($tmpArray);

		$balance['convert']      = currencyformat($balance['dj_cur_balance']);	
		
		$spend['tot_spend']    	 = $totalspend;
		if($totalspend!= '' || $totalspend != null){
		
		$spend 	['convert']      = currencyformat($totalspend);
		}
		else{
			$totalspend = 0;
			$spend 	['convert']      = currencyformat($totalspend);
		}
		//~ $this->response( $spend, 200);
		if($balance)     
		{
			$success 	= 	array('response'	=> 	'ok',
								  'balance'			=> 	$balance,
								  'spend'			=> 	$spend
								  
								);
			
			$this->response( $success, 200);
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	''
								);
			
			$this->response( $error, 200);
		}			
		
		
	}

	public function advertiser_geo_get()
	{
		$account_id=$this->get('account_id');
		$advertiser_geo=$this->Do_advertiser->advertiser_geo($account_id);
		
		$this->response($advertiser_geo);
	}
	
	public function advertiser_geo_selected_fetch_get()
	{
		$campaign_id=$this->get('campaign_id');
		$advertiser_geo=$this->Do_advertiser->advertiser_geo_selected_fetch($campaign_id);
		
		$this->response($advertiser_geo);
	}
	
	
	
}
