<?php
class Do_networks extends CI_Model
{
	
	/*// ox_clients
	
	clientid	
	agencyid 
	clientname
	contact
	email
	report
	reportinterval
	reportlastdate
	reportdeactivate
	comments
	updated
	an_adnetwork_id
	as_advertiser_id
	account_id
	advertiser_limitation
	type
	dj_first_name
	dj_last_name
	dj_company_name
	dj_dob
	dj_gender
	dj_profile_image
	dj_address
	dj_country
	dj_state
	dj_city
	dj_mobile_number
	dj_postal_code
	dj_added_date
	dj_approved_date
	dj_approval_status
	dj_is_denied
	dj_is_deleted
	
	//ox_accounts
	
	account_id
	account_type
	account_name
	m2m_password
	m2m_ticket

	//ox_users
	
	user_id
	contact_name
	email_address
	username
	password
	language
	default_account_id
	comments
	active
	sso_user_id
	date_created
	date_last_login
	email_updated

	// ox_accounts

	account_id
	account_type
	account_name
	m2m_password
	m2m_ticket

	//ox_account_user_assoc
	account_id
	user_id
	linked */
	

	function validate_user($email,$password,$acc_type)
	{
		if(!empty($email) && !empty($password))
		{
			$where	=	array(
								'oxu.email_address'	=>	$email,
								'oxu.password'		=>	md5($password),
								'oxa.account_type'	=>	strtoupper($acc_type),
								'dnet.is_deleted'	=>	0,
								'dnm.default_manager'=>1,
								//'duas.is_default'=>1
							);
			$this->db->select('dnet.first_name,
							   dnet.last_name,
							   dnet.username,
							   dnm.default_manager,
							   dnm.agency_id as agencyid,
							   oxa.account_id as account_id,
							   oxa.account_type as account_type,
							   dnet.email_address as email,
							   dua.api_key as api_key,
							   dnet.is_denied as denied'
							   );
			//$this->db->limit(1);
			$this->db->join('djax_network_managers as dnm','dnm.manager_account_id=oxu.default_account_id');
			$this->db->join(TAB_ACCOUNTS.' as oxa','oxa.account_id=dnm.network_account_id');
			$this->db->join(TAB_NETWORKS.'as dnet','dnet.default_user_id=oxu.user_id');
			$this->db->join(TAB_USER_APIKEY.' as dua','dua.user_id=oxu.user_id');
			#$this->db->join('djax_user_role_assoc as duas','duas.user_id=oxu.user_id');
			$this->db->where($where);
			
			$query 	= 	$this->db->get(TAB_USERS.' as oxu');
			#echo $this->db->last_query();exit;
			if($query->num_rows() >0)
			{	
				$result_array 	= 	$query->result_array();

				$this->db->select('account_id as default_advertiser_account_id,clientid as default_advertiser_client_id,');
				$this->db->where('dj_is_default','1');
				$default_advertiser = 	$this->db->get(TAB_CLIENTS);

				$default_advertiser_array = $default_advertiser->result_array();
				//GET network time zone
				$this->db->select('value as time_zone');
				$this->db->where('preference_id','16');
				$time_zone 		= 	$this->db->get(TAB_ACC_PER_ASSOC);
				$time_zone 		= 	$time_zone->result_array();

				$prep_data_tmp	=	array_merge($result_array[0],$default_advertiser_array[0]);
				$prep_data		=	array_merge($prep_data_tmp,$time_zone[0]);
				

				return $prep_data;
			}else{
				return FALSE;	
			}	
		}else{
			return FALSE;	
		}
	}
	
	/**
       * Validates the correct email based on account type
       * 
       * @param string $email Email of the user
       * @param string $acc_type Account type of the particular user
	   * @return boolean Returns TRUE (or) FALSE
    */
    function validate_email($email='',$acc_type='')
    {
		if(!empty($email) && !empty($acc_type))
		{
			switch(strtoupper($acc_type))
			{
				case 'ADVERTISER':
						$this->db->select('clientname as name,email as email,account_id as accountid');
						$query = $this->db->get_where(TAB_CLIENTS,array('email'=>$email),1);
						if($query->num_rows() == 1)
						{
							return $query->row();	
						}else{
							return FALSE;	
						}
						break;
				case 'PUBLISHER':
						$this->db->select('name as name,email as email,account_id as accountid');
						$query = $this->db->get_where(TAB_AFFILIATE,array('email'=>$email),1);
						if($query->num_rows() == 1)
						{
							return $query->row();	
						}else{
							return FALSE;	
						}
						break;
			}
		}else{
			return FALSE;	
		}
	}
	
	function get_profile($account_id)
	{
		$this->db->select('dn.first_name,dn.last_name,dnm.profile_image');
		$this->db->where('dn.account_id',$account_id);
		$this->db->where('dnm.default_manager',1);
		$this->db->from(TAB_NETWORKS.' as dn');
		$this->db->join(TAB_NWK_MANAGERS.' as dnm','dnm.network_account_id=dn.network_id');
		$query = $this->db->get();
		if($query->num_rows() >0)
		{
			$result_array = $query->result_array();
			return $result_array[0];
		}else{
			return FALSE;	
		}	
	}
	
	
	/**
       * Generates the new password and update the new password
       * @param $account_id Account id is Advertiser or Publisher
       * @param $new_pass New Random Password
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	public function update_new_password($account_id,$new_pass)
	{
		$data = array('password'=>md5($new_pass));
		
		$this->db->update(TAB_USERS,$data,array('default_account_id'=>$account_id));
			
		if($this->db->affected_rows()>0)
		{
			return TRUE;	
		}else{
			return FALSE;	
		}
	}
	
	 /* djax_networks
	  *  get all values from this table
	  * 
	  * */
	 
	 function get_user_information($account_id=FALSE)
	 {
	    $this->db->select('dn.*,dnm.profile_image');
	    $this->db->where('du.default_account_id',$account_id);
		$this->db->where('dnm.default_manager',1);
		$this->db->from(TAB_USERS.' as du');
	    $this->db->join(TAB_NETWORKS.' as dn','dn.default_user_id=du.user_id');
		$this->db->join(TAB_NWK_MANAGERS.' as dnm','dnm.network_account_id=dn.network_id');
		$this->db->join(TAB_ACCOUNTS.' as dua','dua.account_id=dn.account_id');
		$query = $this->db->get();		
		$result = $query->result_array();
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		} 
		 
	 }
	 
	 
	  /* djax_networks
	  *  get all values from this table
	  * 
	  * */
	 
	 function get_user_role_info($user_id)
	 {
	    $this->db->select('email_address,contact_name');
		$this->db->where('user_id',$user_id);
		$query = $this->db->get(TAB_USERS);		
		$result = $query->result_array();
		
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		} 
		 
	 }
	 
	 /*   djax_networks
	 * ---------------------
	 * company_name
	 * company_address
	 * company_block_no
	 * company_city
	 * company_state
	 * company_country
	 * first_name
	 * last_name
	 * gender
	 * mobile_number
	 * state
	 * city
	 * country
	 * */
	function update($account_id=FALSE,$obj=FALSE,$acc_setting_type=FALSE,$admin_user_id=FALSE)
	{
	 
		
		$this->db->trans_start();
		/*--------------------------------------------
			UPDATE OX ACCOUNTS TABLE
		-------------------------------------------*/
		if($acc_setting_type!="account")
		{
			if($acc_setting_type == "personal")
			{
				$where_acc	=	array('account_id'	=>	$account_id);
				$acc_data	=	array(
								"account_name"	=>	$obj['first_name'].' '.$obj['last_name']
								);
			}		
			else
			{
				$where_acc	=	array('account_id'	=>	$account_id,'account_type'	=>	$obj['account_type']);
				$acc_data	=	array(
								"account_name"	=>	$obj['first_name'].' '.$obj['last_name']
								);
			}
		
			$this->db->where($where_acc);				
			$this->db->update(TAB_ACCOUNTS,$acc_data);
		}
		
		
		/*-------------------------------------------
			UPDATE OX USERS TABLE
		---------------------------------------------*/
		$where_user = array('default_account_id' => $account_id);
		if ($admin_user_id) {
			$where_user['user_id'] = $admin_user_id;
		}
		if($acc_setting_type == "personal")
		{		
		$oxUserDet = array(
						"contact_name"			=>	$obj['first_name'].' '.$obj['last_name']						
						);	
		}
		else if($acc_setting_type == "account" )
		{
		  if($obj['password']!='')
		  {	
		  $oxUserDet = array (
						"email_address"  =>	$obj['email'],
						"username"      => $obj['email'],
						"password"       => md5($obj['password']),
						"email_updated"  => $obj['email_updated']
						);
		  }
		  else
		  {
			 $oxUserDet = array (
						"email_address"  =>	$obj['email'],
						"username"      => $obj['email'],
						"email_updated"  => $obj['email_updated']
						);  
		  }			
							
		}
		else
		{
		$oxUserDet	=	array(
						"contact_name"			=>	$obj['first_name'].' '.$obj['last_name'],
						"email_address"			=>	$obj['email'],
						"username"				=>	$obj['email']
						);
		}				
		$this->db->where($where_user);							
		$this->db->update(TAB_USERS,$oxUserDet);
	
		/*--------------------------------------------
			UPDATE OX AGENCY TABLE
		-------------------------------------------*/
	
		$where_manager	=	array('account_id'	=>	2);	
		if($acc_setting_type == "account" )
		{
		  $oxManagerDet = array (
						"email"  =>	$obj['email'],
						"updated" 	 => $obj['email_updated']
						);
			$this->db->where($where_manager);							
			$this->db->update(TAB_AGENCY,$oxManagerDet);				
		}

		$this->db->select('user_id');
		$this->db->where($where_user);
		$query_user_id	= $this->db->get(TAB_USERS);
		$value_user_id  = $query_user_id->result();
		foreach($value_user_id as $v) {
			$network_account_id  = $v->user_id;
		}	
		
		/*-------------------------------------------
			UPDATE djax NETWORKS TABLE
		---------------------------------------------*/
		$where_admin	=	array('default_user_id'	=>	1);
		if($acc_setting_type == "personal")
		{
			$networkInfo =  array(						
						"first_name"  		=>	$obj['first_name'],
						"last_name"			=>	$obj['last_name'],
						"gender" 			=>	$obj['gender'],
						"dob"				=>  $obj['dob'],
						"mobile_number" 	=>  $obj['mobile_number'],
						"city" 				=>  $obj['city'],
						"state" 			=>  $obj['state'],
						"country" 			=>  $obj['country'],
						"updated"			=>  $obj['updated']
						);			
		
		}
		else if($acc_setting_type == "account")
		{							
		 if($obj['password']!='')
		  {	  
			  
			  $networkInfo = array (			
								"email_address" 	 =>	$obj['email'],								
								"alternate_email" => $obj['alternate_email'],
								"username"      => $obj['email'],
								//"currency" 		 =>	$obj['currency'],
								"password"       => md5($obj['password']),
								"updated"  => $obj['email_updated']
								
							);	
		
		  }
		  else
		  {
			 $networkInfo = array (
								"email_address"  =>	$obj['email'],
								"alternate_email" => $obj['alternate_email'],
								"username"      => $obj['email'],
								"currency" 		 =>	$obj['currency'],
								"updated"  => $obj['email_updated']
								);  
		  }				
							
									
		}
		else
		{							
			$networkInfo	=	array(
							"email_address"		=>	$obj['email'],							
							"first_name" 		=>  $obj['first_name'],
							"last_name"  		=>  $obj['last_name']
							);
		}			
		
		$this->db->where($where_admin);							
		$this->db->update(TAB_NETWORKS,$networkInfo);			
		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			
			return array("error"=>"Database error". $this->db->_error_message());
		}
		else
		{
			$this->db->trans_commit();
			
			return TRUE;				
		}
	}
	
	/* update_email
	  * 
	  * ox_clients,ox_users
	  * ---------------------
	  * name:@update_email_def_advertiser() 
	    To update email id for default advertisers
	  * param:email
	* */
	public function update_email_def_advertiser($email=FALSE)
	{
	  $this->db->select('account_id');
	  $this->db->where('dj_is_default',1);
	  $query=$this->db->get(TAB_CLIENTS);
	  $result=$query->result_array();
	  if($result)
	  {
        $account_id=$result[0]['account_id'];
		/** UPDATE INTO OX_CLIENTS**/
		$data=array('email'=>$email);
		$this->db->where('account_id',$account_id);							
		$this->db->update(TAB_CLIENTS,$data);  
		/** UPDATE INTO OX_USERS**/
		$data=array(
		            'email_address'=>$email,
					'username'=>$email
					); 
		$this->db->where('default_account_id',$account_id);							
		$this->db->update(TAB_USERS,$data);  
	  }
	  else
	  {
	    return FALSE;
	  }
	}
	/* update company Information
	  * 
	  *   ox_affiliates
	  * ---------------------
	  * dj_company_name
	  * dj_company_address
	  * dj_company_blockno
	  * dj_company_city
	  * dj_company_state
	  * dj_company_country
	  * 
	  * */
	 
	 function update_companyinfo($user_id=FALSE,$company_obj=FALSE)
	 {
		
		$this->db->trans_start();		
		
		/*-------------------------------------------
			UPDATE djax Networks TABLE
		---------------------------------------------*/
		
		$where_cli	=	array('default_user_id'	=>$user_id);		
		$update_companyInfo=array(							
										"company_name"  	=>$company_obj['company_name'],
										"company_address"	=>$company_obj['company_address'],
										"company_block_no" 	=>$company_obj['company_block_no'],
										"company_city"		=>$company_obj['company_city'],
										"company_state" 	=>$company_obj['company_state'],
										"company_country"	=>$company_obj['company_country'],
										"updated"			=>date("Y-m-d H:i:s")
								);	
										
		$this->db->where($where_cli);	
								
		$this->db->update(TAB_NETWORKS,$update_companyInfo);	
		
		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			
			return array("error"=>"Database error". $this->db->_error_message());
		}
		else
		{
			$this->db->trans_commit();
			
			return TRUE;				
		}
	}
	
	
	
		 
	 /* djax_networks  - Update profile image
	  * profile_image 
	  * 
	  * */	 
	 
	 function update_image_information($account_id=FALSE,$data=FALSE)
	 {	
		 
		 /* Old image unlink  - Start */ 
		 if($account_id != FALSE){
			$this->db->where('manager_account_id',$account_id);
			}
		 $old_image= $this->db->get(TAB_NWK_MANAGERS);			 
		 $image_result = $old_image->result_array();
		 if($image_result!=FALSE){
		 $old_profile_name=$image_result[0]['profile_image'];
		 if($data!=''){		 
		 $this->image_lib->delete_profile_image($old_profile_name);
		 }
		} 		 
		 /* Old image unlink  - End */

		/*-------------------------------------------
			UPDATE DJAX NETWORKS TABLE  - Profile Image
		---------------------------------------------*/
		
		$this->db->trans_start();	
		$image_name=array("profile_image"=>$data);
		$agen_img = array("dj_profile_image"=>$data);
		$this->db->where('manager_account_id',$account_id);
		$this->db->update(TAB_NWK_MANAGERS,$image_name);
		$this->db->update(TAB_AGENCY,$agen_img);
		$this->db->update(TAB_NETWORKS,$image_name);
		$this->db->trans_complete();
		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			
			return array("error"=>"Database error". $this->db->_error_message());
		}
		else
		{
			$this->db->trans_commit();
		
			$query = $this->db->get(TAB_NETWORKS);
		
			$result = $query->result_array();
			
			if($result)
			{			
				return $result;
			}
			else
			{
				return FALSE;
			}  
		}	
	 }
	 
		 
	 /* djax_networks
	  * Delete profile name for Admin
	  * 
	  * */	 
	 
	 function delete_profile_name($account_id=FALSE)
	 {
		if($account_id != FALSE){
			$this->db->where('account_id',$account_id);
		} 		
		$data=array("profile_image"=>'');
		$agen_img = array("dj_profile_image"=>'');
		$this->db->update(TAB_NETWORKS,$data);
		$this->db->update(TAB_NWK_MANAGERS,$data);
		$this->db->update(TAB_AGENCY,$agen_img);
		$query = $this->db->get(TAB_NETWORKS);
		$result = $query->result_array();
			
		if($result)
		{			
			return $result;
		}
		else
		{
			return FALSE;
		} 
	}
	
        
	/*
	 * 
	 * name: add_payment_info
	 * @param : array(bankname,a/c no,bank address);
	 * @return :Last insert id
	 * 
	 */
	 public function add_payment_info($payment_details=FALSE,$account_id=FALSE){
	  
	   if($payment_details['payment_type']=='wire_information')
	   {
	     $payment_type=1;
		 $wire_status =1;
	   }
	   elseif($payment_details['payment_type']=='paypal_id')
	   {
	      $payment_type=2;
		  $wire_status =0;
	   }
	   else
	   {
	      $payment_type=3;
		  $wire_status =0;
	   }
	   
	   $this->db->select('*');
	   #$this->db->where('account_id',$payment_details['account_id']);
	   $this->db->where('account_id',$account_id);
	   $this->db->where('payment_type',1);
	   $query=$this->db->get(TAB_PUB_PAYD);
	   if($query->num_rows()<=0) 
	   {
		   $payment_info=array(
				   //'account_id'=>$payment_details['account_id'],
				   'account_id'=>$account_id,
				   'bank_name'=> $payment_details['billing_wire_bank_name'],      
				   'bank_account_no'=> $payment_details['billing_wire_acc_no'],
				   'bank_address'=> $payment_details['billing_wire_bank_address'],
				   //'currency_code'=> $payment_details['billing_wire_currency'],
				   'swift_bic'=> $payment_details['billing_wire_swift_bic'],
				   'created_date'=> date("Y-m-d H:i:s"),
				   'wire_status'=>$wire_status,
				   'account_holder_name' =>$payment_details['account_holder_name'],
				   'payment_type'=> $payment_type
				);
		   $id=$this->db->insert(TAB_PUB_PAYD,$payment_info);
		   if($id){
		    $res="inserted";
		    return $res;
		   }
	   }
	   else
	   {
	      $payment_info=array(
			   'bank_name'=> $payment_details['billing_wire_bank_name'],      
	           'bank_account_no'=> $payment_details['billing_wire_acc_no'],
			   'bank_address'=> $payment_details['billing_wire_bank_address'],
			   //'currency_code'=> $payment_details['billing_wire_currency'],
			   'swift_bic'=> $payment_details['billing_wire_swift_bic'],
			   'modified_date'=> date("Y-m-d H:i:s"),
			   'wire_status'=>$wire_status,
			   'account_holder_name' =>$payment_details['account_holder_name'],
			);
			
			//$where_acc	=	array('account_id'	=>	$payment_details['account_id'],'payment_type'=>1);
			$where_acc	=	array('account_id'	=>	$account_id,'payment_type'=>1);
			
			$this->db->where($where_acc);							
			
			$this->db->update(TAB_PUB_PAYD,$payment_info);	
			
			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				
				return array("error"=>"Database error". $this->db->_error_message());
			}
			else
			{
				$this->db->trans_commit();
				$res="updated";
		        return $res;
			}
	    }
	}
     
	
	/*
	 * 
	 * name: admin_add_payment_info
	 * @param : array(bankname,a/c no,bank address);
	 * @return :Last insert id
	 * 
	 */
	 public function admin_add_payment_info($payment_details=FALSE,$account_id=FALSE)
	 {
	   $this->db->select('*');
	   $this->db->where('account_id',$account_id); 
	    $this->db->where('payment_type', 1);
	   $query=$this->db->get(TAB_ADMIN_PAYD);
	
	   if($query->num_rows()<=0) 
	   {
		   $payment_info=array(
				   'account_id'=>$account_id,
				   'bank_name'=> $payment_details['billing_wire_bank_name'],      
				   'bank_acc_no'=> $payment_details['billing_wire_acc_no'],
				   'bank_address'=> $payment_details['billing_wire_bank_address'],
				   'currency_code'=> $payment_details['billing_wire_currency'],
				   'swift_bic'=> $payment_details['billing_wire_swift_bic'],
				   'added_date'=> date("Y-m-d H:i:s"),
				   'account_holder_name' =>$payment_details['account_holder_name'],
				   'payment_type'=> 1
				);
		   $id=$this->db->insert(TAB_ADMIN_PAYD,$payment_info);
		   if($id){
		    $res="inserted";
		    return $res;
		   }
	   }
	   else
	   {
	      $payment_info=array(
			   'bank_name'=> $payment_details['billing_wire_bank_name'],      
	           'bank_acc_no'=> $payment_details['billing_wire_acc_no'],
			   'bank_address'=> $payment_details['billing_wire_bank_address'],
			   'currency_code'=> $payment_details['billing_wire_currency'],
			   'swift_bic'=> $payment_details['billing_wire_swift_bic'],
			   'modified_date'=> date("Y-m-d H:i:s"),
			   'account_holder_name' =>$payment_details['account_holder_name'],
		    );
			
			$where_acc	=	array('account_id'	=>	$account_id,'payment_type'=>1);
			
			$this->db->where($where_acc);							
			
			$this->db->update(TAB_ADMIN_PAYD,$payment_info);	
			
			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				
				return array("error"=>"Database error". $this->db->_error_message());
			}
			else
			{
				$this->db->trans_commit();
				$res="updated";
		        return $res;
			}
	    }
	}
	
	/*
	* 
	* name: get_payment_info
	* @param : account_id;
	* @return :details payment info of user
	* 
	*/
	public function get_payment_info($account_id=FALSE)
	{    
	    if($account_id != FALSE){
		 $this->db->select('*');
		 $this->db->where('account_id',$account_id);
		 $this->db->where('payment_type',1);
		 $query = $this->db->get(TAB_PUB_PAYD);
		 $result = $query->result_array();
	     if($result)
		 {			
			return $result;
		 }
		else
		 {
			return FALSE;
		 }
		}
	}
	
    /*FOR ADMIN
	* 
	* name: get_payment_info
	* @param : account_id;
	* @return :details payment info of user
	* 
	*/
	public function get_admin_payment_info($account_id=FALSE)
	{    
	    if($account_id != FALSE){
		 $this->db->select('*');
		 $this->db->where('account_id',$account_id);
		 $this->db->where('payment_type',1);
		 $query = $this->db->get(TAB_ADMIN_PAYD);
		 $result = $query->result_array();
	     if($result)
		 {			
			return $result;
		 }
		else
		 {
			return FALSE;
		 }
		}
	}
	
		/*
	* 
	* name: get_paypal_info
	* @param : account_id;
	* @return :details paypal id of user
	* 
	*/
	public function get_paypal_info($account_id=FALSE)
	{    
	     $where=array(
		               'account_id'=>$account_id,
		               'payment_type'=>2
		             );
		 $this->db->select('*');
		 $this->db->where($where);
		 $query = $this->db->get(TAB_PUB_PAYD);
		 $result = $query->result_array();
	     if($result)
		 {			
			return $result;
		 }
		else
		 {
			return FALSE;
		 }
	}
	
	/*
	* 
	* name: get_admin_paypal_info
	* @param : account_id;
	* @return :details paypal id of user
	* 
	*/
	public function get_admin_paypal_info($account_id=FALSE)
	{    
	     $where=array(
		               'account_id'=>$account_id,
		               'payment_type'=>2
		             );
		 $this->db->select('*');
		 $this->db->where($where);
		 $query = $this->db->get(TAB_ADMIN_PAYD);
		 $result = $query->result_array();
	     if($result)
		 {			
			return $result;
		 }
		else
		 {
			return FALSE;
		 }
	}
	
   /*
	* 
	* name: add_paypal_info
	* @param : paypalemail id;
	* @return :insertid
	* 
	*/
    public function add_paypal_info($paypal_info=FALSE)
	{
	   $account_id =$paypal_info['pk'];
	   $this->db->select('*');
	   $this->db->where('account_id',$account_id);
	   $this->db->where('payment_type',2);
	   $query=$this->db->get(TAB_PUB_PAYD);
	   if($query->num_rows()<=0) 
	   {
		   $payment_info=array(
				   'account_id'=>$account_id,
				   'created_date'=> date("Y-m-d H:i:s"),
				   'wire_status'=>0,
				   'account_holder_name' =>$pub_name,
				   'payment_type'=> '2',
				   'paypal_id'=>$paypal_info['value']
				);
		   $id=$this->db->insert(TAB_PUB_PAYD,$payment_info);
		   if($id){
		    $res="inserted";
		    return $res;
		   }
	   }
	   else
	   {
	      $payment_info=array(
		           'account_id'=>$account_id,
				   'modified_date'=> date("Y-m-d H:i:s"),
				   #'account_holder_name' =>$pub_name,
				   'wire_status'=>0,
				   'paypal_id'=>$paypal_info['value']
				);
			
			$where_acc	=	array('account_id'=>$account_id,'payment_type'=>2);
			
			$this->db->where($where_acc);							
			
			$this->db->update(TAB_PUB_PAYD,$payment_info);	
			
			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				
				return array("error"=>"Database error". $this->db->_error_message());
			}
			else
			{
				$this->db->trans_commit();
				$res="updated";
		        return $res;
			}
	    }

	
	}

	/*
	* 
	* name: admin_add_paypal_info
	* @param : paypalemail id;
	* @return :insertid
	* 
	*/
    public function admin_add_paypal_info($paypal_info=FALSE,$account_id=FALSE)
	{
	   $this->db->select('*');
	   $this->db->where('account_id',$account_id);
	    $this->db->where('payment_type',2);
	   $query=$this->db->get(TAB_ADMIN_PAYD);
	   if($query->num_rows()<=0) 
	   {
		   $payment_info=array(
				   'account_id'=>$account_id,
				   'added_date'=> date("Y-m-d H:i:s"),
				   //'wire_status'=>0,
				   //'account_holder_name' =>$payment_details['user_name'],
				   'payment_type'=> '2',
				   'paypal_id'=>$paypal_info['value']
				);
		   $id=$this->db->insert(TAB_ADMIN_PAYD,$payment_info);
		   if($id){
		    $res="inserted";
		    return $res;
		   }
	   }
	   else
	   {
	      $payment_info=array(
				   'modified_date'=> date("Y-m-d H:i:s"),
				   'paypal_id'=>$paypal_info['value']
				);
			
			$where_acc	=	array('account_id'=>$account_id,'payment_type'=> '2');
			
			$this->db->where($where_acc);							
			
			$this->db->update(TAB_ADMIN_PAYD,$payment_info);	

			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				
				return array("error"=>"Database error". $this->db->_error_message());
			}
			else
			{
				$this->db->trans_commit();
				$res="updated";
		        return $res;
			}
	    }

	
	}
	

/* get network details
	  * 
	  *   djax_app_configurations AND djax_networks
	  * ---------------------
	  *  	new_user_approval_type 	
	  * 	email_address 
	  * 
	  * */
	  
	  function get_network_details()
	  {
		  	  
		$query="Select app.config_value as approval_type,
							djn.first_name  as firstname,
							djn.last_name as lastname,
							djn.email_address as email,
							djn.date_added as app_date from ".TAB_APP_CONFIG."  as app
							JOIN ".TAB_NETWORKS." as djn ON  djn.account_id = 1 
							Where djn.is_super_admin=	1 AND app.config_key='new_user_approval_type'";	    	  
	/*	$where	=	array(
							'djn.is_super_admin'=>	1	,
							'app.config_key'=>	'new_user_approval_type',							
							);		
		$this->db->select( 'app.config_value as approval_type,				
							djn.first_name  as firstname,
							djn.last_name as lastname,
							djn.email_address as email,
							djn.date_added as app_date'							
							);
		$this->db->from(TAB_APP_CONFIG.' as app');
		$this->db->join(TAB_NETWORKS.' as djn','djn.account_id = 1');		
		$this->db->where($where);*/
		$query = $this->db->query($query);
		$query = $this->db->get();
		if($query->num_rows() >0)
		{
			$result = 	$query->result_array();
			return $result[0];
		}else{
			return FALSE;	
		}	
		
	  }
	  
	  function country($country_id=FALSE)
	  {
		 $this->db->select('*');
		 $this->db->where('id',$country_id);
		 $query = $this->db->get(TAB_TARG_COUNTRY);
		 $result = $query->result_array();
	     if($result)
		 {			
			return $result[0];
		 }
		else
		 {
			return FALSE;
		 }  
	  }
	  
	 
	/*
	* 
	* name: update_payment_mode
	* @param : account_id,payment_mode values
	* @return :insertid
	* 
	*/
	  public function update_payment_mode($pay_mode=FALSE, $account_id=FALSE)
	  {
	      $data=array('is_default'=>0);
		  $this->db->where('account_id',$account_id);
          $this->db->update(TAB_PUB_PAYD,$data); 
		  if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
			    return array("error"=>"Database error". $this->db->_error_message());
			}
			else
			{
				 $where=array(
				             'account_id'=>$account_id,
							 'payment_type'=>$pay_mode['payment_mode']
				             );
			      $data=array(
				              'is_default'=>1
							  );
				$this->db->where($where);
				$this->db->update(TAB_PUB_PAYD,$data);
				return TRUE; 			  
		   }
	  }
	
	/*
	* 
	* name: get_network_admin_account_details
	* @param : 
	* @return :admin account details
	* 
	*/
	
	public function get_network_admin_account_details()
	{
	  $this->db->select('*');
	  $this->db->where('payment_type',1);
	  $query = $this->db->get(TAB_ADMIN_PAYD);
	  $result=$query->row_array();
	  if($query->num_rows() >0)
		{
			$result = 	$query->result_array();
			return $result;
		}
	   else
		{
			return FALSE;	
		}
	}
	
	 /* ox_affiliates
	  * Fetch the total earning by the publisher
	  * 
	  * */	
	
	function admin_earning($account_id,$account_type)
	{
		$agency_id 		= FALSE;
		
		switch(strtoupper($account_type)){
			case 'ADMIN';
				$agency_id	= $this->Do_notification->getAdminAgencyId($account_id);
				break;
			case 'MANAGER';
				$agency_id	= $this->Do_notification->getManagerAgencyId($account_id);
				break;
		}


		$SQL = "SELECT IFNULL(ROUND(SUM(oxds.dj_total_revenue) - SUM(oxds.dj_publisher_earnings),4),0) as tot_revenue 
				FROM ".TAB_DATA_SUM_AD_HOURLY." as oxds
				JOIN ".TAB_ZONES." as oxz ON oxz.zoneid=oxds.zone_id
				JOIN ".TAB_AFFILIATE." as oxa ON (oxa.affiliateid=oxz.affiliateid AND oxa.agencyid={$agency_id})
				";  

		$query = $this->db->query($SQL);
		
		$result = $query->result_array();		
		
		if($result)
		{			
				return $result[0];
		}
		else
		{
			return FALSE;
		}
		
	}
	
	public function update_user_role($user_id,$data)
	{
	    $this->db->trans_start();
	    $account_id=$data['acc_id'];
		if($data['password']!=''){
		$data=array( 'username'=>$data['email'],
					 'email_address'=>$data['email'], 
		             'password'=>md5($data['password'])
		           );
		}
		else{
		$data=array( 'username'=>$data['email'],
					 'email_address'=>$data['email']
		           );
		}
		$where=array('user_id'=>$user_id);
	    $this->db->update(TAB_USERS,$data,$where);
		//CHECKING ONLY FOR DEFAULT-MANAGER TO UPDATE EMAIL IN OX_AGENCY TABLE
		$query=$this->db->get_where(TAB_USER_ROLE_ASSOC,array('user_id'=>$user_id,'is_default'=>1));
		if($query->num_rows() > 0)
		{ 
		  $where=array('account_id'=>$account_id);
		  $data=array('email'=>$data['email_address']);
		  $this->db->update(TAB_AGENCY,$data,$where);
		}
		$this->db->trans_complete();
		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			
			return array("error"=>"Database error". $this->db->_error_message());
		}
		else
		{
			$this->db->trans_commit();
			
			return TRUE;				
		}
	}
	
	public function get_agency()
	{
	  $this->db->select('agency_id');
	  $this->db->where('default_manager',1);
	  $query=$this->db->get(TAB_NWK_MANAGERS);
	  $result=$query->result_array();
	  if($result){
	    return $result;
	  }
	}
	
	// Mobile Screen Resolutions
	public function get_screen_sizes()
	{
		$this->db->select('*');
		$query = $this->db->get(TAB_CONF_MOBILE_SCREEN_SIZE);
		$result=$query->result_array();
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	
	// Edit Mobile Data
	public function get_screen_data($screen_id)
	{
		$this->db->select('*');
		$this->db->where('id',$screen_id);
		$query = $this->db->get(TAB_CONF_MOBILE_SCREEN_SIZE);
		//echo $this->db->last_query();exit;
		$result=$query->result_array();
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		}
	}
	
	// Block screen size
	public function block_screen_data($screen_id=FALSE)
	{
		if($screen_id)
	    {  
		     $data=array('status'=>1);
		     $this->db->where('id', $screen_id);
			 $this->db->update(TAB_CONF_MOBILE_SCREEN_SIZE,$data);
			// echo $this->db->last_query();exit;
			return $screen_id;
		}
	}
	
	// Block screen size
	public function unblock_screen_data($screen_id=FALSE)
	{
		if($screen_id)
	    {  
		     $data=array('status'=>0);
		     $this->db->where('id', $screen_id);
			 $this->db->update(TAB_CONF_MOBILE_SCREEN_SIZE,$data);
			// echo $this->db->last_query();exit;
			return $screen_id;
		}
	}
	
	// Update screen size data
	public function update_mobile_screens($update_data=FALSE,$screen_id=FALSE)
	{
		$this->db->where('id',$screen_id);
		$this->db->update(TAB_CONF_MOBILE_SCREEN_SIZE,$update_data);
		//echo $this->db->last_query();exit;
		return $screen_id;
	} 
	
	// Duplicate record check
	public function dup_resolution_check($id=FALSE,$width=FALSE,$height=FALSE)
	{
		$this->db->select('*');	
		$this->db->where("width",$width);
		$this->db->where("height",$height);
		$this->db->where_not_in('id',$id);
		$query_count	=	$this->db->get(TAB_CONF_MOBILE_SCREEN_SIZE)->num_rows();			
		if($query_count)
		{			
		     return $query_count;
		}
	}
	
	// Duplicate screen value check
	public function dup_screen_value($scr_val)
	{
		$this->db->select('*');	
		$this->db->where("value",$scr_val);
		$query_count	=	$this->db->get(TAB_CONF_MOBILE_SCREEN_SIZE)->num_rows();			
		if($query_count)
		{			
		     return $query_count;
		}
		
	}
	
	// Duplicate width & height check
	public function dup_resolution_screen_check($width=FALSE,$height=FALSE)
	{
		$this->db->select('*');	
		$this->db->where("width",$width);
		$this->db->where("height",$height);
		$query_count	=	$this->db->get(TAB_CONF_MOBILE_SCREEN_SIZE)->num_rows();			
		if($query_count)
		{			
		     return $query_count;
		}
	}
	
	// Insert new screen data
	public function insert_new_screen($ins_data)
	{
		$this->db->insert(TAB_CONF_MOBILE_SCREEN_SIZE,$ins_data);
		return $this->db->insert_id();
	}
	
   
	public function get_manager_email($account_id,$account_type=FALSE)
    {
	  if($account_type!=FALSE)
	  { 
	    if($account_type=='ADVERTISER')
	    {	
		 $this->db->select('da.email,da.name as firstname');
		 $this->db->where('dc.account_id',$account_id);
		 $this->db->from(TAB_CLIENTS.' as dc');
		 $this->db->join(TAB_AGENCY.' as da','dc.agencyid=da.agencyid');
		 $query=$this->db->get();
		 $result=$query->result_array();
		 if($result)
		 {
		   return $result[0];
		 }
	    }
	    else
	    {	
		 $this->db->select('da.email,da.name as firstname');
		 $this->db->where('dc.account_id',$account_id);
		 $this->db->from(TAB_AFFILIATE.' as dc');
		 $this->db->join(TAB_AGENCY.' as da','dc.agencyid=da.agencyid');
		 $query=$this->db->get();
		 $result=$query->result_array();
		 if($result){
		   return $result[0];
		  }
	    }
	  }
	  else
	  {
	         
	  }
	}
	
	/* get manager detail in ox_agency */ 
	public function agency_owner_details($agency_id)
	{
		$this->db->select("*");
		$this->db->where('agencyid',$agency_id);
		$query = $this->db->get(TAB_AGENCY);
		$result=$query->result_array();
		if($result)
		{
		   return $result[0];
		}
		else
		{
			return FALSE;
		}
	}
	
	/* get manager role in djax_user_role_assoc */
	public function get_manager_role($user_id=FALSE)
	{
		$this->db->select('is_default');
		$this->db->where('user_id',$user_id);
		$query = $this->db->get(TAB_USER_ROLE_ASSOC);
		$result=$query->result_array();
		if($result)
		{
			return $result[0]['is_default'];
		}
		else
		{
			return FALSE;
		}
	}
	
	/* get manager role in ox_users */
	public function get_network_users_detail($user_id=FALSE)
	{
		$this->db->select('*');
		$this->db->where('user_id',$user_id);
		$query = $this->db->get(TAB_USERS);
		$result = $query->result_array();
		if($result)
		{
			return $result[0];
		}
		else
		{
			return FALSE;
		} 
	}
	
	/* GET MAIN MANAGER EMAIL BY USER_ID */
	public function get_manager_emailID($user_id=FALSE)
	{
		$this->db->select('email');
		$this->db->from(TAB_AGENCY.' as oxa');
		$this->db->where('oxu.user_id', $user_id);
		$this->db->join(TAB_USERS.' as oxu','oxu.default_account_id=oxa.account_id');
		$query = $this->db->get();
		$result = $query->result_array();
		if($result)
		{
			return $result[0]['email'];
		}
		else
		{
			return FALSE;
		} 
	}
	
	/* GET MANAGERS LIST TO SEND MAIL */
	public function get_managers_list($account_id=FALSE)
	{
	
		$SQL = "SELECT email,name from (SELECT oxc.email as email,oxc.contact as name From ox_agency as oxa
				JOIN ox_clients oxc ON oxc.agencyid=oxa.agencyid
				WHERE oxa.account_id=$account_id
				UNION
				SELECT oxf.email as email,oxf.contact as name From ox_agency as oxa
				JOIN ox_affiliates oxf ON oxf.agencyid=oxa.agencyid
				WHERE oxa.account_id=$account_id
				UNION
				SELECT oxa.email_address as email,oxa.contact_name as name From ox_users as oxa
				JOIN djax_user_role_assoc as dura ON dura.user_id=oxa.user_id
				WHERE oxa.default_account_id=$account_id AND dura.user_status=1
				) as final";
				
		$result=$this->db->query($SQL);
		$data=$result->result_array();
		if($data)
		{
			return $data;
		}
		else
		{
		  return FALSE;
		} 
	}
	
	/* GET MANAGERS BY ROLE ID */
	public function get_managers_by_role_id($role_id=FALSE)
	{
		$this->db->select('oxu.user_id as u_id,oxu.contact_name as name,oxu.email_address as email');
		$this->db->where('uas.role_id',$role_id);
		$this->db->from(TAB_USER_ROLE_ASSOC.' as uas');
		$this->db->join(TAB_USERS.' as oxu','oxu.user_id=uas.user_id');
		$query = $this->db->get();
		$result = $query->result_array();
		if($result)
		{
			return $result;
		}
		else
		{
			return FALSE;
		} 
	}		
	
	/* GET is_default=1 MANAGER EMAIL BY USER ID */
	public function manager_email_for_BCC($user_id)
	{
		$this->db->select('oxa.email as email');
		$this->db->where('oxu.user_id',$user_id);
		$this->db->from(TAB_AGENCY.' as oxa');
		$this->db->join(TAB_USERS.' as oxu','oxu.default_account_id=oxa.account_id');
		$query = $this->db->get();
		$result = $query->result_array();
		if($result)
		{
			return $result[0]['email'];
		}
		else
		{
			return FALSE;
		}
	}
	
	/*INSERT login details*/
    public function update_login_details($login_info)
	{
	   if($login_info){
	  	 $this->db->insert(TAB_LOGIN_INFO,$login_info);
	   }
	} 
	
	/*UPDATE logout details*/
    public function update_logout_details($data)
	{
	   if($data){
	  	 $this->db->where("DATE(login_time)",date("Y-m-d"));
		 $this->db->where('logout_time',"0000-00-00 00:00:00");
		 $this->db->where('account_id',$data['account_id']);
		 $update=array('logout_time'=>$data['logout_time']);
		 $this->db->update(TAB_LOGIN_INFO,$update);
		if($this->db->affected_rows()>0)
		{																									
	        $sql="SELECT TIMEDIFF(logout_time,login_time) as 'interval',f_name,l_name,email_id FROM djax_login_info 
			      WHERE account_id = '".$data['account_id']."' AND DATE( login_time ) = '".date("Y-m-d")."' ORDER BY login_id DESC LIMIT 1";
			$res = $this->db->query($sql);
			$result=$res->result_array();
			if($result){
			return $result[0];
			}
			else{
			 return 'Mis-match record';
			}
		}else{
			return FALSE;	
		}
	  }
	}

	/* Update Sub Admin Payment Mode */


	/*
     * 
     * name: update_admin_payment_mode
     * @param : account_id,payment_mode values
     * @return :insertid
     * 13-08-2015
     */
	public function update_admin_payment_mode($pay_mode = FALSE, $account_id = FALSE)
	{
		$data = array(
			'status' => 0
		);
		$this->db->where('account_id', $account_id);
		$this->db->update(TAB_ADMIN_PAYD, $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return array(
				"error" => $this->db->_error_number() . ' : ' . $this->db->_error_message();
			);
		} else {
			$where = array(
				'account_id' => $account_id,
				'payment_type' => $pay_mode['payment_mode']
			);
			$data = array(
				'status' => 1
			);
			$this->db->where($where);
			$this->db->update(TAB_ADMIN_PAYD, $data);
			return TRUE;
		}
	}

	/*
     *
     * name: admin_add_payment_info
     * @param : array(bankname,a/c no,bank address);
     * @return :Last insert id
     *
     */
	public function admin_add_gt_payment_info($payment_details = FALSE, $account_id = FALSE)
	{
		//return $payment_details;
		$this->db->select('*');
		$this->db->where('account_id', $account_id);
		$this->db->where('payment_type', 4);
		$query = $this->db->get(TAB_ADMIN_PAYD);

		if ($query->num_rows() <= 0) {
			$payment_info = array(
				'account_id' => $account_id,
				'gt_payment_id' => $payment_details['gt_account_id'],
				'gt_payment_api_key' => $payment_details['gt_api_key'],
				'added_date' => date("Y-m-d H:i:s"),
				'payment_type' => 4
			);
			$id = $this->db->insert(TAB_ADMIN_PAYD, $payment_info);
			if ($id) {
				$res = "inserted";
				return $res;
			}
		} else {
			$payment_info = array(
				'account_id' => $account_id,
				'gt_payment_id' => $payment_details['gt_account_id'],
				'gt_payment_api_key' => $payment_details['gt_api_key'],
				'modified_date' => date("Y-m-d H:i:s")

			);

			$where_acc = array('account_id' => $account_id, 'payment_type' => 4);

			$this->db->where($where_acc);

			$this->db->update(TAB_ADMIN_PAYD, $payment_info);
			
			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();

				return array("error" => "Database error" . $this->db->_error_message());
			} else {
				$this->db->trans_commit();
				$res = "updated";
				return $res;
			}
		}
	}


	/*FOR ADMIN
    *
    * name: get_gt_payment_info
    * @param : account_id;
    * @return :details payment info of user
    *
    */
	public function get_admin_gt_payment_info($account_id = FALSE)
	{

		if ($account_id != FALSE) {
			$this->db->select('gt_payment_id,gt_payment_api_key');
			$this->db->where('account_id', $account_id);
			$this->db->where('payment_type', 4);
			$query = $this->db->get(TAB_ADMIN_PAYD);
			$result = $query->result_array();
			if ($result) {
				return $result;
			} else {
				return FALSE;
			}
		}
	}

	/*FOR Publisher
  *
  * name: get_gt_payment_info
  * @param : account_id;
  * @return :details payment info of user
  *
  */
	public function add_gt_payment_info($payment_details = FALSE, $account_id)
	{

		// $account_id = $paypal_info['pk'];
		$this->db->select('*');
		$this->db->where('account_id', $account_id);
		$this->db->where('payment_type', 4);
		$query = $this->db->get(TAB_PUB_PAYD);
		if ($query->num_rows() <= 0) {
			$payment_info = array(
				'account_id' => $account_id,
				'created_date' => date("Y-m-d H:i:s"),
				'wire_status' => 0,
				'pub_gt_payment_id' => $payment_details['gt_account_id'],
				'payment_type' => '4',
				'pub_gt_payment_api_key' => $payment_details['gt_api_key']
			);
			$id = $this->db->insert(TAB_PUB_PAYD, $payment_info);
			if ($id) {
				$res = "inserted";
				return $res;
			}
		} else {
			$payment_info = array(
				'account_id' => $account_id,
				'modified_date' => date("Y-m-d H:i:s"),
				#'account_holder_name' =>$pub_name,
				'wire_status' => 0,
				'pub_gt_payment_id' => $payment_details['gt_account_id'],
				'pub_gt_payment_api_key' => $payment_details['gt_api_key']
			);

			$where_acc = array(
				'account_id' => $account_id,
				'payment_type' => 4
			);

			$this->db->where($where_acc);

			$this->db->update(TAB_PUB_PAYD, $payment_info);

			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();

				return array(
					"error" => $this->db->_error_number() . ' : ' . $this->db->_error_message()
				);
			} else {
				$this->db->trans_commit();
				$res = "updated";
				return $res;
			}
		}


	}

	//14-08-2015

	public function get_pub_gt_payment_info($account_id = FALSE)
	{

		if ($account_id != FALSE) {
			$this->db->select('pub_gt_payment_id,pub_gt_payment_api_key');
			$this->db->where('account_id', $account_id);
			$this->db->where('payment_type', 4);
			$query = $this->db->get(TAB_PUB_PAYD);
			$result = $query->result_array();
			if ($result) {
				return $result;
			} else {
				return FALSE;
			}
		}
	}
	
	
	
	
}
?>
